--
-- PostgreSQL database dump
--

SET statement_timeout = 0;
SET client_encoding = 'UTF8';
SET standard_conforming_strings = on;
SET check_function_bodies = false;
SET client_min_messages = warning;

--
-- Name: basic; Type: SCHEMA; Schema: -; Owner: radiosan_ustaana
--

CREATE SCHEMA basic;


ALTER SCHEMA basic OWNER TO radiosan_ustaana;

--
-- Name: boletaje; Type: SCHEMA; Schema: -; Owner: radiosan_ustaana
--

CREATE SCHEMA boletaje;


ALTER SCHEMA boletaje OWNER TO radiosan_ustaana;

--
-- Name: catalogo; Type: SCHEMA; Schema: -; Owner: radiosan_ustaana
--

CREATE SCHEMA catalogo;


ALTER SCHEMA catalogo OWNER TO radiosan_ustaana;

--
-- Name: cms; Type: SCHEMA; Schema: -; Owner: radiosan_ustaana
--

CREATE SCHEMA cms;


ALTER SCHEMA cms OWNER TO radiosan_ustaana;

--
-- Name: contabilidad; Type: SCHEMA; Schema: -; Owner: radiosan_ustaana
--

CREATE SCHEMA contabilidad;


ALTER SCHEMA contabilidad OWNER TO radiosan_ustaana;

--
-- Name: docs; Type: SCHEMA; Schema: -; Owner: radiosan_ustaana
--

CREATE SCHEMA docs;


ALTER SCHEMA docs OWNER TO radiosan_ustaana;

--
-- Name: forms; Type: SCHEMA; Schema: -; Owner: radiosan_ustaana
--

CREATE SCHEMA forms;


ALTER SCHEMA forms OWNER TO radiosan_ustaana;

--
-- Name: images; Type: SCHEMA; Schema: -; Owner: radiosan_ustaana
--

CREATE SCHEMA images;


ALTER SCHEMA images OWNER TO radiosan_ustaana;

--
-- Name: inventarios; Type: SCHEMA; Schema: -; Owner: radiosan_ustaana
--

CREATE SCHEMA inventarios;


ALTER SCHEMA inventarios OWNER TO radiosan_ustaana;

--
-- Name: planillas; Type: SCHEMA; Schema: -; Owner: radiosan_ustaana
--

CREATE SCHEMA planillas;


ALTER SCHEMA planillas OWNER TO radiosan_ustaana;

--
-- Name: rastro; Type: SCHEMA; Schema: -; Owner: radiosan_ustaana
--

CREATE SCHEMA rastro;


ALTER SCHEMA rastro OWNER TO radiosan_ustaana;

--
-- Name: spool; Type: SCHEMA; Schema: -; Owner: radiosan_ustaana
--

CREATE SCHEMA spool;


ALTER SCHEMA spool OWNER TO radiosan_ustaana;

--
-- Name: sunat; Type: SCHEMA; Schema: -; Owner: radiosan_ustaana
--

CREATE SCHEMA sunat;


ALTER SCHEMA sunat OWNER TO radiosan_ustaana;

--
-- Name: tesoreria; Type: SCHEMA; Schema: -; Owner: radiosan_ustaana
--

CREATE SCHEMA tesoreria;


ALTER SCHEMA tesoreria OWNER TO radiosan_ustaana;

--
-- Name: transa; Type: SCHEMA; Schema: -; Owner: radiosan_ustaana
--

CREATE SCHEMA transa;


ALTER SCHEMA transa OWNER TO radiosan_ustaana;

--
-- Name: webservice; Type: SCHEMA; Schema: -; Owner: radiosan_ustaana
--

CREATE SCHEMA webservice;


ALTER SCHEMA webservice OWNER TO radiosan_ustaana;

--
-- Name: plpgsql; Type: EXTENSION; Schema: -; Owner: 
--

CREATE EXTENSION IF NOT EXISTS plpgsql WITH SCHEMA pg_catalog;


--
-- Name: EXTENSION plpgsql; Type: COMMENT; Schema: -; Owner: 
--

COMMENT ON EXTENSION plpgsql IS 'PL/pgSQL procedural language';


SET search_path = basic, pg_catalog;

--
-- Name: seguridad_proceso_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE seguridad_proceso_leer AS (
	permiso boolean,
	mensaje character varying
);


ALTER TYPE basic.seguridad_proceso_leer OWNER TO radiosan_ustaana;

--
-- Name: type_almacen_consultar; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_almacen_consultar AS (
	almacenid integer,
	nombre character varying,
	unidadnegocioid integer
);


ALTER TYPE basic.type_almacen_consultar OWNER TO radiosan_ustaana;

--
-- Name: type_almacen_getrow; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_almacen_getrow AS (
	almacenid integer,
	nombre character varying,
	abreviatura character varying,
	direccion character varying,
	telefono character varying,
	estado boolean,
	zonaid integer,
	zona_nombre character varying,
	unidadnegocioid integer,
	unidadnegocio_nombre character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_ruc character varying,
	distritoid integer,
	distrito_nombre character varying,
	provinciaid integer,
	provincia_nombre character varying,
	departamentoid integer,
	departamento_nombre character varying
);


ALTER TYPE basic.type_almacen_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_almacen_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_almacen_leer AS (
	almacenid integer,
	nombre character varying,
	abreviatura character varying,
	direccion character varying,
	telefono character varying,
	estado boolean,
	zonaid integer,
	zona_nombre character varying,
	unidadnegocioid integer,
	unidadnegocio_nombre character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_ruc character varying,
	distritoid integer,
	distrito_nombre character varying,
	provinciaid integer,
	provincia_nombre character varying,
	departamentoid integer,
	departamento_nombre character varying
);


ALTER TYPE basic.type_almacen_leer OWNER TO radiosan_ustaana;

--
-- Name: type_almacen_leer_sistema; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_almacen_leer_sistema AS (
	almacenid integer,
	nombre character varying,
	abreviatura character varying,
	direccion character varying,
	telefono character varying,
	estado boolean,
	zonaid integer,
	zona_nombre character varying,
	unidadnegocioid integer,
	unidadnegocio_nombre character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_ruc character varying,
	distritoid integer,
	distrito_nombre character varying,
	provinciaid integer,
	provincia_nombre character varying,
	departamentoid integer,
	departamento_nombre character varying,
	updateprecio boolean
);


ALTER TYPE basic.type_almacen_leer_sistema OWNER TO radiosan_ustaana;

--
-- Name: type_ambiente_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_ambiente_leer AS (
	ambienteid integer,
	nombre character varying,
	abreviatura character varying,
	piso integer,
	capacidad integer,
	edificioid integer,
	edificio character varying,
	edificio_ambiente character varying,
	orden integer,
	estado boolean
);


ALTER TYPE basic.type_ambiente_leer OWNER TO radiosan_ustaana;

--
-- Name: type_area_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_area_leer AS (
	areaid integer,
	nombre character varying,
	abreviatura character varying,
	orden integer,
	estado boolean
);


ALTER TYPE basic.type_area_leer OWNER TO radiosan_ustaana;

--
-- Name: type_banco_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_banco_leer AS (
	bancoid integer,
	nombre character varying,
	abreviatura character varying,
	referencia character varying
);


ALTER TYPE basic.type_banco_leer OWNER TO radiosan_ustaana;

--
-- Name: type_banco_leer_sistema; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_banco_leer_sistema AS (
	bancoid integer,
	nombre character varying,
	abreviatura character varying,
	referencia character varying
);


ALTER TYPE basic.type_banco_leer_sistema OWNER TO radiosan_ustaana;

--
-- Name: type_cambiar_clave_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_cambiar_clave_leer AS (
	codigo integer,
	registro character varying,
	personaid integer,
	nombre_persona character varying,
	usuario_anterior character varying,
	usuario_nuevo character varying,
	clave_anterior character varying,
	clave_nueva character varying,
	clave_temporal character varying,
	renovar_clave boolean,
	tipo_cambio character varying,
	exito boolean,
	ip character varying,
	usuarioid integer,
	nombre_usuario character varying,
	observacion character varying
);


ALTER TYPE basic.type_cambiar_clave_leer OWNER TO radiosan_ustaana;

--
-- Name: type_cambiar_clave_otros_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_cambiar_clave_otros_leer AS (
	codigo integer,
	registro character varying,
	personaid integer,
	nombre_persona character varying,
	usuario_anterior character varying,
	usuario_nuevo character varying,
	clave_anterior character varying,
	clave_nueva character varying,
	clave_temporal character varying,
	renovar_clave boolean,
	tipo_cambio character varying,
	exito boolean,
	ip character varying,
	usuarioid integer,
	nombre_usuario character varying,
	observacion character varying
);


ALTER TYPE basic.type_cambiar_clave_otros_leer OWNER TO radiosan_ustaana;

--
-- Name: type_cargo_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_cargo_leer AS (
	cargoid integer,
	nombre character varying,
	abreviatura character varying,
	orden integer,
	estado boolean
);


ALTER TYPE basic.type_cargo_leer OWNER TO radiosan_ustaana;

--
-- Name: type_categoria_licencia_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_categoria_licencia_leer AS (
	categoriaid integer,
	nombre character varying,
	orden integer,
	estado boolean
);


ALTER TYPE basic.type_categoria_licencia_leer OWNER TO radiosan_ustaana;

--
-- Name: type_clave_otros_validar_usuario; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_clave_otros_validar_usuario AS (
	personaid integer,
	usuario character varying,
	clave character varying
);


ALTER TYPE basic.type_clave_otros_validar_usuario OWNER TO radiosan_ustaana;

--
-- Name: type_configuracion_leer_valores; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_configuracion_leer_valores AS (
	codigo integer,
	valor_char character varying,
	valor_text text,
	valor_int integer,
	valor_numeric numeric
);


ALTER TYPE basic.type_configuracion_leer_valores OWNER TO radiosan_ustaana;

--
-- Name: type_ctacte_consulta; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_ctacte_consulta AS (
	ctacteid integer,
	nombre_full character varying,
	numero character varying
);


ALTER TYPE basic.type_ctacte_consulta OWNER TO radiosan_ustaana;

--
-- Name: type_ctacte_getrow; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_ctacte_getrow AS (
	ctacteid integer,
	registro character varying,
	bancoid integer,
	banco_nombre character varying,
	banco_abreviatura character varying,
	empresaid integer,
	empresa_nombre character varying,
	nombre character varying,
	numero character varying,
	abreviatura character varying,
	moneda character varying,
	moneda_nombre character varying,
	moneda_simbolo character varying,
	titular character varying,
	tipo character varying,
	banco boolean,
	controlcheques boolean,
	che_inicio integer,
	che_fin integer,
	che_actual integer,
	dif_inicio integer,
	dif_fin integer,
	dif_actual integer,
	pcgr_general character varying,
	pcgr_empresarial character varying,
	arc_cliente character varying,
	arc_sucursal character varying,
	arc_responsable character varying,
	estado boolean
);


ALTER TYPE basic.type_ctacte_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_ctacte_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_ctacte_leer AS (
	ctacteid integer,
	bancoid integer,
	banco_nombre character varying,
	banco_abreviatura character varying,
	empresaid integer,
	empresa_nombre character varying,
	nombre character varying,
	numero character varying,
	abreviatura character varying,
	moneda character varying,
	moneda_nombre character varying,
	moneda_simbolo character varying,
	banco boolean,
	controlcheques boolean,
	pcgr_general character varying,
	pcgr_empresarial character varying,
	estado boolean
);


ALTER TYPE basic.type_ctacte_leer OWNER TO radiosan_ustaana;

--
-- Name: type_ctacte_leer_sistema; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_ctacte_leer_sistema AS (
	ctacteid integer,
	empresaid integer,
	bancoid integer,
	banco_nombre character varying,
	banco_abreviatura character varying,
	numero character varying,
	nombre1 character varying,
	nombre2 character varying,
	moneda character varying,
	moneda_nombre character varying,
	moneda_simbolo character varying
);


ALTER TYPE basic.type_ctacte_leer_sistema OWNER TO radiosan_ustaana;

--
-- Name: type_departamento_getrow; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_departamento_getrow AS (
	departamentoid integer,
	paisid integer,
	pais_nombre character varying,
	pais_abreviatura character varying,
	pais_ubigeo character varying,
	nombre character varying,
	abreviatura character varying,
	ubigeo character varying,
	estado boolean
);


ALTER TYPE basic.type_departamento_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_departamento_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_departamento_leer AS (
	departamentoid integer,
	paisid integer,
	pais_nombre character varying,
	nombre character varying,
	abreviatura character varying,
	ubigeo character varying,
	estado boolean
);


ALTER TYPE basic.type_departamento_leer OWNER TO radiosan_ustaana;

--
-- Name: type_distrito_consulta; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_distrito_consulta AS (
	distritoid integer,
	nombre character varying,
	provinciaid integer,
	provincia character varying,
	departamentoid integer,
	departamento character varying,
	ubigeo character varying
);


ALTER TYPE basic.type_distrito_consulta OWNER TO radiosan_ustaana;

--
-- Name: type_distrito_getrow; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_distrito_getrow AS (
	distritoid integer,
	nombre character varying,
	abreviatura character varying,
	ubigeo character varying,
	ubigeofull character varying,
	provinciaid integer,
	provincia_nombre character varying,
	provincia_abreviatura character varying,
	provincia_ubigeo character varying,
	departamentoid integer,
	departamento_nombre character varying,
	departamento_abreviatura character varying,
	departamento_ubigeo character varying,
	paisid integer,
	pais_nombre character varying,
	pais_abreviatura character varying,
	pais_ubigeo character varying,
	estado boolean
);


ALTER TYPE basic.type_distrito_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_distrito_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_distrito_leer AS (
	distritoid integer,
	departamentoid integer,
	departamento_nombre character varying,
	provinciaid integer,
	provincia_nombre character varying,
	nombre character varying,
	abreviatura character varying,
	ubigeo character varying,
	estado boolean
);


ALTER TYPE basic.type_distrito_leer OWNER TO radiosan_ustaana;

--
-- Name: type_edificio_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_edificio_leer AS (
	edificioid integer,
	nombre character varying,
	cantidad_ambientes integer
);


ALTER TYPE basic.type_edificio_leer OWNER TO radiosan_ustaana;

--
-- Name: type_empresa_almacen_despacho_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_empresa_almacen_despacho_leer AS (
	almacenid integer,
	nombre character varying,
	abreviatura character varying
);


ALTER TYPE basic.type_empresa_almacen_despacho_leer OWNER TO radiosan_ustaana;

--
-- Name: type_empresa_almacen_fp_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_empresa_almacen_fp_leer AS (
	tipoformapagoid integer,
	nombre character varying,
	abreviatura character varying
);


ALTER TYPE basic.type_empresa_almacen_fp_leer OWNER TO radiosan_ustaana;

--
-- Name: type_empresa_almacen_leer_almacenes; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_empresa_almacen_leer_almacenes AS (
	almacenid integer,
	nombre character varying,
	abreviatura character varying,
	zonaid integer,
	zona_nombre character varying,
	zona_abreviatura character varying,
	sunat_firmar boolean,
	sunat_enviar boolean,
	sunat_temporizador integer,
	sunat_intentos integer,
	cantidad_precios integer,
	tipo_redondeo integer,
	certificadoid integer,
	certificado_nombre character varying,
	entregar boolean,
	salida_porpartes boolean,
	despachar_otroalmacen boolean,
	cantidad_almacenes_despacho integer,
	cantidad_fp integer,
	generarqrcode boolean,
	codigo_establecimiento character varying
);


ALTER TYPE basic.type_empresa_almacen_leer_almacenes OWNER TO radiosan_ustaana;

--
-- Name: type_empresa_almacen_leer_sistema; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_empresa_almacen_leer_sistema AS (
	empresaid integer,
	almacenid integer,
	ids character varying,
	certificadoid integer,
	certificado_nombre character varying,
	certificado_archivo character varying,
	certificado_clave character varying,
	certificado_alias character varying,
	certificado_firma_codigo character varying,
	certificado_firma_ruc character varying,
	certificado_firma_nombre character varying,
	firmadorid integer,
	firmador_nombre character varying,
	firmador_archivo character varying,
	sunat_firmar boolean,
	sunat_enviar boolean,
	sunat_temporizador integer,
	sunat_intentos integer,
	cantidad_precios integer,
	tipo_redondeo integer,
	venta_tipdocid integer,
	venta_sinprecio boolean,
	salida_porpartes boolean,
	venta_sinstock boolean,
	venta_descuentos boolean,
	atencion_interfaz character varying,
	entregar boolean,
	despachar_otroalmacen boolean,
	despachoalmacenesids character varying,
	venta_decimales_cantidad integer,
	venta_decimales_precio integer,
	codigo_establecimiento character varying,
	generarqrcode boolean,
	update_precio_com boolean,
	venta_ingresar_valor_venta boolean,
	venta_estransportes boolean,
	sunat_desc_item_xml_bien character varying,
	sunat_desc_item_xml_serv character varying,
	tipoformapagoids character varying,
	grupoid integer,
	venta_salida_obligatoria boolean,
	ingreso_tipoingreso integer,
	venta_reparto boolean,
	pedido_validar_stock boolean
);


ALTER TYPE basic.type_empresa_almacen_leer_sistema OWNER TO radiosan_ustaana;

--
-- Name: type_empresa_config_webservice_facturacion; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_empresa_config_webservice_facturacion AS (
	webserviceid integer,
	institucionid integer,
	institucion_nombre character varying,
	institucion_referencia character varying,
	tipoid integer,
	tipo_nombre character varying,
	tipo_referencia character varying,
	nombre character varying,
	url character varying
);


ALTER TYPE basic.type_empresa_config_webservice_facturacion OWNER TO radiosan_ustaana;

--
-- Name: type_empresa_formatos_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_empresa_formatos_leer AS (
	empresaid integer,
	tipooperacionid integer,
	tipodocumentoid integer,
	formato character varying
);


ALTER TYPE basic.type_empresa_formatos_leer OWNER TO radiosan_ustaana;

--
-- Name: type_empresa_formatos_leer_sistema; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_empresa_formatos_leer_sistema AS (
	empresaid integer,
	tipooperacionid integer,
	tipodocumentoid integer,
	formato character varying
);


ALTER TYPE basic.type_empresa_formatos_leer_sistema OWNER TO radiosan_ustaana;

--
-- Name: type_empresa_getrow; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_empresa_getrow AS (
	empresaid integer,
	ruc character varying,
	nombre character varying,
	nombre_comercial character varying,
	abreviatura character varying,
	direccion character varying,
	url character varying,
	distritoid integer,
	distrito_nombre character varying,
	provinciaid integer,
	provincia_nombre character varying,
	departamentoid integer,
	departamento_nombre character varying,
	igv numeric,
	cantidad_almacenes integer
);


ALTER TYPE basic.type_empresa_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_empresa_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_empresa_leer AS (
	empresaid integer,
	ruc character varying,
	nombre character varying,
	nombre_comercial character varying,
	abreviatura character varying,
	direccion character varying,
	url character varying,
	distritoid integer,
	distrito_nombre character varying,
	provinciaid integer,
	provincia_nombre character varying,
	departamentoid integer,
	departamento_nombre character varying,
	cantidad_almacenes integer
);


ALTER TYPE basic.type_empresa_leer OWNER TO radiosan_ustaana;

--
-- Name: type_empresa_leer_sistema; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_empresa_leer_sistema AS (
	empresaid integer,
	ruc character varying,
	nombre character varying,
	nombre_comercial character varying,
	tipodocumento character varying,
	abreviatura character varying,
	direccion character varying,
	url character varying,
	sunat_usuario character varying,
	sunat_clave character varying,
	sunat_usuario_consulting character varying,
	sunat_clave_consulting character varying,
	distritoid integer,
	distrito_nombre character varying,
	distrito_ubigeofull character varying,
	provinciaid integer,
	provincia_nombre character varying,
	departamentoid integer,
	departamento_nombre character varying,
	bill_wsid integer,
	url_billservice character varying,
	bill_wsid2 integer,
	url_billservice2 character varying,
	bill_wsid3 integer,
	url_billservice3 character varying,
	billconsulting_wsid integer,
	url_billconsultingservice character varying,
	billconsulting_usuarioid integer,
	tipdocid_bol integer,
	tipdocid_fac integer,
	tipdocid_nc integer,
	tipdocid_nd integer,
	bol_tipo_envio integer,
	bol_enviar_asociados boolean,
	fac_tipo_envio integer,
	fac_enviar_asociados boolean,
	certificadoid integer,
	certificado_nombre character varying,
	certificado_archivo character varying,
	certificado_clave character varying,
	certificado_alias character varying,
	certificado_firma_codigo character varying,
	certificado_firma_ruc character varying,
	certificado_firma_nombre character varying,
	firmadorid integer,
	firmador_nombre character varying,
	firmador_archivo character varying,
	igv numeric,
	inv_ubl_version character varying,
	inv_custom_version character varying,
	crenot_ubl_version character varying,
	crenot_custom_version character varying,
	debnot_ubl_version character varying,
	debnot_custom_version character varying,
	resdia_ubl_version character varying,
	resdia_custom_version character varying,
	voided_ubl_version character varying,
	voided_custom_version character varying,
	grupoid integer,
	grupo_nombre character varying,
	almacenesids character varying,
	tipooperacionids character varying,
	venta_decimales_precio integer,
	venta_decimales_cantidad integer,
	venta_clienteid integer,
	venta_tipdoc_condni integer,
	venta_tipdoc_conruc integer,
	venta_condicionpagoid integer,
	paisid integer,
	tiporegimenid integer,
	servidorftpid integer,
	servidorftp_nombre character varying,
	servidorftp_server character varying,
	servidorftp_user character varying,
	servidorftp_password character varying,
	servidorftp_port character varying,
	servidorftp_path_html character varying,
	servidorftp_path_xml character varying,
	ftpjar_archivo character varying,
	servidorcorreoid integer,
	servidorbdid integer,
	servidorbd_nombre character varying,
	servidorbd_server character varying,
	servidorbd_user character varying,
	servidorbd_database character varying,
	servidorbd_password character varying,
	servidorbd_port character varying,
	irenta numeric,
	sunat_wsid_ruc integer,
	sunat_wsid_ruc_url character varying,
	sunat_wsid_ruc_captcha integer,
	sunat_wsid_ruc_captcha_url character varying,
	sunat_wsid_ruc_randomid integer,
	sunat_wsid_ruc_randomid_url character varying,
	sunat_wsid_ruc_random integer,
	sunat_wsid_ruc_random_url character varying,
	sunat_wsid_ruc_personal integer,
	sunat_wsid_ruc_personal_url character varying,
	reniec_wsid_dni integer,
	reniec_wsid_dni_url character varying,
	reniec_wsid_dni_captcha integer,
	reniec_wsid_dni_captcha_url character varying,
	reniec_wsid_dni_personal integer,
	reniec_wsid_dni_personal_url character varying,
	ordcom_decimales_precio integer,
	ordcom_decimales_cantidad integer,
	ordcom_moneda character varying,
	ordcom_proveedorid integer,
	noting_tipmovidventa integer,
	noting_tipmovidventa_notcre integer,
	noting_tipmovidventa_notdeb integer,
	notsal_tipmovidventa integer,
	notsal_tipmovidventa_notcre integer,
	notsal_tipmovidventa_notdeb integer,
	transferencia_personaid integer,
	transferencia_tipmovid integer,
	transferencia_tipodocumentoid integer,
	conversion_personaid integer,
	conversion_tipmovid integer,
	conversion_tipodocumentoid integer,
	inventario_personaid integer,
	inventario_tipmovid integer,
	inventario_tipodocumentoid integer,
	resdia_tipo character varying,
	resdia_items integer,
	anio integer,
	webservicejarid integer,
	webservicejar_nombre character varying,
	webservicejar_archivo character varying,
	modoenviosunat character varying,
	ordrec_tipmovid integer,
	ordrec_tipdocid integer,
	ordrec_proveedorid integer,
	venta_tipopeid integer,
	salida_refdef character varying,
	ingreso_refdef character varying,
	ticketsjarid integer,
	ticketsjar_nombre character varying,
	ticketsjar_archivo character varying,
	utilidad numeric,
	billconsulting_tipo_envio character varying
);


ALTER TYPE basic.type_empresa_leer_sistema OWNER TO radiosan_ustaana;

--
-- Name: type_empresa_tipooperacion_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_empresa_tipooperacion_leer AS (
	tipooperacionid integer,
	nombre character varying,
	abreviatura character varying,
	codigo_contable character varying,
	orden integer
);


ALTER TYPE basic.type_empresa_tipooperacion_leer OWNER TO radiosan_ustaana;

--
-- Name: type_grupo_permisos_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_grupo_permisos_leer AS (
	codigo integer,
	proceso character varying,
	nombre character varying,
	descripcion character varying,
	orden integer,
	estado boolean,
	cantidad_opciones integer,
	cantidad_personas integer
);


ALTER TYPE basic.type_grupo_permisos_leer OWNER TO radiosan_ustaana;

--
-- Name: type_grupo_permisos_menuweb_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_grupo_permisos_menuweb_leer AS (
	codigo integer,
	menuwebid integer
);


ALTER TYPE basic.type_grupo_permisos_menuweb_leer OWNER TO radiosan_ustaana;

--
-- Name: type_grupo_permisos_persona_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_grupo_permisos_persona_leer AS (
	personaid integer,
	nombre_persona character varying,
	sexo character varying,
	foto character varying,
	email character varying,
	telefono character varying,
	rol character varying,
	usuario character varying
);


ALTER TYPE basic.type_grupo_permisos_persona_leer OWNER TO radiosan_ustaana;

--
-- Name: type_grupo_permisos_persona_leer_porpersona; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_grupo_permisos_persona_leer_porpersona AS (
	codigo integer,
	proceso character varying,
	nombre character varying,
	descripcion character varying
);


ALTER TYPE basic.type_grupo_permisos_persona_leer_porpersona OWNER TO radiosan_ustaana;

--
-- Name: type_licencia_conducir_getrow; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_licencia_conducir_getrow AS (
	licenciaid integer,
	registro character varying,
	personaid integer,
	persona_nombre character varying,
	persona_foto character varying,
	persona_sexo character varying,
	categoriaid integer,
	categoria_nombre character varying,
	expedicion date,
	revalidacion date,
	restricciones text,
	archivo character varying,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	usuario_usuario character varying
);


ALTER TYPE basic.type_licencia_conducir_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_licencia_conducir_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_licencia_conducir_leer AS (
	licenciaid integer,
	registro character varying,
	personaid integer,
	categoriaid integer,
	categoria_nombre character varying,
	expedicion date,
	revalidacion date,
	restricciones text,
	archivo character varying,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	usuario_usuario character varying
);


ALTER TYPE basic.type_licencia_conducir_leer OWNER TO radiosan_ustaana;

--
-- Name: type_maquina_getrow; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_maquina_getrow AS (
	maquinaid integer,
	zonaid integer,
	zona_nombre character varying,
	almacenid integer,
	almacen_nombre character varying,
	nombre character varying,
	abreviatura character varying,
	numero integer,
	codigo character varying,
	posx integer,
	posy integer,
	filas integer,
	columnas integer,
	estado boolean
);


ALTER TYPE basic.type_maquina_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_maquina_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_maquina_leer AS (
	maquinaid integer,
	zonaid integer,
	zona_nombre character varying,
	zona_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	nombre character varying,
	abreviatura character varying,
	numero integer,
	codigo character varying,
	posx integer,
	posy integer,
	filas integer,
	columnas integer,
	estado boolean
);


ALTER TYPE basic.type_maquina_leer OWNER TO radiosan_ustaana;

--
-- Name: type_menuweb_getrow; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_menuweb_getrow AS (
	menuwebid integer,
	proceso character varying,
	titulo character varying,
	descripcion character varying,
	link character varying,
	orden integer,
	imagen character varying,
	padre integer,
	padre_titulo character varying,
	padre_descripcion character varying,
	estado boolean,
	cantidad_hijos integer
);


ALTER TYPE basic.type_menuweb_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_menuweb_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_menuweb_leer AS (
	menuwebid integer,
	titulo character varying,
	descripcion character varying,
	proceso character varying,
	link character varying,
	orden integer,
	imagen character varying,
	padre integer,
	estado boolean,
	cantidad_hijos integer,
	cantidad_personas integer
);


ALTER TYPE basic.type_menuweb_leer OWNER TO radiosan_ustaana;

--
-- Name: type_menuweb_leer_favoritos; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_menuweb_leer_favoritos AS (
	menuwebid integer,
	titulo character varying,
	descripcion character varying,
	link character varying,
	orden integer,
	imagen character varying,
	padre integer,
	titulo_padre character varying
);


ALTER TYPE basic.type_menuweb_leer_favoritos OWNER TO radiosan_ustaana;

--
-- Name: type_menuweb_leer_hijos; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_menuweb_leer_hijos AS (
	menuwebid integer,
	titulo character varying,
	descripcion character varying,
	proceso character varying,
	link character varying,
	orden integer,
	imagen character varying,
	padre integer,
	cantidad_hijos integer
);


ALTER TYPE basic.type_menuweb_leer_hijos OWNER TO radiosan_ustaana;

--
-- Name: type_menuweb_leer_padres; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_menuweb_leer_padres AS (
	menuwebid integer,
	titulo character varying,
	descripcion character varying,
	link character varying,
	orden integer,
	imagen character varying,
	padre integer,
	cantidad_hijos integer
);


ALTER TYPE basic.type_menuweb_leer_padres OWNER TO radiosan_ustaana;

--
-- Name: type_menuweb_query_hijos; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_menuweb_query_hijos AS (
	menuwebid integer,
	titulo character varying,
	descripcion character varying,
	link character varying,
	orden integer,
	imagen character varying,
	padre integer
);


ALTER TYPE basic.type_menuweb_query_hijos OWNER TO radiosan_ustaana;

--
-- Name: type_menuweb_query_padres; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_menuweb_query_padres AS (
	menuwebid integer,
	titulo character varying,
	descripcion character varying,
	link character varying,
	orden integer,
	imagen character varying,
	padre integer
);


ALTER TYPE basic.type_menuweb_query_padres OWNER TO radiosan_ustaana;

--
-- Name: type_menuweb_rastro_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_menuweb_rastro_leer AS (
	codigo integer,
	fecha date,
	hora character varying,
	codigo_usu integer,
	nombre_usuario character varying,
	usuario character varying,
	menuwebid integer,
	titulo character varying,
	link character varying,
	ip character varying,
	web character varying
);


ALTER TYPE basic.type_menuweb_rastro_leer OWNER TO radiosan_ustaana;

--
-- Name: type_opciones_seleccion_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_opciones_seleccion_leer AS (
	codigo integer,
	proceso character varying,
	descripcion character varying,
	estado boolean
);


ALTER TYPE basic.type_opciones_seleccion_leer OWNER TO radiosan_ustaana;

--
-- Name: type_opciones_seleccion_leer_rol; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_opciones_seleccion_leer_rol AS (
	rolid integer,
	nombre character varying,
	estructura character varying,
	tipo character varying,
	pordefecto boolean
);


ALTER TYPE basic.type_opciones_seleccion_leer_rol OWNER TO radiosan_ustaana;

--
-- Name: type_pais_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_pais_leer AS (
	paisid integer,
	nombre character varying,
	abreviatura character varying,
	ubigeo character varying,
	estado boolean
);


ALTER TYPE basic.type_pais_leer OWNER TO radiosan_ustaana;

--
-- Name: type_permisos_caja_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_permisos_caja_leer AS (
	personaid integer,
	cajaid integer,
	caja_nombre character varying,
	caja_abreviatura character varying
);


ALTER TYPE basic.type_permisos_caja_leer OWNER TO radiosan_ustaana;

--
-- Name: type_permisos_caja_leer_cajas; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_permisos_caja_leer_cajas AS (
	cajaid integer,
	nombre character varying,
	abreviatura character varying
);


ALTER TYPE basic.type_permisos_caja_leer_cajas OWNER TO radiosan_ustaana;

--
-- Name: type_permisos_ctacte_leer_cajas; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_permisos_ctacte_leer_cajas AS (
	ctacteid integer,
	ctacte character varying,
	empresa boolean,
	empresaid integer,
	almacenid integer
);


ALTER TYPE basic.type_permisos_ctacte_leer_cajas OWNER TO radiosan_ustaana;

--
-- Name: type_permisos_empresa_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_permisos_empresa_leer AS (
	personaid integer,
	empresaid integer,
	empresa_nombre character varying,
	modulosistemaid integer,
	modulosistema_nombre character varying
);


ALTER TYPE basic.type_permisos_empresa_leer OWNER TO radiosan_ustaana;

--
-- Name: type_permisos_empresa_leer_empresas; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_permisos_empresa_leer_empresas AS (
	empresaid integer,
	nombre character varying,
	ruc character varying
);


ALTER TYPE basic.type_permisos_empresa_leer_empresas OWNER TO radiosan_ustaana;

--
-- Name: type_permisos_empresa_leer_personas; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_permisos_empresa_leer_personas AS (
	personaid integer,
	nombre character varying,
	direccion character varying,
	telefono character varying,
	foto character varying,
	sexo character varying,
	rol character varying,
	usuario character varying,
	tipo_cambio character varying,
	renovar_clave character varying,
	cantidad integer,
	ultima_visita character varying
);


ALTER TYPE basic.type_permisos_empresa_leer_personas OWNER TO radiosan_ustaana;

--
-- Name: type_permisos_empresa_leer_resumen; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_permisos_empresa_leer_resumen AS (
	modulosistemaid integer,
	modulosistema_nombre character varying,
	empresaid integer,
	empresa_nombre character varying,
	cantidad integer
);


ALTER TYPE basic.type_permisos_empresa_leer_resumen OWNER TO radiosan_ustaana;

--
-- Name: type_permisos_menuweb_leer_hijos; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_permisos_menuweb_leer_hijos AS (
	menuwebid integer,
	titulo character varying,
	descripcion character varying,
	link character varying,
	imagen character varying,
	padre integer
);


ALTER TYPE basic.type_permisos_menuweb_leer_hijos OWNER TO radiosan_ustaana;

--
-- Name: type_permisos_menuweb_leer_padre; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_permisos_menuweb_leer_padre AS (
	menuwebid integer,
	titulo character varying,
	descripcion character varying,
	link character varying,
	imagen character varying,
	padre integer
);


ALTER TYPE basic.type_permisos_menuweb_leer_padre OWNER TO radiosan_ustaana;

--
-- Name: type_permisos_menuweb_leer_personas; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_permisos_menuweb_leer_personas AS (
	personaid integer,
	nombre character varying,
	direccion character varying,
	telefono character varying,
	foto character varying,
	sexo character varying,
	rol character varying,
	usuario character varying,
	tipo_cambio character varying,
	renovar_clave character varying,
	cantidad integer,
	ultima_visita character varying
);


ALTER TYPE basic.type_permisos_menuweb_leer_personas OWNER TO radiosan_ustaana;

--
-- Name: type_permisos_modulo_almacenes; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_permisos_modulo_almacenes AS (
	almacenid integer,
	nombre character varying,
	abreviatura character varying,
	zonaid integer,
	zona_nombre character varying,
	unidadnegocioid integer,
	unidadnegocio_nombre character varying
);


ALTER TYPE basic.type_permisos_modulo_almacenes OWNER TO radiosan_ustaana;

--
-- Name: type_permisos_modulo_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_permisos_modulo_leer AS (
	personaid integer,
	almacenid integer,
	almacen_nombre character varying,
	modulosistemaid integer,
	modulosistema_nombre character varying,
	cerrar_new boolean,
	cerrar_update boolean
);


ALTER TYPE basic.type_permisos_modulo_leer OWNER TO radiosan_ustaana;

--
-- Name: type_permisos_modulo_leer_almacenes; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_permisos_modulo_leer_almacenes AS (
	almacenid integer,
	nombre character varying,
	modulosistemaid integer,
	modulosistema_nombre character varying,
	unidadnegocioid integer,
	unidadnegocio_nombre character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_ruc character varying
);


ALTER TYPE basic.type_permisos_modulo_leer_almacenes OWNER TO radiosan_ustaana;

--
-- Name: type_permisos_modulo_leer_personas; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_permisos_modulo_leer_personas AS (
	personaid integer,
	nombre character varying,
	direccion character varying,
	telefono character varying,
	foto character varying,
	sexo character varying,
	rol character varying,
	usuario character varying,
	tipo_cambio character varying,
	renovar_clave character varying,
	cantidad integer,
	ultima_visita character varying
);


ALTER TYPE basic.type_permisos_modulo_leer_personas OWNER TO radiosan_ustaana;

--
-- Name: type_permisos_modulo_leer_resumen; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_permisos_modulo_leer_resumen AS (
	modulosistemaid integer,
	modulosistema_nombre character varying,
	almacenid integer,
	almacen_nombre character varying,
	cantidad integer
);


ALTER TYPE basic.type_permisos_modulo_leer_resumen OWNER TO radiosan_ustaana;

--
-- Name: type_permisos_modulo_zonas; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_permisos_modulo_zonas AS (
	zonaid integer,
	nombre character varying,
	abreviatura character varying,
	cantidad_almacenes integer
);


ALTER TYPE basic.type_permisos_modulo_zonas OWNER TO radiosan_ustaana;

--
-- Name: type_permisos_proceso_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_permisos_proceso_leer AS (
	procesoid integer,
	nombre character varying,
	descripcion character varying,
	mensaje text
);


ALTER TYPE basic.type_permisos_proceso_leer OWNER TO radiosan_ustaana;

--
-- Name: type_permisos_proceso_leer_personas; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_permisos_proceso_leer_personas AS (
	personaid integer,
	nombre character varying,
	direccion character varying,
	telefono character varying,
	foto character varying,
	sexo character varying,
	rol character varying,
	usuario character varying,
	tipo_cambio character varying,
	renovar_clave character varying,
	cantidad integer,
	ultima_visita character varying
);


ALTER TYPE basic.type_permisos_proceso_leer_personas OWNER TO radiosan_ustaana;

--
-- Name: type_permisos_unidad_negocio_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_permisos_unidad_negocio_leer AS (
	personaid integer,
	unidadnegocioid integer,
	unidad_negocio character varying,
	moduloid smallint,
	modulo_sistema character varying
);


ALTER TYPE basic.type_permisos_unidad_negocio_leer OWNER TO radiosan_ustaana;

--
-- Name: type_persona_claves_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_persona_claves_leer AS (
	personaid integer,
	tipo character varying,
	nombre_persona character varying,
	direccion character varying,
	telefono character varying,
	sexo character varying,
	foto character varying,
	usuario character varying,
	tipo_cambio character varying,
	renovar_clave boolean,
	estado boolean
);


ALTER TYPE basic.type_persona_claves_leer OWNER TO radiosan_ustaana;

--
-- Name: type_persona_config_getrow; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_persona_config_getrow AS (
	personaid integer,
	consultarsunat boolean,
	consultarreniec boolean,
	caja_refdef character varying
);


ALTER TYPE basic.type_persona_config_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_persona_consulta; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_persona_consulta AS (
	personaid integer,
	tipo character varying,
	dni_ruc character varying,
	nombre_persona character varying,
	direccion character varying,
	foto character varying,
	email character varying,
	telefono character varying,
	sexo character varying,
	rol character varying,
	usuario character varying
);


ALTER TYPE basic.type_persona_consulta OWNER TO radiosan_ustaana;

--
-- Name: type_persona_consulta_basico; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_persona_consulta_basico AS (
	personaid integer,
	tipo character varying,
	ape_pat character varying,
	ape_mat character varying,
	nombre character varying,
	raz_soc character varying,
	dni character varying,
	ruc character varying,
	direccion character varying,
	estado boolean,
	distritoid integer,
	nrolicencia character varying,
	nrocuenta character varying,
	c_costo character varying,
	asistenteid integer,
	saldo numeric
);


ALTER TYPE basic.type_persona_consulta_basico OWNER TO radiosan_ustaana;

--
-- Name: type_persona_direccion_getrow; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_persona_direccion_getrow AS (
	direccionid integer,
	registro character varying,
	personaid integer,
	tipodireccionid integer,
	tipodireccion_nombre character varying,
	sucursal character varying,
	direccion character varying,
	urbanizacion character varying,
	referencia character varying,
	estado boolean,
	pordefecto boolean,
	ubigeofull character varying,
	direccionfull character varying,
	distritoid integer,
	distrito_nombre character varying,
	distrito_abreviatura character varying,
	distrito_ubigeo character varying,
	provinciaid integer,
	provincia_nombre character varying,
	provincia_abreviatura character varying,
	provincia_ubigeo character varying,
	departamentoid integer,
	departamento_nombre character varying,
	departamento_abreviatura character varying,
	departamento_ubigeo character varying,
	paisid integer,
	pais_nombre character varying,
	pais_abreviatura character varying,
	pais_ubigeo character varying
);


ALTER TYPE basic.type_persona_direccion_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_persona_direccion_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_persona_direccion_leer AS (
	direccionid integer,
	registro character varying,
	personaid integer,
	tipodireccionid integer,
	tipodireccion_nombre character varying,
	sucursal character varying,
	direccion character varying,
	urbanizacion character varying,
	referencia character varying,
	estado boolean,
	pordefecto boolean,
	ubigeofull character varying,
	direccionfull character varying,
	distritoid integer,
	distrito_nombre character varying,
	distrito_abreviatura character varying,
	distrito_ubigeo character varying,
	provinciaid integer,
	provincia_nombre character varying,
	provincia_abreviatura character varying,
	provincia_ubigeo character varying,
	departamentoid integer,
	departamento_nombre character varying,
	departamento_abreviatura character varying,
	departamento_ubigeo character varying,
	paisid integer,
	pais_nombre character varying,
	pais_abreviatura character varying,
	pais_ubigeo character varying
);


ALTER TYPE basic.type_persona_direccion_leer OWNER TO radiosan_ustaana;

--
-- Name: type_persona_email_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_persona_email_leer AS (
	codigo integer,
	personaid integer,
	tipoemailid integer,
	tipo_email_nombre character varying,
	email character varying,
	nombre character varying,
	main boolean,
	publico boolean,
	tipo_email_requerido boolean
);


ALTER TYPE basic.type_persona_email_leer OWNER TO radiosan_ustaana;

--
-- Name: type_persona_estado_cuenta; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_persona_estado_cuenta AS (
	linea_credito numeric,
	ventas_monbas numeric,
	ventas_monext numeric,
	ventas_total numeric,
	porcobrar_venta_total numeric,
	porcobrar_venta_saldo numeric,
	porcobrar_porcobrar_total numeric,
	porcobrar_porcobrar_saldo numeric,
	porcobrar_total numeric,
	porcobrar_saldo numeric,
	porpagar_venta_total numeric,
	porpagar_venta_saldo numeric,
	porpagar_porpagar_total numeric,
	porpagar_porpagar_saldo numeric,
	porpagar_docpro_total numeric,
	porpagar_docpro_saldo numeric,
	porpagar_total numeric,
	porpagar_saldo numeric,
	sobrante_ingreso_total numeric,
	sobrante_ingreso_saldo numeric,
	sobrante_egreso_total numeric,
	sobrante_egreso_saldo numeric,
	sobrante numeric,
	monbas_porcobrar_venta_total numeric,
	monbas_porcobrar_venta_saldo numeric,
	monbas_porcobrar_porcobrar_total numeric,
	monbas_porcobrar_porcobrar_saldo numeric,
	monbas_porcobrar_total numeric,
	monbas_porcobrar_saldo numeric,
	monbas_porpagar_venta_total numeric,
	monbas_porpagar_venta_saldo numeric,
	monbas_porpagar_porpagar_total numeric,
	monbas_porpagar_porpagar_saldo numeric,
	monbas_porpagar_docpro_total numeric,
	monbas_porpagar_docpro_saldo numeric,
	monbas_porpagar_total numeric,
	monbas_porpagar_saldo numeric,
	monext_porcobrar_venta_total numeric,
	monext_porcobrar_venta_saldo numeric,
	monext_porcobrar_porcobrar_total numeric,
	monext_porcobrar_porcobrar_saldo numeric,
	monext_porcobrar_total numeric,
	monext_porcobrar_saldo numeric,
	monext_porpagar_venta_total numeric,
	monext_porpagar_venta_saldo numeric,
	monext_porpagar_porpagar_total numeric,
	monext_porpagar_porpagar_saldo numeric,
	monext_porpagar_docpro_total numeric,
	monext_porpagar_docpro_saldo numeric,
	monext_porpagar_total numeric,
	monext_porpagar_saldo numeric
);


ALTER TYPE basic.type_persona_estado_cuenta OWNER TO radiosan_ustaana;

--
-- Name: type_persona_getdeuda; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_persona_getdeuda AS (
	ventas_monbas numeric,
	ventas_monext numeric,
	porcobrar_monbas numeric,
	porcobrar_monext numeric,
	anticipo_ing_monbas numeric,
	anticipo_ing_monext numeric,
	docpro_monbas numeric,
	docpro_monext numeric,
	porpagar_monbas numeric,
	porpagar_monext numeric,
	anticipo_egr_monbas numeric,
	anticipo_egr_monext numeric
);


ALTER TYPE basic.type_persona_getdeuda OWNER TO radiosan_ustaana;

--
-- Name: type_persona_getrow; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_persona_getrow AS (
	personaid integer,
	tipo character varying,
	rol character varying,
	direccion character varying,
	telefono character varying,
	email character varying,
	estado boolean,
	registro character varying,
	distritoid integer,
	foto character varying,
	nombre_comercial character varying,
	titulo character varying,
	ape_pat character varying,
	ape_mat character varying,
	nombre character varying,
	nacimiento date,
	dni character varying,
	pernat_ruc character varying,
	sexo character varying,
	est_civil character varying,
	raz_soc character varying,
	ruc character varying,
	distrito_nombre character varying,
	distrito_abreviatura character varying,
	distrito_ubigeo character varying,
	provinciaid integer,
	provincia_nombre character varying,
	provincia_abreviatura character varying,
	provincia_ubigeo character varying,
	departamentoid integer,
	departamento_nombre character varying,
	departamento_abreviatura character varying,
	departamento_ubigeo character varying,
	ape_pat_mayus character varying,
	ape_mat_mayus character varying,
	nombre_mayus character varying,
	ape_pat_ab character varying,
	ape_mat_ab character varying,
	nombre_ab character varying,
	nacimiento_text character varying,
	licencia character varying,
	cantidad_licencias integer,
	saldo_porcobrar_monbas numeric,
	saldo_porcobrar_monext numeric,
	saldo_porpagar_monbas numeric,
	saldo_porpagar_monext numeric
);


ALTER TYPE basic.type_persona_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_persona_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_persona_leer AS (
	personaid integer,
	tipo character varying,
	dni_ruc character varying,
	nombre_persona character varying,
	direccion character varying,
	telefono character varying,
	email character varying,
	rol character varying,
	sexo character varying,
	foto character varying,
	nacimiento character varying,
	estado boolean
);


ALTER TYPE basic.type_persona_leer OWNER TO radiosan_ustaana;

--
-- Name: type_persona_leer_saldos; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_persona_leer_saldos AS (
	linea_credito numeric,
	deuda numeric,
	pago_adelantado numeric,
	disponible numeric
);


ALTER TYPE basic.type_persona_leer_saldos OWNER TO radiosan_ustaana;

--
-- Name: type_persona_non_grupo_permisos; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_persona_non_grupo_permisos AS (
	personaid integer,
	nombre_persona character varying,
	sexo character varying,
	foto character varying,
	email character varying,
	telefono character varying,
	rol character varying,
	usuario character varying
);


ALTER TYPE basic.type_persona_non_grupo_permisos OWNER TO radiosan_ustaana;

--
-- Name: type_persona_proceso_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_persona_proceso_leer AS (
	nombre character varying
);


ALTER TYPE basic.type_persona_proceso_leer OWNER TO radiosan_ustaana;

--
-- Name: type_persona_rol_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_persona_rol_leer AS (
	personaid integer,
	rolid integer,
	nombre character varying
);


ALTER TYPE basic.type_persona_rol_leer OWNER TO radiosan_ustaana;

--
-- Name: type_persona_socialmedia_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_persona_socialmedia_leer AS (
	personaid integer,
	tiposocialmediaid integer,
	tipo_socialmedia_nombre character varying,
	tipo_socialmedia_url character varying,
	url character varying
);


ALTER TYPE basic.type_persona_socialmedia_leer OWNER TO radiosan_ustaana;

--
-- Name: type_persona_telefono_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_persona_telefono_leer AS (
	codigo integer,
	personaid integer,
	tipotelefonoid integer,
	tipo_telefono_name character varying,
	numero character varying,
	nombre character varying,
	main boolean,
	publico boolean,
	tipo_telefono_requerido boolean
);


ALTER TYPE basic.type_persona_telefono_leer OWNER TO radiosan_ustaana;

--
-- Name: type_persona_tipoid_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_persona_tipoid_leer AS (
	personaid integer,
	tipoid integer,
	tipoid_nombre character varying,
	numero character varying,
	main boolean
);


ALTER TYPE basic.type_persona_tipoid_leer OWNER TO radiosan_ustaana;

--
-- Name: type_personagallery_getrow; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_personagallery_getrow AS (
	personagalleryid integer,
	personaid integer,
	registro character varying,
	filename character varying,
	width integer,
	height integer,
	dpi integer,
	size integer,
	"order" integer,
	status boolean,
	lastchange character varying
);


ALTER TYPE basic.type_personagallery_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_personagallery_read; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_personagallery_read AS (
	personagalleryid integer,
	personaid integer,
	registro character varying,
	filename character varying,
	width integer,
	height integer,
	dpi integer,
	size integer,
	"order" integer,
	status boolean,
	lastchange character varying
);


ALTER TYPE basic.type_personagallery_read OWNER TO radiosan_ustaana;

--
-- Name: type_proceso_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_proceso_leer AS (
	procesoid integer,
	tipoprocesoid integer,
	tipo_proceso character varying,
	nombre character varying,
	descripcion character varying,
	mensaje text,
	orden integer,
	estado boolean,
	cantidad_personas integer
);


ALTER TYPE basic.type_proceso_leer OWNER TO radiosan_ustaana;

--
-- Name: type_provincia_getrow; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_provincia_getrow AS (
	provinciaid integer,
	nombre character varying,
	abreviatura character varying,
	ubigeo character varying,
	departamentoid integer,
	departamento_nombre character varying,
	departamento_abreviatura character varying,
	departamento_ubigeo character varying,
	paisid integer,
	pais_nombre character varying,
	pais_abreviatura character varying,
	pais_ubigeo character varying,
	estado boolean
);


ALTER TYPE basic.type_provincia_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_provincia_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_provincia_leer AS (
	provinciaid integer,
	departamentoid integer,
	departamento_nombre character varying,
	nombre character varying,
	abreviatura character varying,
	ubigeo character varying,
	estado boolean
);


ALTER TYPE basic.type_provincia_leer OWNER TO radiosan_ustaana;

--
-- Name: type_seguridad_redirect_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_seguridad_redirect_leer AS (
	codigo integer,
	registro character varying,
	usuarioid integer,
	usuario character varying,
	ip character varying,
	nombre_persona character varying,
	link character varying
);


ALTER TYPE basic.type_seguridad_redirect_leer OWNER TO radiosan_ustaana;

--
-- Name: type_servidor_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_servidor_leer AS (
	servidorid integer,
	nombre character varying,
	servidor character varying,
	usuario character varying,
	clave character varying,
	puerto character varying,
	path_html character varying,
	path_xml character varying
);


ALTER TYPE basic.type_servidor_leer OWNER TO radiosan_ustaana;

--
-- Name: type_servidorcorreo_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_servidorcorreo_leer AS (
	servidorid integer,
	nombre character varying,
	servidor character varying,
	correo character varying,
	clave character varying,
	puerto character varying,
	encriptacion character varying,
	estado boolean
);


ALTER TYPE basic.type_servidorcorreo_leer OWNER TO radiosan_ustaana;

--
-- Name: type_servidordb_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_servidordb_leer AS (
	servidorid integer,
	nombre character varying,
	servidor character varying,
	basedatos character varying,
	servidor_basedatos character varying,
	usuario character varying,
	puerto character varying,
	estado boolean
);


ALTER TYPE basic.type_servidordb_leer OWNER TO radiosan_ustaana;

--
-- Name: type_surtidor_consulta; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_surtidor_consulta AS (
	surtidorid integer,
	tanqueid integer,
	tanque_nombre character varying,
	maquinaid integer,
	maquina_nombre character varying,
	nombre character varying,
	abreviatura character varying,
	posx integer,
	posy integer,
	productoid integer,
	producto_nombre character varying,
	producto_abreviatura character varying,
	producto_sigla character varying,
	producto_backcolor character varying,
	producto_forecolor character varying
);


ALTER TYPE basic.type_surtidor_consulta OWNER TO radiosan_ustaana;

--
-- Name: type_surtidor_getrow; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_surtidor_getrow AS (
	surtidorid integer,
	zonaid integer,
	zona_nombre character varying,
	almacenid integer,
	almacen_nombre character varying,
	tanqueid integer,
	tanque_nombre character varying,
	maquinaid integer,
	maquina_nombre character varying,
	nombre character varying,
	abreviatura character varying,
	posx integer,
	posy integer,
	estado boolean
);


ALTER TYPE basic.type_surtidor_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_surtidor_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_surtidor_leer AS (
	surtidorid integer,
	zonaid integer,
	zona_nombre character varying,
	zona_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	tanqueid integer,
	tanque_nombre character varying,
	maquinaid integer,
	maquina_nombre character varying,
	nombre character varying,
	abreviatura character varying,
	posx integer,
	posy integer,
	estado boolean
);


ALTER TYPE basic.type_surtidor_leer OWNER TO radiosan_ustaana;

--
-- Name: type_tanque_getrow; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_tanque_getrow AS (
	tanqueid integer,
	zonaid integer,
	zona_nombre character varying,
	almacenid integer,
	almacen_nombre character varying,
	nombre character varying,
	abreviatura character varying,
	numero integer,
	capacidad integer,
	productoid integer,
	producto_nombre character varying,
	producto_abreviatura character varying,
	estado boolean
);


ALTER TYPE basic.type_tanque_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_tanque_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_tanque_leer AS (
	tanqueid integer,
	zonaid integer,
	zona_nombre character varying,
	zona_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	nombre character varying,
	abreviatura character varying,
	nombre_conproducto character varying,
	numero integer,
	capacidad integer,
	productoid integer,
	producto_nombre character varying,
	producto_abreviatura character varying,
	estado boolean
);


ALTER TYPE basic.type_tanque_leer OWNER TO radiosan_ustaana;

--
-- Name: type_tipo_moneda_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_tipo_moneda_leer AS (
	tipomonedaid character varying,
	nombre character varying,
	abreviatura character varying,
	simbolo character varying,
	codigo_contable character varying,
	codigo_ple character varying
);


ALTER TYPE basic.type_tipo_moneda_leer OWNER TO radiosan_ustaana;

--
-- Name: type_tipo_proceso_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_tipo_proceso_leer AS (
	tipoprocesoid integer,
	nombre character varying,
	descripcion character varying,
	orden integer,
	estado boolean,
	cantidad_procesos integer
);


ALTER TYPE basic.type_tipo_proceso_leer OWNER TO radiosan_ustaana;

--
-- Name: type_tipoid_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_tipoid_leer AS (
	tipoid integer,
	nombre character varying,
	abreviatura character varying,
	codigo_contable character varying,
	longitud smallint,
	pordefecto boolean,
	orden integer,
	estado boolean
);


ALTER TYPE basic.type_tipoid_leer OWNER TO radiosan_ustaana;

--
-- Name: type_tipooperacion_consulta; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_tipooperacion_consulta AS (
	tipooperacionid integer,
	nombre character varying,
	abreviatura character varying,
	codigo_contable character varying,
	orden integer
);


ALTER TYPE basic.type_tipooperacion_consulta OWNER TO radiosan_ustaana;

--
-- Name: type_tipooperacion_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_tipooperacion_leer AS (
	tipooperacionid integer,
	nombre character varying,
	abreviatura character varying,
	codigo_contable character varying,
	orden integer,
	estado boolean
);


ALTER TYPE basic.type_tipooperacion_leer OWNER TO radiosan_ustaana;

--
-- Name: type_tiporegimen_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_tiporegimen_leer AS (
	tiporegimenid integer,
	nombre character varying,
	abreviatura character varying,
	orden integer,
	estado boolean
);


ALTER TYPE basic.type_tiporegimen_leer OWNER TO radiosan_ustaana;

--
-- Name: type_unidad_negocio_consultar; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_unidad_negocio_consultar AS (
	unidadnegocioid integer,
	nombre character varying,
	abreviatura character varying,
	empresaid integer,
	empresa_nombre character varying,
	tipoempresaid integer,
	tipoempresa_nombre character varying
);


ALTER TYPE basic.type_unidad_negocio_consultar OWNER TO radiosan_ustaana;

--
-- Name: type_unidad_negocio_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_unidad_negocio_leer AS (
	unidadnegocioid integer,
	nombre character varying,
	abreviatura character varying,
	direccion character varying,
	telefono character varying,
	empresaid integer,
	empresa character varying,
	tipoempresaid integer,
	tipoempresa character varying,
	orden integer,
	estado boolean
);


ALTER TYPE basic.type_unidad_negocio_leer OWNER TO radiosan_ustaana;

--
-- Name: type_visita_intranet_getrow; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_visita_intranet_getrow AS (
	codigo integer,
	intranet character varying,
	fechaintento character varying,
	fecha_text character varying,
	hora_text character varying,
	personaid integer,
	usuario character varying,
	clave character varying,
	ip character varying,
	exito boolean,
	persona_nombre character varying,
	browser character varying,
	browser_version character varying,
	plataform character varying,
	mobile boolean,
	fechasalida character varying
);


ALTER TYPE basic.type_visita_intranet_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_visita_intranet_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_visita_intranet_leer AS (
	codigo integer,
	intranet character varying,
	fechaintento timestamp without time zone,
	fecha_text character varying,
	hora_text character varying,
	personaid integer,
	usuario character varying,
	clave character varying,
	ip character varying,
	exito boolean,
	nombre_persona character varying,
	browser character varying,
	browser_version character varying,
	plataform character varying,
	mobile boolean,
	fechasalida timestamp without time zone
);


ALTER TYPE basic.type_visita_intranet_leer OWNER TO radiosan_ustaana;

--
-- Name: type_visita_intranet_resumen_browser; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_visita_intranet_resumen_browser AS (
	browser character varying,
	cantidad bigint,
	porcentaje numeric
);


ALTER TYPE basic.type_visita_intranet_resumen_browser OWNER TO radiosan_ustaana;

--
-- Name: type_visita_intranet_resumen_plataform; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_visita_intranet_resumen_plataform AS (
	plataform character varying,
	cantidad bigint,
	porcentaje numeric
);


ALTER TYPE basic.type_visita_intranet_resumen_plataform OWNER TO radiosan_ustaana;

--
-- Name: type_zona_getrow; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_zona_getrow AS (
	zonaid integer,
	nombre character varying,
	abreviatura character varying,
	estado boolean
);


ALTER TYPE basic.type_zona_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_zona_leer; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_zona_leer AS (
	zonaid integer,
	nombre character varying,
	abreviatura character varying,
	orden integer,
	estado boolean
);


ALTER TYPE basic.type_zona_leer OWNER TO radiosan_ustaana;

--
-- Name: type_zona_leer_sistema; Type: TYPE; Schema: basic; Owner: radiosan_ustaana
--

CREATE TYPE type_zona_leer_sistema AS (
	zonaid integer,
	nombre character varying,
	abreviatura character varying,
	estado boolean
);


ALTER TYPE basic.type_zona_leer_sistema OWNER TO radiosan_ustaana;

SET search_path = boletaje, pg_catalog;

--
-- Name: type_proceso_getrow; Type: TYPE; Schema: boletaje; Owner: radiosan_ustaana
--

CREATE TYPE type_proceso_getrow AS (
	procesoid integer,
	registro character varying,
	tipo character varying,
	empresaid integer,
	empresa_nombre character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	nombre character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	serie character varying,
	numero integer,
	limitarfechas boolean,
	desde date,
	hasta date,
	importe_maximo numeric,
	cantidad_items integer,
	cantidad_maxima_item integer,
	observacion text,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	usuario_usuario character varying,
	ip character varying,
	estado smallint,
	estado_detalle character varying,
	cantidad_porprocesar integer
);


ALTER TYPE boletaje.type_proceso_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_proceso_leer; Type: TYPE; Schema: boletaje; Owner: radiosan_ustaana
--

CREATE TYPE type_proceso_leer AS (
	procesoid integer,
	registro character varying,
	empresaid integer,
	empresa_nombre character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	nombre character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	serie character varying,
	numero integer,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	usuario_usuario character varying,
	estado smallint,
	estado_detalle character varying,
	cantidad_porprocesar integer
);


ALTER TYPE boletaje.type_proceso_leer OWNER TO radiosan_ustaana;

--
-- Name: type_proceso_porprocesar_leer; Type: TYPE; Schema: boletaje; Owner: radiosan_ustaana
--

CREATE TYPE type_proceso_porprocesar_leer AS (
	porprocesarid integer,
	procesoid integer,
	numero integer,
	fecha date,
	dniruc character varying,
	ape_pat character varying,
	ape_mat character varying,
	nombre character varying,
	cantidad numeric,
	producto character varying,
	unidad character varying,
	precio numeric,
	personaid integer,
	persona_nombre character varying
);


ALTER TYPE boletaje.type_proceso_porprocesar_leer OWNER TO radiosan_ustaana;

SET search_path = catalogo, pg_catalog;

--
-- Name: type_cambiar_precios_leer; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_cambiar_precios_leer AS (
	id integer,
	registro character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	productoid integer,
	producto_nombre character varying,
	precio_actual numeric,
	precio numeric,
	observacion text,
	estado smallint,
	estado_detalle character varying,
	usuariosolicitaid integer,
	usuariosolicita_nombre character varying,
	usuariosolicita_foto character varying,
	usuariosolicita_sexo character varying,
	usuariorespuestaid integer,
	usuariorespuesta_nombre character varying,
	usuariorespuesta_foto character varying,
	usuariorespuesta_sexo character varying
);


ALTER TYPE catalogo.type_cambiar_precios_leer OWNER TO radiosan_ustaana;

--
-- Name: type_categoria_leer; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_categoria_leer AS (
	categoriaid integer,
	nombre character varying,
	abreviatura character varying,
	cantidad_subcategorias integer
);


ALTER TYPE catalogo.type_categoria_leer OWNER TO radiosan_ustaana;

--
-- Name: type_color_leer; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_color_leer AS (
	colorid integer,
	nombre character varying,
	abreviatura character varying,
	count_productos integer
);


ALTER TYPE catalogo.type_color_leer OWNER TO radiosan_ustaana;

--
-- Name: type_grupo_getrow; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_grupo_getrow AS (
	grupoid integer,
	nombre character varying,
	abreviatura character varying,
	orden integer,
	estado boolean,
	cantidad_productos integer
);


ALTER TYPE catalogo.type_grupo_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_grupo_leer; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_grupo_leer AS (
	grupoid integer,
	nombre character varying,
	abreviatura character varying,
	orden integer,
	estado boolean,
	cantidad_productos integer
);


ALTER TYPE catalogo.type_grupo_leer OWNER TO radiosan_ustaana;

--
-- Name: type_laboratorio_leer; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_laboratorio_leer AS (
	laboratorioid integer,
	nombre character varying,
	abreviatura character varying,
	count_productos integer
);


ALTER TYPE catalogo.type_laboratorio_leer OWNER TO radiosan_ustaana;

--
-- Name: type_linea_leer; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_linea_leer AS (
	lineaid integer,
	nombre character varying,
	abreviatura character varying,
	codigo_contable character varying,
	orden integer,
	estado boolean
);


ALTER TYPE catalogo.type_linea_leer OWNER TO radiosan_ustaana;

--
-- Name: type_marca_leer; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_marca_leer AS (
	marcaid integer,
	nombre character varying,
	abreviatura character varying,
	count_productos integer
);


ALTER TYPE catalogo.type_marca_leer OWNER TO radiosan_ustaana;

--
-- Name: type_producto_almacen_consulta_app; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_producto_almacen_consulta_app AS (
	almacenid integer,
	almacen_nombre character varying,
	producto_preciova numeric
);


ALTER TYPE catalogo.type_producto_almacen_consulta_app OWNER TO radiosan_ustaana;

--
-- Name: type_producto_almacen_consulta_stock; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_producto_almacen_consulta_stock AS (
	almacenid integer,
	almacen_nombre character varying,
	zonaid integer,
	zona_nombre character varying,
	stock_min integer,
	stock_max integer,
	precio_va numeric,
	precio_vb numeric,
	precio_vc numeric,
	precio_vd numeric,
	stock integer
);


ALTER TYPE catalogo.type_producto_almacen_consulta_stock OWNER TO radiosan_ustaana;

--
-- Name: type_producto_almacen_getalmacenesbyproducto; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_producto_almacen_getalmacenesbyproducto AS (
	almacenid integer,
	nombre character varying,
	zonaid integer,
	zona_nombre character varying
);


ALTER TYPE catalogo.type_producto_almacen_getalmacenesbyproducto OWNER TO radiosan_ustaana;

--
-- Name: type_producto_almacen_getalmacenesbyproductoapp; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_producto_almacen_getalmacenesbyproductoapp AS (
	almacenid integer,
	nombre character varying,
	precioalmacen numeric,
	preciogeneral numeric
);


ALTER TYPE catalogo.type_producto_almacen_getalmacenesbyproductoapp OWNER TO radiosan_ustaana;

--
-- Name: type_producto_almacen_getrow; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_producto_almacen_getrow AS (
	productoid integer,
	almacenid integer,
	almacen_nombre character varying,
	zonaid integer,
	zona_nombre character varying,
	stock_min integer,
	stock_max integer,
	precio_va numeric,
	precio_vb numeric,
	precio_vc numeric,
	precio_vd numeric,
	stock numeric,
	ultimo_precio_venta numeric
);


ALTER TYPE catalogo.type_producto_almacen_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_producto_almacen_leer; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_producto_almacen_leer AS (
	almacenid integer,
	almacen_nombre character varying,
	zonaid integer,
	zona_nombre character varying,
	stock_min integer,
	stock_max integer,
	precio_va numeric,
	precio_vb numeric,
	precio_vc numeric,
	precio_vd numeric,
	stock integer
);


ALTER TYPE catalogo.type_producto_almacen_leer OWNER TO radiosan_ustaana;

--
-- Name: type_producto_consulta; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_producto_consulta AS (
	productoid integer,
	producto character varying,
	unidadmedida character varying,
	marca character varying,
	subcategoria character varying,
	precio_va numeric,
	precio_vb numeric,
	precio_vc numeric,
	precio_vd numeric,
	precio_com numeric,
	peso numeric,
	stock numeric,
	subcategoriaid integer,
	codigo_barras character varying,
	stock_min integer,
	stock_max integer,
	flete numeric,
	grabado boolean,
	stand character varying,
	observacion text,
	oferta boolean,
	servicio boolean
);


ALTER TYPE catalogo.type_producto_consulta OWNER TO radiosan_ustaana;

--
-- Name: type_producto_consulta_app; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_producto_consulta_app AS (
	productoid integer,
	nombre character varying
);


ALTER TYPE catalogo.type_producto_consulta_app OWNER TO radiosan_ustaana;

--
-- Name: type_producto_consulta_old; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_producto_consulta_old AS (
	productoid integer,
	producto character varying,
	marca character varying,
	subcategoria character varying,
	precio_va numeric,
	precio_vb numeric,
	precio_vc numeric,
	precio_vd numeric,
	precio_com numeric,
	peso numeric,
	stock numeric,
	subcategoriaid integer,
	codigo_barras character varying,
	stock_min integer,
	stock_max integer,
	flete numeric,
	grabado boolean,
	stand character varying,
	observacion text,
	oferta boolean
);


ALTER TYPE catalogo.type_producto_consulta_old OWNER TO radiosan_ustaana;

--
-- Name: type_producto_enoferta; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_producto_enoferta AS (
	productoid integer,
	producto character varying,
	unidad_medida character varying,
	marca character varying,
	subcategoria character varying,
	precio_va numeric,
	precio_vb numeric,
	precio_vc numeric,
	precio_vd numeric,
	precio_com numeric,
	peso numeric,
	stock numeric,
	subcategoriaid integer,
	codigo_barras character varying,
	stock_min integer,
	stock_max integer,
	grabado boolean,
	stand character varying,
	observacion text,
	oferta boolean
);


ALTER TYPE catalogo.type_producto_enoferta OWNER TO radiosan_ustaana;

--
-- Name: type_producto_getrow; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_producto_getrow AS (
	productoid integer,
	registro character varying,
	nombre character varying,
	presentacion character varying,
	moneda character varying,
	precio_com numeric,
	precio_va numeric,
	precio_vb numeric,
	precio_vc numeric,
	precio_vd numeric,
	fraccion boolean,
	fraccion_cantidad integer,
	fraccion_productoid integer,
	peso numeric,
	stock_min integer,
	stock_max integer,
	flete numeric,
	codigo_barras character varying,
	categoriaid integer,
	categoria_nombre character varying,
	subcategoriaid integer,
	subcategoria_nombre character varying,
	marcaid integer,
	marca_nombre character varying,
	unidadmedidaid integer,
	unidadmedida_nombre character varying,
	unidadid integer,
	unidad_nombre character varying,
	grabado boolean,
	stand character varying,
	observacion text,
	oferta boolean,
	estado boolean,
	lineaid integer,
	linea_nombre character varying,
	abreviatura character varying,
	codigo_interno character varying,
	codigo_sunat character varying,
	servicio boolean,
	destinado_compra boolean,
	destinado_venta boolean,
	isc boolean,
	isc_porcentaje numeric,
	percepcion boolean,
	percepcion_porcentaje numeric,
	sigla character varying,
	backcolor character varying,
	forecolor character varying,
	colorid integer,
	color_nombre character varying,
	laboratorioid integer,
	laboratorio_nombre character varying,
	principio_activo text,
	indicaciones text,
	registro_sanitario text,
	utilidad numeric
);


ALTER TYPE catalogo.type_producto_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_producto_grupo_leer; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_producto_grupo_leer AS (
	productoid integer,
	producto_nombre character varying,
	lineaid integer,
	linea_nombre character varying,
	marcaid integer,
	marca_nombre character varying,
	subcategoriaid integer,
	subcategoria_nombre character varying,
	precio_va numeric,
	precio_vb numeric,
	precio_vc numeric,
	precio_vd numeric,
	precio_com numeric,
	stock numeric,
	codigo_barras character varying
);


ALTER TYPE catalogo.type_producto_grupo_leer OWNER TO radiosan_ustaana;

--
-- Name: type_producto_grupo_leer_grupos; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_producto_grupo_leer_grupos AS (
	grupoid integer,
	nombre character varying
);


ALTER TYPE catalogo.type_producto_grupo_leer_grupos OWNER TO radiosan_ustaana;

--
-- Name: type_producto_leer; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_producto_leer AS (
	productoid integer,
	producto character varying,
	subcategoriaid integer,
	subcategoria_nombre character varying,
	marcaid integer,
	marca_nombre character varying,
	precio_com numeric,
	stand character varying,
	stock numeric,
	precio_va numeric,
	precio_vb numeric,
	precio_vc numeric,
	precio_vd numeric,
	fraccion_cantidad integer,
	fraccion_productoid integer,
	peso numeric,
	stock_min integer,
	stock_max integer,
	codigo_barras character varying,
	grabado boolean,
	observacion text,
	oferta boolean,
	estado boolean
);


ALTER TYPE catalogo.type_producto_leer OWNER TO radiosan_ustaana;

--
-- Name: type_producto_leer_nongrupo; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_producto_leer_nongrupo AS (
	productoid integer,
	producto_nombre character varying,
	lineaid integer,
	linea_nombre character varying,
	marcaid integer,
	marca_nombre character varying,
	subcategoriaid integer,
	subcategoria_nombre character varying,
	precio_va numeric,
	precio_vb numeric,
	precio_vc numeric,
	precio_vd numeric,
	precio_com numeric,
	stock numeric,
	codigo_barras character varying
);


ALTER TYPE catalogo.type_producto_leer_nongrupo OWNER TO radiosan_ustaana;

--
-- Name: type_producto_tipo_precio_leer; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_producto_tipo_precio_leer AS (
	tipoprecioid integer,
	nombre character varying,
	precio_min numeric,
	precio_max numeric,
	cantidad integer,
	descripcion character varying
);


ALTER TYPE catalogo.type_producto_tipo_precio_leer OWNER TO radiosan_ustaana;

--
-- Name: type_producto_tipooperacion_leer; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_producto_tipooperacion_leer AS (
	tipooperacionid integer,
	nombre character varying,
	abreviatura character varying,
	codigo_contable character varying,
	orden integer
);


ALTER TYPE catalogo.type_producto_tipooperacion_leer OWNER TO radiosan_ustaana;

--
-- Name: type_producto_tipoprecio_leer; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_producto_tipoprecio_leer AS (
	tipoprecioid integer,
	nombre character varying,
	precio_min numeric,
	precio_max numeric,
	cantidad integer,
	descripcion character varying
);


ALTER TYPE catalogo.type_producto_tipoprecio_leer OWNER TO radiosan_ustaana;

--
-- Name: type_producto_ultimos_codigos; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_producto_ultimos_codigos AS (
	productoid integer,
	producto character varying,
	unidad_medida character varying,
	marca character varying,
	subcategoria character varying,
	precio_va numeric,
	precio_vb numeric,
	precio_vc numeric,
	precio_vd numeric,
	precio_com numeric,
	peso numeric,
	stock numeric,
	codigo_sub integer,
	codigo_barras character varying,
	stock_min integer,
	stock_max integer,
	grabado boolean,
	stand character varying,
	observacion text,
	oferta boolean
);


ALTER TYPE catalogo.type_producto_ultimos_codigos OWNER TO radiosan_ustaana;

--
-- Name: type_productos_proveedor_consulta; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_productos_proveedor_consulta AS (
	productoid integer,
	producto character varying,
	subcategoriaid integer,
	subcategoria character varying,
	precio_com numeric,
	flete numeric,
	stock numeric,
	precio_va numeric,
	precio_vb numeric,
	stock_min integer,
	stock_max integer
);


ALTER TYPE catalogo.type_productos_proveedor_consulta OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_lista_precios; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_lista_precios AS (
	producotid integer,
	producto character varying,
	stock numeric,
	precio_com numeric,
	precio_va numeric,
	precio_vb numeric,
	precio_vc numeric,
	precio_vd numeric,
	marca character varying
);


ALTER TYPE catalogo.type_reporte_lista_precios OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_precios; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_precios AS (
	producotid integer,
	almacenid integer,
	stock numeric,
	stock_min integer,
	stock_max integer,
	precio_va numeric,
	precio_vb numeric,
	precio_vc numeric,
	precio_vd numeric
);


ALTER TYPE catalogo.type_reporte_precios OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_productos; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_productos AS (
	producotid integer,
	producto_nombre character varying,
	stock numeric,
	precio_com numeric,
	precio_va numeric,
	precio_vb numeric,
	precio_vc numeric,
	precio_vd numeric,
	marcaid integer,
	marca_nombre character varying,
	categoriaid integer,
	categoria_nombre character varying,
	subcategoriaid integer,
	subcategoria_nombre character varying,
	laboratorioid integer,
	laboratorio_nombre character varying
);


ALTER TYPE catalogo.type_reporte_productos OWNER TO radiosan_ustaana;

--
-- Name: type_subcategoria_getrow; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_subcategoria_getrow AS (
	subcategoriaid integer,
	categoriaid integer,
	categoria_nombre character varying,
	nombre character varying,
	abreviatura character varying
);


ALTER TYPE catalogo.type_subcategoria_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_subcategoria_leer; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_subcategoria_leer AS (
	subcategoriaid integer,
	nombre character varying,
	abreviatura character varying,
	categoriaid integer,
	categoria_nombre character varying,
	count_productos integer
);


ALTER TYPE catalogo.type_subcategoria_leer OWNER TO radiosan_ustaana;

--
-- Name: type_tipoprecio_leer; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_tipoprecio_leer AS (
	tipoprecioid integer,
	nombre character varying,
	cantidad integer
);


ALTER TYPE catalogo.type_tipoprecio_leer OWNER TO radiosan_ustaana;

--
-- Name: type_unidad_leer; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_unidad_leer AS (
	unidadid integer,
	nombre character varying,
	abreviatura character varying,
	codigo_contable character varying,
	codigo_internacional character varying
);


ALTER TYPE catalogo.type_unidad_leer OWNER TO radiosan_ustaana;

--
-- Name: type_unidadmedida_leer; Type: TYPE; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE TYPE type_unidadmedida_leer AS (
	unidadmedidaid integer,
	nombre character varying,
	abreviatura character varying,
	codigo_contable character varying,
	codigo_internacional character varying
);


ALTER TYPE catalogo.type_unidadmedida_leer OWNER TO radiosan_ustaana;

SET search_path = cms, pg_catalog;

--
-- Name: type_autoreply_docs; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_autoreply_docs AS (
	galleryid integer,
	name character varying,
	description text,
	size integer,
	uploaddate_text character varying
);


ALTER TYPE cms.type_autoreply_docs OWNER TO radiosan_ustaana;

--
-- Name: type_autoreply_read; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_autoreply_read AS (
	autoreplyid integer,
	process character varying,
	subject character varying,
	fromname character varying,
	mailingid integer,
	server character varying,
	status boolean,
	count_docs integer,
	count_receiver integer
);


ALTER TYPE cms.type_autoreply_read OWNER TO radiosan_ustaana;

--
-- Name: type_config_query; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_config_query AS (
	configid integer,
	name character varying,
	content text,
	configgroupid integer
);


ALTER TYPE cms.type_config_query OWNER TO radiosan_ustaana;

--
-- Name: type_config_read; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_config_read AS (
	configid integer,
	name character varying,
	description character varying,
	content text,
	configgroupid integer,
	configgroup_name character varying
);


ALTER TYPE cms.type_config_read OWNER TO radiosan_ustaana;

--
-- Name: type_configgroup_read; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_configgroup_read AS (
	configgroupid integer,
	name character varying,
	"order" integer,
	status boolean
);


ALTER TYPE cms.type_configgroup_read OWNER TO radiosan_ustaana;

--
-- Name: type_galeria_imagenes_detalle_leer; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_galeria_imagenes_detalle_leer AS (
	imagenid integer,
	galeriaid integer,
	nombre character varying,
	descripcion text,
	orden integer,
	estado boolean
);


ALTER TYPE cms.type_galeria_imagenes_detalle_leer OWNER TO radiosan_ustaana;

--
-- Name: type_galeria_imagenes_leer; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_galeria_imagenes_leer AS (
	galeriaid integer,
	nombre character varying,
	descripcion text,
	publicacion date,
	imagenid integer,
	image_name character varying,
	estado boolean,
	unidadnegocioid integer,
	unidadnegocio_nombre character varying,
	count_images integer,
	visitas integer
);


ALTER TYPE cms.type_galeria_imagenes_leer OWNER TO radiosan_ustaana;

--
-- Name: type_galeria_imagenes_read_website; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_galeria_imagenes_read_website AS (
	galeriaid integer,
	nombre character varying,
	descripcion text,
	publicacion date,
	imagenid integer,
	image_name character varying,
	estado boolean,
	unidadnegocioid integer,
	unidadnegocio_nombre character varying,
	count_images integer,
	visitas integer
);


ALTER TYPE cms.type_galeria_imagenes_read_website OWNER TO radiosan_ustaana;

--
-- Name: type_galeria_imagenes_visitas_read; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_galeria_imagenes_visitas_read AS (
	visitaid integer,
	registro_text character varying,
	ip character varying,
	dedonde character varying,
	personaid integer,
	persona_nombre character varying
);


ALTER TYPE cms.type_galeria_imagenes_visitas_read OWNER TO radiosan_ustaana;

--
-- Name: type_gallery_getrow; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_gallery_getrow AS (
	galleryid integer,
	categoryid integer,
	category_name character varying,
	name character varying,
	description text,
	"order" integer,
	rotation integer,
	image character varying,
	count integer,
	status boolean,
	nextid integer,
	previousid integer
);


ALTER TYPE cms.type_gallery_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_gallery_query; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_gallery_query AS (
	galleryid integer,
	categoryid integer,
	category_name character varying,
	name character varying,
	description text,
	image character varying,
	rotation integer
);


ALTER TYPE cms.type_gallery_query OWNER TO radiosan_ustaana;

--
-- Name: type_gallery_read; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_gallery_read AS (
	galleryid integer,
	categoryid integer,
	category_name character varying,
	name character varying,
	description text,
	"order" integer,
	rotation integer,
	image character varying,
	count integer,
	status boolean
);


ALTER TYPE cms.type_gallery_read OWNER TO radiosan_ustaana;

--
-- Name: type_gallerycategory_query; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_gallerycategory_query AS (
	categoryid integer,
	name character varying,
	description text,
	count_gallery integer
);


ALTER TYPE cms.type_gallerycategory_query OWNER TO radiosan_ustaana;

--
-- Name: type_gallerycategory_read; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_gallerycategory_read AS (
	categoryid integer,
	name character varying,
	description text,
	"order" integer,
	status boolean,
	count_gallery integer
);


ALTER TYPE cms.type_gallerycategory_read OWNER TO radiosan_ustaana;

--
-- Name: type_galleryimages_query; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_galleryimages_query AS (
	galleryimagesid integer,
	name character varying,
	description character varying
);


ALTER TYPE cms.type_galleryimages_query OWNER TO radiosan_ustaana;

--
-- Name: type_galleryimages_read; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_galleryimages_read AS (
	galleryimagesid integer,
	galleryid integer,
	registro character varying,
	name character varying,
	description character varying,
	width integer,
	height integer,
	dpi integer,
	size integer,
	"order" integer,
	"default" boolean,
	status boolean,
	lastchange character varying
);


ALTER TYPE cms.type_galleryimages_read OWNER TO radiosan_ustaana;

--
-- Name: type_language_read; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_language_read AS (
	languageid integer,
	name character varying,
	nomenclature character varying,
	icon character varying,
	"order" integer,
	"default" boolean,
	status boolean
);


ALTER TYPE cms.type_language_read OWNER TO radiosan_ustaana;

--
-- Name: type_language_read_website; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_language_read_website AS (
	languageid integer,
	name character varying,
	nomenclature character varying,
	icon character varying,
	"default" boolean,
	webcontent_first_filename character varying
);


ALTER TYPE cms.type_language_read_website OWNER TO radiosan_ustaana;

--
-- Name: type_mailing_read; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_mailing_read AS (
	mailingid integer,
	server character varying,
	mailer character varying,
	password character varying,
	port character varying,
	encryption character varying,
	status boolean
);


ALTER TYPE cms.type_mailing_read OWNER TO radiosan_ustaana;

--
-- Name: type_noticia_leer; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_noticia_leer AS (
	noticiaid integer,
	titulo character varying,
	descripcion text,
	imagen character varying,
	galeriaid integer,
	galeria_nombre character varying,
	publicacion date,
	estado boolean,
	unidadnegocioid integer,
	unidad_negocio_nombre character varying,
	visitas integer
);


ALTER TYPE cms.type_noticia_leer OWNER TO radiosan_ustaana;

--
-- Name: type_noticia_query; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_noticia_query AS (
	noticiaid integer,
	titulo character varying,
	descripcion text,
	imagen character varying,
	galeriaid integer,
	nombre_galeria character varying,
	publicacion date,
	estado boolean,
	unidadnegocioid integer,
	unidad_negocio character varying,
	visitas integer
);


ALTER TYPE cms.type_noticia_query OWNER TO radiosan_ustaana;

--
-- Name: type_noticia_visitas_read; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_noticia_visitas_read AS (
	noticiaid integer,
	registro character varying,
	ip character varying,
	dedonde character varying,
	personaid integer,
	persona_nombre character varying
);


ALTER TYPE cms.type_noticia_visitas_read OWNER TO radiosan_ustaana;

--
-- Name: type_project_docs; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_project_docs AS (
	galleryid integer,
	name character varying,
	description text,
	size integer,
	uploaddate_text character varying
);


ALTER TYPE cms.type_project_docs OWNER TO radiosan_ustaana;

--
-- Name: type_project_query; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_project_query AS (
	projectid integer,
	name character varying,
	description text,
	projectcategoryid integer,
	projectcategory_name character varying,
	"order" integer,
	image_default character varying,
	count_images integer
);


ALTER TYPE cms.type_project_query OWNER TO radiosan_ustaana;

--
-- Name: type_project_read; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_project_read AS (
	projectid integer,
	name character varying,
	description text,
	projectcategoryid integer,
	projectcategory_name character varying,
	"order" integer,
	status boolean,
	image_default character varying,
	count_images integer,
	count_docs integer
);


ALTER TYPE cms.type_project_read OWNER TO radiosan_ustaana;

--
-- Name: type_projectcategory_query; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_projectcategory_query AS (
	projectcategoryid integer,
	name character varying,
	description text,
	image character varying,
	"order" integer,
	count_projects integer
);


ALTER TYPE cms.type_projectcategory_query OWNER TO radiosan_ustaana;

--
-- Name: type_projectcategory_read; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_projectcategory_read AS (
	projectcategoryid integer,
	name character varying,
	description text,
	image character varying,
	"order" integer,
	status boolean,
	count_projects integer
);


ALTER TYPE cms.type_projectcategory_read OWNER TO radiosan_ustaana;

--
-- Name: type_projectcategory_read_projects; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_projectcategory_read_projects AS (
	projectcategoryid integer,
	name character varying,
	count_projects integer
);


ALTER TYPE cms.type_projectcategory_read_projects OWNER TO radiosan_ustaana;

--
-- Name: type_projectphoto_read; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_projectphoto_read AS (
	projectphotoid integer,
	projectid integer,
	registro character varying,
	name character varying,
	description character varying,
	width integer,
	height integer,
	dpi integer,
	size integer,
	"order" integer,
	"default" boolean,
	status boolean,
	lastchange character varying
);


ALTER TYPE cms.type_projectphoto_read OWNER TO radiosan_ustaana;

--
-- Name: type_receiver_query; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_receiver_query AS (
	receiverid integer,
	name character varying,
	email character varying,
	unidadnegocioid integer,
	unidad_negocio character varying
);


ALTER TYPE cms.type_receiver_query OWNER TO radiosan_ustaana;

--
-- Name: type_receiver_read; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_receiver_read AS (
	receiverid integer,
	name character varying,
	email character varying,
	unidadnegocioid integer,
	unidad_negocio character varying,
	status boolean
);


ALTER TYPE cms.type_receiver_read OWNER TO radiosan_ustaana;

--
-- Name: type_webcontent_getfirst; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_webcontent_getfirst AS (
	webcontentid integer,
	filename character varying,
	caption character varying,
	description character varying,
	parentid integer
);


ALTER TYPE cms.type_webcontent_getfirst OWNER TO radiosan_ustaana;

--
-- Name: type_webcontent_query_all; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_webcontent_query_all AS (
	webcontentid integer,
	page boolean,
	filename character varying,
	caption character varying,
	description character varying,
	level integer,
	"order" integer,
	parentid integer,
	url character varying,
	target character varying
);


ALTER TYPE cms.type_webcontent_query_all OWNER TO radiosan_ustaana;

--
-- Name: type_webcontent_query_parents; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_webcontent_query_parents AS (
	webcontentid integer,
	filename character varying,
	name character varying,
	description character varying,
	parentid integer
);


ALTER TYPE cms.type_webcontent_query_parents OWNER TO radiosan_ustaana;

--
-- Name: type_webcontent_query_sitemap; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_webcontent_query_sitemap AS (
	webcontentid integer,
	filename character varying,
	parentid integer,
	parentid_0 integer,
	name_0 character varying
);


ALTER TYPE cms.type_webcontent_query_sitemap OWNER TO radiosan_ustaana;

--
-- Name: type_webcontent_read_all; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_webcontent_read_all AS (
	webcontentid integer,
	page boolean,
	filename character varying,
	caption character varying,
	description character varying,
	level integer,
	"order" integer,
	parentid integer,
	url character varying,
	target character varying
);


ALTER TYPE cms.type_webcontent_read_all OWNER TO radiosan_ustaana;

--
-- Name: type_webcontent_read_childs; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_webcontent_read_childs AS (
	webcontentid integer,
	filename character varying,
	filename_parent character varying,
	caption character varying,
	description character varying,
	page boolean,
	url character varying,
	level integer,
	"order" integer,
	parentid integer,
	status boolean,
	count_childs integer,
	count_images integer
);


ALTER TYPE cms.type_webcontent_read_childs OWNER TO radiosan_ustaana;

--
-- Name: type_webcontent_read_filename; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_webcontent_read_filename AS (
	webcontentid integer,
	filename character varying,
	caption character varying,
	description character varying,
	level integer,
	"order" integer,
	parentid integer
);


ALTER TYPE cms.type_webcontent_read_filename OWNER TO radiosan_ustaana;

--
-- Name: type_webcontent_read_parents; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_webcontent_read_parents AS (
	webcontentid integer,
	filename character varying,
	caption character varying,
	description character varying,
	level integer,
	"order" integer,
	parentid integer,
	status boolean,
	count_childs integer
);


ALTER TYPE cms.type_webcontent_read_parents OWNER TO radiosan_ustaana;

--
-- Name: type_webcontentcategory_read; Type: TYPE; Schema: cms; Owner: radiosan_ustaana
--

CREATE TYPE type_webcontentcategory_read AS (
	webcontentcategoryid integer,
	name character varying,
	"order" integer,
	status boolean
);


ALTER TYPE cms.type_webcontentcategory_read OWNER TO radiosan_ustaana;

SET search_path = contabilidad, pg_catalog;

--
-- Name: type_asiento_detalle_leer; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_asiento_detalle_leer AS (
	asientoid integer,
	orden integer,
	plan character varying,
	columna character varying,
	nombre_columna character varying,
	porcentaje numeric,
	debe_haber character varying
);


ALTER TYPE contabilidad.type_asiento_detalle_leer OWNER TO radiosan_ustaana;

--
-- Name: type_asiento_leer; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_asiento_leer AS (
	asientoid integer,
	nombre character varying,
	abreviatura character varying,
	modulo character varying
);


ALTER TYPE contabilidad.type_asiento_leer OWNER TO radiosan_ustaana;

--
-- Name: type_auditoria_validar_cuenta; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_auditoria_validar_cuenta AS (
	codigo integer,
	nombre character varying,
	ctas_1 character varying,
	total_ctas1 numeric,
	ctas_2 character varying,
	total_ctas2 numeric,
	total_diferencia numeric,
	ctas_3 character varying,
	total_ctas3 numeric,
	total_diferencia_2 numeric
);


ALTER TYPE contabilidad.type_auditoria_validar_cuenta OWNER TO radiosan_ustaana;

--
-- Name: type_auditoria_validar_cuenta_todas; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_auditoria_validar_cuenta_todas AS (
	codigo integer,
	nombre character varying,
	ctas_1 character varying,
	total_ctas1 numeric,
	ctas_2 character varying,
	total_ctas2 numeric,
	total_diferencia numeric,
	ctas_3 character varying,
	total_ctas3 numeric,
	total_diferencia2 numeric
);


ALTER TYPE contabilidad.type_auditoria_validar_cuenta_todas OWNER TO radiosan_ustaana;

--
-- Name: type_clasificacion_leer; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_clasificacion_leer AS (
	clasificacionid integer,
	nombre character varying,
	abreviatura character varying,
	estructura character varying,
	codigo_contable character varying,
	orden integer,
	estado boolean
);


ALTER TYPE contabilidad.type_clasificacion_leer OWNER TO radiosan_ustaana;

--
-- Name: type_configuracion_empresa_leer; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_configuracion_empresa_leer AS (
	empresaid integer,
	empresa_nombre character varying,
	igv numeric,
	codigo_asi_rc_sinigv integer,
	codigo_asi_rc_conigv integer,
	codigo_asi_rv_sinigv integer,
	codigo_asi_rv_conigv integer
);


ALTER TYPE contabilidad.type_configuracion_empresa_leer OWNER TO radiosan_ustaana;

--
-- Name: type_costo_moneda_getrow; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_costo_moneda_getrow AS (
	moneda character varying,
	fecha date,
	venta numeric,
	compra numeric,
	cobranza numeric
);


ALTER TYPE contabilidad.type_costo_moneda_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_costo_moneda_leer; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_costo_moneda_leer AS (
	moneda character varying,
	moneda_nombre character varying,
	moneda_simbolo character varying,
	fecha date,
	venta numeric,
	compra numeric,
	cobranza numeric
);


ALTER TYPE contabilidad.type_costo_moneda_leer OWNER TO radiosan_ustaana;

--
-- Name: type_libro_balance_comprobacion_leer; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_libro_balance_comprobacion_leer AS (
	numero character varying,
	nombre_pcgr character varying,
	debe numeric,
	haber numeric,
	saldo_deudor numeric,
	saldo_acreedor numeric,
	inventario_activo numeric,
	inventario_pasivo numeric,
	importe_perdida numeric,
	importe_ganancia numeric
);


ALTER TYPE contabilidad.type_libro_balance_comprobacion_leer OWNER TO radiosan_ustaana;

--
-- Name: type_libro_balance_general_leer; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_libro_balance_general_leer AS (
	grupo1 character varying,
	grupo2 character varying,
	numero character varying,
	nombre character varying,
	importe numeric
);


ALTER TYPE contabilidad.type_libro_balance_general_leer OWNER TO radiosan_ustaana;

--
-- Name: type_libro_mayor_leer; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_libro_mayor_leer AS (
	numero character varying,
	nombre_pcgr character varying,
	saldo_inicial numeric,
	debe numeric,
	haber numeric,
	saldo numeric
);


ALTER TYPE contabilidad.type_libro_mayor_leer OWNER TO radiosan_ustaana;

--
-- Name: type_libros_modulo_leer; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_libros_modulo_leer AS (
	codigo integer,
	modulosistemaid integer,
	modulosistema_nombre character varying,
	tipolibroid character varying,
	tipolibro_nombre character varying
);


ALTER TYPE contabilidad.type_libros_modulo_leer OWNER TO radiosan_ustaana;

--
-- Name: type_libros_varios_asiento_leer; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_libros_varios_asiento_leer AS (
	item integer,
	tipodocumentoid integer,
	documento character varying,
	numero character varying,
	glosa character varying,
	personaid integer,
	nombre_persona character varying,
	plan character varying,
	nombre_plan character varying,
	columna character varying,
	importe_debe numeric,
	importe_haber numeric,
	debe boolean
);


ALTER TYPE contabilidad.type_libros_varios_asiento_leer OWNER TO radiosan_ustaana;

--
-- Name: type_libros_varios_leer; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_libros_varios_leer AS (
	libvarid integer,
	numero_registro integer,
	codigo_tiplib character varying,
	tipo_libro character varying,
	fecha_emi date,
	anio integer,
	mes integer,
	nombre_mes character varying,
	numeros character varying,
	glosas character varying,
	moneda character varying,
	simbolo_moneda character varying,
	cambio numeric,
	usuario character varying,
	caja character varying,
	estado boolean,
	cerrado boolean,
	empresaid integer,
	empresa character varying,
	referencia character varying,
	codigo_ref1 integer,
	codigo_ref2 integer
);


ALTER TYPE contabilidad.type_libros_varios_leer OWNER TO radiosan_ustaana;

--
-- Name: type_pcgr_copiar; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_pcgr_copiar AS (
	cantidad integer,
	descripcion character varying
);


ALTER TYPE contabilidad.type_pcgr_copiar OWNER TO radiosan_ustaana;

--
-- Name: type_pcgr_getrow; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_pcgr_getrow AS (
	pcgrid integer,
	empresaid integer,
	empresa_nombre character varying,
	anio integer,
	tipocuentaid integer,
	tipocuenta_nombre character varying,
	numero character varying,
	nombre character varying,
	origen character varying,
	destino character varying,
	padre integer,
	nivel integer,
	ctacte character varying,
	codigo_res_nat character varying,
	codigo_res_fun character varying,
	tipoestfinid integer,
	tipoestfin_nombre character varying
);


ALTER TYPE contabilidad.type_pcgr_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_pcgr_leer; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_pcgr_leer AS (
	pcgrid integer,
	empresaid integer,
	empresa_nombre character varying,
	numero character varying,
	nombre character varying,
	origen character varying,
	destino character varying,
	padre integer,
	nivel integer,
	tipocuentaid integer,
	tipocuenta_nombre character varying,
	tipoestfinid integer,
	tipoestfin_nombre character varying
);


ALTER TYPE contabilidad.type_pcgr_leer OWNER TO radiosan_ustaana;

--
-- Name: type_registro_compras_asiento_leer; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_registro_compras_asiento_leer AS (
	plan character varying,
	columna character varying,
	importe_debe numeric,
	importe_haber numeric,
	debe boolean,
	usuario character varying,
	caja character varying
);


ALTER TYPE contabilidad.type_registro_compras_asiento_leer OWNER TO radiosan_ustaana;

--
-- Name: type_registro_compras_incluir; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_registro_compras_incluir AS (
	cantidad_incluidos integer,
	cantidad_noincluidos integer
);


ALTER TYPE contabilidad.type_registro_compras_incluir OWNER TO radiosan_ustaana;

--
-- Name: type_registro_compras_leer; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_registro_compras_leer AS (
	regcomid integer,
	nroreg integer,
	fecha date,
	anio integer,
	mes integer,
	nombre_mes character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	clasificacionid integer,
	clasificacion_nombre character varying,
	clasificacion_abreviatura character varying,
	numero character varying,
	personaid integer,
	persona_dniruc character varying,
	persona_nombre character varying,
	moneda character varying,
	moneda_simbolo character varying,
	importe_gravado numeric,
	importe_igv numeric,
	importe_percepcion numeric,
	importe_gratuito numeric,
	importe_exonerado numeric,
	importe_inafecto numeric,
	importe_total numeric,
	porcentaje_igv numeric,
	estado boolean,
	cerrado boolean,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying
);


ALTER TYPE contabilidad.type_registro_compras_leer OWNER TO radiosan_ustaana;

--
-- Name: type_registro_compras_resumen_bytipdoc; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_registro_compras_resumen_bytipdoc AS (
	tipodocumentoid integer,
	nombre character varying,
	cantidad integer,
	cantidad_incluidos integer,
	cantidad_noincluidos integer,
	numero_inicial character varying,
	numero_final character varying
);


ALTER TYPE contabilidad.type_registro_compras_resumen_bytipdoc OWNER TO radiosan_ustaana;

--
-- Name: type_registro_ventas_asiento_leer; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_registro_ventas_asiento_leer AS (
	plan character varying,
	columna character varying,
	importe_debe numeric,
	importe_haber numeric,
	debe boolean
);


ALTER TYPE contabilidad.type_registro_ventas_asiento_leer OWNER TO radiosan_ustaana;

--
-- Name: type_registro_ventas_incluir; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_registro_ventas_incluir AS (
	cantidad_incluidos integer,
	cantidad_noincluidos integer
);


ALTER TYPE contabilidad.type_registro_ventas_incluir OWNER TO radiosan_ustaana;

--
-- Name: type_registro_ventas_leer; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_registro_ventas_leer AS (
	regvenid integer,
	nroreg integer,
	fecha date,
	anio integer,
	mes integer,
	nombre_mes character varying,
	tipodocumentoid integer,
	numero character varying,
	personaid integer,
	persona_dniruc character varying,
	persona_nombre character varying,
	moneda character varying,
	moneda_simbolo character varying,
	importe_grabado numeric,
	importe_igv numeric,
	importe_percepcion numeric,
	importe_gratuito numeric,
	importe_exonerado numeric,
	importe_inafecto numeric,
	importe_total numeric,
	valor_igv numeric,
	condicion character varying,
	estado boolean,
	cerrado boolean,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying
);


ALTER TYPE contabilidad.type_registro_ventas_leer OWNER TO radiosan_ustaana;

--
-- Name: type_registro_ventas_resumen_bytipdoc; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_registro_ventas_resumen_bytipdoc AS (
	tipodocumentoid integer,
	nombre character varying,
	cantidad integer,
	cantidad_incluidos integer,
	cantidad_noincluidos integer,
	numero_inicial character varying,
	numero_final character varying
);


ALTER TYPE contabilidad.type_registro_ventas_resumen_bytipdoc OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_asiento_diario; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_asiento_diario AS (
	pcgr character varying,
	nombre_pcgr character varying,
	codigo_contable_doc character varying,
	numero character varying,
	glosa character varying,
	debe numeric,
	haber numeric,
	origen boolean
);


ALTER TYPE contabilidad.type_reporte_asiento_diario OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_libro_diario; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_libro_diario AS (
	libdiaid integer,
	numero_registro integer,
	fecha date,
	personaid integer,
	nombre_persona character varying,
	tipo_libro character varying,
	codigo_contable_libro character varying,
	nombre_libro character varying,
	item integer,
	numero_doc character varying,
	numero_pcgr character varying,
	nombre_pcgr character varying,
	importe_debe numeric,
	importe_haber numeric
);


ALTER TYPE contabilidad.type_reporte_libro_diario OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_libro_mayor_cabecera; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_libro_mayor_cabecera AS (
	cta_nivel1 character varying,
	nombre_nivel1 character varying,
	salini_deb_nivel1 numeric,
	salini_hab_nivel1 numeric,
	debe_nivel1 numeric,
	haber_nivel1 numeric,
	salfin_deb_nivel1 numeric,
	salfin_hab_nivel1 numeric,
	cta_nivel2 character varying,
	nombre_nivel2 character varying,
	salini_deb_nivel2 numeric,
	salini_hab_nivel2 numeric,
	debe_nivel2 numeric,
	haber_nivel2 numeric,
	salfin_deb_nivel2 numeric,
	salfin_hab_nivel2 numeric,
	cta_nivel3 character varying,
	nombre_nivel3 character varying,
	salini_deb_nivel3 numeric,
	salini_hab_nivel3 numeric,
	debe_nivel3 numeric,
	haber_nivel3 numeric,
	salfin_deb_nivel3 numeric,
	salfin_hab_nivel3 numeric,
	cta_nivel4 character varying,
	nombre_nivel4 character varying,
	salini_deb_nivel4 numeric,
	salini_hab_nivel4 numeric,
	debe_nivel4 numeric,
	haber_nivel4 numeric,
	salfin_deb_nivel4 numeric,
	salfin_hab_nivel4 numeric,
	cta_nivel5 character varying,
	nombre_nivel5 character varying,
	salini_deb_nivel5 numeric,
	salini_hab_nivel5 numeric,
	debe_nivel5 numeric,
	haber_nivel5 numeric,
	salfin_deb_nivel5 numeric,
	salfin_hab_nivel5 numeric
);


ALTER TYPE contabilidad.type_reporte_libro_mayor_cabecera OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_libro_mayor_detalle; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_libro_mayor_detalle AS (
	numero character varying,
	tipo_libro character varying,
	nro_reg integer,
	dia integer,
	codigo_contable character varying,
	numero_doc character varying,
	glosa character varying,
	debe_detalle numeric,
	haber_detalle numeric
);


ALTER TYPE contabilidad.type_reporte_libro_mayor_detalle OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_libro_mayor_resumen; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_libro_mayor_resumen AS (
	cta_nivel1 character varying,
	nombre_nivel1 character varying,
	saldo_inicial_nivel1 numeric,
	debe_nivel1 numeric,
	haber_nivel1 numeric,
	saldo_final_nivel1 numeric,
	cta_nivel2 character varying,
	nombre_nivel2 character varying,
	saldo_inicial_nivel2 numeric,
	debe_nivel2 numeric,
	haber_nivel2 numeric,
	saldo_final_nivel2 numeric,
	cta_nivel3 character varying,
	nombre_nivel3 character varying,
	saldo_inicial_nivel3 numeric,
	debe_nivel3 numeric,
	haber_nivel3 numeric,
	saldo_final_nivel3 numeric,
	cta_nivel4 character varying,
	nombre_nivel4 character varying,
	saldo_inicial_nivel4 numeric,
	debe_nivel4 numeric,
	haber_nivel4 numeric,
	saldo_final_nivel4 numeric,
	cta_nivel5 character varying,
	nombre_nivel5 character varying,
	saldo_inicial_nivel5 numeric,
	debe_nivel5 numeric,
	haber_nivel5 numeric,
	saldo_final_nivel5 numeric
);


ALTER TYPE contabilidad.type_reporte_libro_mayor_resumen OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_registro_compras; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_registro_compras AS (
	regcomid integer,
	nroreg integer,
	fecha character varying,
	vencimiento character varying,
	tipodocumento_codigo character varying,
	serie character varying,
	numero character varying,
	persona_tipdoc character varying,
	persona_dniruc character varying,
	persona_nombre character varying,
	importe_gravado numeric,
	importe_gravado_cdcf numeric,
	importe_gravado_sdcf numeric,
	importe_gravado_xapl numeric,
	importe_igv numeric,
	importe_igv_cdcf numeric,
	importe_igv_sdcf numeric,
	importe_igv_xapl numeric,
	importe_exonerado numeric,
	importe_inafecto numeric,
	importe_gratuito numeric,
	importe_percepcion numeric,
	importe_total numeric,
	cambio numeric,
	emision date,
	notascd_fecha character varying,
	notascd_tipodocumento_codigo character varying,
	notascd_serie character varying,
	notascd_numero character varying,
	detraccion_numero character varying,
	detraccion_fecha character varying,
	estadoregistro integer,
	codigo_libdia integer,
	porcentaje_igv numeric
);


ALTER TYPE contabilidad.type_reporte_registro_compras OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_registro_compras_percepcion; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_registro_compras_percepcion AS (
	regcomid integer,
	nroreg integer,
	fecha character varying,
	vencimiento character varying,
	tipodocumento_codigo character varying,
	serie character varying,
	numero character varying,
	persona_tipdoc character varying,
	persona_dniruc character varying,
	persona_nombre character varying,
	importe_percepcion numeric,
	importe_total numeric,
	moneda character varying,
	moneda_simbolo character varying,
	moneda_codigo character varying,
	cambio numeric
);


ALTER TYPE contabilidad.type_reporte_registro_compras_percepcion OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_registro_compras_ple; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_registro_compras_ple AS (
	regcomid integer,
	nroreg integer,
	fecha character varying,
	vencimiento character varying,
	tipodocumento_codigo character varying,
	serie character varying,
	numero character varying,
	persona_tipdoc character varying,
	persona_dniruc character varying,
	persona_nombre character varying,
	importe_gravado numeric,
	importe_gravado_cdcf numeric,
	importe_gravado_sdcf numeric,
	importe_gravado_xapl numeric,
	importe_igv numeric,
	importe_igv_cdcf numeric,
	importe_igv_sdcf numeric,
	importe_igv_xapl numeric,
	importe_exonerado numeric,
	importe_inafecto numeric,
	importe_gratuito numeric,
	importe_percepcion numeric,
	importe_total numeric,
	cambio numeric,
	emision date,
	notascd_fecha character varying,
	notascd_tipodocumento_codigo character varying,
	notascd_serie character varying,
	notascd_numero character varying,
	detraccion_numero character varying,
	detraccion_fecha character varying,
	estadoregistro integer,
	codigo_libdia integer
);


ALTER TYPE contabilidad.type_reporte_registro_compras_ple OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_registro_ventas; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_registro_ventas AS (
	regvenid integer,
	nroreg integer,
	fecha character varying,
	vencimiento character varying,
	tipodocumento_codigo character varying,
	serie character varying,
	numero1 character varying,
	numero2 character varying,
	persona_tipdoc character varying,
	persona_dniruc character varying,
	persona_nombre character varying,
	importe_gravado numeric,
	importe_gravado_cdcf numeric,
	importe_gravado_sdcf numeric,
	importe_gravado_xapl numeric,
	importe_igv numeric,
	importe_igv_cdcf numeric,
	importe_igv_sdcf numeric,
	importe_igv_xapl numeric,
	importe_exonerado numeric,
	importe_inafecto numeric,
	importe_gratuito numeric,
	importe_percepcion numeric,
	importe_total numeric,
	cambio numeric,
	emision date,
	notascd_fecha character varying,
	notascd_tipodocumento_codigo character varying,
	notascd_serie character varying,
	notascd_numero character varying,
	estadoregistro integer,
	codigo_libdia integer
);


ALTER TYPE contabilidad.type_reporte_registro_ventas OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_registro_ventas_concar; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_registro_ventas_concar AS (
	regvenid integer,
	nroreg integer,
	mes_nroreg character varying,
	fecha character varying,
	vencimiento character varying,
	tipodocumento_codigo character varying,
	numero character varying,
	serie character varying,
	numero1 character varying,
	numero2 character varying,
	persona_tipdoc character varying,
	persona_dniruc character varying,
	persona_nombre character varying,
	orden integer,
	plan_librodiario character varying,
	plan character varying,
	glosa character varying,
	importe numeric,
	importe_monbas numeric,
	importe_monext numeric,
	debe_haber character varying,
	moneda character varying,
	moneda_codigo character varying,
	cambio numeric,
	cambio_tipo character varying,
	conversion character varying,
	emision date,
	notascd_fecha character varying,
	notascd_tipodocumento_codigo character varying,
	notascd_serie character varying,
	notascd_numero character varying,
	estadoregistro integer,
	codigo_libdia integer
);


ALTER TYPE contabilidad.type_reporte_registro_ventas_concar OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_registro_ventas_fechas; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_registro_ventas_fechas AS (
	regvenid integer,
	numero_registro integer,
	fecha character varying,
	vencimiento character varying,
	codigo_contable character varying,
	serie character varying,
	numero1 character varying,
	numero2 character varying,
	tipo_doc_persona character varying,
	numero_doc_per character varying,
	nombre_persona character varying,
	bas_imp numeric,
	bas_imp_cdcf numeric,
	bas_imp_sdcf numeric,
	bas_imp_xapl numeric,
	igv numeric,
	igv_cdcf numeric,
	igv_sdcf numeric,
	igv_xapl numeric,
	imp_exo numeric,
	imp_inafecto numeric,
	imp_gratuito numeric,
	imp_perc numeric,
	imp_detrac numeric,
	importe_total numeric,
	tipmon_codigo_contable character varying,
	cambio numeric,
	detrac_numero character varying,
	detrac_fecha character varying,
	detract_cambio numeric,
	doc_ori_fecha character varying,
	doc_ori_cod character varying,
	doc_ori_serie character varying,
	doc_ori_numero character varying,
	emision date,
	nc_fecha character varying,
	nc_tipodocumentoid character varying,
	nc_serie character varying,
	nc_numero character varying,
	estadoregistro integer,
	codigo_libdia integer
);


ALTER TYPE contabilidad.type_reporte_registro_ventas_fechas OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_registro_ventas_ple; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_registro_ventas_ple AS (
	regvenid integer,
	nroreg integer,
	periodo character varying,
	fecha character varying,
	vencimiento character varying,
	tipodocumento_codigo character varying,
	serie character varying,
	numero1 character varying,
	numero2 character varying,
	persona_tipdoc character varying,
	persona_dniruc character varying,
	persona_nombre character varying,
	importe_gravado numeric,
	importe_gravado_cdcf numeric,
	importe_gravado_sdcf numeric,
	importe_gravado_xapl numeric,
	importe_igv numeric,
	importe_igv_cdcf numeric,
	importe_igv_sdcf numeric,
	importe_igv_xapl numeric,
	importe_exonerado numeric,
	importe_inafecto numeric,
	importe_gratuito numeric,
	importe_percepcion numeric,
	importe_total numeric,
	cambio numeric,
	moneda character varying,
	moneda_nombre character varying,
	moneda_simbolo character varying,
	moneda_codigo character varying,
	emision date,
	notascd_fecha character varying,
	notascd_tipodocumento_codigo character varying,
	notascd_serie character varying,
	notascd_numero character varying,
	estadoregistro integer,
	codigo_libdia integer
);


ALTER TYPE contabilidad.type_reporte_registro_ventas_ple OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_resultados_funcion; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_resultados_funcion AS (
	codigo_grupo character varying,
	nombre_grupo character varying,
	codigo_detalle character varying,
	nombre_detalle character varying,
	importe numeric
);


ALTER TYPE contabilidad.type_reporte_resultados_funcion OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_resultados_naturaleza; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_resultados_naturaleza AS (
	codigo_grupo character varying,
	nombre_grupo character varying,
	codigo_detalle character varying,
	nombre_detalle character varying,
	importe numeric
);


ALTER TYPE contabilidad.type_reporte_resultados_naturaleza OWNER TO radiosan_ustaana;

--
-- Name: type_tablas_auxiliares_leer; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_tablas_auxiliares_leer AS (
	grupo character varying,
	subgrupo character varying,
	descripcion character varying,
	abreviatura character varying,
	orden integer,
	estado boolean,
	referencia character varying
);


ALTER TYPE contabilidad.type_tablas_auxiliares_leer OWNER TO radiosan_ustaana;

--
-- Name: type_tipo_base_imponible_leer; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_tipo_base_imponible_leer AS (
	tipoid integer,
	nombre character varying,
	abreviatura character varying,
	estructura character varying,
	codigo_contable character varying,
	orden integer,
	estado boolean
);


ALTER TYPE contabilidad.type_tipo_base_imponible_leer OWNER TO radiosan_ustaana;

--
-- Name: type_tipo_estfin_leer; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_tipo_estfin_leer AS (
	tipoestfinid integer,
	nombre character varying,
	abreviatura character varying,
	tipo character varying,
	orden integer,
	estado boolean
);


ALTER TYPE contabilidad.type_tipo_estfin_leer OWNER TO radiosan_ustaana;

--
-- Name: type_tipo_libro_leer; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_tipo_libro_leer AS (
	tipolibroid character varying,
	nombre character varying,
	abreviatura character varying,
	tipo character varying,
	codigo_contable character varying,
	codigo_ple character varying,
	orden integer
);


ALTER TYPE contabilidad.type_tipo_libro_leer OWNER TO radiosan_ustaana;

--
-- Name: type_tipo_metodo_valuacion_leer; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_tipo_metodo_valuacion_leer AS (
	tipmetvalid integer,
	nombre character varying,
	abreviatura character varying,
	codigo_contable character varying,
	orden integer,
	estado boolean
);


ALTER TYPE contabilidad.type_tipo_metodo_valuacion_leer OWNER TO radiosan_ustaana;

--
-- Name: type_tipocuenta_leer; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_tipocuenta_leer AS (
	tipocuentaid integer,
	nombre character varying,
	abreviatura character varying,
	tipo character varying,
	orden integer,
	estado boolean
);


ALTER TYPE contabilidad.type_tipocuenta_leer OWNER TO radiosan_ustaana;

--
-- Name: type_tipodocumento_leer; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_tipodocumento_leer AS (
	tipodocumentoid integer,
	nombre character varying,
	abreviatura character varying,
	codigocontable character varying,
	caracter_contable character varying,
	signo character varying,
	calcular_igv boolean,
	tipdocper character varying,
	cantidad_series integer
);


ALTER TYPE contabilidad.type_tipodocumento_leer OWNER TO radiosan_ustaana;

--
-- Name: type_tipodocumento_leer_sistema; Type: TYPE; Schema: contabilidad; Owner: radiosan_ustaana
--

CREATE TYPE type_tipodocumento_leer_sistema AS (
	tipodocumentoid integer,
	nombre character varying,
	abreviatura character varying,
	codigocontable character varying,
	caracter_contable character varying,
	signo character varying,
	calcular_igv boolean,
	tipdocper character varying
);


ALTER TYPE contabilidad.type_tipodocumento_leer_sistema OWNER TO radiosan_ustaana;

SET search_path = docs, pg_catalog;

--
-- Name: type_category_read; Type: TYPE; Schema: docs; Owner: radiosan_ustaana
--

CREATE TYPE type_category_read AS (
	categoryid integer,
	name character varying,
	count_docs integer
);


ALTER TYPE docs.type_category_read OWNER TO radiosan_ustaana;

--
-- Name: type_format_read; Type: TYPE; Schema: docs; Owner: radiosan_ustaana
--

CREATE TYPE type_format_read AS (
	formatid integer,
	name character varying,
	description text,
	extension character varying,
	count_docs integer
);


ALTER TYPE docs.type_format_read OWNER TO radiosan_ustaana;

--
-- Name: type_gallery_keyword_read; Type: TYPE; Schema: docs; Owner: radiosan_ustaana
--

CREATE TYPE type_gallery_keyword_read AS (
	keywordid integer,
	keyword_name character varying
);


ALTER TYPE docs.type_gallery_keyword_read OWNER TO radiosan_ustaana;

--
-- Name: type_gallery_read; Type: TYPE; Schema: docs; Owner: radiosan_ustaana
--

CREATE TYPE type_gallery_read AS (
	galleryid integer,
	name character varying,
	description text,
	uploaddate_text character varying,
	size integer,
	categoryid integer,
	category_name character varying,
	formatid integer,
	format_name character varying,
	keywords text
);


ALTER TYPE docs.type_gallery_read OWNER TO radiosan_ustaana;

--
-- Name: type_gallery_read_ids; Type: TYPE; Schema: docs; Owner: radiosan_ustaana
--

CREATE TYPE type_gallery_read_ids AS (
	galleryid integer,
	name character varying,
	description text,
	size integer,
	uploaddate_text character varying
);


ALTER TYPE docs.type_gallery_read_ids OWNER TO radiosan_ustaana;

--
-- Name: type_keyword_read; Type: TYPE; Schema: docs; Owner: radiosan_ustaana
--

CREATE TYPE type_keyword_read AS (
	keywordid integer,
	name character varying,
	count_docs integer
);


ALTER TYPE docs.type_keyword_read OWNER TO radiosan_ustaana;

SET search_path = forms, pg_catalog;

--
-- Name: type_contactus_getrow; Type: TYPE; Schema: forms; Owner: radiosan_ustaana
--

CREATE TYPE type_contactus_getrow AS (
	contactusid integer,
	registro character varying,
	nombre character varying,
	email character varying,
	telefono character varying,
	tema character varying,
	mensaje text
);


ALTER TYPE forms.type_contactus_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_contactus_read; Type: TYPE; Schema: forms; Owner: radiosan_ustaana
--

CREATE TYPE type_contactus_read AS (
	contactusid integer,
	registro character varying,
	nombre character varying,
	email character varying,
	telefono character varying,
	tema character varying,
	mensaje text
);


ALTER TYPE forms.type_contactus_read OWNER TO radiosan_ustaana;

SET search_path = images, pg_catalog;

--
-- Name: type_category_read; Type: TYPE; Schema: images; Owner: radiosan_ustaana
--

CREATE TYPE type_category_read AS (
	categoryid integer,
	name character varying,
	count_images integer
);


ALTER TYPE images.type_category_read OWNER TO radiosan_ustaana;

--
-- Name: type_format_read; Type: TYPE; Schema: images; Owner: radiosan_ustaana
--

CREATE TYPE type_format_read AS (
	formatid integer,
	name character varying,
	description text,
	extension character varying,
	count_images integer
);


ALTER TYPE images.type_format_read OWNER TO radiosan_ustaana;

--
-- Name: type_gallery_keyword_read; Type: TYPE; Schema: images; Owner: radiosan_ustaana
--

CREATE TYPE type_gallery_keyword_read AS (
	keywordid integer,
	keyword_name character varying
);


ALTER TYPE images.type_gallery_keyword_read OWNER TO radiosan_ustaana;

--
-- Name: type_gallery_read; Type: TYPE; Schema: images; Owner: radiosan_ustaana
--

CREATE TYPE type_gallery_read AS (
	galleryid integer,
	name character varying,
	description text,
	uploaddate_text character varying,
	width integer,
	height integer,
	size integer,
	dpi integer,
	categoryid integer,
	category_name character varying,
	formatid integer,
	format_name character varying,
	keywords text
);


ALTER TYPE images.type_gallery_read OWNER TO radiosan_ustaana;

--
-- Name: type_keyword_read; Type: TYPE; Schema: images; Owner: radiosan_ustaana
--

CREATE TYPE type_keyword_read AS (
	keywordid integer,
	name character varying,
	count_images integer
);


ALTER TYPE images.type_keyword_read OWNER TO radiosan_ustaana;

SET search_path = inventarios, pg_catalog;

--
-- Name: type_certificadodigital_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_certificadodigital_leer AS (
	certificadoid integer,
	nombre character varying,
	archivo character varying,
	clave character varying,
	alias character varying,
	firmaid integer,
	firma_codigo character varying,
	firma_ruc character varying,
	firma_nombre character varying
);


ALTER TYPE inventarios.type_certificadodigital_leer OWNER TO radiosan_ustaana;

--
-- Name: type_configuracion_leer_valores; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_configuracion_leer_valores AS (
	codigo integer,
	valor_char character varying,
	valor_int integer,
	valor_numeric numeric
);


ALTER TYPE inventarios.type_configuracion_leer_valores OWNER TO radiosan_ustaana;

--
-- Name: type_configuracion_venta_limite_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_configuracion_venta_limite_leer AS (
	almacenid integer,
	almacen character varying,
	tipodocumentoid integer,
	documento character varying,
	importe numeric
);


ALTER TYPE inventarios.type_configuracion_venta_limite_leer OWNER TO radiosan_ustaana;

--
-- Name: type_configuracion_venta_rango_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_configuracion_venta_rango_leer AS (
	almacenid integer,
	almacen character varying,
	tipodocumentoid integer,
	documento character varying,
	importe_min numeric,
	importe_max numeric
);


ALTER TYPE inventarios.type_configuracion_venta_rango_leer OWNER TO radiosan_ustaana;

--
-- Name: type_conversion_getrow; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_conversion_getrow AS (
	conversionid integer,
	registro character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	productoorigenid integer,
	productoorigen_nombre character varying,
	productoorigen_abreviatura character varying,
	cantidad_origen integer,
	productodestinoid integer,
	productodestino_nombre character varying,
	productodestino_abreviatura character varying,
	cantidad_destino integer,
	ingresoid integer,
	salidaid integer,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_sexo character varying,
	usuario_foto character varying,
	usuario_usuario character varying,
	caja character varying,
	estado boolean,
	cerrado boolean
);


ALTER TYPE inventarios.type_conversion_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_conversion_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_conversion_leer AS (
	conversionid integer,
	registro character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	productoorigenid integer,
	productoorigen_nombre character varying,
	productoorigen_abreviatura character varying,
	cantidad_origen integer,
	productodestinoid integer,
	productodestino_nombre character varying,
	productodestino_abreviatura character varying,
	cantidad_destino integer,
	ingresoid integer,
	salidaid integer,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_sexo character varying,
	usuario_foto character varying,
	usuario_usuario character varying,
	caja character varying,
	estado boolean,
	cerrado boolean
);


ALTER TYPE inventarios.type_conversion_leer OWNER TO radiosan_ustaana;

--
-- Name: type_correlativos_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_correlativos_leer AS (
	tipo character varying,
	tipo_nombre character varying,
	keyid1 integer,
	keyid1_nombre character varying,
	keyid2 integer,
	keyid2_nombre character varying,
	keyid3 integer,
	keyid3_nombre character varying,
	correlativo integer
);


ALTER TYPE inventarios.type_correlativos_leer OWNER TO radiosan_ustaana;

--
-- Name: type_detalle_movimiento_mercaderia_leer_documentos; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_detalle_movimiento_mercaderia_leer_documentos AS (
	codigo integer,
	modulosistemaid integer,
	tipmovmerid integer,
	movimiento character varying,
	tipodocumentoid integer,
	documento character varying,
	signo character varying,
	incluir_referencia boolean,
	columna_descuento boolean
);


ALTER TYPE inventarios.type_detalle_movimiento_mercaderia_leer_documentos OWNER TO radiosan_ustaana;

--
-- Name: type_detalle_movimiento_mercaderia_leer_documentos_venta; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_detalle_movimiento_mercaderia_leer_documentos_venta AS (
	codigo integer,
	documento character varying,
	abreviatura character varying,
	columna_descuento boolean,
	incluir_referencia boolean,
	signo character varying
);


ALTER TYPE inventarios.type_detalle_movimiento_mercaderia_leer_documentos_venta OWNER TO radiosan_ustaana;

--
-- Name: type_detalle_movimiento_mercaderia_leer_movimientos; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_detalle_movimiento_mercaderia_leer_movimientos AS (
	tipmovmerid integer,
	nombre character varying,
	modulosistemaid integer
);


ALTER TYPE inventarios.type_detalle_movimiento_mercaderia_leer_movimientos OWNER TO radiosan_ustaana;

--
-- Name: type_firmadigital_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_firmadigital_leer AS (
	firmaid integer,
	codigo character varying,
	ruc character varying,
	nombre character varying,
	url character varying,
	resolucion character varying,
	valido_desde date,
	valido_hasta date
);


ALTER TYPE inventarios.type_firmadigital_leer OWNER TO radiosan_ustaana;

--
-- Name: type_firmador_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_firmador_leer AS (
	firmadorid integer,
	nombre character varying,
	archivo character varying,
	nombre_archivo character varying
);


ALTER TYPE inventarios.type_firmador_leer OWNER TO radiosan_ustaana;

--
-- Name: type_ganancias_metas_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ganancias_metas_leer AS (
	vendedorid integer,
	vendedor_nombre character varying,
	importe numeric
);


ALTER TYPE inventarios.type_ganancias_metas_leer OWNER TO radiosan_ustaana;

--
-- Name: type_ganancias_metas_leer_fechas; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ganancias_metas_leer_fechas AS (
	fecha date,
	fecha_larga character varying,
	fecha_corta character varying
);


ALTER TYPE inventarios.type_ganancias_metas_leer_fechas OWNER TO radiosan_ustaana;

--
-- Name: type_guia_getdataitem_edit; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_guia_getdataitem_edit AS (
	stock_actual numeric,
	existe boolean,
	cantidad numeric,
	peso numeric,
	producto_peso numeric
);


ALTER TYPE inventarios.type_guia_getdataitem_edit OWNER TO radiosan_ustaana;

--
-- Name: type_guia_getrow; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_guia_getrow AS (
	guiaid integer,
	registro character varying,
	tipo integer,
	empresaid integer,
	empresa_nombre character varying,
	almacenid integer,
	almacen_nombre character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	tipodocumento_codigocontable character varying,
	tipodocumento_caracter_contable character varying,
	numero character varying,
	clienteid integer,
	cliente_tipo character varying,
	cliente_razsoc character varying,
	cliente_direccion character varying,
	cliente_ruc character varying,
	cliente_sexo character varying,
	cliente_foto character varying,
	fecha_emision date,
	fecha_traslado date,
	hora_traslado time without time zone,
	hora_traslado_text character varying,
	lugar_desde character varying,
	lugar_hasta character varying,
	emptransid integer,
	emptrans_nombre character varying,
	emptrans_direccion character varying,
	emptrans_ruc character varying,
	marca_placa character varying,
	choferid integer,
	chofer_nombre character varying,
	chofer_dni character varying,
	chofer_sexo character varying,
	chofer_foto character varying,
	licencia character varying,
	constancia character varying,
	impresiones integer,
	reservado boolean,
	cerrado boolean,
	vendedorid integer,
	vendedor_nombre character varying,
	vendedor_sexo character varying,
	vendedor_foto character varying,
	vendedor_usuario character varying,
	observacion character varying,
	caja character varying,
	estado boolean,
	referencias character varying,
	cantidad_referencias integer
);


ALTER TYPE inventarios.type_guia_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_guia_imprimir_cabecera; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_guia_imprimir_cabecera AS (
	guiaid integer,
	registro character varying,
	tipo integer,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	empresa_direccion character varying,
	empresa_ruc character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	tipodocumento_codigocontable character varying,
	tipodocumento_caracter_contable character varying,
	numero character varying,
	clienteid integer,
	cliente_tipo character varying,
	cliente_razsoc character varying,
	cliente_direccion character varying,
	cliente_ruc character varying,
	cliente_sexo character varying,
	cliente_foto character varying,
	fecha_emision character varying,
	fecha_traslado character varying,
	hora_traslado character varying,
	lugar_desde character varying,
	lugar_hasta character varying,
	emptransid integer,
	emptrans_nombre character varying,
	emptrans_direccion character varying,
	emptrans_ruc character varying,
	marca_placa character varying,
	choferid integer,
	chofer_nombre character varying,
	chofer_dni character varying,
	chofer_sexo character varying,
	chofer_foto character varying,
	licencia character varying,
	constancia character varying,
	impresiones integer,
	reservado boolean,
	cerrado boolean,
	vendedorid integer,
	vendedor_nombre character varying,
	vendedor_sexo character varying,
	vendedor_foto character varying,
	vendedor_usuario character varying,
	observacion text,
	caja character varying,
	estado boolean,
	referencias text,
	pesototal numeric,
	totalcantidad numeric
);


ALTER TYPE inventarios.type_guia_imprimir_cabecera OWNER TO radiosan_ustaana;

--
-- Name: type_guia_imprimir_detalle; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_guia_imprimir_detalle AS (
	guiaid integer,
	productoid integer,
	producto character varying,
	cantidad numeric,
	peso numeric,
	peso_subtotal numeric,
	item integer,
	observacion text,
	unidadmedida character varying
);


ALTER TYPE inventarios.type_guia_imprimir_detalle OWNER TO radiosan_ustaana;

--
-- Name: type_guia_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_guia_leer AS (
	guiaid integer,
	tipo integer,
	empresaid integer,
	empresa_nombre character varying,
	almacenid integer,
	almacen_nombre character varying,
	fecha_emision date,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	numero character varying,
	clienteid integer,
	cliente_tipo character varying,
	cliente_nrodoc character varying,
	cliente_nombre character varying,
	cliente_foto character varying,
	cliente_sexo character varying,
	referencias character varying,
	fecha_traslado date,
	hora_traslado character varying,
	lugar_hasta character varying,
	emptransid integer,
	emptrans_nombre character varying,
	emptrans_ruc character varying,
	emptrans_foto character varying,
	emptrans_sexo character varying,
	choferid integer,
	chofer_nombre character varying,
	chofer_foto character varying,
	chofer_sexo character varying,
	vendedorid integer,
	vendedor_nombre character varying,
	vendedor_foto character varying,
	vendedor_sexo character varying,
	caja character varying,
	impresiones integer,
	estado boolean,
	cerrado boolean
);


ALTER TYPE inventarios.type_guia_leer OWNER TO radiosan_ustaana;

--
-- Name: type_guia_leer_detalle_referencias; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_guia_leer_detalle_referencias AS (
	guiaid integer,
	ventaid integer,
	almacenid integer,
	almacen_nombe character varying,
	almacen_abreviatura character varying,
	clienteid integer,
	cliente_ruc character varying,
	cliente_nombre character varying,
	numero character varying,
	estado boolean
);


ALTER TYPE inventarios.type_guia_leer_detalle_referencias OWNER TO radiosan_ustaana;

--
-- Name: type_guia_leer_items; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_guia_leer_items AS (
	guiaid integer,
	productoid integer,
	producto character varying,
	cantidad numeric,
	peso numeric,
	peso_subtotal numeric,
	item integer,
	observacion text
);


ALTER TYPE inventarios.type_guia_leer_items OWNER TO radiosan_ustaana;

--
-- Name: type_ingreso_consulta; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ingreso_consulta AS (
	ingresoid integer,
	registro character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	correlativo integer,
	fecha date,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	numero character varying,
	numero_detalle character varying,
	proveedorid integer,
	proveedor_nombre character varying,
	proveedor_foto character varying,
	proveedor_sexo character varying,
	moneda character varying,
	moneda_nombre character varying,
	moneda_simbolo character varying,
	total numeric,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	usuario_usuario character varying,
	caja character varying,
	estado boolean
);


ALTER TYPE inventarios.type_ingreso_consulta OWNER TO radiosan_ustaana;

--
-- Name: type_ingreso_detalle_porreferencia; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ingreso_detalle_porreferencia AS (
	ingresoid integer,
	registro character varying,
	fecha date,
	zonaid integer,
	zona_nombre character varying,
	zona_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	correlativo integer,
	numero_detalle character varying,
	productoid integer,
	producto_nombre character varying,
	producto_abreviatura character varying,
	moneda character varying,
	moneda_simbolo character varying,
	cantidad numeric,
	precio numeric,
	total numeric
);


ALTER TYPE inventarios.type_ingreso_detalle_porreferencia OWNER TO radiosan_ustaana;

--
-- Name: type_ingreso_getdataitem_edit; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ingreso_getdataitem_edit AS (
	stock_actual numeric,
	existe boolean,
	cantidad numeric,
	existe_referencia boolean,
	saldo numeric,
	precio_va numeric,
	utilidad numeric
);


ALTER TYPE inventarios.type_ingreso_getdataitem_edit OWNER TO radiosan_ustaana;

--
-- Name: type_ingreso_getrow; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ingreso_getrow AS (
	ingresoid integer,
	registro character varying,
	empresaid integer,
	empresa_nombre character varying,
	almacenid integer,
	almacen_nombre character varying,
	correlativo integer,
	tipmovmerid integer,
	tipmovmer_nombre character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	numero character varying,
	personaid integer,
	persona_tipo character varying,
	persona_nombre character varying,
	persona_direccion character varying,
	persona_ruc character varying,
	persona_sexo character varying,
	persona_foto character varying,
	fecha date,
	moneda character varying,
	moneda_nombre character varying,
	moneda_simbolo character varying,
	moneda_codigo_contable character varying,
	valor_igv numeric,
	total numeric,
	cambio numeric,
	cerrado boolean,
	observacion text,
	referencia character varying,
	referenciaid1 integer,
	referenciaid2 integer,
	referencia_detalle character varying,
	referenciatexto character varying,
	referenciafecha character varying,
	guiatransporteid integer,
	guiatransporte_detalle character varying,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_sexo character varying,
	usuario_foto character varying,
	usuario_usuario character varying,
	caja character varying,
	estado boolean
);


ALTER TYPE inventarios.type_ingreso_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_ingreso_imprimir_cabecera; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ingreso_imprimir_cabecera AS (
	ingresoid integer,
	registro character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	empresa_direccion character varying,
	empresa_ruc character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	correlativo integer,
	correlativo_texto character varying,
	tipmovmerid integer,
	tipmovmer_nombre character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	numero character varying,
	personaid integer,
	persona_nombre character varying,
	persona_direccion character varying,
	persona_ruc character varying,
	persona_sexo character varying,
	persona_foto character varying,
	persona_telefono character varying,
	persona_email character varying,
	fecha character varying,
	moneda character varying,
	moneda_nombre character varying,
	moneda_simbolo character varying,
	moneda_codigo_contable character varying,
	total numeric,
	cambio numeric,
	cerrado boolean,
	observacion text,
	referencia character varying,
	referenciaid1 integer,
	referenciaid2 integer,
	referencia_detalle character varying,
	referenciatexto character varying,
	referencia_numero character varying,
	referencia_fecha character varying,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_sexo character varying,
	usuario_foto character varying,
	usuario_usuario character varying,
	caja character varying,
	estado boolean
);


ALTER TYPE inventarios.type_ingreso_imprimir_cabecera OWNER TO radiosan_ustaana;

--
-- Name: type_ingreso_imprimir_detalle; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ingreso_imprimir_detalle AS (
	ingresoid integer,
	productoid integer,
	producto_nombre character varying,
	producto_abreviatura character varying,
	unidadmedidaid integer,
	unidadmedida_nombre character varying,
	unidadmedida_abreviatura character varying,
	cantidad numeric,
	bonificacion numeric,
	precio numeric,
	item smallint,
	observacion text,
	total numeric
);


ALTER TYPE inventarios.type_ingreso_imprimir_detalle OWNER TO radiosan_ustaana;

--
-- Name: type_ingreso_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ingreso_leer AS (
	ingresoid integer,
	zonaid integer,
	zona_nombre character varying,
	zona_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	tipomovimientoid integer,
	tipomovimiento_nombre character varying,
	correlativo integer,
	fecha date,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	numero character varying,
	personaid integer,
	persona_dniruc character varying,
	persona_nombre character varying,
	persona_sexo character varying,
	persona_foto character varying,
	moneda character varying,
	simbolo_moneda character varying,
	total numeric,
	cambio numeric,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_sexo character varying,
	usuario_foto character varying,
	usuario_usuario character varying,
	caja character varying,
	estado boolean,
	cerrado boolean,
	observacion text,
	referencia character varying,
	referenciaid1 integer,
	referenciaid2 integer,
	referencia_texto character varying
);


ALTER TYPE inventarios.type_ingreso_leer OWNER TO radiosan_ustaana;

--
-- Name: type_ingreso_leer_gasto; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ingreso_leer_gasto AS (
	ingresoid integer,
	item integer,
	tipogastoid integer,
	tipogasto_nombre character varying,
	tipogasto_abreviatura character varying,
	moneda character varying,
	moneda_nombre character varying,
	moneda_simbolo character varying,
	importe numeric,
	cambio numeric,
	observacion text
);


ALTER TYPE inventarios.type_ingreso_leer_gasto OWNER TO radiosan_ustaana;

--
-- Name: type_ingreso_leer_items; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ingreso_leer_items AS (
	ingresoid integer,
	productoid integer,
	producto_nombre character varying,
	producto_abreviatura character varying,
	cantidad numeric,
	bonificacion numeric,
	precio numeric,
	item smallint,
	observacion text,
	total numeric,
	existe_origen boolean,
	gratuito boolean,
	descuento1 numeric,
	descuento2 numeric,
	descuento3 numeric,
	descuento numeric,
	gravado boolean,
	precio_compra numeric,
	tipocalculo integer,
	lote character varying,
	vencimiento date,
	utilidad numeric,
	precio_va numeric
);


ALTER TYPE inventarios.type_ingreso_leer_items OWNER TO radiosan_ustaana;

--
-- Name: type_ingreso_leer_por_referencia; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ingreso_leer_por_referencia AS (
	ingresoid integer,
	registro character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	tipomovimientoid integer,
	tipomovimiento_nombre character varying,
	correlativo integer,
	fecha date,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	numero character varying,
	personaid integer,
	persona_dniruc character varying,
	persona_nombre character varying,
	persona_sexo character varying,
	persona_foto character varying,
	total numeric,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_sexo character varying,
	usuario_foto character varying,
	usuario_usuario character varying,
	caja character varying,
	estado boolean,
	cerrado boolean,
	observacion text,
	cantidad integer,
	total_cantidad numeric,
	cantidad_items_error integer
);


ALTER TYPE inventarios.type_ingreso_leer_por_referencia OWNER TO radiosan_ustaana;

--
-- Name: type_ingreso_resumen_tipodocumento; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ingreso_resumen_tipodocumento AS (
	tipodocumentoid integer,
	nombre character varying,
	abreviatura character varying
);


ALTER TYPE inventarios.type_ingreso_resumen_tipodocumento OWNER TO radiosan_ustaana;

--
-- Name: type_ingreso_ultimas_byproducto; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ingreso_ultimas_byproducto AS (
	ingresoid integer,
	correlativo integer,
	fecha date,
	proveedorid integer,
	proveedor_ruc character varying,
	proveedor_nombre character varying,
	proveedor_foto character varying,
	proveedor_sexo character varying,
	moneda character varying,
	moneda_simbolo character varying,
	cantidad numeric,
	precio numeric,
	precio_compra numeric,
	total numeric
);


ALTER TYPE inventarios.type_ingreso_ultimas_byproducto OWNER TO radiosan_ustaana;

--
-- Name: type_inventario_detalle_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_inventario_detalle_leer AS (
	productoid integer,
	producto_nombre character varying,
	stock numeric,
	stock_db numeric
);


ALTER TYPE inventarios.type_inventario_detalle_leer OWNER TO radiosan_ustaana;

--
-- Name: type_inventario_getrow; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_inventario_getrow AS (
	inventarioid integer,
	registro character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	fecha date,
	observacion text,
	cerrado boolean,
	usuarioid integer,
	usuario_nombre character varying,
	ip character varying
);


ALTER TYPE inventarios.type_inventario_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_inventario_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_inventario_leer AS (
	inventarioid integer,
	registro character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	fecha date,
	observacion text,
	cerrado boolean,
	usuarioid integer,
	usuario_nombre character varying,
	ip character varying
);


ALTER TYPE inventarios.type_inventario_leer OWNER TO radiosan_ustaana;

--
-- Name: type_inventario_productos_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_inventario_productos_leer AS (
	productoid integer,
	producto_nombre character varying,
	stock numeric
);


ALTER TYPE inventarios.type_inventario_productos_leer OWNER TO radiosan_ustaana;

--
-- Name: type_kardex_fisico_cabecera; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_kardex_fisico_cabecera AS (
	categoriaid integer,
	categoria_nombre character varying,
	subcategoriaid integer,
	subcategoria_nombre character varying,
	productoid integer,
	producto character varying,
	stock numeric,
	precio_promedio numeric
);


ALTER TYPE inventarios.type_kardex_fisico_cabecera OWNER TO radiosan_ustaana;

--
-- Name: type_kardex_fisico_detalle; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_kardex_fisico_detalle AS (
	almacenid integer,
	almacen_nombre character varying,
	almacen_abrev character varying,
	direccion integer,
	fecha date,
	productoid integer,
	numero character varying,
	ingreso numeric,
	salida numeric,
	precio numeric,
	personaid integer,
	persona character varying
);


ALTER TYPE inventarios.type_kardex_fisico_detalle OWNER TO radiosan_ustaana;

--
-- Name: type_kardex_fisico_detalle_completo; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_kardex_fisico_detalle_completo AS (
	almacenid integer,
	almacen_nombre character varying,
	almacen_abrev character varying,
	direccion integer,
	fecha date,
	productoid integer,
	numero character varying,
	ingreso numeric,
	salida numeric,
	precio numeric,
	personaid integer,
	persona character varying
);


ALTER TYPE inventarios.type_kardex_fisico_detalle_completo OWNER TO radiosan_ustaana;

--
-- Name: type_kardex_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_kardex_leer AS (
	tipo integer,
	contador integer,
	fecha date,
	personaid integer,
	persona_nombre character varying,
	numero character varying,
	productoid integer,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	ingreso_cantidad numeric,
	ingreso_cantidad_bonif numeric,
	ingreso_precio numeric,
	ingreso_total numeric,
	salida_cantidad numeric,
	salida_cantidad_bonif numeric,
	salida_precio numeric,
	salida_total numeric,
	referencia character varying,
	referenciaid1 integer,
	cerrado boolean,
	registro timestamp without time zone
);


ALTER TYPE inventarios.type_kardex_leer OWNER TO radiosan_ustaana;

--
-- Name: type_motivo_anulacion_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_motivo_anulacion_leer AS (
	motivoid integer,
	nombre character varying,
	abreviatura character varying,
	codigo_contable character varying,
	orden integer,
	estado boolean
);


ALTER TYPE inventarios.type_motivo_anulacion_leer OWNER TO radiosan_ustaana;

--
-- Name: type_motivo_notas_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_motivo_notas_leer AS (
	motivoid integer,
	tipo character varying,
	nombre character varying,
	abreviatura character varying,
	codigo_contable character varying,
	afectastock boolean,
	orden integer,
	estado boolean
);


ALTER TYPE inventarios.type_motivo_notas_leer OWNER TO radiosan_ustaana;

--
-- Name: type_ordecompra_entregas; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ordecompra_entregas AS (
	tipo character varying,
	id integer,
	registro character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	tipomovimientoid integer,
	tipomovimiento_nombre character varying,
	correlativo integer,
	fecha date,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	numero character varying,
	personaid integer,
	persona_dniruc character varying,
	persona_nombre character varying,
	persona_sexo character varying,
	persona_foto character varying,
	total numeric,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_sexo character varying,
	usuario_foto character varying,
	usuario_usuario character varying,
	caja character varying,
	estado boolean,
	cerrado boolean,
	observacion text,
	cantidad integer,
	total_cantidad numeric,
	cantidad_items_error integer
);


ALTER TYPE inventarios.type_ordecompra_entregas OWNER TO radiosan_ustaana;

--
-- Name: type_ordencompra_consulta; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ordencompra_consulta AS (
	ordencompraid integer,
	empresaid integer,
	registro character varying,
	fecha date,
	correlativo integer,
	proveedorid integer,
	proveedor_nombre character varying,
	proveedor_foto character varying,
	proveedor_sexo character varying,
	paraareaid integer,
	paraarea_nombre character varying,
	condicionpagoid integer,
	condicionpago_nombre character varying,
	moneda character varying,
	moneda_simbolo character varying,
	exonerado numeric,
	grabado numeric,
	igv numeric,
	total numeric,
	cantidad_items integer,
	situacion character varying,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	usuario_usuario character varying,
	caja character varying,
	estadoactual integer,
	estado boolean
);


ALTER TYPE inventarios.type_ordencompra_consulta OWNER TO radiosan_ustaana;

--
-- Name: type_ordencompra_entregas_detalle; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ordencompra_entregas_detalle AS (
	tipo character varying,
	id integer,
	registro character varying,
	fecha date,
	zonaid integer,
	zona_nombre character varying,
	zona_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	correlativo integer,
	numero_detalle character varying,
	productoid integer,
	producto_nombre character varying,
	producto_abreviatura character varying,
	moneda character varying,
	moneda_simbolo character varying,
	item integer,
	cantidad numeric,
	precio numeric,
	total numeric
);


ALTER TYPE inventarios.type_ordencompra_entregas_detalle OWNER TO radiosan_ustaana;

--
-- Name: type_ordencompra_getdataitem_edit; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ordencompra_getdataitem_edit AS (
	stock_actual numeric,
	existe boolean,
	cantidad numeric,
	cantidad_recogida numeric,
	cantidad_porrecoger numeric,
	cantidad_porrecoger_otros numeric
);


ALTER TYPE inventarios.type_ordencompra_getdataitem_edit OWNER TO radiosan_ustaana;

--
-- Name: type_ordencompra_getrow; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ordencompra_getrow AS (
	ordencompraid integer,
	registro character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_ruc character varying,
	correlativo integer,
	fecha date,
	proveedorid integer,
	proveedor_nombre character varying,
	proveedor_foto character varying,
	proveedor_sexo character varying,
	proveedor_direccion character varying,
	proveedor_dniruc character varying,
	proveedor_telefono character varying,
	proveedor_email character varying,
	paraareaid integer,
	paraarea_nombre character varying,
	condicionpagoid integer,
	condicionpago_nombre character varying,
	moneda character varying,
	moneda_simbolo character varying,
	moneda_nombre character varying,
	entrega_fecha date,
	entrega_lugar character varying,
	doc_ref character varying,
	gratuito numeric,
	exonerado numeric,
	grabado numeric,
	igv numeric,
	descuento numeric,
	descuento_global numeric,
	descuento_global_porc numeric,
	total numeric,
	valor_igv numeric,
	referencia character varying,
	codigo_ref1 integer,
	codigo_ref2 integer,
	observacion character varying,
	estadoactual integer,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	usuario_usuario character varying,
	caja character varying,
	cantidad_total numeric,
	estado boolean
);


ALTER TYPE inventarios.type_ordencompra_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_ordencompra_imprimir_cabecera; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ordencompra_imprimir_cabecera AS (
	ordencompraid integer,
	registro character varying,
	registro_fecha character varying,
	registro_hora character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abrev character varying,
	empresa_direccion character varying,
	empresa_ruc character varying,
	correlativo integer,
	correlativo_texto character varying,
	fecha character varying,
	proveedorid integer,
	proveedor_nombre character varying,
	proveedor_foto character varying,
	proveedor_sexo character varying,
	proveedor_direccion character varying,
	proveedor_dniruc character varying,
	proveedor_telefono character varying,
	proveedor_email character varying,
	paraareaid integer,
	paraarea_nombre character varying,
	condicionpagoid integer,
	condicionpago_nombre character varying,
	moneda character varying,
	moneda_simbolo character varying,
	moneda_nombre character varying,
	entrega_fecha character varying,
	entrega_lugar character varying,
	doc_ref character varying,
	gratuito numeric,
	exonerado numeric,
	grabado numeric,
	exonerado_grabado numeric,
	igv numeric,
	descuento numeric,
	descuento_global numeric,
	descuento_global_porc numeric,
	total numeric,
	valor_igv numeric,
	referencia character varying,
	codigo_ref1 integer,
	codigo_ref2 integer,
	observacion character varying,
	estadoactual integer,
	estadoactual_texto character varying,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	usuario_usuario character varying,
	caja character varying,
	cantidad_total numeric,
	subtitulo_igv character varying,
	estado boolean
);


ALTER TYPE inventarios.type_ordencompra_imprimir_cabecera OWNER TO radiosan_ustaana;

--
-- Name: type_ordencompra_imprimir_detalle; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ordencompra_imprimir_detalle AS (
	ordencompraid integer,
	productoid integer,
	producto character varying,
	unidadmedidaid integer,
	unidadmedida_nombre character varying,
	unidadmedida_abreviatura character varying,
	gratuito boolean,
	gratuito_texto character varying,
	cantidad numeric,
	valor_venta numeric,
	precio numeric,
	descuento_porc numeric,
	descuento_porc_valor numeric,
	descuento_fijo numeric,
	descuento numeric,
	grabado boolean,
	grabado_texto character varying,
	igv numeric,
	item integer,
	total numeric,
	bonificacion numeric,
	observacion text,
	tipocalculo smallint
);


ALTER TYPE inventarios.type_ordencompra_imprimir_detalle OWNER TO radiosan_ustaana;

--
-- Name: type_ordencompra_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ordencompra_leer AS (
	ordencompraid integer,
	empresaid integer,
	registro character varying,
	fecha date,
	correlativo integer,
	proveedorid integer,
	proveedor_nombre character varying,
	proveedor_foto character varying,
	proveedor_sexo character varying,
	paraareaid integer,
	paraarea_nombre character varying,
	condicionpagoid integer,
	condicionpago_nombre character varying,
	moneda character varying,
	moneda_simbolo character varying,
	exonerado numeric,
	grabado numeric,
	igv numeric,
	total numeric,
	cantidad_items integer,
	situacion character varying,
	cantidad_porconfirmar integer,
	doc_ref character varying,
	observacion character varying,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	usuario_usuario character varying,
	caja character varying,
	estadoactual integer,
	estado boolean,
	cerrado boolean
);


ALTER TYPE inventarios.type_ordencompra_leer OWNER TO radiosan_ustaana;

--
-- Name: type_ordencompra_leer_items; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ordencompra_leer_items AS (
	ordencompraid integer,
	productoid integer,
	producto character varying,
	unidadmedidaid integer,
	unidadmedida_nombre character varying,
	unidadmedida_abreviatura character varying,
	gratuito boolean,
	cantidad numeric,
	valor_venta numeric,
	precio numeric,
	descuento_porc numeric,
	descuento_porc_valor numeric,
	descuento_fijo numeric,
	descuento numeric,
	grabado boolean,
	igv numeric,
	item integer,
	total numeric,
	bonificacion numeric,
	observacion text,
	tipocalculo smallint,
	saldo numeric,
	cantidad_entregada numeric,
	cantidad_porentregar numeric
);


ALTER TYPE inventarios.type_ordencompra_leer_items OWNER TO radiosan_ustaana;

--
-- Name: type_ordencompra_lugar_entrega_usadas; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ordencompra_lugar_entrega_usadas AS (
	direccion character varying,
	fecha date
);


ALTER TYPE inventarios.type_ordencompra_lugar_entrega_usadas OWNER TO radiosan_ustaana;

--
-- Name: type_ordencompra_porrecoger; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ordencompra_porrecoger AS (
	ordencompraid integer,
	registro character varying,
	fecha date,
	correlativo integer,
	proveedorid integer,
	proveedor_tipo character varying,
	proveedor_nrodoc character varying,
	proveedor_nombre character varying,
	proveedor_foto character varying,
	proveedor_sexo character varying,
	moneda character varying,
	moneda_nombre character varying,
	moneda_simbolo character varying,
	total numeric,
	cantidad_items integer,
	cantidad_total numeric
);


ALTER TYPE inventarios.type_ordencompra_porrecoger OWNER TO radiosan_ustaana;

--
-- Name: type_ordencompra_porrecoger_byproducto; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ordencompra_porrecoger_byproducto AS (
	productoid integer,
	producto_nombre character varying,
	producto_abreviatura character varying,
	cantidad_items integer,
	cantidad_proveedores integer,
	cantidad_total numeric
);


ALTER TYPE inventarios.type_ordencompra_porrecoger_byproducto OWNER TO radiosan_ustaana;

--
-- Name: type_ordencompra_ultimas_byproducto; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ordencompra_ultimas_byproducto AS (
	ordencompraid integer,
	correlativo integer,
	fecha date,
	proveedorid integer,
	proveedor_ruc character varying,
	proveedor_nombre character varying,
	proveedor_foto character varying,
	proveedor_sexo character varying,
	moneda character varying,
	moneda_simbolo character varying,
	cantidad numeric,
	valor_venta numeric,
	precio numeric,
	total numeric
);


ALTER TYPE inventarios.type_ordencompra_ultimas_byproducto OWNER TO radiosan_ustaana;

--
-- Name: type_ordenrecojo_byalmacen; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ordenrecojo_byalmacen AS (
	ventaid integer,
	registro character varying,
	zonaid integer,
	zona_nombre character varying,
	zona_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	fecha date,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	numero character varying,
	numero_detalle character varying,
	clienteid integer,
	cliente_tipo character varying,
	cliente_nrodoc character varying,
	cliente_nombre character varying,
	cliente_foto character varying,
	cliente_sexo character varying,
	moneda character varying,
	simbolo_moneda character varying,
	vta_total numeric,
	usuario character varying,
	caja character varying,
	impresiones integer,
	vendedorid integer,
	vendedor_nombre character varying,
	vendedor_foto character varying,
	vendedor_sexo character varying,
	estado boolean,
	cerrado boolean,
	condicion character varying,
	signo character varying,
	cantidad_items integer,
	cantidad_total numeric
);


ALTER TYPE inventarios.type_ordenrecojo_byalmacen OWNER TO radiosan_ustaana;

--
-- Name: type_ordenrecojo_consulta; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ordenrecojo_consulta AS (
	ordenrecojoid integer,
	empresaid integer,
	registro character varying,
	fecha date,
	correlativo integer,
	proveedorid integer,
	proveedor_nombre character varying,
	proveedor_foto character varying,
	proveedor_sexo character varying,
	almacendestinoid integer,
	almacendestino_nombre character varying,
	almacendestino_abreviatura character varying,
	moneda character varying,
	moneda_simbolo character varying,
	doc_ref character varying,
	total numeric,
	referencia character varying,
	referenciaid1 integer,
	referenciaid2 integer,
	referencia_texto character varying,
	cantidad_items integer,
	confirmado boolean,
	confirmado_text character varying,
	confirmado_cantidad_obs integer,
	observacion text,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	usuario_usuario character varying,
	caja character varying,
	estado boolean
);


ALTER TYPE inventarios.type_ordenrecojo_consulta OWNER TO radiosan_ustaana;

--
-- Name: type_ordenrecojo_getdataitem_edit; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ordenrecojo_getdataitem_edit AS (
	stock_actual numeric,
	existe boolean,
	cantidad numeric,
	cantidad_confirmada numeric
);


ALTER TYPE inventarios.type_ordenrecojo_getdataitem_edit OWNER TO radiosan_ustaana;

--
-- Name: type_ordenrecojo_getrow; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ordenrecojo_getrow AS (
	ordenrecojoid integer,
	registro character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	empresa_ruc character varying,
	correlativo integer,
	fecha date,
	proveedorid integer,
	proveedor_nombre character varying,
	proveedor_foto character varying,
	proveedor_sexo character varying,
	proveedor_direccion character varying,
	proveedor_dniruc character varying,
	proveedor_telefono character varying,
	proveedor_email character varying,
	origenid integer,
	origen_nombre character varying,
	origen_abreviatura character varying,
	almacendestinoid integer,
	almacendestino_nombre character varying,
	almacendestino_abreviatura character varying,
	moneda character varying,
	moneda_simbolo character varying,
	moneda_nombre character varying,
	doc_ref character varying,
	valor_igv numeric,
	igv numeric,
	total numeric,
	referencia character varying,
	referenciaid1 integer,
	referenciaid2 integer,
	referencia_detalle character varying,
	referencia_titulo character varying,
	referencia_texto character varying,
	referencia_numero character varying,
	referencia_fecha character varying,
	observacion text,
	confirmado boolean,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	usuario_usuario character varying,
	caja character varying,
	cantidad_total numeric,
	estado boolean
);


ALTER TYPE inventarios.type_ordenrecojo_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_ordenrecojo_imprimir_cabecera; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ordenrecojo_imprimir_cabecera AS (
	ordenrecojoid integer,
	registro character varying,
	registro_fecha character varying,
	registro_hora character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	empresa_direccion character varying,
	empresa_ruc character varying,
	correlativo integer,
	correlativo_texto character varying,
	fecha character varying,
	proveedorid integer,
	proveedor_nombre character varying,
	proveedor_foto character varying,
	proveedor_sexo character varying,
	proveedor_direccion character varying,
	proveedor_dniruc character varying,
	proveedor_telefono character varying,
	proveedor_email character varying,
	origenid integer,
	origen_nombre character varying,
	origen_abreviatura character varying,
	almacendestinoid integer,
	almacendestino_nombre character varying,
	almacendestino_abreviatura character varying,
	moneda character varying,
	moneda_simbolo character varying,
	moneda_nombre character varying,
	doc_ref character varying,
	valor_igv numeric,
	igv numeric,
	total numeric,
	referencia character varying,
	referenciaid1 integer,
	referenciaid2 integer,
	referencia_detalle character varying,
	referencia_titulo character varying,
	referencia_texto character varying,
	referencia_numero character varying,
	referencia_fecha character varying,
	observacion character varying,
	confirmado boolean,
	confirmado_texto character varying,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	usuario_usuario character varying,
	caja character varying,
	cantidad_total numeric,
	estado boolean
);


ALTER TYPE inventarios.type_ordenrecojo_imprimir_cabecera OWNER TO radiosan_ustaana;

--
-- Name: type_ordenrecojo_imprimir_detalle; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ordenrecojo_imprimir_detalle AS (
	ordenrecojoid integer,
	productoid integer,
	producto character varying,
	unidadmedidaid integer,
	unidadmedida_nombre character varying,
	unidadmedida_abreviatura character varying,
	item integer,
	cantidad numeric,
	precio numeric,
	total numeric,
	bonificacion numeric,
	observacion text,
	cantidad_confirmada numeric
);


ALTER TYPE inventarios.type_ordenrecojo_imprimir_detalle OWNER TO radiosan_ustaana;

--
-- Name: type_ordenrecojo_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ordenrecojo_leer AS (
	ordenrecojoid integer,
	empresaid integer,
	registro character varying,
	fecha date,
	correlativo integer,
	proveedorid integer,
	proveedor_nombre character varying,
	proveedor_foto character varying,
	proveedor_sexo character varying,
	origenid integer,
	origen_nombre character varying,
	origen_abreviatura character varying,
	almacendestinoid integer,
	almacendestino_nombre character varying,
	almacendestino_abreviatura character varying,
	doc_ref character varying,
	moneda character varying,
	moneda_simbolo character varying,
	total numeric,
	referencia character varying,
	referenciaid1 integer,
	referenciaid2 integer,
	referencia_texto character varying,
	cantidad_items integer,
	confirmado boolean,
	confirmado_text character varying,
	confirmado_cantidad_obs integer,
	observacion text,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	usuario_usuario character varying,
	caja character varying,
	estado boolean
);


ALTER TYPE inventarios.type_ordenrecojo_leer OWNER TO radiosan_ustaana;

--
-- Name: type_ordenrecojo_leer_items; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ordenrecojo_leer_items AS (
	ordenrecojoid integer,
	productoid integer,
	producto character varying,
	unidadmedidaid integer,
	unidadmedida_nombre character varying,
	unidadmedida_abreviatura character varying,
	item integer,
	cantidad numeric,
	precio numeric,
	total numeric,
	bonificacion numeric,
	observacion text,
	cantidad_confirmada numeric
);


ALTER TYPE inventarios.type_ordenrecojo_leer_items OWNER TO radiosan_ustaana;

--
-- Name: type_ordenrecojo_porconfirmar; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ordenrecojo_porconfirmar AS (
	ordenrecojoid integer,
	empresaid integer,
	registro character varying,
	fecha date,
	correlativo integer,
	proveedorid integer,
	proveedor_nombre character varying,
	proveedor_foto character varying,
	proveedor_sexo character varying,
	zonaid integer,
	zona_nombre character varying,
	zona_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	moneda character varying,
	moneda_simbolo character varying,
	doc_ref character varying,
	total numeric,
	referencia character varying,
	referenciaid1 integer,
	referenciaid2 integer,
	referencia_texto character varying,
	cantidad_items integer,
	observacion text,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	usuario_usuario character varying,
	caja character varying
);


ALTER TYPE inventarios.type_ordenrecojo_porconfirmar OWNER TO radiosan_ustaana;

--
-- Name: type_ordenrecojo_porconfirmar_porproducto; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_ordenrecojo_porconfirmar_porproducto AS (
	zonaid integer,
	zona_nombre character varying,
	zona_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	productoid integer,
	producto_nombre character varying,
	producto_abreviatura character varying,
	cantidad_items integer,
	cantidad_proveedores integer,
	cantidad_total numeric
);


ALTER TYPE inventarios.type_ordenrecojo_porconfirmar_porproducto OWNER TO radiosan_ustaana;

--
-- Name: type_origen_getrow; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_origen_getrow AS (
	origenid integer,
	nombre character varying,
	abreviatura character varying,
	direccion character varying,
	estado boolean,
	distritoid integer,
	distrito_nombre character varying,
	provinciaid integer,
	provincia_nombre character varying,
	departamentoid integer,
	departamento_nombre character varying
);


ALTER TYPE inventarios.type_origen_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_origen_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_origen_leer AS (
	origenid integer,
	nombre character varying,
	abreviatura character varying,
	direccion character varying,
	estado boolean,
	distritoid integer,
	distrito_nombre character varying,
	provinciaid integer,
	provincia_nombre character varying,
	departamentoid integer,
	departamento_nombre character varying
);


ALTER TYPE inventarios.type_origen_leer OWNER TO radiosan_ustaana;

--
-- Name: type_pedido_getdataitem_edit; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_pedido_getdataitem_edit AS (
	stock_actual numeric,
	existe boolean,
	cantidad numeric,
	existe_referencia boolean,
	saldo numeric
);


ALTER TYPE inventarios.type_pedido_getdataitem_edit OWNER TO radiosan_ustaana;

--
-- Name: type_pedido_getrow; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_pedido_getrow AS (
	pedidoid integer,
	registro character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	empresa_ruc character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	correlativo integer,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	fecha date,
	clienteid integer,
	cliente_tipo character varying,
	cliente_razsoc character varying,
	cliente_direccion character varying,
	cliente_ruc character varying,
	cliente_sexo character varying,
	cliente_foto character varying,
	nombre character varying,
	total numeric,
	redondeo numeric,
	pendiente boolean,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_sexo character varying,
	usuario_foto character varying,
	caja character varying,
	ventaid integer
);


ALTER TYPE inventarios.type_pedido_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_pedido_imprimir_cabecera; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_pedido_imprimir_cabecera AS (
	pedidoid integer,
	registro character varying,
	registro_fecha character varying,
	registro_hora character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	empresa_ruc character varying,
	empresa_direccion character varying,
	empresa_direccion_full character varying,
	empresa_ubicacion character varying,
	empresa_ubigeo character varying,
	empresa_distrito_nombre character varying,
	empresa_provincia_nombre character varying,
	empresa_departamento_nombre character varying,
	empresa_pais_nombre character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	almacen_direccion character varying,
	almacen_direccion_full character varying,
	almacen_ubicacion character varying,
	almacen_ubigeo character varying,
	almacen_distrito_nombre character varying,
	almacen_provincia_nombre character varying,
	almacen_departamento_nombre character varying,
	almacen_pais_nombre character varying,
	correlativo integer,
	correlativo_texto character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	tipodocumento_codigo character varying,
	tipodocumento_caracter character varying,
	fecha character varying,
	clienteid integer,
	cliente_tipo character varying,
	cliente_nombre character varying,
	cliente_direccion character varying,
	cliente_ruc character varying,
	cliente_sexo character varying,
	cliente_foto character varying,
	nombre character varying,
	total numeric,
	redondeo numeric,
	pendiente boolean,
	usuarioid integer,
	usuario_nombre_full character varying,
	usuario_nombre character varying,
	usuario_usuario character varying,
	caja character varying,
	fecha_larga_empresa character varying,
	fecha_larga_almacen character varying
);


ALTER TYPE inventarios.type_pedido_imprimir_cabecera OWNER TO radiosan_ustaana;

--
-- Name: type_pedido_imprimir_detalle; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_pedido_imprimir_detalle AS (
	pedidoid integer,
	productoid integer,
	producto_nombre character varying,
	producto_codigo_sunat character varying,
	unidadmedida_nombre character varying,
	unidadmedida_abreviatura character varying,
	cantidad numeric,
	gratuito boolean,
	gratuito_texto character varying,
	precio numeric,
	valor_venta numeric,
	descuento_porc numeric,
	descuento_porc_valor numeric,
	descuento_fijo numeric,
	descuento numeric,
	grabado boolean,
	grabado_texto character varying,
	igv numeric,
	isc_porc numeric,
	isc numeric,
	comision numeric,
	item smallint,
	total numeric,
	entregado boolean,
	bonificacion numeric,
	observacion text,
	tieneobservacion integer,
	total_valor_venta numeric
);


ALTER TYPE inventarios.type_pedido_imprimir_detalle OWNER TO radiosan_ustaana;

--
-- Name: type_pedido_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_pedido_leer AS (
	pedidoid integer,
	empresaid integer,
	empresa_nombre character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	fecha date,
	correlativo integer,
	clienteid integer,
	cliente_nombre character varying,
	total numeric,
	usuarioid integer,
	usuario_nombre character varying,
	caja character varying,
	pendiente boolean,
	registro_text character varying,
	ventaid integer
);


ALTER TYPE inventarios.type_pedido_leer OWNER TO radiosan_ustaana;

--
-- Name: type_pedido_leer_items; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_pedido_leer_items AS (
	pedidoid integer,
	productoid integer,
	producto character varying,
	producto_peso numeric,
	cantidad numeric,
	gratuito boolean,
	precio numeric,
	valor_venta numeric,
	descuento_porc numeric,
	descuento_porc_valor numeric,
	descuento_fijo numeric,
	descuento numeric,
	grabado boolean,
	igv numeric,
	isc_porc numeric,
	isc numeric,
	comision numeric,
	item smallint,
	total numeric,
	entregado boolean,
	bonificacion numeric,
	observacion text,
	cantidad_entregada numeric
);


ALTER TYPE inventarios.type_pedido_leer_items OWNER TO radiosan_ustaana;

--
-- Name: type_permisos_impresion_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_permisos_impresion_leer AS (
	codigo integer,
	tipo_modulo_impresion character varying,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	usuario_usuario character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	caja character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	serie character varying,
	cantidad_items integer,
	cantidad_impresiones integer,
	imprimir boolean,
	impresion_directa boolean,
	formato character varying,
	impresora character varying
);


ALTER TYPE inventarios.type_permisos_impresion_leer OWNER TO radiosan_ustaana;

--
-- Name: type_permisos_impresion_leer_permisos; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_permisos_impresion_leer_permisos AS (
	codigo integer,
	tipodocumentoid integer,
	serieid integer,
	serie character varying,
	imprimir boolean,
	almacenid integer,
	empresaid integer,
	formato character varying,
	impresora character varying,
	cantidad_items integer,
	cantidad_impresiones integer,
	impresion_directa boolean,
	codigo_for integer,
	tipo_modulo_impresion character varying,
	tipo_impresora character varying
);


ALTER TYPE inventarios.type_permisos_impresion_leer_permisos OWNER TO radiosan_ustaana;

--
-- Name: type_persona_leer_vendedores; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_persona_leer_vendedores AS (
	personaid integer,
	nombre character varying,
	foto character varying,
	sexo character varying,
	usuario character varying
);


ALTER TYPE inventarios.type_persona_leer_vendedores OWNER TO radiosan_ustaana;

--
-- Name: type_producto_resumen; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_producto_resumen AS (
	stock numeric,
	precio_promedio numeric
);


ALTER TYPE inventarios.type_producto_resumen OWNER TO radiosan_ustaana;

--
-- Name: type_producto_ultimos_ingresos; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_producto_ultimos_ingresos AS (
	fecha date,
	numero character varying,
	nombre_persona character varying,
	precio numeric
);


ALTER TYPE inventarios.type_producto_ultimos_ingresos OWNER TO radiosan_ustaana;

--
-- Name: type_producto_ultimos_salidas; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_producto_ultimos_salidas AS (
	fecha date,
	numero character varying,
	nombre_persona character varying,
	precio numeric
);


ALTER TYPE inventarios.type_producto_ultimos_salidas OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_correlativos_libres; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_correlativos_libres AS (
	empresaid integer,
	empresa_nombre character varying,
	almacenid integer,
	almacen_nombre character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	serie character varying,
	inicio integer,
	fin integer,
	cantidad integer
);


ALTER TYPE inventarios.type_reporte_correlativos_libres OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_ganancias_metas_vendedor; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_ganancias_metas_vendedor AS (
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	vendedorid integer,
	vendedor_nombre character varying,
	meta numeric,
	ganancia numeric,
	porcentaje numeric
);


ALTER TYPE inventarios.type_reporte_ganancias_metas_vendedor OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_ingreso_mercaderia; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_ingreso_mercaderia AS (
	ingresoid integer,
	fecha date,
	numero character varying,
	nombre_persona character varying,
	moneda character varying,
	simbolo character varying,
	subtotal numeric,
	igv numeric,
	vta_total numeric
);


ALTER TYPE inventarios.type_reporte_ingreso_mercaderia OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_ingreso_mercaderia_detalladas_producto; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_ingreso_mercaderia_detalladas_producto AS (
	mes_ano character varying,
	dia integer,
	numero character varying,
	nombre_persona character varying,
	producto character varying,
	cantidad numeric,
	precio numeric,
	dcto numeric,
	subtotal numeric,
	fecha date,
	moneda character varying,
	simbolo_moneda character varying,
	codigo_ing integer
);


ALTER TYPE inventarios.type_reporte_ingreso_mercaderia_detalladas_producto OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_ingreso_mercaderia_detallado_proveedor; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_ingreso_mercaderia_detallado_proveedor AS (
	personaid integer,
	persona character varying,
	ingresoid integer,
	fecha date,
	numero character varying,
	productoid integer,
	producto character varying,
	cantidad numeric,
	precio numeric,
	dcto numeric,
	total numeric,
	almacenid integer,
	almacen character varying
);


ALTER TYPE inventarios.type_reporte_ingreso_mercaderia_detallado_proveedor OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_ingreso_mercaderia_persona; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_ingreso_mercaderia_persona AS (
	nombre_persona character varying,
	mes_ano character varying,
	dia character varying,
	fecha date,
	numero character varying,
	moneda character varying,
	simbolo character varying,
	subtotal numeric,
	igv numeric,
	vta_total numeric
);


ALTER TYPE inventarios.type_reporte_ingreso_mercaderia_persona OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_ingreso_mercaderia_producto; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_ingreso_mercaderia_producto AS (
	producto character varying,
	fecha date,
	detalle character varying,
	persona character varying,
	cantidad numeric,
	precio numeric,
	dcto numeric,
	total numeric,
	productoid integer,
	almacenid integer,
	almacen character varying
);


ALTER TYPE inventarios.type_reporte_ingreso_mercaderia_producto OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_ingreso_producto; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_ingreso_producto AS (
	productoid integer,
	producto character varying,
	almaenid integer,
	almacen_nombre character varying,
	fecha date,
	detalle character varying,
	personaid integer,
	persona_dni character varying,
	persona_nombre character varying,
	moneda character varying,
	moneda_simbolo character varying,
	cantidad numeric,
	precio numeric,
	descuento numeric,
	total numeric
);


ALTER TYPE inventarios.type_reporte_ingreso_producto OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_inventario_permanente_valorizado; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_inventario_permanente_valorizado AS (
	tipolinea character varying,
	tipomovimiento integer,
	registro timestamp without time zone,
	nroreg integer,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	almacen_codigo character varying,
	productoid integer,
	producto character varying,
	codigo_catalogo character varying,
	codigo_unico_bienes character varying,
	unidadmedidaid integer,
	unidadmedida_nombre character varying,
	unidadmedida_abreviatura character varying,
	unidadmedida_codigo character varying,
	lineaid integer,
	linea_nombre character varying,
	linea_codigo character varying,
	fecha date,
	fecha_text character varying,
	tipmovmerid integer,
	tipmovmer_nombre character varying,
	tipmovmer_codigo character varying,
	tipmetval_codigo character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	tipodocumento_codigo character varying,
	serie character varying,
	numero character varying,
	ingreso_cantidad numeric,
	ingreso_precio numeric,
	ingreso_total numeric,
	salida_cantidad numeric,
	salida_precio numeric,
	salida_total numeric,
	saldo_cantidad numeric,
	saldo_precio numeric,
	saldo_total numeric,
	referencia character varying,
	referenciaid1 integer,
	codigo_libdia integer,
	estadoregistro integer,
	orden_producto integer,
	ultimo integer,
	tienedetalle integer
);


ALTER TYPE inventarios.type_reporte_inventario_permanente_valorizado OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_kardex_cabecera; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_kardex_cabecera AS (
	categoriaid integer,
	categoria_nombre character varying,
	subcategoriaid integer,
	subcategoria_nombre character varying,
	productoid integer,
	producto_nombre character varying,
	stock_anterior numeric
);


ALTER TYPE inventarios.type_reporte_kardex_cabecera OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_kardex_detalle; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_kardex_detalle AS (
	productoid integer,
	tipo integer,
	fecha date,
	numero_detalle character varying,
	ingreso numeric,
	salida numeric,
	personaid integer,
	persona_nombre character varying
);


ALTER TYPE inventarios.type_reporte_kardex_detalle OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_kardex_promedio; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_kardex_promedio AS (
	fecha date,
	personaid integer,
	persona_nombre character varying,
	numero character varying,
	productoid integer,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	tipo integer,
	ingreso_cantidad numeric,
	ingreso_precio numeric,
	ingreso_total numeric,
	ingreso_cantidad_bonif numeric,
	salida_cantidad numeric,
	salida_precio numeric,
	salida_total numeric,
	salida_cantidad_bonif numeric,
	saldo_cantidad numeric,
	saldo_precio numeric,
	saldo_total numeric,
	referencia character varying,
	referenciaid1 integer,
	cerrado boolean
);


ALTER TYPE inventarios.type_reporte_kardex_promedio OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_kardex_subcategoria_cabecera; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_kardex_subcategoria_cabecera AS (
	categoriaid integer,
	categoria_nombre character varying,
	subcategoriaid integer,
	nombre character varying,
	stock_anterior numeric
);


ALTER TYPE inventarios.type_reporte_kardex_subcategoria_cabecera OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_kardex_subcategoria_detalle; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_kardex_subcategoria_detalle AS (
	subcategoriaid integer,
	tipo integer,
	fecha date,
	numero_detalle character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	productoid integer,
	producto_nombre character varying,
	producto_abreviatura character varying,
	ingreso numeric,
	salida numeric,
	personaid integer,
	persona_nombre character varying
);


ALTER TYPE inventarios.type_reporte_kardex_subcategoria_detalle OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_mineria_clientes_frecuentes; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_mineria_clientes_frecuentes AS (
	clienteid integer,
	nombre_cliente character varying,
	almacenid integer,
	nombre_almacen character varying,
	total numeric
);


ALTER TYPE inventarios.type_reporte_mineria_clientes_frecuentes OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_mineria_ingreso_mercaderia_producto; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_mineria_ingreso_mercaderia_producto AS (
	almacenid integer,
	productoid integer,
	producto character varying,
	cantidad numeric,
	total numeric
);


ALTER TYPE inventarios.type_reporte_mineria_ingreso_mercaderia_producto OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_mineria_saldos; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_mineria_saldos AS (
	productoid integer,
	producto character varying,
	almacenid integer,
	almacen character varying,
	anterior integer,
	ingreso integer,
	salida integer,
	actual integer,
	precio numeric,
	total numeric
);


ALTER TYPE inventarios.type_reporte_mineria_saldos OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_mineria_stock_general; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_mineria_stock_general AS (
	productoid integer,
	producto character varying,
	almacenid integer,
	almacen character varying,
	stock numeric
);


ALTER TYPE inventarios.type_reporte_mineria_stock_general OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_mineria_venta_hora; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_mineria_venta_hora AS (
	almacenid integer,
	almacen_nombre character varying,
	hora integer,
	total numeric
);


ALTER TYPE inventarios.type_reporte_mineria_venta_hora OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_ordencompra_faltan_recoger; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_ordencompra_faltan_recoger AS (
	productoid integer,
	producto_nombre character varying,
	ordencompraid integer,
	fecha date,
	correlativo integer,
	proveedorid integer,
	proveedor_nombre character varying,
	moneda character varying,
	moneda_simbolo character varying,
	cantidad numeric,
	porrecoger numeric,
	precio numeric,
	total numeric
);


ALTER TYPE inventarios.type_reporte_ordencompra_faltan_recoger OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_precios_general; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_precios_general AS (
	productoid integer,
	almacenid integer,
	precio_va numeric,
	precio_vb numeric,
	precio_vc numeric,
	precio_vd numeric
);


ALTER TYPE inventarios.type_reporte_precios_general OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_precios_poralmacen_general; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_precios_poralmacen_general AS (
	productoid integer,
	almacenid integer,
	precio_va numeric,
	precio_vb numeric,
	precio_vc numeric,
	precio_vd numeric
);


ALTER TYPE inventarios.type_reporte_precios_poralmacen_general OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_productos_mas_vendidos; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_productos_mas_vendidos AS (
	productoid integer,
	producto character varying,
	cantidad numeric,
	total numeric
);


ALTER TYPE inventarios.type_reporte_productos_mas_vendidos OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_productos_mas_vendidos_detalle; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_productos_mas_vendidos_detalle AS (
	productoid integer,
	producto character varying,
	zonaid integer,
	zona_nombre character varying,
	almacenid integer,
	almacen_nombre character varying,
	cantidad numeric,
	total numeric
);


ALTER TYPE inventarios.type_reporte_productos_mas_vendidos_detalle OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_productos_nunca_vendidos; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_productos_nunca_vendidos AS (
	productoid integer,
	producto character varying,
	cantidad numeric,
	precio numeric,
	total numeric
);


ALTER TYPE inventarios.type_reporte_productos_nunca_vendidos OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_ranking; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_ranking AS (
	codigo integer,
	nombre_persona character varying,
	cantidad numeric,
	total numeric
);


ALTER TYPE inventarios.type_reporte_ranking OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_resumen_stock_general; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_resumen_stock_general AS (
	productoid integer,
	almacenid integer,
	stock numeric
);


ALTER TYPE inventarios.type_reporte_resumen_stock_general OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_resumen_ventas_diaria; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_resumen_ventas_diaria AS (
	ano integer,
	mes integer,
	dia integer,
	fecha date,
	zonaid integer,
	zona_nombre character varying,
	zona_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	total numeric
);


ALTER TYPE inventarios.type_reporte_resumen_ventas_diaria OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_resumen_ventas_diaria_byusuario; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_resumen_ventas_diaria_byusuario AS (
	ano integer,
	mes integer,
	dia integer,
	fecha date,
	usuarioid integer,
	usuario_nombre character varying,
	total numeric
);


ALTER TYPE inventarios.type_reporte_resumen_ventas_diaria_byusuario OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_resumen_ventas_diaria_usuarios; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_resumen_ventas_diaria_usuarios AS (
	usuarioid integer,
	nombre character varying,
	foto character varying,
	sexo character varying,
	total numeric
);


ALTER TYPE inventarios.type_reporte_resumen_ventas_diaria_usuarios OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_resumen_ventas_mensual; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_resumen_ventas_mensual AS (
	ano integer,
	mes integer,
	zonaid integer,
	zona_nombre character varying,
	zona_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	total numeric
);


ALTER TYPE inventarios.type_reporte_resumen_ventas_mensual OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_resumen_ventas_mensual_bytipodocumento; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_resumen_ventas_mensual_bytipodocumento AS (
	ano integer,
	mes integer,
	zonaid integer,
	zona_nombre character varying,
	zona_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	total numeric
);


ALTER TYPE inventarios.type_reporte_resumen_ventas_mensual_bytipodocumento OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_resumen_ventas_usuario_anual; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_resumen_ventas_usuario_anual AS (
	ano integer,
	usuarioid integer,
	usuario_nombre character varying,
	total numeric
);


ALTER TYPE inventarios.type_reporte_resumen_ventas_usuario_anual OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_resumen_ventas_usuario_mensual; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_resumen_ventas_usuario_mensual AS (
	ano integer,
	mes integer,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	usuarioid integer,
	usuario_nombre character varying,
	total numeric
);


ALTER TYPE inventarios.type_reporte_resumen_ventas_usuario_mensual OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_saldos; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_saldos AS (
	productoid integer,
	producto character varying,
	anterior numeric,
	ingreso numeric,
	salida numeric,
	actual numeric,
	precio numeric,
	total numeric
);


ALTER TYPE inventarios.type_reporte_saldos OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_salida_mercaderia; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_salida_mercaderia AS (
	salidaid integer,
	fecha date,
	numero character varying,
	nombre_persona character varying,
	moneda character varying,
	simbolo character varying,
	subtotal numeric,
	igv numeric,
	vta_total numeric
);


ALTER TYPE inventarios.type_reporte_salida_mercaderia OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_salida_mercaderia_detalladas_producto; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_salida_mercaderia_detalladas_producto AS (
	mes_ano character varying,
	dia integer,
	numero character varying,
	nombre_persona character varying,
	producto character varying,
	cantidad numeric,
	precio numeric,
	dcto numeric,
	subtotal numeric,
	fecha date,
	moneda character varying,
	simbolo_moneda character varying,
	codigo_sal integer
);


ALTER TYPE inventarios.type_reporte_salida_mercaderia_detalladas_producto OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_salida_mercaderia_detallado_persona; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_salida_mercaderia_detallado_persona AS (
	personaid integer,
	persona character varying,
	codigo_ing integer,
	fecha date,
	numero character varying,
	productoid integer,
	producto character varying,
	cantidad numeric,
	precio numeric,
	dcto numeric,
	total numeric,
	almacenid integer,
	almacen character varying
);


ALTER TYPE inventarios.type_reporte_salida_mercaderia_detallado_persona OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_salida_mercaderia_persona; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_salida_mercaderia_persona AS (
	nombre_persona character varying,
	mes_ano character varying,
	dia character varying,
	fecha date,
	numero character varying,
	moneda character varying,
	simbolo character varying,
	subtotal numeric,
	igv numeric,
	vta_total numeric
);


ALTER TYPE inventarios.type_reporte_salida_mercaderia_persona OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_salida_mercaderia_producto; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_salida_mercaderia_producto AS (
	producto character varying,
	fecha date,
	detalle character varying,
	persona character varying,
	cantidad numeric,
	precio numeric,
	dcto numeric,
	total numeric,
	productoid integer,
	almacenid integer,
	almacen character varying
);


ALTER TYPE inventarios.type_reporte_salida_mercaderia_producto OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_stock; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_stock AS (
	productoid integer,
	producto character varying,
	ingreso numeric,
	salida numeric,
	actual numeric,
	precio numeric,
	total numeric
);


ALTER TYPE inventarios.type_reporte_stock OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_traslados_venta_destino_detallado_almacen; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_traslados_venta_destino_detallado_almacen AS (
	almacenid integer,
	almacen character varying,
	trasladoid integer,
	fecha date,
	numero character varying,
	productoid integer,
	producto character varying,
	cantidad_solicitada numeric,
	cantidad_confirmado numeric,
	precio numeric,
	total numeric,
	codigo_usu integer,
	nombre_usuario character varying,
	confirmado character varying
);


ALTER TYPE inventarios.type_reporte_traslados_venta_destino_detallado_almacen OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_traslados_venta_destino_detallado_producto; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_traslados_venta_destino_detallado_producto AS (
	productoid integer,
	producto character varying,
	codigo integer,
	fecha date,
	numero character varying,
	almacenid integer,
	almacen character varying,
	cantidad_solicitada numeric,
	cantidad_confirmado numeric,
	precio numeric,
	total numeric,
	codigo_usu integer,
	nombre_usuario character varying,
	confirmado character varying
);


ALTER TYPE inventarios.type_reporte_traslados_venta_destino_detallado_producto OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_traslados_venta_origen_detallado_almacen; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_traslados_venta_origen_detallado_almacen AS (
	almacenid integer,
	almacen character varying,
	trasladoid integer,
	fecha date,
	numero character varying,
	productoid integer,
	producto character varying,
	cantidad_solicitada numeric,
	cantidad_confirmado numeric,
	precio numeric,
	total numeric,
	codigo_usu integer,
	nombre_usuario character varying,
	confirmado character varying
);


ALTER TYPE inventarios.type_reporte_traslados_venta_origen_detallado_almacen OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_traslados_venta_origen_detallado_producto; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_traslados_venta_origen_detallado_producto AS (
	productoid integer,
	producto character varying,
	trsladoid integer,
	fecha date,
	numero character varying,
	almacenid integer,
	almacen character varying,
	cantidad_solicitada numeric,
	cantidad_confirmado numeric,
	precio numeric,
	total numeric,
	codigo_usu integer,
	nombre_usuario character varying,
	confirmado character varying
);


ALTER TYPE inventarios.type_reporte_traslados_venta_origen_detallado_producto OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_ventas; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_ventas AS (
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	tipodocumento_codigocontable character varying,
	numero character varying,
	numero_detalle character varying,
	fecha date,
	cliente character varying,
	moneda character varying,
	abrev character varying,
	contado numeric,
	credito numeric,
	usuario character varying,
	caja character varying,
	estado character varying,
	dniruc character varying
);


ALTER TYPE inventarios.type_reporte_ventas OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_ventas_detalladas; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_ventas_detalladas AS (
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	mes_ano character varying,
	dia integer,
	ventaid integer,
	fecha date,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	tipodocumento_codigocontable character varying,
	numero character varying,
	numero_solo character varying,
	clienteid integer,
	cliente_tipdoc character varying,
	cliente_nrodoc character varying,
	cliente_nombre character varying,
	productoid integer,
	producto character varying,
	moneda character varying,
	simbolo_moneda character varying,
	cantidad numeric,
	precio numeric,
	dcto numeric,
	subtotal numeric
);


ALTER TYPE inventarios.type_reporte_ventas_detalladas OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_ventas_detalladas_producto; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_ventas_detalladas_producto AS (
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	productoid integer,
	producto character varying,
	producto_abreviatura character varying,
	ventaid integer,
	fecha date,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	tipodocumento_codigocontable character varying,
	numero character varying,
	numero_detalle character varying,
	clienteid integer,
	cliente_nrodoc character varying,
	cliente_nombre character varying,
	moneda character varying,
	simbolo_moneda character varying,
	cantidad numeric,
	precio numeric,
	dcto numeric,
	total numeric
);


ALTER TYPE inventarios.type_reporte_ventas_detalladas_producto OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_ventas_perdidas; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_ventas_perdidas AS (
	productoid integer,
	producto character varying,
	fecha date,
	numero character varying,
	cliente character varying,
	cantidad numeric,
	ultimo_precio numeric,
	precio_venta numeric,
	importe numeric,
	diferencia numeric,
	tipo_precio character varying
);


ALTER TYPE inventarios.type_reporte_ventas_perdidas OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_ventas_persona; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_ventas_persona AS (
	nombre_persona character varying,
	mes_ano character varying,
	dia character varying,
	fecha date,
	numero character varying,
	moneda character varying,
	simbolo character varying,
	subtotal numeric,
	igv numeric,
	vta_total numeric
);


ALTER TYPE inventarios.type_reporte_ventas_persona OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_ventas_pordia; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_ventas_pordia AS (
	tipodocumentoid integer,
	documento_nombre character varying,
	documento_abreviatura character varying,
	dia integer,
	nombre_dia character varying,
	total numeric
);


ALTER TYPE inventarios.type_reporte_ventas_pordia OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_ventas_vendedor_categoria; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_ventas_vendedor_categoria AS (
	empleado character varying,
	categoria character varying,
	cantidad numeric,
	total numeric
);


ALTER TYPE inventarios.type_reporte_ventas_vendedor_categoria OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_ventas_vendedor_subcategoria; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_ventas_vendedor_subcategoria AS (
	empleado character varying,
	categoria character varying,
	subcategoria character varying,
	cantidad numeric,
	total numeric
);


ALTER TYPE inventarios.type_reporte_ventas_vendedor_subcategoria OWNER TO radiosan_ustaana;

--
-- Name: type_resumen_anuladas_documentos_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_resumen_anuladas_documentos_leer AS (
	resumenid integer,
	tipodocumento character varying,
	serie character varying,
	numero character varying,
	descripcion character varying,
	ventaid integer,
	venta_signo character varying
);


ALTER TYPE inventarios.type_resumen_anuladas_documentos_leer OWNER TO radiosan_ustaana;

--
-- Name: type_resumen_anuladas_getrow; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_resumen_anuladas_getrow AS (
	resumenid integer,
	registro character varying,
	empresaid integer,
	empresa_nombre character varying,
	fecha date,
	contador integer,
	ticket character varying,
	estado integer,
	estado_detalle character varying,
	respuesta character varying,
	respuesta_observacion character varying,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_sexo character varying,
	usuario_foto character varying,
	usuario_usuario character varying,
	ip character varying
);


ALTER TYPE inventarios.type_resumen_anuladas_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_resumen_anuladas_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_resumen_anuladas_leer AS (
	resumenid integer,
	registro character varying,
	empresaid integer,
	empresa_nombre character varying,
	fecha date,
	contador integer,
	cantidad integer,
	ticket character varying,
	estado integer,
	estado_detalle character varying,
	respuesta character varying,
	respuesta_observacion character varying,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_sexo character varying,
	usuario_foto character varying,
	usuario_usuario character varying,
	ip character varying
);


ALTER TYPE inventarios.type_resumen_anuladas_leer OWNER TO radiosan_ustaana;

--
-- Name: type_resumen_diario_getrow; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_resumen_diario_getrow AS (
	resumenid integer,
	registro character varying,
	empresaid integer,
	empresa_nombre character varying,
	fecha date,
	contador integer,
	tipo character varying,
	ticket character varying,
	estado integer,
	estado_detalle character varying,
	respuesta character varying,
	respuesta_observacion character varying,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_sexo character varying,
	usuario_foto character varying,
	usuario_usuario character varying,
	ip character varying
);


ALTER TYPE inventarios.type_resumen_diario_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_resumen_diario_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_resumen_diario_leer AS (
	resumenid integer,
	registro character varying,
	empresaid integer,
	empresa_nombre character varying,
	fecha date,
	contador integer,
	tipo character varying,
	cantidad integer,
	ticket character varying,
	estado integer,
	estado_detalle character varying,
	respuesta character varying,
	respuesta_observacion character varying,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_sexo character varying,
	usuario_foto character varying,
	usuario_usuario character varying,
	ip character varying
);


ALTER TYPE inventarios.type_resumen_diario_leer OWNER TO radiosan_ustaana;

--
-- Name: type_resumen_diario_series_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_resumen_diario_series_leer AS (
	resumenid integer,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	serie character varying,
	inicio integer,
	fin integer,
	grabado numeric,
	exonerado numeric,
	inafecto numeric,
	otros numeric,
	isc numeric,
	igv numeric,
	otros_impuestos numeric,
	total numeric
);


ALTER TYPE inventarios.type_resumen_diario_series_leer OWNER TO radiosan_ustaana;

--
-- Name: type_resumen_diario_venta_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_resumen_diario_venta_leer AS (
	ventaid integer,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	tipodocumento_codigo character varying,
	numero character varying,
	signo character varying,
	cliente_tipdoc character varying,
	cliente_dniruc character varying,
	moneda character varying,
	moneda_nombre character varying,
	moneda_simbolo character varying,
	vta_grabada numeric,
	vta_exonerada numeric,
	igv numeric,
	vta_total numeric
);


ALTER TYPE inventarios.type_resumen_diario_venta_leer OWNER TO radiosan_ustaana;

--
-- Name: type_salida_getdataitem_edit; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_salida_getdataitem_edit AS (
	stock_actual numeric,
	existe boolean,
	cantidad numeric,
	existe_referencia boolean,
	saldo numeric
);


ALTER TYPE inventarios.type_salida_getdataitem_edit OWNER TO radiosan_ustaana;

--
-- Name: type_salida_getrow; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_salida_getrow AS (
	salidaid integer,
	registro character varying,
	empresaid integer,
	empresa_nombre character varying,
	almacenid integer,
	almacen_nombre character varying,
	correlativo integer,
	tipmovmerid integer,
	tipmovmer_nombre character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	numero character varying,
	personaid integer,
	persona_tipo character varying,
	persona_nombre character varying,
	persona_direccion character varying,
	persona_ruc character varying,
	persona_sexo character varying,
	persona_foto character varying,
	fecha date,
	moneda character varying,
	moneda_nombre character varying,
	moneda_simbolo character varying,
	moneda_codigo_contable character varying,
	total numeric,
	cambio numeric,
	cerrado boolean,
	observacion text,
	referencia character varying,
	referenciaid1 integer,
	referenciaid2 integer,
	referenciatexto character varying,
	referenciafecha character varying,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_sexo character varying,
	usuario_foto character varying,
	usuario_usuario character varying,
	caja character varying,
	estado boolean
);


ALTER TYPE inventarios.type_salida_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_salida_imprimir_cabecera; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_salida_imprimir_cabecera AS (
	salidaid integer,
	registro character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	empresa_direccion character varying,
	empresa_ruc character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	correlativo integer,
	correlativo_texto character varying,
	tipmovmerid integer,
	tipmovmer_nombre character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	numero character varying,
	personaid integer,
	persona_nombre character varying,
	persona_direccion character varying,
	persona_ruc character varying,
	persona_sexo character varying,
	persona_foto character varying,
	persona_telefono character varying,
	persona_email character varying,
	fecha character varying,
	moneda character varying,
	moneda_nombre character varying,
	moneda_simbolo character varying,
	moneda_codigo_contable character varying,
	total numeric,
	cambio numeric,
	cerrado boolean,
	observacion text,
	referencia character varying,
	referenciaid1 integer,
	referenciaid2 integer,
	referenciatexto character varying,
	referencia_numero character varying,
	referencia_fecha character varying,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_sexo character varying,
	usuario_foto character varying,
	usuario_usuario character varying,
	caja character varying,
	estado boolean
);


ALTER TYPE inventarios.type_salida_imprimir_cabecera OWNER TO radiosan_ustaana;

--
-- Name: type_salida_imprimir_detalle; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_salida_imprimir_detalle AS (
	salidaid integer,
	productoid integer,
	producto_nombre character varying,
	producto_abreviatura character varying,
	unidadmedidaid integer,
	unidadmedida_nombre character varying,
	unidadmedida_abreviatura character varying,
	cantidad numeric,
	bonificacion numeric,
	precio numeric,
	item smallint,
	observacion text,
	total numeric
);


ALTER TYPE inventarios.type_salida_imprimir_detalle OWNER TO radiosan_ustaana;

--
-- Name: type_salida_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_salida_leer AS (
	salidaid integer,
	zonaid integer,
	zona_nombre character varying,
	zona_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	tipomovimientoid integer,
	tipomovimiento_nombre character varying,
	correlativo integer,
	fecha date,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	numero character varying,
	personaid integer,
	persona_dniruc character varying,
	persona_nombre character varying,
	persona_sexo character varying,
	persona_foto character varying,
	moneda character varying,
	simbolo_moneda character varying,
	total numeric,
	cambio numeric,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_sexo character varying,
	usuario_foto character varying,
	usuario_usuario character varying,
	caja character varying,
	estado boolean,
	cerrado boolean,
	observacion text,
	referencia character varying,
	referenciaid1 integer,
	referenciaid2 integer
);


ALTER TYPE inventarios.type_salida_leer OWNER TO radiosan_ustaana;

--
-- Name: type_salida_leer_items; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_salida_leer_items AS (
	salidaid integer,
	productoid integer,
	producto_nombre character varying,
	producto_abreviatura character varying,
	cantidad numeric,
	bonificacion numeric,
	precio numeric,
	item smallint,
	observacion text,
	total numeric,
	existe_origen boolean
);


ALTER TYPE inventarios.type_salida_leer_items OWNER TO radiosan_ustaana;

--
-- Name: type_salida_leer_por_referencia; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_salida_leer_por_referencia AS (
	salidaid integer,
	registro character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	tipomovimientoid integer,
	tipomovimiento_nombre character varying,
	correlativo integer,
	fecha date,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	numero character varying,
	personaid integer,
	persona_dniruc character varying,
	persona_nombre character varying,
	persona_sexo character varying,
	persona_foto character varying,
	total numeric,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_sexo character varying,
	usuario_foto character varying,
	usuario_usuario character varying,
	caja character varying,
	estado boolean,
	cerrado boolean,
	observacion text,
	cantidad integer,
	total_cantidad numeric,
	cantidad_items_error integer
);


ALTER TYPE inventarios.type_salida_leer_por_referencia OWNER TO radiosan_ustaana;

--
-- Name: type_salida_resumen_tipodocumento; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_salida_resumen_tipodocumento AS (
	tipodocumentoid integer,
	nombre character varying,
	abreviatura character varying
);


ALTER TYPE inventarios.type_salida_resumen_tipodocumento OWNER TO radiosan_ustaana;

--
-- Name: type_serie_consulta; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_serie_consulta AS (
	serieid integer,
	empresaid integer,
	empresa_nombre character varying,
	almacenid integer,
	almacen_nombre character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	tipodocumento_signo character varying,
	detalle character varying,
	serie character varying,
	correlativo bigint,
	caja character varying
);


ALTER TYPE inventarios.type_serie_consulta OWNER TO radiosan_ustaana;

--
-- Name: type_serie_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_serie_leer AS (
	serieid integer,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	tipodocumento_serie character varying,
	serie character varying,
	correlativo bigint,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	estado boolean
);


ALTER TYPE inventarios.type_serie_leer OWNER TO radiosan_ustaana;

--
-- Name: type_stock_inicial_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_stock_inicial_leer AS (
	productoid integer,
	producto character varying,
	categoria character varying,
	subcategoria character varying,
	marca character varying,
	stand character varying,
	precio_va numeric,
	precio_vb numeric,
	precio_vc numeric,
	precio_vd numeric,
	precio_com numeric,
	codigo_barras character varying,
	stock_min integer,
	stock_max integer,
	grabado boolean,
	stock_actual numeric,
	stock_inicial numeric,
	costo_inicial numeric,
	precio_com_inicial numeric,
	precio_ven_inicial numeric,
	vencimiento_inicial character varying,
	lote_inicial character varying
);


ALTER TYPE inventarios.type_stock_inicial_leer OWNER TO radiosan_ustaana;

--
-- Name: type_stock_leer_rango; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_stock_leer_rango AS (
	productoid integer,
	stock numeric
);


ALTER TYPE inventarios.type_stock_leer_rango OWNER TO radiosan_ustaana;

--
-- Name: type_tipo_movimiento_mercaderia_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_tipo_movimiento_mercaderia_leer AS (
	tipmovmerid integer,
	nombre character varying,
	abreviatura character varying,
	codigo_contable character varying,
	orden integer,
	estado boolean
);


ALTER TYPE inventarios.type_tipo_movimiento_mercaderia_leer OWNER TO radiosan_ustaana;

--
-- Name: type_tipo_operacion_consulta; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_tipo_operacion_consulta AS (
	tipoid integer,
	nombre character varying,
	abreviatura character varying,
	codigo_contable character varying,
	orden integer
);


ALTER TYPE inventarios.type_tipo_operacion_consulta OWNER TO radiosan_ustaana;

--
-- Name: type_tipo_operacion_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_tipo_operacion_leer AS (
	tipoid integer,
	nombre character varying,
	abreviatura character varying,
	codigo_contable character varying,
	orden integer,
	estado boolean
);


ALTER TYPE inventarios.type_tipo_operacion_leer OWNER TO radiosan_ustaana;

--
-- Name: type_tipogasto_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_tipogasto_leer AS (
	tipogastoid integer,
	nombre character varying,
	abreviatura character varying,
	codigo_contable character varying,
	orden integer,
	estado boolean
);


ALTER TYPE inventarios.type_tipogasto_leer OWNER TO radiosan_ustaana;

--
-- Name: type_transferencia_getrow; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_transferencia_getrow AS (
	transferenciaid integer,
	registro character varying,
	empresaid integer,
	empresa_nombre character varying,
	fecha date,
	tipmovmerid integer,
	tipmovmer_nombre character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	numero character varying,
	almacenorigenid integer,
	almacenorigen_nombre character varying,
	almacenorigen_abreviatura character varying,
	almacendestinoid integer,
	almacendestino_nombre character varying,
	almacendestino_abreviatura character varying,
	moneda character varying,
	moneda_simbolo character varying,
	observacion text,
	cerrado boolean,
	estado boolean,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	usuario_usuario character varying,
	ip character varying
);


ALTER TYPE inventarios.type_transferencia_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_transferencia_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_transferencia_leer AS (
	transferenciaid integer,
	registro character varying,
	fecha date,
	tipmovmerid integer,
	tipmovmer_nombre character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	numero character varying,
	almacenorigenid integer,
	almacenorigen_nombre character varying,
	almacenorigen_abreviatura character varying,
	salidaid integer,
	salida_detalles character varying,
	almacendestinoid integer,
	almacendestino_nombre character varying,
	almacendestino_abreviatura character varying,
	ingresoid integer,
	ingreso_detalles character varying,
	moneda character varying,
	moneda_simbolo character varying,
	cerrado boolean,
	estado boolean,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	usuario_usuario character varying,
	ip character varying
);


ALTER TYPE inventarios.type_transferencia_leer OWNER TO radiosan_ustaana;

--
-- Name: type_transferencia_leer_items; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_transferencia_leer_items AS (
	transferenciaid integer,
	productoid integer,
	producto character varying,
	cantidad numeric,
	precio numeric,
	orden integer,
	grabado boolean
);


ALTER TYPE inventarios.type_transferencia_leer_items OWNER TO radiosan_ustaana;

--
-- Name: type_traslados_venta_getrow; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_traslados_venta_getrow AS (
	trasladoid integer,
	registro character varying,
	numero character varying,
	almacenorigenid integer,
	almacenorigen_nombre character varying,
	almacendestinoid integer,
	almacendestino_nombre character varying,
	usuariosolicitaid integer,
	usuariosolicita_nombre character varying,
	usuariosolicita_sexo character varying,
	usuariosolicita_foto character varying,
	usuarioconfirmaid integer,
	usuarioconfirma_nombre character varying,
	usuarioconfirma_sexo character varying,
	usuarioconfirma_foto character varying,
	fecha date,
	total numeric,
	confirmado boolean,
	cerrado boolean,
	observacion character varying,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_sexo character varying,
	usuario_foto character varying,
	usuario_usuario character varying,
	caja character varying,
	estado boolean
);


ALTER TYPE inventarios.type_traslados_venta_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_traslados_venta_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_traslados_venta_leer AS (
	trasladoid integer,
	fecha date,
	numero character varying,
	almacenorigenid integer,
	almacen_origen character varying,
	almacendestinoid integer,
	almacen_destino character varying,
	usuariosolicitaid integer,
	usuariosolicita_nombre character varying,
	total numeric,
	usuario character varying,
	caja character varying,
	estado boolean,
	cerrado boolean,
	confirmado boolean,
	observacion character varying
);


ALTER TYPE inventarios.type_traslados_venta_leer OWNER TO radiosan_ustaana;

--
-- Name: type_traslados_venta_leer_items; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_traslados_venta_leer_items AS (
	trasladoid integer,
	productoid integer,
	producto character varying,
	cantidad_solicitada numeric,
	cantidad numeric,
	precio numeric,
	peso numeric,
	grabado boolean
);


ALTER TYPE inventarios.type_traslados_venta_leer_items OWNER TO radiosan_ustaana;

--
-- Name: type_traslados_venta_leer_mensajes; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_traslados_venta_leer_mensajes AS (
	codigo integer,
	detalle character varying
);


ALTER TYPE inventarios.type_traslados_venta_leer_mensajes OWNER TO radiosan_ustaana;

--
-- Name: type_venta_abonos_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_abonos_leer AS (
	referencia character varying,
	referenciaid1 integer,
	referenciaid2 integer,
	registro character varying,
	fecha date,
	panillaid integer,
	planilla_numero integer,
	planilla_cajaid integer,
	plamilla_caja_nombre character varying,
	planilla_detalles character varying,
	tipo character varying,
	tipoid integer,
	tipmovcaj_nombre character varying,
	operacion character varying,
	glosa character varying,
	personaid integer,
	persona_nombre character varying,
	incluirctacte boolean,
	moneda character varying,
	moneda_simbolo character varying,
	importe numeric,
	tipoformapagoid integer,
	tipoformapago_nombre character varying,
	tipoformapago_abreviatura character varying,
	observacion text,
	usuarioid integer,
	usuario_nombre character varying,
	caja character varying,
	estado boolean
);


ALTER TYPE inventarios.type_venta_abonos_leer OWNER TO radiosan_ustaana;

--
-- Name: type_venta_anulacion_detalle_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_anulacion_detalle_leer AS (
	detalleid integer,
	ventaid integer,
	registro character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	numero_detalle character varying,
	estado boolean,
	motivoid integer,
	motivo_nombre character varying,
	observacion character varying,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	usuario_usuario character varying,
	ip character varying
);


ALTER TYPE inventarios.type_venta_anulacion_detalle_leer OWNER TO radiosan_ustaana;

--
-- Name: type_venta_consultar; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_consultar AS (
	ventaid integer,
	tipo smallint,
	fecha date,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	numero character varying,
	clienteid integer,
	cliente_tipo character varying,
	cliente_nrodoc character varying,
	cliente_nombre character varying,
	cliente_foto character varying,
	cliente_sexo character varying,
	moneda character varying,
	simbolo_moneda character varying,
	vta_total numeric,
	saldo numeric,
	usuario character varying,
	caja character varying,
	impresiones integer,
	vendedorid integer,
	vendedor_nombre character varying,
	vendedor_foto character varying,
	vendedor_sexo character varying,
	estado boolean,
	cerrado boolean,
	condicion character varying,
	signo character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	registro character varying,
	total_soles numeric,
	hash character varying,
	sunat_respuesta character varying,
	sunat_respuesta_detalle character varying,
	planillaid integer,
	planilla_numero integer,
	planilla_cajaid integer,
	planilla_caja_nombre character varying,
	planilla_caja_abreviatura character varying,
	planilla_detalles character varying,
	repartozonaid integer,
	repartozona_nombre character varying
);


ALTER TYPE inventarios.type_venta_consultar OWNER TO radiosan_ustaana;

--
-- Name: type_venta_consultar_persona; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_consultar_persona AS (
	ventaid integer,
	tipo smallint,
	fecha date,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	numero character varying,
	clienteid integer,
	cliente_tipo character varying,
	cliente_nrodoc character varying,
	cliente_nombre character varying,
	cliente_foto character varying,
	cliente_sexo character varying,
	moneda character varying,
	moneda_simbolo character varying,
	vta_total numeric,
	abono numeric,
	saldo numeric,
	usuario character varying,
	caja character varying,
	impresiones integer,
	vendedorid integer,
	vendedor_nombre character varying,
	vendedor_foto character varying,
	vendedor_sexo character varying,
	estado boolean,
	cerrado boolean,
	condicion character varying,
	signo character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	registro character varying,
	total_soles numeric,
	hash character varying,
	sunat_respuesta character varying,
	sunat_respuesta_detalle character varying
);


ALTER TYPE inventarios.type_venta_consultar_persona OWNER TO radiosan_ustaana;

--
-- Name: type_venta_consultar_planilla; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_consultar_planilla AS (
	ventaid integer,
	tipo smallint,
	fecha date,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	numero character varying,
	clienteid integer,
	cliente_tipo character varying,
	cliente_nrodoc character varying,
	cliente_nombre character varying,
	cliente_foto character varying,
	cliente_sexo character varying,
	moneda character varying,
	moneda_simbolo character varying,
	vta_total numeric,
	abono numeric,
	saldo numeric,
	usuario character varying,
	caja character varying,
	impresiones integer,
	vendedorid integer,
	vendedor_nombre character varying,
	vendedor_foto character varying,
	vendedor_sexo character varying,
	estado boolean,
	cerrado boolean,
	condicion character varying,
	signo character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	registro character varying,
	total_soles numeric,
	hash character varying,
	sunat_respuesta character varying,
	sunat_respuesta_detalle character varying
);


ALTER TYPE inventarios.type_venta_consultar_planilla OWNER TO radiosan_ustaana;

--
-- Name: type_venta_getdataitem_edit; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_getdataitem_edit AS (
	precio_va numeric,
	precio_vb numeric,
	precio_vc numeric,
	precio_vd numeric,
	servicio boolean,
	stock_actual numeric,
	existe boolean,
	cantidad numeric,
	saldo numeric,
	ultimo_precio_ingreso numeric,
	ultimo_costo_ingreso numeric,
	ultimo_precio_venta numeric,
	unidadmedidaid integer
);


ALTER TYPE inventarios.type_venta_getdataitem_edit OWNER TO radiosan_ustaana;

--
-- Name: type_venta_getestado_salida; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_getestado_salida AS (
	error boolean,
	detalle character varying
);


ALTER TYPE inventarios.type_venta_getestado_salida OWNER TO radiosan_ustaana;

--
-- Name: type_venta_getrow; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_getrow AS (
	ventaid integer,
	tipooperacionid integer,
	tipooperacion_nombre character varying,
	tipooperacion_abreviatura character varying,
	tipooperacion_codigocontable character varying,
	tipo smallint,
	registro character varying,
	opcion integer,
	empresaid integer,
	empresa_nombre character varying,
	almacenid integer,
	almacen_nombre character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	tipodocumento_codigocontable character varying,
	tipodocumento_caracter_contable character varying,
	numero character varying,
	fecha date,
	hora time without time zone,
	hora_texto character varying,
	hora_militar character varying,
	clienteid integer,
	cliente_tipo character varying,
	cliente_razsoc character varying,
	cliente_direccion character varying,
	cliente_distrito character varying,
	cliente_provincia character varying,
	cliente_region character varying,
	cliente_pais character varying,
	cliente_ruc character varying,
	cliente_tipdoc character varying,
	cliente_sexo character varying,
	cliente_foto character varying,
	cliente_tipoid integer,
	cliente_tipoid_nombre character varying,
	cliente_tipoid_abreviatura character varying,
	cliente_tipoid_codigo character varying,
	nombre_cli character varying,
	direccionid integer,
	direcciondespachoid integer,
	direcciondespacho_direccionfull character varying,
	direcciondespacho_ubigeofull character varying,
	direcciondespacho_sucursal character varying,
	direcciondespacho_direccion character varying,
	direcciondespacho_urbanizacion character varying,
	direcciondespacho_referencia character varying,
	direcciondespacho_distritoid integer,
	direcciondespacho_distrito_nombre character varying,
	direcciondespacho_distrito_abreviatura character varying,
	direcciondespacho_distrito_ubigeo character varying,
	direcciondespacho_provinciaid integer,
	direcciondespacho_provincia_nombre character varying,
	direcciondespacho_provincia_abreviatura character varying,
	direcciondespacho_provincia_ubigeo character varying,
	direcciondespacho_departamentoid integer,
	direcciondespacho_departamento_nombre character varying,
	direcciondespacho_departamento_abreviatura character varying,
	direcciondespacho_departamento_ubigeo character varying,
	direcciondespacho_paisid integer,
	direcciondespacho_pais_nombre character varying,
	direcciondespacho_pais_abreviatura character varying,
	direcciondespacho_pais_ubigeo character varying,
	condicion character varying,
	vta_bruta numeric,
	descuento numeric,
	igv numeric,
	vta_gratuita numeric,
	vta_inafecta numeric,
	isc numeric,
	otros_tributos numeric,
	otros_cargos numeric,
	descuento_global_porc numeric,
	descuento_global numeric,
	percepcion numeric,
	vta_total numeric,
	vta_grabada numeric,
	vta_exonerada numeric,
	valor_igv numeric,
	moneda character varying,
	moneda_nombre character varying,
	moneda_simbolo character varying,
	moneda_codigo_contable character varying,
	cambio numeric,
	comision numeric,
	impresiones smallint,
	descontar_stock boolean,
	cerrado boolean,
	signo character varying,
	referenciaid integer,
	referenciatipdocid integer,
	referenciatipdoc_nombre character varying,
	referenciatipdoc_abreviatura character varying,
	referenciatipdoc_codigo_contable character varying,
	referenciatipdoc_caracter character varying,
	referencia_numero character varying,
	referenciamotivoid integer,
	referenciamotivo_nombre character varying,
	referenciamotivo_codigo_contable character varying,
	pedidoid integer,
	redondeo numeric,
	condicionpagoid integer,
	condicionpago_nombre character varying,
	saldo numeric,
	formapago_tipoformapagoid integer,
	formapago_tipotarjetaid integer,
	formapago_bancoid integer,
	formapago_detalle character varying,
	formapago_importe numeric,
	formapago_vuelto numeric,
	observacion character varying,
	vendedorid integer,
	vendedor_nombre character varying,
	vendedor_sexo character varying,
	vendedor_foto character varying,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_sexo character varying,
	usuario_foto character varying,
	sunat_enviado boolean,
	sunat_respuesta character varying,
	sunat_respuesta_detalle character varying,
	caja character varying,
	guias character varying,
	cantidad_items integer,
	cantidad_items_grabados integer,
	cantidad_items_exonerados integer,
	cantidad_items_gratuitos integer,
	cantidad_guias integer,
	hash character varying,
	estado boolean,
	anuladomotivoid integer,
	anuladomotivo_nombre character varying,
	anuladomotivo_codigo_contable character varying,
	anulado_observacion character varying,
	cantidad_porentregar integer,
	salidas_error_saldos integer,
	salidas_error_fecha integer,
	salidas_error_estado integer,
	salidas_error_items integer,
	vencimiento character varying,
	ultimoabono_fecha character varying,
	ultimoabono_moneda character varying,
	ultimoabono_monedasimbolo character varying,
	ultimoabono_importe numeric,
	qrcode character varying,
	qrcode_filename character varying,
	planillaid integer,
	planilla_numero integer,
	planilla_cajaid integer,
	planilla_caja_nombre character varying,
	total_valor_venta numeric,
	total_precio_venta numeric,
	xml_ubl character varying,
	xml_custom character varying,
	detraccion boolean,
	detraccion_numero character varying,
	detraccion_codigo character varying,
	detraccion_fecha date,
	detraccion_fecha_texto character varying,
	detraccion_porcentaje numeric,
	detraccion_porcentaje_texto character varying,
	detraccion_importe numeric,
	detraccion_importe_texto character varying,
	detraccion_banco_codigo character varying,
	detraccion_banco_numero character varying,
	reparto_zonaid integer,
	reparto_zona_nombre character varying,
	reparto_zona_abreviatura character varying,
	reparto_direccion character varying,
	reparto_referencia character varying,
	reparto_telefono character varying
);


ALTER TYPE inventarios.type_venta_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_venta_imprimir_cabecera; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_imprimir_cabecera AS (
	ventaid integer,
	registro character varying,
	registro_fecha character varying,
	registro_hora character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	empresa_direccion character varying,
	empresa_ruc character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	tipodocumento_codigo character varying,
	tipodocumento_caracter character varying,
	numero character varying,
	clienteid integer,
	cliente character varying,
	fecha character varying,
	nombre_cli character varying,
	direccion character varying,
	direccion_full character varying,
	direccion_ciudad character varying,
	tipdocper character varying,
	dni_ruc character varying,
	condicion character varying,
	valor_igv numeric,
	vta_bruta numeric,
	descuento numeric,
	igv numeric,
	vta_total numeric,
	vta_grabada numeric,
	vta_exonerada numeric,
	vta_gratuita numeric,
	vta_inafecta numeric,
	isc numeric,
	otros_tributos numeric,
	otros_cargos numeric,
	descuento_global numeric,
	descuento_global_porc numeric,
	percepcion numeric,
	cambio numeric,
	vendedorid integer,
	vendedor_nombrefull character varying,
	vendedor_nombre character varying,
	vendedor_usuario character varying,
	usuarioid integer,
	usuario_nombrefull character varying,
	usuario_nombre character varying,
	usuario_usuario character varying,
	caja character varying,
	observacion character varying,
	guia_referencia character varying,
	moneda character varying,
	moneda_simbolo character varying,
	moneda_nombre character varying,
	referenciaid integer,
	referenciatipdocid integer,
	referenciatipdoc_nombre character varying,
	referenciatipdoc_abreviatura character varying,
	referenciatipdoc_codigo_contable character varying,
	referenciatipdoc_caracter character varying,
	referencia_numero character varying,
	referenciamotivoid integer,
	referenciamotivo_nombre character varying,
	referenciamotivo_codigo_contable character varying,
	formapago_tipoformapagoid integer,
	formapago_tipoformapago_nombre character varying,
	formapago_tipotarjetaid integer,
	formapago_bancoid integer,
	formapago_detalle character varying,
	formapago_importe numeric,
	formapago_vuelto numeric,
	hash character varying,
	anuladomotivoid integer,
	anuladomotivo_nombre character varying,
	anuladomotivo_codigo_contable character varying,
	anulado_observacion character varying,
	fecha_dia integer,
	fecha_mes integer,
	fecha_mes_nombre character varying,
	fecha_ano integer,
	importe_letras character varying,
	subtitulo_igv character varying,
	estado boolean,
	qrcode character varying,
	qrcode_filename character varying,
	tipooperacionid integer,
	tipooperacion_nombre character varying,
	tipooperacion_abreviatura character varying,
	tipooperacion_codigocontable character varying,
	hora character varying,
	direcciondespachoid integer,
	direcciondespacho_direccionfull character varying,
	direcciondespacho_ubigeofull character varying,
	direcciondespacho_sucursal character varying,
	direcciondespacho_direccion character varying,
	direcciondespacho_urbanizacion character varying,
	direcciondespacho_referencia character varying,
	direcciondespacho_distritoid integer,
	direcciondespacho_distrito_nombre character varying,
	direcciondespacho_distrito_abreviatura character varying,
	direcciondespacho_distrito_ubigeo character varying,
	direcciondespacho_provinciaid integer,
	direcciondespacho_provincia_nombre character varying,
	direcciondespacho_provincia_abreviatura character varying,
	direcciondespacho_provincia_ubigeo character varying,
	direcciondespacho_departamentoid integer,
	direcciondespacho_departamento_nombre character varying,
	direcciondespacho_departamento_abreviatura character varying,
	direcciondespacho_departamento_ubigeo character varying,
	direcciondespacho_paisid integer,
	direcciondespacho_pais_nombre character varying,
	direcciondespacho_pais_abreviatura character varying,
	direcciondespacho_pais_ubigeo character varying,
	almacen_direccion character varying,
	almacen_direccion_full character varying,
	almacen_ubicacion character varying,
	almacen_ubigeo character varying,
	almacen_distrito character varying,
	almacen_provincia character varying,
	almacen_departamento character varying,
	almacen_pais character varying,
	empresa_direccion_full character varying,
	empresa_ubicacion character varying,
	empresa_ubigeo character varying,
	empresa_distrito character varying,
	empresa_provincia character varying,
	empresa_departamento character varying,
	empresa_pais character varying,
	detraccion boolean,
	detraccion_codigo character varying,
	detraccion_fecha1 character varying,
	detraccion_fecha2 character varying,
	detraccion_porcentaje numeric,
	detraccion_porcentaje_texto character varying,
	detraccion_importe numeric,
	detraccion_importe_texto character varying,
	detraccion_banco_codigo character varying,
	detraccion_banco_numero character varying,
	detraccion_leyenda text,
	fecha_larga_empresa character varying,
	fecha_larga_almacen character varying,
	reparto_zonaid integer,
	reparto_zona_nombre character varying,
	reparto_zona_abreviatura character varying,
	reparto_direccion character varying,
	reparto_referencia character varying,
	reparto_telefono character varying
);


ALTER TYPE inventarios.type_venta_imprimir_cabecera OWNER TO radiosan_ustaana;

--
-- Name: type_venta_imprimir_detalle; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_imprimir_detalle AS (
	ventaid integer,
	productoid integer,
	producto character varying,
	unidadmedida character varying,
	cantidad numeric,
	gratuito boolean,
	gratuito_texto character varying,
	precio numeric,
	valor_venta numeric,
	descuento_porc numeric,
	descuento_porc_valor numeric,
	descuento_fijo numeric,
	descuento numeric,
	grabado boolean,
	grabado_texto character varying,
	igv numeric,
	isc_porc numeric,
	isc numeric,
	comision numeric,
	item smallint,
	total numeric,
	entregado boolean,
	bonificacion numeric,
	observacion text,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	unidadmedidaid integer,
	unidadmedida_nombre character varying,
	unidadmedida_abreviatura character varying,
	codigo_sunat character varying,
	unidad_medida_codint character varying,
	total_valor_venta numeric,
	tiene_observacion integer
);


ALTER TYPE inventarios.type_venta_imprimir_detalle OWNER TO radiosan_ustaana;

--
-- Name: type_venta_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_leer AS (
	ventaid integer,
	registro character varying,
	tipo smallint,
	fecha date,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	tipodocumento_codigo character varying,
	numero character varying,
	numero_detalle character varying,
	clienteid integer,
	cliente_tipo character varying,
	cliente_nrodoc character varying,
	cliente_nombre character varying,
	cliente_foto character varying,
	cliente_sexo character varying,
	moneda character varying,
	simbolo_moneda character varying,
	vta_total numeric,
	saldo numeric,
	aux_condicion character varying,
	usuario character varying,
	caja character varying,
	impresiones integer,
	vendedorid integer,
	vendedor_nombre character varying,
	vendedor_foto character varying,
	vendedor_sexo character varying,
	estado boolean,
	cerrado boolean,
	condicion character varying,
	signo character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	total_soles numeric,
	hash character varying,
	sunat_respuesta character varying,
	sunat_respuesta_detalle character varying,
	planillaid integer,
	planilla_numero integer,
	planilla_cajaid integer,
	planilla_caja_nombre character varying,
	planilla_caja_abreviatura character varying,
	planilla_detalles character varying,
	repartozonaid integer,
	repartozona_nombre character varying
);


ALTER TYPE inventarios.type_venta_leer OWNER TO radiosan_ustaana;

--
-- Name: type_venta_leer_contingencias_enviar; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_leer_contingencias_enviar AS (
	ventaid integer,
	fecha character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	tipocontingencia_codigo character varying,
	tipooperacion_codigo character varying,
	tipodocumento_codigo character varying,
	serie character varying,
	numero1 character varying,
	numero2 character varying,
	persona_tipdoc character varying,
	persona_dniruc character varying,
	persona_nombre character varying,
	moneda character varying,
	moneda_simbolo character varying,
	moneda_codigo character varying,
	importe_gravado numeric,
	importe_exonerado numeric,
	importe_inafecto numeric,
	importe_igv numeric,
	importe_total numeric,
	notascd_fecha character varying,
	notascd_tipodocumento_codigo character varying,
	notascd_serie character varying,
	notascd_numero character varying,
	signo character varying
);


ALTER TYPE inventarios.type_venta_leer_contingencias_enviar OWNER TO radiosan_ustaana;

--
-- Name: type_venta_leer_contingencias_porinformar; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_leer_contingencias_porinformar AS (
	ventaid integer,
	fecha date,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	tipocontingenciaid integer,
	tipocontingencia_nombre character varying,
	tipocontingencia_codigo character varying,
	tipooperacionid integer,
	tipooperacion_nombre character varying,
	tipooperacion_codigo character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	numero character varying,
	clienteid integer,
	cliente_nombre character varying,
	moneda character varying,
	moneda_simbolo character varying,
	vta_grabada numeric,
	vta_exonerada numeric,
	igv numeric,
	vta_total numeric,
	caja character varying,
	estado boolean,
	condicion character varying,
	signo character varying,
	hash character varying,
	sunat_respuesta character varying,
	sunat_respuesta_detalle character varying,
	referenciaid integer,
	referenciatipodocumentoid integer
);


ALTER TYPE inventarios.type_venta_leer_contingencias_porinformar OWNER TO radiosan_ustaana;

--
-- Name: type_venta_leer_contingencias_porinformar_fechas; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_leer_contingencias_porinformar_fechas AS (
	empresaid integer,
	empresa_nombre character varying,
	fecha date,
	cantidad integer,
	vta_grabada numeric,
	vta_exonerada numeric,
	igv numeric,
	vta_total numeric
);


ALTER TYPE inventarios.type_venta_leer_contingencias_porinformar_fechas OWNER TO radiosan_ustaana;

--
-- Name: type_venta_leer_items; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_leer_items AS (
	ventaid integer,
	productoid integer,
	itemid integer,
	producto character varying,
	producto_peso numeric,
	unidadmedida character varying,
	unidadmedida_codint character varying,
	cantidad numeric,
	gratuito boolean,
	precio numeric,
	valor_venta numeric,
	descuento_porc numeric,
	descuento_porc_valor numeric,
	descuento_fijo numeric,
	descuento numeric,
	grabado boolean,
	igv numeric,
	isc_porc numeric,
	isc numeric,
	comision numeric,
	item smallint,
	lote integer,
	saldo numeric,
	total numeric,
	entregado boolean,
	bonificacion numeric,
	observacion text,
	peso numeric,
	tipocalculo smallint,
	surtidorid integer,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	unidadmedidaid integer,
	unidadmedida_nombre character varying,
	unidadmedida_abreviatura character varying,
	codigo_sunat character varying
);


ALTER TYPE inventarios.type_venta_leer_items OWNER TO radiosan_ustaana;

--
-- Name: type_venta_leer_items_sunat; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_leer_items_sunat AS (
	ventaid integer,
	productoid integer,
	producto character varying,
	producto_peso numeric,
	unidadmedida character varying,
	unidadmedida_codint character varying,
	cantidad numeric,
	gratuito boolean,
	precio numeric,
	valor_venta numeric,
	descuento_porc numeric,
	descuento_porc_valor numeric,
	descuento_fijo numeric,
	descuento numeric,
	grabado boolean,
	igv numeric,
	isc_porc numeric,
	isc numeric,
	comision numeric,
	item smallint,
	lote integer,
	saldo numeric,
	total numeric,
	total_valor_venta numeric,
	entregado boolean,
	bonificacion numeric,
	observacion text,
	peso numeric,
	tipocalculo smallint,
	surtidorid integer,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	unidadmedidaid integer,
	unidadmedida_nombre character varying,
	unidadmedida_abreviatura character varying,
	codigo_sunat character varying
);


ALTER TYPE inventarios.type_venta_leer_items_sunat OWNER TO radiosan_ustaana;

--
-- Name: type_venta_leer_sunat; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_leer_sunat AS (
	ventaid integer,
	fecha date,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	tipodocumento_codigo character varying,
	numero character varying,
	clienteid integer,
	cliente_nombre character varying,
	moneda character varying,
	moneda_simbolo character varying,
	vta_grabada numeric,
	vta_exonerada numeric,
	vta_gratuita numeric,
	igv numeric,
	vta_total numeric,
	caja character varying,
	estado boolean,
	condicion character varying,
	signo character varying,
	hash character varying,
	sunat_respuesta character varying,
	sunat_respuesta_detalle character varying
);


ALTER TYPE inventarios.type_venta_leer_sunat OWNER TO radiosan_ustaana;

--
-- Name: type_venta_leer_sunat_porinformar; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_leer_sunat_porinformar AS (
	ventaid integer,
	fecha date,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	numero character varying,
	clienteid integer,
	cliente_nombre character varying,
	moneda character varying,
	moneda_simbolo character varying,
	vta_grabada numeric,
	vta_exonerada numeric,
	igv numeric,
	vta_total numeric,
	caja character varying,
	estado boolean,
	condicion character varying,
	signo character varying,
	hash character varying,
	sunat_respuesta character varying,
	sunat_respuesta_detalle character varying,
	referenciaid integer,
	referenciatipodocumentoid integer
);


ALTER TYPE inventarios.type_venta_leer_sunat_porinformar OWNER TO radiosan_ustaana;

--
-- Name: type_venta_leer_sunat_porinformar_resumen_diario; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_leer_sunat_porinformar_resumen_diario AS (
	almacenid integer,
	almacen_nombre character varying,
	fecha date,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	tipodocumento_codigo character varying,
	tipodocumento_caracter character varying,
	serie character varying,
	serie_sunat character varying,
	inicio integer,
	fin integer,
	ids text,
	cantidad integer,
	vta_grabada numeric,
	vta_exonerada numeric,
	igv numeric,
	vta_total numeric
);


ALTER TYPE inventarios.type_venta_leer_sunat_porinformar_resumen_diario OWNER TO radiosan_ustaana;

--
-- Name: type_venta_leer_sunat_porinformar_resumen_diario_bydocs; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_leer_sunat_porinformar_resumen_diario_bydocs AS (
	ventaid integer,
	almacenid integer,
	almacen_nombre character varying,
	fecha date,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	tipodocumento_codigo character varying,
	tipodocumento_caracter character varying,
	numero character varying,
	clienteid integer,
	cliente_tipo character varying,
	cliente_razsoc character varying,
	cliente_direccion character varying,
	cliente_distrito character varying,
	cliente_provincia character varying,
	cliente_region character varying,
	cliente_pais character varying,
	cliente_ruc character varying,
	cliente_tipdoc character varying,
	moneda character varying,
	moneda_nombre character varying,
	moneda_simbolo character varying,
	moneda_codigo_contable character varying,
	cambio numeric,
	vta_grabada numeric,
	vta_exonerada numeric,
	vta_gratuita numeric,
	igv numeric,
	vta_total numeric,
	valor_igv numeric,
	estado boolean,
	referenciaid integer,
	referenciatipdocid integer,
	referenciatipdoc_nombre character varying,
	referenciatipdoc_abreviatura character varying,
	referenciatipdoc_codigo_contable character varying,
	referenciatipdoc_caracter character varying,
	referencia_numero character varying,
	referenciamotivoid integer,
	referenciamotivo_nombre character varying,
	referenciamotivo_codigo_contable character varying,
	anuladomotivoid integer,
	anuladomotivo_nombre character varying,
	anuladomotivo_codigo_contable character varying,
	anulado_observacion character varying
);


ALTER TYPE inventarios.type_venta_leer_sunat_porinformar_resumen_diario_bydocs OWNER TO radiosan_ustaana;

--
-- Name: type_venta_leer_sunat_porinformar_resumen_diario_fechas; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_leer_sunat_porinformar_resumen_diario_fechas AS (
	empresaid integer,
	empresa_nombre character varying,
	fecha date,
	cantidad_series integer,
	cantidad integer,
	vta_grabada numeric,
	vta_exonerada numeric,
	igv numeric,
	vta_total numeric
);


ALTER TYPE inventarios.type_venta_leer_sunat_porinformar_resumen_diario_fechas OWNER TO radiosan_ustaana;

--
-- Name: type_venta_leer_sunat_porinformar_resumen_individual; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_leer_sunat_porinformar_resumen_individual AS (
	almacenid integer,
	almacen_nombre character varying,
	cantidad integer,
	informados integer,
	noinformados integer,
	desde date,
	hasta date,
	vta_grabada numeric,
	vta_exonerada numeric,
	igv numeric,
	total numeric
);


ALTER TYPE inventarios.type_venta_leer_sunat_porinformar_resumen_individual OWNER TO radiosan_ustaana;

--
-- Name: type_venta_leer_sunat_voided_porinformar; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_leer_sunat_voided_porinformar AS (
	ventaid integer,
	fecha date,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	tipodocumento_codigo character varying,
	tipodocumento_caracter character varying,
	numero character varying,
	serie character varying,
	serie_sunat character varying,
	numerosolo integer,
	clienteid integer,
	cliente_nombre character varying,
	moneda character varying,
	moneda_simbolo character varying,
	vta_grabada numeric,
	vta_exonerada numeric,
	igv numeric,
	vta_total numeric,
	motivoid integer,
	motivo_nombre character varying,
	motivo_abreviatura character varying,
	motivo_codigo_contable character varying,
	caja character varying,
	condicion character varying,
	signo character varying
);


ALTER TYPE inventarios.type_venta_leer_sunat_voided_porinformar OWNER TO radiosan_ustaana;

--
-- Name: type_venta_leer_sunat_voided_porinformar_fechas; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_leer_sunat_voided_porinformar_fechas AS (
	empresaid integer,
	empresa_nombre character varying,
	fecha date,
	cantidad integer,
	vta_grabada numeric,
	vta_exonerada numeric,
	igv numeric,
	vta_total numeric
);


ALTER TYPE inventarios.type_venta_leer_sunat_voided_porinformar_fechas OWNER TO radiosan_ustaana;

--
-- Name: type_venta_porcobrar_usuario; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_porcobrar_usuario AS (
	ventaid integer,
	tipo smallint,
	fecha date,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	numero character varying,
	clienteid integer,
	cliente_tipo character varying,
	cliente_nrodoc character varying,
	cliente_nombre character varying,
	cliente_foto character varying,
	cliente_sexo character varying,
	moneda character varying,
	simbolo_moneda character varying,
	vta_total numeric,
	saldo numeric,
	usuario character varying,
	caja character varying,
	impresiones integer,
	vendedorid integer,
	vendedor_nombre character varying,
	vendedor_foto character varying,
	vendedor_sexo character varying,
	estado boolean,
	cerrado boolean,
	condicion character varying,
	signo character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	registro character varying,
	total_soles numeric,
	vencimiento character varying
);


ALTER TYPE inventarios.type_venta_porcobrar_usuario OWNER TO radiosan_ustaana;

--
-- Name: type_venta_porentregar; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_porentregar AS (
	ventaid integer,
	registro character varying,
	zonaid integer,
	zona_nombre character varying,
	zona_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	fecha date,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	numero character varying,
	numero_detalle character varying,
	clienteid integer,
	cliente_tipo character varying,
	cliente_nrodoc character varying,
	cliente_nombre character varying,
	cliente_foto character varying,
	cliente_sexo character varying,
	moneda character varying,
	simbolo_moneda character varying,
	vta_total numeric,
	usuario character varying,
	caja character varying,
	impresiones integer,
	vendedorid integer,
	vendedor_nombre character varying,
	vendedor_foto character varying,
	vendedor_sexo character varying,
	estado boolean,
	cerrado boolean,
	condicion character varying,
	signo character varying,
	cantidad_items integer,
	cantidad_total numeric
);


ALTER TYPE inventarios.type_venta_porentregar OWNER TO radiosan_ustaana;

--
-- Name: type_venta_porentregar_byalmacen; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_porentregar_byalmacen AS (
	ventaid integer,
	registro character varying,
	zonaid integer,
	zona_nombre character varying,
	zona_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	fecha date,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	numero character varying,
	numero_detalle character varying,
	clienteid integer,
	cliente_tipo character varying,
	cliente_nrodoc character varying,
	cliente_nombre character varying,
	cliente_foto character varying,
	cliente_sexo character varying,
	moneda character varying,
	simbolo_moneda character varying,
	vta_total numeric,
	usuario character varying,
	caja character varying,
	impresiones integer,
	vendedorid integer,
	vendedor_nombre character varying,
	vendedor_foto character varying,
	vendedor_sexo character varying,
	estado boolean,
	cerrado boolean,
	condicion character varying,
	signo character varying,
	cantidad_items integer,
	cantidad_total numeric
);


ALTER TYPE inventarios.type_venta_porentregar_byalmacen OWNER TO radiosan_ustaana;

--
-- Name: type_venta_porentregar_byalmacen_byproducto; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_porentregar_byalmacen_byproducto AS (
	zonaid integer,
	zona_nombre character varying,
	zona_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	productoid integer,
	producto_nombre character varying,
	producto_abreviatura character varying,
	cantidad_items integer,
	cantidad_clientes integer,
	cantidad_total numeric
);


ALTER TYPE inventarios.type_venta_porentregar_byalmacen_byproducto OWNER TO radiosan_ustaana;

--
-- Name: type_venta_porentregar_byproducto; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_porentregar_byproducto AS (
	zonaid integer,
	zona_nombre character varying,
	zona_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	productoid integer,
	producto_nombre character varying,
	producto_abreviatura character varying,
	cantidad_items integer,
	cantidad_clientes integer,
	cantidad_total numeric
);


ALTER TYPE inventarios.type_venta_porentregar_byproducto OWNER TO radiosan_ustaana;

--
-- Name: type_venta_sunat_detalle_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_sunat_detalle_leer AS (
	id integer,
	registro character varying,
	respuesta character varying,
	respuesta_detalle text,
	usuarioid integer,
	usuario_nombre character varying,
	ip character varying
);


ALTER TYPE inventarios.type_venta_sunat_detalle_leer OWNER TO radiosan_ustaana;

--
-- Name: type_venta_supervision_salidas; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_supervision_salidas AS (
	ventaid integer,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	numero_detalle character varying,
	errores text
);


ALTER TYPE inventarios.type_venta_supervision_salidas OWNER TO radiosan_ustaana;

--
-- Name: type_venta_tiposdocumento_persona; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_tiposdocumento_persona AS (
	tipodocumentoid integer,
	nombre character varying,
	abreviatura character varying
);


ALTER TYPE inventarios.type_venta_tiposdocumento_persona OWNER TO radiosan_ustaana;

--
-- Name: type_venta_tiposdocumento_planilla; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_tiposdocumento_planilla AS (
	tipodocumentoid integer,
	nombre character varying,
	abreviatura character varying
);


ALTER TYPE inventarios.type_venta_tiposdocumento_planilla OWNER TO radiosan_ustaana;

--
-- Name: type_verificar_transferencia; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_verificar_transferencia AS (
	codigo integer,
	producto character varying,
	stock_origen integer,
	stock_proceso integer
);


ALTER TYPE inventarios.type_verificar_transferencia OWNER TO radiosan_ustaana;

--
-- Name: type_zona_getrow; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_zona_getrow AS (
	zonaid integer,
	nombre character varying,
	abreviatura character varying,
	estado boolean
);


ALTER TYPE inventarios.type_zona_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_zona_leer; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_zona_leer AS (
	zonaid integer,
	nombre character varying,
	abreviatura character varying,
	orden integer,
	estado boolean
);


ALTER TYPE inventarios.type_zona_leer OWNER TO radiosan_ustaana;

--
-- Name: type_zona_leer_sistema; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE type_zona_leer_sistema AS (
	zonaid integer,
	nombre character varying,
	abreviatura character varying,
	estado boolean
);


ALTER TYPE inventarios.type_zona_leer_sistema OWNER TO radiosan_ustaana;

--
-- Name: typeresult_pedido; Type: TYPE; Schema: inventarios; Owner: radiosan_ustaana
--

CREATE TYPE typeresult_pedido AS (
	outstate boolean,
	outid integer,
	outnumber integer,
	outerrornumber integer,
	outdescription character varying
);


ALTER TYPE inventarios.typeresult_pedido OWNER TO radiosan_ustaana;

SET search_path = planillas, pg_catalog;

--
-- Name: type_afp_leer; Type: TYPE; Schema: planillas; Owner: radiosan_ustaana
--

CREATE TYPE type_afp_leer AS (
	afpid integer,
	nombre character varying,
	abreviatura character varying,
	tasa numeric,
	comision numeric,
	prima numeric,
	orden integer,
	estado boolean
);


ALTER TYPE planillas.type_afp_leer OWNER TO radiosan_ustaana;

--
-- Name: type_concepto_leer; Type: TYPE; Schema: planillas; Owner: radiosan_ustaana
--

CREATE TYPE type_concepto_leer AS (
	conceptoid integer,
	tipoconceptoid integer,
	tipoconcepto_nombre character varying,
	nombre character varying,
	abreviatura character varying,
	evaluacion character varying,
	tipoingreso character varying,
	tipo character varying,
	variable character varying,
	estado boolean
);


ALTER TYPE planillas.type_concepto_leer OWNER TO radiosan_ustaana;

--
-- Name: type_concepto_non_tipoplanilla_calculo; Type: TYPE; Schema: planillas; Owner: radiosan_ustaana
--

CREATE TYPE type_concepto_non_tipoplanilla_calculo AS (
	conceptoid integer,
	tipoconceptoid integer,
	tipoconcepto_nombre character varying,
	nombre character varying,
	abreviatura character varying,
	evaluacion character varying,
	tipoingreso character varying,
	tipo character varying,
	variable character varying,
	estado boolean
);


ALTER TYPE planillas.type_concepto_non_tipoplanilla_calculo OWNER TO radiosan_ustaana;

--
-- Name: type_concepto_non_tipoplanilla_ingreso; Type: TYPE; Schema: planillas; Owner: radiosan_ustaana
--

CREATE TYPE type_concepto_non_tipoplanilla_ingreso AS (
	conceptoid integer,
	tipoconceptoid integer,
	tipoconcepto_nombre character varying,
	nombre character varying,
	abreviatura character varying,
	evaluacion character varying,
	tipoingreso character varying,
	tipo character varying,
	variable character varying,
	estado boolean
);


ALTER TYPE planillas.type_concepto_non_tipoplanilla_ingreso OWNER TO radiosan_ustaana;

--
-- Name: type_contrato_getrow; Type: TYPE; Schema: planillas; Owner: radiosan_ustaana
--

CREATE TYPE type_contrato_getrow AS (
	contratoid integer,
	registro character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	personaid integer,
	persona_dni character varying,
	persona_nombre character varying,
	persona_sexo character varying,
	persona_foto character varying,
	inicio date,
	fin date,
	tipoplanillaid integer,
	tipoplanilla_nombre character varying,
	tipocontratoid integer,
	tipocontrato_nombre character varying,
	areaid integer,
	area_nombre character varying,
	cargoid integer,
	cargo_nombre character varying,
	turnoid integer,
	turno_nombre character varying,
	horarioid integer,
	horario_nombre character varying,
	nrohijos integer,
	nrohijosescolar integer,
	afpid integer,
	afp_nombre character varying,
	formapagoid integer,
	formapago_nombre character varying,
	formapagobancoid integer,
	formapagobanco_nombre character varying,
	formapagocuenta character varying,
	ctsbancoid integer,
	ctsbanco_nombre character varying,
	ctscuenta character varying,
	ctsmoneda character varying,
	tiposegurosaludid integer,
	tiposegurosalud_nombre character varying,
	sueldobasico numeric,
	observacion text
);


ALTER TYPE planillas.type_contrato_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_contrato_leer; Type: TYPE; Schema: planillas; Owner: radiosan_ustaana
--

CREATE TYPE type_contrato_leer AS (
	contratoid integer,
	registro character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	personaid integer,
	persona_dni character varying,
	persona_nombre character varying,
	persona_sexo character varying,
	persona_foto character varying,
	inicio date,
	fin date,
	tipoplanillaid integer,
	tipoplanilla_nombre character varying,
	tipocontratoid integer,
	tipocontrato_nombre character varying,
	areaid integer,
	area_nombre character varying,
	cargoid integer,
	cargo_nombre character varying,
	sueldobasico numeric
);


ALTER TYPE planillas.type_contrato_leer OWNER TO radiosan_ustaana;

--
-- Name: type_contrato_leer_paraingresodatos; Type: TYPE; Schema: planillas; Owner: radiosan_ustaana
--

CREATE TYPE type_contrato_leer_paraingresodatos AS (
	contratoid integer,
	registro character varying,
	personaid integer,
	persona_dni character varying,
	persona_nombre character varying,
	persona_sexo character varying,
	persona_foto character varying,
	inicio date,
	fin date,
	tipoplanillaid integer,
	tipoplanilla_nombre character varying,
	tipocontratoid integer,
	tipocontrato_nombre character varying,
	areaid integer,
	area_nombre character varying,
	cargoid integer,
	cargo_nombre character varying,
	sueldobasico numeric
);


ALTER TYPE planillas.type_contrato_leer_paraingresodatos OWNER TO radiosan_ustaana;

--
-- Name: type_formapago_leer; Type: TYPE; Schema: planillas; Owner: radiosan_ustaana
--

CREATE TYPE type_formapago_leer AS (
	formapagoid integer,
	nombre character varying,
	abreviatura character varying,
	orden integer,
	estado boolean
);


ALTER TYPE planillas.type_formapago_leer OWNER TO radiosan_ustaana;

--
-- Name: type_horario_leer; Type: TYPE; Schema: planillas; Owner: radiosan_ustaana
--

CREATE TYPE type_horario_leer AS (
	horarioid integer,
	nombre character varying,
	abreviatura character varying,
	orden integer,
	estado boolean
);


ALTER TYPE planillas.type_horario_leer OWNER TO radiosan_ustaana;

--
-- Name: type_periodo_dias_leer; Type: TYPE; Schema: planillas; Owner: radiosan_ustaana
--

CREATE TYPE type_periodo_dias_leer AS (
	tipoperiodo character varying,
	anio integer,
	periodo integer,
	dias integer
);


ALTER TYPE planillas.type_periodo_dias_leer OWNER TO radiosan_ustaana;

--
-- Name: type_planilla_calculo_leer; Type: TYPE; Schema: planillas; Owner: radiosan_ustaana
--

CREATE TYPE type_planilla_calculo_leer AS (
	tipoplanillaid integer,
	empresaid integer,
	empleadoid integer,
	anio integer,
	periodo integer,
	conceptoid integer,
	importe numeric
);


ALTER TYPE planillas.type_planilla_calculo_leer OWNER TO radiosan_ustaana;

--
-- Name: type_planilla_ingreso_leer; Type: TYPE; Schema: planillas; Owner: radiosan_ustaana
--

CREATE TYPE type_planilla_ingreso_leer AS (
	tipoplanillaid integer,
	empresaid integer,
	empleadoid integer,
	anio integer,
	periodo integer,
	conceptoid integer,
	importe numeric
);


ALTER TYPE planillas.type_planilla_ingreso_leer OWNER TO radiosan_ustaana;

--
-- Name: type_tipoconcepto_leer; Type: TYPE; Schema: planillas; Owner: radiosan_ustaana
--

CREATE TYPE type_tipoconcepto_leer AS (
	tipoconceptoid integer,
	nombre character varying,
	abreviatura character varying,
	orden integer,
	estado boolean
);


ALTER TYPE planillas.type_tipoconcepto_leer OWNER TO radiosan_ustaana;

--
-- Name: type_tipocontrato_leer; Type: TYPE; Schema: planillas; Owner: radiosan_ustaana
--

CREATE TYPE type_tipocontrato_leer AS (
	tipocontratoid integer,
	nombre character varying,
	abreviatura character varying,
	orden integer,
	estado boolean
);


ALTER TYPE planillas.type_tipocontrato_leer OWNER TO radiosan_ustaana;

--
-- Name: type_tipoplanilla_calculo_leer; Type: TYPE; Schema: planillas; Owner: radiosan_ustaana
--

CREATE TYPE type_tipoplanilla_calculo_leer AS (
	conceptoid integer,
	tipoconceptoid integer,
	tipoconcepto_nombre character varying,
	concepto_nombre character varying,
	concepto_abreviatura character varying,
	concepto_variable character varying,
	"grupóid" integer,
	subgrupoid integer,
	formula text,
	orden integer
);


ALTER TYPE planillas.type_tipoplanilla_calculo_leer OWNER TO radiosan_ustaana;

--
-- Name: type_tipoplanilla_ingreso_leer; Type: TYPE; Schema: planillas; Owner: radiosan_ustaana
--

CREATE TYPE type_tipoplanilla_ingreso_leer AS (
	conceptoid integer,
	tipoconceptoid integer,
	tipoconcepto_nombre character varying,
	concepto_nombre character varying,
	concepto_abreviatura character varying,
	concepto_evaluacion character varying,
	concepto_tipoingreso character varying,
	concepto_tipo character varying,
	concepto_variable character varying,
	titulo character varying,
	descripcion character varying,
	orden integer,
	estado boolean
);


ALTER TYPE planillas.type_tipoplanilla_ingreso_leer OWNER TO radiosan_ustaana;

--
-- Name: type_tipoplanilla_leer; Type: TYPE; Schema: planillas; Owner: radiosan_ustaana
--

CREATE TYPE type_tipoplanilla_leer AS (
	tipoplanillaid integer,
	nombre character varying,
	abreviatura character varying,
	tipo_periodo character varying,
	cantidad_periodos integer,
	orden integer,
	estado boolean
);


ALTER TYPE planillas.type_tipoplanilla_leer OWNER TO radiosan_ustaana;

--
-- Name: type_tiposegurosalud_leer; Type: TYPE; Schema: planillas; Owner: radiosan_ustaana
--

CREATE TYPE type_tiposegurosalud_leer AS (
	tiposegurosaludid integer,
	nombre character varying,
	abreviatura character varying,
	orden integer,
	estado boolean
);


ALTER TYPE planillas.type_tiposegurosalud_leer OWNER TO radiosan_ustaana;

--
-- Name: type_turno_leer; Type: TYPE; Schema: planillas; Owner: radiosan_ustaana
--

CREATE TYPE type_turno_leer AS (
	turnoid integer,
	nombre character varying,
	abreviatura character varying,
	orden integer,
	estado boolean
);


ALTER TYPE planillas.type_turno_leer OWNER TO radiosan_ustaana;

SET search_path = public, pg_catalog;

--
-- Name: type_config_query; Type: TYPE; Schema: public; Owner: radiosan_ustaana
--

CREATE TYPE type_config_query AS (
	unidadid integer,
	procesomatriculaid integer,
	periodoid integer,
	nivelid integer,
	gradoid integer,
	gradoseccionid integer,
	configgroupid integer,
	configsubgroupid integer,
	configvarsid integer,
	configvars_name character varying,
	valor text
);


ALTER TYPE public.type_config_query OWNER TO radiosan_ustaana;

--
-- Name: type_config_read; Type: TYPE; Schema: public; Owner: radiosan_ustaana
--

CREATE TYPE type_config_read AS (
	unidadid integer,
	procesomatriculaid integer,
	periodoid integer,
	nivelid integer,
	gradoid integer,
	gradoseccionid integer,
	configgroupid integer,
	configsubgroupid integer,
	configvarsid integer,
	valor text
);


ALTER TYPE public.type_config_read OWNER TO radiosan_ustaana;

--
-- Name: type_configgroup_read; Type: TYPE; Schema: public; Owner: radiosan_ustaana
--

CREATE TYPE type_configgroup_read AS (
	configgroupid integer,
	name character varying,
	description character varying,
	"order" integer,
	status boolean,
	count_subgroup integer
);


ALTER TYPE public.type_configgroup_read OWNER TO radiosan_ustaana;

--
-- Name: type_configsubgroup_getrowbyname; Type: TYPE; Schema: public; Owner: radiosan_ustaana
--

CREATE TYPE type_configsubgroup_getrowbyname AS (
	configsubgroupid integer,
	name character varying,
	description character varying,
	configgroupid integer,
	configgroup_name character varying,
	configgroup_description character varying
);


ALTER TYPE public.type_configsubgroup_getrowbyname OWNER TO radiosan_ustaana;

--
-- Name: type_configsubgroup_read; Type: TYPE; Schema: public; Owner: radiosan_ustaana
--

CREATE TYPE type_configsubgroup_read AS (
	configsubgroupid integer,
	name character varying,
	description character varying,
	"order" integer,
	status boolean,
	configgroupid integer,
	configgroup_name character varying,
	count_vars integer
);


ALTER TYPE public.type_configsubgroup_read OWNER TO radiosan_ustaana;

--
-- Name: type_configsubgroupvars_read; Type: TYPE; Schema: public; Owner: radiosan_ustaana
--

CREATE TYPE type_configsubgroupvars_read AS (
	configvarsid integer,
	name character varying,
	description character varying,
	inputtype character varying,
	length integer,
	min integer,
	max integer,
	"order" integer,
	count_values integer
);


ALTER TYPE public.type_configsubgroupvars_read OWNER TO radiosan_ustaana;

--
-- Name: type_configvalues_read; Type: TYPE; Schema: public; Owner: radiosan_ustaana
--

CREATE TYPE type_configvalues_read AS (
	configvaluesid integer,
	value character varying,
	description character varying,
	"order" integer,
	status boolean,
	configvaluestypeid integer,
	configvaluestype_name character varying,
	count_vars integer
);


ALTER TYPE public.type_configvalues_read OWNER TO radiosan_ustaana;

--
-- Name: type_configvalues_read_non_configvars; Type: TYPE; Schema: public; Owner: radiosan_ustaana
--

CREATE TYPE type_configvalues_read_non_configvars AS (
	configvaluesid integer,
	value character varying,
	description character varying,
	"order" integer,
	status boolean,
	count_values integer,
	configvaluestypeid integer,
	configvaluestype_name character varying
);


ALTER TYPE public.type_configvalues_read_non_configvars OWNER TO radiosan_ustaana;

--
-- Name: type_configvaluestype_read; Type: TYPE; Schema: public; Owner: radiosan_ustaana
--

CREATE TYPE type_configvaluestype_read AS (
	configvaluestypeid integer,
	name character varying,
	"order" integer,
	status boolean,
	count_values integer
);


ALTER TYPE public.type_configvaluestype_read OWNER TO radiosan_ustaana;

--
-- Name: type_configvars_read; Type: TYPE; Schema: public; Owner: radiosan_ustaana
--

CREATE TYPE type_configvars_read AS (
	configvarsid integer,
	name character varying,
	description character varying,
	type character varying,
	length integer,
	min integer,
	max integer,
	inputtype character varying,
	"order" integer,
	status boolean,
	configvarstypeid integer,
	configvarstype_name character varying,
	count_values integer
);


ALTER TYPE public.type_configvars_read OWNER TO radiosan_ustaana;

--
-- Name: type_configvars_read_non_configsubgroups; Type: TYPE; Schema: public; Owner: radiosan_ustaana
--

CREATE TYPE type_configvars_read_non_configsubgroups AS (
	configvarsid integer,
	name character varying,
	description character varying,
	type character varying,
	length integer,
	min integer,
	max integer,
	inputtype character varying,
	"order" integer,
	status boolean,
	count_values integer
);


ALTER TYPE public.type_configvars_read_non_configsubgroups OWNER TO radiosan_ustaana;

--
-- Name: type_configvarstype_read; Type: TYPE; Schema: public; Owner: radiosan_ustaana
--

CREATE TYPE type_configvarstype_read AS (
	configvarstypeid integer,
	name character varying,
	"order" integer,
	status boolean,
	count_vars integer
);


ALTER TYPE public.type_configvarstype_read OWNER TO radiosan_ustaana;

--
-- Name: type_configvarsvalues_query; Type: TYPE; Schema: public; Owner: radiosan_ustaana
--

CREATE TYPE type_configvarsvalues_query AS (
	configvaluesid integer,
	value character varying,
	description character varying
);


ALTER TYPE public.type_configvarsvalues_query OWNER TO radiosan_ustaana;

--
-- Name: type_configvarsvalues_read; Type: TYPE; Schema: public; Owner: radiosan_ustaana
--

CREATE TYPE type_configvarsvalues_read AS (
	configvaluesid integer,
	value character varying,
	description character varying,
	"order" integer
);


ALTER TYPE public.type_configvarsvalues_read OWNER TO radiosan_ustaana;

--
-- Name: type_configvarsvalues_read_group; Type: TYPE; Schema: public; Owner: radiosan_ustaana
--

CREATE TYPE type_configvarsvalues_read_group AS (
	configvarsid integer,
	configvaluesid integer,
	value character varying,
	description character varying,
	"order" integer
);


ALTER TYPE public.type_configvarsvalues_read_group OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_alumnos_libres; Type: TYPE; Schema: public; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_alumnos_libres AS (
	codigo_alu integer,
	alumno character varying,
	codigo_gra integer,
	grado character varying,
	grado_abreviatura character varying,
	grado_numero integer,
	codigo_grasec integer,
	seccion character varying,
	codigo_per integer,
	periodo character varying,
	periodo_numero integer,
	sexo character varying,
	foto character varying,
	condicion_real character varying,
	estado_mat character varying
);


ALTER TYPE public.type_reporte_alumnos_libres OWNER TO radiosan_ustaana;

--
-- Name: type_result_general; Type: TYPE; Schema: public; Owner: radiosan_ustaana
--

CREATE TYPE type_result_general AS (
	outstate boolean,
	outid integer,
	outerrornumber integer,
	outdescription text
);


ALTER TYPE public.type_result_general OWNER TO radiosan_ustaana;

--
-- Name: type_tablas_relacionadas; Type: TYPE; Schema: public; Owner: radiosan_ustaana
--

CREATE TYPE type_tablas_relacionadas AS (
	schema character varying,
	tabla character varying,
	campo character varying
);


ALTER TYPE public.type_tablas_relacionadas OWNER TO radiosan_ustaana;

--
-- Name: type_tablas_relacionadas_registros; Type: TYPE; Schema: public; Owner: radiosan_ustaana
--

CREATE TYPE type_tablas_relacionadas_registros AS (
	schema name,
	tabla name,
	campo name,
	cantidad integer
);


ALTER TYPE public.type_tablas_relacionadas_registros OWNER TO radiosan_ustaana;

--
-- Name: typeresult; Type: TYPE; Schema: public; Owner: radiosan_ustaana
--

CREATE TYPE typeresult AS (
	outstate boolean,
	outid integer,
	outerrornumber integer,
	outdescription character varying
);


ALTER TYPE public.typeresult OWNER TO radiosan_ustaana;

SET search_path = rastro, pg_catalog;

--
-- Name: type_ingreso_leer; Type: TYPE; Schema: rastro; Owner: radiosan_ustaana
--

CREATE TYPE type_ingreso_leer AS (
	tipoedit character varying,
	registro character varying,
	ingresoid integer,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	tipomovimientoid integer,
	tipomovimiento_nombre character varying,
	correlativo integer,
	fecha date,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	numero character varying,
	personaid integer,
	persona_dniruc character varying,
	persona_nombre character varying,
	persona_sexo character varying,
	persona_foto character varying,
	moneda character varying,
	moneda_simbolo character varying,
	total numeric,
	cambio numeric,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_sexo character varying,
	usuario_foto character varying,
	usuario_usuario character varying,
	caja character varying,
	estado boolean,
	cerrado boolean,
	observacion text,
	referencia character varying,
	referenciaid1 integer,
	referenciaid2 integer,
	referencia_detalle character varying,
	referencia_texto character varying
);


ALTER TYPE rastro.type_ingreso_leer OWNER TO radiosan_ustaana;

--
-- Name: type_ingreso_leer_items; Type: TYPE; Schema: rastro; Owner: radiosan_ustaana
--

CREATE TYPE type_ingreso_leer_items AS (
	tipoedit character varying,
	ingresoid integer,
	productoid integer,
	producto_nombre character varying,
	producto_abreviatura character varying,
	cantidad numeric,
	bonificacion numeric,
	precio numeric,
	item smallint,
	observacion text,
	total numeric
);


ALTER TYPE rastro.type_ingreso_leer_items OWNER TO radiosan_ustaana;

--
-- Name: type_ingresoedit_getrow; Type: TYPE; Schema: rastro; Owner: radiosan_ustaana
--

CREATE TYPE type_ingresoedit_getrow AS (
	ingresoeditid integer,
	ingresoid integer,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_sexo character varying,
	usuario_foto character varying,
	usuario_usuario character varying,
	tipo character varying,
	registro character varying,
	ip character varying,
	estado smallint
);


ALTER TYPE rastro.type_ingresoedit_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_ingresoedit_leer; Type: TYPE; Schema: rastro; Owner: radiosan_ustaana
--

CREATE TYPE type_ingresoedit_leer AS (
	ingresoeditid integer,
	tipoedit character varying,
	registro character varying,
	ingresoid integer,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	correlativo integer,
	tipodocumento_abreviatura character varying,
	tipodocumento_nombre character varying,
	numero character varying,
	personaid integer,
	persona_nombre character varying,
	moneda character varying,
	moneda_simbolo character varying,
	total numeric,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_usuario character varying,
	ip character varying,
	estado smallint
);


ALTER TYPE rastro.type_ingresoedit_leer OWNER TO radiosan_ustaana;

--
-- Name: type_ordencompra_detalle_leer; Type: TYPE; Schema: rastro; Owner: radiosan_ustaana
--

CREATE TYPE type_ordencompra_detalle_leer AS (
	tipoedit character varying,
	ordencompraid integer,
	productoid integer,
	producto character varying,
	unidadmedida character varying,
	unidadmedida_codint character varying,
	cantidad numeric,
	gratuito boolean,
	valor_venta numeric,
	precio numeric,
	descuento_porc numeric,
	descuento_porc_valor numeric,
	descuento_fijo numeric,
	descuento numeric,
	grabado boolean,
	igv numeric,
	item smallint,
	total numeric,
	bonificacion numeric,
	observacion text,
	tipocalculo smallint,
	saldo numeric
);


ALTER TYPE rastro.type_ordencompra_detalle_leer OWNER TO radiosan_ustaana;

--
-- Name: type_ordencompra_leer; Type: TYPE; Schema: rastro; Owner: radiosan_ustaana
--

CREATE TYPE type_ordencompra_leer AS (
	ordencompraeditid integer,
	tipoedit character varying,
	ordencompraid integer,
	registro character varying,
	empresaid integer,
	empresa_nombre character varying,
	correlativo integer,
	fecha date,
	proveedorid integer,
	proveedor_tipo character varying,
	proveedor_nrodoc character varying,
	proveedor_nombre character varying,
	proveedor_foto character varying,
	proveedor_sexo character varying,
	condicionpagoid integer,
	condicionpago_nombre character varying,
	moneda character varying,
	moneda_simbolo character varying,
	paraareaid integer,
	paraarea_nombre character varying,
	entrega_fecha date,
	entrega_lugar character varying,
	doc_ref character varying,
	gratuito numeric,
	exonerado numeric,
	grabado numeric,
	igv numeric,
	descuento numeric,
	descuento_global numeric,
	descuento_global_porc numeric,
	total numeric,
	valor_igv numeric,
	referencia character varying,
	codigo_ref1 integer,
	codigo_ref2 integer,
	observacion character varying,
	estadoactual integer,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	usuario_usuario character varying,
	caja character varying,
	estado boolean,
	total_soles numeric
);


ALTER TYPE rastro.type_ordencompra_leer OWNER TO radiosan_ustaana;

--
-- Name: type_ordencompraedit_getrow; Type: TYPE; Schema: rastro; Owner: radiosan_ustaana
--

CREATE TYPE type_ordencompraedit_getrow AS (
	ordencompraeditid integer,
	ordencompraid integer,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_sexo character varying,
	usuario_foto character varying,
	usuario_usuario character varying,
	tipo character varying,
	registro character varying,
	ip character varying,
	estado smallint
);


ALTER TYPE rastro.type_ordencompraedit_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_ordencompraedit_leer; Type: TYPE; Schema: rastro; Owner: radiosan_ustaana
--

CREATE TYPE type_ordencompraedit_leer AS (
	ordencompraeditid integer,
	tipoedit character varying,
	registro character varying,
	ordencompraid integer,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	correlativo integer,
	proveedorid integer,
	proveedor_nombre character varying,
	condicionpagoid integer,
	condicionpago_nombre character varying,
	moneda character varying,
	moneda_simbolo character varying,
	total numeric,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_usuario character varying,
	ip character varying,
	estado smallint
);


ALTER TYPE rastro.type_ordencompraedit_leer OWNER TO radiosan_ustaana;

--
-- Name: type_persona_email_read; Type: TYPE; Schema: rastro; Owner: radiosan_ustaana
--

CREATE TYPE type_persona_email_read AS (
	tipoedit character varying,
	codigo integer,
	personaid integer,
	tipoemailid integer,
	tipo_email_nombre character varying,
	email character varying,
	nombre character varying,
	main boolean,
	publico boolean,
	tipo_email_requerido boolean
);


ALTER TYPE rastro.type_persona_email_read OWNER TO radiosan_ustaana;

--
-- Name: type_persona_juridica_leer; Type: TYPE; Schema: rastro; Owner: radiosan_ustaana
--

CREATE TYPE type_persona_juridica_leer AS (
	personaeditid integer,
	tipoedit character varying,
	personaid integer,
	raz_soc character varying,
	ruc character varying
);


ALTER TYPE rastro.type_persona_juridica_leer OWNER TO radiosan_ustaana;

--
-- Name: type_persona_leer; Type: TYPE; Schema: rastro; Owner: radiosan_ustaana
--

CREATE TYPE type_persona_leer AS (
	personaeditid integer,
	tipoedit character varying,
	personaid integer,
	tipo character varying,
	nombre_comercial character varying,
	direccion character varying,
	telefono character varying,
	email character varying,
	estado boolean,
	registro_text character varying,
	rol character varying,
	distritoid integer,
	distrito_nombre character varying,
	provinciaid integer,
	provincia_nombre character varying,
	departamentoid integer,
	departamento_nombre character varying
);


ALTER TYPE rastro.type_persona_leer OWNER TO radiosan_ustaana;

--
-- Name: type_persona_natural_leer; Type: TYPE; Schema: rastro; Owner: radiosan_ustaana
--

CREATE TYPE type_persona_natural_leer AS (
	personaeditid integer,
	tipoedit character varying,
	personaid integer,
	ape_pat character varying,
	ape_mat character varying,
	nombre character varying,
	sexo character varying,
	est_civil character varying,
	nacimiento date,
	dni character varying,
	titulo character varying
);


ALTER TYPE rastro.type_persona_natural_leer OWNER TO radiosan_ustaana;

--
-- Name: type_persona_socialmedia_leer; Type: TYPE; Schema: rastro; Owner: radiosan_ustaana
--

CREATE TYPE type_persona_socialmedia_leer AS (
	tipoedit character varying,
	personaid integer,
	tiposocialmediaid integer,
	tipo_socialmedia_nombre character varying,
	url character varying
);


ALTER TYPE rastro.type_persona_socialmedia_leer OWNER TO radiosan_ustaana;

--
-- Name: type_persona_telefono_leer; Type: TYPE; Schema: rastro; Owner: radiosan_ustaana
--

CREATE TYPE type_persona_telefono_leer AS (
	tipoedit character varying,
	codigo integer,
	personaid integer,
	tipotelefonoid integer,
	tipo_telefono_nombre character varying,
	numero character varying,
	nombre character varying,
	main boolean,
	publico boolean,
	tipo_email_requerido boolean
);


ALTER TYPE rastro.type_persona_telefono_leer OWNER TO radiosan_ustaana;

--
-- Name: type_personaedit_leer; Type: TYPE; Schema: rastro; Owner: radiosan_ustaana
--

CREATE TYPE type_personaedit_leer AS (
	personaeditid integer,
	tipoedit character varying,
	registro character varying,
	personaid integer,
	tipo character varying,
	nombre_persona character varying,
	rol character varying,
	usuarioid integer,
	usuario character varying,
	ip character varying,
	estado smallint
);


ALTER TYPE rastro.type_personaedit_leer OWNER TO radiosan_ustaana;

--
-- Name: type_salida_leer; Type: TYPE; Schema: rastro; Owner: radiosan_ustaana
--

CREATE TYPE type_salida_leer AS (
	tipoedit character varying,
	registro character varying,
	salidaid integer,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	tipomovimientoid integer,
	tipomovimiento_nombre character varying,
	correlativo integer,
	fecha date,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	numero character varying,
	personaid integer,
	persona_dniruc character varying,
	persona_nombre character varying,
	persona_sexo character varying,
	persona_foto character varying,
	moneda character varying,
	moneda_simbolo character varying,
	total numeric,
	cambio numeric,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_sexo character varying,
	usuario_foto character varying,
	usuario_usuario character varying,
	caja character varying,
	estado boolean,
	cerrado boolean,
	observacion text,
	referencia character varying,
	referenciaid1 integer,
	referenciaid2 integer,
	referencia_texto character varying
);


ALTER TYPE rastro.type_salida_leer OWNER TO radiosan_ustaana;

--
-- Name: type_salida_leer_items; Type: TYPE; Schema: rastro; Owner: radiosan_ustaana
--

CREATE TYPE type_salida_leer_items AS (
	tipoedit character varying,
	salidaid integer,
	productoid integer,
	producto_nombre character varying,
	producto_abreviatura character varying,
	cantidad numeric,
	bonificacion numeric,
	precio numeric,
	item smallint,
	observacion text,
	total numeric
);


ALTER TYPE rastro.type_salida_leer_items OWNER TO radiosan_ustaana;

--
-- Name: type_salidaedit_getrow; Type: TYPE; Schema: rastro; Owner: radiosan_ustaana
--

CREATE TYPE type_salidaedit_getrow AS (
	salidaeditid integer,
	salidaid integer,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_sexo character varying,
	usuario_foto character varying,
	usuario_usuario character varying,
	tipo character varying,
	registro character varying,
	ip character varying,
	estado smallint
);


ALTER TYPE rastro.type_salidaedit_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_salidaedit_leer; Type: TYPE; Schema: rastro; Owner: radiosan_ustaana
--

CREATE TYPE type_salidaedit_leer AS (
	salidaeditid integer,
	tipoedit character varying,
	registro character varying,
	salidaid integer,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	correlativo integer,
	tipodocumento_abreviatura character varying,
	tipodocumento_nombre character varying,
	numero character varying,
	personaid integer,
	persona_nombre character varying,
	moneda character varying,
	moneda_simbolo character varying,
	total numeric,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_usuario character varying,
	ip character varying,
	estado smallint
);


ALTER TYPE rastro.type_salidaedit_leer OWNER TO radiosan_ustaana;

--
-- Name: type_venta_detalle_leer; Type: TYPE; Schema: rastro; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_detalle_leer AS (
	tipoedit character varying,
	ventaid integer,
	productoid integer,
	producto character varying,
	producto_peso numeric,
	unidadmedida character varying,
	unidadmedida_codint character varying,
	cantidad numeric,
	gratuito boolean,
	precio numeric,
	valor_venta numeric,
	descuento_porc numeric,
	descuento_porc_valor numeric,
	descuento_fijo numeric,
	descuento numeric,
	grabado boolean,
	igv numeric,
	isc_porc numeric,
	isc numeric,
	comision numeric,
	item smallint,
	lote integer,
	saldo numeric,
	total numeric,
	entregado boolean,
	bonificacion numeric,
	observacion text
);


ALTER TYPE rastro.type_venta_detalle_leer OWNER TO radiosan_ustaana;

--
-- Name: type_venta_leer; Type: TYPE; Schema: rastro; Owner: radiosan_ustaana
--

CREATE TYPE type_venta_leer AS (
	ventaeditid integer,
	tipoedit character varying,
	ventaid integer,
	registro character varying,
	empresaid integer,
	empresa_nombre character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	tipo smallint,
	fecha date,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	numero character varying,
	numero_detalle character varying,
	clienteid integer,
	cliente_tipo character varying,
	cliente_nrodoc character varying,
	cliente_nombre character varying,
	cliente_foto character varying,
	cliente_sexo character varying,
	moneda character varying,
	moneda_simbolo character varying,
	cambio numeric,
	vta_bruta numeric,
	descuento numeric,
	igv numeric,
	vta_grabada numeric,
	vta_exonerada numeric,
	valor_igv numeric,
	vta_total numeric,
	impresiones integer,
	vendedorid integer,
	vendedor_nombre character varying,
	vendedor_foto character varying,
	vendedor_sexo character varying,
	vendedor_usuario character varying,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	usuario_usuario character varying,
	caja character varying,
	observacion character varying,
	estado boolean,
	cerrado boolean,
	condicion character varying,
	signo character varying,
	total_soles numeric,
	condicionpagoid integer,
	condicionpago_nombre character varying,
	hash character varying,
	referenciaid integer,
	referenciatipdocid integer,
	referenciatipdoc_nombre character varying,
	referenciatipdoc_abreviatura character varying,
	referenciatipdoc_codigo_contable character varying,
	referenciatipdoc_caracter character varying,
	referencia_numero character varying,
	referenciamotivoid integer,
	referenciamotivo_nombre character varying
);


ALTER TYPE rastro.type_venta_leer OWNER TO radiosan_ustaana;

--
-- Name: type_ventaedit_getrow; Type: TYPE; Schema: rastro; Owner: radiosan_ustaana
--

CREATE TYPE type_ventaedit_getrow AS (
	ventaeditid integer,
	ventaid integer,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_sexo character varying,
	usuario_foto character varying,
	usuario_usuario character varying,
	tipo character varying,
	registro character varying,
	ip character varying,
	estado smallint
);


ALTER TYPE rastro.type_ventaedit_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_ventaedit_leer; Type: TYPE; Schema: rastro; Owner: radiosan_ustaana
--

CREATE TYPE type_ventaedit_leer AS (
	ventaeditid integer,
	tipoedit character varying,
	registro character varying,
	ventaid integer,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	tipodocumento_abreviatura character varying,
	tipodocumento_nombre character varying,
	numero character varying,
	clienteid integer,
	cliente_nombre character varying,
	moneda character varying,
	moneda_simbolo character varying,
	vta_total numeric,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_usuario character varying,
	ip character varying,
	estado smallint
);


ALTER TYPE rastro.type_ventaedit_leer OWNER TO radiosan_ustaana;

SET search_path = spool, pg_catalog;

--
-- Name: type_atributo_leer; Type: TYPE; Schema: spool; Owner: radiosan_ustaana
--

CREATE TYPE type_atributo_leer AS (
	codigo integer,
	nombre character varying,
	valor character varying,
	cancel character varying,
	codigo_tip integer,
	tipo_impresora character varying
);


ALTER TYPE spool.type_atributo_leer OWNER TO radiosan_ustaana;

--
-- Name: type_detalle_formato_leer; Type: TYPE; Schema: spool; Owner: radiosan_ustaana
--

CREATE TYPE type_detalle_formato_leer AS (
	codigo integer,
	codigo_for integer,
	linea smallint,
	item smallint,
	tipo_area character varying,
	formato character varying,
	nombres_formatos character varying,
	tipo_valor smallint,
	valor character varying,
	tipo_formato smallint,
	alineacion character varying,
	posicion integer,
	mayusculas character varying
);


ALTER TYPE spool.type_detalle_formato_leer OWNER TO radiosan_ustaana;

--
-- Name: type_detalle_formato_leer_permisos; Type: TYPE; Schema: spool; Owner: radiosan_ustaana
--

CREATE TYPE type_detalle_formato_leer_permisos AS (
	codigo_for integer,
	linea smallint,
	item smallint,
	tipo_area character varying,
	formato character varying,
	cancel_formato character varying,
	tipo_valor smallint,
	valor character varying,
	tipo_formato smallint,
	alineacion character varying,
	posicion integer,
	mayusculas character varying,
	condicion boolean,
	condicion_campo character varying,
	condicion_signo character varying,
	condicion_valor character varying
);


ALTER TYPE spool.type_detalle_formato_leer_permisos OWNER TO radiosan_ustaana;

--
-- Name: type_detalle_formato_reporte_leer; Type: TYPE; Schema: spool; Owner: radiosan_ustaana
--

CREATE TYPE type_detalle_formato_reporte_leer AS (
	codigo integer,
	codigo_for integer,
	linea smallint,
	item smallint,
	tipo_area character varying,
	formato character varying,
	nombres_formatos character varying,
	tipo_valor smallint,
	valor character varying,
	tipo_formato smallint,
	alineacion character varying,
	posicion integer,
	mayusculas character varying
);


ALTER TYPE spool.type_detalle_formato_reporte_leer OWNER TO radiosan_ustaana;

--
-- Name: type_formato_leer; Type: TYPE; Schema: spool; Owner: radiosan_ustaana
--

CREATE TYPE type_formato_leer AS (
	codigo integer,
	nombre character varying,
	tipoimpresoraid integer,
	tipoimpresora_nombre character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	modulo character varying
);


ALTER TYPE spool.type_formato_leer OWNER TO radiosan_ustaana;

--
-- Name: type_formato_reporte_leer; Type: TYPE; Schema: spool; Owner: radiosan_ustaana
--

CREATE TYPE type_formato_reporte_leer AS (
	codigo integer,
	nombre character varying,
	codigo_tip integer,
	tipo_impresora character varying,
	grupos character varying,
	linias_cab integer,
	linias_hoja integer,
	linias_pie integer,
	id_rpt character varying
);


ALTER TYPE spool.type_formato_reporte_leer OWNER TO radiosan_ustaana;

SET search_path = sunat, pg_catalog;

--
-- Name: type_codigo_detraccion_leer; Type: TYPE; Schema: sunat; Owner: radiosan_ustaana
--

CREATE TYPE type_codigo_detraccion_leer AS (
	codigo character varying,
	nombre character varying
);


ALTER TYPE sunat.type_codigo_detraccion_leer OWNER TO radiosan_ustaana;

--
-- Name: type_leer_codigos_retorno; Type: TYPE; Schema: sunat; Owner: radiosan_ustaana
--

CREATE TYPE type_leer_codigos_retorno AS (
	codigo character varying,
	descripcion text,
	explicacion text
);


ALTER TYPE sunat.type_leer_codigos_retorno OWNER TO radiosan_ustaana;

--
-- Name: type_producto_consulta; Type: TYPE; Schema: sunat; Owner: radiosan_ustaana
--

CREATE TYPE type_producto_consulta AS (
	segmentoid character varying,
	segmento_nombre character varying,
	familiaid character varying,
	familia_nombre character varying,
	claseid character varying,
	clase_nombre character varying,
	productoid character varying,
	nombre character varying
);


ALTER TYPE sunat.type_producto_consulta OWNER TO radiosan_ustaana;

SET search_path = tesoreria, pg_catalog;

--
-- Name: type_caja_empresa_leer; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_caja_empresa_leer AS (
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	serieid_ingreso integer,
	serieid_ingreso_tipodocumentoid integer,
	serieid_ingreso_tipodocumento_nombre character varying,
	serieid_ingreso_tipodocumento_abreviatura character varying,
	serieid_ingreso_serie character varying,
	serieid_ingreso_serie2 character varying,
	serieid_egreso integer,
	serieid_egreso_tipodocumentoid integer,
	serieid_egreso_tipodocumento_nombre character varying,
	serieid_egreso_tipodocumento_abreviatura character varying,
	serieid_egreso_serie character varying,
	serieid_egreso_serie2 character varying
);


ALTER TYPE tesoreria.type_caja_empresa_leer OWNER TO radiosan_ustaana;

--
-- Name: type_caja_getrow; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_caja_getrow AS (
	cajaid integer,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	nombre character varying,
	abreviatura character varying,
	estructura character varying,
	pcgr_general character varying,
	pcgr_empresarial character varying,
	estado boolean,
	caja_ultimo integer,
	caja_ultimo_numero integer,
	caja_ultimo_fecha date,
	caja_ultimo_saldo numeric,
	caja_ultimo_moneda character varying,
	caja_ultimo_cerrado boolean,
	caja_ultimo_operador integer,
	caja_ultimo_operador_nombre character varying,
	saldo_efectivo_monbas numeric,
	saldo_efectivo_monext numeric,
	saldo_cheque_monbas numeric,
	saldo_cheque_monext numeric
);


ALTER TYPE tesoreria.type_caja_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_caja_getsaldos; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_caja_getsaldos AS (
	saldo_efectivo_monbas numeric,
	saldo_efectivo_monext numeric,
	saldo_cheque_monbas numeric,
	saldo_cheque_monext numeric
);


ALTER TYPE tesoreria.type_caja_getsaldos OWNER TO radiosan_ustaana;

--
-- Name: type_caja_leer; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_caja_leer AS (
	cajaid integer,
	zonaid integer,
	zona_nombre character varying,
	zona_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	nombre character varying,
	abreviatura character varying,
	estructura character varying,
	pcgr_general character varying,
	pcgr_empresarial character varying,
	estado boolean
);


ALTER TYPE tesoreria.type_caja_leer OWNER TO radiosan_ustaana;

--
-- Name: type_cajachica_getrow; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_cajachica_getrow AS (
	cajachicaid integer,
	registro character varying,
	cajanumeroid integer,
	cajanumero_numero integer,
	cajanumero_nombre character varying,
	tipo character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	numero character varying,
	fecha date,
	tipoid integer,
	tipo_nombre character varying,
	personaid integer,
	persona_nombre character varying,
	persona_sexo character varying,
	persona_foto character varying,
	concepto character varying,
	moneda character varying,
	moneda_nombre character varying,
	moneda_simbolo character varying,
	importe numeric,
	cambio numeric,
	tipoformapagoid integer,
	tipoformapago_nombre character varying,
	bancoid integer,
	banco_nombre character varying,
	ctacteid integer,
	ctacte_nombre character varying,
	tipotarjetaid integer,
	tipotarjeta_nombre character varying,
	operacion character varying,
	tipmovid integer,
	tipmov_nombre character varying,
	centrocostoid integer,
	centrocosto_nombre character varying,
	centrogastoid integer,
	centrogasto_nombre character varying,
	observacion character varying,
	referencia character varying,
	referenciaid1 integer,
	referenciaid2 integer,
	cerrado boolean,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_sexo character varying,
	usuario_foto character varying,
	usuario_usuario character varying,
	caja character varying,
	estado boolean
);


ALTER TYPE tesoreria.type_cajachica_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_cajachica_leer; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_cajachica_leer AS (
	cajachicaid integer,
	tipo character varying,
	fecha date,
	cajanumeroid integer,
	cajanumero_numero integer,
	cajanumero_nombre character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	numero character varying,
	tipoid integer,
	tipo_nombre character varying,
	personaid integer,
	persona_nombre character varying,
	concepto character varying,
	tipoformapagoid integer,
	tipoformapago_nombre character varying,
	moneda character varying,
	moneda_nombre character varying,
	moneda_simbolo character varying,
	abono numeric,
	cargo numeric,
	cambio numeric,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_usuario character varying,
	caja character varying,
	cerrado boolean,
	estado boolean,
	observacion character varying,
	referencia character varying,
	referenciaid1 integer,
	referenciaid2 integer
);


ALTER TYPE tesoreria.type_cajachica_leer OWNER TO radiosan_ustaana;

--
-- Name: type_cajanumero_getrow; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_cajanumero_getrow AS (
	cajanumeroid integer,
	registro character varying,
	fecha date,
	fecharendir date,
	cajaid integer,
	caja_nombre character varying,
	numero integer,
	moneda character varying,
	moneda_nombre character varying,
	moneda_simbolo character varying,
	operadorid integer,
	operador_nombre character varying,
	operador_foto character varying,
	operador_sexo character varying,
	operador_usuario character varying,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	usuario_usuario character varying,
	tipoformapagoid integer,
	tipoformapago_nombre character varying,
	bancoid integer,
	banco_nombre character varying,
	ctacteid integer,
	ctacte_nombre character varying,
	operacion character varying,
	tipmovid integer,
	saldoanterior numeric,
	saldo numeric,
	cerrado boolean,
	cerrado_texto character varying,
	fechacierre character varying
);


ALTER TYPE tesoreria.type_cajanumero_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_cajanumero_leer; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_cajanumero_leer AS (
	cajanumeroid integer,
	registro character varying,
	fecha date,
	cajaid integer,
	caja_nombre character varying,
	numero integer,
	moneda character varying,
	moneda_nombre character varying,
	moneda_simbolo character varying,
	operadorid integer,
	operador_nombre character varying,
	operador_foto character varying,
	operador_sexo character varying,
	operador_usuario character varying,
	tipoformapagoid integer,
	tipoformapago_nombre character varying,
	saldoanterior numeric,
	importe numeric,
	saldo numeric,
	cerrado boolean,
	cerrado_texto character varying,
	fechacierre character varying
);


ALTER TYPE tesoreria.type_cajanumero_leer OWNER TO radiosan_ustaana;

--
-- Name: type_cajanumero_leer_abiertas; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_cajanumero_leer_abiertas AS (
	cajanumeroid integer,
	cajaid integer,
	detalles character varying,
	moneda character varying,
	moneda_simbolo character varying,
	tipoformapagoid integer,
	tipoformapago_nombre character varying,
	saldoanterior numeric,
	importe numeric,
	saldo numeric
);


ALTER TYPE tesoreria.type_cajanumero_leer_abiertas OWNER TO radiosan_ustaana;

--
-- Name: type_cajaplanilla_anticipos; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_cajaplanilla_anticipos AS (
	detalleid integer,
	registro character varying,
	fecha date,
	planillaid integer,
	planilla_numero integer,
	tipo character varying,
	tipoid integer,
	tipmovcaj_nombre character varying,
	referencia character varying,
	referenciaid1 integer,
	referenciaid2 integer,
	referencia_detalles character varying,
	operacion character varying,
	glosa character varying,
	personaid integer,
	persona_nombre character varying,
	persona_foto character varying,
	persona_sexo character varying,
	moneda character varying,
	moneda_simbolo character varying,
	importe numeric,
	usado numeric,
	saldo numeric,
	tipoformapagoid integer,
	tipoformapago_nombre character varying,
	observacion text,
	cajaid integer,
	caja_nombre character varying,
	caja_abreviatura character varying,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	caja character varying,
	estado boolean
);


ALTER TYPE tesoreria.type_cajaplanilla_anticipos OWNER TO radiosan_ustaana;

--
-- Name: type_cajaplanilla_detalle_consulta; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_cajaplanilla_detalle_consulta AS (
	detalleid integer,
	registro character varying,
	fecha date,
	tipo character varying,
	tipoid integer,
	tipmovcaj_nombre character varying,
	referencia character varying,
	referenciaid1 integer,
	referenciaid2 integer,
	referencia_detalles character varying,
	operacion character varying,
	glosa character varying,
	personaid integer,
	persona_nombre character varying,
	incluirctacte boolean,
	moneda character varying,
	moneda_simbolo character varying,
	importe numeric,
	importe_usado numeric,
	saldo numeric,
	tipoformapagoid integer,
	tipoformapago_nombre character varying,
	tipoformapago_abreviatura character varying,
	observacion text,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	caja character varying,
	estado boolean
);


ALTER TYPE tesoreria.type_cajaplanilla_detalle_consulta OWNER TO radiosan_ustaana;

--
-- Name: type_cajaplanilla_detalle_consulta_persona; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_cajaplanilla_detalle_consulta_persona AS (
	detalleid integer,
	registro character varying,
	fecha date,
	tipo character varying,
	tipoid integer,
	tipmovcaj_nombre character varying,
	referencia character varying,
	referenciaid1 integer,
	referenciaid2 integer,
	referencia_detalles character varying,
	operacion character varying,
	glosa character varying,
	personaid integer,
	persona_nombre character varying,
	incluirctacte boolean,
	moneda character varying,
	moneda_simbolo character varying,
	importe numeric,
	importe_usado numeric,
	saldo numeric,
	tipoformapagoid integer,
	tipoformapago_nombre character varying,
	tipoformapago_abreviatura character varying,
	observacion text,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	caja character varying,
	estado boolean
);


ALTER TYPE tesoreria.type_cajaplanilla_detalle_consulta_persona OWNER TO radiosan_ustaana;

--
-- Name: type_cajaplanilla_detalle_getrow; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_cajaplanilla_detalle_getrow AS (
	detalleid integer,
	registro character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	empresa_ruc character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	tipodocumento_codigo character varying,
	numero character varying,
	fecha date,
	planillaid integer,
	planilla_numero integer,
	tipo character varying,
	tipoid integer,
	tipo_nombre character varying,
	referencia character varying,
	referenciaid1 integer,
	referenciaid2 integer,
	referencia_detalles character varying,
	operacion character varying,
	glosa character varying,
	personaid integer,
	persona_nombre character varying,
	persona_foto character varying,
	persona_sexo character varying,
	persona_direccion character varying,
	persona_dniruc character varying,
	incluirctacte boolean,
	moneda character varying,
	moneda_nombre character varying,
	moneda_simbolo character varying,
	importe numeric,
	saldo numeric,
	cambio numeric,
	tipoformapagoid integer,
	tipoformapago_nombre character varying,
	tipotarjetaid integer,
	bancoid integer,
	ctacteid integer,
	cheque_tipo character varying,
	cheque_vencimiento date,
	observacion text,
	cajaid integer,
	caja_nombre character varying,
	caja_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	caja character varying,
	estado boolean,
	cerrado boolean,
	aprobado boolean
);


ALTER TYPE tesoreria.type_cajaplanilla_detalle_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_cajaplanilla_detalle_imprimir_cabecera; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_cajaplanilla_detalle_imprimir_cabecera AS (
	detalleid integer,
	registro character varying,
	registro_fecha character varying,
	registro_hora character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	empresa_direccion character varying,
	empresa_ruc character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	tipodocumento_codigo character varying,
	numero character varying,
	fecha date,
	fecha_texto character varying,
	planillaid integer,
	planilla_numero integer,
	planilla_texto character varying,
	tipo character varying,
	tipo_texto character varying,
	tipoid integer,
	tipo_nombre character varying,
	referencia character varying,
	referenciaid1 integer,
	referenciaid2 integer,
	referencia_detalles character varying,
	operacion character varying,
	glosa character varying,
	personaid integer,
	persona_nombre character varying,
	persona_foto character varying,
	persona_sexo character varying,
	persona_direccion character varying,
	persona_direccion_full character varying,
	persona_direccion_ciudad character varying,
	persona_tipdoc character varying,
	persona_dniruc character varying,
	incluirctacte boolean,
	incluirctacte_texto character varying,
	moneda character varying,
	moneda_nombre character varying,
	moneda_simbolo character varying,
	importe numeric,
	saldo numeric,
	cambio numeric,
	tipoformapagoid integer,
	tipoformapago_nombre character varying,
	tipotarjetaid integer,
	tipotarjeta_nombre character varying,
	tipotarjeta_abreviatura character varying,
	bancoid integer,
	banco_nombre character varying,
	banco_abreviatura character varying,
	ctacteid integer,
	ctacte_nombre character varying,
	ctacte_numero character varying,
	cheque_tipo character varying,
	cheque_vencimiento character varying,
	observacion text,
	cajaid integer,
	caja_nombre character varying,
	caja_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	usuarioid integer,
	usuario_nombre_full character varying,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	usuario_usuario character varying,
	caja character varying,
	estado boolean,
	cerrado boolean,
	aprobado boolean
);


ALTER TYPE tesoreria.type_cajaplanilla_detalle_imprimir_cabecera OWNER TO radiosan_ustaana;

--
-- Name: type_cajaplanilla_detalle_imprimir_detalle; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_cajaplanilla_detalle_imprimir_detalle AS (
	id integer,
	registro character varying,
	registro_fecha character varying,
	registro_hora character varying,
	detalleid integer,
	referencia character varying,
	referenciaid1 integer,
	referenciaid2 integer,
	referencia_detalle character varying,
	importe numeric,
	usuarioid integer,
	usuario_nombre_full character varying,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	usuario_usuario character varying,
	ip character varying,
	estado character varying
);


ALTER TYPE tesoreria.type_cajaplanilla_detalle_imprimir_detalle OWNER TO radiosan_ustaana;

--
-- Name: type_cajaplanilla_detalle_incluidos_leer; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_cajaplanilla_detalle_incluidos_leer AS (
	id integer,
	registro character varying,
	detalleid integer,
	referencia character varying,
	referenciaid1 integer,
	referenciaid2 integer,
	referencia_detalle character varying,
	importe numeric,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	ip character varying,
	estado character varying
);


ALTER TYPE tesoreria.type_cajaplanilla_detalle_incluidos_leer OWNER TO radiosan_ustaana;

--
-- Name: type_cajaplanilla_detalle_leer; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_cajaplanilla_detalle_leer AS (
	detalleid integer,
	registro character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	numero character varying,
	numero2 character varying,
	fecha date,
	planillaid integer,
	planilla_numero integer,
	tipo character varying,
	tipoid integer,
	tipmovcaj_nombre character varying,
	referencia character varying,
	referenciaid1 integer,
	referenciaid2 integer,
	referencia_detalles character varying,
	operacion character varying,
	glosa character varying,
	personaid integer,
	persona_nombre character varying,
	persona_foto character varying,
	persona_sexo character varying,
	incluirctacte boolean,
	moneda character varying,
	moneda_simbolo character varying,
	ingreso numeric,
	egreso numeric,
	importe numeric,
	tipoformapagoid integer,
	tipoformapago_nombre character varying,
	observacion text,
	cajaid integer,
	caja_nombre character varying,
	caja_abreviatura character varying,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	caja character varying,
	estado boolean,
	aprobado boolean
);


ALTER TYPE tesoreria.type_cajaplanilla_detalle_leer OWNER TO radiosan_ustaana;

--
-- Name: type_cajaplanilla_detalle_otros_ingresos; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_cajaplanilla_detalle_otros_ingresos AS (
	detalleid integer,
	registro character varying,
	fecha date,
	tipo character varying,
	tipoid integer,
	tipmovcaj_nombre character varying,
	operacion character varying,
	glosa character varying,
	personaid integer,
	persona_nombre character varying,
	incluirctacte boolean,
	moneda character varying,
	moneda_simbolo character varying,
	importe numeric,
	tipoformapagoid integer,
	tipoformapago_nombre character varying,
	tipoformapago_abreviatura character varying,
	observacion text,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	caja character varying,
	estado boolean
);


ALTER TYPE tesoreria.type_cajaplanilla_detalle_otros_ingresos OWNER TO radiosan_ustaana;

--
-- Name: type_cajaplanilla_detalle_persona_pendientes; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_cajaplanilla_detalle_persona_pendientes AS (
	detalleid integer,
	registro character varying,
	fecha date,
	tipo character varying,
	tipoid integer,
	tipmovcaj_nombre character varying,
	referencia character varying,
	referenciaid1 integer,
	referenciaid2 integer,
	referencia_detalles character varying,
	operacion character varying,
	glosa character varying,
	personaid integer,
	persona_nombre character varying,
	incluirctacte boolean,
	moneda character varying,
	moneda_simbolo character varying,
	importe numeric,
	importe_usado numeric,
	saldo numeric,
	tipoformapagoid integer,
	tipoformapago_nombre character varying,
	tipoformapago_abreviatura character varying,
	observacion text,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	caja character varying,
	estado boolean
);


ALTER TYPE tesoreria.type_cajaplanilla_detalle_persona_pendientes OWNER TO radiosan_ustaana;

--
-- Name: type_cajaplanilla_detalle_resumen; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_cajaplanilla_detalle_resumen AS (
	tipo character varying,
	tipoid integer,
	nombre character varying,
	cantidad integer,
	importe numeric
);


ALTER TYPE tesoreria.type_cajaplanilla_detalle_resumen OWNER TO radiosan_ustaana;

--
-- Name: type_cajaplanilla_detalle_resumen_empresa; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_cajaplanilla_detalle_resumen_empresa AS (
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	empresa_ruc character varying,
	tipoformapagoid integer,
	tipoformapago_nombre character varying,
	tipoformapago_abreviatura character varying,
	monbas_ingreso numeric,
	monbas_egreso numeric,
	monbas_saldo numeric,
	monext_ingreso numeric,
	monext_egreso numeric,
	monext_saldo numeric
);


ALTER TYPE tesoreria.type_cajaplanilla_detalle_resumen_empresa OWNER TO radiosan_ustaana;

--
-- Name: type_cajaplanilla_detalle_tipmovcaja; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_cajaplanilla_detalle_tipmovcaja AS (
	tipoid integer,
	nombre character varying,
	abreviatura character varying,
	tipo character varying,
	estructura character varying,
	pcgr_general character varying,
	pcgr_empresarial character varying,
	estado boolean
);


ALTER TYPE tesoreria.type_cajaplanilla_detalle_tipmovcaja OWNER TO radiosan_ustaana;

--
-- Name: type_cajaplanilla_detalle_tipmovcaja_persona; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_cajaplanilla_detalle_tipmovcaja_persona AS (
	tipoid integer,
	nombre character varying,
	abreviatura character varying,
	tipo character varying,
	estructura character varying,
	pcgr_general character varying,
	pcgr_empresarial character varying,
	estado boolean
);


ALTER TYPE tesoreria.type_cajaplanilla_detalle_tipmovcaja_persona OWNER TO radiosan_ustaana;

--
-- Name: type_cajaplanilla_getresumen; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_cajaplanilla_getresumen AS (
	planillaid integer,
	ingreso numeric,
	ingreso_monbas numeric,
	ingreso_monext numeric,
	ingefe_monbas numeric,
	ingefe_monext numeric,
	ingche_monbas numeric,
	ingche_monext numeric,
	ingtar_monbas numeric,
	ingtar_monext numeric,
	ingbco_monbas numeric,
	ingbco_monext numeric,
	egreso numeric,
	egreso_monbas numeric,
	egreso_monext numeric,
	egrefe_monbas numeric,
	egrefe_monext numeric,
	egrche_monbas numeric,
	egrche_monext numeric,
	egrtar_monbas numeric,
	egrtar_monext numeric,
	egrbco_monbas numeric,
	egrbco_monext numeric
);


ALTER TYPE tesoreria.type_cajaplanilla_getresumen OWNER TO radiosan_ustaana;

--
-- Name: type_cajaplanilla_getrow; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_cajaplanilla_getrow AS (
	planillaid integer,
	registro character varying,
	cajaid integer,
	caja_nombre character varying,
	caja_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	numero integer,
	fecha date,
	cobradorid integer,
	cobrador_nombre character varying,
	cobrador_foto character varying,
	cobrador_sexo character varying,
	cobrador_usuario character varying,
	observacion text,
	cerrado boolean,
	cerrado_texto character varying,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	usuario_usuario character varying,
	caja character varying,
	ingreso numeric,
	ingreso_monbas numeric,
	ingreso_monext numeric,
	ingefe_monbas numeric,
	ingefe_monext numeric,
	ingche_monbas numeric,
	ingche_monext numeric,
	ingtar_monbas numeric,
	ingtar_monext numeric,
	ingbco_monbas numeric,
	ingbco_monext numeric,
	egreso numeric,
	egreso_monbas numeric,
	egreso_monext numeric,
	egrefe_monbas numeric,
	egrefe_monext numeric,
	egrche_monbas numeric,
	egrche_monext numeric,
	egrtar_monbas numeric,
	egrtar_monext numeric,
	egrbco_monbas numeric,
	egrbco_monext numeric,
	ventas_contado_monbas numeric,
	ventas_contado_monext numeric,
	ventas_credito_monbas numeric,
	ventas_credito_monext numeric,
	ventas_monbas numeric,
	ventas_monext numeric,
	porcobrar_monbas numeric,
	porcobrar_monext numeric,
	cobrado_monbas numeric,
	cobrado_monext numeric,
	notcre_monbas numeric,
	notcre_monext numeric,
	notdeb_monbas numeric,
	notdeb_monext numeric
);


ALTER TYPE tesoreria.type_cajaplanilla_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_cajaplanilla_leer; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_cajaplanilla_leer AS (
	planillaid integer,
	registro character varying,
	fecha date,
	cajaid integer,
	caja_nombre character varying,
	caja_abreviatura character varying,
	numero integer,
	cobradorid integer,
	cobrador_nombre character varying,
	cobrador_foto character varying,
	cobrador_sexo character varying,
	cobrador_usuario character varying,
	cerrado boolean,
	cerrado_texto character varying,
	observacion text,
	saldo_soles numeric,
	saldo_dolares numeric
);


ALTER TYPE tesoreria.type_cajaplanilla_leer OWNER TO radiosan_ustaana;

--
-- Name: type_cajaplanilla_leer_abiertas; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_cajaplanilla_leer_abiertas AS (
	planillaid integer,
	registro character varying,
	fecha date,
	cajaid integer,
	caja_nombre character varying,
	caja_abreviatura character varying,
	numero integer,
	cobradorid integer,
	cobrador_nombre character varying,
	cobrador_foto character varying,
	cobrador_sexo character varying,
	cobrador_usuario character varying,
	observacion text,
	saldo_soles numeric,
	saldo_dolares numeric
);


ALTER TYPE tesoreria.type_cajaplanilla_leer_abiertas OWNER TO radiosan_ustaana;

--
-- Name: type_cajaplanilla_leer_abiertas_usuario; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_cajaplanilla_leer_abiertas_usuario AS (
	planillaid integer,
	fecha date,
	cajaid integer,
	caja_nombre character varying,
	caja_abreviatura character varying,
	numero integer,
	cobradorid integer,
	detalles character varying
);


ALTER TYPE tesoreria.type_cajaplanilla_leer_abiertas_usuario OWNER TO radiosan_ustaana;

--
-- Name: type_categoria_leer; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_categoria_leer AS (
	categoriaid integer,
	nombre character varying,
	abreviatura character varying,
	orden integer,
	estado boolean,
	cantidad_conceptos integer
);


ALTER TYPE tesoreria.type_categoria_leer OWNER TO radiosan_ustaana;

--
-- Name: type_centrocosto_leer; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_centrocosto_leer AS (
	centrocostoid integer,
	nombre character varying,
	abreviatura character varying,
	referencia character varying,
	tipo character varying,
	direccionamiento character varying,
	estado boolean
);


ALTER TYPE tesoreria.type_centrocosto_leer OWNER TO radiosan_ustaana;

--
-- Name: type_centrogasto_getrow; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_centrogasto_getrow AS (
	centrogastoid integer,
	tipocentrogastoid integer,
	tipocentrogasto_nombre character varying,
	tipocentrogasto_direccionamiento character varying,
	nombre character varying,
	abreviatura character varying,
	referencia character varying,
	apl_bancos boolean,
	apl_cajchi boolean,
	apl_gasmen boolean,
	apl_honora boolean,
	apl_entred boolean,
	apl_docume boolean,
	apl_produc boolean,
	estado boolean
);


ALTER TYPE tesoreria.type_centrogasto_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_centrogasto_leer; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_centrogasto_leer AS (
	centrogastoid integer,
	tipocentrogastoid integer,
	tipocentrogasto_nombre character varying,
	tipocentrogasto_direccionamiento character varying,
	nombre character varying,
	abreviatura character varying,
	referencia character varying,
	apl_bancos boolean,
	apl_cajchi boolean,
	apl_gasmen boolean,
	apl_honora boolean,
	apl_entred boolean,
	apl_docume boolean,
	apl_produc boolean,
	estado boolean
);


ALTER TYPE tesoreria.type_centrogasto_leer OWNER TO radiosan_ustaana;

--
-- Name: type_concepto_getids; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_concepto_getids AS (
	conceptoid integer,
	nombre character varying,
	abreviatura character varying,
	importe numeric,
	categoriaid integer,
	categoria_nombre character varying
);


ALTER TYPE tesoreria.type_concepto_getids OWNER TO radiosan_ustaana;

--
-- Name: type_concepto_leer; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_concepto_leer AS (
	conceptoid integer,
	nombre character varying
);


ALTER TYPE tesoreria.type_concepto_leer OWNER TO radiosan_ustaana;

--
-- Name: type_condicionpago_leer; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_condicionpago_leer AS (
	condicionpagoid integer,
	nombre character varying,
	abreviatura character varying,
	cantidad integer,
	orden integer,
	estado boolean
);


ALTER TYPE tesoreria.type_condicionpago_leer OWNER TO radiosan_ustaana;

--
-- Name: type_config_proceso_leer; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_config_proceso_leer AS (
	procesoid integer,
	codigo character varying,
	tipmovcajid integer,
	tipmovcaj_nombre character varying,
	tipmovbanid integer,
	tipmovban_nombre character varying,
	mediopagoid integer,
	mediopago_nombre character varying
);


ALTER TYPE tesoreria.type_config_proceso_leer OWNER TO radiosan_ustaana;

--
-- Name: type_documentos_consulta; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_documentos_consulta AS (
	documentoid integer,
	registro character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	anio integer,
	mes integer,
	mes_nombre character varying,
	numero_control integer,
	fecha date,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	numero character varying,
	numero_detalle character varying,
	proveedorid integer,
	proveedor_nombre character varying,
	proveedor_foto character varying,
	proveedor_sexo character varying,
	moneda character varying,
	moneda_nombre character varying,
	moneda_simbolo character varying,
	importe_total numeric,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	usuario_usuario character varying,
	caja character varying,
	estado boolean
);


ALTER TYPE tesoreria.type_documentos_consulta OWNER TO radiosan_ustaana;

--
-- Name: type_documentos_getrow; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_documentos_getrow AS (
	documentoid integer,
	registro character varying,
	empresaid integer,
	empresa_nombre character varying,
	anio integer,
	mes integer,
	numero_control integer,
	clasificacionid integer,
	clasificacion_nombre character varying,
	clasificacion_abreviatura character varying,
	tipbasimpid integer,
	tipbasimp_nombre character varying,
	tipbasimp_abreviatura character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	tipodocumento_codigocontable character varying,
	tipodocumento_caracter_contable character varying,
	numero character varying,
	fecha date,
	vencimiento date,
	moneda character varying,
	moneda_nombre character varying,
	moneda_simbolo character varying,
	proveedorid integer,
	proveedor_tipo character varying,
	proveedor_nrodoc character varying,
	proveedor_nombre character varying,
	proveedor_foto character varying,
	proveedor_sexo character varying,
	proveedor_direccion character varying,
	proveedor_tipdoc character varying,
	porcentaje_igv numeric,
	importe_bruto numeric,
	importe_descuento numeric,
	importe_subtotal numeric,
	importe_gratuito numeric,
	importe_descuento_global numeric,
	importe_gravado numeric,
	importe_igv numeric,
	importe_exonerado numeric,
	importe_inafecto numeric,
	importe_detraccion numeric,
	importe_ajuste numeric,
	importe_total numeric,
	porcentaje_percepcion numeric,
	importe_percepcion numeric,
	importe_total_pagar numeric,
	saldo numeric,
	notareferenciaid integer,
	notareferenciatipdocid integer,
	notareferenciatipdoc_nombre character varying,
	notareferenciatipdoc_abreviatura character varying,
	notareferenciatipdoc_codigo_contable character varying,
	notareferenciatipdoc_caracter character varying,
	notareferencia_numero character varying,
	notareferencia_fecha character varying,
	cambio numeric,
	referencia character varying,
	referenciaid1 integer,
	referenciaid2 integer,
	cerrado boolean,
	observacion text,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	usuario_usuario character varying,
	caja character varying,
	estado boolean,
	detraccion_numero character varying,
	detraccion_fecha character varying
);


ALTER TYPE tesoreria.type_documentos_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_documentos_leer; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_documentos_leer AS (
	documentoid integer,
	registro character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	anio integer,
	mes integer,
	mes_nombre character varying,
	numero_control integer,
	fecha date,
	clasificacionid integer,
	clasificacion_nombre character varying,
	clasificacion_abreviatura character varying,
	tipbasimpid integer,
	tipbasimp_nombre character varying,
	tipbasimp_abreviatura character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	numero character varying,
	numero_detalle character varying,
	proveedorid integer,
	proveedor_tipo character varying,
	proveedor_nrodoc character varying,
	proveedor_nombre character varying,
	proveedor_foto character varying,
	proveedor_sexo character varying,
	moneda character varying,
	moneda_nombre character varying,
	moneda_simbolo character varying,
	importe_total numeric,
	abonado numeric,
	saldo numeric,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	usuario_usuario character varying,
	estado boolean,
	cerrado boolean,
	total_soles numeric,
	caja character varying
);


ALTER TYPE tesoreria.type_documentos_leer OWNER TO radiosan_ustaana;

--
-- Name: type_documentos_leer_items; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_documentos_leer_items AS (
	documentoid integer,
	detalleid integer,
	productoid integer,
	producto_nombre character varying,
	producto_peso numeric,
	unidadmedida_nombre character varying,
	unidadmedida_codint character varying,
	item integer,
	gratuito boolean,
	cantidad numeric,
	precio numeric,
	valor_venta numeric,
	descuento_porc numeric,
	descuento_porc_valor numeric,
	descuento_fijo numeric,
	descuento numeric,
	gravado boolean,
	igv numeric,
	isc_porc numeric,
	isc numeric,
	total numeric,
	bonificacion numeric,
	observacion text,
	tipocalculo smallint
);


ALTER TYPE tesoreria.type_documentos_leer_items OWNER TO radiosan_ustaana;

--
-- Name: type_documentos_leer_porpagar; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_documentos_leer_porpagar AS (
	documentoid integer,
	registro character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	anio integer,
	mes integer,
	mes_nombre character varying,
	numero_control integer,
	fecha date,
	clasificacionid integer,
	clasificacion_nombre character varying,
	clasificacion_abreviatura character varying,
	tipbasimpid integer,
	tipbasimp_nombre character varying,
	tipbasimp_abreviatura character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	numero character varying,
	numero_detalle character varying,
	proveedorid integer,
	proveedor_tipo character varying,
	proveedor_nrodoc character varying,
	proveedor_nombre character varying,
	proveedor_foto character varying,
	proveedor_sexo character varying,
	moneda character varying,
	moneda_nombre character varying,
	moneda_simbolo character varying,
	importe_total numeric,
	saldo numeric,
	vencimiento character varying,
	total_soles numeric
);


ALTER TYPE tesoreria.type_documentos_leer_porpagar OWNER TO radiosan_ustaana;

--
-- Name: type_medio_pago_leer; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_medio_pago_leer AS (
	mediopagoid integer,
	nombre character varying,
	abreviatura character varying,
	estructura character varying,
	tipo character varying,
	pcgr_general character varying,
	pcgr_empresarial character varying,
	orden integer,
	estado boolean
);


ALTER TYPE tesoreria.type_medio_pago_leer OWNER TO radiosan_ustaana;

--
-- Name: type_movban_getrow; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_movban_getrow AS (
	movbanid integer,
	registro character varying,
	ctacteid integer,
	fecha date,
	numero character varying,
	tipo character varying,
	tipoid integer,
	tipo_nombre character varying,
	personaid integer,
	persona_nombre character varying,
	persona_direccion character varying,
	persona_dniruc character varying,
	mediopagoid integer,
	mediopago_nombre character varying,
	importe numeric,
	cambio numeric,
	operacion character varying,
	glosa character varying,
	centrocostogastoid integer,
	observacion text,
	referencia character varying,
	referenciaid1 integer,
	referenciaid2 integer,
	usuarioid integer,
	usuario_nombre character varying,
	ip character varying,
	estado boolean
);


ALTER TYPE tesoreria.type_movban_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_movban_leer; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_movban_leer AS (
	movbanid integer,
	registro character varying,
	ctacteid integer,
	fecha date,
	numero character varying,
	tipo character varying,
	tipoid integer,
	tipo_nombre character varying,
	personaid integer,
	persona_nombre character varying,
	persona_direccion character varying,
	persona_dniruc character varying,
	mediopagoid integer,
	mediopago_nombre character varying,
	importe numeric,
	operacion character varying,
	glosa character varying,
	observacion text,
	referencia character varying,
	referenciaid1 integer,
	referenciaid2 integer,
	usuarioid integer,
	usuario_nombre character varying,
	ip character varying,
	estado boolean
);


ALTER TYPE tesoreria.type_movban_leer OWNER TO radiosan_ustaana;

--
-- Name: type_porcobrar_abonos_leer; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_porcobrar_abonos_leer AS (
	referencia character varying,
	referenciaid1 integer,
	referenciaid2 integer,
	id integer,
	registro character varying,
	fecha date,
	panillaid integer,
	planilla_numero integer,
	planilla_cajaid integer,
	planilla_caja_nombre character varying,
	planilla_detalles character varying,
	tipo character varying,
	detalle character varying,
	personaid integer,
	persona_nombre character varying,
	incluirctacte boolean,
	moneda character varying,
	moneda_simbolo character varying,
	importe numeric,
	tipoformapagoid integer,
	tipoformapago_nombre character varying,
	tipoformapago_abreviatura character varying,
	observacion text,
	usuarioid integer,
	usuario_nombre character varying,
	caja character varying,
	estado boolean,
	transaccionid integer
);


ALTER TYPE tesoreria.type_porcobrar_abonos_leer OWNER TO radiosan_ustaana;

--
-- Name: type_porcobrar_general_leer; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_porcobrar_general_leer AS (
	modulo character varying,
	porcobrarid integer,
	registro character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	personaid integer,
	persona_nombre character varying,
	persona_foto character varying,
	persona_sexo character varying,
	tipodocumentoid integer,
	tipodocumento_abreviatura character varying,
	numero character varying,
	numero2 character varying,
	letra integer,
	fecha date,
	vencimiento date,
	moneda character varying,
	moneda_simbolo character varying,
	importe numeric,
	saldo numeric,
	cambio numeric,
	referencia character varying,
	referenciaid1 integer,
	referenciaid2 integer,
	referenciaid3 integer,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_usuario character varying,
	caja character varying,
	cerrado boolean,
	estado boolean
);


ALTER TYPE tesoreria.type_porcobrar_general_leer OWNER TO radiosan_ustaana;

--
-- Name: type_porcobrar_general_pendiente_persona; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_porcobrar_general_pendiente_persona AS (
	modulo character varying,
	porcobrarid integer,
	registro character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	unidadnegocioid integer,
	unidadnegocio_nombre character varying,
	unidadnegocio_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	tipodocumentoid integer,
	tipodocumento_abreviatura character varying,
	numero character varying,
	numero2 character varying,
	letra integer,
	fecha date,
	vencimiento date,
	importe numeric,
	saldo numeric,
	moneda character varying,
	moneda_simbolo character varying,
	cambio numeric,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_usuario character varying,
	caja character varying,
	cerrado boolean
);


ALTER TYPE tesoreria.type_porcobrar_general_pendiente_persona OWNER TO radiosan_ustaana;

--
-- Name: type_porcobrar_general_pendiente_persona_nota_credito; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_porcobrar_general_pendiente_persona_nota_credito AS (
	modulo character varying,
	porcobrarid integer,
	registro character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	unidadnegocioid integer,
	unidadnegocio_nombre character varying,
	unidadnegocio_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	tipodocumentoid integer,
	tipodocumento_abreviatura character varying,
	numero character varying,
	numero2 character varying,
	letra integer,
	fecha date,
	vencimiento date,
	moneda character varying,
	moneda_simbolo character varying,
	importe numeric,
	saldo numeric,
	cambio numeric,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_usuario character varying,
	caja character varying,
	cerrado boolean
);


ALTER TYPE tesoreria.type_porcobrar_general_pendiente_persona_nota_credito OWNER TO radiosan_ustaana;

--
-- Name: type_porcobrar_getrow; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_porcobrar_getrow AS (
	porcobrarid integer,
	registro character varying,
	signo character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	personaid integer,
	persona_nombre character varying,
	persona_direccion character varying,
	persona_foto character varying,
	persona_sexo character varying,
	persona_dniruc character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	numero character varying,
	numero2 character varying,
	letra integer,
	fecha date,
	vencimiento date,
	importe numeric,
	saldo numeric,
	moneda character varying,
	moneda_nombre character varying,
	moneda_simbolo character varying,
	cambio numeric,
	planillaid integer,
	planilla_numero integer,
	planilla_caja_nombre character varying,
	observacion text,
	referencia character varying,
	referenciaid1 integer,
	referenciaid2 integer,
	referenciaid3 integer,
	referencia_detalles character varying,
	pcgr character varying,
	centrocostoid integer,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	caja character varying,
	cerrado boolean,
	estado boolean
);


ALTER TYPE tesoreria.type_porcobrar_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_porcobrar_leer; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_porcobrar_leer AS (
	porcobrarid integer,
	registro character varying,
	signo character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_abreviatura character varying,
	almacenid integer,
	almacen_nombre character varying,
	almacen_abreviatura character varying,
	personaid integer,
	persona_nombre character varying,
	persona_foto character varying,
	persona_sexo character varying,
	tipodocumentoid integer,
	tipodocumento_nombre character varying,
	tipodocumento_abreviatura character varying,
	numero character varying,
	numero2 character varying,
	letra integer,
	fecha date,
	vencimiento date,
	importe numeric,
	saldo numeric,
	moneda character varying,
	moneda_simbolo character varying,
	cambio numeric,
	referencia character varying,
	referenciaid1 integer,
	referenciaid2 integer,
	referenciaid3 integer,
	referencia_detalles character varying,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_foto character varying,
	usuario_sexo character varying,
	usuario_usuario character varying,
	caja character varying,
	cerrado boolean,
	estado boolean
);


ALTER TYPE tesoreria.type_porcobrar_leer OWNER TO radiosan_ustaana;

--
-- Name: type_proceso_leer; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_proceso_leer AS (
	procesoid integer,
	codigo character varying,
	nombre character varying
);


ALTER TYPE tesoreria.type_proceso_leer OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_cajaplanilla_detalle; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_cajaplanilla_detalle AS (
	detalleid integer,
	registro character varying,
	fecha character varying,
	tipo character varying,
	tipoid integer,
	tipmovcaj_nombre character varying,
	referencia character varying,
	referenciaid1 integer,
	referenciaid2 integer,
	referencia_detalles character varying,
	operacion character varying,
	glosa character varying,
	personaid integer,
	persona_nombre character varying,
	moneda character varying,
	moneda_simbolo character varying,
	efectivo numeric,
	cheque numeric,
	tarjeta numeric,
	banco numeric,
	tipoformapagoid integer,
	tipoformapago_nombre character varying,
	tipoformapago_abreviatura character varying,
	banco_tarjeta character varying,
	cambio numeric,
	observacion text
);


ALTER TYPE tesoreria.type_reporte_cajaplanilla_detalle OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_cuadre_caja; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_cuadre_caja AS (
	tipo character varying,
	detalle character varying,
	modulo character varying,
	referencia character varying,
	codigo integer,
	fecha date,
	hora time without time zone,
	numero character varying,
	cliente character varying,
	importe numeric,
	orden integer,
	mifecha date
);


ALTER TYPE tesoreria.type_reporte_cuadre_caja OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_cuadre_caja_multiple; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_cuadre_caja_multiple AS (
	tipo character varying,
	detalle character varying,
	modulo character varying,
	referencia character varying,
	codigo integer,
	fecha date,
	hora time without time zone,
	numero character varying,
	cliente character varying,
	importe numeric,
	orden integer
);


ALTER TYPE tesoreria.type_reporte_cuadre_caja_multiple OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_cuadre_caja_resumen; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_cuadre_caja_resumen AS (
	tipo character varying,
	detalle character varying,
	modulo character varying,
	importe numeric,
	orden integer
);


ALTER TYPE tesoreria.type_reporte_cuadre_caja_resumen OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_cuadre_caja_resumen_multiple; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_cuadre_caja_resumen_multiple AS (
	tipo character varying,
	detalle character varying,
	modulo character varying,
	importe numeric,
	orden integer
);


ALTER TYPE tesoreria.type_reporte_cuadre_caja_resumen_multiple OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_estado_cuenta_cliente; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_estado_cuenta_cliente AS (
	personaid integer,
	almacenid integer,
	almacen character varying,
	fecha date,
	detalle character varying,
	numero character varying,
	cargo numeric,
	abono numeric,
	referencia character varying,
	codigo_ref1 integer,
	orden integer,
	tipo character varying
);


ALTER TYPE tesoreria.type_reporte_estado_cuenta_cliente OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_flujocaja; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_flujocaja AS (
	tipo character varying,
	detalle character varying,
	modulo character varying,
	referencia character varying,
	codigo integer,
	fecha date,
	registro character varying,
	numero character varying,
	cliente character varying,
	importe numeric,
	orden integer,
	mifecha date
);


ALTER TYPE tesoreria.type_reporte_flujocaja OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_flujocaja_resumen; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_flujocaja_resumen AS (
	tipo character varying,
	detalle character varying,
	modulo character varying,
	importe numeric,
	orden integer
);


ALTER TYPE tesoreria.type_reporte_flujocaja_resumen OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_mineria_ingresos_dinero_sobrante; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_mineria_ingresos_dinero_sobrante AS (
	personaid integer,
	nombre_persona character varying,
	almacenid integer,
	nombre_almacen character varying,
	total numeric,
	sobrante numeric
);


ALTER TYPE tesoreria.type_reporte_mineria_ingresos_dinero_sobrante OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_mineria_porcobrar; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_mineria_porcobrar AS (
	clienteid integer,
	nombre_cliente character varying,
	almacenid integer,
	nombre_almacen character varying,
	total numeric
);


ALTER TYPE tesoreria.type_reporte_mineria_porcobrar OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_mineria_porcobrar_resumen; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_mineria_porcobrar_resumen AS (
	personaid integer,
	ruc_dni character varying,
	nombre_persona character varying,
	almacenid integer,
	almacen character varying,
	importe numeric,
	sobrante numeric
);


ALTER TYPE tesoreria.type_reporte_mineria_porcobrar_resumen OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_mineria_porpagar_resumen; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_mineria_porpagar_resumen AS (
	personaid integer,
	ruc_dni character varying,
	nombre_persona character varying,
	almacenid integer,
	almacen character varying,
	importe numeric,
	sobrante numeric
);


ALTER TYPE tesoreria.type_reporte_mineria_porpagar_resumen OWNER TO radiosan_ustaana;

--
-- Name: type_reporte_saldos_porcaja; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_reporte_saldos_porcaja AS (
	cajaid integer,
	caja_nombre character varying,
	almacenid integer,
	almacen_nombre character varying,
	zonaid integer,
	zona_nombre character varying,
	saldo_efectivo_monbas numeric,
	saldo_efectivo_monext numeric,
	saldo_cheque_monbas numeric,
	saldo_cheque_monext numeric
);


ALTER TYPE tesoreria.type_reporte_saldos_porcaja OWNER TO radiosan_ustaana;

--
-- Name: type_tipmovbanco_leer; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_tipmovbanco_leer AS (
	tipoid integer,
	nombre character varying,
	abreviatura character varying,
	tipo character varying,
	estructura character varying,
	pcgr_general character varying,
	pcgr_empresarial character varying,
	estado boolean
);


ALTER TYPE tesoreria.type_tipmovbanco_leer OWNER TO radiosan_ustaana;

--
-- Name: type_tipmovcaja_leer; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_tipmovcaja_leer AS (
	tipoid integer,
	nombre character varying,
	abreviatura character varying,
	tipo character varying,
	estructura character varying,
	pcgr_general character varying,
	pcgr_empresarial character varying,
	estado boolean
);


ALTER TYPE tesoreria.type_tipmovcaja_leer OWNER TO radiosan_ustaana;

--
-- Name: type_tipmoventren_leer; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_tipmoventren_leer AS (
	tipoid integer,
	nombre character varying,
	abreviatura character varying,
	estructura character varying,
	pcgr_general character varying,
	pcgr_empresarial character varying,
	estado boolean
);


ALTER TYPE tesoreria.type_tipmoventren_leer OWNER TO radiosan_ustaana;

--
-- Name: type_tipo_forma_pago_leer; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_tipo_forma_pago_leer AS (
	tipoformapagoid integer,
	nombre character varying,
	abreviatura character varying,
	estructura character varying,
	tipo character varying,
	pcgr_general character varying,
	pcgr_empresarial character varying,
	orden integer,
	estado boolean
);


ALTER TYPE tesoreria.type_tipo_forma_pago_leer OWNER TO radiosan_ustaana;

--
-- Name: type_tipo_operacion_leer; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_tipo_operacion_leer AS (
	tipooperacionid integer,
	nombre character varying
);


ALTER TYPE tesoreria.type_tipo_operacion_leer OWNER TO radiosan_ustaana;

--
-- Name: type_tipo_tarjeta_leer; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_tipo_tarjeta_leer AS (
	tipotarjetaid integer,
	nombre character varying,
	abreviatura character varying,
	orden integer,
	estado boolean
);


ALTER TYPE tesoreria.type_tipo_tarjeta_leer OWNER TO radiosan_ustaana;

--
-- Name: type_tipo_tarjeta_leer_sistema; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_tipo_tarjeta_leer_sistema AS (
	tipotarjetaid integer,
	nombre character varying,
	abreviatura character varying,
	orden integer,
	estado boolean
);


ALTER TYPE tesoreria.type_tipo_tarjeta_leer_sistema OWNER TO radiosan_ustaana;

--
-- Name: type_tipocentrogasto_leer; Type: TYPE; Schema: tesoreria; Owner: radiosan_ustaana
--

CREATE TYPE type_tipocentrogasto_leer AS (
	tipocentrogastoid integer,
	nombre character varying,
	abreviatura character varying,
	referencia character varying,
	direccionamiento character varying,
	estado boolean
);


ALTER TYPE tesoreria.type_tipocentrogasto_leer OWNER TO radiosan_ustaana;

SET search_path = transa, pg_catalog;

--
-- Name: paliquidacion_detalle_listar; Type: TYPE; Schema: transa; Owner: radiosan_ustaana
--

CREATE TYPE paliquidacion_detalle_listar AS (
	liquidacion_detalleid integer,
	ctaxrendirid integer,
	moneda character varying,
	importe numeric,
	tipoformapagoid integer
);


ALTER TYPE transa.paliquidacion_detalle_listar OWNER TO radiosan_ustaana;

--
-- Name: type_combustible_getrow; Type: TYPE; Schema: transa; Owner: radiosan_ustaana
--

CREATE TYPE type_combustible_getrow AS (
	combustibleid integer,
	tipocombustibleid integer,
	tipocombustible_nombre character varying,
	tipocombustible_abreviatura character varying,
	nombre character varying,
	precio numeric(6,2),
	estado boolean
);


ALTER TYPE transa.type_combustible_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_combustible_leer; Type: TYPE; Schema: transa; Owner: radiosan_ustaana
--

CREATE TYPE type_combustible_leer AS (
	combustibleid integer,
	tipocombustibleid integer,
	tipocombustible_nombre character varying,
	nombre character varying,
	abreviatura character varying,
	precio numeric(6,2),
	estado boolean
);


ALTER TYPE transa.type_combustible_leer OWNER TO radiosan_ustaana;

--
-- Name: type_ctaxrendir_buscarservicio; Type: TYPE; Schema: transa; Owner: radiosan_ustaana
--

CREATE TYPE type_ctaxrendir_buscarservicio AS (
	ctarendirid integer,
	servicioid integer,
	conductorid integer,
	moneda character varying,
	importe numeric,
	tipoformapagoid integer,
	tipogastoid integer
);


ALTER TYPE transa.type_ctaxrendir_buscarservicio OWNER TO radiosan_ustaana;

--
-- Name: type_marca_leer; Type: TYPE; Schema: transa; Owner: radiosan_ustaana
--

CREATE TYPE type_marca_leer AS (
	marcaid integer,
	nombre character varying,
	abreviatura character varying,
	orden integer,
	estado boolean
);


ALTER TYPE transa.type_marca_leer OWNER TO radiosan_ustaana;

--
-- Name: type_modelo_leer; Type: TYPE; Schema: transa; Owner: radiosan_ustaana
--

CREATE TYPE type_modelo_leer AS (
	modeloid integer,
	nombre character varying,
	abreviatura character varying,
	orden integer,
	marcaid integer,
	marca character varying,
	estado boolean
);


ALTER TYPE transa.type_modelo_leer OWNER TO radiosan_ustaana;

--
-- Name: type_paliquidacion_detalle_listar; Type: TYPE; Schema: transa; Owner: radiosan_ustaana
--

CREATE TYPE type_paliquidacion_detalle_listar AS (
	liquidacion_detalleid integer,
	ctaxrendirid integer,
	moneda character varying,
	importe numeric,
	tipogastoid integer
);


ALTER TYPE transa.type_paliquidacion_detalle_listar OWNER TO radiosan_ustaana;

--
-- Name: type_ruta_distrito; Type: TYPE; Schema: transa; Owner: radiosan_ustaana
--

CREATE TYPE type_ruta_distrito AS (
	distritoid integer,
	distrito character varying,
	distritodata text,
	departamentoid integer,
	departamento character varying,
	provinciaid integer,
	provincia character varying
);


ALTER TYPE transa.type_ruta_distrito OWNER TO radiosan_ustaana;

--
-- Name: type_ruta_leer; Type: TYPE; Schema: transa; Owner: radiosan_ustaana
--

CREATE TYPE type_ruta_leer AS (
	rutaid integer,
	nombre character varying,
	registro date,
	fechahora timestamp without time zone,
	origenid integer,
	origendata text,
	destinoid integer,
	destinodata text,
	kilometros numeric,
	galones numeric,
	precioxtn numeric,
	estado boolean
);


ALTER TYPE transa.type_ruta_leer OWNER TO radiosan_ustaana;

--
-- Name: type_servicio_conductor_leer; Type: TYPE; Schema: transa; Owner: radiosan_ustaana
--

CREATE TYPE type_servicio_conductor_leer AS (
	itemid integer,
	servicioid integer,
	registro timestamp without time zone,
	fecha date,
	monto numeric,
	conductorid integer,
	kminicio integer,
	kmfin integer,
	ruta character varying,
	placa character varying,
	gastado numeric
);


ALTER TYPE transa.type_servicio_conductor_leer OWNER TO radiosan_ustaana;

--
-- Name: type_servicio_conductor_listar; Type: TYPE; Schema: transa; Owner: radiosan_ustaana
--

CREATE TYPE type_servicio_conductor_listar AS (
	servicioid integer,
	registro timestamp without time zone,
	fecha date,
	monto numeric,
	conductorid integer
);


ALTER TYPE transa.type_servicio_conductor_listar OWNER TO radiosan_ustaana;

--
-- Name: type_servicio_ruta; Type: TYPE; Schema: transa; Owner: radiosan_ustaana
--

CREATE TYPE type_servicio_ruta AS (
	itemid integer,
	servicioid integer,
	kminicio integer,
	kmfin integer,
	nombre character varying
);


ALTER TYPE transa.type_servicio_ruta OWNER TO radiosan_ustaana;

--
-- Name: type_tipoaro_leer; Type: TYPE; Schema: transa; Owner: radiosan_ustaana
--

CREATE TYPE type_tipoaro_leer AS (
	tipoaroid integer,
	nombre character varying,
	abreviatura character varying,
	orden integer,
	estado boolean
);


ALTER TYPE transa.type_tipoaro_leer OWNER TO radiosan_ustaana;

--
-- Name: type_tipocobertor_leer; Type: TYPE; Schema: transa; Owner: radiosan_ustaana
--

CREATE TYPE type_tipocobertor_leer AS (
	tipocobertorid integer,
	nombre character varying,
	abreviatura character varying,
	orden integer,
	estado boolean
);


ALTER TYPE transa.type_tipocobertor_leer OWNER TO radiosan_ustaana;

--
-- Name: type_tipocombustible_leer; Type: TYPE; Schema: transa; Owner: radiosan_ustaana
--

CREATE TYPE type_tipocombustible_leer AS (
	tipocombustibleid integer,
	nombre character varying,
	abreviatura character varying,
	codigo_contable character varying
);


ALTER TYPE transa.type_tipocombustible_leer OWNER TO radiosan_ustaana;

--
-- Name: type_tipollanta_leer; Type: TYPE; Schema: transa; Owner: radiosan_ustaana
--

CREATE TYPE type_tipollanta_leer AS (
	tipollantaid integer,
	nombre character varying,
	abreviatura character varying,
	orden integer,
	estado boolean
);


ALTER TYPE transa.type_tipollanta_leer OWNER TO radiosan_ustaana;

--
-- Name: type_tipovehiculo_leer; Type: TYPE; Schema: transa; Owner: radiosan_ustaana
--

CREATE TYPE type_tipovehiculo_leer AS (
	tipovehiculoid integer,
	nombre character varying,
	abreviatura character varying,
	codigo_contable character varying,
	orden integer,
	estado boolean
);


ALTER TYPE transa.type_tipovehiculo_leer OWNER TO radiosan_ustaana;

--
-- Name: type_vehiculo_color_leer; Type: TYPE; Schema: transa; Owner: radiosan_ustaana
--

CREATE TYPE type_vehiculo_color_leer AS (
	vehiculoid integer,
	colorid integer
);


ALTER TYPE transa.type_vehiculo_color_leer OWNER TO radiosan_ustaana;

--
-- Name: type_vehiculo_leer; Type: TYPE; Schema: transa; Owner: radiosan_ustaana
--

CREATE TYPE type_vehiculo_leer AS (
	vehiculoid integer,
	registro timestamp without time zone,
	tipovehiculoid integer,
	tipovehiculo character varying,
	marcaid integer,
	marca character varying,
	modeloid integer,
	modelo character varying,
	tipoaroid integer,
	tipoaro character varying,
	tipollantaid integer,
	tipollanta character varying,
	tipocobertorid integer,
	tipocobertor character varying,
	color text,
	placa character varying,
	seriechasis character varying,
	aniofab integer,
	aniomodelo integer,
	ancho numeric,
	largo numeric,
	alto numeric,
	cargautil numeric,
	pesobruto numeric,
	pesoneto numeric,
	ruedas integer,
	nejes integer,
	observacion text,
	estado boolean
);


ALTER TYPE transa.type_vehiculo_leer OWNER TO radiosan_ustaana;

--
-- Name: type_vehiculo_tipocombustible_leer; Type: TYPE; Schema: transa; Owner: radiosan_ustaana
--

CREATE TYPE type_vehiculo_tipocombustible_leer AS (
	vehiculoid integer,
	tipocombustibleid integer
);


ALTER TYPE transa.type_vehiculo_tipocombustible_leer OWNER TO radiosan_ustaana;

SET search_path = webservice, pg_catalog;

--
-- Name: type_institucion_getrow; Type: TYPE; Schema: webservice; Owner: radiosan_ustaana
--

CREATE TYPE type_institucion_getrow AS (
	institucionid integer,
	nombre character varying,
	abreviatura character varying,
	referencia character varying,
	url character varying,
	estado boolean,
	cantidad_usuarios integer,
	cantidad_webservice integer
);


ALTER TYPE webservice.type_institucion_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_institucion_leer; Type: TYPE; Schema: webservice; Owner: radiosan_ustaana
--

CREATE TYPE type_institucion_leer AS (
	institucionid integer,
	nombre character varying,
	abreviatura character varying,
	referencia character varying,
	url character varying,
	orden integer,
	estado boolean,
	cantidad_usuarios integer,
	cantidad_webservice integer
);


ALTER TYPE webservice.type_institucion_leer OWNER TO radiosan_ustaana;

--
-- Name: type_tipo_getrow; Type: TYPE; Schema: webservice; Owner: radiosan_ustaana
--

CREATE TYPE type_tipo_getrow AS (
	tipoid integer,
	nombre character varying,
	abreviatura character varying,
	referencia character varying,
	estado boolean
);


ALTER TYPE webservice.type_tipo_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_tipo_leer; Type: TYPE; Schema: webservice; Owner: radiosan_ustaana
--

CREATE TYPE type_tipo_leer AS (
	tipoid integer,
	nombre character varying,
	abreviatura character varying,
	referencia character varying,
	orden integer,
	estado boolean
);


ALTER TYPE webservice.type_tipo_leer OWNER TO radiosan_ustaana;

--
-- Name: type_usuario_consulta; Type: TYPE; Schema: webservice; Owner: radiosan_ustaana
--

CREATE TYPE type_usuario_consulta AS (
	usuarioid integer,
	institucionid integer,
	institucion_nombre character varying,
	institucion_referencia character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_ruc character varying,
	nombre character varying,
	usuario character varying,
	clave character varying,
	orden integer,
	estado boolean
);


ALTER TYPE webservice.type_usuario_consulta OWNER TO radiosan_ustaana;

--
-- Name: type_usuario_getrow; Type: TYPE; Schema: webservice; Owner: radiosan_ustaana
--

CREATE TYPE type_usuario_getrow AS (
	usuarioid integer,
	institucionid integer,
	institucion_nombre character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_ruc character varying,
	nombre character varying,
	usuario character varying,
	clave character varying,
	estado boolean
);


ALTER TYPE webservice.type_usuario_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_usuario_leer; Type: TYPE; Schema: webservice; Owner: radiosan_ustaana
--

CREATE TYPE type_usuario_leer AS (
	usuarioid integer,
	institucionid integer,
	institucion_nombre character varying,
	empresaid integer,
	empresa_nombre character varying,
	empresa_ruc character varying,
	nombre character varying,
	usuario character varying,
	clave character varying,
	orden integer,
	estado boolean
);


ALTER TYPE webservice.type_usuario_leer OWNER TO radiosan_ustaana;

--
-- Name: type_webservice_consulta; Type: TYPE; Schema: webservice; Owner: radiosan_ustaana
--

CREATE TYPE type_webservice_consulta AS (
	webserviceid integer,
	institucionid integer,
	institucion_nombre character varying,
	tipoid integer,
	tipo_nombre character varying,
	nombre character varying,
	url character varying,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_usuario character varying,
	usuario_clave character varying,
	orden integer,
	estado boolean
);


ALTER TYPE webservice.type_webservice_consulta OWNER TO radiosan_ustaana;

--
-- Name: type_webservice_getrow; Type: TYPE; Schema: webservice; Owner: radiosan_ustaana
--

CREATE TYPE type_webservice_getrow AS (
	webserviceid integer,
	institucionid integer,
	institucion_nombre character varying,
	tipoid integer,
	tipo_nombre character varying,
	nombre character varying,
	url character varying,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_usuario character varying,
	usuario_clave character varying,
	estado boolean
);


ALTER TYPE webservice.type_webservice_getrow OWNER TO radiosan_ustaana;

--
-- Name: type_webservice_leer; Type: TYPE; Schema: webservice; Owner: radiosan_ustaana
--

CREATE TYPE type_webservice_leer AS (
	webserviceid integer,
	institucionid integer,
	institucion_nombre character varying,
	tipoid integer,
	tipo_nombre character varying,
	nombre character varying,
	url character varying,
	orden integer,
	estado boolean
);


ALTER TYPE webservice.type_webservice_leer OWNER TO radiosan_ustaana;

--
-- Name: type_webservice_leer_sistema; Type: TYPE; Schema: webservice; Owner: radiosan_ustaana
--

CREATE TYPE type_webservice_leer_sistema AS (
	webserviceid integer,
	institucionid integer,
	institucion_nombre character varying,
	institucion_referencia character varying,
	tipoid integer,
	tipo_nombre character varying,
	tipo_referencia character varying,
	nombre character varying,
	url character varying,
	usuarioid integer,
	usuario_nombre character varying,
	usuario_usuario character varying,
	usuario_clave character varying,
	orden integer,
	estado boolean
);


ALTER TYPE webservice.type_webservice_leer_sistema OWNER TO radiosan_ustaana;

SET search_path = basic, pg_catalog;

--
-- Name: getconf_caja_tipdocid_egreso(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION getconf_caja_tipdocid_egreso() RETURNS integer
    LANGUAGE plpgsql
    AS $$
DECLARE vValor integer default 0;
BEGIN
	select conf.valor_int into vValor from basic.configuracion conf where conf.codigo=34;
	return coalesce(vValor, 0);
END;
$$;


ALTER FUNCTION basic.getconf_caja_tipdocid_egreso() OWNER TO radiosan_ustaana;

--
-- Name: getconf_caja_tipdocid_ingreso(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION getconf_caja_tipdocid_ingreso() RETURNS integer
    LANGUAGE plpgsql
    AS $$
DECLARE vValor integer default 0;
BEGIN
	select conf.valor_int into vValor from basic.configuracion conf where conf.codigo=33;
	return coalesce(vValor, 0);
END;
$$;


ALTER FUNCTION basic.getconf_caja_tipdocid_ingreso() OWNER TO radiosan_ustaana;

--
-- Name: getconf_concar_asiento(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION getconf_concar_asiento() RETURNS integer
    LANGUAGE plpgsql
    AS $$
DECLARE vValor integer default 0;
BEGIN
	select conf.valor_int into vValor from basic.configuracion conf where conf.codigo=71;
	return coalesce(vValor, 0);
END;
$$;


ALTER FUNCTION basic.getconf_concar_asiento() OWNER TO radiosan_ustaana;

--
-- Name: getconf_concar_subdiario(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION getconf_concar_subdiario() RETURNS character varying
    LANGUAGE plpgsql
    AS $$
DECLARE vValor varchar default '';
BEGIN
	select conf.valor_char into vValor from basic.configuracion conf where conf.codigo=70;
	return coalesce(vValor, '');
END;
$$;


ALTER FUNCTION basic.getconf_concar_subdiario() OWNER TO radiosan_ustaana;

--
-- Name: getconf_formapago_anticipo(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION getconf_formapago_anticipo() RETURNS integer
    LANGUAGE plpgsql
    AS $$
DECLARE vValor integer default 0;
BEGIN
	select conf.valor_int into vValor from basic.configuracion conf where conf.codigo=45;
	return coalesce(vValor, 0);
END;
$$;


ALTER FUNCTION basic.getconf_formapago_anticipo() OWNER TO radiosan_ustaana;

--
-- Name: getconf_formapago_banco(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION getconf_formapago_banco() RETURNS integer
    LANGUAGE plpgsql
    AS $$
DECLARE vValor integer default 0;
BEGIN
	select conf.valor_int into vValor from basic.configuracion conf where conf.codigo=44;
	return coalesce(vValor, 0);
END;
$$;


ALTER FUNCTION basic.getconf_formapago_banco() OWNER TO radiosan_ustaana;

--
-- Name: getconf_formapago_cheque(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION getconf_formapago_cheque() RETURNS integer
    LANGUAGE plpgsql
    AS $$
DECLARE vValor integer default 0;
BEGIN
	select conf.valor_int into vValor from basic.configuracion conf where conf.codigo=43;
	return coalesce(vValor, 0);
END;
$$;


ALTER FUNCTION basic.getconf_formapago_cheque() OWNER TO radiosan_ustaana;

--
-- Name: getconf_formapago_defecto(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION getconf_formapago_defecto() RETURNS integer
    LANGUAGE plpgsql
    AS $$
DECLARE vValor integer default 0;
BEGIN
	select conf.valor_int into vValor from basic.configuracion conf where conf.codigo=40;
	return coalesce(vValor, 0);
END;
$$;


ALTER FUNCTION basic.getconf_formapago_defecto() OWNER TO radiosan_ustaana;

--
-- Name: getconf_formapago_efectivo(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION getconf_formapago_efectivo() RETURNS integer
    LANGUAGE plpgsql
    AS $$
DECLARE vValor integer default 0;
BEGIN
	select conf.valor_int into vValor from basic.configuracion conf where conf.codigo=41;
	return coalesce(vValor, 0);
END;
$$;


ALTER FUNCTION basic.getconf_formapago_efectivo() OWNER TO radiosan_ustaana;

--
-- Name: getconf_formapago_tarjeta(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION getconf_formapago_tarjeta() RETURNS integer
    LANGUAGE plpgsql
    AS $$
DECLARE vValor integer default 0;
BEGIN
	select conf.valor_int into vValor from basic.configuracion conf where conf.codigo=42;
	return coalesce(vValor, 0);
END;
$$;


ALTER FUNCTION basic.getconf_formapago_tarjeta() OWNER TO radiosan_ustaana;

--
-- Name: getconf_tipoid_dni(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION getconf_tipoid_dni() RETURNS integer
    LANGUAGE plpgsql
    AS $$
DECLARE vValor integer default 0;
BEGIN
	select conf.valor_int into vValor from basic.configuracion conf where conf.codigo=25;
	return coalesce(vValor, 0);
END;
$$;


ALTER FUNCTION basic.getconf_tipoid_dni() OWNER TO radiosan_ustaana;

--
-- Name: getconf_tipoid_ruc(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION getconf_tipoid_ruc() RETURNS integer
    LANGUAGE plpgsql
    AS $$
DECLARE vValor integer default 0;
BEGIN
	select conf.valor_int into vValor from basic.configuracion conf where conf.codigo=26;
	return coalesce(vValor, 0);
END;
$$;


ALTER FUNCTION basic.getconf_tipoid_ruc() OWNER TO radiosan_ustaana;

--
-- Name: getprimerdia(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION getprimerdia(vanio integer, vperiodo integer, vopcion character varying) RETURNS date
    LANGUAGE plpgsql
    AS $$
declare vfecha date default current_date;
BEGIN
	vfecha:=date_trunc(vopcion, (trim(vanio::varchar)||'-'||trim(vperiodo::varchar)||'-01')::date);

	return vfecha;
END
$$;


ALTER FUNCTION basic.getprimerdia(vanio integer, vperiodo integer, vopcion character varying) OWNER TO radiosan_ustaana;

--
-- Name: getultimodia(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION getultimodia(vanio integer, vperiodo integer, vopcion character varying) RETURNS date
    LANGUAGE plpgsql
    AS $$
declare vfecha date default current_date;
BEGIN
	vfecha:=(date_trunc(vopcion, ((trim(vanio::varchar)||'-'||trim(vperiodo::varchar)||'-01')::date)+ interval '1 month') - interval '1 day')::date;

	return vfecha;
END
$$;


ALTER FUNCTION basic.getultimodia(vanio integer, vperiodo integer, vopcion character varying) OWNER TO radiosan_ustaana;

--
-- Name: idsuperusuario(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION idsuperusuario() RETURNS integer
    LANGUAGE plpgsql
    AS $$
DECLARE vPersonaId integer default 0;
BEGIN
	select personaid into vPersonaId from basic.clave where usuario=superusuario();
	return coalesce(vPersonaId, 0);
END;
$$;


ALTER FUNCTION basic.idsuperusuario() OWNER TO radiosan_ustaana;

--
-- Name: moneda_base(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION moneda_base() RETURNS character varying
    LANGUAGE plpgsql
    AS $$
declare vmoneda varchar default '';
BEGIN
	select conf.valor_char into vmoneda from basic.configuracion conf where conf.codigo=30;
	return coalesce(vmoneda,'NS');
END;
$$;


ALTER FUNCTION basic.moneda_base() OWNER TO radiosan_ustaana;

--
-- Name: moneda_extranjera(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION moneda_extranjera() RETURNS character varying
    LANGUAGE plpgsql
    AS $$
declare vmoneda varchar default '';
BEGIN
	select conf.valor_char into vmoneda from basic.configuracion conf where conf.codigo=32;
	return coalesce(vmoneda,'');
END;
$$;


ALTER FUNCTION basic.moneda_extranjera() OWNER TO radiosan_ustaana;

--
-- Name: obtener_id_modulo(character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION obtener_id_modulo(vmodulonombre character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vModuloId integer default 0; vNombre varchar default '';
BEGIN
	vNombre:=trim(upper(vmodulonombre));
	if vNombre='ING_MER' or vNombre='ING-MER' then
		vModuloId:=1;
	elseif vNombre='SAL_MER' or vNombre='SAL-MER' then
		vModuloId:=2;
	elseif vNombre='VENTAS' then
		vModuloId:=3;
	elseif vNombre='PORCOBRAR' then
		vModuloId:=4;
	elseif vNombre='PORPAGAR' then
		vModuloId:=5;
	elseif vNombre='TRASLADO' then
		vModuloId:=6;
	elseif vNombre='REG-COM' then
		vModuloId:=7;
	elseif vNombre='REG-VEN' then
		vModuloId:=8;
	elseif vNombre='LIB-VAR' then
		vModuloId:=9;
	end if;
	return vModuloId;
END
$$;


ALTER FUNCTION basic.obtener_id_modulo(vmodulonombre character varying) OWNER TO radiosan_ustaana;

--
-- Name: paalmacen_actualizar(boolean, integer, integer, integer, character varying, character varying, character varying, character varying, integer, boolean); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paalmacen_actualizar(innew boolean, valmacenid integer, vunidadnegocioid integer, inzonaid integer, innombre character varying, inabreviatura character varying, indireccion character varying, intelefono character varying, indistritoid integer, inestado boolean) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.almacen a where trim(upper(buscar(a.nombre)))=trim(upper(buscar(innombre))) and almacenid!=valmacenid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre del almacen ya existe.';
	end if;
	If vState Then
		If inNew Then
			insert into basic.almacen values(default, vunidadnegocioid, trim(innombre), trim(inabreviatura), trim(indireccion), trim(intelefono), indistritoid, inzonaid, inestado);
			vID:=lastval();
		Else
			update basic.almacen set unidadnegocioid=vunidadnegocioid, zonaid=inzonaid, nombre=trim(innombre), abreviatura=trim(inabreviatura), direccion=trim(indireccion), telefono=trim(intelefono), distritoid=indistritoid, estado=inestado where almacenid=valmacenid;
			vID:=valmacenid;
		end if;
		if vID>0 then
			insert into catalogo.producto_almacen
				select vID, p.productoid, p.stock_min, p.stock_max, p.precio_va, p.precio_vb, p.precio_vc, p.precio_vd
				from catalogo.producto p left join catalogo.producto_almacen pa on p.productoid=pa.productoid and vID=pa.almacenid
				where pa.productoid is null;
			insert into inventarios.stock
				select emp.empresaid, p.productoid, vID, 0
				from catalogo.producto p inner join basic.empresa emp on 1=1
					left join inventarios.stock s on emp.empresaid=s.empresaid and p.productoid=s.productoid and vID=s.almacenid
				where s.productoid is null;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paalmacen_actualizar(innew boolean, valmacenid integer, vunidadnegocioid integer, inzonaid integer, innombre character varying, inabreviatura character varying, indireccion character varying, intelefono character varying, indistritoid integer, inestado boolean) OWNER TO radiosan_ustaana;

--
-- Name: paalmacen_cambiar_estado(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paalmacen_cambiar_estado(valmacenid integer, vusuario integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vEstadoOld boolean default false;
BEGIN
	if vState then
		if exists(select * from basic.almacen where almacenid=valmacenid) then
			--RASTRO
			select estado into vEstadoOld from basic.almacen where almacenid=valmacenid;
			insert into rastro.campo values(default, 'basic', 'almacen', 'estado', 'B', valmacenid, 0, 0, vEstadoOld::varchar, (not vEstadoOld)::varchar, current_timestamp, vusuario, vip, 1, 0);
			
			update basic.almacen set estado=not estado where almacenid=valmacenid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paalmacen_cambiar_estado(valmacenid integer, vusuario integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: paalmacen_config_actualizar(integer, boolean); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paalmacen_config_actualizar(valmacenid integer, vupdateprecio boolean) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if not exists(select * from basic.almacen_config where almacenid=valmacenid) then
		insert into basic.almacen_config values(valmacenid, vupdateprecio);
		vID:=0;
	else
		update basic.almacen_config set updateprecio=vupdateprecio where almacenid=valmacenid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paalmacen_config_actualizar(valmacenid integer, vupdateprecio boolean) OWNER TO radiosan_ustaana;

--
-- Name: paalmacen_consultar(integer, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paalmacen_consultar(vpersonaid integer, vmoduloid integer) RETURNS SETOF type_almacen_consultar
    LANGUAGE plpgsql
    AS $$
DECLARE vUsuario varchar(20) default '';
BEGIN
	drop table if exists tmp_alm_aux, tmp_alm;
	create temporary table tmp_alm_aux(almacenid integer not null);
	create temporary table tmp_alm(almacenid integer not null);

	select usuario into vUsuario from basic.clave where personaid=vpersonaid;
	if vUsuario=superusuario() then
		insert into tmp_alm select almacenid from basic.almacen;
	else
		insert into tmp_alm_aux 
			select almacenid 
			from basic.permisos_modulo 
			where personaid=vpersonaid
				and case when vmoduloid>0 then modulosistemaid=vmoduloid else true end;
		insert into tmp_alm select almacenid from tmp_alm_aux group by almacenid;
	end if;
	
	return query 
		select a.almacenid, a.nombre, a.unidadnegocioid
		from basic.almacen a
		where a.almacenid in (select almacenid from tmp_alm)
		order by 2;
	drop table if exists tmp_alm_aux, tmp_alm;
END
$$;


ALTER FUNCTION basic.paalmacen_consultar(vpersonaid integer, vmoduloid integer) OWNER TO radiosan_ustaana;

--
-- Name: paalmacen_eliminar(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paalmacen_eliminar(valmacenid integer, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from inventarios.venta where almacenid=valmacenid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar el almacen por tener ventas relacionadas.';
	end if;
	if vState then
		if exists(select * from inventarios.ingreso where almacenid=valmacenid) then
			vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar el almacen por tener ingresos de mercaderia relacionadas.';
		end if;
	end if;
	if vState then
		if exists(select * from inventarios.salida where almacenid=valmacenid) then
			vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar el almacen por tener salidas de mercaderia relacionadas.';
		end if;
	end if;
	if vState then
		if exists(select * from inventarios.traslados_venta where almacendestinoid=valmacenid or almacenorigenid=valmacenid) then
			vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar el almacen por tener traslados de mercaderia relacionadas.';
		end if;
	end if;
	if vState then
		if exists(select * from inventarios.transferencia where almacendestinoid=valmacenid or almacenorigenid=valmacenid) then
			vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar el almacen por tener transferencias de mercaderia relacionadas.';
		end if;
	end if;
	if vState then
		if exists(select * from tesoreria.caja where almacenid=valmacenid) then
			vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar el almacen por tener caja relacionadas.';
		end if;
	end if;
	if vState then
		
		delete from basic.empresa_almacen_despacho where almacenid=valmacenid;
		delete from basic.empresa_almacen_despacho where despachoalmacenid=valmacenid;
		delete from inventarios.stock where almacenid=valmacenid;
		delete from inventarios.lote where almacenid=valmacenid;
		delete from inventarios.loteid where almacenid=valmacenid;
		delete from basic.permisos_modulo where almacenid=valmacenid;
		delete from inventarios.permisos_impresion where almacenid=valmacenid;
		delete from catalogo.producto_almacen where almacenid=valmacenid;
		delete from inventarios.serie where almacenid=valmacenid;
		delete from inventarios.transferencia_stock where almacenid=valmacenid;
		delete from inventarios.ganancias_metas where almacenid=valmacenid;
		delete from inventarios.pedido_correlativos where almacenid=valmacenid;
		delete from basic.almacen_config where almacenid=valmacenid;
		delete from basic.empresa_almacen where almacenid=valmacenid;
		delete from basic.almacen where almacenid=valmacenid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paalmacen_eliminar(valmacenid integer, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: paalmacen_getcount_noupdateprecio(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paalmacen_getcount_noupdateprecio(vusuarioid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vcount integer default 0;
BEGIN
	select count(*) into vcount from basic.almacen alm inner join basic.almacen_config conf on alm.almacenid=conf.almacenid where conf.updateprecio=false;
	return coalesce(vcount, 0);
END
$$;


ALTER FUNCTION basic.paalmacen_getcount_noupdateprecio(vusuarioid integer) OWNER TO radiosan_ustaana;

--
-- Name: paalmacen_getempresaid(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paalmacen_getempresaid(valmacenid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vempresaid integer default 0;
BEGIN
	select un.empresaid into vempresaid from basic.almacen a inner join basic.unidad_negocio un on a.unidadnegocioid=un.unidadnegocioid where a.almacenid=valmacenid;
	return coalesce(vempresaid, 0);
END
$$;


ALTER FUNCTION basic.paalmacen_getempresaid(valmacenid integer) OWNER TO radiosan_ustaana;

--
-- Name: paalmacen_getrow(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paalmacen_getrow(valmacenid integer) RETURNS SETOF type_almacen_getrow
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query
		select a.almacenid, a.nombre, a.abreviatura, a.direccion, a.telefono, a.estado, a.zonaid, z.nombre, a.unidadnegocioid, un.nombre, un.empresaid, e.nombre, e.ruc,
			a.distritoid, coalesce(dis.nombre,'')::varchar, coalesce(dis.provinciaid,0)::integer, coalesce(pro.nombre,'')::varchar, coalesce(pro.departamentoid, 0)::integer, coalesce(dpto.nombre, '')::varchar
		from basic.almacen a inner join basic.unidad_negocio un on a.unidadnegocioid=un.unidadnegocioid
			inner join basic.empresa e on un.empresaid=e.empresaid
			inner join basic.zona z on a.zonaid=z.zonaid
			left join basic.distrito dis on a.distritoid=dis.distritoid
			left join basic.provincia pro on dis.provinciaid=pro.provinciaid
			left join basic.departamento dpto on pro.departamentoid=dpto.departamentoid
		where a.almacenid=valmacenid;
END
$$;


ALTER FUNCTION basic.paalmacen_getrow(valmacenid integer) OWNER TO radiosan_ustaana;

--
-- Name: paalmacen_leer(integer, integer, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paalmacen_leer(vzonaid integer, vempresaid integer, vunidadnegocioid integer) RETURNS SETOF type_almacen_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query
		select a.almacenid, a.nombre, a.abreviatura, a.direccion, a.telefono, a.estado, a.zonaid, z.nombre, a.unidadnegocioid, un.nombre, un.empresaid, e.nombre, e.ruc,
			a.distritoid, coalesce(dis.nombre,'')::varchar, coalesce(dis.provinciaid,0)::integer, coalesce(pro.nombre,'')::varchar, coalesce(pro.departamentoid, 0)::integer, coalesce(dpto.nombre, '')::varchar
		from basic.almacen a inner join basic.zona z on a.zonaid=z.zonaid
			inner join basic.unidad_negocio un on a.unidadnegocioid=un.unidadnegocioid
			inner join basic.empresa e on un.empresaid=e.empresaid
			left join basic.distrito dis on e.distritoid=dis.distritoid
			left join basic.provincia pro on dis.provinciaid=pro.provinciaid
			left join basic.departamento dpto on pro.departamentoid=dpto.departamentoid
		where a.almacenid>0
			and case when vzonaid>0 then a.zonaid=vzonaid else true end
			and case when vempresaid>0 then un.empresaid=vempresaid else true end
			and case when vunidadnegocioid>0 then a.unidadnegocioid=vunidadnegocioid else true end
		order by z.orden, a.nombre;
END
$$;


ALTER FUNCTION basic.paalmacen_leer(vzonaid integer, vempresaid integer, vunidadnegocioid integer) OWNER TO radiosan_ustaana;

--
-- Name: paalmacen_leer_sistema(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paalmacen_leer_sistema() RETURNS SETOF type_almacen_leer_sistema
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query
		select a.almacenid, a.nombre, a.abreviatura, a.direccion, a.telefono, a.estado, a.zonaid, z.nombre, a.unidadnegocioid, un.nombre, un.empresaid, e.nombre, e.ruc,
			a.distritoid, coalesce(dis.nombre,'')::varchar, coalesce(dis.provinciaid,0)::integer, coalesce(pro.nombre,'')::varchar, coalesce(pro.departamentoid, 0)::integer, coalesce(dpto.nombre, '')::varchar,
			coalesce(conf.updateprecio, false)::boolean
		from basic.almacen a inner join basic.zona z on a.zonaid=z.zonaid
			inner join basic.unidad_negocio un on a.unidadnegocioid=un.unidadnegocioid
			inner join basic.empresa e on un.empresaid=e.empresaid
			left join basic.distrito dis on e.distritoid=dis.distritoid
			left join basic.provincia pro on dis.provinciaid=pro.provinciaid
			left join basic.departamento dpto on pro.departamentoid=dpto.departamentoid
			left join basic.almacen_config conf on a.almacenid=conf.almacenid
		order by a.nombre;
END
$$;


ALTER FUNCTION basic.paalmacen_leer_sistema() OWNER TO radiosan_ustaana;

--
-- Name: paambiente_actualizar(boolean, integer, integer, character varying, character varying, integer, integer, boolean); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paambiente_actualizar(innew boolean, inambienteid integer, inedificioid integer, innombre character varying, inabreviatura character varying, inpiso integer, incapacidad integer, inestado boolean) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.ambiente a where trim(upper(buscar(a.nombre)))=trim(upper(buscar(innombre))) and a.edificioid=inedificioid and a.ambienteid!=inambienteid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre del ambiente ya ha sido registrada en el sistema.';
	end if;
	If vState Then
		if inNew then
			insert into basic.ambiente values(default, inedificioid, trim(innombre), trim(inabreviatura), inpiso, incapacidad, basic.paambiente_ultimo_orden(inedificioid)+1, inestado);
			vID:=lastval();
		else
			update basic.ambiente set edificioid=inedificioid, nombre=trim(innombre), abreviatura=trim(inabreviatura), piso=inpiso, capacidad=incapacidad, estado=inestado where ambienteid=inambienteid;
			vID:=inambienteid;
		end if;
	end if;

	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paambiente_actualizar(innew boolean, inambienteid integer, inedificioid integer, innombre character varying, inabreviatura character varying, inpiso integer, incapacidad integer, inestado boolean) OWNER TO radiosan_ustaana;

--
-- Name: paambiente_cambiar_estado(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paambiente_cambiar_estado(vambienteid integer, vusuario integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vEstadoOld boolean default false;
BEGIN
	if vState then
		if exists(select * from basic.ambiente where ambienteid=vambienteid) then
			--RASTRO
			select estado into vEstadoOld from basic.ambiente where ambienteid=vambienteid;
			insert into rastro.campo values(default, 'basic', 'ambiente', 'estado', 'B', vambienteid, 0, 0, vEstadoOld::varchar, (not vEstadoOld)::varchar, current_timestamp, vusuario, vip, 1, 0);
			
			update basic.ambiente set estado=not estado where ambienteid=vambienteid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paambiente_cambiar_estado(vambienteid integer, vusuario integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: paambiente_cambiar_orden(integer, integer[]); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paambiente_cambiar_orden(vedificioid integer, myarr integer[]) RETURNS void
    LANGUAGE plpgsql
    AS $$
declare myRow record;
BEGIN
	for myRow in select myarr[i] as id, i as orden from generate_series(1, array_upper(myarr, 1)) as i loop
		update basic.ambiente set orden=myRow.orden where ambienteid=myRow.id;
	end loop;
END
$$;


ALTER FUNCTION basic.paambiente_cambiar_orden(vedificioid integer, myarr integer[]) OWNER TO radiosan_ustaana;

--
-- Name: paambiente_eliminar(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paambiente_eliminar(vambienteid integer) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare 
	vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from especializacion.grupo where ambienteid=vambienteid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar el ambiente por tener grupos relacionados.';
	end if;
	if vState=true then
		delete from basic.ambiente where ambienteid=vambienteid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paambiente_eliminar(vambienteid integer) OWNER TO radiosan_ustaana;

--
-- Name: paambiente_leer(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paambiente_leer(vedificioid integer) RETURNS SETOF type_ambiente_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select a.ambienteid, a.nombre, a.abreviatura, a.piso, a.capacidad, a.edificioid, e.nombre, (e.nombre ||' - '||a.nombre)::varchar, a.orden, a.estado
		from basic.ambiente a inner join basic.edificio e on a.edificioid=e.edificioid
		where 1=1 and case when vedificioid>0 then a.edificioid=vedificioid else true end 
		order by a.orden, 2;
END
$$;


ALTER FUNCTION basic.paambiente_leer(vedificioid integer) OWNER TO radiosan_ustaana;

--
-- Name: paambiente_ultimo_orden(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paambiente_ultimo_orden(vedificioid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vOrden integer default 0;
BEGIN
	select max(orden) into vOrden from basic.ambiente where edificioid=vedificioid;
	return coalesce(vOrden, 0);
END
$$;


ALTER FUNCTION basic.paambiente_ultimo_orden(vedificioid integer) OWNER TO radiosan_ustaana;

--
-- Name: paarea_actualizar(boolean, integer, character varying, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paarea_actualizar(innew boolean, inareaid integer, innombre character varying, inabreviatura character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.area t where trim(upper(buscar(t.nombre)))=trim(upper(buscar(innombre))) and t.areaid!=inareaid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre del area ya existe en la base de datos';
	end if;
	if vState then
		if exists(select * from basic.area t where trim(upper(buscar(t.abreviatura)))=trim(upper(buscar(inabreviatura))) and t.areaid!=inareaid) then
			vState:=false; vID:=0; vError:=1; vDescripcion:='La abreviatura del area ya existe en la base de datos';
		end if;
	end if;
	if vState then
		If inNew Then
			insert into basic.area values(default, trim(innombre), trim(inabreviatura), basic.paarea_lastorder()+1, true);
			vID:=lastval();
		Else
			update basic.area set nombre=trim(innombre), abreviatura=trim(inabreviatura) where areaid=inareaid;
			vID:=inareaid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paarea_actualizar(innew boolean, inareaid integer, innombre character varying, inabreviatura character varying) OWNER TO radiosan_ustaana;

--
-- Name: paarea_cambiar_estado(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paarea_cambiar_estado(vareaid integer, vusuario integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vEstadoOld boolean default false;
BEGIN
	if vState then
		if exists(select * from basic.area where areaid=vareaid) then
			--RASTRO
			select estado into vEstadoOld from basic.area where areaid=vareaid;
			insert into rastro.campo values(default, 'basic', 'area', 'estado', 'B', vareaid, 0, 0, vEstadoOld::varchar, (not vEstadoOld)::varchar, current_timestamp, vusuario, vip, 1, 0);
			
			update basic.area set estado=not estado where areaid=vareaid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paarea_cambiar_estado(vareaid integer, vusuario integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: paarea_change_order(integer[], integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paarea_change_order(myarr integer[], vstart integer) RETURNS void
    LANGUAGE plpgsql
    AS $$
declare myRow record;
BEGIN
	for myRow in select myarr[i] as id, i as orden from generate_series(1, array_upper(myarr, 1)) as i loop
		update basic.area set orden=myRow.orden+(case when vstart>1 then vstart-1 else 0 end) where areaid=myRow.id;
	end loop;
END
$$;


ALTER FUNCTION basic.paarea_change_order(myarr integer[], vstart integer) OWNER TO radiosan_ustaana;

--
-- Name: paarea_eliminar(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paarea_eliminar(inareaid integer) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if vState=true then
		delete from basic.area where areaid=inareaid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paarea_eliminar(inareaid integer) OWNER TO radiosan_ustaana;

--
-- Name: paarea_lastorder(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paarea_lastorder() RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vOrden integer default 0;
BEGIN
	select max(t.orden) into vOrden from basic.area t;
	return coalesce(vOrden, 0);
END
$$;


ALTER FUNCTION basic.paarea_lastorder() OWNER TO radiosan_ustaana;

--
-- Name: paarea_leer(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paarea_leer() RETURNS SETOF type_area_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select a.areaid, a.nombre, a.abreviatura, a.orden, a.estado 
		from basic.area a 
		where a.areaid>0 
		order by a.orden, a.nombre;
END
$$;


ALTER FUNCTION basic.paarea_leer() OWNER TO radiosan_ustaana;

--
-- Name: pabanco_actualizar(boolean, integer, character varying, character varying, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pabanco_actualizar(innew boolean, inbancoid integer, innombre character varying, inabreviatura character varying, inreferencia character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.banco b where trim(upper(buscar(b.nombre)))=trim(upper(buscar(innombre))) and b.bancoid!=inbancoid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre del banco ya existe en la base de datos';
	end if;
	If vState Then
		If inNew Then
			insert into basic.banco values(default, trim(innombre), trim(inabreviatura), trim(inreferencia));
			vID:=lastval();
		else
			update basic.banco set nombre=trim(innombre), abreviatura=trim(inabreviatura), referencia=trim(inreferencia) where bancoid=inbancoid;
			vID:=inbancoid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.pabanco_actualizar(innew boolean, inbancoid integer, innombre character varying, inabreviatura character varying, inreferencia character varying) OWNER TO radiosan_ustaana;

--
-- Name: pabanco_eliminar(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pabanco_eliminar(inbancoid integer) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.ctacte where bancoid=inbancoid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar el banco por tener cuentas corrientes relacionadas.';
	end if;
	if vState then
		delete from basic.banco where bancoid=inbancoid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.pabanco_eliminar(inbancoid integer) OWNER TO radiosan_ustaana;

--
-- Name: pabanco_leer(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pabanco_leer() RETURNS SETOF type_banco_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select b.bancoid, b.nombre, b.abreviatura, b.referencia
		from basic.banco b
		where b.bancoid>0
		order by b.nombre;
END
$$;


ALTER FUNCTION basic.pabanco_leer() OWNER TO radiosan_ustaana;

--
-- Name: pabanco_leer_sistema(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pabanco_leer_sistema() RETURNS SETOF type_banco_leer_sistema
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select b.bancoid, b.nombre, b.abreviatura, b.referencia
		from basic.banco b
		where b.bancoid>0
		order by b.nombre;
END
$$;


ALTER FUNCTION basic.pabanco_leer_sistema() OWNER TO radiosan_ustaana;

--
-- Name: pacambiar_clave_actualizar(integer, character varying, character varying, character varying, character varying, character varying, boolean, character varying, boolean, date, time without time zone, character varying, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pacambiar_clave_actualizar(inpersonaid integer, inusuario_anterior character varying, inusuario_nuevo character varying, inclave_anterior character varying, inclave_nueva character varying, inclave_temporal character varying, inrenovar_clave boolean, intipo_cambio character varying, inexito boolean, infecha date, inhora time without time zone, inip character varying, incodigo_usu integer, inobservacion character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.clave where personaid!=inpersonaid and usuario=inusuario_nuevo) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='Ya existe un usuario registrado igual al que acaba de ingresar';
	end if;
	if vState then
		insert into basic.cambiar_clave values(default, inpersonaid, inusuario_anterior, inusuario_nuevo, inclave_anterior, inclave_nueva, inclave_temporal, inrenovar_clave, intipo_cambio, inexito, infecha, inhora, inip, incodigo_usu, inobservacion);
		vID:=lastval();

		if exists(select * from basic.clave where personaid=inpersonaid) then
			update basic.clave set usuario=inusuario_nuevo, clave=inclave_nueva, clave_temporal=inclave_temporal, renovar_clave=inrenovar_clave, tipo_cambio=intipo_cambio where personaid=inpersonaid;
		else
			insert into basic.clave values(inpersonaid, inusuario_nuevo, inclave_nueva, inclave_temporal, inrenovar_clave, intipo_cambio);
		end if;
	end if;
	
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.pacambiar_clave_actualizar(inpersonaid integer, inusuario_anterior character varying, inusuario_nuevo character varying, inclave_anterior character varying, inclave_nueva character varying, inclave_temporal character varying, inrenovar_clave boolean, intipo_cambio character varying, inexito boolean, infecha date, inhora time without time zone, inip character varying, incodigo_usu integer, inobservacion character varying) OWNER TO radiosan_ustaana;

--
-- Name: pacambiar_clave_leer(integer, integer, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pacambiar_clave_leer(vfirst integer, vlast integer, vpersona integer) RETURNS SETOF type_cambiar_clave_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query
		select cc.codigo, to_char(cc.fecha+cc.hora, 'DD/MM/YYYY HH12:MI AM')::varchar,cc.personaid, (case when per.tipo='J' then coalesce(pj.raz_soc,'') else (coalesce(pn.ape_pat,'') || ' ' || coalesce(pn.ape_mat,'') || ', ' || coalesce(pn.nombre,'')) end)::varchar,
			cc.usuario_anterior, cc.usuario_nuevo, cc.clave_anterior, cc.clave_nueva, cc.clave_temporal,
			cc.renovar_clave, cc.tipo_cambio, cc.exito, cc.ip, 
			cc.usuarioid, (case when usu.tipo='J' then coalesce(pjusu.raz_soc,'') else (coalesce(pnusu.ape_pat,'') || ' ' || coalesce(pnusu.ape_mat,'') || ', ' || coalesce(pnusu.nombre,'')) end)::varchar,
			cc.observacion
		from basic.cambiar_clave cc inner join basic.persona per on cc.personaid=per.personaid
				left join basic.persona_natural pn on per.personaid=pn.personaid
				left join basic.persona_juridica pj on per.personaid=pj.personaid
			left join basic.persona usu on cc.personaid=usu.personaid
				left join basic.persona_natural pnusu on usu.personaid=pnusu.personaid
				left join basic.persona_juridica pjusu on usu.personaid=pjusu.personaid
		where cc.personaid=vPersona
		order by cc.fecha desc, cc.hora desc
		limit case when vfirst=0 and vlast=0 then null else vlast end offset vfirst;
END

$$;


ALTER FUNCTION basic.pacambiar_clave_leer(vfirst integer, vlast integer, vpersona integer) OWNER TO radiosan_ustaana;

--
-- Name: pacambiar_clave_otros_actualizar(integer, character varying, character varying, character varying, character varying, character varying, boolean, character varying, boolean, character varying, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pacambiar_clave_otros_actualizar(inpersonaid integer, inusuario_anterior character varying, inusuario_nuevo character varying, inclave_anterior character varying, inclave_nueva character varying, inclave_temporal character varying, inrenovar_clave boolean, intipo_cambio character varying, inexito boolean, inip character varying, incodigo_usu integer, inobservacion character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.clave_otros where personaid!=inpersonaid and usuario=inusuario_nuevo) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='Ya existe un usuario registrado igual al que acaba de ingresar';
	end if;
	if vState then
		insert into basic.cambiar_clave_otros values(default, inpersonaid, inusuario_anterior, inusuario_nuevo, inclave_anterior, inclave_nueva, inclave_temporal, inrenovar_clave, intipo_cambio, inexito, current_date, current_time, inip, incodigo_usu, inobservacion);
		vID:=lastval();

		if exists(select * from basic.clave_otros where personaid=inpersonaid) then
			update basic.clave_otros set usuario=inusuario_nuevo, clave=inclave_nueva, clave_temporal=inclave_temporal, renovar_clave=inrenovar_clave, tipo_cambio=intipo_cambio where personaid=inpersonaid;
		else
			insert into basic.clave_otros values(inpersonaid, inusuario_nuevo, inclave_nueva, inclave_temporal, inrenovar_clave, intipo_cambio);
		end if;
	end if;
	
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.pacambiar_clave_otros_actualizar(inpersonaid integer, inusuario_anterior character varying, inusuario_nuevo character varying, inclave_anterior character varying, inclave_nueva character varying, inclave_temporal character varying, inrenovar_clave boolean, intipo_cambio character varying, inexito boolean, inip character varying, incodigo_usu integer, inobservacion character varying) OWNER TO radiosan_ustaana;

--
-- Name: pacambiar_clave_otros_leer(integer, integer, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pacambiar_clave_otros_leer(vfirst integer, vlast integer, vpersonaid integer) RETURNS SETOF type_cambiar_clave_otros_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query
		select cc.codigo, to_char(cc.fecha+cc.hora, 'DD/MM/YYYY HH12:MI AM')::varchar, cc.personaid, (case when per.tipo='J' then coalesce(pj.raz_soc,'') else (coalesce(pn.ape_pat,'') || ' ' || coalesce(pn.ape_mat,'') || ', ' || coalesce(pn.nombre,'')) end)::varchar,
			cc.usuario_anterior, cc.usuario_nuevo, cc.clave_anterior, cc.clave_nueva, cc.clave_temporal,
			cc.renovar_clave, cc.tipo_cambio, cc.exito, cc.ip, 
			cc.usuarioid, (case when usu.tipo='J' then coalesce(pjusu.raz_soc,'') else (coalesce(pnusu.ape_pat,'') || ' ' || coalesce(pnusu.ape_mat,'') || ', ' || coalesce(pnusu.nombre,'')) end)::varchar,
			cc.observacion
		from basic.cambiar_clave_otros cc inner join basic.persona per on cc.personaid=per.personaid
				left join basic.persona_natural pn on per.personaid=pn.personaid
				left join basic.persona_juridica pj on per.personaid=pj.personaid
			left join basic.persona usu on cc.personaid=usu.personaid
				left join basic.persona_natural pnusu on usu.personaid=pnusu.personaid
				left join basic.persona_juridica pjusu on usu.personaid=pjusu.personaid
		where cc.personaid=vpersonaid
		order by cc.fecha desc, cc.hora desc
		limit case when vfirst=0 and vlast=0 then null else vlast end offset vfirst;
END

$$;


ALTER FUNCTION basic.pacambiar_clave_otros_leer(vfirst integer, vlast integer, vpersonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: pacargo_actualizar(boolean, integer, character varying, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pacargo_actualizar(innew boolean, incargoid integer, innombre character varying, inabreviatura character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.cargo t where trim(upper(buscar(t.nombre)))=trim(upper(buscar(innombre))) and t.cargoid!=incargoid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre del cargo ya existe en la base de datos';
	end if;
	if vState then
		if exists(select * from basic.cargo t where trim(upper(buscar(t.abreviatura)))=trim(upper(buscar(inabreviatura))) and t.cargoid!=incargoid) then
			vState:=false; vID:=0; vError:=1; vDescripcion:='La abreviatura del cargo ya existe en la base de datos';
		end if;
	end if;
	if vState then
		If inNew Then
			insert into basic.cargo values(default, trim(innombre), trim(inabreviatura), basic.pacargo_lastorder()+1, true);
			vID:=lastval();
		Else
			update basic.cargo set nombre=trim(innombre), abreviatura=trim(inabreviatura) where cargoid=incargoid;
			vID:=incargoid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.pacargo_actualizar(innew boolean, incargoid integer, innombre character varying, inabreviatura character varying) OWNER TO radiosan_ustaana;

--
-- Name: pacargo_cambiar_estado(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pacargo_cambiar_estado(vcargoid integer, vusuario integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vEstadoOld boolean default false;
BEGIN
	if vState then
		if exists(select * from basic.cargo where cargoid=vcargoid) then
			--RASTRO
			select estado into vEstadoOld from basic.cargo where cargoid=vcargoid;
			insert into rastro.campo values(default, 'basic', 'cargo', 'estado', 'B', vcargoid, 0, 0, vEstadoOld::varchar, (not vEstadoOld)::varchar, current_timestamp, vusuario, vip, 1, 0);
			
			update basic.cargo set estado=not estado where cargoid=vcargoid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.pacargo_cambiar_estado(vcargoid integer, vusuario integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: pacargo_change_order(integer[], integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pacargo_change_order(myarr integer[], vstart integer) RETURNS void
    LANGUAGE plpgsql
    AS $$
declare myRow record;
BEGIN
	for myRow in select myarr[i] as id, i as orden from generate_series(1, array_upper(myarr, 1)) as i loop
		update basic.cargo set orden=myRow.orden+(case when vstart>1 then vstart-1 else 0 end) where cargoid=myRow.id;
	end loop;
END
$$;


ALTER FUNCTION basic.pacargo_change_order(myarr integer[], vstart integer) OWNER TO radiosan_ustaana;

--
-- Name: pacargo_eliminar(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pacargo_eliminar(incargoid integer) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if vState=true then
		delete from basic.cargo where cargoid=incargoid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.pacargo_eliminar(incargoid integer) OWNER TO radiosan_ustaana;

--
-- Name: pacargo_lastorder(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pacargo_lastorder() RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vOrden integer default 0;
BEGIN
	select max(t.orden) into vOrden from basic.cargo t;
	return coalesce(vOrden, 0);
END
$$;


ALTER FUNCTION basic.pacargo_lastorder() OWNER TO radiosan_ustaana;

--
-- Name: pacargo_leer(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pacargo_leer() RETURNS SETOF type_cargo_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query select c.cargoid, c.nombre, c.abreviatura, c.orden, c.estado from basic.cargo c order by c.orden, c.nombre;
END
$$;


ALTER FUNCTION basic.pacargo_leer() OWNER TO radiosan_ustaana;

--
-- Name: pacategoria_licencia_actualizar(boolean, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pacategoria_licencia_actualizar(innew boolean, incategoriaid integer, innombre character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.categoria_licencia t where trim(upper(buscar(t.nombre)))=trim(upper(buscar(innombre))) and t.categoriaid!=incategoriaid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre del categoria de licencia ya existe en la base de datos';
	end if;
	
	if vState then
		If inNew Then
			insert into basic.categoria_licencia values(default, trim(innombre), basic.pacategoria_licencia_lastorder()+1, true);
			vID:=lastval();
		Else
			update basic.categoria_licencia set nombre=trim(innombre) where categoriaid=incategoriaid;
			vID:=incategoriaid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.pacategoria_licencia_actualizar(innew boolean, incategoriaid integer, innombre character varying) OWNER TO radiosan_ustaana;

--
-- Name: pacategoria_licencia_cambiar_estado(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pacategoria_licencia_cambiar_estado(vcategoriaid integer, vusuario integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vEstadoOld boolean default false;
BEGIN
	if vState then
		if exists(select * from basic.categoria_licencia where categoriaid=vcategoriaid) then
			--RASTRO
			select estado into vEstadoOld from basic.categoria_licencia where categoriaid=vcategoriaid;
			insert into rastro.campo values(default, 'basic', 'categoria_licencia', 'estado', 'B', vcategoriaid, 0, 0, vEstadoOld::varchar, (not vEstadoOld)::varchar, current_timestamp, vusuario, vip, 1, 0);
			
			update basic.categoria_licencia set estado=not estado where categoriaid=vcategoriaid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.pacategoria_licencia_cambiar_estado(vcategoriaid integer, vusuario integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: pacategoria_licencia_change_order(integer[], integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pacategoria_licencia_change_order(myarr integer[], vstart integer) RETURNS void
    LANGUAGE plpgsql
    AS $$
declare myRow record;
BEGIN
	for myRow in select myarr[i] as id, i as orden from generate_series(1, array_upper(myarr, 1)) as i loop
		update basic.categoria_licencia set orden=myRow.orden+(case when vstart>1 then vstart-1 else 0 end) where categoriaid=myRow.id;
	end loop;
END
$$;


ALTER FUNCTION basic.pacategoria_licencia_change_order(myarr integer[], vstart integer) OWNER TO radiosan_ustaana;

--
-- Name: pacategoria_licencia_eliminar(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pacategoria_licencia_eliminar(incategoriaid integer) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if vState=true then
		delete from basic.categoria_licencia where categoriaid=incategoriaid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.pacategoria_licencia_eliminar(incategoriaid integer) OWNER TO radiosan_ustaana;

--
-- Name: pacategoria_licencia_lastorder(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pacategoria_licencia_lastorder() RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vOrden integer default 0;
BEGIN
	select max(t.orden) into vOrden from basic.categoria_licencia t;
	return coalesce(vOrden, 0);
END
$$;


ALTER FUNCTION basic.pacategoria_licencia_lastorder() OWNER TO radiosan_ustaana;

--
-- Name: pacategoria_licencia_leer(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pacategoria_licencia_leer() RETURNS SETOF type_categoria_licencia_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select a.categoriaid, a.nombre, a.orden, a.estado 
		from basic.categoria_licencia a 
		where a.categoriaid>0 
		order by a.orden, a.nombre;
END
$$;


ALTER FUNCTION basic.pacategoria_licencia_leer() OWNER TO radiosan_ustaana;

--
-- Name: paclave_cambiar_temporal(integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paclave_cambiar_temporal(vpersonaid integer, vclave character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if not exists(select * from basic.clave where personaid=vpersonaid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='No existe el codigo de persona en la base de datos.';
	end if;
	if vState then
		update basic.clave set clave=MD5(vclave), clave_temporal=vclave, renovar_clave=true, tipo_cambio='R' where personaid=vpersonaid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paclave_cambiar_temporal(vpersonaid integer, vclave character varying) OWNER TO radiosan_ustaana;

--
-- Name: paclave_existe_usuario(character varying, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paclave_existe_usuario(vusuario character varying, vdistinto integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vPersonaId integer default 0;
BEGIN
	if trim(vusuario)!='' then
		select c.personaid into vPersonaId
		from basic.clave c
		where trim(c.usuario)=trim(vusuario) and c.personaid!=vdistinto and c.personaid>0 limit 1;
	end if;
	return coalesce(vPersonaId, 0);
END
$$;


ALTER FUNCTION basic.paclave_existe_usuario(vusuario character varying, vdistinto integer) OWNER TO radiosan_ustaana;

--
-- Name: paclave_otros_cambiar_temporal(integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paclave_otros_cambiar_temporal(vpersona integer, vclave character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vUsuario varchar default '';
BEGIN
	if exists(select * from basic.clave_otros where personaid!=vpersona) then
		select usuario into vUsuario from basic.clave_otros where personaid=vpersona;
		vUsuario:=coalesce(vUsuario, '');
		if vclave=vUsuario then
			vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no acepta una clave similar al usuario.';
		end if;
		if vState then
			update basic.clave_otros set clave=vclave, clave_temporal=vclave, renovar_clave=true, tipo_cambio='R' where personaid=vpersona;
			update basic.persona set clave=vclave where personaid=vpersona;
		end if;
	else
		vState:=false; vID:=0; vError:=1; vDescripcion:='No existe el codigo de persona en la base de datos.';
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paclave_otros_cambiar_temporal(vpersona integer, vclave character varying) OWNER TO radiosan_ustaana;

--
-- Name: paclave_otros_existe_usuario(character varying, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paclave_otros_existe_usuario(vusuario character varying, vdistinto integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vPersonaId integer default 0;
BEGIN
	if trim(vusuario)!='' then
		select c.personaid into vPersonaId
		from basic.clave_otros c
		where trim(c.usuario)=trim(vusuario) and c.personaid!=vdistinto and c.personaid>0 limit 1;
	end if;
	return coalesce(vPersonaId, 0);
END
$$;


ALTER FUNCTION basic.paclave_otros_existe_usuario(vusuario character varying, vdistinto integer) OWNER TO radiosan_ustaana;

--
-- Name: paclave_otros_renovar(integer[], boolean, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paclave_otros_renovar(myarr integer[], vrenovar boolean, vusuario integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vEstadoOld boolean default false; myRow record; vContador integer default 0;
BEGIN
	if vState then
		for myRow in select myarr[i] as id from generate_series(1, array_upper(myarr, 1)) as i loop
			if exists(select * from basic.clave_otros where personaid=myRow.id) then
				--RASTRO
				select renovar_clave into vEstadoOld from basic.clave_otros where personaid=myRow.id;
				insert into rastro.campo values(default, 'basic', 'clave_otros', 'renovar_clave', 'B', myRow.id, 0, 0, vEstadoOld::varchar, vrenovar::varchar, current_date, current_time, vusuario, vip, 1, 0);
				
				update basic.clave_otros set renovar_clave=vrenovar where personaid=myRow.id;
				vContador:=vContador+1;
			end if;
		end loop;
	end if;
	if vContador=0 then
		vDescripcion:='No se actualizaron registros.';
	else
		vDescripcion:='Se actualizaron '||trim(cast(vContador as varchar))||' registros.';
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paclave_otros_renovar(myarr integer[], vrenovar boolean, vusuario integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: paclave_otros_validar(character varying, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paclave_otros_validar(vusuario character varying, vclave character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vPersonaId integer default 0;
BEGIN
	if trim(vusuario)!='' and trim(vclave)!='' then
		select c.personaid into vPersonaId 
		from basic.clave_otros c inner join basic.persona p on c.personaid=p.personaid
		where trim(c.usuario)=trim(vusuario) and trim(c.clave)=trim(vclave)  and c.personaid>0 and p.estado=true limit 1;
	end if;
	return coalesce(vPersonaId, 0);
END
$$;


ALTER FUNCTION basic.paclave_otros_validar(vusuario character varying, vclave character varying) OWNER TO radiosan_ustaana;

--
-- Name: paclave_otros_validar_usuario(character varying, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paclave_otros_validar_usuario(vusuario character varying, vclave character varying) RETURNS SETOF type_clave_otros_validar_usuario
    LANGUAGE plpgsql
    AS $$
BEGIN
	if trim(vusuario)!='' and trim(vclave)!='' then
		return query
			select c.personaid, c.usuario, c.clave 
			from basic.clave_otros c inner join basic.persona p on c.personaid=p.personaid 
			where c.usuario=trim(vusuario) and c.clave=trim(vclave) and p.estado=true limit 1;		
	end if;
END
$$;


ALTER FUNCTION basic.paclave_otros_validar_usuario(vusuario character varying, vclave character varying) OWNER TO radiosan_ustaana;

--
-- Name: paclave_validar(character varying, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paclave_validar(vusuario character varying, vclave character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vPersonaId integer default 0;
BEGIN
	if trim(vusuario)!='' and trim(vclave)!='' then
		select c.personaid into vPersonaId 
		from basic.clave c inner join basic.persona p on c.personaid=p.personaid
		where trim(c.usuario)=trim(vusuario) and c.clave=md5(vclave) and p.estado=true and c.personaid>0 limit 1;
	end if;
	return coalesce(vPersonaId, 0);
END
$$;


ALTER FUNCTION basic.paclave_validar(vusuario character varying, vclave character varying) OWNER TO radiosan_ustaana;

--
-- Name: paconfiguracion_actualizar(character varying, integer, character varying, character varying, text, integer, numeric); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paconfiguracion_actualizar(intipo character varying, incodigo integer, indescripcion character varying, invalor_char character varying, invalor_text text, invalor_int integer, invalor_numeric numeric) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if not exists(select * from basic.configuracion where tipo=intipo and codigo=incodigo) then
		insert into basic.configuracion values(trim(intipo), incodigo, trim(indescripcion), trim(invalor_char), trim(invalor_text), invalor_int, invalor_numeric);
		vID:=0;
	Else
		update basic.configuracion set descripcion=trim(indescripcion), valor_char=trim(invalor_char), valor_text=trim(invalor_text), valor_int=invalor_int, valor_numeric=invalor_numeric 
		where tipo=trim(intipo) and codigo=incodigo;
		vID:=0;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paconfiguracion_actualizar(intipo character varying, incodigo integer, indescripcion character varying, invalor_char character varying, invalor_text text, invalor_int integer, invalor_numeric numeric) OWNER TO radiosan_ustaana;

--
-- Name: paconfiguracion_leer_valores(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paconfiguracion_leer_valores() RETURNS SETOF type_configuracion_leer_valores
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query
		select c.codigo, c.valor_char, c.valor_text, c.valor_int, c.valor_numeric 
		from basic.configuracion c
		where trim(c.valor_char)!='' or trim(c.valor_text)!='' or c.valor_int!=0 or c.valor_numeric!=0;

END
$$;


ALTER FUNCTION basic.paconfiguracion_leer_valores() OWNER TO radiosan_ustaana;

--
-- Name: paconfiguracion_registrar(character varying[], integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paconfiguracion_registrar(myarr character varying[], vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vFilas integer default 0; vIndice integer default 0; 
	vTipo varchar default ''; vCodigo integer default 0;
BEGIN
	if not (myarr[1][1] is null) then
		vIndice:=0;
		vFilas=array_upper(myarr,1);
		if vFilas>0 then
			for vIndice in 1..vFilas loop
				vTipo:=trim(myarr[vIndice][1]);
				vCodigo:=myarr[vIndice][2]::integer;
				if not exists(select * from basic.configuracion conf where conf.tipo=vTipo and conf.codigo=vCodigo) then
					insert into basic.configuracion values(vtipo, vcodigo, trim(myarr[vIndice][3]), trim(myarr[vIndice][4]), trim(myarr[vIndice][5]), myarr[vIndice][6]::integer, myarr[vIndice][7]::numeric);
				else
					update basic.configuracion set descripcion=trim(myarr[vIndice][3]), valor_char=trim(myarr[vIndice][4]), valor_text=trim(myarr[vIndice][5]), valor_int=myarr[vIndice][6]::integer, valor_numeric=myarr[vIndice][7]::numeric 
					where tipo=vtipo and codigo=vcodigo;
				end if;
			end loop;

		end if;
	end if;

	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paconfiguracion_registrar(myarr character varying[], vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: pactacte_actualizar(boolean, integer, integer, integer, character varying, character varying, character varying, character varying, character varying, character varying, boolean, boolean, integer, integer, integer, integer, integer, integer, character varying, character varying, character varying, character varying, character varying, boolean); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pactacte_actualizar(innew boolean, inctacteid integer, inbancoid integer, inempresaid integer, inmoneda character varying, innombre character varying, innumero character varying, inabreviatura character varying, intitular character varying, intipo character varying, inbanco boolean, incontrolcheques boolean, inche_inicio integer, inche_fin integer, inche_actual integer, indif_inicio integer, indif_fin integer, indif_actual integer, inpcgr_general character varying, inpcgr_empresarial character varying, inarc_cliente character varying, inarc_sucursal character varying, inarc_responsable character varying, inestado boolean) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.ctacte cc where trim(upper(buscar(cc.nombre)))=trim(upper(buscar(innombre))) and ctacteid!=inctacteid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre de la cuenta corriente ya existe.';
	end if;
	If vState Then
		if exists(select * from basic.ctacte cc where trim(upper(buscar(cc.numero)))=trim(upper(buscar(innumero))) and ctacteid!=inctacteid) then
			vState:=false; vID:=0; vError:=1; vDescripcion:='El numero de la cuenta corriente ya existe.';
		end if;
	end if;
	If vState Then
		If inNew Then
			insert into basic.ctacte values(default, current_timestamp, inbancoid, inempresaid, trim(inmoneda), trim(innombre), trim(innumero), trim(inabreviatura), trim(intitular), trim(intipo), inbanco, incontrolcheques, inche_inicio, inche_fin, inche_actual, indif_inicio, indif_fin, indif_actual, trim(inpcgr_general), trim(inpcgr_empresarial), trim(inarc_cliente), trim(inarc_sucursal), trim(inarc_responsable), inestado);
			vID:=lastval();
		else
			update basic.ctacte set bancoid=inbancoid, empresaid=inempresaid, moneda=trim(inmoneda), nombre=trim(innombre), numero=trim(innumero), abreviatura=trim(inabreviatura), titular=trim(intitular), tipo=trim(intipo), banco=inbanco, controlcheques=incontrolcheques, che_inicio=inche_inicio, che_fin=inche_fin, che_actual=inche_actual, dif_inicio=indif_inicio, dif_fin=indif_fin, dif_actual=indif_actual, pcgr_general=trim(inpcgr_general), pcgr_empresarial=trim(inpcgr_empresarial), arc_cliente=trim(inarc_cliente), arc_sucursal=trim(inarc_sucursal), arc_responsable=trim(inarc_responsable), estado=inestado where ctacteid=inctacteid;
			vID:=inctacteid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.pactacte_actualizar(innew boolean, inctacteid integer, inbancoid integer, inempresaid integer, inmoneda character varying, innombre character varying, innumero character varying, inabreviatura character varying, intitular character varying, intipo character varying, inbanco boolean, incontrolcheques boolean, inche_inicio integer, inche_fin integer, inche_actual integer, indif_inicio integer, indif_fin integer, indif_actual integer, inpcgr_general character varying, inpcgr_empresarial character varying, inarc_cliente character varying, inarc_sucursal character varying, inarc_responsable character varying, inestado boolean) OWNER TO radiosan_ustaana;

--
-- Name: pactacte_consulta(integer, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pactacte_consulta(vbancoid integer, vempresaid integer) RETURNS SETOF type_ctacte_consulta
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select cc.ctacteid, (cc.numero || '  ' || case when trim(b.abreviatura)!='' then trim(b.abreviatura) else trim(b.nombre) end || '  ' || e.nombre)::varchar, cc.numero
		from basic.ctacte cc inner join basic.empresa e on cc.empresaid=e.empresaid
			inner join basic.banco b on cc.bancoid=b.bancoid
		where 1=1
			and case when vbancoid>0 then cc.bancoid=vbancoid else true end
			and case when vempresaid>0 then cc.empresaid=vempresaid else true end
		order by cc.numero
	;
END
$$;


ALTER FUNCTION basic.pactacte_consulta(vbancoid integer, vempresaid integer) OWNER TO radiosan_ustaana;

--
-- Name: pactacte_eliminar(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pactacte_eliminar(inctacteid integer) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	--if exists(select codigo from operacion where codigo_ctacte=incodigo limit 1) then
	--	vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar la cuenta corriente por tener relacion con documentos emitidos(Operaciones).';
	--end if;
	if vState then
		delete from basic.ctacte where ctacteid=inctacteid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.pactacte_eliminar(inctacteid integer) OWNER TO radiosan_ustaana;

--
-- Name: pactacte_eliminar(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pactacte_eliminar(vctacteid integer, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	--if exists(select codigo from operacion where codigo_ctacte=incodigo limit 1) then
	--	vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar la cuenta corriente por tener relacion con documentos emitidos(Operaciones).';
	--end if;
	if vState then
		delete from basic.ctacte where ctacteid=vctacteid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.pactacte_eliminar(vctacteid integer, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: pactacte_getrow(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pactacte_getrow(vctacteid integer) RETURNS SETOF type_ctacte_getrow
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select cc.ctacteid, to_char(cc.registro, 'DD/MM/YYYY HH12:MI AM')::varchar, cc.bancoid, b.nombre, b.abreviatura, cc.empresaid, e.nombre, cc.nombre, cc.numero, cc.abreviatura, cc.moneda, tm.nombre, tm.simbolo, cc.titular, cc.tipo, cc.banco, cc.controlcheques, cc.che_inicio, cc.che_fin, cc.che_actual, cc.dif_inicio, cc.dif_fin, cc.dif_actual, cc.pcgr_general, cc.pcgr_empresarial, cc.arc_cliente, cc.arc_sucursal, cc.arc_responsable, cc.estado
		from basic.ctacte cc inner join basic.empresa e on cc.empresaid=e.empresaid
			inner join basic.banco b on cc.bancoid=b.bancoid
			left join basic.tipo_moneda tm on trim(cc.moneda)=trim(tm.tipomonedaid)
		where cc.ctacteid=vctacteid;
END
$$;


ALTER FUNCTION basic.pactacte_getrow(vctacteid integer) OWNER TO radiosan_ustaana;

--
-- Name: pactacte_leer(integer, integer, character varying, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pactacte_leer(vbancoid integer, vempresaid integer, vmoneda character varying, vnombre character varying) RETURNS SETOF type_ctacte_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp cascade;
	--create temporary table tmp(tipo integer not null, ctacteid integer not null, cantidad integer not null);
	--insert into tmp select 1, ctacteid, count(*) from basic.permisos_ctacte group by 2;
	
	return query 
		select cc.ctacteid, cc.bancoid, b.nombre, b.abreviatura, cc.empresaid, e.nombre, cc.nombre, cc.numero, cc.abreviatura, cc.moneda, tm.nombre, tm.simbolo, cc.banco, cc.controlcheques, cc.pcgr_general, cc.pcgr_empresarial, cc.estado
		from basic.ctacte cc inner join basic.empresa e on cc.empresaid=e.empresaid
			inner join basic.banco b on cc.bancoid=b.bancoid
			left join basic.tipo_moneda tm on trim(cc.moneda)=trim(tm.tipomonedaid)
		where 1=1
			and case when vbancoid>0 then cc.bancoid=vbancoid else true end
			and case when vempresaid>0 then cc.empresaid=vempresaid else true end
			and case when trim(vmoneda)!='' then cc.moneda=trim(vmoneda) else true end
			and case when trim(vnombre)!='' then (cc.nombre like '%'||trim(vnombre)||'%' or cc.numero like '%'||trim(vnombre)||'%' or cc.abreviatura like '%'||trim(vnombre)||'%') else true end
		order by cc.numero;
		
	drop table if exists tmp cascade;
END
$$;


ALTER FUNCTION basic.pactacte_leer(vbancoid integer, vempresaid integer, vmoneda character varying, vnombre character varying) OWNER TO radiosan_ustaana;

--
-- Name: pactacte_leer_sistema(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pactacte_leer_sistema() RETURNS SETOF type_ctacte_leer_sistema
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select cc.ctacteid, cc.empresaid, 
			cc.bancoid, b.nombre, b.abreviatura,
			cc.numero, 
			(cc.numero || '  ' || case when trim(b.abreviatura)!='' then trim(b.abreviatura) else trim(b.nombre) end)::varchar,
			(case when trim(b.abreviatura)!='' then trim(b.abreviatura) else trim(b.nombre) end ||' '||cc.numero)::varchar, 
			cc.moneda, coalesce(mon.nombre, '')::varchar, coalesce(mon.simbolo, '')::varchar
		from basic.ctacte cc inner join basic.empresa e on cc.empresaid=e.empresaid
			inner join basic.banco b on cc.bancoid=b.bancoid
			left join basic.tipo_moneda mon on trim(cc.moneda)=trim(mon.tipomonedaid)
		order by b.nombre, cc.numero;
END
$$;


ALTER FUNCTION basic.pactacte_leer_sistema() OWNER TO radiosan_ustaana;

--
-- Name: padepartamento_actualizar(boolean, integer, integer, character varying, character varying, character varying, boolean); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION padepartamento_actualizar(innew boolean, indepartamentoid integer, inpaisid integer, innombre character varying, inabreviatura character varying, inubigeo character varying, inestado boolean) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.departamento d where trim(upper(buscar(d.nombre)))=trim(upper(buscar(innombre))) and d.departamentoid!=indepartamentoid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre ya existe en la base de datos';
	end if;
	if vState then
		if trim(inubigeo)!='' then
			if exists(select * from basic.departamento d where trim(upper(buscar(d.ubigeo)))=trim(upper(buscar(inubigeo))) and d.departamentoid!=indepartamentoid) then
				vState:=false; vID:=0; vError:=1; vDescripcion:='El ubigeo ya existe en la base de datos';
			end if;
		end if;
	end if;
	If vState Then
		If inNew Then
			insert into basic.departamento values(default, trim(innombre), trim(inabreviatura), trim(inubigeo), inestado, inpaisid);
			vID:=lastval();
		Else
			update basic.departamento set paisid=inpaisid, nombre=trim(innombre), abreviatura=trim(inabreviatura), ubigeo=trim(inubigeo), estado=inestado where departamentoid=indepartamentoid;
			vID:=indepartamentoid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.padepartamento_actualizar(innew boolean, indepartamentoid integer, inpaisid integer, innombre character varying, inabreviatura character varying, inubigeo character varying, inestado boolean) OWNER TO radiosan_ustaana;

--
-- Name: padepartamento_eliminar(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION padepartamento_eliminar(indepartamentoid integer) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.provincia where departamentoid=indepartamentoid limit 1) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar el departamento por tener provincias relacionadas.';
	end if;
	if vState then
		delete from basic.departamento where departamentoid=indepartamentoid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.padepartamento_eliminar(indepartamentoid integer) OWNER TO radiosan_ustaana;

--
-- Name: padepartamento_getrow(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION padepartamento_getrow(vdepartamentoid integer) RETURNS SETOF type_departamento_getrow
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select d.departamentoid, d.paisid, p.nombre, p.abreviatura, p.ubigeo, d.nombre, d.abreviatura, d.ubigeo, d.estado 
		from basic.departamento d inner join basic.pais p on d.paisid=p.paisid
		where d.departamentoid=vdepartamentoid;
END
$$;


ALTER FUNCTION basic.padepartamento_getrow(vdepartamentoid integer) OWNER TO radiosan_ustaana;

--
-- Name: padepartamento_leer(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION padepartamento_leer(vpaisid integer) RETURNS SETOF type_departamento_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select d.departamentoid, d.paisid, p.nombre, d.nombre, d.abreviatura, d.ubigeo, d.estado 
		from basic.departamento d inner join basic.pais p on d.paisid=p.paisid
		where 1=1
			and case when vpaisid>0 then d.paisid=vpaisid else true end
		order by 2;
END
$$;


ALTER FUNCTION basic.padepartamento_leer(vpaisid integer) OWNER TO radiosan_ustaana;

--
-- Name: padireccion_lastorder(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION padireccion_lastorder(vpersonaid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vOrden integer default 0;
BEGIN
	select max(dir.orden) into vOrden from basic.persona_direccion dir where dir.personaid=vpersonaid;
	return coalesce(vOrden, 0);
END
$$;


ALTER FUNCTION basic.padireccion_lastorder(vpersonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: padistrito_actualizar(boolean, integer, integer, character varying, character varying, character varying, boolean); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION padistrito_actualizar(innew boolean, indistritoid integer, inprovinciaid integer, innombre character varying, inabreviatura character varying, inubigeo character varying, inestado boolean) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.distrito d where trim(upper(buscar(d.nombre)))=trim(upper(buscar(innombre))) and d.provinciaid=inprovinciaid and d.distritoid!=indistritoid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre del distrito ya existe en la base de datos';
	end if;
	if vState then
		if trim(inubigeo)!='' then
			if exists(select * from basic.distrito d where trim(upper(buscar(d.ubigeo)))=trim(upper(buscar(inubigeo))) and d.provinciaid=inprovinciaid and d.distritoid!=indistritoid) then
				vState:=false; vID:=0; vError:=1; vDescripcion:='El ubigeo del distrio ya existe en la base de datos';
			end if;
		end if;
	end if;
	If vState Then
		If inNew Then
			insert into basic.distrito values(default, trim(innombre), trim(inabreviatura), inprovinciaid, trim(inubigeo), inestado);
			vID:=lastval();
		Else
			update basic.distrito set provinciaid=inprovinciaid, nombre=trim(innombre), abreviatura=trim(inabreviatura), ubigeo=trim(inubigeo), estado=inestado where distritoid=indistritoid;
			vID:=indistritoid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.padistrito_actualizar(innew boolean, indistritoid integer, inprovinciaid integer, innombre character varying, inabreviatura character varying, inubigeo character varying, inestado boolean) OWNER TO radiosan_ustaana;

--
-- Name: padistrito_consulta(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION padistrito_consulta(vdepartamentoid integer, vprovinciaid integer, vnombre character varying) RETURNS SETOF type_distrito_consulta
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select d.distritoid, d.nombre, d.provinciaid, p.nombre, p.departamentoid, dpto.nombre, (dpto.ubigeo||p.ubigeo||d.ubigeo)::varchar
		from basic.distrito d inner join basic.provincia p on d.provinciaid=p.provinciaid 
			inner join basic.departamento dpto on p.departamentoid=dpto.departamentoid
		where 1=1
			and case when vdepartamentoid>0 then p.departamentoid=vdepartamentoid else true end
			and case when vprovinciaid>0 then d.provinciaid=vprovinciaid else true end
			and case when vnombre!='' then buscar(upper(d.nombre)) like '%' || buscar(upper(vnombre)) || '%' else true end
		order by 2;
END
$$;


ALTER FUNCTION basic.padistrito_consulta(vdepartamentoid integer, vprovinciaid integer, vnombre character varying) OWNER TO radiosan_ustaana;

--
-- Name: padistrito_eliminar(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION padistrito_eliminar(indistritoid integer) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.persona where distritoid=indistritoid limit 1) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar distrito por tener personas relacionadas.';
	end if;
	if vState then
		delete from basic.distrito where distritoid=indistritoid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.padistrito_eliminar(indistritoid integer) OWNER TO radiosan_ustaana;

--
-- Name: padistrito_getid(character varying, character varying, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION padistrito_getid(vdepartamento character varying, vprovincia character varying, vdistrito character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vdistritoid integer default 0; vcantidaddistritos integer default 0;
BEGIN
	select count(*) into vcantidaddistritos from basic.distrito dis where trim(upper(buscar(dis.nombre)))=trim(upper(buscar(vdistrito)));
	vcantidaddistritos:=coalesce(vcantidaddistritos, 0);
	--raise notice 'CANTIDAD DISTRITOS 1: %', vcantidaddistritos;
	if vcantidaddistritos>0 then
		if vcantidaddistritos=1 then
			select dis.distritoid into vdistritoid from basic.distrito dis where trim(upper(buscar(dis.nombre)))=trim(upper(buscar(vdistrito)));
		else
			select count(*) into vcantidaddistritos from basic.distrito dis inner join basic.provincia pro on dis.provinciaid=pro.provinciaid where trim(upper(buscar(dis.nombre)))=trim(upper(buscar(vdistrito))) and trim(upper(buscar(pro.nombre)))=trim(upper(buscar(vprovincia)));
			vcantidaddistritos:=coalesce(vcantidaddistritos, 0);
			--raise notice 'CANTIDAD DISTRITOS 2: %', vcantidaddistritos;
			if vcantidaddistritos=1 then
				select dis.distritoid into vdistritoid from basic.distrito dis inner join basic.provincia pro on dis.provinciaid=pro.provinciaid where trim(upper(buscar(dis.nombre)))=trim(upper(buscar(vdistrito))) and trim(upper(buscar(pro.nombre)))=trim(upper(buscar(vprovincia)));
			else
				select count(*) into vcantidaddistritos from basic.distrito dis inner join basic.provincia pro on dis.provinciaid=pro.provinciaid inner join basic.departamento dpto on pro.departamentoid=dpto.departamentoid where trim(upper(buscar(dis.nombre)))=trim(upper(buscar(vdistrito))) and trim(upper(buscar(pro.nombre)))=trim(upper(buscar(vprovincia))) and trim(upper(buscar(dpto.nombre)))=trim(upper(buscar(vdepartamento)));
				vcantidaddistritos:=coalesce(vcantidaddistritos, 0);
				--raise notice 'CANTIDAD DISTRITOS 3: %', vcantidaddistritos;
				if vcantidaddistritos>0 then
					select dis.distritoid into vdistritoid from basic.distrito dis inner join basic.provincia pro on dis.provinciaid=pro.provinciaid inner join basic.departamento dpto on pro.departamentoid=dpto.departamentoid where trim(upper(buscar(dis.nombre)))=trim(upper(buscar(vdistrito))) and trim(upper(buscar(pro.nombre)))=trim(upper(buscar(vprovincia))) and trim(upper(buscar(dpto.nombre)))=trim(upper(buscar(vdepartamento)));
				end if;
			end if;
			
		end if;
	end if;

	return coalesce(vdistritoid, 0);
END
$$;


ALTER FUNCTION basic.padistrito_getid(vdepartamento character varying, vprovincia character varying, vdistrito character varying) OWNER TO radiosan_ustaana;

--
-- Name: padistrito_getpaisid(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION padistrito_getpaisid(vdistritoid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vpaisid integer default 0;
BEGIN
	select dpto.paisid into vpaisid from basic.distrito dis inner join basic.provincia pro on dis.provinciaid=pro.provinciaid inner join basic.departamento dpto on pro.departamentoid=dpto.departamentoid where dis.distritoid=vdistritoid;

	return coalesce(vpaisid, 0);
END
$$;


ALTER FUNCTION basic.padistrito_getpaisid(vdistritoid integer) OWNER TO radiosan_ustaana;

--
-- Name: padistrito_getrow(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION padistrito_getrow(vdistritoid integer) RETURNS SETOF type_distrito_getrow
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select d.distritoid, d.nombre, d.abreviatura, d.ubigeo, (dpto.ubigeo||p.ubigeo||d.ubigeo)::varchar, d.provinciaid, p.nombre, p.abreviatura, p.ubigeo, p.departamentoid, dpto.nombre, dpto.abreviatura, dpto.ubigeo, 
			dpto.paisid, pa.nombre, pa.abreviatura, pa.ubigeo, d.estado
		from basic.distrito d inner join basic.provincia p on d.provinciaid=p.provinciaid
			inner join basic.departamento dpto on p.departamentoid=dpto.departamentoid
			inner join basic.pais pa on dpto.paisid=pa.paisid
		where d.distritoid=vdistritoid;
END
$$;


ALTER FUNCTION basic.padistrito_getrow(vdistritoid integer) OWNER TO radiosan_ustaana;

--
-- Name: padistrito_leer(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION padistrito_leer(vdepartamentoid integer, vprovinciaid integer, vnombre character varying) RETURNS SETOF type_distrito_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select dis.distritoid, dpto.departamentoid, dpto.nombre, pro.provinciaid, pro.nombre, dis.nombre, dis.abreviatura, dis.ubigeo, dis.estado
		from basic.distrito dis inner join basic.provincia pro on dis.provinciaid=pro.provinciaid
			inner join basic.departamento dpto on pro.departamentoid=dpto.departamentoid
		where 1=1
			and case when vdepartamentoid>0 then pro.departamentoid=vdepartamentoid else true end
			and case when vprovinciaid>0 then dis.provinciaid=vprovinciaid else true end
			and case when trim(vnombre)!='' then trim(upper(buscar(dis.nombre))) like '%' || trim(upper(buscar(vnombre))) || '%' else true end
		order by dis.nombre;
END
$$;


ALTER FUNCTION basic.padistrito_leer(vdepartamentoid integer, vprovinciaid integer, vnombre character varying) OWNER TO radiosan_ustaana;

--
-- Name: paedificio_actualizar(boolean, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paedificio_actualizar(innew boolean, inedificioid integer, innombre character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.edificio e where trim(upper(buscar(e.nombre)))=trim(upper(buscar(innombre))) and edificioid!=inedificioid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre del edificio ya existe en la base de datos';
	end if;
	if vState then
		If inNew Then
			insert into basic.edificio values(default, trim(innombre));
			vID:=lastval();
		Else
			update basic.edificio set nombre=trim(innombre) where edificioid=inedificioid;
			vID:=inedificioid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paedificio_actualizar(innew boolean, inedificioid integer, innombre character varying) OWNER TO radiosan_ustaana;

--
-- Name: paedificio_eliminar(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paedificio_eliminar(inedificioid integer) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.ambiente where edificioid=inedificioid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar el edificio por tener ambientes registrados.';
	end if;
	if vState=true then
		delete from basic.edificio where edificioid=inedificioid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paedificio_eliminar(inedificioid integer) OWNER TO radiosan_ustaana;

--
-- Name: paedificio_leer(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paedificio_leer() RETURNS SETOF type_edificio_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp cascade;
	create temporary table tmp(edificioid integer not null, count integer not null);
	insert into tmp select edificioid, count(*) from basic.ambiente group by 1;
	
	return query 
		select e.edificioid, e.nombre, coalesce(tmp.count, 0)::integer
		from basic.edificio e left join tmp on e.edificioid=tmp.edificioid 
		where e.edificioid>0 
		order by e.nombre;
		
	drop table if exists tmp cascade;
END
$$;


ALTER FUNCTION basic.paedificio_leer() OWNER TO radiosan_ustaana;

--
-- Name: paempresa_actualizar(boolean, integer, character varying, character varying, character varying, character varying, character varying, character varying, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_actualizar(innew boolean, inempresaid integer, inruc character varying, innombre character varying, innombre_comercial character varying, inabreviatura character varying, indireccion character varying, inurl character varying, indistritoid integer) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.empresa e where trim(upper(buscar(e.nombre)))=trim(upper(buscar(innombre))) and empresaid!=inempresaid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre de la empresa ya esta registrado en la base de datos';
	end if;
	if vState then
		if trim(inruc)!='' then
			if exists(select * from basic.empresa e where trim(upper(e.ruc))=trim(upper(inruc)) and e.empresaid!=inempresaid) then
				vState:=false; vID:=0; vError:=1; vDescripcion:='El RUC de la empresa ya esta registrado en la base de datos';
			end if;
		end if;
	end if;
	if vState then
		if trim(inabreviatura)!='' then
			if exists(select * from basic.empresa e where trim(upper(buscar(e.abreviatura)))=trim(upper(buscar(inabreviatura))) and e.empresaid!=inempresaid) then
				vState:=false; vID:=0; vError:=1; vDescripcion:='La abreviatura de la empresa ya esta registrado en la base de datos';
			end if;
		end if;
	end if;
	If vState Then
		If inNew Then
			insert into basic.empresa values(default, trim(inruc), trim(innombre), trim(inabreviatura), trim(indireccion), trim(inurl), indistritoid, trim(innombre_comercial) );
			vID:=lastval();
		else
			update basic.empresa set ruc=trim(inruc), nombre=trim(innombre), nombre_comercial=trim(innombre_comercial), abreviatura=trim(inabreviatura), direccion=trim(indireccion), url=trim(inurl), distritoid=indistritoid where empresaid=inempresaid;
			vID:=inempresaid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paempresa_actualizar(innew boolean, inempresaid integer, inruc character varying, innombre character varying, innombre_comercial character varying, inabreviatura character varying, indireccion character varying, inurl character varying, indistritoid integer) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_almacen_actualizar(integer, integer, boolean, boolean, integer, integer, integer, integer, integer, integer, integer, boolean, boolean, boolean, boolean, character varying, boolean, boolean, integer, integer, character varying, boolean, boolean, boolean, boolean, character varying, character varying, integer, boolean, integer, boolean, boolean, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_almacen_actualizar(vempresaid integer, valmacenid integer, vsunat_firmar boolean, vsunat_enviar boolean, vsunat_temporizador integer, vsunat_intentos integer, vcantidad_precios integer, vtipo_redondeo integer, vcertificadoid integer, vfirmadorid integer, vventa_tipdocid integer, vventa_sinprecio boolean, vsalida_porpartes boolean, vventa_sinstock boolean, vventa_descuentos boolean, vatencioninterfaz character varying, ventregar boolean, vdespacharotroalmacen boolean, vventa_decimales_cantidad integer, vventa_decimales_precio integer, vcodigo_establecimiento character varying, vgenerarqrcode boolean, vupdate_precio_com boolean, vventa_ingresar_valor_venta boolean, vventa_estransportes boolean, vsunat_desc_item_xml_bien character varying, vsunat_desc_item_xml_serv character varying, vgrupoid integer, vventa_salida_obligatoria boolean, vingreso_tipoingreso integer, vventa_reparto boolean, vpedido_validar_stock boolean, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if not exists(select * from basic.empresa_almacen where empresaid=vempresaid and almacenid=valmacenid) then
		insert into basic.empresa_almacen values(vempresaid, valmacenid, vsunat_firmar, vsunat_enviar, vsunat_temporizador, vsunat_intentos, vcantidad_precios, vtipo_redondeo, vcertificadoid, vventa_tipdocid, vventa_sinprecio, vsalida_porpartes, vfirmadorid, vventa_sinstock, vventa_descuentos, trim(vatencioninterfaz), vdespacharotroalmacen, ventregar, vventa_decimales_cantidad, vventa_decimales_precio, trim(vcodigo_establecimiento), vgenerarqrcode, vupdate_precio_com, vventa_ingresar_valor_venta, vventa_estransportes, trim(vsunat_desc_item_xml_bien), trim(vsunat_desc_item_xml_serv), vgrupoid, vventa_salida_obligatoria, vingreso_tipoingreso, vventa_reparto, vpedido_validar_stock);
		vID:=0;
	Else
		update basic.empresa_almacen 
			set sunat_firmar=vsunat_firmar, sunat_enviar=vsunat_enviar, sunat_temporizador=vsunat_temporizador, sunat_intentos=vsunat_intentos, cantidad_precios=vcantidad_precios, tipo_redondeo=vtipo_redondeo, certificadoid=vcertificadoid, firmadorid=vfirmadorid,
			venta_tipdocid=vventa_tipdocid, venta_sinprecio=vventa_sinprecio, salida_porpartes=vsalida_porpartes,
			venta_sinstock=vventa_sinstock, venta_descuentos=vventa_descuentos, atencion_interfaz=trim(vatencioninterfaz),
			despachar_otroalmacen=vdespacharotroalmacen, entregar=ventregar,
			venta_decimales_cantidad=vventa_decimales_cantidad, venta_decimales_precio=vventa_decimales_precio, codigo_establecimiento=trim(vcodigo_establecimiento),
			generarqrcode=vgenerarqrcode, update_precio_com=vupdate_precio_com, venta_ingresar_valor_venta=vventa_ingresar_valor_venta, venta_estransportes=vventa_estransportes,
			sunat_desc_item_xml_bien=trim(vsunat_desc_item_xml_bien), sunat_desc_item_xml_serv=trim(vsunat_desc_item_xml_serv),
			grupoid=vgrupoid, venta_salida_obligatoria=vventa_salida_obligatoria, ingreso_tipoingreso=vingreso_tipoingreso,
			venta_reparto=vventa_reparto, 
			pedido_validar_stock=vpedido_validar_stock
		where empresaid=vempresaid and almacenid=valmacenid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paempresa_almacen_actualizar(vempresaid integer, valmacenid integer, vsunat_firmar boolean, vsunat_enviar boolean, vsunat_temporizador integer, vsunat_intentos integer, vcantidad_precios integer, vtipo_redondeo integer, vcertificadoid integer, vfirmadorid integer, vventa_tipdocid integer, vventa_sinprecio boolean, vsalida_porpartes boolean, vventa_sinstock boolean, vventa_descuentos boolean, vatencioninterfaz character varying, ventregar boolean, vdespacharotroalmacen boolean, vventa_decimales_cantidad integer, vventa_decimales_precio integer, vcodigo_establecimiento character varying, vgenerarqrcode boolean, vupdate_precio_com boolean, vventa_ingresar_valor_venta boolean, vventa_estransportes boolean, vsunat_desc_item_xml_bien character varying, vsunat_desc_item_xml_serv character varying, vgrupoid integer, vventa_salida_obligatoria boolean, vingreso_tipoingreso integer, vventa_reparto boolean, vpedido_validar_stock boolean, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_almacen_add(integer, integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_almacen_add(vempresaid integer, valmacenid integer, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if not exists(select * from basic.empresa_almacen where empresaid=vempresaid and almacenid=valmacenid) then
		insert into basic.empresa_almacen values(vempresaid, valmacenid, false, false, 500, 10, 1, 0, 0, 0, false, false, 0, false, false, '', false, true, 2, 2, '', false, false, false, false, '', '', 0, false, 0, false, false);
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paempresa_almacen_add(vempresaid integer, valmacenid integer, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_almacen_delete(integer, integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_almacen_delete(vempresaid integer, valmacenid integer, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.empresa_almacen where empresaid=vempresaid and almacenid=valmacenid) then
		delete from basic.empresa_almacen where empresaid=vempresaid and almacenid=valmacenid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paempresa_almacen_delete(vempresaid integer, valmacenid integer, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_almacen_despacho_add(integer, integer, integer[], integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_almacen_despacho_add(vempresaid integer, valmacenid integer, myarr integer[], vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	delete from basic.empresa_almacen_despacho where empresaid=vempresaid and almacenid=valmacenid and despachoalmacenid in (select myarr[i] from generate_series(1, array_upper(myarr, 1)) as i);
	insert into basic.empresa_almacen_despacho select vempresaid, valmacenid, myarr[i] from generate_series(1, array_upper(myarr, 1)) as i;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paempresa_almacen_despacho_add(vempresaid integer, valmacenid integer, myarr integer[], vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_almacen_despacho_delete(integer, integer, integer[], integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_almacen_despacho_delete(vempresaid integer, valmacenid integer, myarr integer[], vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	delete from basic.empresa_almacen_despacho where empresaid=vempresaid and almacenid=valmacenid and despachoalmacenid in (select myarr[i] from generate_series(1, array_upper(myarr, 1)) as i);
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paempresa_almacen_despacho_delete(vempresaid integer, valmacenid integer, myarr integer[], vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_almacen_despacho_getcantidad(integer, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_almacen_despacho_getcantidad(vempresaid integer, valmacenid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vCantidad integer default 0;
BEGIN
	select count(*) into vCantidad from basic.empresa_almacen_despacho ead where ead.empresaid=vempresaid and ead.almacenid=valmacenid;
	return coalesce(vCantidad, 0);
END
$$;


ALTER FUNCTION basic.paempresa_almacen_despacho_getcantidad(vempresaid integer, valmacenid integer) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_almacen_despacho_getids(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_almacen_despacho_getids(vempresaid integer, valmacenid integer, vseperador character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $$
declare vResultado varchar default ''; myRow record; vseperadoraux varchar default '';
BEGIN
	vseperadoraux:=vseperador;
	if(trim(vseperadoraux)='') then
		vseperadoraux=', ';
	end if;
	for myRow in select ead.despachoalmacenid from basic.empresa_almacen_despacho ead inner join basic.almacen alm on ead.almacenid=alm.almacenid inner join basic.zona zon on alm.zonaid=zon.zonaid where ead.empresaid=vempresaid and ead.almacenid=valmacenid order by zon.orden, alm.nombre loop
		vResultado:=vResultado || myRow.despachoalmacenid || vseperadoraux;
	end loop;
	if trim(vResultado)!='' then
		vResultado:=substring(vResultado, 0, char_length(vResultado)- (char_length(vseperadoraux)-1));
	end if;
	return vResultado;
END
$$;


ALTER FUNCTION basic.paempresa_almacen_despacho_getids(vempresaid integer, valmacenid integer, vseperador character varying) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_almacen_despacho_leer(integer, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_almacen_despacho_leer(vempresaid integer, valmacenid integer) RETURNS SETOF type_empresa_almacen_despacho_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query
		select a.almacenid, a.nombre, a.abreviatura
		from basic.empresa_almacen_despacho ead inner join basic.almacen a on ead.despachoalmacenid=a.almacenid
		where ead.empresaid=vempresaid and ead.almacenid=valmacenid
		order by a.nombre;
END
$$;


ALTER FUNCTION basic.paempresa_almacen_despacho_leer(vempresaid integer, valmacenid integer) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_almacen_fp_add(integer, integer, integer[], integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_almacen_fp_add(vempresaid integer, valmacenid integer, myarr integer[], vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	delete from basic.empresa_almacen_fp where empresaid=vempresaid and almacenid=valmacenid and tipoformapagoid in (select myarr[i] from generate_series(1, array_upper(myarr, 1)) as i);
	insert into basic.empresa_almacen_fp select vempresaid, valmacenid, myarr[i] from generate_series(1, array_upper(myarr, 1)) as i;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paempresa_almacen_fp_add(vempresaid integer, valmacenid integer, myarr integer[], vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_almacen_fp_delete(integer, integer, integer[], integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_almacen_fp_delete(vempresaid integer, valmacenid integer, myarr integer[], vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	delete from basic.empresa_almacen_fp where empresaid=vempresaid and almacenid=valmacenid and tipoformapagoid in (select myarr[i] from generate_series(1, array_upper(myarr, 1)) as i);
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paempresa_almacen_fp_delete(vempresaid integer, valmacenid integer, myarr integer[], vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_almacen_fp_getcantidad(integer, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_almacen_fp_getcantidad(vempresaid integer, valmacenid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vCantidad integer default 0;
BEGIN
	select count(*) into vCantidad from basic.empresa_almacen_fp ead where ead.empresaid=vempresaid and ead.almacenid=valmacenid;
	return coalesce(vCantidad, 0);
END
$$;


ALTER FUNCTION basic.paempresa_almacen_fp_getcantidad(vempresaid integer, valmacenid integer) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_almacen_fp_getids(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_almacen_fp_getids(vempresaid integer, valmacenid integer, vseperador character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $$
declare vResultado varchar default ''; myRow record; vseperadoraux varchar default '';
BEGIN
	vseperadoraux:=vseperador;
	if(trim(vseperadoraux)='') then
		vseperadoraux=', ';
	end if;
	for myRow in select ead.tipoformapagoid from basic.empresa_almacen_fp ead inner join basic.almacen alm on ead.almacenid=alm.almacenid inner join basic.zona zon on alm.zonaid=zon.zonaid where ead.empresaid=vempresaid and ead.almacenid=valmacenid order by zon.orden, alm.nombre loop
		vResultado:=vResultado || myRow.tipoformapagoid || vseperadoraux;
	end loop;
	if trim(vResultado)!='' then
		vResultado:=substring(vResultado, 0, char_length(vResultado)- (char_length(vseperadoraux)-1));
	end if;
	return vResultado;
END
$$;


ALTER FUNCTION basic.paempresa_almacen_fp_getids(vempresaid integer, valmacenid integer, vseperador character varying) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_almacen_fp_leer(integer, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_almacen_fp_leer(vempresaid integer, valmacenid integer) RETURNS SETOF type_empresa_almacen_fp_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query
		select tfp.tipoformapagoid, tfp.nombre, tfp.abreviatura
		from basic.empresa_almacen_fp eatfp inner join tesoreria.tipo_forma_pago tfp on eatfp.tipoformapagoid=tfp.tipoformapagoid
		where eatfp.empresaid=vempresaid and eatfp.almacenid=valmacenid
		order by tfp.nombre;
END
$$;


ALTER FUNCTION basic.paempresa_almacen_fp_leer(vempresaid integer, valmacenid integer) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_almacen_getgrupoid(integer, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_almacen_getgrupoid(vempresaid integer, valmacenid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vgrupoid integer default 0;
BEGIN
	select ea.grupoid into vgrupoid from basic.empresa_almacen ea where ea.empresaid=vempresaid and ea.almacenid=valmacenid;
	return coalesce(vgrupoid, 0);
END
$$;


ALTER FUNCTION basic.paempresa_almacen_getgrupoid(vempresaid integer, valmacenid integer) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_almacen_getidsalmacenes(integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_almacen_getidsalmacenes(vempresaid integer, vseperador character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $$
declare vResultado varchar default ''; myRow record; vseperadoraux varchar default '';
BEGIN
	vseperadoraux:=vseperador;
	if(trim(vseperadoraux)='') then
		vseperadoraux=', ';
	end if;
	for myRow in select ea.almacenid from basic.empresa_almacen ea inner join basic.almacen alm on ea.almacenid=alm.almacenid inner join basic.zona zon on alm.zonaid=zon.zonaid where ea.empresaid=vempresaid order by zon.orden, alm.nombre loop
		vResultado:=vResultado || myRow.almacenid || vseperadoraux;
	end loop;
	if trim(vResultado)!='' then
		vResultado:=substring(vResultado, 0, char_length(vResultado)- (char_length(vseperadoraux)-1));
	end if;
	return vResultado;
END
$$;


ALTER FUNCTION basic.paempresa_almacen_getidsalmacenes(vempresaid integer, vseperador character varying) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_almacen_getventasalidaobligatoria(integer, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_almacen_getventasalidaobligatoria(vempresaid integer, valmacenid integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $$
declare vvalor boolean default false;
BEGIN
	select ea.venta_salida_obligatoria into vvalor from basic.empresa_almacen ea where ea.empresaid=vempresaid and ea.almacenid=valmacenid;
	return coalesce(vvalor, false);
END
$$;


ALTER FUNCTION basic.paempresa_almacen_getventasalidaobligatoria(vempresaid integer, valmacenid integer) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_almacen_leer_almacenes(integer, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_almacen_leer_almacenes(vempresaid integer, vzonaid integer) RETURNS SETOF type_empresa_almacen_leer_almacenes
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query
		select a.almacenid, a.nombre, a.abreviatura, a.zonaid, z.nombre, z.abreviatura,
			coalesce(ea.sunat_firmar, false)::boolean, coalesce(ea.sunat_enviar, false)::boolean,
			coalesce(ea.sunat_temporizador, 0)::integer, coalesce(ea.sunat_intentos, 0)::integer, coalesce(ea.cantidad_precios, 0)::integer,
			coalesce(ea.tipo_redondeo, 0)::integer, coalesce(ea.certificadoid, 0)::integer, coalesce(cer.nombre, '')::varchar,
			coalesce(ea.entregar, false)::boolean, coalesce(ea.salida_porpartes, false)::boolean, coalesce(ea.despachar_otroalmacen, false)::boolean, 
			basic.paempresa_almacen_despacho_getcantidad(ea.empresaid, ea.almacenid),
			basic.paempresa_almacen_fp_getcantidad(ea.empresaid, ea.almacenid), ea.generarqrcode, ea.codigo_establecimiento
		from basic.empresa_almacen ea inner join basic.almacen a on ea.almacenid=a.almacenid
			inner join basic.zona z on a.zonaid=z.zonaid
			left join inventarios.certificadodigital cer on ea.certificadoid=cer.certificadoid
		where ea.empresaid=vempresaid
			and case when vzonaid>0 then a.zonaid=vzonaid else true end
		order by z.orden, a.nombre;
END
$$;


ALTER FUNCTION basic.paempresa_almacen_leer_almacenes(vempresaid integer, vzonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_almacen_leer_sistema(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_almacen_leer_sistema() RETURNS SETOF type_empresa_almacen_leer_sistema
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query
		select ea.empresaid, ea.almacenid, (trim(ea.empresaid::varchar)||'-'||trim(ea.almacenid::varchar))::varchar, ea.certificadoid, coalesce(cer.nombre,'')::varchar, coalesce(cer.archivo,'')::varchar, coalesce(cer.clave,'')::varchar, coalesce(cer.alias,'')::varchar, coalesce(fir.codigo,'')::varchar, coalesce(fir.ruc,'')::varchar,coalesce(fir.nombre,'')::varchar,
			ea.firmadorid, coalesce(firma.nombre,'')::varchar, coalesce(firma.archivo,'')::varchar,
			coalesce(ea.sunat_firmar, false)::boolean, coalesce(ea.sunat_enviar, false)::boolean,
			coalesce(ea.sunat_temporizador, 0)::integer, coalesce(ea.sunat_intentos, 0)::integer, coalesce(ea.cantidad_precios, 0)::integer, coalesce(ea.tipo_redondeo, 0)::integer,
			coalesce(ea.venta_tipdocid, 0)::integer, coalesce(ea.venta_sinprecio, false)::boolean, coalesce(ea.salida_porpartes, false)::boolean,
			coalesce(ea.venta_sinstock , false)::boolean, coalesce(ea.venta_descuentos, false)::boolean, coalesce(ea.atencion_interfaz,'')::varchar,
			coalesce(ea.entregar, false)::boolean, coalesce(ea.despachar_otroalmacen, false)::boolean, basic.paempresa_almacen_despacho_getids(ea.empresaid, ea.almacenid, ','),
			coalesce(ea.venta_decimales_cantidad, 0)::integer, coalesce(ea.venta_decimales_precio, 0)::integer, coalesce(ea.codigo_establecimiento, '')::varchar,
			coalesce(ea.generarqrcode, false)::boolean, coalesce(ea.update_precio_com, false)::boolean, coalesce(ea.venta_ingresar_valor_venta, false)::boolean, coalesce(ea.venta_estransportes, false)::boolean,
			coalesce(ea.sunat_desc_item_xml_bien, '')::varchar, coalesce(ea.sunat_desc_item_xml_serv, '')::varchar,
			basic.paempresa_almacen_fp_getids(ea.empresaid, ea.almacenid, ','), ea.grupoid, ea.venta_salida_obligatoria, ea.ingreso_tipoingreso, ea.venta_reparto, ea.pedido_validar_stock
		from basic.empresa_almacen ea left join inventarios.certificadodigital cer on ea.certificadoid=cer.certificadoid
			left join inventarios.firmadigital fir on cer.firmaid=fir.firmaid
			left join inventarios.firmador firma on ea.firmadorid=firma.firmadorid
		order by ea.empresaid, ea.almacenid;
END
$$;


ALTER FUNCTION basic.paempresa_almacen_leer_sistema() OWNER TO radiosan_ustaana;

--
-- Name: paempresa_config_actualizar(integer, integer[], integer, integer, integer, integer, integer, boolean, integer, boolean, numeric, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, integer, integer, integer, integer, integer, integer, integer, integer, integer, integer, integer, integer, integer, integer, integer, integer, integer, integer, integer, integer, integer, integer, integer, integer, integer, integer, integer, integer, numeric, integer, integer, character varying, integer, integer, integer, integer, integer, integer, integer, integer, integer, integer, integer, integer, integer, integer, integer, integer, character varying, integer, integer, integer, character varying, integer, integer, integer, integer, character varying, character varying, integer, numeric, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_config_actualizar(vempresaid integer, myarrtipope integer[], vtipdocidbol integer, vtipdocidfac integer, vtipdocidnc integer, vtipdocidnd integer, vboltipoenvio integer, vbolenviarasociados boolean, vfactipoenvio integer, vfacenviarasociados boolean, vigv numeric, vinv_ubl_version character varying, vinv_custom_version character varying, vcrenot_ubl_version character varying, vcrenot_custom_version character varying, vdebnot_ubl_version character varying, vdebnot_custom_version character varying, vresdia_ubl_version character varying, vresdia_custom_version character varying, vvoided_ubl_version character varying, vvoided_custom_version character varying, vtipodocumento character varying, vcertificadoid integer, vfirmadorid integer, vbill_wsid integer, vbill_wsid2 integer, vbill_wsid3 integer, vbill_usuarioid integer, vbillconsulting_wsid integer, vbillconsulting_usuarioid integer, vsunat_wsid_ruc integer, vsunat_wsid_ruc_captcha integer, vsunat_wsid_ruc_randomid integer, vsunat_wsid_ruc_random integer, vsunat_wsid_ruc_personal integer, vreniec_wsid_dni integer, vreniec_wsid_dni_captcha integer, vreniec_wsid_dni_personal integer, vgrupoid integer, vventa_decimales_precio integer, vventa_decimales_cantidad integer, vventa_clienteid integer, vventa_tipdoc_condni integer, vventa_tipdoc_conruc integer, vventa_condicionpagoid integer, vpaisid integer, vtiporegimenid integer, vservidorftpid integer, vservidorcorreoid integer, vservidorbdid integer, virenta numeric, vordcom_decimales_precio integer, vordcom_decimales_cantidad integer, vordcom_moneda character varying, vordcom_proveedorid integer, vnoting_tipmovidventa integer, vnoting_tipmovidventa_notcre integer, vnoting_tipmovidventa_notdeb integer, vnotsal_tipmovidventa integer, vnotsal_tipmovidventa_notcre integer, vnotsal_tipmovidventa_notdeb integer, vtransferencia_personaid integer, vtransferencia_tipmovid integer, vtransferencia_tipodocumentoid integer, vconversion_personaid integer, vconversion_tipmovid integer, vconversion_tipodocumentoid integer, vinventario_personaid integer, vinventario_tipmovid integer, vinventario_tipodocumentoid integer, inresdia_tipo character varying, inresdia_items integer, inanio integer, inwebservicejarid integer, inmodoenviosunat character varying, inordrec_tipmovid integer, inordrec_tipdocid integer, inordrec_proveedorid integer, vventa_tipopeid integer, vsalida_refdef character varying, vingreso_refdef character varying, inticketsjarid integer, inutilidad numeric, inbillconsulting_tipo_envio character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if not exists(select * from basic.empresa_config where empresaid=vempresaid) then
		insert into basic.empresa_config
		values(vempresaid, vtipdocidbol, vtipdocidfac, vtipdocidnc, vtipdocidnd, vboltipoenvio, vbolenviarasociados, vfactipoenvio, vfacenviarasociados, vigv,
			trim(vinv_ubl_version), trim(vinv_custom_version), trim(vcrenot_ubl_version), trim(vcrenot_custom_version), trim(vdebnot_ubl_version), trim(vdebnot_custom_version), trim(vresdia_ubl_version), trim(vresdia_custom_version), trim(vvoided_ubl_version), trim(vvoided_custom_version), 
			trim(vtipodocumento), vcertificadoid, vbill_wsid, vbill_usuarioid, vbillconsulting_wsid, vbillconsulting_usuarioid, vsunat_wsid_ruc, vsunat_wsid_ruc_captcha, vreniec_wsid_dni, vreniec_wsid_dni_captcha, vgrupoid,
			vventa_decimales_precio, vventa_decimales_cantidad, vventa_clienteid, vventa_tipdoc_condni, vventa_tipdoc_conruc, vventa_condicionpagoid, vpaisid, vtiporegimenid, vservidorftpid, vservidorcorreoid, vservidorbdid, virenta,
			vfirmadorid,
			vsunat_wsid_ruc_randomid, vsunat_wsid_ruc_random, vsunat_wsid_ruc_personal, vreniec_wsid_dni_personal,
			vordcom_decimales_precio, vordcom_decimales_cantidad, vordcom_moneda, vordcom_proveedorid,
			vnoting_tipmovidventa, vnoting_tipmovidventa_notcre, vnoting_tipmovidventa_notdeb,
			vnotsal_tipmovidventa, vnotsal_tipmovidventa_notcre, vnotsal_tipmovidventa_notdeb, 
			vtransferencia_personaid, vtransferencia_tipmovid, vtransferencia_tipodocumentoid, 
			vconversion_personaid, vconversion_tipmovid, vconversion_tipodocumentoid, 
			vinventario_personaid, vinventario_tipmovid, vinventario_tipodocumentoid,
			trim(inresdia_tipo), inresdia_items, inanio, inwebservicejarid, inmodoenviosunat,
			vbill_wsid2, vbill_wsid3,
			inordrec_tipmovid, inordrec_tipdocid, inordrec_proveedorid,
			vventa_tipopeid, trim(vsalida_refdef), trim(vingreso_refdef),
			inticketsjarid, inutilidad, trim(inbillconsulting_tipo_envio)
		);
		vID:=0;
	Else
		update basic.empresa_config 
			set
				tipdocid_bol=vtipdocidbol, tipdocid_fac=vtipdocidfac, tipdocid_nc=vtipdocidnc, tipdocid_nd=vtipdocidnd,
				bol_tipo_envio=vboltipoenvio, bol_enviar_asociados=vbolenviarasociados, fac_tipo_envio=vfactipoenvio, fac_enviar_asociados=vfacenviarasociados,
				inv_ubl_version=trim(vinv_ubl_version), inv_custom_version=trim(vinv_custom_version), 
				crenot_ubl_version=trim(vcrenot_ubl_version), crenot_custom_version=trim(vcrenot_custom_version), 
				debnot_ubl_version=trim(vdebnot_ubl_version), debnot_custom_version=trim(vdebnot_custom_version), 
				resdia_ubl_version=trim(vresdia_ubl_version), resdia_custom_version=trim(vresdia_custom_version), 
				voided_ubl_version=trim(vvoided_ubl_version), voided_custom_version=trim(vvoided_custom_version), 
				igv=vigv,
				
				tipodocumento=trim(vtipodocumento), certificadoid=vcertificadoid, 
				bill_wsid=vbill_wsid, bill_wsid2=vbill_wsid2, bill_wsid3=vbill_wsid3, bill_usuarioid=vbill_usuarioid, 
				billconsulting_wsid=vbillconsulting_wsid, billconsulting_usuarioid=vbillconsulting_usuarioid, 
				sunat_wsid_ruc=vsunat_wsid_ruc, sunat_wsid_ruc_captcha=vsunat_wsid_ruc_captcha, 
				reniec_wsid_dni=vreniec_wsid_dni, reniec_wsid_dni_captcha=vreniec_wsid_dni_captcha,

				grupoid=vgrupoid,

				venta_decimales_precio=vventa_decimales_precio, venta_decimales_cantidad=vventa_decimales_cantidad, venta_clienteid=vventa_clienteid, venta_tipdoc_condni=vventa_tipdoc_condni, venta_tipdoc_conruc=vventa_tipdoc_conruc, venta_condicionpagoid=vventa_condicionpagoid, 

				paisid=vpaisid, tiporegimenid=vtiporegimenid, servidorftpid=vservidorftpid, servidorcorreoid=vservidorcorreoid, servidorbdid=vservidorbdid, irenta=virenta,
				firmadorid=vfirmadorid,
				
				sunat_wsid_ruc_randomid=vsunat_wsid_ruc_randomid, sunat_wsid_ruc_random=vsunat_wsid_ruc_random, sunat_wsid_ruc_personal=vsunat_wsid_ruc_personal, reniec_wsid_dni_personal=vreniec_wsid_dni_personal,
				
				ordcom_decimales_precio=vordcom_decimales_precio, ordcom_decimales_cantidad=vordcom_decimales_cantidad, ordcom_moneda=vordcom_moneda, ordcom_proveedorid=vordcom_proveedorid,

				noting_tipmovidventa=vnoting_tipmovidventa, noting_tipmovidventa_notcre=vnoting_tipmovidventa_notcre, noting_tipmovidventa_notdeb=vnoting_tipmovidventa_notdeb,
				notsal_tipmovidventa=vnotsal_tipmovidventa, notsal_tipmovidventa_notcre=vnotsal_tipmovidventa_notcre, notsal_tipmovidventa_notdeb=vnotsal_tipmovidventa_notdeb, 
				transferencia_personaid=vtransferencia_personaid, transferencia_tipmovid=vtransferencia_tipmovid, transferencia_tipodocumentoid=vtransferencia_tipodocumentoid, 
				conversion_personaid=vconversion_personaid, conversion_tipmovid=vconversion_tipmovid, conversion_tipodocumentoid=vconversion_tipodocumentoid, 
				inventario_personaid=vinventario_personaid, inventario_tipmovid=vinventario_tipmovid, inventario_tipodocumentoid=vinventario_tipodocumentoid,
				resdia_tipo=inresdia_tipo, resdia_items=inresdia_items, anio=inanio,
				webservicejarid=inwebservicejarid, modoenviosunat=inmodoenviosunat,
				ordrec_tipmovid=inordrec_tipmovid, ordrec_tipdocid=inordrec_tipdocid, ordrec_proveedorid=inordrec_proveedorid,
				venta_tipopeid=vventa_tipopeid, salida_refdef=trim(vsalida_refdef), ingreso_refdef=trim(vingreso_refdef),
				ticktesjarid=inticketsjarid, utilidad=inutilidad, 
				billconsulting_tipo_envio=trim(inbillconsulting_tipo_envio)
				
		where empresaid=vempresaid;
	end if;
	delete from basic.empresa_tipooperacion where empresaid=vempresaid;
	insert into basic.empresa_tipooperacion select vempresaid, myarrtipope[i] from generate_series(1, array_upper(myarrtipope, 1)) as i;
	
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paempresa_config_actualizar(vempresaid integer, myarrtipope integer[], vtipdocidbol integer, vtipdocidfac integer, vtipdocidnc integer, vtipdocidnd integer, vboltipoenvio integer, vbolenviarasociados boolean, vfactipoenvio integer, vfacenviarasociados boolean, vigv numeric, vinv_ubl_version character varying, vinv_custom_version character varying, vcrenot_ubl_version character varying, vcrenot_custom_version character varying, vdebnot_ubl_version character varying, vdebnot_custom_version character varying, vresdia_ubl_version character varying, vresdia_custom_version character varying, vvoided_ubl_version character varying, vvoided_custom_version character varying, vtipodocumento character varying, vcertificadoid integer, vfirmadorid integer, vbill_wsid integer, vbill_wsid2 integer, vbill_wsid3 integer, vbill_usuarioid integer, vbillconsulting_wsid integer, vbillconsulting_usuarioid integer, vsunat_wsid_ruc integer, vsunat_wsid_ruc_captcha integer, vsunat_wsid_ruc_randomid integer, vsunat_wsid_ruc_random integer, vsunat_wsid_ruc_personal integer, vreniec_wsid_dni integer, vreniec_wsid_dni_captcha integer, vreniec_wsid_dni_personal integer, vgrupoid integer, vventa_decimales_precio integer, vventa_decimales_cantidad integer, vventa_clienteid integer, vventa_tipdoc_condni integer, vventa_tipdoc_conruc integer, vventa_condicionpagoid integer, vpaisid integer, vtiporegimenid integer, vservidorftpid integer, vservidorcorreoid integer, vservidorbdid integer, virenta numeric, vordcom_decimales_precio integer, vordcom_decimales_cantidad integer, vordcom_moneda character varying, vordcom_proveedorid integer, vnoting_tipmovidventa integer, vnoting_tipmovidventa_notcre integer, vnoting_tipmovidventa_notdeb integer, vnotsal_tipmovidventa integer, vnotsal_tipmovidventa_notcre integer, vnotsal_tipmovidventa_notdeb integer, vtransferencia_personaid integer, vtransferencia_tipmovid integer, vtransferencia_tipodocumentoid integer, vconversion_personaid integer, vconversion_tipmovid integer, vconversion_tipodocumentoid integer, vinventario_personaid integer, vinventario_tipmovid integer, vinventario_tipodocumentoid integer, inresdia_tipo character varying, inresdia_items integer, inanio integer, inwebservicejarid integer, inmodoenviosunat character varying, inordrec_tipmovid integer, inordrec_tipdocid integer, inordrec_proveedorid integer, vventa_tipopeid integer, vsalida_refdef character varying, vingreso_refdef character varying, inticketsjarid integer, inutilidad numeric, inbillconsulting_tipo_envio character varying) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_config_getconversion_personaid(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_config_getconversion_personaid(vempresaid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vpersonaid integer default 0;
BEGIN
	select c.conversion_personaid into vpersonaid from basic.empresa_config c where c.empresaid=vempresaid;
	return coalesce(vpersonaid, 0);
END
$$;


ALTER FUNCTION basic.paempresa_config_getconversion_personaid(vempresaid integer) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_config_getconversion_tipdocid(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_config_getconversion_tipdocid(vempresaid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vtipdocid integer default 0;
BEGIN
	select c.conversion_tipodocumentoid into vtipdocid from basic.empresa_config c where c.empresaid=vempresaid;
	return coalesce(vtipdocid, 0);
END
$$;


ALTER FUNCTION basic.paempresa_config_getconversion_tipdocid(vempresaid integer) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_config_getconversion_tipmovid(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_config_getconversion_tipmovid(vempresaid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vtipmovid integer default 0;
BEGIN
	select c.conversion_tipmovid into vtipmovid from basic.empresa_config c where c.empresaid=vempresaid;
	return coalesce(vtipmovid, 0);
END
$$;


ALTER FUNCTION basic.paempresa_config_getconversion_tipmovid(vempresaid integer) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_config_getigv(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_config_getigv(vempresaid integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $$
declare vigv numeric default 0;
BEGIN
	select c.igv into vigv from basic.empresa_config c where c.empresaid=vempresaid;
	return coalesce(vigv, 0);
END
$$;


ALTER FUNCTION basic.paempresa_config_getigv(vempresaid integer) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_config_getinvini_personaid(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_config_getinvini_personaid(vempresaid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vpersonaid integer default 0;
BEGIN
	select c.inventario_personaid into vpersonaid from basic.empresa_config c where c.empresaid=vempresaid;
	return coalesce(vpersonaid, 0);
END
$$;


ALTER FUNCTION basic.paempresa_config_getinvini_personaid(vempresaid integer) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_config_getinvini_tipdocid(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_config_getinvini_tipdocid(vempresaid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vtipdocid integer default 0;
BEGIN
	select c.inventario_tipodocumentoid into vtipdocid from basic.empresa_config c where c.empresaid=vempresaid;
	return coalesce(vtipdocid, 0);
END
$$;


ALTER FUNCTION basic.paempresa_config_getinvini_tipdocid(vempresaid integer) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_config_getinvini_tipmovid(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_config_getinvini_tipmovid(vempresaid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vtipmovid integer default 0;
BEGIN
	select c.inventario_tipmovid into vtipmovid from basic.empresa_config c where c.empresaid=vempresaid;
	return coalesce(vtipmovid, 0);
END
$$;


ALTER FUNCTION basic.paempresa_config_getinvini_tipmovid(vempresaid integer) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_config_gettransferencia_personaid(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_config_gettransferencia_personaid(vempresaid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vpersonaid integer default 0;
BEGIN
	select c.transferencia_personaid into vpersonaid from basic.empresa_config c where c.empresaid=vempresaid;
	return coalesce(vpersonaid, 0);
END
$$;


ALTER FUNCTION basic.paempresa_config_gettransferencia_personaid(vempresaid integer) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_config_gettransferencia_tipdocid(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_config_gettransferencia_tipdocid(vempresaid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vtipdocid integer default 0;
BEGIN
	select c.transferencia_tipodocumentoid into vtipdocid from basic.empresa_config c where c.empresaid=vempresaid;
	return coalesce(vtipdocid, 0);
END
$$;


ALTER FUNCTION basic.paempresa_config_gettransferencia_tipdocid(vempresaid integer) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_config_gettransferencia_tipmovid(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_config_gettransferencia_tipmovid(vempresaid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vtipmovid integer default 0;
BEGIN
	select c.transferencia_tipmovid into vtipmovid from basic.empresa_config c where c.empresaid=vempresaid;
	return coalesce(vtipmovid, 0);
END
$$;


ALTER FUNCTION basic.paempresa_config_gettransferencia_tipmovid(vempresaid integer) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_config_getvalue(integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_config_getvalue(vempresaid integer, vvalor character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $$
declare vrpta varchar default '';
BEGIN
	select (case
		when vvalor='invoice-ubl' then c.inv_ubl_version
		when vvalor='invoice-custom' then c.inv_custom_version
		when vvalor='creditnote-ubl' then c.crenot_ubl_version
		when vvalor='creditnote-custom' then c.crenot_custom_version
		when vvalor='debitnote-ubl' then c.debnot_ubl_version
		when vvalor='debitnote-custom' then c.debnot_custom_version
		else ''
		end) into vrpta from basic.empresa_config c where c.empresaid=vempresaid;
	return coalesce(vrpta, '');
END
$$;


ALTER FUNCTION basic.paempresa_config_getvalue(vempresaid integer, vvalor character varying) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_config_getventa_noting_tipmovid(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_config_getventa_noting_tipmovid(vempresaid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vtipmovid integer default 0;
BEGIN
	select c.noting_tipmovidventa into vtipmovid from basic.empresa_config c where c.empresaid=vempresaid;
	return coalesce(vtipmovid, 0);
END
$$;


ALTER FUNCTION basic.paempresa_config_getventa_noting_tipmovid(vempresaid integer) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_config_getventa_noting_tipmovid_notcre(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_config_getventa_noting_tipmovid_notcre(vempresaid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vtipmovid integer default 0;
BEGIN
	select c.noting_tipmovidventa_notcre into vtipmovid from basic.empresa_config c where c.empresaid=vempresaid;
	return coalesce(vtipmovid, 0);
END
$$;


ALTER FUNCTION basic.paempresa_config_getventa_noting_tipmovid_notcre(vempresaid integer) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_config_getventa_noting_tipmovid_notdeb(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_config_getventa_noting_tipmovid_notdeb(vempresaid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vtipmovid integer default 0;
BEGIN
	select c.noting_tipmovidventa_notdeb into vtipmovid from basic.empresa_config c where c.empresaid=vempresaid;
	return coalesce(vtipmovid, 0);
END
$$;


ALTER FUNCTION basic.paempresa_config_getventa_noting_tipmovid_notdeb(vempresaid integer) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_config_getventa_notsal_tipmovid(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_config_getventa_notsal_tipmovid(vempresaid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vtipmovid integer default 0;
BEGIN
	select c.notsal_tipmovidventa into vtipmovid from basic.empresa_config c where c.empresaid=vempresaid;
	return coalesce(vtipmovid, 0);
END
$$;


ALTER FUNCTION basic.paempresa_config_getventa_notsal_tipmovid(vempresaid integer) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_config_getventa_notsal_tipmovid_notcre(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_config_getventa_notsal_tipmovid_notcre(vempresaid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vtipmovid integer default 0;
BEGIN
	select c.notsal_tipmovidventa_notcre into vtipmovid from basic.empresa_config c where c.empresaid=vempresaid;
	return coalesce(vtipmovid, 0);
END
$$;


ALTER FUNCTION basic.paempresa_config_getventa_notsal_tipmovid_notcre(vempresaid integer) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_config_getventa_notsal_tipmovid_notdeb(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_config_getventa_notsal_tipmovid_notdeb(vempresaid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vtipmovid integer default 0;
BEGIN
	select c.notsal_tipmovidventa_notdeb into vtipmovid from basic.empresa_config c where c.empresaid=vempresaid;
	return coalesce(vtipmovid, 0);
END
$$;


ALTER FUNCTION basic.paempresa_config_getventa_notsal_tipmovid_notdeb(vempresaid integer) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_config_getventaclienteid(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_config_getventaclienteid(vempresaid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vclienteid integer default 0;
BEGIN
	select c.venta_clienteid into vclienteid from basic.empresa_config c where c.empresaid=vempresaid;
	return coalesce(vclienteid, 0);
END
$$;


ALTER FUNCTION basic.paempresa_config_getventaclienteid(vempresaid integer) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_config_getventatipdoc(integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_config_getventatipdoc(vempresaid integer, vtipo character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vtipdocid integer default 0;
BEGIN
	if upper(trim(vtipo))='RUC' then
		select c.venta_tipdoc_condni into vtipdocid from basic.empresa_config c where c.empresaid=vempresaid;
	elseif upper(trim(vtipo))='DNI' then
		select c.venta_tipdoc_conruc into vtipdocid from basic.empresa_config c where c.empresaid=vempresaid;
	end if;
	return coalesce(vtipdocid, 0);
END
$$;


ALTER FUNCTION basic.paempresa_config_getventatipdoc(vempresaid integer, vtipo character varying) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_config_webservice_facturacion(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_config_webservice_facturacion(vempresaid integer) RETURNS SETOF type_empresa_config_webservice_facturacion
    LANGUAGE plpgsql
    AS $$
declare vBillWebSerId1 integer default 0; vBillWebSerId2 integer default 0; vBillWebSerId3 integer default 0;
BEGIN
	select conf.bill_wsid, conf.bill_wsid2, conf.bill_wsid3 into vBillWebSerId1, vBillWebSerId2, vBillWebSerId3 from basic.empresa_config conf where conf.empresaid=vempresaid;
	vBillWebSerId1:=coalesce(vBillWebSerId1, 0);
	vBillWebSerId2:=coalesce(vBillWebSerId2, 0);
	vBillWebSerId3:=coalesce(vBillWebSerId3, 0);
	raise notice '%, %, %', vBillWebSerId1, vBillWebSerId2, vBillWebSerId3;
	return query
		select ws.webserviceid, ws.institucionid, i.nombre, i.referencia, ws.tipoid, t.nombre, t.referencia, ws.nombre, ws.url
		from webservice.webservice ws inner join webservice.institucion i on ws.institucionid=i.institucionid
			inner join webservice.tipo t on ws.tipoid=t.tipoid
		where ws.webserviceid in (vBillWebSerId1, vBillWebSerId2, vBillWebSerId3)
		order by i.orden, t.orden, ws.orden;
END
$$;


ALTER FUNCTION basic.paempresa_config_webservice_facturacion(vempresaid integer) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_eliminar(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_eliminar(vempresaid integer, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from inventarios.venta where empresaid=vempresaid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar la empresa por tener ventas registradas.';
	end if;
	if vState then
		if exists(select * from inventarios.serie where empresaid=vempresaid) then
			vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar la empresa por tener ventas registradas.';
		end if;
	end if;
	if vState then
		delete from inventarios.resumen_diario_correlativos where empresaid=vempresaid;
		delete from inventarios.resumen_anuladas_correlativos where empresaid=vempresaid;
		delete from contabilidad.correlativos_periodo where empresaid=vempresaid;
		delete from webservice.usuario where empresaid=vempresaid;
		delete from basic.permisos_empresa where empresaid=vempresaid;
		delete from basic.empresa_tipooperacion where empresaid=vempresaid;
		delete from basic.empresa_config where empresaid=vempresaid;
		delete from basic.empresa where empresaid=vempresaid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paempresa_eliminar(vempresaid integer, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_formatos_leer(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_formatos_leer(vempresaid integer) RETURNS SETOF type_empresa_formatos_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query
		select conf.empresaid, conf.tipooperacionid, conf.tipodocumentoid, conf.formato
		from basic.empresa_formatos conf
		where conf.empresaid=vempresaid;
END
$$;


ALTER FUNCTION basic.paempresa_formatos_leer(vempresaid integer) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_formatos_leer_sistema(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_formatos_leer_sistema() RETURNS SETOF type_empresa_formatos_leer_sistema
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query
		select conf.empresaid, conf.tipooperacionid, conf.tipodocumentoid, conf.formato
		from basic.empresa_formatos conf
		order by 1, 2, 3;
END
$$;


ALTER FUNCTION basic.paempresa_formatos_leer_sistema() OWNER TO radiosan_ustaana;

--
-- Name: paempresa_formatos_registrar(integer, character varying[], integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_formatos_registrar(vempresaid integer, myarr character varying[], vusuarioid integer, vcaja character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vFilas integer default 0; vIndice integer default 0; vTipoOperacionId integer default 0; vTipoDocumentoId integer default 0; vFormato varchar default '';
BEGIN
	--BEGIN DETALLE EN TEMPORAL
	if (not (myarr[1][1] is null)) then
		vIndice:=0;
		vFilas=array_upper(myarr,1);
		if vFilas>0 then
			for vIndice in 1..vFilas loop
				vTipoOperacionId:=myArr[vIndice][1]::integer;
				vTipoDocumentoId:=myArr[vIndice][2]::integer;
				vFormato:=trim(myArr[vIndice][3]);
				
				if vTipoOperacionId>=0 and vTipoDocumentoId>0 then
					delete from basic.empresa_formatos where empresaid=vempresaid and tipooperacionid=vtipooperacionid and tipodocumentoid=vtipodocumentoid;
					insert into basic.empresa_formatos values(vempresaid, vtipooperacionid, vtipodocumentoid, trim(vformato));
				end if;
			end loop;

		end if;
	end if;
	
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paempresa_formatos_registrar(vempresaid integer, myarr character varying[], vusuarioid integer, vcaja character varying) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_getdato(integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_getdato(vempresaid integer, vvalor character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $$
declare vresultado varchar default '';
BEGIN
	select trim(case 
		when vvalor='nombre' then emp.nombre 
		when vvalor='abreviatura' then emp.abreviatura 
		when vvalor='ruc' then emp.ruc
		else emp.empresaid::varchar end) into vresultado 
	from basic.empresa emp where emp.empresaid=vempresaid;
	
	return coalesce(vresultado, '');
END
$$;


ALTER FUNCTION basic.paempresa_getdato(vempresaid integer, vvalor character varying) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_getgrupoid(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_getgrupoid(vempresaid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vgrupoid integer default 0;
BEGIN
	select c.grupoid into vgrupoid from basic.empresa_config c where c.empresaid=vempresaid;
	return coalesce(vgrupoid, 0);
END
$$;


ALTER FUNCTION basic.paempresa_getgrupoid(vempresaid integer) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_getigv(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_getigv(vempresaid integer) RETURNS numeric
    LANGUAGE plpgsql
    AS $$
declare vigv numeric default 0;
BEGIN
	select c.igv into vigv from basic.empresa_config c where c.empresaid=vempresaid;
	return coalesce(vigv, 0);
END
$$;


ALTER FUNCTION basic.paempresa_getigv(vempresaid integer) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_getpaisid(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_getpaisid(vempresaid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vpaisid integer default 0;
BEGIN
	select dpto.paisid into vpaisid from basic.empresa emp inner join basic.distrito dis on emp.distritoid=dis.distritoid inner join basic.provincia pro on dis.provinciaid=pro.provinciaid inner join basic.departamento dpto on pro.departamentoid=dpto.departamentoid where emp.empresaid=vempresaid;
	return coalesce(vpaisid, 0);
END
$$;


ALTER FUNCTION basic.paempresa_getpaisid(vempresaid integer) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_getrow(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_getrow(vempresaid integer) RETURNS SETOF type_empresa_getrow
    LANGUAGE plpgsql
    AS $$
declare vCantAlmacen integer default 0;
BEGIN
	select count(*) into vCantAlmacen from basic.empresa_almacen e where e.empresaid=vempresaid;
	return query 
		select e.empresaid, e.ruc, e.nombre, e.nombre_comercial, e.abreviatura, e.direccion, e.url, e.distritoid, coalesce(dis.nombre,'')::varchar, coalesce(dis.provinciaid,0)::integer, coalesce(pro.nombre,'')::varchar, coalesce(pro.departamentoid, 0)::integer, coalesce(dpto.nombre, '')::varchar,
			coalesce(conf.igv, 0)::numeric, coalesce(vCantAlmacen, 0)::integer
		from basic.empresa e left join basic.distrito dis on e.distritoid=dis.distritoid
			left join basic.provincia pro on dis.provinciaid=pro.provinciaid
			left join basic.departamento dpto on pro.departamentoid=dpto.departamentoid
			left join basic.empresa_config conf on e.empresaid=conf.empresaid
		where e.empresaid=vempresaid;
END
$$;


ALTER FUNCTION basic.paempresa_getrow(vempresaid integer) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_leer(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_leer() RETURNS SETOF type_empresa_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp cascade;
	create temporary table tmp (empresaid integer not null, count integer not null);
	insert into tmp select ea.empresaid, count(*) from basic.empresa_almacen ea group by 1;
	return query 
		select e.empresaid, e.ruc, e.nombre, e.nombre_comercial, e.abreviatura, e.direccion, e.url,
			e.distritoid, coalesce(dis.nombre,'')::varchar, coalesce(dis.provinciaid,0)::integer, coalesce(pro.nombre,'')::varchar, coalesce(pro.departamentoid, 0)::integer, coalesce(dpto.nombre, '')::varchar,
			coalesce(tmp.count, 0)::integer
		from basic.empresa e left join basic.distrito dis on e.distritoid=dis.distritoid
			left join basic.provincia pro on dis.provinciaid=pro.provinciaid
			left join basic.departamento dpto on pro.departamentoid=dpto.departamentoid
			left join tmp on e.empresaid=tmp.empresaid
		order by e.empresaid;
END
$$;


ALTER FUNCTION basic.paempresa_leer() OWNER TO radiosan_ustaana;

--
-- Name: paempresa_leer_sistema(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_leer_sistema() RETURNS SETOF type_empresa_leer_sistema
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select e.empresaid, e.ruc, e.nombre, e.nombre_comercial, coalesce(conf.tipodocumento, '')::varchar, e.abreviatura, e.direccion, e.url, coalesce(busu.usuario,'')::varchar, coalesce(busu.clave, '')::varchar, coalesce(bcusu.usuario,'')::varchar, coalesce(bcusu.clave, '')::varchar,
			e.distritoid, coalesce(dis.nombre,'')::varchar, (dpto.ubigeo||pro.ubigeo||dis.ubigeo)::varchar, coalesce(dis.provinciaid,0)::integer, coalesce(pro.nombre,'')::varchar, coalesce(pro.departamentoid, 0)::integer, coalesce(dpto.nombre, '')::varchar,
			coalesce(conf.bill_wsid,0)::integer, coalesce(bws1.url,'')::varchar, 
			coalesce(conf.bill_wsid2,0)::integer, coalesce(bws2.url,'')::varchar, 
			coalesce(conf.bill_wsid3,0)::integer, coalesce(bws3.url,'')::varchar, 
			coalesce(conf.billconsulting_wsid,0)::integer, coalesce(bcws.url,'')::varchar, coalesce(conf.billconsulting_usuarioid, 0),
			coalesce(conf.tipdocid_bol,0)::integer, coalesce(conf.tipdocid_fac,0)::integer, coalesce(conf.tipdocid_nc,0)::integer, coalesce(conf.tipdocid_nd,0)::integer,
			coalesce(conf.bol_tipo_envio, 0)::integer, coalesce(conf.bol_enviar_asociados, false)::boolean,
			coalesce(conf.tipdocid_fac, 0)::integer, coalesce(conf.fac_enviar_asociados, false)::boolean,
			conf.certificadoid, coalesce(cer.nombre,'')::varchar, coalesce(cer.archivo,'')::varchar, coalesce(cer.clave,'')::varchar, coalesce(cer.alias,'')::varchar, coalesce(fir.codigo,'')::varchar, coalesce(fir.ruc,'')::varchar,coalesce(fir.nombre,'')::varchar,
			conf.firmadorid, coalesce(firma.nombre,'')::varchar, coalesce(firma.archivo,'')::varchar,
			coalesce(conf.igv, 0)::numeric,
			coalesce(conf.inv_ubl_version, '')::varchar, coalesce(conf.inv_custom_version, '')::varchar,
			coalesce(conf.crenot_ubl_version, '')::varchar, coalesce(conf.crenot_custom_version, '')::varchar,
			coalesce(conf.debnot_ubl_version, '')::varchar, coalesce(conf.debnot_custom_version, '')::varchar,
			coalesce(conf.resdia_ubl_version, '')::varchar, coalesce(conf.resdia_custom_version, '')::varchar,
			coalesce(conf.voided_ubl_version, '')::varchar, coalesce(conf.voided_custom_version, '')::varchar,
			
			conf.grupoid, gru.nombre, 
			
			basic.paempresa_almacen_getidsalmacenes(e.empresaid, ','),
			basic.paempresa_tipooperacion_getidstipooperacion(e.empresaid, ','),

			conf.venta_decimales_precio, conf.venta_decimales_cantidad, conf.venta_clienteid, conf.venta_tipdoc_condni, conf.venta_tipdoc_conruc, conf.venta_condicionpagoid, conf.paisid, conf.tiporegimenid, 
			conf.servidorftpid, coalesce(sftp.nombre,'')::varchar, coalesce(sftp.servidor,'')::varchar, coalesce(sftp.usuario,'')::varchar, coalesce(sftp.clave,'')::varchar, coalesce(sftp.puerto,'')::varchar, coalesce(sftp.path_html,'')::varchar, coalesce(sftp.path_xml,'')::varchar, 'ftp.jar'::varchar,
			conf.servidorcorreoid, 
			conf.servidorbdid, coalesce(sdb.nombre,'')::varchar, coalesce(sdb.servidor,'')::varchar, coalesce(sdb.usuario,'')::varchar, coalesce(sdb.basedatos,'')::varchar, coalesce(sdb.clave,'')::varchar, coalesce(sdb.puerto,'')::varchar,
			conf.irenta,

			conf.sunat_wsid_ruc, coalesce(wsruc.url,'')::varchar,
			conf.sunat_wsid_ruc_captcha, coalesce(wsruc_c.url,'')::varchar,
			conf.sunat_wsid_ruc_randomid, coalesce(wsruc_r_id.url,'')::varchar,
			conf.sunat_wsid_ruc_random, coalesce(wsruc_r.url,'')::varchar,
			conf.sunat_wsid_ruc_personal, coalesce(wsruc_p.url,'')::varchar,

			conf.reniec_wsid_dni, coalesce(wsdni.url,'')::varchar,
			conf.reniec_wsid_dni_captcha, coalesce(wsdni_c.url,'')::varchar, 
			conf.reniec_wsid_dni_personal, coalesce(wsdni_p.url,'')::varchar,

			coalesce(conf.ordcom_decimales_precio, 0)::integer, coalesce(conf.ordcom_decimales_cantidad,0)::integer, coalesce(conf.ordcom_moneda,'NS')::varchar, coalesce(conf.ordcom_proveedorid,0)::integer,

			coalesce(conf.noting_tipmovidventa, 0)::integer, coalesce(conf.noting_tipmovidventa_notcre, 0)::integer, coalesce(conf.noting_tipmovidventa_notdeb, 0)::integer,
			coalesce(conf.notsal_tipmovidventa, 0)::integer, coalesce(conf.notsal_tipmovidventa_notcre, 0)::integer, coalesce(conf.notsal_tipmovidventa_notdeb, 0)::integer, 
			coalesce(conf.transferencia_personaid, 0)::integer, coalesce(conf.transferencia_tipmovid, 0)::integer, coalesce(conf.transferencia_tipodocumentoid, 0)::integer, 
			coalesce(conf.conversion_personaid, 0)::integer, coalesce(conf.conversion_tipmovid, 0)::integer, coalesce(conf.conversion_tipodocumentoid, 0)::integer, 
			coalesce(conf.inventario_personaid, 0)::integer, coalesce(conf.inventario_tipmovid, 0)::integer, coalesce(conf.inventario_tipodocumentoid, 0)::integer,

			coalesce(conf.resdia_tipo,'SERIE')::varchar, coalesce(conf.resdia_items,0)::integer, coalesce(conf.anio,0)::integer,

			coalesce(conf.webservicejarid,0)::integer, coalesce(wsjar.nombre,'')::varchar, coalesce(wsjar.archivo,'')::varchar, coalesce(conf.modoenviosunat, '')::varchar,
			coalesce(conf.ordrec_tipmovid,0)::integer, coalesce(conf.ordrec_tipdocid,0)::integer, coalesce(conf.ordrec_proveedorid,0)::integer,
			coalesce(conf.venta_tipopeid,0)::integer, coalesce(conf.salida_refdef,'')::varchar, coalesce(conf.ingreso_refdef,'')::varchar,
			coalesce(conf.ticktesjarid,0)::integer, coalesce(tickjar.nombre,'')::varchar, coalesce(tickjar.archivo,'')::varchar,
			coalesce(conf.utilidad,0)::numeric,
			coalesce(conf.billconsulting_tipo_envio, '')::varchar

		from basic.empresa e left join basic.distrito dis on e.distritoid=dis.distritoid
			left join basic.provincia pro on dis.provinciaid=pro.provinciaid
			left join basic.departamento dpto on pro.departamentoid=dpto.departamentoid
			left join basic.empresa_config conf on e.empresaid=conf.empresaid
			left join inventarios.certificadodigital cer on conf.certificadoid=cer.certificadoid
			left join inventarios.firmadigital fir on cer.firmaid=fir.firmaid

			--BILL
			left join webservice.webservice bws1 on conf.bill_wsid =bws1.webserviceid
			left join webservice.webservice bws2 on conf.bill_wsid2=bws2.webserviceid
			left join webservice.webservice bws3 on conf.bill_wsid3=bws3.webserviceid
			left join webservice.usuario busu on conf.bill_usuarioid=busu.usuarioid
			
			--BILL CONSULTING
			left join webservice.webservice bcws on conf.billconsulting_wsid=bcws.webserviceid
			left join webservice.usuario bcusu on conf.billconsulting_usuarioid=bcusu.usuarioid

			left join catalogo.grupo gru on conf.grupoid=gru.grupoid

			left join inventarios.firmador firma on conf.firmadorid=firma.firmadorid

			--WEB SERVICE SUNAT
			left join webservice.webservice wsruc on conf.sunat_wsid_ruc=wsruc.webserviceid
			left join webservice.webservice wsruc_c on conf.sunat_wsid_ruc_captcha=wsruc_c.webserviceid
			left join webservice.webservice wsruc_r_id on conf.sunat_wsid_ruc_randomid=wsruc_r_id.webserviceid
			left join webservice.webservice wsruc_r on conf.sunat_wsid_ruc_random=wsruc_r.webserviceid
			left join webservice.webservice wsruc_p on conf.sunat_wsid_ruc_personal=wsruc_p.webserviceid

			--WEB SERVICE RENIEC
			left join webservice.webservice wsdni on conf.reniec_wsid_dni=wsdni.webserviceid
			left join webservice.webservice wsdni_c on conf.reniec_wsid_dni_captcha=wsdni_c.webserviceid
			left join webservice.webservice wsdni_p on conf.reniec_wsid_dni_personal=wsdni_p.webserviceid

			left join inventarios.firmador wsjar on conf.webservicejarid=wsjar.firmadorid
			left join inventarios.firmador tickjar on conf.ticktesjarid=tickjar.firmadorid
			
			left join basic.servidor sftp on conf.servidorftpid=sftp.servidorid
			left join basic.servidordb sdb on conf.servidorbdid=sdb.servidorid
		order by e.nombre;
END
$$;


ALTER FUNCTION basic.paempresa_leer_sistema() OWNER TO radiosan_ustaana;

--
-- Name: paempresa_tipooperacion_getidstipooperacion(integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_tipooperacion_getidstipooperacion(vempresaid integer, vseperador character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $$
declare vResultado varchar default ''; myRow record; vseperadoraux varchar default '';
BEGIN
	vseperadoraux:=vseperador;
	if(trim(vseperadoraux)='') then
		vseperadoraux=', ';
	end if;
	for myRow in select eto.tipooperacionid from basic.empresa_tipooperacion eto inner join basic.tipooperacion t on eto.tipooperacionid=t.tipooperacionid where eto.empresaid=vempresaid order by t.orden loop
		vResultado:=vResultado || myRow.tipooperacionid || vseperadoraux;
	end loop;
	if trim(vResultado)!='' then
		vResultado:=substring(vResultado, 0, char_length(vResultado)- (char_length(vseperadoraux)-1));
	end if;
	return vResultado;
END
$$;


ALTER FUNCTION basic.paempresa_tipooperacion_getidstipooperacion(vempresaid integer, vseperador character varying) OWNER TO radiosan_ustaana;

--
-- Name: paempresa_tipooperacion_leer(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paempresa_tipooperacion_leer(vempresaid integer) RETURNS SETOF type_empresa_tipooperacion_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select tip.tipooperacionid, tip.nombre, tip.abreviatura, tip.codigo_contable, tip.orden
		from basic.empresa_tipooperacion emptip inner join basic.tipooperacion tip on emptip.tipooperacionid=tip.tipooperacionid
		where emptip.empresaid=vempresaid
		order by tip.orden;
END
$$;


ALTER FUNCTION basic.paempresa_tipooperacion_leer(vempresaid integer) OWNER TO radiosan_ustaana;

--
-- Name: paexists_email(character varying, boolean, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paexists_email(vemail character varying, vmain boolean, vdistinto integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vPersonaId integer default 0;
BEGIN
	if exists(select * from basic.persona_email pe where ismail(pe.email) and trim(upper(buscar(pe.email)))=trim(upper(buscar(vemail))) and (case when vmain then pe.main=true else true end) and pe.personaid!=vdistinto ) then
		select personaid into vPersonaId from basic.persona_email where trim(upper(buscar(email)))=trim(upper(buscar(vemail)));
		
	end if;
	return coalesce(vPersonaId, 0);
END
$$;


ALTER FUNCTION basic.paexists_email(vemail character varying, vmain boolean, vdistinto integer) OWNER TO radiosan_ustaana;

--
-- Name: pagrupo_permisos_actualizar(boolean, integer, character varying, character varying, character varying, boolean); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pagrupo_permisos_actualizar(innew boolean, incodigo integer, inproceso character varying, innombre character varying, indescripcion character varying, inestado boolean) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.grupo_permisos where lower(buscar(trim(proceso)))=lower(buscar(trim(inproceso))) and codigo!=incodigo) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema ha detectado que el proceso ya existe en la base de datos.';
	end if;
	if vState then
		if exists(select * from basic.grupo_permisos where lower(buscar(trim(nombre)))=lower(buscar(trim(innombre))) and codigo!=incodigo) then
			vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema ha detectado que el nombre ya existe en la base de datos.';
		end if;
	end if;
	If vState Then
		If innew Then
			insert into basic.grupo_permisos values(default, inproceso, innombre, indescripcion, basic.pagrupo_permisos_lastorder()+1, inestado);
			vID:=lastval();
		else
			update basic.grupo_permisos set proceso=inproceso, nombre=innombre, descripcion=indescripcion, estado=inestado where codigo=inCodigo;
			vID:=inCodigo;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.pagrupo_permisos_actualizar(innew boolean, incodigo integer, inproceso character varying, innombre character varying, indescripcion character varying, inestado boolean) OWNER TO radiosan_ustaana;

--
-- Name: pagrupo_permisos_change_order(integer[], integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pagrupo_permisos_change_order(myarr integer[], vstart integer) RETURNS void
    LANGUAGE plpgsql
    AS $$
declare myRow record;
BEGIN
	for myRow in select myarr[i] as id, i as orden from generate_series(1, array_upper(myarr, 1)) as i loop
		update basic.grupo_permisos set orden=myRow.orden+(case when vstart>1 then vstart-1 else 0 end) where codigo=myRow.id;
	end loop;
END
$$;


ALTER FUNCTION basic.pagrupo_permisos_change_order(myarr integer[], vstart integer) OWNER TO radiosan_ustaana;

--
-- Name: pagrupo_permisos_eliminar(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pagrupo_permisos_eliminar(incodigo integer) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if vState then
		delete from basic.grupo_permisos_menuweb where codigo=incodigo;
		delete from basic.grupo_permisos where codigo=incodigo;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.pagrupo_permisos_eliminar(incodigo integer) OWNER TO radiosan_ustaana;

--
-- Name: pagrupo_permisos_lastorder(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pagrupo_permisos_lastorder() RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vOrden integer default 0;
BEGIN
	select max(orden) into vOrden from basic.grupo_permisos;
	return coalesce(vOrden, 0);
END
$$;


ALTER FUNCTION basic.pagrupo_permisos_lastorder() OWNER TO radiosan_ustaana;

--
-- Name: pagrupo_permisos_leer(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pagrupo_permisos_leer() RETURNS SETOF type_grupo_permisos_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp cascade;
	create temporary table tmp(type integer not null, codigo integer not null, count integer not null);
	insert into tmp select 1, gpm.codigo, count(*) from basic.grupo_permisos_menuweb gpm inner join basic.menuweb m on gpm.menuwebid=m.menuwebid where m.padre>0 group by 2;
	insert into tmp select 2, gpp.codigo, count(*) from basic.grupo_permisos_persona gpp group by 2;
	
	return query 
		select g.codigo, g.proceso, g.nombre, g.descripcion, g.orden, g.estado, coalesce(tmp_m.count, 0)::integer, coalesce(tmp_p.count, 0)::integer
		from basic.grupo_permisos g left join tmp tmp_m on g.codigo=tmp_m.codigo and 1=tmp_m.type
			left join tmp tmp_p on g.codigo=tmp_p.codigo and 2=tmp_p.type
		order by g.orden, g.nombre;
		
	drop table if exists tmp cascade;
END
$$;


ALTER FUNCTION basic.pagrupo_permisos_leer() OWNER TO radiosan_ustaana;

--
-- Name: pagrupo_permisos_menuweb_leer(integer, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pagrupo_permisos_menuweb_leer(vcodigo integer, vmenuwebid integer) RETURNS SETOF type_grupo_permisos_menuweb_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select opc.codigo, opc.menuwebid
		from basic.grupo_permisos_menuweb opc inner join basic.grupo_permisos g on opc.codigo=g.codigo
		where 1=1
			and case when vcodigo>0 then opc.codigo=vcodigo else true end
			and case when vmenuwebid>0 then opc.menuwebid=vmenuwebid else true end
		order by g.orden, g.codigo;
END
$$;


ALTER FUNCTION basic.pagrupo_permisos_menuweb_leer(vcodigo integer, vmenuwebid integer) OWNER TO radiosan_ustaana;

--
-- Name: pagrupo_permisos_menuweb_registrar(integer, integer[]); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pagrupo_permisos_menuweb_registrar(vcodigo integer, myarr integer[]) RETURNS void
    LANGUAGE plpgsql
    AS $$
begin
	if vCodigo>0 then
		delete from basic.grupo_permisos_menuweb where codigo=vCodigo;
		insert into basic.grupo_permisos_menuweb select vCodigo, myarr[i] from generate_series(1, array_upper(myarr, 1)) as i;
	end if;
end 
$$;


ALTER FUNCTION basic.pagrupo_permisos_menuweb_registrar(vcodigo integer, myarr integer[]) OWNER TO radiosan_ustaana;

--
-- Name: pagrupo_permisos_persona_add(integer, integer[]); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pagrupo_permisos_persona_add(vcodigo integer, inarr integer[]) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	delete from basic.grupo_permisos_persona where codigo=vcodigo and personaid in (select inarr[i] from generate_series(1, array_upper(inarr, 1)) as i);
	insert into basic.grupo_permisos_persona select vcodigo, inarr[i] from generate_series(1, array_upper(inarr, 1)) as i;
END
$$;


ALTER FUNCTION basic.pagrupo_permisos_persona_add(vcodigo integer, inarr integer[]) OWNER TO radiosan_ustaana;

--
-- Name: pagrupo_permisos_persona_add_porpersona(integer, integer[], integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pagrupo_permisos_persona_add_porpersona(vpersonaid integer, myarr integer[], vusuario integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vIDRastro integer default 0;
begin
	drop table if exists tmp cascade;
	create temporary table tmp(tipo varchar(1) not null, codigo integer not null);

	insert into tmp select 'O', p.codigo from basic.grupo_permisos_persona p where personaid=vpersonaid;
	insert into tmp select 'N', myarr[i] from generate_series(1, array_upper(myarr, 1)) as i;

	delete from basic.grupo_permisos_persona where personaid=vpersonaid;
	insert into basic.grupo_permisos_persona select codigo, vpersonaid from tmp where tipo='N';

	--RASTRO
	insert into rastro.grupo_permisos_persona values(default, vpersonaid, vusuario, current_timestamp, vip);
	vIDRastro:=lastval();
	insert into rastro.grupo_permisos_persona_detalle select vIDRastro, tipo, codigo from tmp;

	drop table if exists tmp cascade;
end 
$$;


ALTER FUNCTION basic.pagrupo_permisos_persona_add_porpersona(vpersonaid integer, myarr integer[], vusuario integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: pagrupo_permisos_persona_delete(integer, integer[]); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pagrupo_permisos_persona_delete(vcodigo integer, inarr integer[]) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	delete from basic.grupo_permisos_persona where codigo=vcodigo and personaid in(select inarr[i] from generate_series(1, array_upper(inarr, 1)) as i);
END
$$;


ALTER FUNCTION basic.pagrupo_permisos_persona_delete(vcodigo integer, inarr integer[]) OWNER TO radiosan_ustaana;

--
-- Name: pagrupo_permisos_persona_leer(integer, integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pagrupo_permisos_persona_leer(vfirst integer, vlast integer, vcodigo integer, vnombre character varying) RETURNS SETOF type_grupo_permisos_persona_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select p.personaid, (case when p.tipo='J' then coalesce(pj.raz_soc,'') else (coalesce(pn.ape_pat,'') || ' ' || coalesce(pn.ape_mat,'') || ', ' || coalesce(pn.nombre,'')) end)::varchar, coalesce(pn.sexo, 'M'), p.foto, p.email, p.telefono, p.rol, coalesce(c.usuario, '')::varchar
		from basic.grupo_permisos_persona gpp inner join basic.persona p on gpp.personaid=p.personaid
				left join basic.persona_natural pn on p.personaid=pn.personaid
				left join basic.persona_juridica pj on p.personaid=pj.personaid
			left join basic.clave c on p.personaid=c.personaid
		where gpp.codigo=vcodigo
			and case when trim(upper(vnombre))!='' then 
				(
					upper(buscar(pn.ape_pat)) like ('%' || trim(upper(buscar(vnombre))) || '%') 
					or upper(buscar(pn.ape_pat||' '||pn.ape_mat||' '||pn.nombre)) like ('%' || trim(upper(buscar(vnombre))) || '%')
					or upper(buscar(pn.nombre||' '||pn.ape_pat||' '||pn.ape_mat)) like ('%' || trim(upper(buscar(vnombre))) || '%')
					or trim(cast(p.personaid as varchar)) = trim(upper(buscar(vnombre)))
					or upper(buscar(p.email)) like ('%' || trim(upper(buscar(vnombre))) || '%') 
					or upper(buscar(p.telefono)) like ('%' || trim(upper(buscar(vnombre))) || '%') 
					or upper(buscar(pn.dni)) like ('%' || trim(upper(buscar(vnombre))) || '%')
					or upper(buscar(pn.ruc)) like ('%' || trim(upper(buscar(vnombre))) || '%')
					or upper(buscar(pj.ruc)) like ('%' || trim(upper(buscar(vnombre))) || '%')
					or upper(buscar(pj.raz_soc)) like ('%' || trim(upper(buscar(vnombre))) || '%')
				) 
				else true end
		order by 2
		limit case when vfirst=0 and vlast=0 then null else vlast end offset vfirst;
END
$$;


ALTER FUNCTION basic.pagrupo_permisos_persona_leer(vfirst integer, vlast integer, vcodigo integer, vnombre character varying) OWNER TO radiosan_ustaana;

--
-- Name: pagrupo_permisos_persona_leer_porpersona(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pagrupo_permisos_persona_leer_porpersona(vpersonaid integer) RETURNS SETOF type_grupo_permisos_persona_leer_porpersona
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select g.codigo, g.proceso, g.nombre, g.descripcion
		from basic.grupo_permisos_persona gpp inner join basic.grupo_permisos g on gpp.codigo=g.codigo
		where gpp.personaid=vpersonaid
		order by g.orden, g.nombre;
END
$$;


ALTER FUNCTION basic.pagrupo_permisos_persona_leer_porpersona(vpersonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: palicencia_conducir_actualizar(boolean, integer, integer, integer, date, date, text, character varying, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION palicencia_conducir_actualizar(innew boolean, inlicenciaid integer, inpersonaid integer, incategoriaid integer, inexpedicion date, inrevalidacion date, inrestricciones text, inarchivo character varying, inusuarioid integer, inip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vpersonaid integer default 0; 
BEGIN
	If innew Then
		insert into basic.licencia_conducir values(default, current_timestamp, inpersonaid, incategoriaid, inexpedicion, inrevalidacion, trim(inrestricciones), trim(inarchivo), inusuarioid, trim(inip));
		vID:=lastval();
	else
		update basic.licencia_conducir set categoriaid=incategoriaid, expedicion=inexpedicion, revalidacion=inrevalidacion, restricciones=trim(inrestricciones), archivo=trim(inarchivo) where licenciaid=inlicenciaid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.palicencia_conducir_actualizar(innew boolean, inlicenciaid integer, inpersonaid integer, incategoriaid integer, inexpedicion date, inrevalidacion date, inrestricciones text, inarchivo character varying, inusuarioid integer, inip character varying) OWNER TO radiosan_ustaana;

--
-- Name: palicencia_conducir_eliminar(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION palicencia_conducir_eliminar(vlicenciaid integer, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vPermisoId integer default 0;
BEGIN
	/*
	if basic.papermisos_proceso_getid(vusuario, 'licencia-delete')=0 then
		vPermisoId:=basic.paproceso_getid('licencia-delete');
		vState:=false; vID:=0; vError:=1; vDescripcion:=basic.paproceso_getmensaje(vPermisoId);
		if trim(vDescripcion)='' then
			vDescripcion:='No tiene permisos para realizar este proceso';
		end if;
	end if;
	*/
	if vState then 
		delete from basic.licencia_conducir where licenciaid=vlicenciaid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.palicencia_conducir_eliminar(vlicenciaid integer, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: palicencia_conducir_getrow(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION palicencia_conducir_getrow(vlicenciaid integer) RETURNS SETOF type_licencia_conducir_getrow
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select lic.licenciaid, to_char(lic.registro, 'DD/MM/YYYY HH12:MI AM')::varchar, 
			lic.personaid, (case when per.tipo='J' then pjper.raz_soc else (pnper.ape_pat||' '||pnper.ape_mat||', '||pnper.nombre) end)::varchar, per.foto, coalesce(pnper.sexo, 'M')::varchar,
			lic.categoriaid, cat.nombre, lic.expedicion, lic.revalidacion, lic.restricciones, lic.archivo,
			lic.usuarioid, (case when usu.tipo='J' then pjusu.raz_soc else (pnusu.ape_pat||' '||pnusu.ape_mat||', '||pnusu.nombre) end)::varchar, usu.foto, coalesce(pnusu.sexo, 'M')::varchar, coalesce(cla.usuario,'')::varchar
		from basic.licencia_conducir lic inner join basic.categoria_licencia cat on lic.categoriaid=cat.categoriaid 
			inner join basic.persona per on lic.personaid=per.personaid
				left join basic.persona_natural pnper on per.personaid=pnper.personaid
				left join basic.persona_juridica pjper on per.personaid=pjper.personaid
			inner join basic.persona usu on lic.usuarioid=usu.personaid
				left join basic.persona_natural pnusu on usu.personaid=pnusu.personaid
				left join basic.persona_juridica pjusu on usu.personaid=pjusu.personaid
			left join basic.clave cla on usu.personaid=cla.personaid
		where lic.licenciaid=vlicenciaid;
END
$$;


ALTER FUNCTION basic.palicencia_conducir_getrow(vlicenciaid integer) OWNER TO radiosan_ustaana;

--
-- Name: palicencia_conducir_leer(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION palicencia_conducir_leer(vpersonaid integer) RETURNS SETOF type_licencia_conducir_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select lic.licenciaid, to_char(lic.registro, 'DD/MM/YYYY HH12:MI AM')::varchar, lic.personaid, lic.categoriaid, cat.nombre, lic.expedicion, lic.revalidacion, lic.restricciones, lic.archivo,
			lic.usuarioid, (case when usu.tipo='J' then pjusu.raz_soc else (pnusu.ape_pat||' '||pnusu.ape_mat||', '||pnusu.nombre) end)::varchar, usu.foto, coalesce(pnusu.sexo, 'M')::varchar, coalesce(cla.usuario,'')::varchar
		from basic.licencia_conducir lic inner join basic.categoria_licencia cat on lic.categoriaid=cat.categoriaid 
			inner join basic.persona usu on lic.usuarioid=usu.personaid
				left join basic.persona_natural pnusu on usu.personaid=pnusu.personaid
				left join basic.persona_juridica pjusu on usu.personaid=pjusu.personaid
			left join basic.clave cla on usu.personaid=cla.personaid
		where lic.personaid=vpersonaid order by lic.revalidacion desc;
END
$$;


ALTER FUNCTION basic.palicencia_conducir_leer(vpersonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: pamaquina_actualizar(boolean, integer, integer, character varying, character varying, integer, character varying, integer, integer, integer, integer, boolean); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pamaquina_actualizar(innew boolean, inmaquinaid integer, inalmacenid integer, innombre character varying, inabreviatura character varying, innumero integer, incodigo character varying, inposx integer, inposy integer, infilas integer, incolumnas integer, inestado boolean) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.maquina maq where trim(upper(buscar(maq.nombre)))=trim(upper(buscar(innombre))) and maq.almacenid=inalmacenid and maq.maquinaid!=inmaquinaid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre del maquina ya existe.';
	end if;
	if vState then
		if trim(inabreviatura)!='' then
			if exists(select * from basic.maquina maq where trim(upper(buscar(maq.abreviatura)))=trim(upper(buscar(inabreviatura))) and maq.almacenid=inalmacenid and maq.maquinaid!=inmaquinaid) then
				vState:=false; vID:=0; vError:=1; vDescripcion:='La abreviatura del maquina ya existe.';
			end if;
		end if;
	end if;
	if vState then
		if innumero>0 then
			if exists(select * from basic.maquina maq where maq.numero=innumero and maq.almacenid=inalmacenid and maq.maquinaid!=inmaquinaid) then
				vState:=false; vID:=0; vError:=1; vDescripcion:='La numero del maquina ya existe.';
			end if;
		end if;
	end if;
	if vstate then
		if exists(select * from basic.maquina maq where maq.posy=inposy and maq.posx=inposx and maq.almacenid=inalmacenid and maq.maquinaid!=inmaquinaid) then
			vState:=false; vID:=0; vError:=1; vDescripcion:='La posición "XY" ya existe.';
		end if;
	end if;
	If vState Then
		If innew Then
			insert into basic.maquina values(default, inalmacenid, trim(innombre), trim(inabreviatura), innumero, trim(incodigo), inposx, inposy, infilas, incolumnas, inestado);
			vID:=lastval();
		Else
			update basic.maquina set nombre=trim(innombre), abreviatura=trim(inabreviatura), numero=innumero, codigo=trim(incodigo), posx=inposx, posy=inposy, filas=infilas, columnas=incolumnas, estado=inestado where maquinaid=inmaquinaid;
			vID:=inmaquinaid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.pamaquina_actualizar(innew boolean, inmaquinaid integer, inalmacenid integer, innombre character varying, inabreviatura character varying, innumero integer, incodigo character varying, inposx integer, inposy integer, infilas integer, incolumnas integer, inestado boolean) OWNER TO radiosan_ustaana;

--
-- Name: pamaquina_cambiar_estado(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pamaquina_cambiar_estado(vmaquinaid integer, vusuario integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vEstadoOld boolean default false;
BEGIN
	if vState then
		if exists(select * from basic.maquina where maquinaid=vmaquinaid) then
			--RASTRO
			select estado into vEstadoOld from basic.maquina where maquinaid=vmaquinaid;
			insert into rastro.campo values(default, 'basic', 'maquina', 'estado', 'B', vmaquinaid, 0, 0, vEstadoOld::varchar, (not vEstadoOld)::varchar, current_timestamp, vusuario, vip, 1, 0);
			
			update basic.maquina set estado=not estado where maquinaid=vmaquinaid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.pamaquina_cambiar_estado(vmaquinaid integer, vusuario integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: pamaquina_eliminar(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pamaquina_eliminar(vmaquinaid integer, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.surtidor where maquinaid=vmaquinaid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar el maquina por tener surtidores relacionados.';
	end if;
	if vState then
		delete from basic.maquina where maquinaid=vmaquinaid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.pamaquina_eliminar(vmaquinaid integer, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: pamaquina_getrow(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pamaquina_getrow(vmaquinaid integer) RETURNS SETOF type_maquina_getrow
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query
		select maq.maquinaid, alm.zonaid, zon.nombre, maq.almacenid, alm.nombre, maq.nombre, maq.abreviatura, maq.numero, maq.codigo, 
			maq.posx, maq.posy, maq.filas, maq.columnas, maq.estado
		from basic.maquina maq inner join basic.almacen alm on maq.almacenid=alm.almacenid
			inner join basic.zona zon on alm.zonaid=zon.zonaid
		where maq.maquinaid=vmaquinaid;
END
$$;


ALTER FUNCTION basic.pamaquina_getrow(vmaquinaid integer) OWNER TO radiosan_ustaana;

--
-- Name: pamaquina_leer(integer, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pamaquina_leer(vzonaid integer, valmacenid integer) RETURNS SETOF type_maquina_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query
		select maq.maquinaid, alm.zonaid, zon.nombre, zon.abreviatura, maq.almacenid, alm.nombre, alm.abreviatura,
			maq.nombre, maq.abreviatura, maq.numero, maq.codigo, maq.posx, maq.posy, maq.filas, maq.columnas, maq.estado
		from basic.maquina maq inner join basic.almacen alm on maq.almacenid=alm.almacenid
			inner join basic.zona zon on alm.zonaid=zon.zonaid
		where maq.maquinaid>0
			and case when vzonaid>0 then alm.zonaid=vzonaid else true end
			and case when valmacenid>0 then maq.almacenid=valmacenid else true end
		order by zon.orden, alm.nombre, maq.nombre;
END
$$;


ALTER FUNCTION basic.pamaquina_leer(vzonaid integer, valmacenid integer) OWNER TO radiosan_ustaana;

--
-- Name: pamarca_change_order(integer[], integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pamarca_change_order(myarr integer[], vstart integer) RETURNS void
    LANGUAGE plpgsql
    AS $$
declare myRow record;
BEGIN
	for myRow in select myarr[i] as id, i as orden from generate_series(1, array_upper(myarr, 1)) as i loop
		update basic.marca set orden=myRow.orden+(case when vstart>1 then vstart-1 else 0 end) where marcaid=myRow.id;
	end loop;
END
$$;


ALTER FUNCTION basic.pamarca_change_order(myarr integer[], vstart integer) OWNER TO radiosan_ustaana;

--
-- Name: pamenuweb_actualizar(boolean, integer, character varying, character varying, character varying, character varying, character varying, integer, boolean); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pamenuweb_actualizar(innew boolean, inmenuwebid integer, inproceso character varying, intitulo character varying, indescripcion character varying, inlink character varying, inimagen character varying, inpadre integer, inestado boolean) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if trim(inproceso)!='' then
		if exists(select * from basic.menuweb where buscar(trim(upper(proceso)))=buscar(trim(upper(inproceso))) and menuwebid!=inmenuwebid) then
			vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema ha detectado que el nombre del proceso ya existe.';
		end if;
	end if;
	If vState Then
		If inNew Then
			insert into basic.menuweb values(default, inproceso, intitulo, indescripcion, inlink, basic.pamenuweb_ultimo_orden(inpadre)+1, inimagen, inpadre, inestado);
			vID:=lastval();
		Else
			update basic.menuweb set proceso=inproceso, titulo=intitulo, descripcion=indescripcion, link=inlink, padre=inpadre, estado=inestado where menuwebid=inmenuwebid;
			vID:=inmenuwebid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.pamenuweb_actualizar(innew boolean, inmenuwebid integer, inproceso character varying, intitulo character varying, indescripcion character varying, inlink character varying, inimagen character varying, inpadre integer, inestado boolean) OWNER TO radiosan_ustaana;

--
-- Name: pamenuweb_cambiar_orden(integer, integer[]); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pamenuweb_cambiar_orden(vpadre integer, myarr integer[]) RETURNS void
    LANGUAGE plpgsql
    AS $$
declare myRow record;
BEGIN
	for myRow in select myarr[i] as id, i as orden from generate_series(1, array_upper(myarr, 1)) as i loop
		update basic.menuweb set orden=myRow.orden where menuwebid=myRow.id;
	end loop;
END
$$;


ALTER FUNCTION basic.pamenuweb_cambiar_orden(vpadre integer, myarr integer[]) OWNER TO radiosan_ustaana;

--
-- Name: pamenuweb_eliminar(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pamenuweb_eliminar(inmenuwebid integer) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if vState then
		delete from basic.menuweb_persona_rastro where menuwebid=inmenuwebid;
		delete from basic.grupo_permisos_menuweb where menuwebid=inmenuwebid;
		delete from basic.permisos_menuweb where menuwebid=inmenuwebid;
		delete from basic.menuweb_favoritos where menuwebid=inmenuwebid;
		delete from basic.menuweb where menuwebid=inmenuwebid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.pamenuweb_eliminar(inmenuwebid integer) OWNER TO radiosan_ustaana;

--
-- Name: pamenuweb_favoritos_registrar(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pamenuweb_favoritos_registrar(inpersonaid integer, inmenuwebid integer, inip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vLink varchar default '';
BEGIN
	if not exists(select * from basic.menuweb_favoritos where personaid=inpersonaid and menuwebid=inmenuwebid) then
		insert into basic.menuweb_favoritos values(inpersonaid, inmenuwebid, 1);
	else 
		update basic.menuweb_favoritos set contador=contador+1 where personaid=inpersonaid and menuwebid=inmenuwebid;
	end if;
	select link into vLink from basic.menuweb where menuwebid=inmenuwebid;
	vLink:=coalesce(vLink, '');
	insert into basic.menuweb_persona_rastro values(default, inpersonaid, inmenuwebid, current_date, current_time, inip, vLink);

	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.pamenuweb_favoritos_registrar(inpersonaid integer, inmenuwebid integer, inip character varying) OWNER TO radiosan_ustaana;

--
-- Name: pamenuweb_getrow(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pamenuweb_getrow(vmenuwebid integer) RETURNS SETOF type_menuweb_getrow
    LANGUAGE plpgsql
    AS $$
declare vCount integer default 0;
BEGIN
	select count(*) into vCount from basic.menuweb m where padre=vmenuwebid;
	
	return query 
		select m.menuwebid, m.proceso, m.titulo, m.descripcion, m.link, m.orden, m.imagen, m.padre, coalesce(mp.titulo,'')::varchar, coalesce(mp.descripcion, '')::varchar, m.estado, coalesce(vCount, 0)::integer
		from basic.menuweb m left join basic.menuweb mp on m.padre=mp.menuwebid
		where m.menuwebid=vmenuwebid;
END
$$;


ALTER FUNCTION basic.pamenuweb_getrow(vmenuwebid integer) OWNER TO radiosan_ustaana;

--
-- Name: pamenuweb_leer(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pamenuweb_leer(vpadre integer) RETURNS SETOF type_menuweb_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp cascade;
	create temporary table tmp (type integer not null, menuwebid integer not null, cantidad integer not null);
	insert into tmp select 1, m.padre, count(*) from basic.menuweb m  group by 2;
	insert into tmp select 2, m.menuwebid, count(*) from basic.permisos_menuweb m  group by 2;

	return query 
		select m.menuwebid, m.titulo, m.descripcion, m.proceso, m.link, m.orden, m.imagen, m.padre, m.estado , coalesce(tmp_hij.cantidad, 0)::integer, coalesce(tmp_men.cantidad, 0)::integer
		from basic.menuweb m left join tmp tmp_hij on m.menuwebid=tmp_hij.menuwebid and 1=tmp_hij.type
			left join tmp tmp_men on m.menuwebid=tmp_men.menuwebid and 2=tmp_men.type
		where 1=1
			and case when vpadre>=0 then m.padre=vpadre else true end
		order by m.padre, m.orden;
		
	drop table if exists tmp cascade;
END
$$;


ALTER FUNCTION basic.pamenuweb_leer(vpadre integer) OWNER TO radiosan_ustaana;

--
-- Name: pamenuweb_leer_favoritos(integer, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pamenuweb_leer_favoritos(vpersonaid integer, vpadre integer) RETURNS SETOF type_menuweb_leer_favoritos
    LANGUAGE plpgsql
    AS $$
declare vUsuario varchar default '';
BEGIN
	select usuario into vUsuario from basic.clave where personaid=vpersonaid;
	vUsuario:=coalesce(vUsuario, '');
	if vUsuario=superusuario() then
		return query 
			select m.menuwebid, m.titulo, m.descripcion, m.link, m.orden, m.imagen, m.padre, mp.titulo
			from basic.menuweb_favoritos mwf
				inner join basic.menuweb m on mwf.menuwebid=m.menuwebid
				left join basic.menuweb mp on m.padre=mp.menuwebid
			where mwf.personaid=vpersonaid and m.estado=true and mp.estado=true 
				and case when vpadre>0 then m.padre=vpadre else true end
			order by mwf.contador desc, m.padre, m.orden
			limit 10;
	else
		drop table if exists tmp_aux, tmp cascade;
		create temporary table tmp_aux(menuwebid integer not null, contador integer not null);
		create temporary table tmp(menuwebid integer not null, contador integer not null);
		insert into tmp_aux select per.menuwebid, sum(mwf.contador) from basic.menuweb_favoritos mwf inner join basic.permisos_menuweb per on mwf.personaid=per.personaid and mwf.menuwebid=per.menuwebid inner join basic.menuweb men on per.menuwebid=men.menuwebid where per.personaid=vpersonaid and men.estado=true and case when vpadre>0 then men.padre=vpadre else true end group by 1;
		insert into tmp_aux select per.menuwebid, sum(mwf.contador) from basic.grupo_permisos_persona gpp inner join basic.grupo_permisos_menuweb per on gpp.codigo=per.codigo inner join basic.menuweb men on per.menuwebid=men.menuwebid inner join basic.menuweb_favoritos mwf on gpp.personaid=mwf.personaid and men.menuwebid=mwf.menuwebid where gpp.personaid=vpersonaid and men.estado=true and case when vpadre>0 then men.padre=vpadre else true end group by 1;
		insert into tmp select menuwebid, sum(contador) from tmp_aux group by 1;
		
		return query 
			select m.menuwebid, m.titulo, m.descripcion, m.link, m.orden, m.imagen, m.padre, mp.titulo
			from tmp inner join basic.menuweb m on tmp.menuwebid=m.menuwebid
				left join basic.menuweb mp on m.padre=mp.menuwebid
			where m.estado=true and mp.estado=true 
				and case when vpadre>0 then m.padre=vpadre else true end
			order by tmp.contador desc, m.padre, m.orden
			limit 10;

		drop table if exists tmp_aux, tmp cascade;
	end if;
END
$$;


ALTER FUNCTION basic.pamenuweb_leer_favoritos(vpersonaid integer, vpadre integer) OWNER TO radiosan_ustaana;

--
-- Name: pamenuweb_leer_hijos(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pamenuweb_leer_hijos(vpadre integer) RETURNS SETOF type_menuweb_leer_hijos
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp;
	create temporary table tmp(menuwebid integer not null, cantidad integer not null);
	insert into tmp select m.padre, count(*) from basic.menuweb m group by 1;
	return query 
		select m.menuwebid, m.titulo, m.descripcion, m.proceso, m.link, m.orden, m.imagen, m.padre , coalesce(tmp.cantidad, 0)::integer
		from basic.menuweb m left join tmp on m.menuwebid=tmp.menuwebid
		where 1=1
			and case when vpadre>0 then m.padre=vpadre else true end
		order by m.padre, m.orden
	;
	drop table if exists tmp;
END
$$;


ALTER FUNCTION basic.pamenuweb_leer_hijos(vpadre integer) OWNER TO radiosan_ustaana;

--
-- Name: pamenuweb_leer_padres(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pamenuweb_leer_padres() RETURNS SETOF type_menuweb_leer_padres
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp;
	create temporary table tmp (menuwebid integer not null, cantidad integer not null);
	insert into tmp select m.padre, count(*) from basic.menuweb m group by 1;
	return query 
		select m.menuwebid, m.titulo, m.descripcion, m.link, m.orden, m.imagen, m.padre , coalesce(tmp.cantidad, 0)::integer
		from basic.menuweb m left join tmp on m.menuwebid=tmp.menuwebid
		where m.padre=0
		order by m.orden
	;
	drop table if exists tmp;
END
$$;


ALTER FUNCTION basic.pamenuweb_leer_padres() OWNER TO radiosan_ustaana;

--
-- Name: pamenuweb_query_hijos(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pamenuweb_query_hijos(vpadre integer) RETURNS SETOF type_menuweb_query_hijos
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select m.menuwebid, m.titulo, m.descripcion, m.link, m.orden, m.imagen, m.padre 
		from basic.menuweb m
		where m.estado=true
			and case when vpadre>0 then m.padre=vpadre else true end
		order by m.padre, m.orden;
END
$$;


ALTER FUNCTION basic.pamenuweb_query_hijos(vpadre integer) OWNER TO radiosan_ustaana;

--
-- Name: pamenuweb_query_padres(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pamenuweb_query_padres() RETURNS SETOF type_menuweb_query_padres
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select m.menuwebid, m.titulo, m.descripcion, m.link, m.orden, m.imagen, m.padre
		from basic.menuweb m
		where m.padre=0 and m.estado=true
		order by m.orden;
END
$$;


ALTER FUNCTION basic.pamenuweb_query_padres() OWNER TO radiosan_ustaana;

--
-- Name: pamenuweb_rastro_count(integer, integer, character varying, character varying, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pamenuweb_rastro_count(vpersonaid integer, vmenuwebid integer, vdesde character varying, vhasta character varying, vtexto character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vCount integer default 0;
BEGIN
	select count(*) into vCount
	from basic.menuweb_persona_rastro r inner join basic.menuweb m on r.menuwebid=m.menuwebid
		inner join basic.persona usu on r.personaid=usu.personaid
			left join basic.persona_natural pnusu on usu.personaid=pnusu.personaid
			left join basic.persona_juridica pjusu on usu.personaid=pjusu.personaid
		left join basic.clave c on usu.personaid=c.personaid
	where 1=1
		and case when vpersonaid>0 then r.personaid=vpersonaid else true end
		and case when vmenuwebid>0 then r.menuwebid=vmenuwebid else true end
		and case when trim(vdesde)!='' then r.fecha>=cast(vdesde as date) else true end
		and case when trim(vhasta)!='' then r.fecha<=cast(vhasta as date) else true end

		and case when trim(vtexto)!='' then (
			upper(buscar(c.usuario)) like upper(buscar('%'||vtexto||'%'))   
			or upper(buscar(m.link)) like upper(buscar('%'||vtexto||'%'))   
			or upper(buscar(pnusu.ape_pat)) like upper(buscar('%'||vtexto||'%'))  
			or upper(buscar(pnusu.ape_mat)) like upper(buscar('%'||vtexto||'%')) 
			or upper(buscar(pnusu.nombre)) like upper(buscar('%'||vtexto||'%')) 
			or upper(buscar(pnusu.ape_pat||' '||pnusu.ape_mat||' '||pnusu.nombre)) like upper(buscar('%'||vtexto||'%'))  ) else true end;
	return coalesce(vCount, 0);
END
$$;


ALTER FUNCTION basic.pamenuweb_rastro_count(vpersonaid integer, vmenuwebid integer, vdesde character varying, vhasta character varying, vtexto character varying) OWNER TO radiosan_ustaana;

--
-- Name: pamenuweb_rastro_leer(integer, integer, integer, integer, character varying, character varying, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pamenuweb_rastro_leer(vinicio integer, vfin integer, vpersonaid integer, vmenuwebid integer, vdesde character varying, vhasta character varying, vtexto character varying) RETURNS SETOF type_menuweb_rastro_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select r.codigo, r.fecha, to_char(r.hora, 'HH12:MI AM')::varchar, 
			r.personaid, (case when usu.tipo='J' then coalesce(pjusu.raz_soc,'') else (coalesce(pnusu.ape_pat,'') || ' ' || coalesce(pnusu.ape_mat,'') || ', ' || coalesce(pnusu.nombre,'')) end)::varchar, c.usuario,
			r.menuwebid, m.titulo, m.link, r.ip, r.web
		from basic.menuweb_persona_rastro r inner join basic.menuweb m on r.menuwebid=m.menuwebid
			inner join basic.persona usu on r.personaid=usu.personaid
				left join basic.persona_natural pnusu on usu.personaid=pnusu.personaid
				left join basic.persona_juridica pjusu on usu.personaid=pjusu.personaid
			left join basic.clave c on usu.personaid=c.personaid
		where 1=1
			and case when vpersonaid>0 then r.personaid=vpersonaid else true end
			and case when vmenuwebid>0 then r.menuwebid=vmenuwebid else true end
			and case when trim(vdesde)!='' then r.fecha>=cast(vdesde as date) else true end
			and case when trim(vhasta)!='' then r.fecha<=cast(vhasta as date) else true end

			and case when trim(vtexto)!='' then (
				upper(buscar(c.usuario)) like upper(buscar('%'||vtexto||'%'))   
				or upper(buscar(m.link)) like upper(buscar('%'||vtexto||'%'))   
				or upper(buscar(pnusu.ape_pat)) like upper(buscar('%'||vtexto||'%'))  
				or upper(buscar(pnusu.ape_mat)) like upper(buscar('%'||vtexto||'%')) 
				or upper(buscar(pnusu.nombre)) like upper(buscar('%'||vtexto||'%')) 
				or upper(buscar(pnusu.ape_pat||' '||pnusu.ape_mat||' '||pnusu.nombre)) like upper(buscar('%'||vtexto||'%'))  ) else true end

		order by r.fecha desc, r.hora desc
		limit case when vinicio=0 and vfin=0 then null else vfin end offset vinicio;
END
$$;


ALTER FUNCTION basic.pamenuweb_rastro_leer(vinicio integer, vfin integer, vpersonaid integer, vmenuwebid integer, vdesde character varying, vhasta character varying, vtexto character varying) OWNER TO radiosan_ustaana;

--
-- Name: pamenuweb_ultimo_orden(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pamenuweb_ultimo_orden(vpadre integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vOrden integer default 0;
BEGIN
	select max(orden) into vOrden
	from basic.menuweb m
	where 1=1
		and case when vpadre>0 then m.padre=vpadre else m.padre=0 end
	;
	return coalesce(vOrden, 0);
END
$$;


ALTER FUNCTION basic.pamenuweb_ultimo_orden(vpadre integer) OWNER TO radiosan_ustaana;

--
-- Name: pamodulo_sistema_getid(character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pamodulo_sistema_getid(vreferencia character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vmoduloid integer default 0;
BEGIN
	select codigo into vmoduloid from basic.modulo_sistema m where trim(upper(m.referencia))=upper(trim(vreferencia));
	return coalesce(vmoduloid, 0);
END
$$;


ALTER FUNCTION basic.pamodulo_sistema_getid(vreferencia character varying) OWNER TO radiosan_ustaana;

SET default_tablespace = '';

SET default_with_oids = false;

--
-- Name: modulo_sistema; Type: TABLE; Schema: basic; Owner: radiosan_ustaana; Tablespace: 
--

CREATE TABLE modulo_sistema (
    codigo integer NOT NULL,
    nombre character varying(50) NOT NULL,
    descripcion character varying(250) NOT NULL,
    referencia character varying(10) NOT NULL,
    orden integer NOT NULL
);


ALTER TABLE basic.modulo_sistema OWNER TO radiosan_ustaana;

--
-- Name: pamodulo_sistema_leer(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pamodulo_sistema_leer() RETURNS SETOF modulo_sistema
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select * from basic.modulo_sistema m order by m.orden, 1
	;
END
$$;


ALTER FUNCTION basic.pamodulo_sistema_leer() OWNER TO radiosan_ustaana;

--
-- Name: pamulticursor(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pamulticursor() RETURNS SETOF refcursor
    LANGUAGE plpgsql
    AS $$
declare alm refcursor; emp refcursor;
BEGIN
    	
	open alm FOR	
		select * from basic.almacen;
	RETURN NEXT alm;

	open emp FOR	
		select * from basic.empresa;
	RETURN NEXT emp;

	RETURN;
	
END;$$;


ALTER FUNCTION basic.pamulticursor() OWNER TO radiosan_ustaana;

--
-- Name: paopciones_seleccion_actualizar(boolean, integer, character varying, character varying, boolean, integer[]); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paopciones_seleccion_actualizar(innew boolean, incodigo integer, inproceso character varying, indescripcion character varying, inestado boolean, inarrrol integer[]) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vIndice integer default 0; vFilas integer default 0; vProceso integer default 0;
BEGIN
	if exists(select * from basic.opciones_seleccion o where buscar(trim(upper(o.proceso)))=buscar(trim(upper(inproceso))) and o.codigo!=incodigo) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre del proceso ya existe en la base de datos';
	end if;
	If vState Then
		If inNew Then
			insert into basic.opciones_seleccion values(default, trim(inproceso), trim(indescripcion), inestado);
			vID:=lastval();
		Else
			update basic.opciones_seleccion set proceso=trim(inproceso), descripcion=trim(indescripcion), estado=inestado where codigo=incodigo;
			vID:=inCodigo;
		end if;
		delete from basic.opciones_seleccion_rol where codigo=vID;
		insert into basic.opciones_seleccion_rol select vID, inarrrol[i] from generate_series(1, array_upper(inarrrol, 1)) as i;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paopciones_seleccion_actualizar(innew boolean, incodigo integer, inproceso character varying, indescripcion character varying, inestado boolean, inarrrol integer[]) OWNER TO radiosan_ustaana;

--
-- Name: paopciones_seleccion_eliminar(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paopciones_seleccion_eliminar(incodigo integer) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if vState then
		delete from basic.opciones_seleccion_rol where codigo=incodigo;
		delete from basic.opciones_seleccion where codigo=incodigo;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paopciones_seleccion_eliminar(incodigo integer) OWNER TO radiosan_ustaana;

--
-- Name: paopciones_seleccion_leer(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paopciones_seleccion_leer(vinicio integer, vfin integer, vnombre character varying) RETURNS SETOF type_opciones_seleccion_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select os.codigo, os.proceso, os.descripcion, os.estado
		from basic.opciones_seleccion  os
		where 1=1
		order by os.proceso;
END
$$;


ALTER FUNCTION basic.paopciones_seleccion_leer(vinicio integer, vfin integer, vnombre character varying) OWNER TO radiosan_ustaana;

--
-- Name: paopciones_seleccion_leer_rol(character varying, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paopciones_seleccion_leer_rol(vproceso character varying, vcodigo integer) RETURNS SETOF type_opciones_seleccion_leer_rol
    LANGUAGE plpgsql
    AS $$
BEGIN
	if trim(vproceso)!='' or vcodigo>0 then
		return query 
			select distinct r.rolid, r.nombre, r.estructura, r.tipo, r.pordefecto
			from basic.opciones_seleccion_rol osr inner join basic.rol r on osr.rolid=r.rolid
				inner join basic.opciones_seleccion os on osr.codigo=os.codigo
			where 1=1
				and case when vproceso!='' then os.proceso=vproceso else true end
				and case when vcodigo>0 then osr.codigo=vcodigo else true end
			order by 2;
	end if;
END
$$;


ALTER FUNCTION basic.paopciones_seleccion_leer_rol(vproceso character varying, vcodigo integer) OWNER TO radiosan_ustaana;

--
-- Name: papais_actualizar(boolean, integer, character varying, character varying, character varying, boolean); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papais_actualizar(innew boolean, inpaisid integer, innombre character varying, inabreviatura character varying, inubigeo character varying, inestado boolean) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.pais p where trim(upper(buscar(p.nombre)))=trim(upper(buscar(innombre))) and p.paisid!=inpaisid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre ya existe en la base de datos';
	end if;
	if vState then
		if trim(inubigeo)!='' then
			if exists(select * from basic.pais p where trim(upper(buscar(p.ubigeo)))=trim(upper(buscar(inubigeo))) and p.paisid!=inpaisid) then
				vState:=false; vID:=0; vError:=1; vDescripcion:='El ubigeo ya existe en la base de datos';
			end if;
		end if;
	end if;
	If vState Then
		If inNew Then
			insert into basic.pais values(default, trim(innombre), trim(inabreviatura), trim(inubigeo), inestado);
			vID:=lastval();
		Else
			update basic.pais set nombre=trim(innombre), abreviatura=trim(inabreviatura), ubigeo=trim(inubigeo), estado=inestado where paisid=inpaisid;
			vID:=inpaisid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.papais_actualizar(innew boolean, inpaisid integer, innombre character varying, inabreviatura character varying, inubigeo character varying, inestado boolean) OWNER TO radiosan_ustaana;

--
-- Name: papais_eliminar(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papais_eliminar(inpaisid integer) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.departamento d where d.paisid=inpaisid limit 1) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar el pais por tener departamentos relacionados.';
	end if;
	if vState then
		delete from basic.pais where paisid=inpaisid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.papais_eliminar(inpaisid integer) OWNER TO radiosan_ustaana;

--
-- Name: papais_leer(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papais_leer() RETURNS SETOF type_pais_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select p.paisid, p.nombre, p.abreviatura, p.ubigeo, p.estado 
		from basic.pais p order by 2;
END
$$;


ALTER FUNCTION basic.papais_leer() OWNER TO radiosan_ustaana;

--
-- Name: papermisos_caja_leer(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_caja_leer(vpersonaid integer) RETURNS SETOF type_permisos_caja_leer
    LANGUAGE plpgsql
    AS $$
begin

	return query
		select pc.personaid, pc.cajaid, c.nombre, c.abreviatura
		from basic.permisos_caja pc inner join tesoreria.caja c on pc.cajaid=c.cajaid
		where pc.personaid=vpersonaid
		order by c.nombre;
end 
$$;


ALTER FUNCTION basic.papermisos_caja_leer(vpersonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_caja_leer_cajas(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_caja_leer_cajas(vpersonaid integer) RETURNS SETOF type_permisos_caja_leer_cajas
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select caj.cajaid, caj.nombre, caj.abreviatura
		from basic.permisos_caja pc inner join tesoreria.caja caj on pc.cajaid=caj.cajaid
		where pc.personaid=vpersonaid;
END
$$;


ALTER FUNCTION basic.papermisos_caja_leer_cajas(vpersonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_caja_registrar(integer, integer[], integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_caja_registrar(vpersonaid integer, myarr integer[], vusuarioid integer, vip character varying) RETURNS void
    LANGUAGE plpgsql
    AS $$
declare vIndice integer default 0; vFilas integer default 0; vidrastro integer default 0;
begin
	drop table if exists tmp, tmp_rastro cascade;
	create temporary table tmp(cajaid integer not null);
	create temporary table tmp_rastro(tipo varchar(1) not null, cajaid integer not null);

	vFilas=array_upper(myArr,1);
	delete from basic.permisos_caja where personaid=vpersonaid;
	insert into tmp select myarr[i] from generate_series(1, array_upper(myarr, 1)) as i;

	insert into tmp_rastro select 'O', p.cajaid from basic.permisos_caja p where personaid=vpersonaid;
	insert into tmp_rastro select 'N', cajaid from tmp;

	delete from basic.permisos_caja where personaid=vpersonaid;
	insert into basic.permisos_caja select vpersonaid, cajaid from tmp_rastro where tipo='N';

	--RASTRO
	vidrastro:=nextval('rastro.permisos_caja_codigo_seq');
	insert into rastro.permisos_caja values(vidrastro, vpersonaid, vusuarioid, current_timestamp, vip);
	insert into rastro.permisos_caja_detalle select vidrastro, tipo, cajaid from tmp_rastro;
	
	drop table if exists tmp, tmp_rastro cascade;
end 
$$;


ALTER FUNCTION basic.papermisos_caja_registrar(vpersonaid integer, myarr integer[], vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_ctacte_leer_cajas(integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_ctacte_leer_cajas(vpersonaid integer, vempresa character varying) RETURNS SETOF type_permisos_ctacte_leer_cajas
    LANGUAGE plpgsql
    AS $$
BEGIN
	/*
	return query 
		select percc.ctacteid, cc.numero, cc.empresa, cc.empresaid, cc.almacenid
		from basic.permisos_ctacte percc inner join basic.ctacte cc on percc.ctacteid=cc.ctacteid
		where percc.personaid=vpersonaid
			and case when trim(vempresa)!='' then cc.empresa=(trim(vempresa)='S') else true end
		order by case when cc.empresa then 0 else 1 end, 2;
	*/
END
$$;


ALTER FUNCTION basic.papermisos_ctacte_leer_cajas(vpersonaid integer, vempresa character varying) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_empresa_eliminar(integer, integer, integer[], integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_empresa_eliminar(vempresaid integer, vmodulosistemaid integer, myarr integer[], vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	delete from basic.permisos_empresa where empresaid=vempresaid and moduloid=vmodulosistemaid and personaid in(select myarr[i] from generate_series(1, array_upper(myarr, 1)) as i);
END
$$;


ALTER FUNCTION basic.papermisos_empresa_eliminar(vempresaid integer, vmodulosistemaid integer, myarr integer[], vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_empresa_leer(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_empresa_leer(vpersonaid integer) RETURNS SETOF type_permisos_empresa_leer
    LANGUAGE plpgsql
    AS $$
begin

	return query
		select pm.personaid, pm.empresaid, e.nombre, pm.moduloid, ms.nombre
		from basic.permisos_empresa pm inner join basic.empresa e on pm.empresaid=e.empresaid
			inner join basic.modulo_sistema ms on pm.moduloid=ms.codigo
		where pm.personaid=vpersonaid
		order by 3,5;
end 
$$;


ALTER FUNCTION basic.papermisos_empresa_leer(vpersonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_empresa_leer_empresas(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_empresa_leer_empresas(vpersonaid integer) RETURNS SETOF type_permisos_empresa_leer_empresas
    LANGUAGE plpgsql
    AS $$
begin
	drop table if exists tmp cascade;
	create temporary table tmp(empresaid integer not null);

	insert into tmp select pm.empresaid from basic.permisos_empresa pm where pm.personaid=vpersonaid group by 1;
	
	return query
		select e.empresaid, e.nombre, e.ruc
		from tmp inner join basic.empresa e on tmp.empresaid=e.empresaid
		order by e.empresaid;
		
	drop table if exists tmp cascade;
end 
$$;


ALTER FUNCTION basic.papermisos_empresa_leer_empresas(vpersonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_empresa_leer_personas(integer, integer, integer, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_empresa_leer_personas(vfirst integer, vlast integer, vempresaid integer, vmodulosistemaid integer) RETURNS SETOF type_permisos_empresa_leer_personas
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp_personas, tmp_visitas cascade;
	create temporary table tmp_personas(personaid integer not null);
	create temporary table tmp_visitas(personaid integer not null, cantidad integer not null, ultima_visita timestamp not null);
	
	insert into tmp_personas select pp.personaid from basic.permisos_empresa pp where pp.empresaid=vempresaid and pp.moduloid=vmodulosistemaid group by 1;

	insert into tmp_visitas
		select v.personaid, count(*), max(v.fechaintento)::timestamp
		from tmp_personas tmp inner join basic.visita_intranet v on tmp.personaid=v.personaid
		where v.intranet='CORP' and v.exito=true group by 1;
	
	return query 
		select tmp.personaid, (case when per.tipo='J' then coalesce(pj.raz_soc,'') else (coalesce(pn.ape_pat,'') || ' ' || coalesce(pn.ape_mat,'') || ', ' || coalesce(pn.nombre,'')) end)::varchar,
			per.direccion, per.telefono, per.foto, coalesce(pn.sexo,'M')::varchar, per.rol, coalesce(c.usuario,'')::varchar, coalesce(c.tipo_cambio, '')::varchar,
			(case when not c.personaid is null then (case when c.renovar_clave then 'S' else 'N' end) else '' end)::varchar,
			coalesce(tmp_vis.cantidad, 0)::integer, case when tmp_vis.personaid is null then '' else to_char(tmp_vis.ultima_visita, 'DD/MM/YYYY HH12:MI:SS AM')::varchar end
		from tmp_personas tmp inner join basic.persona per on tmp.personaid=per.personaid
				left join basic.persona_natural pn on per.personaid=pn.personaid
				left join basic.persona_juridica pj on per.personaid=pj.personaid
			left join basic.clave c on per.personaid=c.personaid
			left join tmp_visitas tmp_vis on tmp.personaid=tmp_vis.personaid
		order by 2
		limit case when vfirst=0 and vlast=0 then null else vlast end offset vfirst;

	drop table if exists tmp_personas, tmp_visitas cascade;
END
$$;


ALTER FUNCTION basic.papermisos_empresa_leer_personas(vfirst integer, vlast integer, vempresaid integer, vmodulosistemaid integer) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_empresa_leer_resumen(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_empresa_leer_resumen() RETURNS SETOF type_permisos_empresa_leer_resumen
    LANGUAGE plpgsql
    AS $$
begin
	drop table if exists tmp cascade;
	create temporary table tmp(modulosistemaid integer not null, empresaid integer not null, cantidad integer not null);
	insert into tmp select p.moduloid, p.empresaid, count(*) from basic.permisos_empresa p group by 1, 2;
	
	return query
		select tmp.modulosistemaid, ms.nombre, tmp.empresaid, emp.nombre, tmp.cantidad
		from tmp inner join basic.empresa emp on tmp.empresaid=emp.empresaid
			inner join basic.modulo_sistema ms on tmp.modulosistemaid=ms.codigo
		order by 1, 3;
		
	drop table if exists tmp cascade;
end 
$$;


ALTER FUNCTION basic.papermisos_empresa_leer_resumen() OWNER TO radiosan_ustaana;

--
-- Name: papermisos_empresa_registrar(integer, integer[], integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_empresa_registrar(vpersonaid integer, myarr integer[], vusuarioid integer, vip character varying) RETURNS void
    LANGUAGE plpgsql
    AS $$
declare vIndice integer default 0; vFilas integer default 0; vidrastro integer default 0;
begin
	drop table if exists tmp, tmp_rastro cascade;
	create temporary table tmp(modulosistemaid integer not null, empresaid integer not null);
	create temporary table tmp_rastro(tipo varchar(1) not null, modulosistemaid integer not null, empresaid integer not null);

	vFilas=array_upper(myArr,1);
	delete from basic.permisos_empresa where personaid=vpersonaid;
	if (not (myArr[1][1] is null)) then
		vIndice:=0;
		if vFilas>0 then
			for vIndice in 1..vFilas loop
				insert into tmp values(myArr[vIndice][1]::integer, myArr[vIndice][2]::integer);
			end loop;
		end if;
	end if;

	insert into tmp_rastro select 'O', p.moduloid, p.empresaid from basic.permisos_empresa p where personaid=vpersonaid;
	insert into tmp_rastro select 'N', modulosistemaid, empresaid from tmp;

	delete from basic.permisos_empresa where personaid=vpersonaid;
	insert into basic.permisos_empresa select vpersonaid, modulosistemaid, empresaid from tmp_rastro where tipo='N';

	--RASTRO
	insert into rastro.permisos_empresa values(default, vpersonaid, vusuarioid, current_timestamp, vip);
	vidrastro:=lastval();
	insert into rastro.permisos_empresa_detalle select vidrastro, tipo, modulosistemaid, empresaid from tmp_rastro;
	
	drop table if exists tmp, tmp_rastro cascade;
end 
$$;


ALTER FUNCTION basic.papermisos_empresa_registrar(vpersonaid integer, myarr integer[], vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_menu_web_incluir_grupo(boolean, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_menu_web_incluir_grupo(vincluir boolean, vusuarioid integer, vgrupo character varying) RETURNS void
    LANGUAGE plpgsql
    AS $$
declare vIndice integer default 0; vFilas integer default 0; vMenu integer default 0;
begin
	drop table if exists tmp cascade;
	create temporary table tmp(menuwebid integer not null, padre integer not null);
	insert into tmp select o.menuwebid, m.padre from basic.grupo_permisos_menuweb o inner join basic.menuweb m on o.menuwebid=m.menuwebid inner join basic.grupo_permisos g on o.codigo=g.codigo where trim(lower(g.proceso))=trim(lower(vgrupo));

	delete from basic.permisos_menuweb where personaid=vusuarioid and menuwebid in (select menuwebid from tmp where padre>0);
	if vincluir then
		insert into basic.permisos_menuweb select vusuarioid, menuwebid from tmp where menuwebid not in (select menuwebid from basic.permisos_menuweb where personaid=vusuarioid );
	end if;
	drop table if exists tmp cascade;
end 
$$;


ALTER FUNCTION basic.papermisos_menu_web_incluir_grupo(vincluir boolean, vusuarioid integer, vgrupo character varying) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_menu_window_leer_cursor(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_menu_window_leer_cursor(vusuarioid integer) RETURNS SETOF refcursor
    LANGUAGE plpgsql
    AS $$
DECLARE   
    myRow record;
    myRowP record;
    dtmenu	refcursor;
    dtmodulos	refcursor;
    dtotros	refcursor;
	


BEGIN   

	drop table if exists tmp_pmn;
	drop table if exists tmp_ap;
	drop table if exists tmp_o;
	
	create temporary table tmp_pmn(menuwindowid integer);	

	create temporary table tmp_ap(codigo integer, nombre varchar, padre integer, sel boolean);
	
	create temporary table tmp_o(codigo integer, nombre varchar, padre integer, sel boolean);

	
	insert into tmp_pmn
		select pmw.menuwindowid
		from basic.permisos_menuwindow pmw 
		where pmw.personaid=vusuarioid
		order by 1;
						
	
	for myRow in select almacenid, nombre from inventarios.almacen order by unidadnegocioid,1 loop
		insert into tmp_ap values (myRow.almacenid, myRow.nombre, 0, false);
		
		insert into tmp_ap
			select ms.codigo, ms.nombre, myRow.almacenid, (case when coalesce(pa.almacenid,0)>0 then true else false end)::boolean
			from basic.modulo_sistema ms left join basic.permisos_almacen pa on pa.moduloid=ms.codigo 
							and pa.almacenid=myRow.almacenid and pa.personaid=vusuarioid
			order by ms.codigo;			
	end loop;	


	for myRowP in select tipoprocesoid, nombre from basic.tipo_proceso order by orden loop
		insert into tmp_o values (myRowP.tipoprocesoid, myRowP.nombre, 0, false);
		
		insert into tmp_o
			select pro.procesoid, pro.descripcion, myRowP.tipoprocesoid, (case when coalesce(per.procesoid,0)>0 then true else false end)::boolean
			from basic.proceso pro left join basic.permisos_proceso per on per.procesoid=pro.procesoid and per.personaid=vusuarioid 
			where pro.tipoprocesoid=myRowP.tipoprocesoid
			order by pro.tipoprocesoid, pro.orden;			
	end loop;
		
	open dtmenu FOR
		select mw.menuwindowid, titulo, padre, (case when coalesce(t.menuwindowid,0)>0 then true else false end)::boolean
		from basic.menuwindow mw left join tmp_pmn t on mw.menuwindowid=t.menuwindowid
		order by mw.padre,orden;
	RETURN NEXT dtmenu;
		
	open dtmodulos FOR
		select codigo, nombre, padre, sel
		from tmp_ap ;
	RETURN NEXT dtmodulos;

	open dtotros FOR
		select codigo, nombre, padre, sel
		from tmp_o;
	RETURN NEXT dtotros;
		
	RETURN;
	
END;$$;


ALTER FUNCTION basic.papermisos_menu_window_leer_cursor(vusuarioid integer) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_menuweb_eliminar(integer, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_menuweb_eliminar(vmenuwebid integer, vpersonaid integer) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if vState then
		delete from basic.permisos_menuweb where menuwebid=vMenuWebId and personaid=vPersonaId;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.papermisos_menuweb_eliminar(vmenuwebid integer, vpersonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_menuweb_leer_hijos(integer, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_menuweb_leer_hijos(vusuarioid integer, vpadre integer) RETURNS SETOF type_permisos_menuweb_leer_hijos
    LANGUAGE plpgsql
    AS $$
declare vAdmin boolean default false;
BEGIN
	vAdmin:=(basic.papersona_getusuario(vusuarioid, 'sistema')=public.superusuario());
	raise notice 'Es admin: %',case when vAdmin then 'SI' else 'NO' END;
	if vAdmin then
		return query
			select m.menuwebid, m.titulo, m.descripcion, m.link, m.imagen, m.padre 
			from basic.menuweb m left join basic.menuweb mp on m.padre=mp.menuwebid
			where m.estado=true and coalesce(mp.estado, false)=true 
				and case when vpadre>0 then m.padre=vpadre else true end
			order by coalesce(mp.orden, 0), m.orden;
	else 
		drop table if exists tmp_aux, tmp cascade;
		create temporary table tmp_aux(menuwebid integer not null);
		create temporary table tmp(menuwebid integer not null);
		insert into tmp_aux select per.menuwebid from basic.permisos_menuweb per inner join basic.menuweb men on per.menuwebid=men.menuwebid where per.personaid=vusuarioid and (case when vpadre>0 then men.padre=vpadre when vpadre=0 then men.padre>0 else true end) and men.estado=true group by 1;
		insert into tmp_aux select per.menuwebid from basic.grupo_permisos_persona gpp inner join basic.grupo_permisos_menuweb per on gpp.codigo=per.codigo inner join basic.menuweb men on per.menuwebid=men.menuwebid where gpp.personaid=vusuarioid and (case when vpadre>0 then men.padre=vpadre when vpadre=0 then men.padre>0 else true end) and men.estado=true group by 1;
		insert into tmp select menuwebid from tmp_aux group by 1;
		
		return query 
			select men.menuwebid, men.titulo, men.descripcion, men.link, men.imagen, men.padre
			from tmp inner join basic.menuweb men on tmp.menuwebid=men.menuwebid
				left join basic.menuweb mp on men.padre=mp.menuwebid
			where men.estado=true and coalesce(mp.estado, false)=true 
			order by coalesce(mp.orden, 0), men.orden;

		drop table if exists tmp_aux, tmp cascade;
	end if;
END
$$;


ALTER FUNCTION basic.papermisos_menuweb_leer_hijos(vusuarioid integer, vpadre integer) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_menuweb_leer_padre(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_menuweb_leer_padre(vusuarioid integer) RETURNS SETOF type_permisos_menuweb_leer_padre
    LANGUAGE plpgsql
    AS $$
declare vAdmin boolean default false;
BEGIN
	vAdmin:=(basic.papersona_getusuario(vusuarioid, 'sistema')=public.superusuario());
	raise notice 'Es admin: %',case when vAdmin then 'SI' else 'NO' END;
	if vAdmin then
		return query 
			select m.menuwebid, m.titulo, m.descripcion, m.link, m.imagen, m.padre
			from basic.menuweb m
			where m.padre=0 and m.estado=true
			order by m.orden
		;
	else
		drop table if exists tmp_aux, tmp cascade;
		create temporary table tmp_aux(menuwebid integer not null);
		create temporary table tmp(menuwebid integer not null);
		insert into tmp_aux select per.menuwebid from basic.permisos_menuweb per inner join basic.menuweb men on per.menuwebid=men.menuwebid where per.personaid=vusuarioid and men.padre=0 and men.estado=true group by 1;
		insert into tmp_aux select per.menuwebid from basic.grupo_permisos_persona gpp inner join basic.grupo_permisos_menuweb per on gpp.codigo=per.codigo inner join basic.menuweb men on per.menuwebid=men.menuwebid where gpp.personaid=vusuarioid and men.padre=0 and men.estado=true group by 1;
		insert into tmp select menuwebid from tmp_aux group by 1;
		
		return query 
			select men.menuwebid, men.titulo, men.descripcion, men.link, men.imagen, men.padre
			from tmp inner join basic.menuweb men on tmp.menuwebid=men.menuwebid
			where men.padre=0 and men.estado=true
			order by men.orden;
		drop table if exists tmp_aux, tmp cascade;
	end if;
END
$$;


ALTER FUNCTION basic.papermisos_menuweb_leer_padre(vusuarioid integer) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_menuweb_leer_personas(integer, integer, integer[]); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_menuweb_leer_personas(vfirst integer, vlast integer, myarr integer[]) RETURNS SETOF type_permisos_menuweb_leer_personas
    LANGUAGE plpgsql
    AS $$
declare vIndice integer default 0; vFilas integer default 0;
BEGIN
	drop table if exists tmp_menu, tmp_personas, tmp_visitas cascade;
	create temporary table tmp_menu(menuwebid integer not null);
	create temporary table tmp_personas(personaid integer primary key);
	create temporary table tmp_visitas(personaid integer not null, cantidad integer not null, ultima_visita timestamp not null);

	vFilas=array_upper(myArr,1);
	if (not (myArr[1] is null)) then
		insert into tmp_menu select myArr[i] from generate_series(1, array_upper(myArr, 1)) as i;
	else
		insert into tmp_menu select menuwebid from basic.permisos_menuweb group by 1;
	end if;
	
	insert into tmp_personas 
		select pm.personaid 
		from tmp_menu tmp inner join basic.permisos_menuweb pm on tmp.menuwebid=pm.menuwebid
	group by 1;

	insert into tmp_visitas
		select v.personaid, count(*), max(v.fechaintento)::timestamp
		from tmp_personas tmp inner join basic.visita_intranet v on tmp.personaid=v.personaid
		where v.intranet='CORP' and v.exito=true
		group by 1;

	return query 
		select tmp.personaid, (case when per.tipo='J' then coalesce(pj.raz_soc,'') else (coalesce(pn.ape_pat,'') || ' ' || coalesce(pn.ape_mat,'') || ', ' || coalesce(pn.nombre,'')) end)::varchar,
			per.direccion, per.telefono, per.foto, coalesce(pn.sexo,'M')::varchar, per.rol, coalesce(c.usuario,'')::varchar, coalesce(c.tipo_cambio, '')::varchar,
			(case when not c.personaid is null then (case when c.renovar_clave then 'S' else 'N' end) else '' end)::varchar,
			coalesce(tmp_vis.cantidad, 0)::integer, case when tmp_vis.personaid is null then '' else to_char(tmp_vis.ultima_visita, 'DD/MM/YYYY HH12:MI:SS AM')::varchar end
		from tmp_personas tmp inner join basic.persona per on tmp.personaid=per.personaid
				left join basic.persona_natural pn on per.personaid=pn.personaid
				left join basic.persona_juridica pj on per.personaid=pj.personaid
			left join basic.clave c on per.personaid=c.personaid
			left join tmp_visitas tmp_vis on tmp.personaid=tmp_vis.personaid
		order by 2
		limit case when vfirst=0 and vlast=0 then null else vlast end offset vfirst
	;
	drop table if exists tmp_menu, tmp_personas cascade;	
END
$$;


ALTER FUNCTION basic.papermisos_menuweb_leer_personas(vfirst integer, vlast integer, myarr integer[]) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_menuweb_registrar(integer, integer[], integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_menuweb_registrar(vpersonaid integer, myarr integer[], vusuarioid integer, vip character varying) RETURNS void
    LANGUAGE plpgsql
    AS $$
declare vIndice integer default 0; vFilas integer default 0; vMenuWebId integer default 0;
begin
	delete from basic.permisos_menuweb where personaid=vpersonaid;
	vFilas=array_upper(myArr,1);
	if (not (myArr[1] is null)) then
		vIndice:=0;
		if vFilas>0 then
			for vIndice in 1..vFilas loop
				vMenuWebId:=case when myArr[vIndice] is null then 0 else myArr[vIndice]::integer end;
				if vMenuWebId>0 and vpersonaid>0 then
					insert into basic.permisos_menuweb values(vpersonaid, vMenuWebId);
				end if;
			end loop;
		end if;
	end if;
end 
$$;


ALTER FUNCTION basic.papermisos_menuweb_registrar(vpersonaid integer, myarr integer[], vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_menuweb_tiene_permiso(integer, character varying[]); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_menuweb_tiene_permiso(vpersonaid integer, arrprocesos character varying[]) RETURNS boolean
    LANGUAGE plpgsql
    AS $$
declare vResultado boolean default false;
BEGIN
	vResultado=exists(select * from basic.permisos_menuweb per inner join basic.menuweb men on per.menuwebid=men.menuwebid where per.personaid=vpersonaid and men.proceso in (select arrProcesos[i] from generate_series(1, array_upper(arrProcesos, 1)) as i) );
	return vResultado;
END
$$;


ALTER FUNCTION basic.papermisos_menuweb_tiene_permiso(vpersonaid integer, arrprocesos character varying[]) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_menuwindow_registrar(integer, integer[], integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_menuwindow_registrar(vpersonaid integer, myarr integer[], vusuarioid integer, vip character varying) RETURNS void
    LANGUAGE plpgsql
    AS $$
declare vIndice integer default 0; vFilas integer default 0; vMenuWindowId integer default 0;
begin
	delete from basic.permisos_menuwindow where personaid=vpersonaid;
	vFilas=array_upper(myArr,1);
	if (not (myArr[1] is null)) then
		vIndice:=0;
		if vFilas>0 then
			for vIndice in 1..vFilas loop
				vMenuWindowId:=case when myArr[vIndice] is null then 0 else myArr[vIndice]::integer end;
				if vMenuWindowId>0 and vpersonaid>0 then
					insert into basic.permisos_menuwindow values(vpersonaid, vMenuWindowId);
				end if;
			end loop;
		end if;
	end if;
end 
$$;


ALTER FUNCTION basic.papermisos_menuwindow_registrar(vpersonaid integer, myarr integer[], vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_modulo_actualizar(boolean, integer, integer, integer, boolean, boolean); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_modulo_actualizar(innew boolean, inpersonaid integer, inalmacenid integer, inmoduloid integer, incerrar_new boolean, incerrar_update boolean) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if innew then
		if exists(select * from basic.permisos_modulo where personaid=inpersonaid and almacenid=inalmacenid and modulosistemaid=inmoduloid) then
			vState:=false; vID:=0; vError:=1; vDescripcion:='Ya existe un permiso similar en la base de datos.';
		end if;
	end if;
	if vState then
		If innew Then
			insert into basic.permisos_modulo values(inpersonaid, inalmacenid, inmoduloid, incerrar_new, incerrar_update);
		else
			update basic.permisos_modulo set cerrar_new=incerrar_new, cerrar_update=incerrar_update where personaid=inpersonaid and almacenid=inalmacenid and modulosistemaid=inmoduloid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.papermisos_modulo_actualizar(innew boolean, inpersonaid integer, inalmacenid integer, inmoduloid integer, incerrar_new boolean, incerrar_update boolean) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_modulo_almacenes(integer, integer, integer, integer, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_modulo_almacenes(vempresaid integer, vpersonaid integer, vmodulosistemaid integer, vzonaid integer, valmacenid integer) RETURNS SETOF type_permisos_modulo_almacenes
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp cascade;
	create temporary table tmp(almacenid integer not null);
	insert into tmp 
		select pm.almacenid
		from basic.permisos_modulo pm
		where pm.personaid=vpersonaid and pm.almacenid in (select ea.almacenid from basic.empresa_almacen ea where ea.empresaid=vempresaid)
			and case when vmodulosistemaid>0 then pm.modulosistemaid=vmodulosistemaid else true end
		group by 1;

	return query
		select a.almacenid, a.nombre, a.abreviatura, a.zonaid, z.nombre, a.unidadnegocioid, un.nombre
		from tmp inner join basic.almacen a on tmp.almacenid=a.almacenid
			inner join basic.zona z on a.zonaid=z.zonaid
			inner join basic.unidad_negocio un on a.unidadnegocioid=un.unidadnegocioid
		where 1=1
			and case when vzonaid>0 then a.zonaid=vzonaid else true end
			and case when valmacenid>0 then a.almacenid=valmacenid else true end
		order by z.orden, a.nombre;
END
$$;


ALTER FUNCTION basic.papermisos_modulo_almacenes(vempresaid integer, vpersonaid integer, vmodulosistemaid integer, vzonaid integer, valmacenid integer) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_modulo_eliminar(integer, integer, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_modulo_eliminar(vpersonaid integer, valmacenid integer, vmodulosistemaid integer) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if vState=true then
		delete from basic.permisos_modulo where personaid=vpersonaid and almacenid=valmacenid and modulosistemaid=vmodulosistemaid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.papermisos_modulo_eliminar(vpersonaid integer, valmacenid integer, vmodulosistemaid integer) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_modulo_eliminar(integer, integer, integer[], integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_modulo_eliminar(valmacenid integer, vmodulosistemaid integer, myarr integer[], vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	delete from basic.permisos_modulo where almacenid=valmacenid and modulosistemaid=vmodulosistemaid and personaid in(select myarr[i] from generate_series(1, array_upper(myarr, 1)) as i);
END
$$;


ALTER FUNCTION basic.papermisos_modulo_eliminar(valmacenid integer, vmodulosistemaid integer, myarr integer[], vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_modulo_leer(integer, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_modulo_leer(vpersonaid integer, valmacenid integer) RETURNS SETOF type_permisos_modulo_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select pm.personaid, pm.almacenid, a.nombre, pm.modulosistemaid, m.nombre, pm.cerrar_new, pm.cerrar_update
		from basic.permisos_modulo pm inner join basic.persona per on pm.personaid=per.personaid
				left join basic.persona_natural pn on per.personaid=pn.personaid
				left join basic.persona_juridica pj on per.personaid=pj.personaid
			inner join basic.almacen a on pm.almacenid=a.almacenid 
			inner join basic.modulo_sistema m on pm.modulosistemaid=m.codigo
		where pm.personaid=vpersonaid
			and case when valmacenid>0 then pm.almacenid=valmacenid else true end
		order by 3, 5;
END
$$;


ALTER FUNCTION basic.papermisos_modulo_leer(vpersonaid integer, valmacenid integer) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_modulo_leer_almacenes(integer, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_modulo_leer_almacenes(vpersonaid integer, vmodulosistemaid integer) RETURNS SETOF type_permisos_modulo_leer_almacenes
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query
		select a.almacenid, a.nombre, pm.modulosistemaid, m.nombre, a.unidadnegocioid, un.nombre, un.empresaid, e.nombre, e.ruc
		from basic.permisos_modulo pm inner join basic.almacen a on pm.almacenid=a.almacenid
			inner join basic.zona z on a.zonaid=z.zonaid
			inner join basic.unidad_negocio un on a.unidadnegocioid=un.unidadnegocioid
			inner join basic.empresa e on un.empresaid=e.empresaid
			inner join basic.modulo_sistema m on pm.modulosistemaid=m.codigo
		where pm.personaid=vpersonaid
			and case when vmodulosistemaid>0 then pm.modulosistemaid=vmodulosistemaid else true end
		order by m.nombre, z.orden, a.nombre;
END
$$;


ALTER FUNCTION basic.papermisos_modulo_leer_almacenes(vpersonaid integer, vmodulosistemaid integer) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_modulo_leer_personas(integer, integer, integer, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_modulo_leer_personas(vfirst integer, vlast integer, valmacenid integer, vmodulosistemaid integer) RETURNS SETOF type_permisos_modulo_leer_personas
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp_personas, tmp_visitas cascade;
	create temporary table tmp_personas(personaid integer not null);
	create temporary table tmp_visitas(personaid integer not null, cantidad integer not null, ultima_visita timestamp not null);
	
	insert into tmp_personas select pp.personaid from basic.permisos_modulo pp where pp.almacenid=valmacenid and pp.modulosistemaid=vmodulosistemaid group by 1;

	insert into tmp_visitas
		select v.personaid, count(*), max(v.fechaintento)::timestamp
		from tmp_personas tmp inner join basic.visita_intranet v on tmp.personaid=v.personaid
		where v.intranet='CORP' and v.exito=true group by 1;
	
	return query 
		select tmp.personaid, (case when per.tipo='J' then coalesce(pj.raz_soc,'') else (coalesce(pn.ape_pat,'') || ' ' || coalesce(pn.ape_mat,'') || ', ' || coalesce(pn.nombre,'')) end)::varchar,
			per.direccion, per.telefono, per.foto, coalesce(pn.sexo,'M')::varchar, per.rol, coalesce(c.usuario,'')::varchar, coalesce(c.tipo_cambio, '')::varchar,
			(case when not c.personaid is null then (case when c.renovar_clave then 'S' else 'N' end) else '' end)::varchar,
			coalesce(tmp_vis.cantidad, 0)::integer, case when tmp_vis.personaid is null then '' else to_char(tmp_vis.ultima_visita, 'DD/MM/YYYY HH12:MI:SS AM')::varchar end
		from tmp_personas tmp inner join basic.persona per on tmp.personaid=per.personaid
				left join basic.persona_natural pn on per.personaid=pn.personaid
				left join basic.persona_juridica pj on per.personaid=pj.personaid
			left join basic.clave c on per.personaid=c.personaid
			left join tmp_visitas tmp_vis on tmp.personaid=tmp_vis.personaid
		order by 2
		limit case when vfirst=0 and vlast=0 then null else vlast end offset vfirst;

	drop table if exists tmp_personas, tmp_visitas cascade;
END
$$;


ALTER FUNCTION basic.papermisos_modulo_leer_personas(vfirst integer, vlast integer, valmacenid integer, vmodulosistemaid integer) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_modulo_leer_resumen(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_modulo_leer_resumen() RETURNS SETOF type_permisos_modulo_leer_resumen
    LANGUAGE plpgsql
    AS $$
begin
	drop table if exists tmp cascade;
	create temporary table tmp(modulosistemaid integer not null, almacenid integer not null, cantidad integer not null);
	insert into tmp select p.modulosistemaid, p.almacenid, count(*) from basic.permisos_modulo p group by 1, 2;
	
	return query
		select tmp.modulosistemaid, ms.nombre, tmp.almacenid, alm.nombre, tmp.cantidad
		from tmp inner join basic.almacen alm on tmp.almacenid=alm.almacenid
			inner join basic.modulo_sistema ms on tmp.modulosistemaid=ms.codigo
		order by 1, 3;
		
	drop table if exists tmp cascade;
end 
$$;


ALTER FUNCTION basic.papermisos_modulo_leer_resumen() OWNER TO radiosan_ustaana;

--
-- Name: papermisos_modulo_obtener_opcion_cerrado(integer, integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_modulo_obtener_opcion_cerrado(vmodulosistemaid integer, valmacenid integer, vpersonaid integer, vopcion character varying) RETURNS boolean
    LANGUAGE plpgsql
    AS $$
declare vPermiso boolean default true; 
BEGIN
	if vpersonaid>0 then
		if exists (select * from basic.permisos_modulo where personaid=vpersonaid and almacenid=valmacenid and modulosistemaid=vmodulosistemaid) then
			select case when vOpcion='NEW' then cerrar_new when vOpcion='UPDATE' then cerrar_update else false end  into vPermiso
			from basic.permisos_modulo where personaid=vpersonaid and almacenid=valmacenid and modulosistemaid=vmodulosistemaid;
		end if;
	end if;
	return vPermiso;
END
$$;


ALTER FUNCTION basic.papermisos_modulo_obtener_opcion_cerrado(vmodulosistemaid integer, valmacenid integer, vpersonaid integer, vopcion character varying) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_modulo_registrar(integer, integer[], integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_modulo_registrar(vpersonaid integer, myarr integer[], vusuarioid integer, vip character varying) RETURNS void
    LANGUAGE plpgsql
    AS $$
declare vIndice integer default 0; vFilas integer default 0; vidrastro integer default 0;
begin
	drop table if exists tmp, tmp_rastro cascade;
	create temporary table tmp(almacenid integer not null, modulosistemaid integer not null);
	create temporary table tmp_rastro(tipo varchar(1) not null, almacenid integer not null, modulosistemaid integer not null);

	vFilas=array_upper(myArr,1);
	delete from basic.permisos_modulo where personaid=vpersonaid;
	if (not (myArr[1][1] is null)) then
		vIndice:=0;
		if vFilas>0 then
			for vIndice in 1..vFilas loop
				insert into tmp values(myArr[vIndice][1]::integer, myArr[vIndice][2]::integer);
			end loop;
		end if;
	end if;

	insert into tmp_rastro select 'O', p.almacenid, p.modulosistemaid from basic.permisos_modulo p where personaid=vpersonaid;
	insert into tmp_rastro select 'N', almacenid, modulosistemaid from tmp;

	delete from basic.permisos_modulo where personaid=vpersonaid;
	insert into basic.permisos_modulo select vpersonaid, almacenid, modulosistemaid, true, true from tmp_rastro where tipo='N';

	--RASTRO
	insert into rastro.permisos_modulo values(default, vpersonaid, vusuarioid, current_timestamp, vip);
	vidrastro:=lastval();
	insert into rastro.permisos_modulo_detalle select vidrastro, tipo, almacenid, modulosistemaid from tmp_rastro;
	
	drop table if exists tmp, tmp_rastro cascade;
end 
$$;


ALTER FUNCTION basic.papermisos_modulo_registrar(vpersonaid integer, myarr integer[], vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_modulo_zonas(integer, integer, integer, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_modulo_zonas(vempresaid integer, vpersonaid integer, vmodulosistemaid integer, vzonaid integer) RETURNS SETOF type_permisos_modulo_zonas
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp cascade;
	create temporary table tmp(zonaid integer not null, count integer not null);
	insert into tmp 
		select alm.zonaid, count(distinct pm.almacenid)
		from basic.permisos_modulo pm inner join basic.almacen alm on pm.almacenid=alm.almacenid
		where pm.personaid=vpersonaid and pm.almacenid in (select ea.almacenid from basic.empresa_almacen ea where ea.empresaid=vempresaid)
			and case when vmodulosistemaid>0 then pm.modulosistemaid=vmodulosistemaid else true end
		group by 1;

	return query
		select z.zonaid, z.nombre, z.abreviatura, tmp.count
		from tmp inner join basic.zona z on tmp.zonaid=z.zonaid
		where 1=1
			and case when vzonaid>0 then z.zonaid=vzonaid else true end
		order by z.orden;
	drop table if exists tmp cascade;
END
$$;


ALTER FUNCTION basic.papermisos_modulo_zonas(vempresaid integer, vpersonaid integer, vmodulosistemaid integer, vzonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_proceso_eliminar(integer, integer[], integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_proceso_eliminar(vprocesoid integer, myarr integer[], vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	delete from basic.permisos_proceso where procesoid=vprocesoid and personaid in(select myarr[i] from generate_series(1, array_upper(myarr, 1)) as i);
END
$$;


ALTER FUNCTION basic.papermisos_proceso_eliminar(vprocesoid integer, myarr integer[], vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_proceso_getid(integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_proceso_getid(vpersonaid integer, vreferencia character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vProcesoId integer default 0;
BEGIN
	select pro.procesoid into vProcesoId from basic.permisos_proceso per inner join basic.proceso pro on per.procesoid=pro.procesoid where per.personaid=vpersonaid and trim(upper(buscar(pro.nombre)))=trim(upper(buscar(vreferencia))) limit 1;
	return coalesce(vProcesoId, 0);
END
$$;


ALTER FUNCTION basic.papermisos_proceso_getid(vpersonaid integer, vreferencia character varying) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_proceso_leer(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_proceso_leer(vpersonaid integer) RETURNS SETOF type_permisos_proceso_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select pro.procesoid, pro.nombre, pro.descripcion, pro.mensaje
		from basic.permisos_proceso per inner join basic.proceso pro on per.procesoid=pro.procesoid
		where per.personaid=vpersonaid and pro.estado=true
		order by pro.orden
	;
END
$$;


ALTER FUNCTION basic.papermisos_proceso_leer(vpersonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_proceso_leer_personas(integer, integer, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_proceso_leer_personas(vfirst integer, vlast integer, vprocesoid integer) RETURNS SETOF type_permisos_proceso_leer_personas
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp_personas, tmp_visitas cascade;
	create temporary table tmp_personas(personaid integer not null);
	create temporary table tmp_visitas(personaid integer not null, cantidad integer not null, ultima_visita timestamp not null);

	insert into tmp_personas select pp.personaid from basic.permisos_proceso pp where pp.procesoid=vprocesoid group by 1;

	insert into tmp_visitas
		select v.personaid, count(*), max(v.fechaintento)::timestamp
		from tmp_personas tmp inner join basic.visita_intranet v on tmp.personaid=v.personaid
		where v.intranet='CORP' and v.exito=true group by 1;
	
	return query 
		select tmp.personaid, (case when per.tipo='J' then coalesce(pj.raz_soc,'') else (coalesce(pn.ape_pat,'') || ' ' || coalesce(pn.ape_mat,'') || ', ' || coalesce(pn.nombre,'')) end)::varchar,
			per.direccion, per.telefono, per.foto, coalesce(pn.sexo,'M')::varchar, per.rol, coalesce(c.usuario,'')::varchar, coalesce(c.tipo_cambio, '')::varchar,
			(case when not c.personaid is null then (case when c.renovar_clave then 'S' else 'N' end) else '' end)::varchar,
			coalesce(tmp_vis.cantidad, 0)::integer, case when tmp_vis.personaid is null then '' else to_char(tmp_vis.ultima_visita, 'DD/MM/YYYY HH12:MI:SS AM')::varchar end
		from tmp_personas tmp inner join basic.persona per on tmp.personaid=per.personaid
				left join basic.persona_natural pn on per.personaid=pn.personaid
				left join basic.persona_juridica pj on per.personaid=pj.personaid
			left join basic.clave c on per.personaid=c.personaid
			left join tmp_visitas tmp_vis on tmp.personaid=tmp_vis.personaid
		order by 2
		limit case when vfirst=0 and vlast=0 then null else vlast end offset vfirst;

	drop table if exists tmp_personas, tmp_visitas cascade;
END
$$;


ALTER FUNCTION basic.papermisos_proceso_leer_personas(vfirst integer, vlast integer, vprocesoid integer) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_proceso_registrar(integer, integer[], integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_proceso_registrar(vpersonaid integer, myarr integer[], vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vidrastro integer default 0;
begin
	drop table if exists tmp cascade;
	create temporary table tmp(tipo varchar(1) not null, procesoid integer not null);

	insert into tmp select 'O', p.procesoid from basic.permisos_proceso p where personaid=vpersonaid;
	insert into tmp select 'N', myarr[i] from generate_series(1, array_upper(myarr, 1)) as i;
	
	delete from basic.permisos_proceso where personaid=vpersonaid;
	insert into basic.permisos_proceso select vpersonaid, procesoid from tmp where tipo='N';

	--RASTRO
	insert into rastro.permisos_proceso values(default, vpersonaid, vusuarioid, current_timestamp, vip);
	vidrastro:=lastval();
	insert into rastro.permisos_proceso_detalle select vidrastro, tipo, procesoid from tmp;
	
	drop table if exists tmp cascade;
end 
$$;


ALTER FUNCTION basic.papermisos_proceso_registrar(vpersonaid integer, myarr integer[], vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_unidad_negocio_leer(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_unidad_negocio_leer(vpersonaid integer) RETURNS SETOF type_permisos_unidad_negocio_leer
    LANGUAGE plpgsql
    AS $$
begin

	return query
		select pm.personaid, pm.unidadnegocioid, un.nombre, pm.moduloid, ms.nombre
		from basic.permisos_unidad_negocio pm inner join basic.unidad_negocio un on pm.unidadnegocioid=un.unidadnegocioid
			inner join basic.modulo_sistema ms on pm.moduloid=ms.codigo
		where pm.personaid=vpersonaid
		order by 3,5
	;
end 
$$;


ALTER FUNCTION basic.papermisos_unidad_negocio_leer(vpersonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: papermisos_unidad_negocio_registrar(integer, integer[], integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papermisos_unidad_negocio_registrar(vpersonaid integer, myarr integer[], vusuario integer, vip character varying) RETURNS void
    LANGUAGE plpgsql
    AS $$
declare vIndice integer default 0; vFilas integer default 0;
begin
	vFilas=array_upper(myArr,1);
	delete from basic.permisos_unidad_negocio where personaid=vpersonaid;
	if (not (myArr[1][1] is null)) then
		vIndice:=0;
		if vFilas>0 then
			for vIndice in 1..vFilas loop
				insert into basic.permisos_unidad_negocio values(vpersonaid, myArr[vIndice][1]::integer, myArr[vIndice][2]::integer);
			end loop;
		end if;
	end if;
end 
$$;


ALTER FUNCTION basic.papermisos_unidad_negocio_registrar(vpersonaid integer, myarr integer[], vusuario integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: papersona_actualizar(boolean, integer, character, character varying, character varying, character varying, character varying, character varying, character varying, character, character, date, character varying, character varying, character varying, character varying, integer, character varying, character varying[], character varying[], character varying[], integer[], integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_actualizar(innew boolean, inpersonaid integer, intipo character, intitulo character varying, inape_pat character varying, inape_mat character varying, innombre character varying, indni character varying, inpernat_ruc character varying, insexo character, inest_civil character, innacimiento date, inraz_soc character varying, inruc character varying, indireccion character varying, innombre_comercial character varying, indistritoid integer, inlicencia character varying, inarrphone character varying[], inarremail character varying[], inarrsocialmedia character varying[], inarrrol integer[], inusuarioid integer, inip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vTipoPersona varchar default ''; vUsuario varchar default ''; vCodigoPerAux integer default 0;
	vIndice integer default 0; vFilas integer default 0; vIDOther integer default 0;
	vIDRastro integer default 0;
	vPermisoNombre varchar default ''; vPermisoId integer default 0;
BEGIN
	if innew then
		vPermisoNombre:='persona-add';
	else
		vPermisoNombre:='persona-edit';
	end if;
	if basic.papermisos_proceso_getid(inusuarioid, vPermisoNombre)=0 then
		vPermisoId:=basic.paproceso_getid(vPermisoNombre);
		vState:=false; vID:=0; vError:=1; vDescripcion:=basic.paproceso_getmensaje(vPermisoId);
		if trim(vDescripcion)='' then
			vDescripcion:='No tiene permisos para realizar este proceso';
		end if;
	end if;
	if vState then
		vTipoPersona:=case when (trim(inape_pat)!='' or trim(inape_mat)!='' or trim(innombre)!='') then 'N' else 'J' end;
		IF vTipoPersona='N' then
			if exists(select * from basic.persona_natural where upper(ape_pat)=upper(inape_pat) and upper(ape_mat)=upper(inape_mat) and upper(nombre)=upper(innombre) and personaid!=inpersonaid) then
				vState:=false; vID:=0; vError:=1; vDescripcion:='Ya existe una persona natural igual al que acaba de ingresar.';
			end if;
		else
			if exists(select * from basic.persona_juridica where upper(raz_soc)=upper(inraz_soc) and personaid!=inpersonaid) then
				vState:=false; vID:=0; vError:=1; vDescripcion:='Ya existe una persona juridica igual al que acaba de ingresar.';
			end if;
		end if;
	end if;
	if vState then
		if trim(indni)!='' then
			if exists(select * from basic.persona_natural where upper(dni)=upper(indni) and personaid!=inpersonaid) then
				select personaid into vCodigoPerAux from basic.persona_natural where upper(dni)=upper(indni) and personaid!=inpersonaid;
				vCodigoPerAux:=coalesce(vCodigoPerAux,0);
				vState:=false; vID:=0; vError:=1; vDescripcion:='Ya existe el DNI que acaba de ingresar. Esta registrado en "' ||basic.papersona_getnombre(vCodigoPerAux)||'"';
			end if;
		end if;
	end if;
	if vState then
		if trim(inruc)!='' then
			if exists(select * from basic.persona_juridica where upper(ruc)=upper(inruc) and personaid!=inpersonaid) then
				select personaid into vCodigoPerAux from basic.persona_juridica where upper(ruc)=upper(inruc) and personaid!=inpersonaid;
				vCodigoPerAux:=coalesce(vCodigoPerAux,0);
				vState:=false; vID:=0; vError:=1; vDescripcion:='Ya existe el RUC que acaba de ingresar. Esta registrado en "' ||basic.papersona_getnombre(vCodigoPerAux)||'"';
			end if;
		end if;
	end if;
	if vState then
		if trim(inlicencia)!='' then
			if exists(select * from basic.persona_conductor where upper(licencia)=upper(inlicencia) and personaid!=inpersonaid) then
				select personaid into vCodigoPerAux from basic.persona_conductor where upper(licencia)=upper(inlicencia) and personaid!=inpersonaid;
				vCodigoPerAux:=coalesce(vCodigoPerAux,0);
				vState:=false; vID:=0; vError:=1; vDescripcion:='Ya existe el numero de licencia que acaba de ingresar. Esta registrado en "' ||basic.papersona_getnombre(vCodigoPerAux)||'"';
			end if;
		end if;
	end if;
	If vState Then
		drop table if exists tmp cascade;
		create temporary table tmp(tipo varchar not null, valor integer not null);

		if innew Then
			vID:=nextval('basic.persona_personaid_seq');
			insert into basic.persona values(vID, vTipoPersona, trim(indireccion),'', '', '', trim(innombre_comercial), indistritoid, true, current_timestamp, '');
		else
			vIDRastro:=nextval('rastro.personaedit_personaeditid_seq');
			insert into rastro.personaedit values(vIDRastro, inpersonaid, inusuarioid, (case when innew then 'N' else 'E' end), current_timestamp, inip, 1);
			execute rastro.papersonainsert(vIDRastro, 'O');

			update basic.persona set tipo=vTipoPersona, direccion=trim(indireccion), nombre_comercial=trim(innombre_comercial), distritoid=indistritoid where personaid=inpersonaid;
			vID:=inpersonaid;
			delete from basic.persona_natural where personaid=vID;
			delete from basic.persona_juridica where personaid=vID;
			delete from basic.persona_socialmedia where personaid=vID;
			delete from basic.persona_rol where personaid=vID;
			delete from basic.persona_conductor where personaid=vID;

			insert into tmp select 'PHONE', codigo from basic.persona_telefono where personaid=vID;
			insert into tmp select 'EMAIL', codigo from basic.persona_email where personaid=vID;
		end if;
		if trim(inape_pat)!='' or trim(inape_mat)!='' or trim(innombre)!='' then
			insert into basic.persona_natural values(vID, intitulo, inape_pat, inape_mat, innombre, indni, inpernat_ruc, 0, '', insexo, inest_civil, innacimiento);
		end if;
		if trim(inraz_soc)!='' then
			insert into basic.persona_juridica values(vID, inraz_soc, inruc);
		end if;
		if trim(inlicencia)!='' then
			insert into basic.persona_conductor values(vID, trim(inlicencia));
		end if;

		--BEGIN PHONE
		vFilas=array_upper(inarrphone,1);
		if (not (inarrphone[1][1] is null)) then 
			vIndice:=0;
			if vFilas>0 then
				for vIndice in 1..vFilas loop
					vIDOther:=inarrphone[vIndice][1]::integer;
					if vIDOther>0 then
						update basic.persona_telefono set tipotelefonoid=inarrphone[vIndice][2]::integer, numero=inarrphone[vIndice][3]::varchar, nombre=inarrphone[vIndice][4]::varchar, main=inarrphone[vIndice][5]::boolean, publico=inarrphone[vIndice][6]::boolean where codigo=vIDOther;
						delete from tmp where tipo='PHONE' and valor=vIDOther;
					else
						insert into basic.persona_telefono values(default, vID, inarrphone[vIndice][2]::integer, inarrphone[vIndice][3]::varchar, '', inarrphone[vIndice][4]::varchar, inarrphone[vIndice][5]::boolean, inarrphone[vIndice][6]::boolean);
					end if;
				end loop; 
			end if;
		end if;
		delete from basic.persona_telefono where personaid=vID and codigo in (select valor from tmp where tipo='PHONE');
		--END PHONE

		--BEGIN EMAIL
		vFilas=array_upper(inarremail,1);
		if (not (inarremail[1][1] is null)) then 
			vIndice:=0;
			if vFilas>0 then
				for vIndice in 1..vFilas loop
					vIDOther:=inarremail[vIndice][1]::integer;
					if vIDOther>0 then
						update basic.persona_email set tipoemailid=inarremail[vIndice][2]::integer, email=inarremail[vIndice][3]::varchar, main=inarremail[vIndice][4]::boolean, publico=inarremail[vIndice][5]::boolean where codigo=vIDOther;
						delete from tmp where tipo='EMAIL' and valor=vIDOther;
					else
						insert into basic.persona_email values(default, vID, inarremail[vIndice][2]::integer, inarremail[vIndice][3]::varchar, '', inarremail[vIndice][4]::boolean, inarremail[vIndice][5]::boolean);
					end if;
				end loop;
			end if;
		end if;
		delete from basic.persona_email where personaid=vID and codigo in (select valor from tmp where tipo='EMAIL');
		--END EMAIL

		--BEGIN SOCIAL MEDIA
		vFilas=array_upper(inarrsocialmedia,1);
		if (not (inarrsocialmedia[1][1] is null)) then 
			vIndice:=0;
			if vFilas>0 then
				for vIndice in 1..vFilas loop
					if trim(inarrsocialmedia[vIndice][2])!='' then
						insert into basic.persona_socialmedia values(vID, inarrsocialmedia[vIndice][1]::integer, inarrsocialmedia[vIndice][2]::varchar);
					end if;
				end loop;
			end if;
		end if;
		--END SOCIAL MEDIA

		--BEGIN ROL
		insert into basic.persona_rol select vID, inarrrol[i] from generate_series(1, array_upper(inarrrol, 1)) as i;
		--BEGIN ROL

		update basic.persona set telefono=basic.papersona_gettelefonomain(vID), email=basic.papersona_getemailmain(vID), rol=basic.papersona_getrol(vID, '') where personaid=vID;

		if not innew then
			--RASTRO DE LOS DATOS NUEVOS
			execute rastro.papersonainsert(vIDRastro, 'N');
		end if;

	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.papersona_actualizar(innew boolean, inpersonaid integer, intipo character, intitulo character varying, inape_pat character varying, inape_mat character varying, innombre character varying, indni character varying, inpernat_ruc character varying, insexo character, inest_civil character, innacimiento date, inraz_soc character varying, inruc character varying, indireccion character varying, innombre_comercial character varying, indistritoid integer, inlicencia character varying, inarrphone character varying[], inarremail character varying[], inarrsocialmedia character varying[], inarrrol integer[], inusuarioid integer, inip character varying) OWNER TO radiosan_ustaana;

--
-- Name: papersona_actualizar_desktop(boolean, integer, character, character varying, character varying, character varying, character varying, character varying, character varying, character, character, date, character varying, character varying, character varying, character varying, integer, character varying[], character varying[], integer[], integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_actualizar_desktop(innew boolean, inpersonaid integer, intipo character, intitulo character varying, inape_pat character varying, inape_mat character varying, innombre character varying, indni character varying, inpernat_ruc character varying, insexo character, inest_civil character, innacimiento date, inraz_soc character varying, inruc character varying, indireccion character varying, innombre_comercial character varying, indistritoid integer, inarrphone character varying[], inarremail character varying[], inarrrol integer[], inusuarioid integer, inip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vTipoPersona varchar default ''; vUsuario varchar default ''; vCodigoPerAux integer default 0;
	vIndice integer default 0; vFilas integer default 0; vIDOther integer default 0;
	vIDRastro integer default 0;
BEGIN
	vTipoPersona:=case when (trim(inape_pat)!='' or trim(inape_mat)!='' or trim(innombre)!='') then 'N' else 'J' end;
	IF vTipoPersona='N' then
		if exists(select * from basic.persona_natural where upper(ape_pat)=upper(inape_pat) and upper(ape_mat)=upper(inape_mat) and upper(nombre)=upper(innombre) and personaid!=inpersonaid) then
			vState:=false; vID:=0; vError:=1; vDescripcion:='Ya existe una persona natural igual al que acaba de ingresar.';
		end if;
	else
		if exists(select * from basic.persona_juridica where upper(raz_soc)=upper(inraz_soc) and personaid!=inpersonaid) then
			vState:=false; vID:=0; vError:=1; vDescripcion:='Ya existe una persona juridica igual al que acaba de ingresar.';
		end if;
	end if;
	if vState then
		if trim(indni)!='' then
			if exists(select * from basic.persona_natural where upper(dni)=upper(indni) and personaid!=inpersonaid) then
				select personaid into vCodigoPerAux from basic.persona_natural where upper(dni)=upper(indni) and personaid!=inpersonaid;
				vCodigoPerAux:=coalesce(vCodigoPerAux,0);
				vState:=false; vID:=0; vError:=1; vDescripcion:='Ya existe el DNI que acaba de ingresar. Esta registrado en "' ||basic.papersona_getnombre(vCodigoPerAux)||'"';
			end if;
		end if;
	end if;
	if vState then
		if trim(inruc)!='' then
			if exists(select * from basic.persona_juridica where upper(ruc)=upper(inruc) and personaid!=inpersonaid) then
				select personaid into vCodigoPerAux from basic.persona_juridica where upper(ruc)=upper(inruc) and personaid!=inpersonaid;
				vCodigoPerAux:=coalesce(vCodigoPerAux,0);
				vState:=false; vID:=0; vError:=1; vDescripcion:='Ya existe el RUC que acaba de ingresar. Esta registrado en "' ||basic.papersona_getnombre(vCodigoPerAux)||'"';
			end if;
		end if;
	end if;
	If vState Then
		drop table if exists tmp cascade;
		create temporary table tmp(tipo varchar not null, valor integer not null);

		if innew Then
			vID:=nextval('basic.persona_personaid_seq');
			insert into basic.persona values(vID, vTipoPersona, trim(indireccion),'', '', '', trim(innombre_comercial), indistritoid, true, current_timestamp, '');
		else
			vIDRastro:=nextval('rastro.personaedit_personaeditid_seq');
			insert into rastro.personaedit values(vIDRastro, inpersonaid, inusuarioid, (case when innew then 'N' else 'E' end), current_timestamp, inip, 1);
			execute rastro.papersonainsert(vIDRastro, 'O');

			update basic.persona set tipo=vTipoPersona, direccion=trim(indireccion), nombre_comercial=trim(innombre_comercial), distritoid=indistritoid where personaid=inpersonaid;
			vID:=inpersonaid;
			delete from basic.persona_natural where personaid=vID;
			delete from basic.persona_juridica where personaid=vID;
			delete from basic.persona_socialmedia where personaid=vID;
			delete from basic.persona_rol where personaid=vID;

			insert into tmp select 'PHONE', codigo from basic.persona_telefono where personaid=vID;
			insert into tmp select 'EMAIL', codigo from basic.persona_email where personaid=vID;
		end if;
		if trim(inApe_Pat)!='' or trim(inApe_Mat)!='' or trim(inNombre)!='' then
			insert into basic.persona_natural values(vID, intitulo, inape_pat, inape_mat, innombre, indni, inpernat_ruc, 0, '', insexo, inest_civil, innacimiento);
		end if;
		if trim(inRaz_Soc)!='' then
			insert into basic.persona_juridica values(vID, inraz_soc, inruc);
		end if;

		--BEGIN PHONE
		vFilas=array_upper(inarrphone,1);
		if (not (inarrphone[1][1] is null)) then 
			vIndice:=0;
			if vFilas>0 then
				for vIndice in 1..vFilas loop
					vIDOther:=inarrphone[vIndice][1]::integer;
					if vIDOther>0 then
						update basic.persona_telefono set tipotelefonoid=inarrphone[vIndice][2]::integer, numero=inarrphone[vIndice][3]::varchar, nombre=inarrphone[vIndice][4]::varchar, main=inarrphone[vIndice][5]::boolean, publico=inarrphone[vIndice][6]::boolean where codigo=vIDOther;
						delete from tmp where tipo='PHONE' and valor=vIDOther;
					else
						insert into basic.persona_telefono values(default, vID, inarrphone[vIndice][2]::integer, inarrphone[vIndice][3]::varchar, '', inarrphone[vIndice][4]::varchar, inarrphone[vIndice][5]::boolean, inarrphone[vIndice][6]::boolean);
					end if;
				end loop; 
			end if;
		end if;
		delete from basic.persona_telefono where personaid=vID and codigo in (select valor from tmp where tipo='PHONE');
		--END PHONE

		--BEGIN EMAIL
		vFilas=array_upper(inarremail,1);
		if (not (inarremail[1][1] is null)) then 
			vIndice:=0;
			if vFilas>0 then
				for vIndice in 1..vFilas loop
					vIDOther:=inarremail[vIndice][1]::integer;
					if vIDOther>0 then
						update basic.persona_email set tipoemailid=inarremail[vIndice][2]::integer, email=inarremail[vIndice][3]::varchar, main=inarremail[vIndice][4]::boolean, publico=inarremail[vIndice][5]::boolean where codigo=vIDOther;
						delete from tmp where tipo='EMAIL' and valor=vIDOther;
					else
						insert into basic.persona_email values(default, vID, inarremail[vIndice][2]::integer, inarremail[vIndice][3]::varchar, '', inarremail[vIndice][4]::boolean, inarremail[vIndice][5]::boolean);
					end if;
				end loop;
			end if;
		end if;
		delete from basic.persona_email where personaid=vID and codigo in (select valor from tmp where tipo='EMAIL');
		--END EMAIL

		--BEGIN ROL
		insert into basic.persona_rol select vID, inarrrol[i] from generate_series(1, array_upper(inarrrol, 1)) as i;
		--BEGIN ROL

		update basic.persona set telefono=basic.papersona_gettelefonomain(vID), email=basic.papersona_getemailmain(vID), rol=basic.papersona_getrol(vID, '') where personaid=vID;

		if not innew then
			--RASTRO DE LOS DATOS NUEVOS
			execute rastro.papersonainsert(vIDRastro, 'N');
		end if;

	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.papersona_actualizar_desktop(innew boolean, inpersonaid integer, intipo character, intitulo character varying, inape_pat character varying, inape_mat character varying, innombre character varying, indni character varying, inpernat_ruc character varying, insexo character, inest_civil character, innacimiento date, inraz_soc character varying, inruc character varying, indireccion character varying, innombre_comercial character varying, indistritoid integer, inarrphone character varying[], inarremail character varying[], inarrrol integer[], inusuarioid integer, inip character varying) OWNER TO radiosan_ustaana;

--
-- Name: papersona_actualizar_desktop(boolean, integer, character, character varying, character varying, character varying, character varying, character varying, character varying, character, character, date, character varying, character varying, character varying, character varying, integer, character varying[], character varying[], character varying[], integer[], integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_actualizar_desktop(innew boolean, inpersonaid integer, intipo character, intitulo character varying, inape_pat character varying, inape_mat character varying, innombre character varying, indni character varying, inpernat_ruc character varying, insexo character, inest_civil character, innacimiento date, inraz_soc character varying, inruc character varying, indireccion character varying, innombre_comercial character varying, indistritoid integer, inarrphone character varying[], inarremail character varying[], inarrdocs character varying[], inarrrol integer[], inusuarioid integer, inip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vTipoPersona varchar default ''; vUsuario varchar default ''; vCodigoPerAux integer default 0;
	vIndice integer default 0; vFilas integer default 0; vIDOther integer default 0;
	vIDRastro integer default 0;
BEGIN
	vTipoPersona:=case when (trim(inape_pat)!='' or trim(inape_mat)!='' or trim(innombre)!='') then 'N' else 'J' end;
	IF vTipoPersona='N' then
		if exists(select * from basic.persona_natural where upper(ape_pat)=upper(inape_pat) and upper(ape_mat)=upper(inape_mat) and upper(nombre)=upper(innombre) and personaid!=inpersonaid) then
			vState:=false; vID:=0; vError:=1; vDescripcion:='Ya existe una persona natural igual al que acaba de ingresar.';
		end if;
	else
		if exists(select * from basic.persona_juridica where upper(raz_soc)=upper(inraz_soc) and personaid!=inpersonaid) then
			vState:=false; vID:=0; vError:=1; vDescripcion:='Ya existe una persona juridica igual al que acaba de ingresar.';
		end if;
	end if;
	if vState then
		if trim(indni)!='' then
			if exists(select * from basic.persona_natural where upper(dni)=upper(indni) and personaid!=inpersonaid) then
				select personaid into vCodigoPerAux from basic.persona_natural where upper(dni)=upper(indni) and personaid!=inpersonaid;
				vCodigoPerAux:=coalesce(vCodigoPerAux,0);
				vState:=false; vID:=0; vError:=1; vDescripcion:='Ya existe el DNI que acaba de ingresar. Esta registrado en "' ||basic.papersona_getnombre(vCodigoPerAux)||'"';
			end if;
		end if;
	end if;
	if vState then
		if trim(inruc)!='' then
			if exists(select * from basic.persona_juridica where upper(ruc)=upper(inruc) and personaid!=inpersonaid) then
				select personaid into vCodigoPerAux from basic.persona_juridica where upper(ruc)=upper(inruc) and personaid!=inpersonaid;
				vCodigoPerAux:=coalesce(vCodigoPerAux,0);
				vState:=false; vID:=0; vError:=1; vDescripcion:='Ya existe el RUC que acaba de ingresar. Esta registrado en "' ||basic.papersona_getnombre(vCodigoPerAux)||'"';
			end if;
		end if;
	end if;
	If vState Then
		drop table if exists tmp cascade;
		create temporary table tmp(tipo varchar not null, valor integer not null);

		if innew Then
			vID:=nextval('basic.persona_personaid_seq');
			insert into basic.persona values(vID, vTipoPersona, trim(indireccion),'', '', '', trim(innombre_comercial), indistritoid, true, current_timestamp, '');
		else
			vIDRastro:=nextval('rastro.personaedit_personaeditid_seq');
			insert into rastro.personaedit values(vIDRastro, inpersonaid, inusuarioid, (case when innew then 'N' else 'E' end), current_timestamp, inip, 1);
			execute rastro.papersonainsert(vIDRastro, 'O');

			update basic.persona set tipo=vTipoPersona, direccion=trim(indireccion), nombre_comercial=trim(innombre_comercial), distritoid=indistritoid where personaid=inpersonaid;
			vID:=inpersonaid;
			delete from basic.persona_natural where personaid=vID;
			delete from basic.persona_juridica where personaid=vID;
			delete from basic.persona_socialmedia where personaid=vID;
			delete from basic.persona_rol where personaid=vID;
			delete from basic.persona_tipoid where personaid=vID;

			insert into tmp select 'PHONE', codigo from basic.persona_telefono where personaid=vID;
			insert into tmp select 'EMAIL', codigo from basic.persona_email where personaid=vID;
		end if;
		if trim(inApe_Pat)!='' or trim(inApe_Mat)!='' or trim(inNombre)!='' then
			insert into basic.persona_natural values(vID, intitulo, inape_pat, inape_mat, innombre, indni, inpernat_ruc, 0, '', insexo, inest_civil, innacimiento);
		end if;
		if trim(inRaz_Soc)!='' then
			insert into basic.persona_juridica values(vID, inraz_soc, inruc);
		end if;

		--BEGIN PHONE
		vFilas=array_upper(inarrphone,1);
		if (not (inarrphone[1][1] is null)) then 
			vIndice:=0;
			if vFilas>0 then
				for vIndice in 1..vFilas loop
					vIDOther:=inarrphone[vIndice][1]::integer;
					if vIDOther>0 then
						update basic.persona_telefono set tipotelefonoid=inarrphone[vIndice][2]::integer, numero=inarrphone[vIndice][3]::varchar, nombre=inarrphone[vIndice][4]::varchar, main=inarrphone[vIndice][5]::boolean, publico=inarrphone[vIndice][6]::boolean where codigo=vIDOther;
						delete from tmp where tipo='PHONE' and valor=vIDOther;
					else
						insert into basic.persona_telefono values(default, vID, inarrphone[vIndice][2]::integer, inarrphone[vIndice][3]::varchar, '', inarrphone[vIndice][4]::varchar, inarrphone[vIndice][5]::boolean, inarrphone[vIndice][6]::boolean);
					end if;
				end loop; 
			end if;
		end if;
		delete from basic.persona_telefono where personaid=vID and codigo in (select valor from tmp where tipo='PHONE');
		--END PHONE

		--BEGIN EMAIL
		vFilas=array_upper(inarremail,1);
		if (not (inarremail[1][1] is null)) then 
			vIndice:=0;
			if vFilas>0 then
				for vIndice in 1..vFilas loop
					vIDOther:=inarremail[vIndice][1]::integer;
					if vIDOther>0 then
						update basic.persona_email set tipoemailid=inarremail[vIndice][2]::integer, email=inarremail[vIndice][3]::varchar, main=inarremail[vIndice][4]::boolean, publico=inarremail[vIndice][5]::boolean where codigo=vIDOther;
						delete from tmp where tipo='EMAIL' and valor=vIDOther;
					else
						insert into basic.persona_email values(default, vID, inarremail[vIndice][2]::integer, inarremail[vIndice][3]::varchar, '', inarremail[vIndice][4]::boolean, inarremail[vIndice][5]::boolean);
					end if;
				end loop;
			end if;
		end if;
		delete from basic.persona_email where personaid=vID and codigo in (select valor from tmp where tipo='EMAIL');
		--END EMAIL

		--BEGIN DOCUMENTOS
		vFilas=array_upper(inarrdocs,1);
		if (not (inarrdocs[1][1] is null)) then 
			vIndice:=0;
			if vFilas>0 then
				for vIndice in 1..vFilas loop
					insert into basic.persona_tipoid values(vID, inarrdocs[vIndice][1]::integer, trim(inarrdocs[vIndice][2]), inarrdocs[vIndice][3]::boolean);
				end loop;
			end if;
		end if;
		--END DOCUMENTOS

		--BEGIN ROL
		insert into basic.persona_rol select vID, inarrrol[i] from generate_series(1, array_upper(inarrrol, 1)) as i;
		--BEGIN ROL

		update basic.persona set telefono=basic.papersona_gettelefonomain(vID), email=basic.papersona_getemailmain(vID), rol=basic.papersona_getrol(vID, '') where personaid=vID;

		if not innew then
			--RASTRO DE LOS DATOS NUEVOS
			execute rastro.papersonainsert(vIDRastro, 'N');
		end if;

	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.papersona_actualizar_desktop(innew boolean, inpersonaid integer, intipo character, intitulo character varying, inape_pat character varying, inape_mat character varying, innombre character varying, indni character varying, inpernat_ruc character varying, insexo character, inest_civil character, innacimiento date, inraz_soc character varying, inruc character varying, indireccion character varying, innombre_comercial character varying, indistritoid integer, inarrphone character varying[], inarremail character varying[], inarrdocs character varying[], inarrrol integer[], inusuarioid integer, inip character varying) OWNER TO radiosan_ustaana;

--
-- Name: papersona_cambiar_estado(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_cambiar_estado(vpersonaid integer, vusuario integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vEstadoOld boolean default false;
BEGIN
	if vState then
		if exists(select * from basic.persona where personaid=vpersonaid) then
			--RASTRO
			select estado into vEstadoOld from basic.persona where personaid=vpersonaid;
			insert into rastro.campo values(default, 'basic', 'persona', 'estado', 'B', vpersonaid, 0, 0, vEstadoOld::varchar, (not vEstadoOld)::varchar, current_timestamp, vusuario, vip, 1, 0);
			
			update basic.persona set estado=not estado where personaid=vpersonaid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.papersona_cambiar_estado(vpersonaid integer, vusuario integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: papersona_cambiar_foto(integer, character varying, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_cambiar_foto(vpersonaid integer, vfoto character varying, vusuario integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vFotoOld varchar default '';
BEGIN
	if vState then
		if exists(select * from basic.persona where personaid=vpersonaid) then
			--RASTRO
			select foto into vFotoOld from basic.persona where personaid=vpersonaid;
			insert into rastro.campo values(default, 'basic', 'persona', 'foto', 'V', vpersonaid, 0, 0, vFotoOld, vfoto, current_timestamp, vusuario, vip, 1, 0);
			
			update basic.persona set foto=vfoto where personaid=vpersonaid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.papersona_cambiar_foto(vpersonaid integer, vfoto character varying, vusuario integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: papersona_claves_leer(integer, integer, character varying, character varying, character varying, integer[]); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_claves_leer(vfirst integer, vlast integer, vape_pat character varying, vape_mat character varying, vnombre character varying, arrrol integer[]) RETURNS SETOF type_persona_claves_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp_rol, tmp_per cascade;
	create temporary table tmp_rol(rolid integer not null);
	create temporary table tmp_per(personaid integer not null);
	
	insert into tmp_rol select rolid from basic.rol where estructura='EMP';
	insert into tmp_per select personaid from basic.persona_rol pr inner join tmp_rol tmp on pr.rolid=tmp.rolid;
	return query
		select p.personaid, p.tipo, (case when p.tipo='J' then coalesce(pj.raz_soc,'') else (coalesce(pn.ape_pat,'') || ' ' || coalesce(pn.ape_mat,'') || ', ' || coalesce(pn.nombre,'')) end)::varchar, 
			p.direccion, p.telefono, coalesce(pn.sexo,'M')::varchar, p.foto, coalesce(c.usuario,'')::varchar, coalesce(c.tipo_cambio, '')::varchar, coalesce(c.renovar_clave, false)::boolean, p.estado
		from tmp_per tmp inner join basic.persona p on tmp.personaid=p.personaid
				left join basic.persona_natural pn on p.personaid=pn.personaid
				left join basic.persona_juridica pj on p.personaid=pj.personaid
			left join basic.clave c on p.personaid=c.personaid
		where p.personaid>0
			and case when trim(upper(vApe_Pat))!='' then (upper(buscar(pn.ape_pat)) like ('%' || trim(upper(buscar(vApe_Pat))) || '%') or upper(buscar(pj.raz_soc)) like ('%' || trim(upper(buscar(vApe_Pat))) || '%')) else true end
			and case when trim(upper(vApe_Mat))!='' then (upper(buscar(pn.ape_mat)) like ('%' || trim(upper(buscar(vApe_Mat))) || '%')) else true end
			and case when trim(upper(vNombre))!='' then (upper(buscar(pn.nombre)) like ('%' || trim(upper(buscar(vNombre))) || '%')) else true end
		order by 3
		limit case when vfirst=0 and vlast=0 then null else vlast end offset vfirst;
		
	drop table if exists tmp_rol, tmp_per cascade;
END
$$;


ALTER FUNCTION basic.papersona_claves_leer(vfirst integer, vlast integer, vape_pat character varying, vape_mat character varying, vnombre character varying, arrrol integer[]) OWNER TO radiosan_ustaana;

--
-- Name: papersona_config_actualizar(integer, boolean, integer, boolean, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_config_actualizar(vpersonaid integer, vconsultasunat boolean, vsunattipoconsulta integer, vconsultareniec boolean, vreniectipoconsulta integer, vcaja_refdef character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.persona_config where personaid=vpersonaid) then
		update basic.persona_config set consultarsunat=vconsultasunat, sunattipoconsulta=vsunattipoconsulta, consultarreniec=vconsultareniec, reniectipoconsulta=vreniectipoconsulta, caja_refdef=trim(vcaja_refdef) where personaid=vpersonaid;
	else
		insert into basic.persona_config values(vpersonaid, vconsultasunat, vconsultareniec, vsunattipoconsulta, vreniectipoconsulta, trim(vcaja_refdef));
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.papersona_config_actualizar(vpersonaid integer, vconsultasunat boolean, vsunattipoconsulta integer, vconsultareniec boolean, vreniectipoconsulta integer, vcaja_refdef character varying) OWNER TO radiosan_ustaana;

--
-- Name: papersona_config_getrow(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_config_getrow(vpersonaid integer) RETURNS SETOF type_persona_config_getrow
    LANGUAGE plpgsql
    AS $$
BEGIN
	
	return query
		select pc.personaid, pc.consultarsunat, pc.consultarreniec, pc.caja_refdef
		from basic.persona_config pc
		where pc.personaid=vpersonaid;

END

$$;


ALTER FUNCTION basic.papersona_config_getrow(vpersonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: papersona_consulta(character varying, character varying, character varying, character varying, integer[], integer, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_consulta(vapepat character varying, vapemat character varying, vnombre character varying, vproceso character varying, arrrol integer[], vfilas integer, vpersonaid integer) RETURNS SETOF type_persona_consulta
    LANGUAGE plpgsql
    AS $$
declare swSinRol boolean default false; swRoles boolean default false;
BEGIN
	drop table if exists tmp_rol, tmp_per_rol, tmp_per_sinrol cascade;
	create temporary table tmp_rol(rolid integer not null);
	create temporary table tmp_per_rol(personaid integer not null);
	create temporary table tmp_per_sinrol(personaid integer not null);
	
	if arrRol[1] is null then
		if vproceso='' then
			insert into tmp_rol select rolid from basic.rol;
			insert into tmp_rol values(0);
		else
			if exists(select * from basic.opciones_seleccion_rol osr inner join basic.opciones_seleccion os on osr.codigo=os.codigo where os.proceso=vproceso) then
				insert into tmp_rol select osr.rolid from basic.opciones_seleccion_rol osr inner join basic.opciones_seleccion os on osr.codigo=os.codigo where os.proceso=vproceso;
			else
				insert into tmp_rol select rolid from basic.rol;
				insert into tmp_rol values(0);
			end if;
		end if;
	else
		insert into tmp_rol select arrRol[i] from generate_series(1, array_upper(arrRol, 1)) as i;
	end if;
	swRoles:=exists(select * from tmp_rol where rolid>0);
	swSinRol:=exists(select * from tmp_rol where rolid=0);
	insert into tmp_per_rol select pr.personaid from tmp_rol tmp inner join basic.persona_rol pr on tmp.rolid=pr.rolid group by 1;
	insert into tmp_per_sinrol select p.personaid from basic.persona p left join basic.persona_rol pr on p.personaid=pr.personaid where pr.personaid is null group by 1;	
	
	RETURN QUERY
		select p.personaid, p.tipo::varchar, (case when p.tipo='J' then coalesce(pj.ruc,'') else (case when coalesce(pn.dni,'')!='' then coalesce(pn.dni,'') else coalesce(pn.ruc,'') end ) end)::varchar,
			(case when p.tipo='J' then coalesce(pj.raz_soc,'') else (coalesce(pn.ape_pat,'') || ' ' || coalesce(pn.ape_mat,'') || ', ' || coalesce(pn.nombre,'')) end)::varchar, 
			p.direccion, p.foto, p.email, p.telefono, coalesce(pn.sexo,'M')::varchar, p.rol, coalesce(c.usuario, '')::varchar
		from basic.persona p left join tmp_per_rol pr on p.personaid=pr.personaid
			left join tmp_per_sinrol psr on p.personaid=psr.personaid
			left join basic.clave c on p.personaid=c.personaid
				left join basic.persona_natural pn on p.personaid=pn.personaid
				left join basic.persona_juridica pj on p.personaid=pj.personaid
		where p.personaid>0
			and case when (swRoles and swSinRol) then (not pr.personaid is null or not psr.personaid is null) when swRoles then not pr.personaid is null when swSinRol then not psr.personaid is null else true end
			and case when vpersonaid>0 then p.personaid=vpersonaid else true end
			and case when trim(upper(vapepat))!='' then 
				(
					upper(buscar(pn.ape_pat)) like ('%' || trim(upper(buscar(vapepat))) || '%') 
					or upper(buscar(pn.ape_pat||' '||pn.ape_mat||' '||pn.nombre)) like ('%' || trim(upper(buscar(vapepat))) || '%')
					or upper(buscar(pn.nombre||' '||pn.ape_pat||' '||pn.ape_mat)) like ('%' || trim(upper(buscar(vapepat))) || '%')
					or trim(cast(p.personaid as varchar)) = trim(upper(buscar(vapepat)))
					or upper(buscar(p.email)) like ('%' || trim(upper(buscar(vapepat))) || '%') 
					or upper(buscar(p.telefono)) like ('%' || trim(upper(buscar(vapepat))) || '%') 
					or upper(buscar(pn.dni)) like ('%' || trim(upper(buscar(vapepat))) || '%')
					or upper(buscar(pn.ruc)) like ('%' || trim(upper(buscar(vapepat))) || '%')
					or upper(buscar(pj.ruc)) like ('%' || trim(upper(buscar(vapepat))) || '%')
					or upper(buscar(pj.raz_soc)) like ('%' || trim(upper(buscar(vapepat))) || '%')
				) 
				else true end
			and case when trim(upper(vapemat))!='' then (upper(buscar(pn.ape_mat)) like ('%' || trim(upper(buscar(vapemat))) || '%')) else true end
			and case when trim(upper(vNombre))!='' then (upper(buscar(pn.nombre)) like ('%' || trim(upper(buscar(vNombre))) || '%')) else true end
		order by 4
		limit case when vFilas>0 then vFilas else null end;

	drop table if exists tmp_rol;

END

$$;


ALTER FUNCTION basic.papersona_consulta(vapepat character varying, vapemat character varying, vnombre character varying, vproceso character varying, arrrol integer[], vfilas integer, vpersonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: papersona_consulta_basico(character varying, character varying, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_consulta_basico(vtipo character varying, vnrodoc character varying, vpersonaid integer) RETURNS SETOF type_persona_consulta_basico
    LANGUAGE plpgsql
    AS $$
	declare vCodigo_Per integer default 0; vNroLicencia character varying default ''; 
		vnrocuenta character varying default ''; vc_costo character varying default ''; 
		vasistenteid integer default 0; vsaldo numeric default 0;
BEGIN
	vCodigo_Per:=vpersonaid;

	if vCodigo_Per=0 then

		select p.personaid into vCodigo_Per 
		from basic.persona p 
			left join basic.persona_natural pn on p.personaid=pn.personaid
			left join basic.persona_juridica pj on p.personaid=pj.personaid 
		where 1=1 and case when char_length(vnrodoc)=8 then pn.dni=vNroDoc else (pn.ruc=vNroDoc or pj.ruc=vNroDoc) end 
		limit 1; 		

	end if;
	
	drop table if exists tmp_s;
	create temporary table tmp_s(codigo integer, almacen varchar, rucdni varchar, nombre varchar, saldo numeric(10,2));

	insert into tmp_s
	select * from finanzas.painfosehs(vCodigo_Per, '');

	select coalesce(substring(nrocuenta from 1 for 7),'')::varchar into vnrocuenta from colportaje.personas_campania where asistenteid=vCodigo_Per and colportorid=0;
	select sum(saldo)::numeric(10,2) into vsaldo from tmp_s;			
	RETURN QUERY
               select p.personaid, p.tipo, coalesce(pn.ape_pat,'')::varchar, coalesce(pn.ape_mat,'')::varchar, 
			coalesce(pn.nombre,'')::varchar, coalesce(pj.raz_soc,'')::varchar, 
			coalesce(pn.dni,'')::varchar, (case when p.tipo='J' then pj.ruc else pn.ruc end)::varchar, 
			p.direccion, p.estado, p.distritoid, coalesce(vNroLicencia,'')::varchar,
			vnrocuenta, vc_costo, vasistenteid, coalesce(vsaldo,0)::numeric(10,2)
               from basic.persona p 
			left join basic.persona_natural pn on p.personaid=pn.personaid
			left join basic.persona_juridica pj on p.personaid=pj.personaid
               where 1=1 and case when vCodigo_Per!=0 then p.personaid=vCodigo_Per else false end
	;	
	drop table if exists tmp_s;
END

$$;


ALTER FUNCTION basic.papersona_consulta_basico(vtipo character varying, vnrodoc character varying, vpersonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: papersona_count(character varying, character varying, character varying, character varying, character varying, character varying, integer[]); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_count(vapepat character varying, vapemat character varying, vnombre character varying, vsexo character varying, vestado character varying, vconfoto character varying, arrrol integer[]) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare swSinRol boolean default false; swRoles boolean default false; 
	vCount integer default 0;
BEGIN
	drop table if exists tmp_rol, tmp_per_rol, tmp_per_sinrol cascade;
	create temporary table tmp_rol(rolid integer not null);
	create temporary table tmp_per_rol(personaid integer not null);
	create temporary table tmp_per_sinrol(personaid integer not null);
	if not arrRol[1] is null then
		insert into tmp_rol select arrRol[i] from generate_series(1, array_upper(arrRol, 1)) as i;
		swRoles:=exists(select * from tmp_rol where rolid>0);
		swSinRol:=exists(select * from tmp_rol where rolid=0);
	end if;
	insert into tmp_per_rol select pr.personaid from tmp_rol tmp inner join basic.persona_rol pr on tmp.rolid=pr.rolid group by 1;
	insert into tmp_per_sinrol select p.personaid from basic.persona p left join basic.persona_rol pr on p.personaid=pr.personaid where pr.personaid is null group by 1;
	
	select count(*) into vCount
	from basic.persona p left join tmp_per_rol pr on p.personaid=pr.personaid
		left join tmp_per_sinrol psr on p.personaid=psr.personaid
			left join basic.persona_natural pn on p.personaid=pn.personaid
			left join basic.persona_juridica pj on p.personaid=pj.personaid
	where p.personaid>0
		and case when (swRoles and swSinRol) then (not pr.personaid is null or not psr.personaid is null) when swRoles then not pr.personaid is null when swSinRol then not psr.personaid is null else true end
		and case when trim(vApePat)!='' then upper(buscar(pn.ape_pat)) like '%' || upper(buscar(vApePat)) || '%' or upper(buscar(pj.raz_soc)) like '%' || upper(buscar(vApePat)) || '%' else true end 
		and case when trim(vApeMat)!='' then upper(buscar(pn.ape_mat)) like '%' || upper(buscar(vApeMat)) || '%' else true end 
		and case when trim(vNombre)!='' then upper(buscar(pn.nombre)) like '%' || upper(buscar(vNombre)) || '%' else true end 
		and case when trim(vSexo)!='' then coalesce(pn.sexo, 'M')=trim(vSexo) else true end 
		and case when trim(vestado)!='' then p.estado=(trim(vestado)='Y') else true end 
		and case when trim(vconfoto)='Y' then trim(p.foto)!='' else true end 
		and case when trim(vconfoto)='N' then trim(p.foto)='' else true end 
	;
	drop table if exists tmp_rol, tmp_per_rol, tmp_per_sinrol cascade;
	return coalesce(vCount, 0);
END
$$;


ALTER FUNCTION basic.papersona_count(vapepat character varying, vapemat character varying, vnombre character varying, vsexo character varying, vestado character varying, vconfoto character varying, arrrol integer[]) OWNER TO radiosan_ustaana;

--
-- Name: papersona_direccion_actualizar(boolean, integer, integer, integer, character varying, character varying, character varying, character varying, integer, boolean, boolean); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_direccion_actualizar(innew boolean, indireccionid integer, inpersonaid integer, intipodireccionid integer, insucursal character varying, indireccion character varying, inurbanizacion character varying, inreferencia character varying, indistritoid integer, inpordefecto boolean, inestado boolean) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.persona_direccion dir where trim(upper(buscar(dir.sucursal)))=trim(upper(buscar(insucursal))) and dir.personaid=inpersonaid and dir.direccionid!=indireccionid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre de la sucursal ya existe en la base de datos para esta persona';
	end if;
	if vState then
		if exists(select * from basic.persona_direccion dir where trim(upper(buscar(dir.direccion)))=trim(upper(buscar(indireccion))) and dir.personaid=inpersonaid and dir.direccionid!=indireccionid) then
			vState:=false; vID:=0; vError:=1; vDescripcion:='La dirección ya existe en la base de datos para esta persona';
		end if;	
	end if;
	If vState Then
		If innew Then
			insert into basic.persona_direccion values(default, current_timestamp, inpersonaid, intipodireccionid, trim(insucursal), trim(indireccion), trim(inurbanizacion), trim(inreferencia), indistritoid, basic.padireccion_lastorder(inpersonaid)+1, inpordefecto, inestado);
			vID:=lastval();
		Else
			update basic.persona_direccion set tipodireccionid=intipodireccionid, sucursal=trim(insucursal), direccion=trim(indireccion),
				urbanizacion=trim(inurbanizacion), referencia=trim(inreferencia), distritoid=indistritoid, pordefecto=inpordefecto, estado=inestado
			where direccionid=indireccionid;
			vID:=indireccionid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.papersona_direccion_actualizar(innew boolean, indireccionid integer, inpersonaid integer, intipodireccionid integer, insucursal character varying, indireccion character varying, inurbanizacion character varying, inreferencia character varying, indistritoid integer, inpordefecto boolean, inestado boolean) OWNER TO radiosan_ustaana;

--
-- Name: papersona_direccion_eliminar(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_direccion_eliminar(vdireccionid integer, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from inventarios.venta where direcciondespachoid=vdireccionid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar la dirección por tener ventas relacionadas.';
	end if;
	if vState then
		delete from basic.persona_direccion where direccionid=vdireccionid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.papersona_direccion_eliminar(vdireccionid integer, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: papersona_direccion_getrow(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_direccion_getrow(vdireccionid integer) RETURNS SETOF type_persona_direccion_getrow
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select dir.direccionid, to_char(dir.registro, 'DD/MM/YYYY HH12:MI AM')::varchar, dir.personaid, dir.tipodireccionid, td.nombre, dir.sucursal, dir.direccion, dir.urbanizacion, dir.referencia, dir.estado, dir.pordefecto,
			(dpto.ubigeo||pro.ubigeo||dis.ubigeo)::varchar,
			(dir.direccion||' - '||dis.nombre||' - '||pro.nombre||' - '||dpto.nombre)::varchar,
			dir.distritoid, dis.nombre, dis.abreviatura, dis.ubigeo, 
			dis.provinciaid, pro.nombre, pro.abreviatura, pro.ubigeo,
			pro.departamentoid, dpto.nombre, dpto.abreviatura, dpto.ubigeo,
			dpto.paisid, pai.nombre, pai.abreviatura, pai.ubigeo
		from basic.persona_direccion dir inner join basic.tipo_direccion td on dir.tipodireccionid=td.tipodireccionid
			inner join basic.distrito dis on dir.distritoid=dis.distritoid
			inner join basic.provincia pro on dis.provinciaid=pro.provinciaid
			inner join basic.departamento dpto on pro.departamentoid=dpto.departamentoid
			inner join basic.pais pai on dpto.paisid=pai.paisid
		where dir.direccionid=vdireccionid;
END
$$;


ALTER FUNCTION basic.papersona_direccion_getrow(vdireccionid integer) OWNER TO radiosan_ustaana;

--
-- Name: papersona_direccion_leer(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_direccion_leer(vpersonaid integer) RETURNS SETOF type_persona_direccion_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select dir.direccionid, to_char(dir.registro, 'DD/MM/YYYY HH12:MI AM')::varchar, dir.personaid, dir.tipodireccionid, td.nombre, dir.sucursal, dir.direccion, dir.urbanizacion, dir.referencia, dir.estado, dir.pordefecto,
			(dpto.ubigeo||pro.ubigeo||dis.ubigeo)::varchar,
			(dir.direccion||' - '||dis.nombre||' - '||pro.nombre||' - '||dpto.nombre)::varchar,
			dir.distritoid, dis.nombre, dis.abreviatura, dis.ubigeo, 
			dis.provinciaid, pro.nombre, pro.abreviatura, pro.ubigeo,
			pro.departamentoid, dpto.nombre, dpto.abreviatura, dpto.ubigeo,
			dpto.paisid, pai.nombre, pai.abreviatura, pai.ubigeo
		from basic.persona_direccion dir inner join basic.tipo_direccion td on dir.tipodireccionid=td.tipodireccionid
			inner join basic.distrito dis on dir.distritoid=dis.distritoid
			inner join basic.provincia pro on dis.provinciaid=pro.provinciaid
			inner join basic.departamento dpto on pro.departamentoid=dpto.departamentoid
			inner join basic.pais pai on dpto.paisid=pai.paisid
		where dir.personaid=vpersonaid and dir.personaid>0
		order by dir.orden, dir.direccionid;
END
$$;


ALTER FUNCTION basic.papersona_direccion_leer(vpersonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: papersona_eliminar(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_eliminar(vpersonaid integer, vusuario integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vIDRastro integer default 0; vPermisoId integer default 0;
BEGIN
	if basic.papermisos_proceso_getid(vusuario, 'persona-delete')=0 then
		vPermisoId:=basic.paproceso_getid('persona-delete');
		vState:=false; vID:=0; vError:=1; vDescripcion:=basic.paproceso_getmensaje(vPermisoId);
		if trim(vDescripcion)='' then
			vDescripcion:='No tiene permisos para realizar este proceso';
		end if;
	end if;
	if vstate then
		if exists(select * from basic.personagallery where personaid=vpersonaid) then
			vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar la persona por tener fotos relacionadas.';
		end if;	
	end if;
	if vState then 
		--INICIO RASTRO DELETE
		vIDRastro:=nextval('rastro.personaedit_personaeditid_seq');
		insert into rastro.personaedit values(vIDRastro, vpersonaid, vusuario, 'D', current_timestamp, vip, 1);
		execute rastro.papersonainsert(vIDRastro, 'O');
		--FIN RASTRO DELETE
		
		delete from inventarios.ganancias_metas where vendedorid=vpersonaid;
		delete from basic.grupo_permisos_persona where personaid=vpersonaid;
		delete from basic.permisos_caja where personaid=vpersonaid;
		delete from basic.permisos_modulo where personaid=vpersonaid;
		delete from basic.permisos_empresa where personaid=vpersonaid;
		delete from basic.permisos_unidad_negocio where personaid=vpersonaid;
		delete from basic.menuweb_favoritos where personaid=vpersonaid;
		delete from basic.persona_rol where personaid=vpersonaid;
		delete from basic.persona_socialmedia where personaid=vpersonaid;
		delete from basic.permisos_menuweb where personaid=vpersonaid;
		delete from basic.permisos_proceso where personaid=vpersonaid;
		delete from basic.persona_telefono where personaid=vpersonaid;
		delete from basic.persona_email where personaid=vpersonaid;
		delete from basic.persona_natural where personaid=vpersonaid;
		delete from basic.persona_juridica where personaid=vpersonaid;
		delete from basic.cambiar_clave where personaid=vpersonaid;
		delete from basic.clave where personaid=vpersonaid;
		delete from basic.clave_otros where personaid=vpersonaid;
		delete from basic.persona_direccion where personaid=vpersonaid;
		delete from basic.persona_config where personaid=vpersonaid;
		delete from basic.persona_conductor where personaid=vpersonaid;
		delete from basic.persona where personaid=vpersonaid;
		vID:=vpersonaid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.papersona_eliminar(vpersonaid integer, vusuario integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: papersona_email_leer(integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_email_leer(vpersonaid integer, vpublico character varying) RETURNS SETOF type_persona_email_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select ema.codigo, ema.personaid, ema.tipoemailid, te.nombre, ema.email, ema.nombre, ema.main, ema.publico, te.requerido
		from basic.persona_email ema inner join basic.tipo_email te on ema.tipoemailid=te.tipoemailid
		where ema.personaid=vpersonaid
			and case when trim(vpublico)!='' then ema.publico=(trim(vpublico)='S') else true end
		order by te.orden, ema.codigo
	;
END
$$;


ALTER FUNCTION basic.papersona_email_leer(vpersonaid integer, vpublico character varying) OWNER TO radiosan_ustaana;

--
-- Name: papersona_estado_cuenta(integer, integer, character varying, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_estado_cuenta(vpersonaid integer, vempresaid integer, vmonedaaux character varying, vhasta character varying) RETURNS SETOF type_persona_estado_cuenta
    LANGUAGE plpgsql
    AS $$
declare vmoneda varchar default ''; vmonedabase varchar default basic.moneda_base(); vmonedaextranjera varchar default basic.moneda_extranjera();
	vporcobrar_venta_total numeric default 0; vporcobrar_venta_saldo numeric default 0; vporcobrar_otros_total numeric default 0; vporcobrar_otros_saldo numeric default 0;
	vporpagar_venta_total numeric default 0; vporpagarventasaldo numeric default 0; vporpagarotrostotal numeric default 0; vporpagarotrossaldo numeric default 0; vporpagardocprototal numeric default 0; vporpagardocprosaldo numeric default 0; 
	vsobrante_ingreso_total numeric default 0; vsobrante_ingreso_saldo numeric default 0; vsobrante_egreso_total numeric default 0; vsobrante_egreso_saldo numeric default 0;

	vmonbasporcobrarventatotal numeric default 0; vmonbasporcobrarventasaldo numeric default 0; vmonbasporcobrarotrostotal numeric default 0; vmonbasporcobrarotrossaldo numeric default 0;
	vmonbasporpagarventatotal numeric default 0; vmonbasporpagarventasaldo numeric default 0; vmonbasporpagarotrostotal numeric default 0; vmonbasporpagarotrossaldo numeric default 0; 
	vmonbasporpagardocprototal numeric default 0; vmonbasporpagardocprosaldo numeric default 0;

	vmonextporcobrarventatotal numeric default 0; vmonextporcobrarventasaldo numeric default 0; vmonextporcobrarotrostotal numeric default 0; vmonextporcobrarotrossaldo numeric default 0;
	vmonextporpagarventatotal numeric default 0; vmonextporpagarventasaldo numeric default 0; vmonextporpagarotrostotal numeric default 0; vmonextporpagarotrossaldo numeric default 0;
	vmonextporpagardocprototal numeric default 0; vmonextporpagardocprosaldo numeric default 0;

	vlineacredito numeric default 0;
	vventas_monbas numeric default 0; vventas_monext numeric default 0; vventas_total numeric default 0;
BEGIN	
	vmoneda:=trim(vmonedaaux);
	if trim(vmoneda)='' then
		vmoneda:=basic.moneda_base();
	end if;

	select cli.linea_credito into vlineacredito from inventarios.cliente cli where cli.personaid=vpersonaid;
	select 
		sum(public.convertir_moneda(doc.vta_total, doc.moneda, vmoneda, vmoneda, doc.cambio)), 
		sum(case when doc.moneda=vmonedabase then doc.vta_total else 0 end),
		sum(case when doc.moneda=vmonedaextranjera then doc.vta_total else 0 end)
		into vventas_total, vventas_monbas, vventas_monext
	from inventarios.venta doc
	where doc.estado=true and doc.clienteid=vpersonaid and doc.signo in ('+', '++') and doc.clienteid>0
		and case when vempresaid>0 then doc.empresaid=vempresaid else true end;


	--BEGIN POR COBRAR
	select 
		sum(public.convertir_moneda(doc.vta_total, doc.moneda, vmoneda, vmoneda, doc.cambio)), 
		sum(public.convertir_moneda(doc.saldo, doc.moneda, vmoneda, vmoneda, doc.cambio)),
		sum(case when doc.moneda=vmonedabase then doc.vta_total else 0 end),
		sum(case when doc.moneda=vmonedabase then doc.saldo else 0 end),
		sum(case when doc.moneda=vmonedaextranjera then doc.vta_total else 0 end),
		sum(case when doc.moneda=vmonedaextranjera then doc.saldo else 0 end)
		into vporcobrar_venta_total, vporcobrar_venta_saldo, vmonbasporcobrarventatotal, vmonbasporcobrarventasaldo, vmonextporcobrarventatotal, vmonextporcobrarventasaldo
	from inventarios.venta doc
	where doc.estado=true and doc.clienteid=vpersonaid and doc.signo in ('+', '++') and doc.clienteid>0
		and case when vempresaid>0 then doc.empresaid=vempresaid else true end;

	select 
		sum(public.convertir_moneda(doc.importe, doc.moneda, vmoneda, vmoneda, doc.cambio)), 
		sum(public.convertir_moneda(doc.saldo, doc.moneda, vmoneda, vmoneda, doc.cambio)),
		sum(case when doc.moneda=vmonedabase then doc.importe else 0 end),
		sum(case when doc.moneda=vmonedabase then doc.saldo else 0 end),
		sum(case when doc.moneda=vmonedaextranjera then doc.importe else 0 end),
		sum(case when doc.moneda=vmonedaextranjera then doc.saldo else 0 end)
		into vporcobrar_otros_total, vporcobrar_otros_saldo, vmonbasporcobrarotrostotal, vmonbasporcobrarotrossaldo, vmonextporcobrarotrostotal, vmonextporcobrarotrossaldo
	from tesoreria.porcobrar doc inner join basic.almacen alm on doc.almacenid=alm.almacenid 
	where doc.estado=true and doc.personaid=vpersonaid and doc.signo in ('+') and doc.personaid>0
		and case when vempresaid>0 then doc.empresaid=vempresaid else true end;
	--END POR COBRAR

	--BEGIN POR PAGAR
	select 
		sum(public.convertir_moneda(doc.vta_total, doc.moneda, vmoneda, vmoneda, doc.cambio)), 
		sum(public.convertir_moneda(doc.saldo, doc.moneda, vmoneda, vmoneda, doc.cambio)) ,
		sum(case when doc.moneda=vmonedabase then doc.vta_total else 0 end),
		sum(case when doc.moneda=vmonedabase then doc.saldo else 0 end),
		sum(case when doc.moneda=vmonedaextranjera then doc.vta_total else 0 end),
		sum(case when doc.moneda=vmonedaextranjera then doc.saldo else 0 end)
		into vporpagar_venta_total, vporpagarventasaldo, vmonbasporpagarventatotal, vmonbasporpagarventasaldo, vmonextporpagarventatotal, vmonextporpagarventasaldo
	from inventarios.venta doc
	where doc.estado=true and doc.clienteid=vpersonaid and doc.signo in ('-') and doc.clienteid>0
		and case when vempresaid>0 then doc.empresaid=vempresaid else true end;

	select 
		sum(public.convertir_moneda(doc.importe, doc.moneda, vmoneda, vmoneda, doc.cambio)), 
		sum(public.convertir_moneda(doc.saldo, doc.moneda, vmoneda, vmoneda, doc.cambio)),
		sum(case when doc.moneda=vmonedabase then doc.importe else 0 end),
		sum(case when doc.moneda=vmonedabase then doc.saldo else 0 end),
		sum(case when doc.moneda=vmonedaextranjera then doc.importe else 0 end),
		sum(case when doc.moneda=vmonedaextranjera then doc.saldo else 0 end)
		into vporpagarotrostotal, vporpagarotrossaldo, vmonbasporpagarotrostotal, vmonbasporpagarotrossaldo, vmonextporpagarotrostotal, vmonextporpagarotrossaldo
	from tesoreria.porcobrar doc inner join basic.almacen alm on doc.almacenid=alm.almacenid 
	where doc.estado=true and doc.personaid=vpersonaid and doc.signo in ('-') and doc.personaid>0
		and case when vempresaid>0 then doc.empresaid=vempresaid else true end;

	select 
		sum(public.convertir_moneda(doc.importe_total, doc.moneda, vmoneda, vmoneda, doc.cambio)), 
		sum(public.convertir_moneda(doc.saldo, doc.moneda, vmoneda, vmoneda, doc.cambio)) ,
		sum(case when doc.moneda=vmonedabase then doc.importe_total else 0 end),
		sum(case when doc.moneda=vmonedabase then doc.saldo else 0 end),
		sum(case when doc.moneda=vmonedaextranjera then doc.importe_total else 0 end),
		sum(case when doc.moneda=vmonedaextranjera then doc.saldo else 0 end)
		into vporpagardocprototal, vporpagardocprosaldo, vmonbasporpagardocprototal, vmonbasporpagardocprosaldo, vmonextporpagardocprototal, vmonextporpagardocprosaldo
	from tesoreria.documentos doc
	where doc.estado=true and doc.proveedorid=vpersonaid and doc.proveedorid>0
		and case when vempresaid>0 then doc.empresaid=vempresaid else true end;
	--END POR PAGAR

	--BEGIN SOBRANTE
	select 
		sum(public.convertir_moneda((case when doc.tipo='I' then doc.importe else 0 end), doc.moneda, vmoneda, vmoneda, doc.cambio)),
		sum(public.convertir_moneda((case when doc.tipo='I' then doc.saldo else 0 end), doc.moneda, vmoneda, vmoneda, doc.cambio)),
		sum(public.convertir_moneda((case when doc.tipo='E' then doc.importe else 0 end), doc.moneda, vmoneda, vmoneda, doc.cambio)),
		sum(public.convertir_moneda((case when doc.tipo='E' then doc.saldo else 0 end), doc.moneda, vmoneda, vmoneda, doc.cambio))
		into
		vsobrante_ingreso_total, vsobrante_ingreso_saldo, vsobrante_egreso_total, vsobrante_egreso_saldo
	from tesoreria.cajaplanilla_detalle doc inner join tesoreria.cajaplanilla pla on doc.planillaid=pla.planillaid
		inner join tesoreria.caja caj on pla.cajaid=caj.cajaid
		inner join basic.almacen alm on caj.almacenid=alm.almacenid 
	where doc.estado=true and doc.personaid=vpersonaid and incluirctacte=true
		and case when vempresaid>0 then doc.empresaid=vempresaid else true end;
	--END SOBRANTE
	
	return query 
		select coalesce(vlineacredito, 0)::numeric, coalesce(vventas_total, 0)::numeric, coalesce(vventas_monbas, 0)::numeric, coalesce(vventas_monext, 0)::numeric,
			--TODO POR COBRAR
			coalesce(vporcobrar_venta_total, 0)::numeric, coalesce(vporcobrar_venta_saldo, 0)::numeric, coalesce(vporcobrar_otros_total, 0)::numeric, coalesce(vporcobrar_otros_saldo, 0)::numeric,
			(coalesce(vporcobrar_venta_total, 0)+coalesce(vporcobrar_otros_total, 0))::numeric, (coalesce(vporcobrar_venta_saldo, 0)+coalesce(vporcobrar_otros_saldo, 0))::numeric,

			--TODO POR PAGAR
			coalesce(vporpagar_venta_total, 0)::numeric, coalesce(vporpagarventasaldo, 0)::numeric, coalesce(vporpagarotrostotal, 0)::numeric, coalesce(vporpagarotrossaldo, 0)::numeric, coalesce(vporpagardocprototal, 0)::numeric, coalesce(vporpagardocprosaldo, 0)::numeric,
			(coalesce(vporpagar_venta_total, 0)+coalesce(vporpagarotrostotal, 0)+coalesce(vporpagardocprototal, 0))::numeric, (coalesce(vporpagarventasaldo, 0)+coalesce(vporpagarotrossaldo, 0)+coalesce(vporpagardocprosaldo, 0))::numeric,

			--TODO SOBRANTE
			coalesce(vsobrante_ingreso_total, 0)::numeric, coalesce(vsobrante_ingreso_saldo, 0)::numeric, coalesce(vsobrante_egreso_total, 0)::numeric, coalesce(vsobrante_egreso_saldo, 0)::numeric,

			--SOBRANTE SALDO
			(coalesce(vsobrante_ingreso_saldo, 0)+coalesce(vsobrante_egreso_saldo, 0))::numeric,

			--MONEDA BASE POR COBRAR
			coalesce(vmonbasporcobrarventatotal, 0)::numeric, coalesce(vmonbasporcobrarventasaldo, 0)::numeric, coalesce(vmonbasporcobrarotrostotal, 0)::numeric, coalesce(vmonbasporcobrarotrossaldo, 0)::numeric,
			(coalesce(vmonbasporcobrarventatotal, 0)+coalesce(vmonbasporcobrarotrostotal, 0))::numeric, (coalesce(vmonbasporcobrarventasaldo, 0)+coalesce(vmonbasporcobrarotrossaldo, 0))::numeric,			
			
			coalesce(vmonbasporpagarventatotal, 0)::numeric, coalesce(vmonbasporpagarventasaldo,0)::numeric, coalesce(vmonbasporpagarotrostotal, 0)::numeric, coalesce(vmonbasporpagarotrossaldo, 0)::numeric, 
			coalesce(vmonbasporpagardocprototal, 0)::numeric, coalesce(vmonbasporpagardocprosaldo, 0)::numeric,
			(coalesce(vmonbasporpagarventatotal, 0)+coalesce(vmonbasporpagarotrostotal, 0)+coalesce(vmonbasporpagardocprototal, 0))::numeric, (coalesce(vmonbasporpagarventasaldo, 0)+coalesce(vmonbasporpagarotrossaldo, 0)+coalesce(vmonbasporpagardocprosaldo, 0))::numeric,

			--MONEDA EXTRANJERA
			coalesce(vmonextporcobrarventatotal, 0)::numeric, coalesce(vmonextporcobrarventasaldo, 0)::numeric, coalesce(vmonextporcobrarotrostotal, 0)::numeric, coalesce(vmonextporcobrarotrossaldo, 0)::numeric,
			(coalesce(vmonextporcobrarventatotal, 0)+coalesce(vmonextporcobrarotrostotal, 0))::numeric, (coalesce(vmonextporcobrarventasaldo, 0)+coalesce(vmonextporcobrarotrossaldo, 0))::numeric,

			coalesce(vmonextporpagarventatotal, 0)::numeric, coalesce(vmonextporpagarventasaldo,0)::numeric, coalesce(vmonextporpagarotrostotal, 0)::numeric, coalesce(vmonextporpagarotrossaldo, 0)::numeric, 
			coalesce(vmonextporpagardocprototal, 0)::numeric, coalesce(vmonextporpagardocprosaldo, 0)::numeric,
			(coalesce(vmonextporpagarventatotal, 0)+coalesce(vmonextporpagarotrostotal, 0)+coalesce(vmonextporpagardocprototal, 0))::numeric, (coalesce(vmonextporpagarventasaldo, 0)+coalesce(vmonextporpagarotrossaldo, 0)+coalesce(vmonextporpagardocprosaldo, 0))::numeric
			;
END
$$;


ALTER FUNCTION basic.papersona_estado_cuenta(vpersonaid integer, vempresaid integer, vmonedaaux character varying, vhasta character varying) OWNER TO radiosan_ustaana;

--
-- Name: papersona_generar_usuario(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_generar_usuario(vpersonaid integer) RETURNS character varying
    LANGUAGE plpgsql
    AS $$
declare vUsuario varchar default ''; vUsuarioTmp varchar default ''; myRow record; vContador integer default 0;
begin
	select p.personaid, p.tipo, coalesce(pn.ape_pat,'')::varchar as ape_pat, coalesce(pn.ape_mat, '')::varchar as ape_mat, coalesce(pn.nombre, '')::varchar as nombre, coalesce(pj.raz_soc, '')::varchar as raz_soc into myRow from basic.persona p left join basic.persona_natural pn on p.personaid=pn.personaid left join basic.persona_juridica pj on p.personaid=pj.personaid where p.personaid=vpersonaid;
	vUsuario:=upper(substring(trim(myRow.nombre) from 1 for 1) || substring(trim(translate(myRow.ape_pat,' ','')) from 1 for 16) || substring(trim(myRow.ape_mat) from 1 for 1));
	raise notice 'Usuario: %', vUsuario;
	if vUsuario!='' then
		vUsuario:=translate(vUsuario, 'àèìòùáéíóúÀÈÌÒÙÁÉÍÓÚçÇñÑ','aeiouaeiouAEOIUAEIOUcCnN');
		vUsuarioTmp:=vUsuario;	
		vContador:=1;
		loop
			if not exists(select personaid from basic.clave_otros where trim(usuario)=trim(vUsuarioTmp) and personaid!=vpersonaid) then
				exit;
			else
				vContador:=vContador+1;
				vUsuarioTmp:=vUsuario || trim(cast(vContador as varchar));
			end if;
		end loop;
		vUsuario=vUsuarioTmp;
	end if;
	return vUsuario;
end 
$$;


ALTER FUNCTION basic.papersona_generar_usuario(vpersonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: papersona_getdeuda(integer, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_getdeuda(vpersonaid integer, vempresaid integer) RETURNS SETOF type_persona_getdeuda
    LANGUAGE plpgsql
    AS $$
declare vmonedabase varchar default basic.moneda_base(); vmonedaextranjera varchar default basic.moneda_extranjera();
BEGIN
	return query 
		select 
			inventarios.paventas_gettotalbypesona(vpersonaid, vempresaid, vmonedabase),
			inventarios.paventas_gettotalbypesona(vpersonaid, vempresaid, vmonedaextranjera),
			basic.papersona_getporcobrar(vpersonaid, vempresaid, vmonedabase), 
			basic.papersona_getporcobrar(vpersonaid, vempresaid, vmonedaextranjera),
			tesoreria.papersona_getsaldoanticipos(vpersonaid, vempresaid, vmonedabase, 'I'),
			tesoreria.papersona_getsaldoanticipos(vpersonaid, vempresaid, vmonedaextranjera, 'I'),

			tesoreria.padocumentos_gettotalbypesona(vpersonaid, vempresaid, vmonedabase),
			tesoreria.padocumentos_gettotalbypesona(vpersonaid, vempresaid, vmonedaextranjera),
			basic.papersona_getporpagar(vpersonaid, vempresaid, vmonedabase), 
			basic.papersona_getporpagar(vpersonaid, vempresaid, vmonedaextranjera),
			tesoreria.papersona_getsaldoanticipos(vpersonaid, vempresaid, vmonedabase, 'E'),
			tesoreria.papersona_getsaldoanticipos(vpersonaid, vempresaid, vmonedaextranjera, 'E');
END
$$;


ALTER FUNCTION basic.papersona_getdeuda(vpersonaid integer, vempresaid integer) OWNER TO radiosan_ustaana;

--
-- Name: papersona_getemailmain(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_getemailmain(vpersonaid integer) RETURNS character varying
    LANGUAGE plpgsql
    AS $$
declare vEmail varchar default '';
BEGIN
	if vpersonaid>0 then
		select ema.email into vEmail from basic.persona_email ema where ema.personaid=vpersonaid and ema.main=true;
		vEmail:=coalesce(vEmail, '');
		if trim(vEmail)='' then
			if exists(select * from basic.persona_email ema where ema.personaid=vpersonaid) then
				select ema.email into vEmail from basic.persona_email ema where ema.personaid=vpersonaid limit 1;
			end if;
		end if;
	end if;
	return coalesce(vEmail, '');
END
$$;


ALTER FUNCTION basic.papersona_getemailmain(vpersonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: papersona_getidbydni(character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_getidbydni(vdni character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vPersonaId integer default 0;
BEGIN
	if trim(vdni)!='' then
		select personaid into vPersonaId from basic.persona_natural pn where trim(upper(pn.dni))=trim(upper(vdni));
	end if;
	return coalesce(vPersonaId, 0)::integer;
END
$$;


ALTER FUNCTION basic.papersona_getidbydni(vdni character varying) OWNER TO radiosan_ustaana;

--
-- Name: papersona_getidbyruc(character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_getidbyruc(vruc character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vPersonaId integer default 0;
BEGIN
	if trim(vruc)!='' then
		select pj.personaid into vPersonaId from basic.persona_juridica pj where trim(upper(pj.ruc))=trim(upper(vruc));
		vPersonaId:=coalesce(vPersonaId, 0);
		if vPersonaId=0 then
			select pn.personaid into vPersonaId from basic.persona_natural pn where trim(upper(pn.ruc))=trim(upper(vruc));
			vPersonaId:=coalesce(vPersonaId, 0);
		end if;
	end if;
	return coalesce(vPersonaId, 0)::integer;
END
$$;


ALTER FUNCTION basic.papersona_getidbyruc(vruc character varying) OWNER TO radiosan_ustaana;

--
-- Name: papersona_getnombre(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_getnombre(inpersonaid integer) RETURNS character varying
    LANGUAGE plpgsql
    AS $$
declare vNombre varchar default ''; vTipo varchar default 'N';
BEGIN
	if inpersonaid>0 then
		if exists(select * from basic.persona where personaid=inpersonaid) then
			select tipo into vTipo from basic.persona where personaid=inpersonaid;
			vTipo:=coalesce(vTipo, 'N');
			if(trim(vTipo)='') then
				vTipo='N';
			end if;
			if vTipo='N' then 
				select upper(ape_pat ||' '|| ape_mat ||', '|| nombre) into vNombre from basic.persona_natural where personaid=inpersonaid;
			else
				select upper(raz_soc) into vNombre from basic.persona_juridica where personaid=inpersonaid;
			end if;
		end if;
	end if;
	return coalesce(vNombre, '')::varchar;
END
$$;


ALTER FUNCTION basic.papersona_getnombre(inpersonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: papersona_getpaisid(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_getpaisid(vpersonaid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vpaisid integer default 0;
BEGIN
	select dpto.paisid into vpaisid from basic.persona per inner join basic.distrito dis on per.distritoid=dis.distritoid inner join basic.provincia pro on dis.provinciaid=pro.provinciaid inner join basic.departamento dpto on pro.departamentoid=dpto.departamentoid where per.personaid=vpersonaid;
	return coalesce(vpaisid, 0);
END
$$;


ALTER FUNCTION basic.papersona_getpaisid(vpersonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: papersona_getporcobrar(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_getporcobrar(vpersonaid integer, vempresaid integer, vmoneda character varying) RETURNS numeric
    LANGUAGE plpgsql
    AS $$
declare vdeuda numeric default 0;
BEGIN
	if vpersonaid>0 then
		select sum(doc.saldo) into vdeuda
		from inventarios.venta doc
		where doc.clienteid=vpersonaid and doc.moneda=vmoneda and doc.estado=true
			and case when vempresaid>0 then doc.empresaid=vempresaid else true end;
	end if;
	return coalesce(vdeuda, 0);
END
$$;


ALTER FUNCTION basic.papersona_getporcobrar(vpersonaid integer, vempresaid integer, vmoneda character varying) OWNER TO radiosan_ustaana;

--
-- Name: papersona_getporpagar(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_getporpagar(vpersonaid integer, vempresaid integer, vmoneda character varying) RETURNS numeric
    LANGUAGE plpgsql
    AS $$
declare vdeuda numeric default 0;
BEGIN
	if vpersonaid>0 then
		select sum(doc.saldo) into vdeuda
		from tesoreria.documentos doc
		where doc.proveedorid=vpersonaid and doc.moneda=vmoneda and doc.estado=true
			and case when vempresaid>0 then doc.empresaid=vempresaid else true end;
	end if;
	return coalesce(vdeuda, 0);
END
$$;


ALTER FUNCTION basic.papersona_getporpagar(vpersonaid integer, vempresaid integer, vmoneda character varying) OWNER TO radiosan_ustaana;

--
-- Name: papersona_getrol(integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_getrol(vpersonaid integer, vseperador character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $$
declare vResultado varchar default ''; myRow record; vseperadoraux varchar default '';
BEGIN
	vseperadoraux:=vseperador;
	if(trim(vseperadoraux)='') then
		vseperadoraux=', ';
	end if;
	for myRow in select r.nombre from basic.persona_rol pr inner join basic.rol r on pr.rolid=r.rolid where pr.personaid=vpersonaid loop
		vResultado:=vResultado || myRow.nombre || vseperadoraux;
	end loop;
	if trim(vResultado)!='' then
		vResultado:=substring(vResultado, 0, char_length(vResultado)- (char_length(vseperadoraux)-1));
	end if;
	return vResultado;
END
$$;


ALTER FUNCTION basic.papersona_getrol(vpersonaid integer, vseperador character varying) OWNER TO radiosan_ustaana;

--
-- Name: papersona_getrow(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_getrow(vpersonaid integer) RETURNS SETOF type_persona_getrow
    LANGUAGE plpgsql
    AS $$
declare vCountLicencias integer default 0; vmonedabase varchar default basic.moneda_base(); vmonedaextranjera varchar default basic.moneda_extranjera();
BEGIN
	select count(*) into vCountLicencias from basic.licencia_conducir where personaid=vpersonaid;
	return query 
		select p.personaid, p.tipo::varchar, p.rol, p.direccion, p.telefono, p.email, p.estado, to_char(p.registro,'DD/MM/YYYY HH12:MI AM')::varchar, p.distritoid, p.foto, p.nombre_comercial,
			coalesce(pn.titulo,'')::varchar, coalesce(pn.ape_pat,'')::varchar, coalesce(pn.ape_mat,'')::varchar, coalesce(pn.nombre,'')::varchar, 
			coalesce(pn.nacimiento,current_date)::date, coalesce(pn.dni,'')::varchar, coalesce(pn.ruc,'')::varchar, coalesce(pn.sexo,'')::varchar, coalesce(pn.est_civil,'')::varchar, 
			coalesce(pj.raz_soc,'')::varchar, coalesce(pj.ruc,'')::varchar, 
			d.nombre, d.abreviatura, d.ubigeo, d.provinciaid, pro.nombre, pro.abreviatura, pro.ubigeo, pro.departamentoid, dpto.nombre, dpto.abreviatura, dpto.ubigeo, 
			upper(coalesce(pn.ape_pat,''))::varchar, upper(coalesce(pn.ape_mat,''))::varchar, upper(coalesce(pn.nombre,''))::varchar,
			initcap(coalesce(pn.ape_pat,''))::varchar, initcap(coalesce(pn.ape_mat,''))::varchar, initcap(coalesce(pn.nombre,''))::varchar, to_char(coalesce(pn.nacimiento,current_date), 'DD/MM/YYYY')::varchar,
			coalesce(pcond.licencia, '')::varchar, coalesce(vCountLicencias, 0)::integer,
			0::numeric, 0::numeric, 0::numeric, 0::numeric
		from basic.persona p left join basic.persona_natural pn on p.personaid=pn.personaid
			left join basic.persona_juridica pj on p.personaid=pj.personaid
			left join basic.distrito d on p.distritoid=d.distritoid
			left join basic.provincia pro on d.provinciaid=pro.provinciaid
			left join basic.departamento dpto on pro.departamentoid=dpto.departamentoid
			left join basic.persona_conductor pcond on p.personaid=pcond.personaid
		where p.personaid=vpersonaid;
END
$$;


ALTER FUNCTION basic.papersona_getrow(vpersonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: papersona_gettelefonomain(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_gettelefonomain(vpersonaid integer) RETURNS character varying
    LANGUAGE plpgsql
    AS $$
declare vTelefono varchar default ''; 
BEGIN
	if vpersonaid>0 then
		select tel.numero into vTelefono from basic.persona_telefono tel where tel.personaid=vpersonaid and tel.main=true;
		vTelefono:=coalesce(vTelefono, '');
		if trim(vTelefono)='' then
			if exists(select * from basic.persona_telefono tel where tel.personaid=vpersonaid) then
				select tel.numero into vTelefono from basic.persona_telefono tel where tel.personaid=vpersonaid limit 1;
			end if;
		end if;
	end if;
	return vTelefono;
END
$$;


ALTER FUNCTION basic.papersona_gettelefonomain(vpersonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: papersona_getusuario(integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_getusuario(vpersonaid integer, vtipo character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $$
declare vUsuario varchar default '';
BEGIN
	if vtipo='sistema' then
		select usuario into vUsuario from basic.clave where personaid=vpersonaid;
	else
		--select usuario into vUsuario from basic.clave_otros where personaid=vpersonaid;
	end if;
	return coalesce(vUsuario, '');
END
$$;


ALTER FUNCTION basic.papersona_getusuario(vpersonaid integer, vtipo character varying) OWNER TO radiosan_ustaana;

--
-- Name: papersona_leer(integer, integer, character varying, character varying, character varying, character varying, character varying, character varying, integer[], character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_leer(vinicio integer, vfin integer, vapepat character varying, vapemat character varying, vnombre character varying, vsexo character varying, vestado character varying, vconfoto character varying, arrrol integer[], vorderby character varying) RETURNS SETOF type_persona_leer
    LANGUAGE plpgsql
    AS $$
declare swSinRol boolean default false; swRoles boolean default false;
BEGIN
	drop table if exists tmp_rol, tmp_per_rol, tmp_per_sinrol cascade;
	create temporary table tmp_rol(rolid integer not null);
	create temporary table tmp_per_rol(personaid integer not null);
	create temporary table tmp_per_sinrol(personaid integer not null);
	if not arrRol[1] is null then
		insert into tmp_rol select arrRol[i] from generate_series(1, array_upper(arrRol, 1)) as i;
		swRoles:=exists(select * from tmp_rol where rolid>0);
		swSinRol:=exists(select * from tmp_rol where rolid=0);
	end if;
	insert into tmp_per_rol select pr.personaid from tmp_rol tmp inner join basic.persona_rol pr on tmp.rolid=pr.rolid group by 1;
	insert into tmp_per_sinrol select p.personaid from basic.persona p left join basic.persona_rol pr on p.personaid=pr.personaid where pr.personaid is null group by 1;
	
	raise notice '%, %', swRoles, swSinRol;
	return query
		select p.personaid, p.tipo, 
			(case when p.tipo='J' then pj.ruc else pn.dni end)::varchar,
			(case when p.tipo='J' then coalesce(pj.raz_soc,'') else (coalesce(pn.ape_pat,'') || ' ' || coalesce(pn.ape_mat,'') || ', ' || coalesce(pn.nombre,'')) end)::varchar, 
			p.direccion, p.telefono, p.email, p.rol, coalesce(pn.sexo,'M')::varchar, p.foto, (case when pn.nacimiento is null then '' else to_char(pn.nacimiento, 'DD/MM/YYYY') end)::varchar,
			p.estado--, pr.*, psr.*
		from basic.persona p left join tmp_per_rol pr on p.personaid=pr.personaid
			left join tmp_per_sinrol psr on p.personaid=psr.personaid
				left join basic.persona_natural pn on p.personaid=pn.personaid
				left join basic.persona_juridica pj on p.personaid=pj.personaid
		where p.personaid>0
			and case when (swRoles and swSinRol) then (not pr.personaid is null or not psr.personaid is null) when swRoles then not pr.personaid is null when swSinRol then not psr.personaid is null else true end
			and case when trim(vApePat)!='' then upper(buscar(pn.ape_pat)) like '%' || upper(buscar(vApePat)) || '%' or upper(buscar(pj.raz_soc)) like '%' || upper(buscar(vApePat)) || '%' else true end 
			and case when trim(vApeMat)!='' then upper(buscar(pn.ape_mat)) like '%' || upper(buscar(vApeMat)) || '%' else true end 
			and case when trim(vNombre)!='' then upper(buscar(pn.nombre)) like '%' || upper(buscar(vNombre)) || '%' else true end 
			and case when trim(vSexo)!='' then coalesce(pn.sexo, 'M')=trim(vSexo) else true end 
			and case when trim(vestado)!='' then p.estado=(trim(vestado)='Y') else true end 
			and case when trim(vconfoto)='Y' then trim(p.foto)!='' else true end 
			and case when trim(vconfoto)='N' then trim(p.foto)='' else true end 
		order by 
			case when vorderby='codigo' then p.personaid else 0 end desc, 4
		limit case when vinicio=0 and vfin=0 then null else vfin end offset vinicio;
	drop table if exists tmp_rol, tmp_per_rol, tmp_per_sinrol cascade;
END
$$;


ALTER FUNCTION basic.papersona_leer(vinicio integer, vfin integer, vapepat character varying, vapemat character varying, vnombre character varying, vsexo character varying, vestado character varying, vconfoto character varying, arrrol integer[], vorderby character varying) OWNER TO radiosan_ustaana;

--
-- Name: papersona_leer_saldos(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_leer_saldos(vpersonaid integer) RETURNS SETOF type_persona_leer_saldos
    LANGUAGE plpgsql
    AS $$
declare vLineaCredito numeric default 0; vDeuda numeric default 0; vPagoAdelantado numeric default 0; vDisponible numeric default 0;
	vMonedaBase varchar default basic.moneda_base(); vIDPagAde integer default 0; vIdAmorCXC integer default 0; 
BEGIN

	select cli.linea_credito into vLineaCredito from inventarios.cliente cli where cli.personaid=vpersonaid;
	vLineaCredito:= coalesce(vLineaCredito, 0);

	/*
	vIDPagAde:=tesoreria.conf_codigo_concepto_ing_pago_adelantado();
	vIdAmorCXC:=tesoreria.conf_codigo_concepto_amortizacion_cxc();
	select sum(tesoreria.convertir_moneda(doc.saldo, doc.moneda, vMoneda_Base, vMoneda_Base, doc.cambio)) into vDeuda 
	from tesoreria.porcobrar doc where doc.personaid=vpersonaid and doc.estado=true
		and case when valmacenid>0 then doc.almacenid=valmacenid else true end;
	vDeuda:=coalesce(vDeuda, 0);
	
	select round(sum(tesoreria.convertir_moneda(doc.importe-tesoreria.total_utilizado_movban(doc.movbanid,''), doc.moneda, vMoneda_Base, vMoneda_Base, doc.cambio)),2) into vPagoAdelantado 
	from tesoreria.movimiento_bancario doc 
	where doc.personaid=vpersonaid and doc.estado=true and doc.tipo='I' and doc.tipmovbanid in (vIDPagAde, vIdAmorCXC)
		and case when valmacenid>0 then doc.almacenid=valmacenid else true end;
	vPagoAdelantado:= coalesce(vPagoAdelantado, 0);
	*/

	vDisponible:=vLineaCredito + vPagoAdelantado - vDeuda;
	return query select coalesce(vLineaCredito,0), coalesce(vDeuda,0), coalesce(vPagoAdelantado,0), coalesce(vDisponible,0);
END
$$;


ALTER FUNCTION basic.papersona_leer_saldos(vpersonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: papersona_non_grupo_permisos(integer, integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_non_grupo_permisos(vfirst integer, vlast integer, vcodigo integer, vnombre character varying) RETURNS SETOF type_persona_non_grupo_permisos
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp_rol, tmp_per cascade;
	create temporary table tmp_rol(rolid integer not null);
	create temporary table tmp_per(personaid integer not null);
	
	insert into tmp_rol select rolid from basic.rol where estructura='EMP';
	insert into tmp_per select personaid from basic.persona_rol pr inner join tmp_rol tmp on pr.rolid=tmp.rolid;
	
	return query 
		select p.personaid, (case when p.tipo='J' then coalesce(pj.raz_soc,'') else (coalesce(pn.ape_pat,'') || ' ' || coalesce(pn.ape_mat,'') || ', ' || coalesce(pn.nombre,'')) end)::varchar, coalesce(pn.sexo, 'M'), p.foto, p.email, p.telefono, p.rol, coalesce(c.usuario, '')::varchar
		from tmp_per tmp inner join basic.persona p on tmp.personaid=p.personaid
			left join basic.grupo_permisos_persona gpp on p.personaid=gpp.personaid and vcodigo=gpp.codigo			
				left join basic.persona_natural pn on p.personaid=pn.personaid
				left join basic.persona_juridica pj on p.personaid=pj.personaid
			left join basic.clave c on p.personaid=c.personaid
		where gpp.personaid is null and p.personaid>0
			and case when trim(upper(vnombre))!='' then 
				(
					upper(buscar(pn.ape_pat)) like ('%' || trim(upper(buscar(vnombre))) || '%') 
					or upper(buscar(pn.ape_pat||' '||pn.ape_mat||' '||pn.nombre)) like ('%' || trim(upper(buscar(vnombre))) || '%')
					or upper(buscar(pn.nombre||' '||pn.ape_pat||' '||pn.ape_mat)) like ('%' || trim(upper(buscar(vnombre))) || '%')
					or trim(cast(p.personaid as varchar)) = trim(upper(buscar(vnombre)))
					or upper(buscar(p.email)) like ('%' || trim(upper(buscar(vnombre))) || '%') 
					or upper(buscar(p.telefono)) like ('%' || trim(upper(buscar(vnombre))) || '%') 
					or upper(buscar(pn.dni)) like ('%' || trim(upper(buscar(vnombre))) || '%')
					or upper(buscar(pn.ruc)) like ('%' || trim(upper(buscar(vnombre))) || '%')
					or upper(buscar(pj.ruc)) like ('%' || trim(upper(buscar(vnombre))) || '%')
					or upper(buscar(pj.raz_soc)) like ('%' || trim(upper(buscar(vnombre))) || '%')
				) 
				else true end
		order by 2
		limit case when vfirst=0 and vlast=0 then null else vlast end offset vfirst;
		
	drop table if exists tmp_rol, tmp_per cascade;
END
$$;


ALTER FUNCTION basic.papersona_non_grupo_permisos(vfirst integer, vlast integer, vcodigo integer, vnombre character varying) OWNER TO radiosan_ustaana;

--
-- Name: papersona_proceso_leer(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_proceso_leer(vpersonaid integer) RETURNS SETOF type_persona_proceso_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select p.nombre
		from basic.permisos_proceso pp inner join basic.proceso p on pp.procesoid=p.procesoid
		where pp.personaid=vpersonaid
		order by 1
	;
END
$$;


ALTER FUNCTION basic.papersona_proceso_leer(vpersonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: papersona_rol_leer(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_rol_leer(vpersonaid integer) RETURNS SETOF type_persona_rol_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select pr.personaid, pr.rolid, r.nombre
		from basic.persona_rol pr inner join basic.rol r on pr.rolid=r.rolid
		where pr.personaid=vpersonaid
		order by r.orden
	;
END
$$;


ALTER FUNCTION basic.papersona_rol_leer(vpersonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: papersona_socialmedia_leer(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_socialmedia_leer(vpersonaid integer) RETURNS SETOF type_persona_socialmedia_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select sm.personaid, sm.tiposocialmediaid, t.nombre, t.url, sm.url
		from basic.persona_socialmedia sm inner join basic.tipo_socialmedia t on sm.tiposocialmediaid=t.tiposocialmediaid
		where sm.personaid=vpersonaid
		order by t.orden, t.tiposocialmediaid;
END
$$;


ALTER FUNCTION basic.papersona_socialmedia_leer(vpersonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: papersona_telefono_leer(integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_telefono_leer(vpersonaid integer, vpublico character varying) RETURNS SETOF type_persona_telefono_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select pho.codigo, pho.personaid, pho.tipotelefonoid, tt.nombre, pho.numero, pho.nombre, pho.main, pho.publico, tt.requerido
		from basic.persona_telefono pho inner join basic.tipo_telefono tt on pho.tipotelefonoid=tt.tipotelefonoid
		where pho.personaid=vpersonaid
			and case when trim(vpublico)!='' then pho.publico=(trim(vpublico)='S') else true end
		order by tt.orden, pho.codigo
	;
END
$$;


ALTER FUNCTION basic.papersona_telefono_leer(vpersonaid integer, vpublico character varying) OWNER TO radiosan_ustaana;

--
-- Name: papersona_tiene_tipdocid(integer, character varying, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_tiene_tipdocid(vpersonaid integer, vtipo character varying, vtipdocid integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $$
declare vresultado boolean default false;
BEGIN
	--vtipdocid (PUEDE SERVIR EN EL FUTUTO)
	if trim(vtipo)='DNI' then
		vresultado:=exists(select * from basic.persona_natural pn where pn.personaid=vpersonaid and trim(upper(pn.dni))!='' and length(trim(upper(pn.dni)))=8);
	elseif trim(vtipo)='RUC' then
		vresultado:=exists(select * from basic.persona_juridica pj where pj.personaid=vpersonaid and trim(upper(pj.ruc))!='' and length(trim(upper(pj.ruc)))=11);
		if not vresultado then
			vresultado:=exists(select * from basic.persona_natural pn where pn.personaid=vpersonaid and trim(upper(pn.ruc))!='' and length(trim(upper(pn.ruc)))=11);
		end if;
	end if;
	return coalesce(vresultado, false)::boolean;
END
$$;


ALTER FUNCTION basic.papersona_tiene_tipdocid(vpersonaid integer, vtipo character varying, vtipdocid integer) OWNER TO radiosan_ustaana;

--
-- Name: papersona_tipoid_getnumero(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_tipoid_getnumero(vpersonaid integer) RETURNS character varying
    LANGUAGE plpgsql
    AS $$
declare vrpta varchar default '';
BEGIN
	if exists(select * from basic.persona_tipoid id where id.personaid=vpersonaid and id.main=true) then
		select id.numero into vrpta from basic.persona_tipoid id where id.personaid=vpersonaid and id.main=true;
	else
		select id.numero into vrpta from basic.persona_tipoid id where id.personaid=vpersonaid;
	end if;
	return trim(coalesce(vrpta,''))::varchar;
END;
$$;


ALTER FUNCTION basic.papersona_tipoid_getnumero(vpersonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: papersona_tipoid_gettipoid(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_tipoid_gettipoid(vpersonaid integer) RETURNS character varying
    LANGUAGE plpgsql
    AS $$
declare vrpta integer default 0;
BEGIN
	if exists(select * from basic.persona_tipoid id where id.personaid=vpersonaid and id.main=true) then
		select id.tipoid into vrpta from basic.persona_tipoid id where id.personaid=vpersonaid and id.main=true;
	else
		select id.tipoid into vrpta from basic.persona_tipoid id where id.personaid=vpersonaid;
	end if;
	return coalesce(vrpta,0)::integer;
END;
$$;


ALTER FUNCTION basic.papersona_tipoid_gettipoid(vpersonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: papersona_tipoid_leer(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersona_tipoid_leer(vpersonaid integer) RETURNS SETOF type_persona_tipoid_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select doc.personaid, doc.tipoid, tid.nombre, doc.numero, doc.main
		from basic.persona_tipoid doc inner join basic.tipoid tid on doc.tipoid=tid.tipoid
		where doc.personaid=vpersonaid
		order by tid.orden;
END
$$;


ALTER FUNCTION basic.papersona_tipoid_leer(vpersonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: papersonagallery_add(integer, character varying, integer, integer, integer, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersonagallery_add(inpersonaid integer, infilename character varying, inwidth integer, inheight integer, indpi integer, insize integer) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vpersonaid integer default 0; 
BEGIN
	if exists(select * from basic.personagallery g where trim(upper(buscar(g.filename)))=trim(upper(buscar(infilename))) and personaid=inpersonaid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre del archivo ya existe. Intentelo nuevamente.';
	end if;
	If vState Then
		insert into basic.personagallery values(default, inpersonaid, current_timestamp, trim(infilename), inwidth, inheight, indpi, insize, basic.papersonagallery_lastorder(inpersonaid) + 1, true, current_timestamp);
		vID:=lastval();
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.papersonagallery_add(inpersonaid integer, infilename character varying, inwidth integer, inheight integer, indpi integer, insize integer) OWNER TO radiosan_ustaana;

--
-- Name: papersonagallery_change_order(integer, integer[]); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersonagallery_change_order(vpersonaid integer, myarr integer[]) RETURNS void
    LANGUAGE plpgsql
    AS $$
declare myRow record;
BEGIN
	for myRow in select myarr[i] as id, i as orden from generate_series(1, array_upper(myarr, 1)) as i loop
		update basic.personagallery set "order"=myRow.orden where personagalleryid=myRow.id;
	end loop;
END
$$;


ALTER FUNCTION basic.papersonagallery_change_order(vpersonaid integer, myarr integer[]) OWNER TO radiosan_ustaana;

--
-- Name: papersonagallery_delete(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersonagallery_delete(inpersonagalleryid integer) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if vState then
		delete from basic.personagallery where personagalleryid=inpersonagalleryid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.papersonagallery_delete(inpersonagalleryid integer) OWNER TO radiosan_ustaana;

--
-- Name: papersonagallery_getrow(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersonagallery_getrow(vpersonagalleryid integer) RETURNS SETOF type_personagallery_getrow
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select i.personagalleryid, i.personaid, to_char(i.registro, 'DD/MM/YYYY HH12:MI AM')::varchar, i.filename, i.width, i.height, i.dpi, i.size, i.order, i.status, to_char(i.lastchange, 'YYYYMMDDHH24MISS')::varchar
		from basic.personagallery i where i.personagalleryid=vpersonagalleryid;
END
$$;


ALTER FUNCTION basic.papersonagallery_getrow(vpersonagalleryid integer) OWNER TO radiosan_ustaana;

--
-- Name: papersonagallery_lastorder(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersonagallery_lastorder(vpersonaid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vOrden integer default 0;
BEGIN
	select max("order") into vOrden from basic.personagallery m where m.personaid=vpersonaid;
	return coalesce(vOrden, 0);
END
$$;


ALTER FUNCTION basic.papersonagallery_lastorder(vpersonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: papersonagallery_read(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersonagallery_read(vpersonaid integer) RETURNS SETOF type_personagallery_read
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select i.personagalleryid, i.personaid, to_char(i.registro, 'DD/MM/YYYY HH12:MI AM')::varchar, i.filename, i.width, i.height, i.dpi, i.size, i.order, i.status, to_char(i.lastchange, 'YYYYMMDDHH24MISS')::varchar
		from basic.personagallery i where i.personaid=vpersonaid order by i.order;
END
$$;


ALTER FUNCTION basic.papersonagallery_read(vpersonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: papersonagallery_rotate(integer, character varying, integer, integer, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersonagallery_rotate(vpersonagalleryid integer, vfilename character varying, vwidth integer, vheight integer, vsize integer) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if vState then
		update basic.personagallery set width=vwidth, height=vheight, size=vsize, lastchange=current_timestamp where personagalleryid=vpersonagalleryid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.papersonagallery_rotate(vpersonagalleryid integer, vfilename character varying, vwidth integer, vheight integer, vsize integer) OWNER TO radiosan_ustaana;

--
-- Name: papersonagallery_setdefault(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersonagallery_setdefault(vpersonagalleryid integer) RETURNS void
    LANGUAGE plpgsql
    AS $$
declare vpersonaid integer default 0;
BEGIN
	select personaid into vpersonaid from basic.personagallery where personagalleryid=vpersonagalleryid;
	
	update basic.personagallery set "default"=false where personaid=vpersonaid;
	update basic.personagallery set "default"=true where personagalleryid=vpersonagalleryid;
END
$$;


ALTER FUNCTION basic.papersonagallery_setdefault(vpersonagalleryid integer) OWNER TO radiosan_ustaana;

--
-- Name: papersonaid_bydocumento(character varying, integer, character varying, character varying, character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papersonaid_bydocumento(intipo_per character varying, vrolid integer, indni character varying, inruc character varying, inape_pat character varying, inape_mat character varying, innombre character varying, indireccion character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vCodigo_Per integer default 0; vDni varchar default ''; vRucN varchar default '';
BEGIN
	
	If intipo_per='N' Then		
		select personaid, dni, ruc into vCodigo_Per, vDni, vRucN from basic.persona_natural 
		where case when indni!='' then dni=indni else ruc=inruc end;
		
		if coalesce(vRucN,'')='' and inruc!='' and vCodigo_Per>0 then
			update basic.persona_natural set ruc=inruc where personaid=vCodigo_Per;
			update basic.persona set direccion=indireccion where personaid=vCodigo_Per;
		end if; 
		if coalesce(vDni,'')='' and indni!='' and vCodigo_Per>0 then
			update basic.persona_natural set dni=indni where personaid=vCodigo_Per;
		end if; 
		
	else
		select coalesce(personaid,0) into vCodigo_Per from basic.persona_juridica where ruc=inruc;
	end if;			 	
		 	 
	If coalesce(vCodigo_Per,0)=0 Then
		If intipo_per='N' Then
			if inape_pat!='' and inape_mat!='' and innombre!='' then
				vCodigo_Per:=nextval('basic.persona_personaid_seq');
				insert into basic.persona values(vCodigo_Per, 'N', indireccion, '', '', '', '', 1, true, current_timestamp, '');
				insert into basic.persona_natural values(vCodigo_Per, '', inape_pat, inape_mat, innombre, indni, inruc, 0,'','M', 'S', current_date);
				
				if vRolId>0 then
					insert into basic.persona_rol values(vCodigo_Per, vRolId);
					update basic.persona set rol=basic.papersona_getrol(vCodigo_Per, '') where personaid=vCodigo_Per;
				end if;								
			end if;
		else 
			vCodigo_Per:=nextval('basic.persona_personaid_seq');
			insert into basic.persona values(vCodigo_Per, 'J', indireccion,'', '', '', '', 1, true, current_timestamp, '');
			insert into basic.persona_juridica values(vCodigo_Per, innombre, inruc);
			
			if vRolId>0 then
				insert into basic.persona_rol values(vCodigo_Per, vRolId);
				update basic.persona set rol=basic.papersona_getrol(vCodigo_Per, '') where personaid=vCodigo_Per;
			end if;			
		end if;
	end if;
	
	return coalesce(vCodigo_Per,0);
END
$$;


ALTER FUNCTION basic.papersonaid_bydocumento(intipo_per character varying, vrolid integer, indni character varying, inruc character varying, inape_pat character varying, inape_mat character varying, innombre character varying, indireccion character varying) OWNER TO radiosan_ustaana;

--
-- Name: papoersona_generar_usuarios(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION papoersona_generar_usuarios() RETURNS void
    LANGUAGE plpgsql
    AS $$
DECLARE myRow record; vUsuario varchar(20) default ''; vContador integer default 0;
BEGIN
	--GENERAMOS USUARIOS DE AQUELLOS QUE NO LO TENGAN
	for myRow in select p.personaid from basic.persona p left join basic.clave_otros cla on p.personaid=cla.personaid where trim(coalesce(cla.usuario,''))='' and p.personaid>0 ORDER BY p.personaid loop
		delete from basic.clave_otros where personaid=myRow.personaid;
		vUsuario:=basic.papersona_generar_usuario(myRow.personaid);
		if trim(vUsuario)!='' then
			insert into basic.clave_otros values(myRow.personaid, vUsuario, vUsuario, vUsuario, false, 'A');
			vContador:=vContador+1;
			raise notice 'Usuario generado: %', vContador;
		end if;
	END LOOP;
END
$$;


ALTER FUNCTION basic.papoersona_generar_usuarios() OWNER TO radiosan_ustaana;

--
-- Name: paproceso_actualizar(boolean, integer, integer, character varying, character varying, character varying, boolean); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paproceso_actualizar(innew boolean, inprocesoid integer, intipoprocesoid integer, innombre character varying, indescripcion character varying, inmensaje character varying, inestado boolean) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.proceso pro where lower(buscar(trim(pro.nombre)))=lower(buscar(trim(innombre))) and pro.procesoid!=inprocesoid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema ha detectado que el nombre ya existe en la base de datos.';
	end if;
	If vState Then
		If innew Then
			insert into basic.proceso values(default, intipoprocesoid, trim(innombre), trim(indescripcion), trim(inmensaje), basic.paproceso_lastorder(intipoprocesoid)+1, inestado);
			vID:=lastval();
		else
			update basic.proceso set tipoprocesoid=intipoprocesoid, nombre=trim(innombre), descripcion=trim(indescripcion), mensaje=trim(inmensaje), estado=inestado where procesoid=inprocesoid;
			vID:=inprocesoid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paproceso_actualizar(innew boolean, inprocesoid integer, intipoprocesoid integer, innombre character varying, indescripcion character varying, inmensaje character varying, inestado boolean) OWNER TO radiosan_ustaana;

--
-- Name: paproceso_cambiar_estado(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paproceso_cambiar_estado(vprocesoid integer, vusuario integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vEstadoOld boolean default false;
BEGIN
	if vState then
		if exists(select * from basic.proceso where procesoid=vprocesoid) then
			--RASTRO
			select estado into vEstadoOld from basic.proceso where procesoid=vprocesoid;
			insert into rastro.campo values(default, 'basic', 'proceso', 'estado', 'B', vprocesoid, 0, 0, vEstadoOld::varchar, (not vEstadoOld)::varchar, current_timestamp, vusuario, vip, 1, 0);
			
			update basic.proceso set estado=not estado where procesoid=vprocesoid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paproceso_cambiar_estado(vprocesoid integer, vusuario integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: paproceso_change_order(integer[], integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paproceso_change_order(myarr integer[], vstart integer) RETURNS void
    LANGUAGE plpgsql
    AS $$
declare myRow record;
BEGIN
	for myRow in select myarr[i] as id, i as orden from generate_series(1, array_upper(myarr, 1)) as i loop
		update basic.proceso set orden=myRow.orden+(case when vstart>1 then vstart-1 else 0 end) where procesoid=myRow.id;
	end loop;
END
$$;


ALTER FUNCTION basic.paproceso_change_order(myarr integer[], vstart integer) OWNER TO radiosan_ustaana;

--
-- Name: paproceso_eliminar(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paproceso_eliminar(inprocesoid integer) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if vState then
		delete from basic.permisos_proceso where procesoid=inprocesoid;
		delete from basic.proceso where procesoid=inprocesoid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paproceso_eliminar(inprocesoid integer) OWNER TO radiosan_ustaana;

--
-- Name: paproceso_getid(character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paproceso_getid(vnombre character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vprocesoid integer default 0;
BEGIN
	select pro.procesoid into vprocesoid from basic.proceso pro where trim(upper(buscar(pro.nombre)))=trim(upper(buscar(vnombre)));
	return coalesce(vprocesoid, 0);
END
$$;


ALTER FUNCTION basic.paproceso_getid(vnombre character varying) OWNER TO radiosan_ustaana;

--
-- Name: paproceso_getmensaje(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paproceso_getmensaje(vprocesoid integer) RETURNS character varying
    LANGUAGE plpgsql
    AS $$
declare vmensaje varchar default '';
BEGIN
	select pro.mensaje into vmensaje from basic.proceso pro where pro.procesoid=vprocesoid;
	return coalesce(vmensaje, '');
END
$$;


ALTER FUNCTION basic.paproceso_getmensaje(vprocesoid integer) OWNER TO radiosan_ustaana;

--
-- Name: paproceso_getmsg(character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paproceso_getmsg(vproceso character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $$
DECLARE vMsg varchar default '';
BEGIN
	select mensaje into vMsg from basic.proceso where nombre=vproceso;
	return coalesce(vMsg, '');
END
$$;


ALTER FUNCTION basic.paproceso_getmsg(vproceso character varying) OWNER TO radiosan_ustaana;

--
-- Name: paproceso_lastorder(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paproceso_lastorder(vtipo integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vOrden integer default 0;
BEGIN
	select max(orden) into vOrden from basic.proceso where tipoprocesoid=vtipo;
	return coalesce(vOrden, 0);
END
$$;


ALTER FUNCTION basic.paproceso_lastorder(vtipo integer) OWNER TO radiosan_ustaana;

--
-- Name: paproceso_leer(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paproceso_leer(vtipoprocesoid integer) RETURNS SETOF type_proceso_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp cascade;
	create temporary table tmp(tipo integer not null, procesoid integer not null, cantidad integer not null);
	insert into tmp select 1, procesoid, count(*) from basic.permisos_proceso group by 2;
	
	return query 
		select p.procesoid, p.tipoprocesoid, tp.nombre, p.nombre, p.descripcion, p.mensaje, p.orden, p.estado, coalesce(tmp.cantidad, 0)::integer
		from basic.proceso p inner join basic.tipo_proceso tp on p.tipoprocesoid=tp.tipoprocesoid
			left join tmp on p.procesoid=tmp.procesoid and 1=tmp.tipo
		where 1=1 
			and case when vtipoprocesoid>0 then p.tipoprocesoid=vtipoprocesoid else true end
		order by tp.orden, tp.nombre, p.orden, p.nombre;
		
	drop table if exists tmp cascade;
END
$$;


ALTER FUNCTION basic.paproceso_leer(vtipoprocesoid integer) OWNER TO radiosan_ustaana;

--
-- Name: paprovincia_actualizar(boolean, integer, integer, character varying, character varying, character varying, boolean); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paprovincia_actualizar(innew boolean, inprovinciaid integer, indepartamentoid integer, innombre character varying, inabreviatura character varying, inubigeo character varying, inestado boolean) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.provincia p where trim(upper(buscar(p.nombre)))=trim(upper(buscar(innombre))) and p.departamentoid=indepartamentoid and p.provinciaid!=inprovinciaid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre de la provincia ya existe en la base de datos';
	end if;
	if vState then
		if trim(inubigeo)!='' then
			if exists(select * from basic.provincia p where trim(upper(buscar(p.ubigeo)))=trim(upper(buscar(inubigeo))) and p.departamentoid=indepartamentoid and p.provinciaid!=inprovinciaid) then
				vState:=false; vID:=0; vError:=1; vDescripcion:='El ubigeo de la provincia ya existe en la base de datos';
			end if;
		end if;
	end if;
	If vState Then
		If inNew Then
			insert into basic.provincia values(default, trim(innombre), trim(inabreviatura), indepartamentoid, trim(inubigeo), inestado);
			vID:=lastval();
		Else
			update basic.provincia set departamentoid=indepartamentoid, nombre=trim(innombre), abreviatura=trim(inabreviatura), ubigeo=trim(inubigeo), estado=inestado where provinciaid=inprovinciaid;
			vID:=inprovinciaid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paprovincia_actualizar(innew boolean, inprovinciaid integer, indepartamentoid integer, innombre character varying, inabreviatura character varying, inubigeo character varying, inestado boolean) OWNER TO radiosan_ustaana;

--
-- Name: paprovincia_eliminar(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paprovincia_eliminar(inprovinciaid integer) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.distrito where provinciaid=inprovinciaid limit 1) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar la provincia por tener distrito relacionados.';
	end if;
	if vState then
		delete from basic.provincia where provinciaid=inprovinciaid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paprovincia_eliminar(inprovinciaid integer) OWNER TO radiosan_ustaana;

--
-- Name: paprovincia_getrow(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paprovincia_getrow(vprovinciaid integer) RETURNS SETOF type_provincia_getrow
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select p.provinciaid, p.nombre, p.abreviatura, p.ubigeo, p.departamentoid, dpto.nombre, dpto.abreviatura, dpto.ubigeo, 
			dpto.paisid, pa.nombre, pa.abreviatura, pa.ubigeo, p.estado
		from basic.provincia p inner join basic.departamento dpto on p.departamentoid=dpto.departamentoid
			inner join basic.pais pa on dpto.paisid=pa.paisid
		where p.provinciaid=vprovinciaid;
END
$$;


ALTER FUNCTION basic.paprovincia_getrow(vprovinciaid integer) OWNER TO radiosan_ustaana;

--
-- Name: paprovincia_leer(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paprovincia_leer(vdepartamentoid integer) RETURNS SETOF type_provincia_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select pro.provinciaid, pro.departamentoid, dpto.nombre, pro.nombre, pro.abreviatura, pro.ubigeo, pro.estado
		from basic.provincia pro inner join basic.departamento dpto on pro.departamentoid=dpto.departamentoid
		where pro.departamentoid=vdepartamentoid 
		order by dpto.nombre, pro.nombre;
END
$$;


ALTER FUNCTION basic.paprovincia_leer(vdepartamentoid integer) OWNER TO radiosan_ustaana;

--
-- Name: parol_actualizar(boolean, integer, character varying, character varying, character varying, character varying, character varying, boolean); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION parol_actualizar(innew boolean, inrolid integer, innombre character varying, inabreviatura character varying, inimagen character varying, inestructura character varying, intipo character varying, inpordefecto boolean) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.rol r where lower(buscar(trim(r.nombre)))=lower(buscar(trim(innombre))) and r.rolid!=inrolid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre del rol ya existe en la base de datos';
	end if;
	If vState Then
		if trim(inabreviatura)!='' then
			if exists(select * from basic.rol r where lower(buscar(trim(r.abreviatura)))=lower(buscar(trim(inabreviatura))) and r.rolid!=inrolid) then
				vState:=false; vID:=0; vError:=1; vDescripcion:='La abreviatura del rol ya existe en la base de datos';
			end if;
		end if;
	end if;
	If vState Then
		If inNew Then
			insert into basic.rol values(default, innombre, inabreviatura, inimagen, inestructura, intipo, inpordefecto, basic.parol_lastorder()+1, true);
			vID:=lastval();
		else
			update basic.rol set nombre=innombre, abreviatura=inabreviatura, imagen=inimagen, estructura=inestructura, tipo=intipo, pordefecto=inpordefecto where rolid=inrolid;
			vID:=inrolid;
		end if;
		if inpordefecto then
			update basic.rol set pordefecto=false where rolid!=vID;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.parol_actualizar(innew boolean, inrolid integer, innombre character varying, inabreviatura character varying, inimagen character varying, inestructura character varying, intipo character varying, inpordefecto boolean) OWNER TO radiosan_ustaana;

--
-- Name: parol_change_order(integer[], integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION parol_change_order(myarr integer[], vstart integer) RETURNS void
    LANGUAGE plpgsql
    AS $$
declare myRow record;
BEGIN
	for myRow in select myarr[i] as id, i as orden from generate_series(1, array_upper(myarr, 1)) as i loop
		update basic.rol set orden=myRow.orden+(case when vstart>1 then vstart-1 else 0 end) where rolid=myRow.id;
	end loop;
END
$$;


ALTER FUNCTION basic.parol_change_order(myarr integer[], vstart integer) OWNER TO radiosan_ustaana;

--
-- Name: parol_eliminar(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION parol_eliminar(inrolid integer) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.persona_rol where rolid=inrolid limit 1) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar el rol por tener personas relacionadas.';
	end if;
	if vState then
		delete from basic.opciones_seleccion_rol where rolid=inrolid;
		delete from basic.rol where rolid=inrolid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.parol_eliminar(inrolid integer) OWNER TO radiosan_ustaana;

--
-- Name: parol_getidbyestructura(character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION parol_getidbyestructura(vestructura character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vRolId integer default 0;
BEGIN
	if trim(vestructura)!='' then
		select rolid into vRolId from basic.rol r where trim(upper(r.estructura))=trim(upper(vestructura));
	end if;
	return coalesce(vRolId, 0)::integer;
END
$$;


ALTER FUNCTION basic.parol_getidbyestructura(vestructura character varying) OWNER TO radiosan_ustaana;

--
-- Name: parol_lastorder(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION parol_lastorder() RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vOrden integer default 0;
BEGIN
	select max(r.orden) into vOrden from basic.rol r;
	return coalesce(vOrden, 0);
END
$$;


ALTER FUNCTION basic.parol_lastorder() OWNER TO radiosan_ustaana;

--
-- Name: rol; Type: TABLE; Schema: basic; Owner: radiosan_ustaana; Tablespace: 
--

CREATE TABLE rol (
    rolid integer NOT NULL,
    nombre character varying(50) NOT NULL,
    abreviatura character varying(10) DEFAULT ''::character varying NOT NULL,
    imagen character varying(50) DEFAULT ''::character varying NOT NULL,
    estructura character varying(10) DEFAULT ''::character varying NOT NULL,
    tipo character varying(1) DEFAULT ''::character varying NOT NULL,
    pordefecto boolean DEFAULT false NOT NULL,
    orden integer DEFAULT 0 NOT NULL,
    estado boolean DEFAULT true NOT NULL
);


ALTER TABLE basic.rol OWNER TO radiosan_ustaana;

--
-- Name: parol_leer(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION parol_leer() RETURNS SETOF rol
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query select * from basic.rol r order by r.orden;
END
$$;


ALTER FUNCTION basic.parol_leer() OWNER TO radiosan_ustaana;

--
-- Name: paseguridad_redirect_agregar(character varying, integer, character varying, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paseguridad_redirect_agregar(inip character varying, inusuarioid integer, inusuario character varying, inlink character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	insert into basic.seguridad_redirect values(default, current_timestamp, trim(inip), inusuarioid, trim(inusuario), trim(inlink));
	vID:=lastval();
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paseguridad_redirect_agregar(inip character varying, inusuarioid integer, inusuario character varying, inlink character varying) OWNER TO radiosan_ustaana;

--
-- Name: paseguridad_redirect_count(character varying, character varying, character varying, character varying, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paseguridad_redirect_count(vdesde character varying, vhasta character varying, vtexto character varying, vip character varying, vusuarioid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vCount integer default 0;
begin
	select count(*) into vCount
	from basic.seguridad_redirect s left join basic.persona p on s.usuarioid=p.personaid 
		left join basic.persona_natural pnalu on p.personaid=pnalu.personaid
		left join basic.persona_juridica pjalu on p.personaid=pjalu.personaid
		left join basic.clave c on s.usuarioid=c.personaid
	where 1=1
		and case when vdesde!='' then s.registro::date>=cast(vdesde as date) else true end 
		and case when vhasta!='' then s.registro::date<=cast(vhasta as date) else true end 
		and case when trim(vtexto)!='' then (
			upper(buscar(c.usuario)) like upper(buscar('%'||vtexto||'%'))   
			or upper(buscar(s.ip)) like upper(buscar('%'||vtexto||'%'))  
			or upper(buscar(pnalu.ape_pat)) like upper(buscar('%'||vtexto||'%'))  
			or upper(buscar(pnalu.ape_mat)) like upper(buscar('%'||vtexto||'%')) 
			or upper(buscar(pnalu.nombre)) like upper(buscar('%'||vtexto||'%')) 
			or upper(buscar(pnalu.ape_pat||' '||pnalu.ape_mat||' '||pnalu.nombre)) like upper(buscar('%'||vtexto||'%'))  ) else true end
		and case when trim(vip)!='' then s.ip like '%'||vip||'%' else true end
		and case when vusuarioid>0 then s.usuarioid=vusuarioid else true end;
	return coalesce(vCount, 0);
END
$$;


ALTER FUNCTION basic.paseguridad_redirect_count(vdesde character varying, vhasta character varying, vtexto character varying, vip character varying, vusuarioid integer) OWNER TO radiosan_ustaana;

--
-- Name: paseguridad_redirect_leer(integer, integer, character varying, character varying, character varying, character varying, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paseguridad_redirect_leer(vfirst integer, vlast integer, vdesde character varying, vhasta character varying, vtexto character varying, vip character varying, vusuarioid integer) RETURNS SETOF type_seguridad_redirect_leer
    LANGUAGE plpgsql
    AS $$
begin
	return query
	select s.codigo, to_char(s.registro, 'DD/MM/YYYY HH12:MI AM')::varchar, s.usuarioid, s.usuario, s.ip,
		 upper(case when p.personaid is null then '' else (case when tipo='N' then (coalesce(pnalu.ape_pat,'') || ' ' || coalesce(pnalu.ape_mat,'') || ', ' || coalesce(pnalu.nombre,'')) else pjalu.raz_soc end) end)::varchar,
		 s.link
	from basic.seguridad_redirect s left join basic.persona p on s.usuarioid=p.personaid 
		left join basic.persona_natural pnalu on p.personaid=pnalu.personaid
		left join basic.persona_juridica pjalu on p.personaid=pjalu.personaid
		left join basic.clave c on s.usuarioid=c.personaid
	where 1=1
		and case when vdesde!='' then s.registro::date>=cast(vdesde as date) else true end 
		and case when vhasta!='' then s.registro::date<=cast(vhasta as date) else true end 
		and case when trim(vtexto)!='' then (
			upper(buscar(c.usuario)) like upper(buscar('%'||vtexto||'%'))   
			or upper(buscar(s.ip)) like upper(buscar('%'||vtexto||'%'))  
			or upper(buscar(pnalu.ape_pat)) like upper(buscar('%'||vtexto||'%'))  
			or upper(buscar(pnalu.ape_mat)) like upper(buscar('%'||vtexto||'%')) 
			or upper(buscar(pnalu.nombre)) like upper(buscar('%'||vtexto||'%')) 
			or upper(buscar(pnalu.ape_pat||' '||pnalu.ape_mat||' '||pnalu.nombre)) like upper(buscar('%'||vtexto||'%'))  ) else true end
		and case when trim(vip)!='' then s.ip like '%'||vip||'%' else true end
		and case when vusuarioid>0 then s.usuarioid=vusuarioid else true end
	order by s.registro desc
	limit case when vfirst=0 and vlast=0 then null else vlast end offset vfirst;
END
$$;


ALTER FUNCTION basic.paseguridad_redirect_leer(vfirst integer, vlast integer, vdesde character varying, vhasta character varying, vtexto character varying, vip character varying, vusuarioid integer) OWNER TO radiosan_ustaana;

--
-- Name: paservidor_actualizar(boolean, integer, character varying, character varying, character varying, character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paservidor_actualizar(innew boolean, inservidorid integer, innombre character varying, inservidor character varying, inusuario character varying, inclave character varying, inpuerto character varying, inpath_html character varying, inpath_xml character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.servidor s where trim(upper(buscar(s.nombre)))=trim(upper(buscar(innombre))) and s.servidorid!=inservidorid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre ya existe en la base de datos';
	end if;
	If vState Then
		If inNew Then
			insert into basic.servidor values(default, trim(innombre), trim(inservidor), trim(inusuario), trim(inclave), trim(inpuerto), trim(inpath_html), trim(inpath_xml));
			vID:=lastval();
		Else
			update basic.servidor set nombre=trim(innombre), servidor=trim(inservidor), usuario=trim(inusuario), clave=trim(inclave), puerto=trim(inpuerto), path_html=trim(inpath_html), path_xml=trim(inpath_xml) where servidorid=inservidorid;
			vID:=inservidorid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paservidor_actualizar(innew boolean, inservidorid integer, innombre character varying, inservidor character varying, inusuario character varying, inclave character varying, inpuerto character varying, inpath_html character varying, inpath_xml character varying) OWNER TO radiosan_ustaana;

--
-- Name: paservidor_eliminar(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paservidor_eliminar(vservidorid integer, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if vState then
		delete from basic.servidor where servidorid=vservidorid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paservidor_eliminar(vservidorid integer, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: paservidor_leer(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paservidor_leer() RETURNS SETOF type_servidor_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select s.servidorid, s.nombre, s.servidor, s.usuario, s.clave, s.puerto, s.path_html, s.path_xml
		from basic.servidor s order by 2;
END
$$;


ALTER FUNCTION basic.paservidor_leer() OWNER TO radiosan_ustaana;

--
-- Name: paservidorcorreo_actualizar(boolean, integer, character varying, character varying, character varying, character varying, character varying, character varying, boolean); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paservidorcorreo_actualizar(innew boolean, inservidorid integer, innombre character varying, inservidor character varying, incorreo character varying, inclave character varying, inpuerto character varying, inencriptacion character varying, inestado boolean) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.servidorcorreo s where trim(upper(buscar(s.nombre)))=trim(upper(buscar(innombre))) and s.servidorid!=inservidorid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre ya existe en la base de datos.';
	end if;
	If vState Then
		if exists(select * from basic.servidorcorreo s where trim(upper(buscar(s.correo)))=trim(upper(buscar(incorreo))) and s.servidorid!=inservidorid) then
			vState:=false; vID:=0; vError:=1; vDescripcion:='La cuenta de correo asociada ya existe en la base de datos.';
		end if;
	end if;
	If vState Then
		If inNew Then
			insert into basic.servidorcorreo values(default, trim(innombre), trim(inservidor), trim(incorreo), trim(inclave), trim(inpuerto), trim(inencriptacion), inestado);
			vID:=lastval();
		Else
			update basic.servidorcorreo set nombre=trim(innombre), servidor=trim(inservidor), correo=trim(incorreo), clave=trim(inclave), puerto=trim(inpuerto), encriptacion=trim(inencriptacion), estado=inestado where servidorid=inservidorid;
			vID:=inservidorid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paservidorcorreo_actualizar(innew boolean, inservidorid integer, innombre character varying, inservidor character varying, incorreo character varying, inclave character varying, inpuerto character varying, inencriptacion character varying, inestado boolean) OWNER TO radiosan_ustaana;

--
-- Name: paservidorcorreo_cambiar_estado(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paservidorcorreo_cambiar_estado(vservidorid integer, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vEstadoOld boolean default false;
BEGIN
	if vState then
		if exists(select * from basic.servidorcorreo where servidorid=vservidorid) then
			--RASTRO
			select estado into vEstadoOld from basic.servidorcorreo where servidorid=vservidorid;
			insert into rastro.campo values(default, 'basic', 'servidorcorreo', 'estado', 'B', vservidorid, 0, 0, vEstadoOld::varchar, (not vEstadoOld)::varchar, current_timestamp, vusuarioid, vip, 1, 0);
			
			update basic.servidorcorreo set estado=not estado where servidorid=vservidorid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paservidorcorreo_cambiar_estado(vservidorid integer, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: paservidorcorreo_count(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paservidorcorreo_count() RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vCount integer default 0;
BEGIN
	select count(*) into vCount from basic.servidorcorreo m;
	return coalesce(vCount, 0);
END
$$;


ALTER FUNCTION basic.paservidorcorreo_count() OWNER TO radiosan_ustaana;

--
-- Name: paservidorcorreo_eliminar(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paservidorcorreo_eliminar(vservidorid integer) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if vState then
		delete from basic.servidorcorreo where servidorid=vservidorid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paservidorcorreo_eliminar(vservidorid integer) OWNER TO radiosan_ustaana;

--
-- Name: paservidorcorreo_leer(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paservidorcorreo_leer() RETURNS SETOF type_servidorcorreo_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select m.servidorid, m.nombre, m.servidor, m.correo, m.clave, m.puerto, m.encriptacion, m.estado
		from basic.servidorcorreo m
		order by m.servidor;
END
$$;


ALTER FUNCTION basic.paservidorcorreo_leer() OWNER TO radiosan_ustaana;

--
-- Name: paservidordb_actualizar(boolean, integer, character varying, character varying, character varying, character varying, character varying, character varying, boolean); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paservidordb_actualizar(innew boolean, inservidorid integer, innombre character varying, inservidor character varying, inbasedatos character varying, inusuario character varying, inclave character varying, inpuerto character varying, inestado boolean) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.servidordb s where trim(upper(buscar(s.nombre)))=trim(upper(buscar(innombre))) and s.servidorid!=inservidorid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre ya existe en la base de datos.';
	end if;
	If vState Then
		If inNew Then
			insert into basic.servidordb values(default, trim(innombre), trim(inservidor), trim(inbasedatos), trim(inusuario), trim(inclave), trim(inpuerto), inestado);
			vID:=lastval();
		Else
			update basic.servidordb set nombre=trim(innombre), servidor=trim(inservidor), basedatos=trim(inbasedatos), usuario=trim(inusuario), clave=trim(inclave), puerto=trim(inpuerto), estado=inestado where servidorid=inservidorid;
			vID:=inservidorid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paservidordb_actualizar(innew boolean, inservidorid integer, innombre character varying, inservidor character varying, inbasedatos character varying, inusuario character varying, inclave character varying, inpuerto character varying, inestado boolean) OWNER TO radiosan_ustaana;

--
-- Name: paservidordb_cambiar_estado(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paservidordb_cambiar_estado(vservidorid integer, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vEstadoOld boolean default false;
BEGIN
	if vState then
		if exists(select * from basic.servidordb where servidorid=vservidorid) then
			--RASTRO
			select estado into vEstadoOld from basic.servidordb where servidorid=vservidorid;
			insert into rastro.campo values(default, 'basic', 'servidordb', 'estado', 'B', vservidorid, 0, 0, vEstadoOld::varchar, (not vEstadoOld)::varchar, current_timestamp, vusuarioid, vip, 1, 0);
			
			update basic.servidordb set estado=not estado where servidorid=vservidorid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paservidordb_cambiar_estado(vservidorid integer, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: paservidordb_count(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paservidordb_count() RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vCount integer default 0;
BEGIN
	select count(*) into vCount from basic.servidordb m;
	return coalesce(vCount, 0);
END
$$;


ALTER FUNCTION basic.paservidordb_count() OWNER TO radiosan_ustaana;

--
-- Name: paservidordb_eliminar(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paservidordb_eliminar(vservidorid integer) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if vState then
		delete from basic.servidordb where servidorid=vservidorid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paservidordb_eliminar(vservidorid integer) OWNER TO radiosan_ustaana;

--
-- Name: paservidordb_leer(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paservidordb_leer() RETURNS SETOF type_servidordb_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select m.servidorid, m.nombre, m.servidor, m.basedatos, (m.servidor||'('||m.basedatos||')')::varchar, m.usuario, m.puerto, m.estado
		from basic.servidordb m
		order by m.servidor;
END
$$;


ALTER FUNCTION basic.paservidordb_leer() OWNER TO radiosan_ustaana;

--
-- Name: pasurtidor_actualizar(boolean, integer, integer, integer, character varying, character varying, character varying, integer, integer, boolean); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pasurtidor_actualizar(innew boolean, insurtidorid integer, intanqueid integer, inmaquinaid integer, innombre character varying, inabreviatura character varying, incodigo character varying, inposx integer, inposy integer, inestado boolean) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.surtidor sur where trim(upper(buscar(sur.nombre)))=trim(upper(buscar(innombre))) and sur.tanqueid=intanqueid and sur.surtidorid!=insurtidorid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre del surtidor ya existe.';
	end if;
	if vstate then
		if trim(inabreviatura)!='' then
			if exists(select * from basic.surtidor sur where trim(upper(buscar(sur.abreviatura)))=trim(upper(buscar(inabreviatura))) and sur.tanqueid=intanqueid and sur.maquinaid=inmaquinaid and sur.surtidorid!=insurtidorid) then
				vState:=false; vID:=0; vError:=1; vDescripcion:='La abreviatura del surtidor ya existe.';
			end if;
		end if;
	end if;
	if vstate then
		if exists(select * from basic.surtidor sur where sur.posy=inposy and sur.posx=inposx and sur.tanqueid=intanqueid and sur.maquinaid=inmaquinaid and sur.surtidorid!=insurtidorid) then
			vState:=false; vID:=0; vError:=1; vDescripcion:='La posición "XY" ya existe.';
		end if;
	end if;
	If vState Then
		If innew Then
			insert into basic.surtidor values(default, intanqueid, inmaquinaid, trim(innombre), trim(inabreviatura), trim(incodigo), inposx, inposy, inestado);
			vID:=lastval();
		Else
			update basic.surtidor set tanqueid=intanqueid, maquinaid=inmaquinaid, nombre=trim(innombre), abreviatura=trim(inabreviatura), codigo=trim(incodigo), posx=inposx, posy=inposy, estado=inestado where surtidorid=insurtidorid;
			vID:=insurtidorid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.pasurtidor_actualizar(innew boolean, insurtidorid integer, intanqueid integer, inmaquinaid integer, innombre character varying, inabreviatura character varying, incodigo character varying, inposx integer, inposy integer, inestado boolean) OWNER TO radiosan_ustaana;

--
-- Name: pasurtidor_cambiar_estado(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pasurtidor_cambiar_estado(vsurtidorid integer, vusuario integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vEstadoOld boolean default false;
BEGIN
	if vState then
		if exists(select * from basic.surtidor where surtidorid=vsurtidorid) then
			--RASTRO
			select estado into vEstadoOld from basic.surtidor where surtidorid=vsurtidorid;
			insert into rastro.campo values(default, 'basic', 'surtidor', 'estado', 'B', vsurtidorid, 0, 0, vEstadoOld::varchar, (not vEstadoOld)::varchar, current_timestamp, vusuario, vip, 1, 0);
			
			update basic.surtidor set estado=not estado where surtidorid=vsurtidorid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.pasurtidor_cambiar_estado(vsurtidorid integer, vusuario integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: pasurtidor_consulta(integer, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pasurtidor_consulta(valmacenid integer, vtanqueid integer) RETURNS SETOF type_surtidor_consulta
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query
		select sur.surtidorid, sur.tanqueid, tan.nombre, sur.maquinaid, maq.nombre,
			sur.nombre, sur.abreviatura, sur.posx, sur.posy,
			tan.productoid, coalesce(pro.nombre,'')::varchar, coalesce(pro.abreviatura, '')::varchar, coalesce(pro.sigla, '')::varchar, coalesce(pro.backcolor, '')::varchar, coalesce(pro.forecolor, '')::varchar
		from basic.surtidor sur inner join basic.tanque tan on sur.tanqueid=tan.tanqueid
			inner join basic.maquina maq on sur.maquinaid=maq.maquinaid
			left join catalogo.producto pro on tan.productoid=pro.productoid
		where tan.almacenid=valmacenid and sur.surtidorid>0 and sur.estado=true
			and case when vtanqueid>0 then sur.tanqueid=vtanqueid else true end
		order by maq.posx, maq.posy, sur.posx, sur.posy;
END
$$;


ALTER FUNCTION basic.pasurtidor_consulta(valmacenid integer, vtanqueid integer) OWNER TO radiosan_ustaana;

--
-- Name: pasurtidor_eliminar(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pasurtidor_eliminar(vsurtidorid integer, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	--if exists(select * from inventarios.venta_detalle where surtidorid=vsurtidorid) then
	--	vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar el surtidor por tener surtidores relacionados.';
	--end if;
	if vState then
		delete from basic.surtidor where surtidorid=vsurtidorid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.pasurtidor_eliminar(vsurtidorid integer, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: pasurtidor_getrow(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pasurtidor_getrow(vsurtidorid integer) RETURNS SETOF type_surtidor_getrow
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query
		select sur.surtidorid, alm.zonaid, zon.nombre, tan.almacenid, alm.nombre, sur.tanqueid, tan.nombre, sur.maquinaid, maq.nombre, sur.nombre, sur.abreviatura, sur.posx, sur.posy, 
			sur.estado
		from basic.surtidor sur inner join basic.tanque tan on sur.tanqueid=tan.tanqueid
			inner join basic.maquina maq on sur.maquinaid=maq.maquinaid
			inner join basic.almacen alm on alm.almacenid=alm.almacenid
			inner join basic.zona zon on alm.zonaid=zon.zonaid
		where sur.surtidorid=vsurtidorid;
END
$$;


ALTER FUNCTION basic.pasurtidor_getrow(vsurtidorid integer) OWNER TO radiosan_ustaana;

--
-- Name: pasurtidor_leer(integer, integer, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pasurtidor_leer(vzonaid integer, valmacenid integer, vtanqueid integer) RETURNS SETOF type_surtidor_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query
		select sur.surtidorid, alm.zonaid, zon.nombre, zon.abreviatura, tan.almacenid, alm.nombre, alm.abreviatura, sur.tanqueid, tan.nombre, sur.maquinaid, maq.nombre,
			sur.nombre, sur.abreviatura, sur.posx, sur.posy,
			sur.estado
		from basic.surtidor sur inner join basic.tanque tan on sur.tanqueid=tan.tanqueid
			inner join basic.almacen alm on tan.almacenid=alm.almacenid
			inner join basic.zona zon on alm.zonaid=zon.zonaid
			inner join basic.maquina maq on sur.maquinaid=maq.maquinaid
		where sur.surtidorid>0
			and case when vzonaid>0 then alm.zonaid=vzonaid else true end
			and case when valmacenid>0 then tan.almacenid=valmacenid else true end
			and case when vtanqueid>0 then sur.tanqueid=vtanqueid else true end
		order by zon.orden, alm.nombre, maq.nombre, sur.nombre, tan.nombre;
END
$$;


ALTER FUNCTION basic.pasurtidor_leer(vzonaid integer, valmacenid integer, vtanqueid integer) OWNER TO radiosan_ustaana;

--
-- Name: patanque_actualizar(boolean, integer, integer, character varying, character varying, integer, integer, integer, boolean); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patanque_actualizar(innew boolean, intanqueid integer, inalmacenid integer, innombre character varying, inabreviatura character varying, innumero integer, incapacidad integer, inproductoid integer, inestado boolean) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.tanque tan where trim(upper(buscar(tan.nombre)))=trim(upper(buscar(innombre))) and tan.almacenid=inalmacenid and tan.tanqueid!=intanqueid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre del tanque ya existe.';
	end if;
	if vState then
		if trim(inabreviatura)!='' then
			if exists(select * from basic.tanque tan where trim(upper(buscar(tan.abreviatura)))=trim(upper(buscar(inabreviatura))) and tan.almacenid=inalmacenid and tan.tanqueid!=intanqueid) then
				vState:=false; vID:=0; vError:=1; vDescripcion:='La abreviatura del tanque ya existe.';
			end if;
		end if;
	end if;
	if vState then
		if innumero>0 then
			if exists(select * from basic.tanque tan where tan.numero=innumero and tan.almacenid=inalmacenid and tan.tanqueid!=intanqueid) then
				vState:=false; vID:=0; vError:=1; vDescripcion:='La numero del tanque ya existe.';
			end if;
		end if;
	end if;
	If vState Then
		If innew Then
			insert into basic.tanque values(default, inalmacenid, trim(innombre), trim(inabreviatura), innumero, incapacidad, inproductoid, inestado);
			vID:=lastval();
		Else
			update basic.tanque set nombre=trim(innombre), abreviatura=trim(inabreviatura), numero=innumero, capacidad=incapacidad, productoid=inproductoid, estado=inestado where tanqueid=intanqueid;
			vID:=intanqueid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.patanque_actualizar(innew boolean, intanqueid integer, inalmacenid integer, innombre character varying, inabreviatura character varying, innumero integer, incapacidad integer, inproductoid integer, inestado boolean) OWNER TO radiosan_ustaana;

--
-- Name: patanque_cambiar_estado(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patanque_cambiar_estado(vtanqueid integer, vusuario integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vEstadoOld boolean default false;
BEGIN
	if vState then
		if exists(select * from basic.tanque where tanqueid=vtanqueid) then
			--RASTRO
			select estado into vEstadoOld from basic.tanque where tanqueid=vtanqueid;
			insert into rastro.campo values(default, 'basic', 'tanque', 'estado', 'B', vtanqueid, 0, 0, vEstadoOld::varchar, (not vEstadoOld)::varchar, current_timestamp, vusuario, vip, 1, 0);
			
			update basic.tanque set estado=not estado where tanqueid=vtanqueid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.patanque_cambiar_estado(vtanqueid integer, vusuario integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: patanque_eliminar(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patanque_eliminar(vtanqueid integer, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.surtidor where tanqueid=vtanqueid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar el tanque por tener surtidores relacionados.';
	end if;
	if vState then
		delete from basic.tanque where tanqueid=vtanqueid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.patanque_eliminar(vtanqueid integer, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: patanque_getrow(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patanque_getrow(vtanqueid integer) RETURNS SETOF type_tanque_getrow
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query
		select tan.tanqueid, alm.zonaid, zon.nombre, tan.almacenid, alm.nombre, tan.nombre, tan.abreviatura, tan.numero, tan.capacidad, 
			tan.productoid, coalesce(pro.nombre,'')::varchar, coalesce(pro.abreviatura,'')::varchar,
			tan.estado
		from basic.tanque tan inner join basic.almacen alm on tan.almacenid=alm.almacenid
			inner join basic.zona zon on alm.zonaid=zon.zonaid
			left join catalogo.producto pro on tan.productoid=pro.productoid
		where tan.tanqueid=vtanqueid;
END
$$;


ALTER FUNCTION basic.patanque_getrow(vtanqueid integer) OWNER TO radiosan_ustaana;

--
-- Name: patanque_leer(integer, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patanque_leer(vzonaid integer, valmacenid integer) RETURNS SETOF type_tanque_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query
		select tan.tanqueid, alm.zonaid, zon.nombre, zon.abreviatura, tan.almacenid, alm.nombre, alm.abreviatura,
			tan.nombre, tan.abreviatura, (tan.nombre||(case when tan.productoid>0 then ' / '||coalesce(pro.nombre,'') else '' end))::varchar, tan.numero, tan.capacidad,
			tan.productoid, coalesce(pro.nombre,'')::varchar, coalesce(pro.abreviatura, '')::varchar,
			tan.estado
		from basic.tanque tan inner join basic.almacen alm on tan.almacenid=alm.almacenid
			inner join basic.zona zon on alm.zonaid=zon.zonaid
			left join catalogo.producto pro on tan.productoid=pro.productoid
		where tan.tanqueid>0
			and case when vzonaid>0 then alm.zonaid=vzonaid else true end
			and case when valmacenid>0 then tan.almacenid=valmacenid else true end
		order by zon.orden, alm.nombre, tan.nombre;
END
$$;


ALTER FUNCTION basic.patanque_leer(vzonaid integer, valmacenid integer) OWNER TO radiosan_ustaana;

--
-- Name: patiene_permiso_proceso(integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patiene_permiso_proceso(vusuarioid integer, vproceso character varying) RETURNS boolean
    LANGUAGE plpgsql
    AS $$
BEGIN
	return exists(select * from basic.papermisos_proceso_leer(vusuarioid) where trim(upper(nombre))=trim(upper(vproceso)));
END
$$;


ALTER FUNCTION basic.patiene_permiso_proceso(vusuarioid integer, vproceso character varying) OWNER TO radiosan_ustaana;

--
-- Name: patiene_permisosweb(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patiene_permisosweb(vpersonaid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vMenuWebId integer default 0; vUsuario varchar default '';
BEGIN
	select cla.usuario into vUsuario from basic.clave cla where cla.personaid=vpersonaid;
	if vUsuario!=public.superusuario() then
		select count(*) into vMenuWebId from basic.permisos_menuweb p inner join basic.menuweb m on p.menuwebid=m.menuwebid where m.estado=true and m.padre>0 and p.personaid=vpersonaid;
		vMenuWebId:=coalesce(vMenuWebId, 0);
		if vMenuWebId=0 then
			select count(*) into vMenuWebId from basic.grupo_permisos_persona p inner join basic.grupo_permisos g on p.codigo=g.codigo where g.estado=true and p.personaid=vpersonaid;
			vMenuWebId:=coalesce(vMenuWebId, 0);
		end if;
	else
		vMenuWebId:=1;
	end if;
	return coalesce(vMenuWebId, 0);
END
$$;


ALTER FUNCTION basic.patiene_permisosweb(vpersonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: tipo_direccion; Type: TABLE; Schema: basic; Owner: radiosan_ustaana; Tablespace: 
--

CREATE TABLE tipo_direccion (
    tipodireccionid integer NOT NULL,
    nombre character varying(50) NOT NULL,
    requerido boolean NOT NULL,
    pordefecto boolean NOT NULL,
    orden integer NOT NULL,
    estado boolean NOT NULL
);


ALTER TABLE basic.tipo_direccion OWNER TO radiosan_ustaana;

--
-- Name: patipo_direccion_leer(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipo_direccion_leer() RETURNS SETOF tipo_direccion
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select * 
		from basic.tipo_direccion t 
		where t.tipodireccionid>0 order by t.orden;
END
$$;


ALTER FUNCTION basic.patipo_direccion_leer() OWNER TO radiosan_ustaana;

--
-- Name: patipo_email_actualizar(boolean, integer, character varying, boolean, boolean, boolean); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipo_email_actualizar(innew boolean, intipoemailid integer, innombre character varying, inrequerido boolean, inpordefecto boolean, inestado boolean) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.tipo_email t where lower(buscar(trim(t.nombre)))=lower(buscar(trim(innombre))) and t.tipoemailid!=intipoemailid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre ya existe en la base de datos';
	end if;
	If vState Then
		If innew Then
			insert into basic.tipo_email values(default, trim(innombre), inrequerido, inpordefecto, basic.patipo_email_lastorder()+1, inestado);
			vID:=lastval();
		Else
			update basic.tipo_email set nombre=trim(innombre), requerido=inrequerido, pordefecto=inpordefecto, estado=inestado where tipoemailid=intipoemailid;
			vID:=intipoemailid;
		end if;
		if inpordefecto then 
			update basic.tipo_email set pordefecto=false where tipoemailid!=vID;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.patipo_email_actualizar(innew boolean, intipoemailid integer, innombre character varying, inrequerido boolean, inpordefecto boolean, inestado boolean) OWNER TO radiosan_ustaana;

--
-- Name: patipo_email_change_order(integer[], integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipo_email_change_order(myarr integer[], vstart integer) RETURNS void
    LANGUAGE plpgsql
    AS $$
declare myRow record;
BEGIN
	for myRow in select myarr[i] as id, i as orden from generate_series(1, array_upper(myarr, 1)) as i loop
		update basic.tipo_email set orden=myRow.orden+(case when vstart>1 then vstart-1 else 0 end) where tipoemailid=myRow.id;
	end loop;
END
$$;


ALTER FUNCTION basic.patipo_email_change_order(myarr integer[], vstart integer) OWNER TO radiosan_ustaana;

--
-- Name: patipo_email_eliminar(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipo_email_eliminar(intipoemailid integer) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.persona_email where tipoemailid=intipoemailid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar el tipo de email por tener personas relacionadas.';
	end if;
	if vState then
		delete from basic.tipo_email where tipoemailid=intipoemailid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.patipo_email_eliminar(intipoemailid integer) OWNER TO radiosan_ustaana;

--
-- Name: patipo_email_lastorder(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipo_email_lastorder() RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vOrden integer default 0;
BEGIN
	select max(t.orden) into vOrden from basic.tipo_email t;
	return coalesce(vOrden, 0);
END
$$;


ALTER FUNCTION basic.patipo_email_lastorder() OWNER TO radiosan_ustaana;

--
-- Name: tipo_email; Type: TABLE; Schema: basic; Owner: radiosan_ustaana; Tablespace: 
--

CREATE TABLE tipo_email (
    tipoemailid integer NOT NULL,
    nombre character varying(50) NOT NULL,
    requerido boolean NOT NULL,
    pordefecto boolean NOT NULL,
    orden integer NOT NULL,
    estado boolean NOT NULL
);


ALTER TABLE basic.tipo_email OWNER TO radiosan_ustaana;

--
-- Name: patipo_email_leer(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipo_email_leer() RETURNS SETOF tipo_email
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select * from basic.tipo_email where tipoemailid>0 order by orden
	;
END
$$;


ALTER FUNCTION basic.patipo_email_leer() OWNER TO radiosan_ustaana;

--
-- Name: patipo_empresa_actualizar(boolean, integer, character varying, boolean); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipo_empresa_actualizar(innew boolean, intipoempresaid integer, innombre character varying, inestado boolean) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select tipoempresaid from basic.tipo_empresa where lower(buscar(trim(nombre)))=lower(buscar(trim(innombre))) and tipoempresaid!=intipoempresaid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema ha detectado que el nombre ya existe en la base de datos.';
	end if;
	If vState Then
		If innew Then
			insert into basic.tipo_empresa values(default, innombre, basic.patipo_empresa_lastorder()+1, inestado);
			vID:=lastval();
		else
			update basic.tipo_empresa set nombre=innombre, estado=inestado where tipoempresaid=intipoempresaid;
			vID:=intipoempresaid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.patipo_empresa_actualizar(innew boolean, intipoempresaid integer, innombre character varying, inestado boolean) OWNER TO radiosan_ustaana;

--
-- Name: patipo_empresa_cambiar_estado(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipo_empresa_cambiar_estado(vtipoempresaid integer, vusuario integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vEstadoOld boolean default false;
BEGIN
	if vState then
		if exists(select * from basic.tipo_empresa where tipoempresaid=vtipoempresaid) then
			--RASTRO
			select estado into vEstadoOld from basic.tipo_empresa where tipoempresaid=vtipoempresaid;
			insert into rastro.campo values(default, 'basic', 'tipo_empresa', 'estado', 'B', vtipoempresaid, 0, 0, vEstadoOld::varchar, (not vEstadoOld)::varchar, current_timestamp, vusuario, vip, 1, 0);
			
			update basic.tipo_empresa set estado=not estado where tipoempresaid=vtipoempresaid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.patipo_empresa_cambiar_estado(vtipoempresaid integer, vusuario integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: patipo_empresa_change_order(integer[], integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipo_empresa_change_order(myarr integer[], vstart integer) RETURNS void
    LANGUAGE plpgsql
    AS $$
declare myRow record;
BEGIN
	for myRow in select myarr[i] as id, i as orden from generate_series(1, array_upper(myarr, 1)) as i loop
		update basic.tipo_empresa set orden=myRow.orden+(case when vstart>1 then vstart-1 else 0 end) where tipoempresaid=myRow.id;
	end loop;
END
$$;


ALTER FUNCTION basic.patipo_empresa_change_order(myarr integer[], vstart integer) OWNER TO radiosan_ustaana;

--
-- Name: patipo_empresa_eliminar(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipo_empresa_eliminar(intipoempresaid integer) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.unidad_negocio where tipoempresaid=intipoempresaid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar el registro por tener procesos relacionados.';
	end if;
	if vState then
		delete from basic.tipo_empresa where tipoempresaid=intipoempresaid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.patipo_empresa_eliminar(intipoempresaid integer) OWNER TO radiosan_ustaana;

--
-- Name: patipo_empresa_lastorder(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipo_empresa_lastorder() RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vOrden integer default 0;
BEGIN
	select max(t.orden) into vOrden from basic.tipo_empresa t;
	return coalesce(vOrden, 0);
END
$$;


ALTER FUNCTION basic.patipo_empresa_lastorder() OWNER TO radiosan_ustaana;

--
-- Name: tipo_empresa; Type: TABLE; Schema: basic; Owner: radiosan_ustaana; Tablespace: 
--

CREATE TABLE tipo_empresa (
    tipoempresaid integer NOT NULL,
    nombre character varying(50) NOT NULL,
    orden integer NOT NULL,
    estado boolean NOT NULL
);


ALTER TABLE basic.tipo_empresa OWNER TO radiosan_ustaana;

--
-- Name: patipo_empresa_leer(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipo_empresa_leer() RETURNS SETOF tipo_empresa
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query select * from basic.tipo_empresa tp where 1=1 order by tp.orden, tp.nombre;
END
$$;


ALTER FUNCTION basic.patipo_empresa_leer() OWNER TO radiosan_ustaana;

--
-- Name: patipo_moneda_getnombre(character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipo_moneda_getnombre(vtipomonedaid character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $$
declare vnombre varchar default '';
BEGIN
	select t.nombre into vnombre from basic.tipo_moneda t where t.tipomonedaid=vtipomonedaid;
	return coalesce(vnombre, '');
END
$$;


ALTER FUNCTION basic.patipo_moneda_getnombre(vtipomonedaid character varying) OWNER TO radiosan_ustaana;

--
-- Name: patipo_moneda_getsimbolo(character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipo_moneda_getsimbolo(vtipomonedaid character varying) RETURNS character varying
    LANGUAGE plpgsql
    AS $$
declare vsimbolo varchar default '';
BEGIN
	select t.simbolo into vsimbolo from basic.tipo_moneda t where t.tipomonedaid=vtipomonedaid;
	return coalesce(vsimbolo, '');
END
$$;


ALTER FUNCTION basic.patipo_moneda_getsimbolo(vtipomonedaid character varying) OWNER TO radiosan_ustaana;

--
-- Name: patipo_moneda_leer(character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipo_moneda_leer(innombre character varying) RETURNS SETOF type_tipo_moneda_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select t.tipomonedaid, t.nombre, t.abreviatura, t.simbolo, t.codigo_contable, t.codigo_ple
		from basic.tipo_moneda t
		where 1=1
			and case when trim(innombre)!='' then upper(buscar(nombre)) like '%'|| upper(buscar(innombre)) ||'%' else true end
		order by nombre;
END
$$;


ALTER FUNCTION basic.patipo_moneda_leer(innombre character varying) OWNER TO radiosan_ustaana;

--
-- Name: patipo_proceso_actualizar(boolean, integer, character varying, character varying, integer, boolean); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipo_proceso_actualizar(innew boolean, intipoprocesoid integer, innombre character varying, indescripcion character varying, inorden integer, inestado boolean) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select tipoprocesoid from basic.tipo_proceso where lower(buscar(trim(nombre)))=lower(buscar(trim(innombre))) and tipoprocesoid!=intipoprocesoid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema ha detectado que el nombre ya existe en la base de datos.';
	end if;
	If vState Then
		If innew Then
			insert into basic.tipo_proceso values(default, innombre, indescripcion, basic.patipo_proceso_lastorder()+1, inestado);
			vID:=lastval();
		else
			update basic.tipo_proceso set nombre=innombre, descripcion=indescripcion, estado=inestado where tipoprocesoid=intipoprocesoid;
			vID:=intipoprocesoid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.patipo_proceso_actualizar(innew boolean, intipoprocesoid integer, innombre character varying, indescripcion character varying, inorden integer, inestado boolean) OWNER TO radiosan_ustaana;

--
-- Name: patipo_proceso_cambiar_estado(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipo_proceso_cambiar_estado(vtipoprocesoid integer, vusuario integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vEstadoOld boolean default false;
BEGIN
	if vState then
		if exists(select * from basic.tipo_proceso where tipoprocesoid=vtipoprocesoid) then
			--RASTRO
			select estado into vEstadoOld from basic.tipo_proceso where tipoprocesoid=vtipoprocesoid;
			insert into rastro.campo values(default, 'basic', 'tipo_proceso', 'estado', 'B', vtipoprocesoid, 0, 0, vEstadoOld::varchar, (not vEstadoOld)::varchar, current_timestamp, vusuario, vip, 1, 0);
			
			update basic.tipo_proceso set estado=not estado where tipoprocesoid=vtipoprocesoid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.patipo_proceso_cambiar_estado(vtipoprocesoid integer, vusuario integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: patipo_proceso_change_order(integer[], integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipo_proceso_change_order(myarr integer[], vstart integer) RETURNS void
    LANGUAGE plpgsql
    AS $$
declare myRow record;
BEGIN
	for myRow in select myarr[i] as id, i as orden from generate_series(1, array_upper(myarr, 1)) as i loop
		update basic.tipo_proceso set orden=myRow.orden+(case when vstart>1 then vstart-1 else 0 end) where tipoprocesoid=myRow.id;
	end loop;
END
$$;


ALTER FUNCTION basic.patipo_proceso_change_order(myarr integer[], vstart integer) OWNER TO radiosan_ustaana;

--
-- Name: patipo_proceso_eliminar(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipo_proceso_eliminar(intipoprocesoid integer) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.proceso where tipoprocesoid=intipoprocesoid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar el registro por tener procesos relacionados.';
	end if;
	if vState then
		delete from basic.tipo_proceso where tipoprocesoid=intipoprocesoid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.patipo_proceso_eliminar(intipoprocesoid integer) OWNER TO radiosan_ustaana;

--
-- Name: patipo_proceso_lastorder(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipo_proceso_lastorder() RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vOrden integer default 0;
BEGIN
	select max(t.orden) into vOrden from basic.tipo_proceso t;
	return coalesce(vOrden, 0);
END
$$;


ALTER FUNCTION basic.patipo_proceso_lastorder() OWNER TO radiosan_ustaana;

--
-- Name: patipo_proceso_leer(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipo_proceso_leer() RETURNS SETOF type_tipo_proceso_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp cascade;
	create temporary table tmp(type integer not null, tipoprocesoid integer not null, count integer not null);
	insert into tmp select 1, tipoprocesoid, count(*) from basic.proceso group by 2;
	
	return query 
		select tp.tipoprocesoid, tp.nombre, tp.descripcion, tp.orden, tp.estado, coalesce(tmp_p.count, 0)::integer
		from basic.tipo_proceso tp left join tmp tmp_p on tp.tipoprocesoid=tmp_p.tipoprocesoid and 1=tmp_p.type
		where 1=1 order by tp.orden, tp.nombre;
		
	drop table if exists tmp cascade;
END
$$;


ALTER FUNCTION basic.patipo_proceso_leer() OWNER TO radiosan_ustaana;

--
-- Name: patipo_socialmedia_actualizar(boolean, integer, character varying, character varying, character varying, boolean); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipo_socialmedia_actualizar(innew boolean, intiposocialmediaid integer, innombre character varying, inurl character varying, inicono character varying, inestado boolean) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.tipo_socialmedia t where lower(buscar(trim(t.nombre)))=lower(buscar(trim(innombre))) and t.tiposocialmediaid!=intiposocialmediaid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre ya existe en la base de datos';
	end if;
	If vState Then
		If innew Then
			insert into basic.tipo_socialmedia values(default, trim(innombre), trim(inurl), trim(inicono), basic.patipo_socialmedia_lastorder()+1, inestado);
			vID:=lastval();
		Else
			update basic.tipo_socialmedia set nombre=trim(innombre), url=trim(inurl), icono=trim(inicono), estado=inestado where tiposocialmediaid=intiposocialmediaid;
			vID:=intiposocialmediaid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.patipo_socialmedia_actualizar(innew boolean, intiposocialmediaid integer, innombre character varying, inurl character varying, inicono character varying, inestado boolean) OWNER TO radiosan_ustaana;

--
-- Name: patipo_socialmedia_change_order(integer[], integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipo_socialmedia_change_order(myarr integer[], vstart integer) RETURNS void
    LANGUAGE plpgsql
    AS $$
declare myRow record;
BEGIN
	for myRow in select myarr[i] as id, i as orden from generate_series(1, array_upper(myarr, 1)) as i loop
		update basic.tipo_socialmedia set orden=myRow.orden+(case when vstart>1 then vstart-1 else 0 end) where tiposocialmediaid=myRow.id;
	end loop;
END
$$;


ALTER FUNCTION basic.patipo_socialmedia_change_order(myarr integer[], vstart integer) OWNER TO radiosan_ustaana;

--
-- Name: patipo_socialmedia_eliminar(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipo_socialmedia_eliminar(incodigo integer) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.persona_socialmedia where tiposocialmediaid=incodigo) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar el registro por tener personas relacionadas.';
	end if;
	if vState=true then
		delete from basic.tipo_socialmedia where tiposocialmediaid=inCodigo;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.patipo_socialmedia_eliminar(incodigo integer) OWNER TO radiosan_ustaana;

--
-- Name: patipo_socialmedia_lastorder(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipo_socialmedia_lastorder() RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vOrden integer default 0;
BEGIN
	select max("orden") into vOrden from basic.tipo_socialmedia;
	return coalesce(vOrden, 0);
END
$$;


ALTER FUNCTION basic.patipo_socialmedia_lastorder() OWNER TO radiosan_ustaana;

--
-- Name: tipo_socialmedia; Type: TABLE; Schema: basic; Owner: radiosan_ustaana; Tablespace: 
--

CREATE TABLE tipo_socialmedia (
    tiposocialmediaid integer NOT NULL,
    nombre character varying(50) NOT NULL,
    url character varying(250) NOT NULL,
    icono character varying(250) NOT NULL,
    orden integer NOT NULL,
    estado boolean NOT NULL
);


ALTER TABLE basic.tipo_socialmedia OWNER TO radiosan_ustaana;

--
-- Name: patipo_socialmedia_leer(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipo_socialmedia_leer() RETURNS SETOF tipo_socialmedia
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select * from basic.tipo_socialmedia where tiposocialmediaid>0 order by orden
	;
END
$$;


ALTER FUNCTION basic.patipo_socialmedia_leer() OWNER TO radiosan_ustaana;

--
-- Name: patipo_telefono_actualizar(boolean, integer, character varying, boolean, boolean, boolean); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipo_telefono_actualizar(innew boolean, intipotelefonoid integer, innombre character varying, inrequerido boolean, inpordefecto boolean, inestado boolean) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.tipo_telefono t where lower(buscar(trim(t.nombre)))=lower(buscar(trim(innombre))) and t.tipotelefonoid!=intipotelefonoid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre ya existe en la base de datos';
	end if;
	If vState Then
		If innew Then
			insert into basic.tipo_telefono values(default, trim(innombre), inrequerido, inpordefecto, basic.patipo_telefono_lastorder()+1, inestado);
			vID:=lastval();
		Else
			update basic.tipo_telefono set nombre=trim(innombre), requerido=inrequerido, pordefecto=inpordefecto, estado=inestado where tipotelefonoid=intipotelefonoid;
			vID:=intipotelefonoid;
		end if;
		if inpordefecto then 
			update basic.tipo_telefono set pordefecto=false where tipotelefonoid!=vID;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.patipo_telefono_actualizar(innew boolean, intipotelefonoid integer, innombre character varying, inrequerido boolean, inpordefecto boolean, inestado boolean) OWNER TO radiosan_ustaana;

--
-- Name: patipo_telefono_change_order(integer[], integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipo_telefono_change_order(myarr integer[], vstart integer) RETURNS void
    LANGUAGE plpgsql
    AS $$
declare myRow record;
BEGIN
	for myRow in select myarr[i] as id, i as orden from generate_series(1, array_upper(myarr, 1)) as i loop
		update basic.tipo_telefono set orden=myRow.orden+(case when vstart>1 then vstart-1 else 0 end) where tipotelefonoid=myRow.id;
	end loop;
END
$$;


ALTER FUNCTION basic.patipo_telefono_change_order(myarr integer[], vstart integer) OWNER TO radiosan_ustaana;

--
-- Name: patipo_telefono_eliminar(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipo_telefono_eliminar(intipotelefonoid integer) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.persona_telefono where tipotelefonoid=intipotelefonoid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar el tipo de telefono por tener personas relacionadas.';
	end if;
	if vState then
		delete from basic.tipo_telefono where tipotelefonoid=intipotelefonoid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.patipo_telefono_eliminar(intipotelefonoid integer) OWNER TO radiosan_ustaana;

--
-- Name: patipo_telefono_lastorder(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipo_telefono_lastorder() RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vOrden integer default 0;
BEGIN
	select max(t.orden) into vOrden from basic.tipo_telefono t;
	return coalesce(vOrden, 0);
END
$$;


ALTER FUNCTION basic.patipo_telefono_lastorder() OWNER TO radiosan_ustaana;

--
-- Name: tipo_telefono; Type: TABLE; Schema: basic; Owner: radiosan_ustaana; Tablespace: 
--

CREATE TABLE tipo_telefono (
    tipotelefonoid integer NOT NULL,
    nombre character varying(50) NOT NULL,
    requerido boolean NOT NULL,
    pordefecto boolean NOT NULL,
    orden integer NOT NULL,
    estado boolean NOT NULL
);


ALTER TABLE basic.tipo_telefono OWNER TO radiosan_ustaana;

--
-- Name: patipo_telefono_leer(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipo_telefono_leer() RETURNS SETOF tipo_telefono
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select * from basic.tipo_telefono where tipotelefonoid>0 order by orden
	;
END
$$;


ALTER FUNCTION basic.patipo_telefono_leer() OWNER TO radiosan_ustaana;

--
-- Name: patipoarchivo_actualizar(boolean, integer, character varying, character varying, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipoarchivo_actualizar(innew boolean, intipoarchivoid integer, innombre character varying, inabreviatura character varying, inextension character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.tipoarchivo t where trim(upper(buscar(t.nombre)))=trim(upper(buscar(innombre))) and t.tipoarchivoid!=intipoarchivoid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre del tipo de archivo ya existe en la base de datos';
	end if;
	if vState then
		if exists(select * from basic.tipoarchivo t where trim(upper(buscar(t.extension)))=trim(upper(buscar(inextension))) and t.tipoarchivoid!=intipoarchivoid) then
			vState:=false; vID:=0; vError:=1; vDescripcion:='La extension del tipo de archivo ya existe en la base de datos';
		end if;
	end if;
	if vState then
		If inNew Then
			insert into basic.tipoarchivo values(default, trim(innombre), trim(inabreviatura), trim(inextension), basic.patipoarchivo_lastorder()+1, true);
			vID:=lastval();
		Else
			update basic.tipoarchivo set nombre=trim(innombre), abreviatura=trim(inabreviatura), extension=trim(inextension) where tipoarchivoid=intipoarchivoid;
			vID:=intipoarchivoid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.patipoarchivo_actualizar(innew boolean, intipoarchivoid integer, innombre character varying, inabreviatura character varying, inextension character varying) OWNER TO radiosan_ustaana;

--
-- Name: patipoarchivo_change_order(integer[], integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipoarchivo_change_order(myarr integer[], vstart integer) RETURNS void
    LANGUAGE plpgsql
    AS $$
declare myRow record;
BEGIN
	for myRow in select myarr[i] as id, i as orden from generate_series(1, array_upper(myarr, 1)) as i loop
		update basic.tipoarchivo set orden=myRow.orden+(case when vstart>1 then vstart-1 else 0 end) where tipoarchivoid=myRow.id;
	end loop;
END
$$;


ALTER FUNCTION basic.patipoarchivo_change_order(myarr integer[], vstart integer) OWNER TO radiosan_ustaana;

--
-- Name: patipoarchivo_eliminar(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipoarchivo_eliminar(intipoarchivoid integer) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if vState=true then
		delete from basic.tipoarchivo where tipoarchivoid=intipoarchivoid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.patipoarchivo_eliminar(intipoarchivoid integer) OWNER TO radiosan_ustaana;

--
-- Name: patipoarchivo_lastorder(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipoarchivo_lastorder() RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vOrden integer default 0;
BEGIN
	select max(t.orden) into vOrden from basic.tipoarchivo t;
	return coalesce(vOrden, 0);
END
$$;


ALTER FUNCTION basic.patipoarchivo_lastorder() OWNER TO radiosan_ustaana;

--
-- Name: tipoarchivo; Type: TABLE; Schema: basic; Owner: radiosan_ustaana; Tablespace: 
--

CREATE TABLE tipoarchivo (
    tipoarchivoid integer NOT NULL,
    nombre character varying(50) NOT NULL,
    abreviatura character varying(20) NOT NULL,
    extension character varying(10) NOT NULL,
    orden integer NOT NULL,
    estado boolean NOT NULL
);


ALTER TABLE basic.tipoarchivo OWNER TO radiosan_ustaana;

--
-- Name: patipoarchivo_leer(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipoarchivo_leer() RETURNS SETOF tipoarchivo
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query select * from basic.tipoarchivo t order by t.orden, t.nombre;
END
$$;


ALTER FUNCTION basic.patipoarchivo_leer() OWNER TO radiosan_ustaana;

--
-- Name: patipoid_actualizar(boolean, integer, character varying, character varying, character varying, integer, boolean, boolean); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipoid_actualizar(innew boolean, intipoid integer, innombre character varying, inabreviatura character varying, incodigo_contable character varying, inlongitud integer, inpordefecto boolean, inestado boolean) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.tipoid t where buscar(trim(upper(t.nombre)))=buscar(trim(upper(innombre))) and t.tipoid!=intipoid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre del tipo de documento ya existe.';
	end if;
	If vState Then
		if trim(inabreviatura)!='' then
			if exists(select * from basic.tipoid t where lower(buscar(trim(t.abreviatura)))=lower(buscar(trim(inabreviatura))) and t.tipoid!=intipoid) then
				vState:=false; vID:=0; vError:=1; vDescripcion:='La abreviatura del tipo de documento ya existe en la base de datos';
			end if;
		end if;
	end if;
	If vState Then
		if inNew then
			insert into basic.tipoid values(default, trim(innombre), trim(inabreviatura), trim(incodigo_contable), inlongitud, inpordefecto, basic.patipoid_lastorder()+1, inestado);
			vID:=lastval();
		else
			update basic.tipoid set nombre=trim(innombre), abreviatura=trim(inabreviatura), codigo_contable=trim(incodigo_contable), longitud=inlongitud, pordefecto=inpordefecto, estado=inestado where tipoid=intipoid;
			vID:=intipoid;
		end if;
		if inpordefecto then
			update basic.tipoid set pordefecto=false where tipoid!=vID;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.patipoid_actualizar(innew boolean, intipoid integer, innombre character varying, inabreviatura character varying, incodigo_contable character varying, inlongitud integer, inpordefecto boolean, inestado boolean) OWNER TO radiosan_ustaana;

--
-- Name: patipoid_eliminar(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipoid_eliminar(intipoid integer) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	--if exists(select * from basic.persona where tipoid_doc=intipoid limit 1) then
	--	vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar este tipo de documento por tener personas registradas.';
	--end if;
	if vState then
		delete from basic.tipoid where tipoid=intipoid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.patipoid_eliminar(intipoid integer) OWNER TO radiosan_ustaana;

--
-- Name: patipoid_lastorder(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipoid_lastorder() RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vOrden integer default 0;
BEGIN
	select max(t.orden) into vOrden from basic.tipoid t;
	return coalesce(vOrden, 0);
END
$$;


ALTER FUNCTION basic.patipoid_lastorder() OWNER TO radiosan_ustaana;

--
-- Name: patipoid_leer(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipoid_leer() RETURNS SETOF type_tipoid_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select t.tipoid, t.nombre, t.abreviatura, t.codigo_contable, t.longitud, t.pordefecto, t.orden, t.estado
		from basic.tipoid t
		where t.tipoid>0
		order by t.orden, t.tipoid;
END
$$;


ALTER FUNCTION basic.patipoid_leer() OWNER TO radiosan_ustaana;

--
-- Name: patipooperacion_actualizar(boolean, integer, character varying, character varying, character, boolean); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipooperacion_actualizar(innew boolean, intipooperacionid integer, innombre character varying, inabreviatura character varying, incodigo_contable character, inestado boolean) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.tipooperacion t where trim(buscar(upper(t.nombre)))=trim(buscar(upper(innombre))) and t.tipooperacionid!=intipooperacionid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre del tipo de operacion ya existe.';
	end if;
	If vState Then
		if trim(incodigo_contable)!='' then
			if exists(select * from basic.tipooperacion t where trim(buscar(upper(t.codigo_contable)))=trim(buscar(upper(incodigo_contable))) and t.tipooperacionid!=intipooperacionid) then
				vState:=false; vID:=0; vError:=1; vDescripcion:='El codigo contable del tipo de operacion ya existe.';
			end if;
		end if;
	end if;
	If vState Then
		If innew Then
			insert into basic.tipooperacion values(default, trim(innombre), trim(inabreviatura), trim(incodigo_contable), basic.patipooperacion_lastorder(), inestado);
			vID:=lastval();
		Else
			update basic.tipooperacion set nombre=trim(innombre), abreviatura=trim(inabreviatura), codigo_contable=trim(incodigo_contable), estado=inestado where tipooperacionid=intipooperacionid;
			vID:=intipooperacionid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.patipooperacion_actualizar(innew boolean, intipooperacionid integer, innombre character varying, inabreviatura character varying, incodigo_contable character, inestado boolean) OWNER TO radiosan_ustaana;

--
-- Name: patipooperacion_consulta(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipooperacion_consulta() RETURNS SETOF type_tipooperacion_consulta
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select t.tipooperacionid, t.nombre, t.abreviatura, t.codigo_contable, t.orden
		from basic.tipooperacion t 
		where t.estado=true order by t.orden;
END
$$;


ALTER FUNCTION basic.patipooperacion_consulta() OWNER TO radiosan_ustaana;

--
-- Name: patipooperacion_eliminar(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipooperacion_eliminar(vtipooperacionid integer, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from inventarios.venta where tipo=vtipooperacionid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar el tipo de operacion por tener ventas relacionadas.';
	end if;
	if vState=true then
		delete from basic.tipooperacion where tipooperacionid=vtipooperacionid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.patipooperacion_eliminar(vtipooperacionid integer, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: patipooperacion_lastorder(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipooperacion_lastorder() RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vOrden integer default 0;
BEGIN
	select max(t.orden) into vOrden from basic.tipooperacion t;
	return coalesce(vOrden, 0);
END
$$;


ALTER FUNCTION basic.patipooperacion_lastorder() OWNER TO radiosan_ustaana;

--
-- Name: patipooperacion_leer(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patipooperacion_leer() RETURNS SETOF type_tipooperacion_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select t.tipooperacionid, t.nombre, t.abreviatura, t.codigo_contable, t.orden, t.estado
		from basic.tipooperacion t order by t.orden;
END
$$;


ALTER FUNCTION basic.patipooperacion_leer() OWNER TO radiosan_ustaana;

--
-- Name: patiporegimen_actualizar(boolean, integer, character varying, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patiporegimen_actualizar(innew boolean, intiporegimenid integer, innombre character varying, inabreviatura character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.tiporegimen t where trim(upper(buscar(t.nombre)))=trim(upper(buscar(innombre))) and t.tiporegimenid!=intiporegimenid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre del tiporegimen ya existe en la base de datos';
	end if;
	if vState then
		if trim(inabreviatura)!='' then
			if exists(select * from basic.tiporegimen t where trim(upper(buscar(t.abreviatura)))=trim(upper(buscar(inabreviatura))) and t.tiporegimenid!=intiporegimenid) then
				vState:=false; vID:=0; vError:=1; vDescripcion:='La abreviatura del tiporegimen ya existe en la base de datos';
			end if;
		end if;
	end if;
	if vState then
		If inNew Then
			insert into basic.tiporegimen values(default, trim(innombre), trim(inabreviatura), basic.patiporegimen_lastorder()+1, true);
			vID:=lastval();
		Else
			update basic.tiporegimen set nombre=trim(innombre), abreviatura=trim(inabreviatura) where tiporegimenid=intiporegimenid;
			vID:=intiporegimenid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.patiporegimen_actualizar(innew boolean, intiporegimenid integer, innombre character varying, inabreviatura character varying) OWNER TO radiosan_ustaana;

--
-- Name: patiporegimen_cambiar_estado(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patiporegimen_cambiar_estado(vtiporegimenid integer, vusuario integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vEstadoOld boolean default false;
BEGIN
	if vState then
		if exists(select * from basic.tiporegimen where tiporegimenid=vtiporegimenid) then
			--RASTRO
			select estado into vEstadoOld from basic.tiporegimen where tiporegimenid=vtiporegimenid;
			insert into rastro.campo values(default, 'basic', 'tiporegimen', 'estado', 'B', vtiporegimenid, 0, 0, vEstadoOld::varchar, (not vEstadoOld)::varchar, current_date, current_time, vusuario, vip, 1, 0);
			
			update basic.tiporegimen set estado=not estado where tiporegimenid=vtiporegimenid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.patiporegimen_cambiar_estado(vtiporegimenid integer, vusuario integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: patiporegimen_change_order(integer[], integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patiporegimen_change_order(myarr integer[], vstart integer) RETURNS void
    LANGUAGE plpgsql
    AS $$
declare myRow record;
BEGIN
	for myRow in select myarr[i] as id, i as orden from generate_series(1, array_upper(myarr, 1)) as i loop
		update basic.tiporegimen set orden=myRow.orden+(case when vstart>1 then vstart-1 else 0 end) where tiporegimenid=myRow.id;
	end loop;
END
$$;


ALTER FUNCTION basic.patiporegimen_change_order(myarr integer[], vstart integer) OWNER TO radiosan_ustaana;

--
-- Name: patiporegimen_eliminar(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patiporegimen_eliminar(vtiporegimenid integer, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if vState=true then
		delete from basic.tiporegimen where tiporegimenid=vtiporegimenid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.patiporegimen_eliminar(vtiporegimenid integer, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: patiporegimen_lastorder(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patiporegimen_lastorder() RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vOrden integer default 0;
BEGIN
	select max(t.orden) into vOrden from basic.tiporegimen t;
	return coalesce(vOrden, 0);
END
$$;


ALTER FUNCTION basic.patiporegimen_lastorder() OWNER TO radiosan_ustaana;

--
-- Name: patiporegimen_leer(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION patiporegimen_leer() RETURNS SETOF type_tiporegimen_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select c.tiporegimenid, c.nombre, c.abreviatura, c.orden, c.estado 
		from basic.tiporegimen c
		where c.tiporegimenid>0 
		order by c.orden, c.nombre;
END
$$;


ALTER FUNCTION basic.patiporegimen_leer() OWNER TO radiosan_ustaana;

--
-- Name: paubigeoexport(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paubigeoexport() RETURNS void
    LANGUAGE plpgsql
    AS $$
declare myRow record;
BEGIN
	for myRow in select * from basic.departamento loop
		raise notice 'insert into rastro.departamento values(%, ''%'', ''%'', true);', myRow.departamentoid, myRow.nombre, myRow.abreviatura;
	end loop;
	for myRow in select * from basic.provincia loop
		raise notice 'insert into rastro.provincia values(%, ''%'', ''%'', %, true);', myRow.provinciaid, myRow.nombre, myRow.abreviatura, myRow.departamentoid;
	end loop;
	for myRow in select * from basic.distrito loop
		raise notice 'insert into rastro.distrito values(%, ''%'', ''%'', %, true);', myRow.distritoid, myRow.nombre, myRow.abreviatura, myRow.provinciaid;
	end loop;
END
$$;


ALTER FUNCTION basic.paubigeoexport() OWNER TO radiosan_ustaana;

--
-- Name: paunidad_negocio_actualizar(boolean, integer, integer, character varying, character varying, character varying, character varying, character varying, integer, boolean); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paunidad_negocio_actualizar(innew boolean, inunidadnegocioid integer, inempresaid integer, innombre character varying, inabreviatura character varying, indireccion character varying, intelefono character varying, inurl character varying, intipoempresaid integer, inestado boolean) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.unidad_negocio un where trim(upper(buscar(un.nombre)))=trim(upper(buscar(innombre))) and un.unidadnegocioid!=inunidadnegocioid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre de la unidad de negocio ya existe.';
	end if;
	If vState Then
		if trim(inabreviatura)!='' then
			if exists(select * from basic.unidad_negocio un where trim(upper(buscar(un.abreviatura)))=trim(upper(buscar(inabreviatura))) and un.unidadnegocioid!=inunidadnegocioid) then
				vState:=false; vID:=0; vError:=1; vDescripcion:='La abreviatura de la unidad de negocio ya existe.';
			end if;
		end if;
	end if;
	If vState Then
		if inNew Then
			insert into basic.unidad_negocio values(default, inempresaid, trim(innombre), trim(inabreviatura), trim(indireccion), trim(intelefono), trim(inurl), intipoempresaid, basic.paunidad_negocio_lastorder()+1, inestado);
			vID:=lastval();
		else
			update basic.unidad_negocio set empresaid=inempresaid, nombre=trim(innombre), abreviatura=trim(inabreviatura), direccion=trim(indireccion), telefono=trim(intelefono), url=trim(inurl), tipoempresaid=intipoempresaid, estado=inestado where unidadnegocioid=inunidadnegocioid;
			vID:=inunidadnegocioid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paunidad_negocio_actualizar(innew boolean, inunidadnegocioid integer, inempresaid integer, innombre character varying, inabreviatura character varying, indireccion character varying, intelefono character varying, inurl character varying, intipoempresaid integer, inestado boolean) OWNER TO radiosan_ustaana;

--
-- Name: paunidad_negocio_cambiar_estado(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paunidad_negocio_cambiar_estado(vunidadnegocioid integer, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vEstadoOld boolean default false;
BEGIN
	if vState then
		if exists(select * from basic.unidad_negocio where unidadnegocioid=vunidadnegocioid) then
			--RASTRO
			select estado into vEstadoOld from basic.unidad_negocio where unidadnegocioid=vunidadnegocioid;
			insert into rastro.campo values(default, 'basic', 'unidad_negocio', 'estado', 'B', vunidadnegocioid, 0, 0, vEstadoOld::varchar, (not vEstadoOld)::varchar, current_timestamp, vusuarioid, vip, 1, 0);
			
			update basic.unidad_negocio set estado=not estado where unidadnegocioid=vunidadnegocioid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paunidad_negocio_cambiar_estado(vunidadnegocioid integer, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: paunidad_negocio_consultar(integer, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paunidad_negocio_consultar(vpersonaid integer, vmoduloid integer) RETURNS SETOF type_unidad_negocio_consultar
    LANGUAGE plpgsql
    AS $$
DECLARE vUsuario varchar(20) default '';
BEGIN
	select usuario into vUsuario from basic.clave where personaid=vpersonaid;

	drop table if exists tmp_uni cascade;
	create temporary table tmp_uni(unidadnegocioid integer not null);
	if vUsuario='admin' then
		insert into tmp_uni select unidadnegocioid from basic.unidad_negocio;
	else
		insert into tmp_uni select unidadnegocioid from basic.permisos_unidad_negocio where personaid=vpersonaid and moduloid=vmoduloid;
	end if;
	return query 
		select un.unidadnegocioid, un.nombre, un.abreviatura, un.empresaid, emp.nombre, un.tipoempresaid, te.nombre
		from tmp_uni tmp inner join basic.unidad_negocio un on tmp.unidadnegocioid=un.unidadnegocioid
			inner join basic.empresa emp on un.empresaid=emp.empresaid
			inner join basic.tipo_empresa te on un.tipoempresaid=te.tipoempresaid
		order by un.nombre;
	drop table if exists tmp_uni cascade;
END
$$;


ALTER FUNCTION basic.paunidad_negocio_consultar(vpersonaid integer, vmoduloid integer) OWNER TO radiosan_ustaana;

--
-- Name: paunidad_negocio_eliminar(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paunidad_negocio_eliminar(vunidadnegocioid integer, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.almacen where unidadnegocioid=vunidadnegocioid limit 1) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar la unidad por tener almacenes registradas.';
	end if;
	if vState then
		delete from basic.permisos_unidad_negocio where unidadnegocioid=vunidadnegocioid;
		delete from basic.unidad_negocio where unidadnegocioid=vunidadnegocioid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.paunidad_negocio_eliminar(vunidadnegocioid integer, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: paunidad_negocio_lastorder(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paunidad_negocio_lastorder() RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vOrden integer default 0;
BEGIN
	select max(orden) into vOrden from basic.unidad_negocio;
	return coalesce(vOrden, 0);
END
$$;


ALTER FUNCTION basic.paunidad_negocio_lastorder() OWNER TO radiosan_ustaana;

--
-- Name: paunidad_negocio_leer(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION paunidad_negocio_leer(vempresaid integer) RETURNS SETOF type_unidad_negocio_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query
		select un.unidadnegocioid, un.nombre, un.abreviatura, un.direccion, un.telefono, un.empresaid, e.nombre, te.tipoempresaid, te.nombre, un.orden, un.estado
		from basic.unidad_negocio un inner join basic.empresa e on un.empresaid=e.empresaid
			inner join basic.tipo_empresa te on un.tipoempresaid=te.tipoempresaid
		where 1=1
			and case when vempresaid>0 then un.empresaid=vempresaid else true end
		order by un.nombre
	;
END
$$;


ALTER FUNCTION basic.paunidad_negocio_leer(vempresaid integer) OWNER TO radiosan_ustaana;

--
-- Name: pavisita_intranet_actualizar(boolean, integer, character varying, integer, character varying, character varying, character varying, boolean, character varying, character varying, character varying, boolean); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pavisita_intranet_actualizar(innew boolean, inid integer, inintranet character varying, inpersonaid integer, inusuario character varying, inclave character varying, inip character varying, inexito boolean, inbrowser character varying, inbrowser_version character varying, inplataform character varying, inmobile boolean) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	If inNew Then
		If vState Then
			insert into basic.visita_intranet values(default, inintranet, current_timestamp, inpersonaid, inusuario, inclave, inip, current_timestamp, inexito, inbrowser, inbrowser_version, inplataform, inmobile);
			vID:=lastval();
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.pavisita_intranet_actualizar(innew boolean, inid integer, inintranet character varying, inpersonaid integer, inusuario character varying, inclave character varying, inip character varying, inexito boolean, inbrowser character varying, inbrowser_version character varying, inplataform character varying, inmobile boolean) OWNER TO radiosan_ustaana;

--
-- Name: pavisita_intranet_count(character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pavisita_intranet_count(vintranet character varying, vdesde character varying, vhasta character varying, vtexto character varying, vexito character varying, vbrowser character varying, vplataform character varying, vmobile character varying, vpersonaid integer) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vCount integer default 0;
begin
	select count(*) into vCount
	from basic.visita_intranet v left join basic.persona p on v.personaid=p.personaid 
		left join basic.persona_natural pnalu on p.personaid=pnalu.personaid
		left join basic.persona_juridica pjalu on p.personaid=pjalu.personaid
		left join basic.clave c on p.personaid=c.personaid
	where v.intranet=vintranet 
		and case when vdesde!='' then v.fechaintento>=cast(vdesde as date) else true end 
		and case when vhasta!='' then v.fechaintento<=cast(vhasta as date) else true end 
		and case when trim(vtexto)!='' then (upper(buscar(v.usuario)) like upper(buscar('%'||vtexto||'%')) 
			or upper(buscar(c.usuario)) like upper(buscar('%'||vtexto||'%'))   
			or upper(buscar(pnalu.ape_pat)) like upper(buscar('%'||vtexto||'%'))  
			or upper(buscar(pnalu.ape_mat)) like upper(buscar('%'||vtexto||'%')) 
			or upper(buscar(pnalu.nombre)) like upper(buscar('%'||vtexto||'%'))  
			or upper(buscar(v.ip)) like upper(buscar('%'||vtexto||'%'))  ) 
		else true end
		and case when vexito!='' then (case when vexito='Y' then v.exito=true else v.exito=false end) else true end 
		and case when trim(vbrowser)!='' then trim(upper(v.browser))=trim(upper(vbrowser)) else true end
		and case when trim(vplataform)!='' then trim(upper(v.plataform))=trim(upper(vplataform)) else true end
		and case when vmobile!='' then (case when vmobile='Y' then v.mobile=true else v.mobile=false end) else true end 
		and case when vpersonaid>0 then v.personaid=vpersonaid else true end
	;
	return coalesce(vCount, 0);
END
$$;


ALTER FUNCTION basic.pavisita_intranet_count(vintranet character varying, vdesde character varying, vhasta character varying, vtexto character varying, vexito character varying, vbrowser character varying, vplataform character varying, vmobile character varying, vpersonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: pavisita_intranet_getrow(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pavisita_intranet_getrow(vvisitaid integer) RETURNS SETOF type_visita_intranet_getrow
    LANGUAGE plpgsql
    AS $$
begin

	return query
	select v.codigo,v.intranet, to_char(v.fechaintento, 'DD/MM/YYYY HH12:MI AM')::varchar, to_char(v.fechaintento, 'DD/MM/YYYY')::varchar, to_char(v.fechaintento, 'HH:MI:SS AM')::varchar, v.personaid, v.usuario, v.clave, v.ip, v.exito,
		 upper(case when p.personaid is null then '' else (case when tipo='N' then (coalesce(pnalu.ape_pat,'') || ' ' || coalesce(pnalu.ape_mat,'') || ', ' || coalesce(pnalu.nombre,'')) else pjalu.raz_soc end) end)::varchar,
		 v.browser, v.browser_version, v.plataform, v.mobile, to_char(v.fechasalida, 'DD/MM/YYYY HH12:MI AM')::varchar
	from basic.visita_intranet v left join basic.persona p on v.personaid=p.personaid
		left join basic.persona_natural pnalu on p.personaid=pnalu.personaid
		left join basic.persona_juridica pjalu on p.personaid=pjalu.personaid
		left join basic.clave c on p.personaid=c.personaid
	where v.codigo=vvisitaid;
END
$$;


ALTER FUNCTION basic.pavisita_intranet_getrow(vvisitaid integer) OWNER TO radiosan_ustaana;

--
-- Name: pavisita_intranet_leer(integer, integer, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pavisita_intranet_leer(vfirst integer, vlast integer, vintranet character varying, vdesde character varying, vhasta character varying, vtexto character varying, vexito character varying, vbrowser character varying, vplataform character varying, vmobile character varying, vpersonaid integer) RETURNS SETOF type_visita_intranet_leer
    LANGUAGE plpgsql
    AS $$
begin

	return query
	select v.codigo,v.intranet, v.fechaintento, to_char(v.fechaintento, 'DD/MM/YYYY')::varchar, to_char(v.fechaintento, 'HH:MI:SS AM')::varchar, v.personaid, v.usuario, v.clave, v.ip, v.exito,
		 upper(case when p.personaid is null then '' else (case when tipo='N' then (coalesce(pnalu.ape_pat,'') || ' ' || coalesce(pnalu.ape_mat,'') || ', ' || coalesce(pnalu.nombre,'')) else pjalu.raz_soc end) end)::varchar,
		 v.browser, v.browser_version, v.plataform, v.mobile, v.fechasalida
	from basic.visita_intranet v left join basic.persona p on v.personaid=p.personaid
		left join basic.persona_natural pnalu on p.personaid=pnalu.personaid
		left join basic.persona_juridica pjalu on p.personaid=pjalu.personaid
		left join basic.clave c on p.personaid=c.personaid
	where v.intranet=vintranet 
		and case when vdesde!='' then v.fechaintento>=cast(vdesde as date) else true end 
		and case when vhasta!='' then v.fechaintento<=cast(vhasta as date) else true end 
		and case when trim(vtexto)!='' then (upper(buscar(v.usuario)) like upper(buscar('%'||vtexto||'%')) 
			or upper(buscar(c.usuario)) like upper(buscar('%'||vtexto||'%'))   
			or upper(buscar(pnalu.ape_pat)) like upper(buscar('%'||vtexto||'%'))  
			or upper(buscar(pnalu.ape_mat)) like upper(buscar('%'||vtexto||'%')) 
			or upper(buscar(pnalu.nombre)) like upper(buscar('%'||vtexto||'%'))  
			or upper(buscar(v.ip)) like upper(buscar('%'||vtexto||'%'))  ) 
		else true end
		and case when vexito!='' then (case when vexito='Y' then v.exito=true else v.exito=false end) else true end 
		and case when trim(vbrowser)!='' then trim(upper(v.browser))=trim(upper(vbrowser)) else true end
		and case when trim(vplataform)!='' then trim(upper(v.plataform))=trim(upper(vplataform)) else true end
		and case when vmobile!='' then (case when vmobile='Y' then v.mobile=true else v.mobile=false end) else true end 
		and case when vpersonaid>0 then v.personaid=vpersonaid else true end
	order by v.fechaintento desc, v.codigo
	limit case when vfirst=0 and vlast=0 then null else vlast end offset vfirst
	;
END
$$;


ALTER FUNCTION basic.pavisita_intranet_leer(vfirst integer, vlast integer, vintranet character varying, vdesde character varying, vhasta character varying, vtexto character varying, vexito character varying, vbrowser character varying, vplataform character varying, vmobile character varying, vpersonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: pavisita_intranet_resumen_browser(character varying, character varying, character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pavisita_intranet_resumen_browser(vintranet character varying, vdesde character varying, vhasta character varying, vexito character varying, vmobile character varying, vplataform character varying) RETURNS SETOF type_visita_intranet_resumen_browser
    LANGUAGE plpgsql
    AS $$
declare vTotal bigint default 0;
BEGIN
	drop table if exists tmp, tmp_resumen cascade;
	create temporary table tmp(browser varchar(50) not null, cantidad bigint not null);
	create temporary table tmp_resumen(browser varchar(50) not null, cantidad bigint not null);
	insert into tmp
		select v.browser, count(*) 
		from basic.visita_intranet v
		where v.intranet=vintranet and trim(v.browser)!=''
			and case when trim(vdesde)!='' then v.fechaintento>=cast(vdesde as date) else true end
			and case when trim(vhasta)!='' then v.fechaintento<=cast(vhasta as date) else true end
			and case when trim(vexito)!='' then v.exito=(trim(vexito)='Y') else true end
			and case when trim(vmobile)!='' then v.mobile=(trim(vmobile)='Y') else true end 
			and case when trim(vplataform)!='' then upper(v.plataform)=upper(vplataform) else true end
		group by 1 
		order by 2 desc
	;
	insert into tmp_resumen select 'Chrome', coalesce(sum(cantidad), 0) from tmp where lower(browser) like '%chrome%';
	insert into tmp_resumen select 'Internet Explorer', coalesce(sum(cantidad),0) from tmp where lower(browser) like '%internet explorer%';
	insert into tmp_resumen select 'Firefox', coalesce(sum(cantidad),0) from tmp where lower(browser) like '%firefox%' or lower(browser) like '%mozilla%';
	insert into tmp_resumen select 'Opera', coalesce(sum(cantidad),0) from tmp where lower(browser) like '%opera%';
	insert into tmp_resumen select 'Safari', coalesce(sum(cantidad),0) from tmp where lower(browser) like '%safari%' or lower(browser) like '%ipad%' or lower(browser) like '%iphone%' or lower(browser) like '%ipod%';
	select sum(cantidad) into vTotal from tmp;
	return query select browser, cantidad, round(cantidad*100/vTotal::numeric, 2)::numeric from tmp_resumen where cantidad>0 order by cantidad desc;
	--drop table if exists tmp, tmp_resumen cascade;
END
$$;


ALTER FUNCTION basic.pavisita_intranet_resumen_browser(vintranet character varying, vdesde character varying, vhasta character varying, vexito character varying, vmobile character varying, vplataform character varying) OWNER TO radiosan_ustaana;

--
-- Name: pavisita_intranet_resumen_plataform(character varying, character varying, character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pavisita_intranet_resumen_plataform(vintranet character varying, vdesde character varying, vhasta character varying, vexito character varying, vmobile character varying, vbrowser character varying) RETURNS SETOF type_visita_intranet_resumen_plataform
    LANGUAGE plpgsql
    AS $$
declare vTotal bigint default 0;
BEGIN
	drop table if exists tmp, tmp_resumen cascade;
	create temporary table tmp(plataform varchar(50) not null, cantidad bigint not null);
	create temporary table tmp_resumen(plataform varchar(50) not null, cantidad bigint not null);
	insert into tmp
		select v.plataform, count(*) 
		from basic.visita_intranet v
		where v.intranet=vintranet and trim(v.plataform)!=''
			and case when trim(vdesde)!='' then v.fechaintento>=cast(vdesde as date) else true end
			and case when trim(vhasta)!='' then v.fechaintento<=cast(vhasta as date) else true end
			and case when trim(vexito)!='' then v.exito=(trim(vexito)='Y') else true end
			and case when trim(vmobile)!='' then v.mobile=(trim(vmobile)='Y') else true end 
			and case when trim(vbrowser)!='' then upper(v.browser)=upper(vbrowser) else true end
		group by 1 
		order by 2 desc
	;
	
	insert into tmp_resumen select 'BlackBerry', coalesce(sum(cantidad), 0) from tmp where lower(plataform) like '%blackberry%';
	insert into tmp_resumen select 'Linux', coalesce(sum(cantidad),0) from tmp where lower(plataform) like '%linux%';
	insert into tmp_resumen select 'Android', coalesce(sum(cantidad),0) from tmp where lower(plataform) like '%android%';
	insert into tmp_resumen select 'Windows', coalesce(sum(cantidad),0) from tmp where lower(plataform) like '%windows%';
	insert into tmp_resumen select 'Apple', coalesce(sum(cantidad),0) from tmp where lower(plataform) like '%apple%' or lower(plataform) like '%ipad%' or lower(plataform) like '%iphone%' or lower(plataform) like '%ipod%';
	
	select sum(cantidad) into vTotal from tmp;
	return query select plataform, cantidad, round(cantidad*100/vTotal::numeric, 2)::numeric from tmp_resumen where cantidad>0 order by cantidad desc;
	drop table if exists tmp, tmp_resumen cascade;
END
$$;


ALTER FUNCTION basic.pavisita_intranet_resumen_plataform(vintranet character varying, vdesde character varying, vhasta character varying, vexito character varying, vmobile character varying, vbrowser character varying) OWNER TO radiosan_ustaana;

--
-- Name: pazona_actualizar(boolean, integer, character varying, character varying, boolean); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pazona_actualizar(innew boolean, vzonaid integer, innombre character varying, inabreviatura character varying, inestado boolean) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.zona a where trim(upper(buscar(a.nombre)))=trim(upper(buscar(innombre))) and zonaid!=vzonaid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre del zona ya existe.';
	end if;
	If vState Then
		If inNew Then
			insert into basic.zona values(default, trim(innombre), trim(inabreviatura), basic.pazona_ultimo_orden()+1, inestado);
			vID:=lastval();
		Else
			update basic.zona set nombre=trim(innombre), abreviatura=trim(inabreviatura), estado=inestado where zonaid=vzonaid;
			vID:=vzonaid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.pazona_actualizar(innew boolean, vzonaid integer, innombre character varying, inabreviatura character varying, inestado boolean) OWNER TO radiosan_ustaana;

--
-- Name: pazona_cambiar_estado(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pazona_cambiar_estado(vzonaid integer, vusuario integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vEstadoOld boolean default false;
BEGIN
	if vState then
		if exists(select * from basic.zona where zonaid=vzonaid) then
			--RASTRO
			select estado into vEstadoOld from basic.zona where zonaid=vzonaid;
			insert into rastro.campo values(default, 'basic', 'zona', 'estado', 'B', vzonaid, 0, 0, vEstadoOld::varchar, (not vEstadoOld)::varchar, current_timestamp, vusuario, vip, 1, 0);
			
			update basic.zona set estado=not estado where zonaid=vzonaid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.pazona_cambiar_estado(vzonaid integer, vusuario integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: pazona_change_order(integer[], integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pazona_change_order(myarr integer[], vstart integer) RETURNS void
    LANGUAGE plpgsql
    AS $$
declare myRow record;
BEGIN
	for myRow in select myarr[i] as id, i as orden from generate_series(1, array_upper(myarr, 1)) as i loop
		update basic.zona set orden=myRow.orden+(case when vstart>1 then vstart-1 else 0 end) where zonaid=myRow.id;
	end loop;
END
$$;


ALTER FUNCTION basic.pazona_change_order(myarr integer[], vstart integer) OWNER TO radiosan_ustaana;

--
-- Name: pazona_eliminar(integer, integer, character varying); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pazona_eliminar(vzonaid integer, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from basic.almacen where zonaid=vzonaid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar el zona por tener almacenes relacionados.';
	end if;
	if vState then
		delete from basic.zona where zonaid=vzonaid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION basic.pazona_eliminar(vzonaid integer, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: pazona_getrow(integer); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pazona_getrow(vzonaid integer) RETURNS SETOF type_zona_getrow
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query
		select z.zonaid, z.nombre, z.abreviatura, z.estado
		from basic.zona z
		where z.zonaid=vzonaid;
END
$$;


ALTER FUNCTION basic.pazona_getrow(vzonaid integer) OWNER TO radiosan_ustaana;

--
-- Name: pazona_leer(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pazona_leer() RETURNS SETOF type_zona_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query
		select z.zonaid, z.nombre, z.abreviatura, z.orden, z.estado
		from basic.zona z
		order by z.orden;
END
$$;


ALTER FUNCTION basic.pazona_leer() OWNER TO radiosan_ustaana;

--
-- Name: pazona_leer_sistema(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pazona_leer_sistema() RETURNS SETOF type_zona_leer_sistema
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query
		select z.zonaid, z.nombre, z.abreviatura, z.estado
		from basic.zona z
		order by z.orden;
END
$$;


ALTER FUNCTION basic.pazona_leer_sistema() OWNER TO radiosan_ustaana;

--
-- Name: pazona_ultimo_orden(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION pazona_ultimo_orden() RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vOrden integer default 0;
BEGIN
	select max(z.orden) into vOrden from basic.zona z;
	return coalesce(vOrden, 0);
END
$$;


ALTER FUNCTION basic.pazona_ultimo_orden() OWNER TO radiosan_ustaana;

--
-- Name: superusuario(); Type: FUNCTION; Schema: basic; Owner: radiosan_ustaana
--

CREATE FUNCTION superusuario() RETURNS character varying
    LANGUAGE plpgsql
    AS $$
BEGIN
	return 'admin';
END;
$$;


ALTER FUNCTION basic.superusuario() OWNER TO radiosan_ustaana;

SET search_path = boletaje, pg_catalog;

--
-- Name: paproceso_actualizar(boolean, integer, character varying, integer, integer, character varying, integer, character varying, integer, boolean, date, date, numeric, integer, integer, text, integer, character varying); Type: FUNCTION; Schema: boletaje; Owner: radiosan_ustaana
--

CREATE FUNCTION paproceso_actualizar(innew boolean, inprocesoid integer, intipo character varying, inempresaid integer, inalmacenid integer, innombre character varying, intipodocumentoid integer, inserie character varying, innumero integer, inlimitarfechas boolean, indesde date, inhasta date, inimporte_maximo numeric, incantidad_items integer, incantidad_maxima_item integer, inobservacion text, inusuarioid integer, inip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from boletaje.proceso pro where trim(upper(buscar(pro.nombre)))=trim(upper(buscar(innombre))) and pro.empresaid=inempresaid and pro.almacenid=inalmacenid and pro.procesoid!=inprocesoid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre del proceso ya existe.';
	end if;
	if vState then
		If inNew Then
			insert into boletaje.proceso values(default, current_timestamp, trim(intipo), inempresaid, inalmacenid, trim(innombre), intipodocumentoid, trim(inserie), innumero, inlimitarfechas, indesde, inhasta, inimporte_maximo, incantidad_items, incantidad_maxima_item, trim(inobservacion), inusuarioid, trim(inip), 0);
			vID:=lastval();
		Else
			update boletaje.proceso set tipo=trim(intipo), nombre=trim(innombre), tipodocumentoid=intipodocumentoid, serie=trim(inserie), numero=innumero, limitarfechas=inlimitarfechas, desde=indesde, hasta=inhasta, importe_maximo=inimporte_maximo, cantidad_items=incantidad_items, cantidad_maxima_item=incantidad_maxima_item, observacion=trim(inobservacion) where procesoid=inprocesoid;
			vID:=inprocesoid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION boletaje.paproceso_actualizar(innew boolean, inprocesoid integer, intipo character varying, inempresaid integer, inalmacenid integer, innombre character varying, intipodocumentoid integer, inserie character varying, innumero integer, inlimitarfechas boolean, indesde date, inhasta date, inimporte_maximo numeric, incantidad_items integer, incantidad_maxima_item integer, inobservacion text, inusuarioid integer, inip character varying) OWNER TO radiosan_ustaana;

--
-- Name: paproceso_count(integer, integer, character varying, character varying); Type: FUNCTION; Schema: boletaje; Owner: radiosan_ustaana
--

CREATE FUNCTION paproceso_count(vempresaid integer, valmacenid integer, vtipo character varying, vnombre character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vCount integer default 0;
BEGIN
	select count(*) into vCount
	from boletaje.proceso pro inner join basic.empresa emp on pro.empresaid=emp.empresaid
		inner join basic.almacen alm on pro.almacenid=alm.almacenid
		inner join contabilidad.tipodocumento td on pro.tipodocumentoid=td.tipodocumentoid
		inner join basic.persona usu on pro.usuarioid=usu.personaid
			left join basic.persona_natural pnusu on usu.personaid=pnusu.personaid
			left join basic.persona_juridica pjusu on usu.personaid=pjusu.personaid
		left join basic.clave cla on usu.personaid=cla.personaid
	where pro.empresaid=vempresaid
		and case when valmacenid>0 then pro.almacenid=valmacenid else true end
		and case when trim(vtipo)!='' then pro.tipo=trim(vtipo) else true end
		and case when trim(vnombre)!='' then trim(upper(buscar(pro.nombre))) like '%'||trim(upper(buscar(vnombre)))||'%' else true end;

	return coalesce(vCount, 0);
END
$$;


ALTER FUNCTION boletaje.paproceso_count(vempresaid integer, valmacenid integer, vtipo character varying, vnombre character varying) OWNER TO radiosan_ustaana;

--
-- Name: paproceso_eliminar(integer, integer, character varying); Type: FUNCTION; Schema: boletaje; Owner: radiosan_ustaana
--

CREATE FUNCTION paproceso_eliminar(vprocesoid integer, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if vState=true then
		delete from boletaje.proceso_porprocesar where procesoid=vprocesoid;
		delete from boletaje.proceso where procesoid=vprocesoid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION boletaje.paproceso_eliminar(vprocesoid integer, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: paproceso_getrow(integer); Type: FUNCTION; Schema: boletaje; Owner: radiosan_ustaana
--

CREATE FUNCTION paproceso_getrow(vprocesoid integer) RETURNS SETOF type_proceso_getrow
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp cascade;
	create temporary table tmp(type integer not null, procesoid integer not null, count integer not null);
	insert into tmp select 1, pp.procesoid, count(*) from boletaje.proceso_porprocesar pp group by 2;
	
	return query 
		select pro.procesoid, to_char(pro.registro, 'DD/MM/YYYY HH12:MI AM')::varchar, pro.tipo, pro.empresaid, emp.nombre, pro.almacenid, alm.nombre, alm.abreviatura, pro.nombre, pro.tipodocumentoid, td.nombre, td.abreviatura,
			pro.serie, pro.numero, pro.limitarfechas, pro.desde, pro.hasta, pro.importe_maximo, pro.cantidad_items::integer, pro.cantidad_maxima_item, pro.observacion,
			pro.usuarioid, (case when usu.tipo='J' then pjusu.raz_soc else (pnusu.ape_pat||' '||pnusu.ape_mat||', '||pnusu.nombre) end)::varchar, usu.foto, coalesce(pnusu.sexo, 'M')::varchar, coalesce(cla.usuario,'')::varchar,
			pro.ip, pro.estado, (case when pro.estado=0 then 'Esperando procesamiento' when pro.estado=1 then 'Procesado' else '' end)::varchar,
			coalesce(tmp.count,0)::integer
		from boletaje.proceso pro inner join basic.empresa emp on pro.empresaid=emp.empresaid
			inner join basic.almacen alm on pro.almacenid=alm.almacenid
			inner join contabilidad.tipodocumento td on pro.tipodocumentoid=td.tipodocumentoid
			inner join basic.persona usu on pro.usuarioid=usu.personaid
				left join basic.persona_natural pnusu on usu.personaid=pnusu.personaid
				left join basic.persona_juridica pjusu on usu.personaid=pjusu.personaid
			left join basic.clave cla on usu.personaid=cla.personaid
			left join tmp on pro.procesoid=tmp.procesoid and 1=tmp.type
		where pro.procesoid=vprocesoid;
		
	drop table if exists tmp cascade;
END
$$;


ALTER FUNCTION boletaje.paproceso_getrow(vprocesoid integer) OWNER TO radiosan_ustaana;

--
-- Name: paproceso_leer(integer, integer, integer, integer, character varying, character varying); Type: FUNCTION; Schema: boletaje; Owner: radiosan_ustaana
--

CREATE FUNCTION paproceso_leer(vinicio integer, vfin integer, vempresaid integer, valmacenid integer, vtipo character varying, vnombre character varying) RETURNS SETOF type_proceso_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp cascade;
	create temporary table tmp(type integer not null, procesoid integer not null, count integer not null);
	insert into tmp select 1, pp.procesoid, count(*) from boletaje.proceso_porprocesar pp group by 2;
	return query 
		select pro.procesoid, to_char(pro.registro, 'DD/MM/YYYY HH12:MI AM')::varchar, pro.empresaid, emp.nombre, pro.almacenid, alm.nombre, alm.abreviatura, pro.nombre, pro.tipodocumentoid, td.nombre, td.abreviatura,
			pro.serie, pro.numero,
			pro.usuarioid, (case when usu.tipo='J' then pjusu.raz_soc else (pnusu.ape_pat||' '||pnusu.ape_mat||', '||pnusu.nombre) end)::varchar, usu.foto, coalesce(pnusu.sexo, 'M')::varchar, coalesce(cla.usuario,'')::varchar,
			pro.estado, (case when pro.estado=0 then 'Esperando procesamiento' when pro.estado=1 then 'Procesado' else '' end)::varchar,
			coalesce(tmp.count,0)::integer
		from boletaje.proceso pro inner join basic.empresa emp on pro.empresaid=emp.empresaid
			inner join basic.almacen alm on pro.almacenid=alm.almacenid
			inner join contabilidad.tipodocumento td on pro.tipodocumentoid=td.tipodocumentoid
			inner join basic.persona usu on pro.usuarioid=usu.personaid
				left join basic.persona_natural pnusu on usu.personaid=pnusu.personaid
				left join basic.persona_juridica pjusu on usu.personaid=pjusu.personaid
			left join basic.clave cla on usu.personaid=cla.personaid
			left join tmp on pro.procesoid=tmp.procesoid and 1=tmp.type
		where 1=1
			and case when vempresaid>0 then pro.empresaid=vempresaid else true end
			and case when valmacenid>0 then pro.almacenid=valmacenid else true end
			and case when trim(vtipo)!='' then pro.tipo=trim(vtipo) else true end
			and case when trim(vnombre)!='' then trim(upper(buscar(pro.nombre))) like '%'||trim(upper(buscar(vnombre)))||'%' else true end
		order by pro.registro desc
		limit case when vinicio=0 and vfin=0 then null else vfin end offset vinicio;
END
$$;


ALTER FUNCTION boletaje.paproceso_leer(vinicio integer, vfin integer, vempresaid integer, valmacenid integer, vtipo character varying, vnombre character varying) OWNER TO radiosan_ustaana;

--
-- Name: paproceso_porprocesar_eliminar(integer[], integer, character varying); Type: FUNCTION; Schema: boletaje; Owner: radiosan_ustaana
--

CREATE FUNCTION paproceso_porprocesar_eliminar(myarr integer[], vusuario integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if vState then 
		delete from boletaje.proceso_porprocesar where porprocesarid in (select myarr[i] from generate_series(1, array_upper(myarr, 1)) as i);
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION boletaje.paproceso_porprocesar_eliminar(myarr integer[], vusuario integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: paproceso_porprocesar_leer(integer, character varying, character varying); Type: FUNCTION; Schema: boletaje; Owner: radiosan_ustaana
--

CREATE FUNCTION paproceso_porprocesar_leer(vprocesoid integer, vtexto character varying, vsoloexistentes character varying) RETURNS SETOF type_proceso_porprocesar_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp cascade;
	create temporary table tmp(porprocesarid integer not null, personaid integer not null);
	insert into tmp 
		select pp.porprocesarid, (case when length(trim(pp.dniruc))=8 then basic.papersona_getidbydni(pp.dniruc) when length(trim(pp.dniruc))=11 then basic.papersona_getidbyruc(pp.dniruc) else 0 end)::integer
		from boletaje.proceso_porprocesar pp
		where pp.procesoid=vprocesoid;
	return query 
		select pp.porprocesarid, pp.procesoid, pp.numero, pp.fecha, pp.dniruc, pp.ape_pat, pp.ape_mat, pp.nombre, pp.cantidad, pp.producto, pp.unidad, pp.precio,
			coalesce(tmp.personaid, 0)::integer, (case when coalesce(tmp.personaid, 0)>0 then (case when cli.tipo='J' then clipj.raz_soc else (clipn.ape_pat||' '||clipn.ape_mat||', '||clipn.nombre) end) else '' end)::varchar
		from boletaje.proceso_porprocesar pp left join tmp on pp.porprocesarid=tmp.porprocesarid
			left join basic.persona cli on tmp.personaid=cli.personaid 
				left join basic.persona_natural clipn on cli.personaid=clipn.personaid
				left join basic.persona_juridica clipj on cli.personaid=clipj.personaid
		where pp.procesoid=vprocesoid
			and case when trim(vtexto)!='' then (trim(upper(buscar(pp.dniruc))) like '%'||trim(upper(buscar(vtexto)))||'%' or trim(upper(buscar(pp.ape_pat||' '||pp.ape_mat||' '||pp.nombre))) like '%'||trim(upper(buscar(vtexto)))||'%' or trim(upper(buscar(pp.producto))) like '%'||trim(upper(buscar(vtexto)))||'%' ) else true end
			and case when trim(vsoloexistentes)='Y' then (coalesce(tmp.personaid,0)>0) else true end
		order by pp.numero;
END
$$;


ALTER FUNCTION boletaje.paproceso_porprocesar_leer(vprocesoid integer, vtexto character varying, vsoloexistentes character varying) OWNER TO radiosan_ustaana;

--
-- Name: paproceso_porprocesar_procesar(integer, integer, character varying); Type: FUNCTION; Schema: boletaje; Owner: radiosan_ustaana
--

CREATE FUNCTION paproceso_porprocesar_procesar(vprocesoid integer, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	myrow record; myrowpro record; vventaid integer default 0; vnumero varchar default ''; 
	vvalorigv numeric default 0; vtotalgravado numeric default 0; vtotalexonerado numeric default 0; vtotal numeric default 0; vigv numeric default 0;
	--vNumero integer default 0; vFecha date default current_date; vDNI varchar default ''; vApePat varchar default ''; vApeMat varchar default ''; vNombre varchar default '';
	--vCantidad numeric default 0; vUnidad varchar default ''; vProducto varchar default ''; vPrecio numeric default 0; myRow record;
BEGIN
	drop table if exists tmp_pro cascade;
	create temporary table tmp_pro(productoid integer not null, cantidad numeric not null, precio numeric not null);
	if exists(select * from boletaje.proceso where procesoid=vprocesoid) then
		if exists(select * from boletaje.proceso_porprocesar where procesoid=vprocesoid) then
			select * into myrowpro from boletaje.proceso where procesoid=vprocesoid;
			
			for myrow in select tmp.numero, count(*) as cantidad from boletaje.proceso_porprocesar tmp where tmp.procesoid=vprocesoid group by 1 order by 1 loop
				raise notice 'NUMERO: %, CANTIDAD:%', myrow.numero, myrow.cantidad;

				delete from tmp_pro;
				insert into tmp_pro select catalogo.paproducto_getidbynombre(tmp.producto), tmp.cantidad, tmp.precio from boletaje.proceso_porprocesar tmp where tmp.procesoid=vprocesoid and tmp.numero=myrow.numero;

				vvalorigv:=basic.paempresa_config_getigv(myrowpro.empresaid);

				select sum(tmp.cantidad*tmp.precio) into vtotal from tmp_pro tmp;
				vtotal:=coalesce(vtotal, 0);
				select sum(tmp.cantidad*tmp.precio) into vtotalgravado from tmp_pro tmp inner join catalogo.producto pro on tmp.productoid=pro.productoid where pro.grabado=true;
				vtotalgravado:=coalesce(vtotalgravado, 0);
				select sum(tmp.cantidad*tmp.precio) into vtotalexonerado from tmp_pro tmp inner join catalogo.producto pro on tmp.productoid=pro.productoid where pro.grabado=false;
				vtotalexonerado:=coalesce(vtotalexonerado, 0);
				vigv:=round(vtotalgravado*vvalorigv/(100::numeric+vvalorigv),2);
				
				raise notice 'TOTAL GRAVADO: %, TOTAL EXONERADO:%, VALOR IGV:%, IGV:%, TOTAL:%', vtotalgravado, vtotalexonerado, vvalorigv, vigv, vtotal;
				--basic.paempresa_config_getigv(myrowpro.empresaid)

				vnumero:=myrowpro.serie||'-'||trim(to_char(myrow.numero, '00000000'));
				vventaid:=nextval('inventarios.venta_ventaid_seq');
				insert into inventarios.venta values(vventaid, current_timestamp, 0, myrowpro.almacenid, myrowpro.tipodocumentoid, vnumero, CURRENT_DATE, basic.paempresa_config_getventaclienteid(myrowpro.empresaid), '', 'CONTADO', vtotal, 0, vigv, vtotal, vtotalgravado-vigv, vtotalexonerado, vvalorigv, 'NS', 0, 0, 0, true, true, '+', '', 0, 0, 0, 0, '',  vusuarioid, vusuarioid, vip, true, 0, 0, 0, 0, 0, 0, 0, 0, myrowpro.empresaid, 0, 0, vtotal, 5872);
				insert into inventarios.venta_detalle 
					select vventaid, tmp.productoid, tmp.cantidad, false, tmp.precio, 
						(case when pro.grabado then round(tmp.precio / (1::numeric + (vvalorigv / 100::numeric)),2) else tmp.precio end),
						0, 0, 0, pro.grabado, (case when pro.grabado then round(((tmp.cantidad*tmp.precio) * vvalorigv / (100::numeric+vvalorigv)),2) else 0 end), 0, 0, 0, 1, 0, tmp.cantidad, (tmp.cantidad*tmp.precio), false, 0, '', 0, 0, 0, 0
					from tmp_pro tmp inner join catalogo.producto pro on tmp.productoid=pro.productoid;

				insert into inventarios.venta_forma_pago values(vventaid, 1, 0, 0, '', 'NS', vtotal, 0); --, 0, 0
				
				--select * from boletaje.proceso;
				--select * from inventarios.venta order by 1 desc limit 5;
				--select * from inventarios.venta_detalle order by 1 desc limit 5;
				--select * from inventarios.venta_forma_pago;
			end loop;
		else
			vState:=false; vID:=0; vError:=1; vDescripcion:='No hay nada para procesar.';
		end if;
	else
		vState:=false; vID:=0; vError:=1; vDescripcion:='No existe el proceso.';
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION boletaje.paproceso_porprocesar_procesar(vprocesoid integer, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: paproceso_porprocesar_registrar(integer, character varying[], integer, character varying); Type: FUNCTION; Schema: boletaje; Owner: radiosan_ustaana
--

CREATE FUNCTION paproceso_porprocesar_registrar(vprocesoid integer, myarr character varying[], vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vIndice integer default 0; vFilas integer default 0;
	vNumero integer default 0; vFecha date default current_date; vDNI varchar default ''; vApePat varchar default ''; vApeMat varchar default ''; vNombre varchar default '';
	vCantidad numeric default 0; vUnidad varchar default ''; vProducto varchar default ''; vPrecio numeric default 0; myRow record;
BEGIN
	--VALIDAR QUE LA SERIE SEA DEL MISMO ALMACEN
	if (not (myarr[1][1] is null)) then

		drop table if exists tmp cascade;
		create temporary table tmp(numero integer not null, fecha date not null, dniruc varchar(50) not null, ape_pat varchar(250) not null, ape_mat varchar(250) not null, nombre varchar(250) not null, cantidad numeric not null, unidad varchar(200) not null, producto varchar(200) not null, precio numeric not null);
		
		vFilas=array_upper(myArr,1);
		vIndice:=0;
		if vFilas>0 then
			raise notice 'FILAS %', vFilas;
			for vIndice in 1..vFilas loop
				vNumero:=myArr[vIndice][1]::integer;
				vFecha:=myArr[vIndice][2]::date;
				vDNI:=trim(myArr[vIndice][3]);
				vApePat:=trim(myArr[vIndice][4]);
				vApeMat:=trim(myArr[vIndice][5]);
				vNombre:=trim(myArr[vIndice][6]);
				vCantidad:=myArr[vIndice][7]::numeric;
				vUnidad:=trim(myArr[vIndice][8]);
				vProducto:=trim(myArr[vIndice][9]);
				vPrecio:=myArr[vIndice][10]::numeric;
				insert into tmp values(vNumero, vFecha, vDNI, vApePat, vApeMat, vNombre, vCantidad, vUnidad, vProducto, vPrecio);
			end loop;
		end if;

		if exists(select * from tmp) then
			insert into boletaje.proceso_porprocesar select nextval('boletaje.proceso_porprocesar_porprocesarid_seq'), vprocesoid, tmp.numero, tmp.fecha, tmp.dniruc, tmp.ape_pat, tmp.ape_mat, tmp.nombre, tmp.cantidad, tmp.unidad, tmp.producto, tmp.precio from tmp;
		end if;
		
		drop table if exists tmp cascade;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION boletaje.paproceso_porprocesar_registrar(vprocesoid integer, myarr character varying[], vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

SET search_path = catalogo, pg_catalog;

--
-- Name: funproducto_antes(); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION funproducto_antes() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE 
BEGIN
	IF (TG_OP='DELETE') THEN
		begin
		delete from inventarios.stock where productoid=old.productoid;
		delete from catalogo.producto_almacen where productoid=old.productoid;
		end;
	END IF;
	RETURN OLD;
END;
$$;


ALTER FUNCTION catalogo.funproducto_antes() OWNER TO radiosan_ustaana;

--
-- Name: funproducto_despues(); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION funproducto_despues() RETURNS trigger
    LANGUAGE plpgsql
    AS $$
DECLARE 
BEGIN
	IF (TG_OP='INSERT') THEN
		begin
		insert into inventarios.stock
			select emp.empresaid, new.productoid, alm.almacenid, 0
			from basic.almacen alm inner join basic.empresa emp on 1=1;
		insert into catalogo.producto_almacen
			select alm.almacenid, new.productoid, new.stock_min, new.stock_max, new.precio_va, new.precio_vb, new.precio_vc, new.precio_vd
			from basic.almacen alm;
		end;
	END IF;
	RETURN NEW;
END;
$$;


ALTER FUNCTION catalogo.funproducto_despues() OWNER TO radiosan_ustaana;

--
-- Name: paactualizar_proveedores(integer, integer); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paactualizar_proveedores(vano integer, vproductoid integer) RETURNS void
    LANGUAGE plpgsql
    AS $$
BEGIN
	delete from inventarios.proveedores_producto where 1=1 
		and case when vano>0 then ano=vano else true end
		and case when vproductoid>0 then productoid=vproductoid else true end;
		
	insert into inventarios.proveedores_producto
		select det.productoid, doc.personaid , max(extract(YEAR from doc.fecha))::integer
		from inventarios.ingreso_mercaderia_detalle det inner join inventarios.ingreso_mercaderia doc on det.ingresoid=doc.ingresoid
		where doc.estado=true and det.precio>0 and doc.descontar_stock=true 
			and case when vano>0 then extract(YEAR from doc.fecha)=vano else true end
			and case when vproductoid>0 then det.productoid=vproductoid else true end
		group by det.productoid, doc.personaid;
		
END
$$;


ALTER FUNCTION catalogo.paactualizar_proveedores(vano integer, vproductoid integer) OWNER TO radiosan_ustaana;

--
-- Name: pacambiar_precios_add(integer, integer, integer, numeric, text, integer, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION pacambiar_precios_add(vempresaid integer, valmacenid integer, vproductoid integer, vprecio numeric, vobservacion text, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if vState then
		insert into catalogo.cambiar_precios values(default, current_timestamp, vempresaid, valmacenid, vproductoid, vprecio, trim(vobservacion), 1, vusuarioid, trim(vip), 0, '', 0);
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION catalogo.pacambiar_precios_add(vempresaid integer, valmacenid integer, vproductoid integer, vprecio numeric, vobservacion text, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: pacambiar_precios_cancelar(integer, integer, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION pacambiar_precios_cancelar(vcodigo integer, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if vState then
		update catalogo.cambiar_precios set estado=0, usuariorespuestaid=vusuarioid, iprespuesta=trim(vip) where id=vcodigo;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION catalogo.pacambiar_precios_cancelar(vcodigo integer, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: pacambiar_precios_leer(integer, integer, integer, integer); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION pacambiar_precios_leer(vempresaid integer, valmacenid integer, vproductoid integer, vestado integer) RETURNS SETOF type_cambiar_precios_leer
    LANGUAGE plpgsql
    AS $$
DECLARE	
BEGIN 
	return query
		select cp.id, to_char(cp.registro, 'DD/MM/YYYY HH12:MI AM')::varchar, 
			cp.empresaid, emp.nombre, emp.abreviatura,
			cp.almacenid, alm.nombre, alm.abreviatura,
			cp.productoid, (p.nombre || case when p.presentacion!='' then (', ' || p.presentacion) else '' end)::varchar,
			coalesce(pa.precio_va)::numeric, cp.precio, cp.observacion, 
			cp.estado, (case when cp.estado=1 then 'EN ESPERA' when cp.estado=0 then 'CANCELADO' when cp.estado=2 then 'ACEPTADO' else '' end)::varchar,
			cp.usuariosolicitaid, upper((case when ususol.tipo='J' then ususolpj.raz_soc else (ususolpn.ape_pat || ' ' || ususolpn.ape_mat || ', ' || ususolpn.nombre) end))::varchar, ususol.foto, coalesce(ususolpn.sexo, 'M')::varchar,
			cp.usuariorespuestaid, upper(case when cp.usuariorespuestaid>0 then (case when usurpta.tipo='J' then usurptapj.raz_soc else (usurptapn.ape_pat || ' ' || usurptapn.ape_mat || ', ' || usurptapn.nombre) end) else '' end)::varchar, usurpta.foto, coalesce(usurptapn.sexo, 'M')::varchar
		from catalogo.cambiar_precios cp inner join basic.almacen alm on cp.almacenid=alm.almacenid
			inner join basic.empresa emp on cp.empresaid=emp.empresaid
			inner join catalogo.producto p on cp.productoid=p.productoid
			inner join basic.persona as ususol on cp.usuariosolicitaid=ususol.personaid
				left join basic.persona_natural ususolpn on ususol.personaid=ususolpn.personaid
				left join basic.persona_juridica ususolpj on ususol.personaid=ususolpj.personaid
			left join basic.persona usurpta on cp.usuariorespuestaid=usurpta.personaid
				left join basic.persona_natural usurptapn on usurpta.personaid=usurptapn.personaid
				left join basic.persona_juridica usurptapj on usurpta.personaid=usurptapj.personaid
			left join catalogo.producto_almacen pa on cp.almacenid=pa.almacenid and cp.productoid=pa.productoid
		where 1=1
			and case when vempresaid>0 then cp.empresaid=vempresaid else true end
			and case when valmacenid>0 then cp.almacenid=valmacenid else true end
			and case when vproductoid>0 then cp.productoid=vproductoid else true end
			and case when vestado>=0 then cp.estado=vestado else true end
		order by cp.registro desc, cp.id desc;
END
$$;


ALTER FUNCTION catalogo.pacambiar_precios_leer(vempresaid integer, valmacenid integer, vproductoid integer, vestado integer) OWNER TO radiosan_ustaana;

--
-- Name: pacategoria_actualizar(boolean, integer, character varying, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION pacategoria_actualizar(innew boolean, incategoriaid integer, innombre character varying, inabreviatura character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from catalogo.categoria c where trim(upper(c.nombre))=trim(upper(innombre)) and c.categoriaid!=incategoriaid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre de la categoria ya existe.';
	end if;
	If vState Then
		if inNew then
			insert into catalogo.categoria values(default, trim(innombre), trim(inabreviatura));
			vID:=lastval();
		Else
			update catalogo.categoria set nombre=trim(innombre), abreviatura=trim(inabreviatura) where categoriaid=incategoriaid;
			vID:=incategoriaid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION catalogo.pacategoria_actualizar(innew boolean, incategoriaid integer, innombre character varying, inabreviatura character varying) OWNER TO radiosan_ustaana;

--
-- Name: pacategoria_eliminar(integer, integer, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION pacategoria_eliminar(vcategoriaid integer, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare 
	vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from catalogo.subcategoria where categoriaid=vcategoriaid limit 1) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar la categoria por tener subcategorias registradas.';
	end if;
	if vState then
		delete from catalogo.categoria where categoriaid=vcategoriaid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION catalogo.pacategoria_eliminar(vcategoriaid integer, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: pacategoria_leer(character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION pacategoria_leer(innombre character varying) RETURNS SETOF type_categoria_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp cascade;
	create temporary table tmp(categoriaid integer not null, count integer not null);
	insert into tmp select sc.categoriaid, count(*) from catalogo.subcategoria sc group by 1;
	return query 
		select c.categoriaid, c.nombre, c.abreviatura, coalesce(tmp.count, 0)::integer
		from catalogo.categoria c left join tmp on c.categoriaid=tmp.categoriaid
		where c.categoriaid>0
			and case when trim(innombre)!='' then upper(buscar(c.nombre)) like '%'|| upper(buscar(innombre)) ||'%' else true end
		order by nombre;
	drop table if exists tmp cascade;
END
$$;


ALTER FUNCTION catalogo.pacategoria_leer(innombre character varying) OWNER TO radiosan_ustaana;

--
-- Name: pacolor_actualizar(boolean, integer, character varying, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION pacolor_actualizar(innew boolean, incolorid integer, innombre character varying, inabreviatura character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from catalogo.color c where trim(upper(buscar(c.nombre)))=trim(upper(buscar(innombre))) and c.colorid!=incolorid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre de la color ya existe.';
	end if;
	If vState Then
		if inNew then
			insert into catalogo.color values(default, trim(innombre), trim(inabreviatura));
			vID:=lastval();
		Else
			update catalogo.color set nombre=trim(innombre), abreviatura=trim(inabreviatura) where colorid=incolorid;
			vID:=incolorid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION catalogo.pacolor_actualizar(innew boolean, incolorid integer, innombre character varying, inabreviatura character varying) OWNER TO radiosan_ustaana;

--
-- Name: pacolor_count(character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION pacolor_count(vnombre character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vCount integer default 0;
BEGIN
	select count(*) into vCount
	from catalogo.color c
	where c.colorid>0
		and case when trim(vnombre)!='' then upper(buscar(trim(c.nombre))) like '%'|| upper(buscar(trim(vnombre))) ||'%' else true end;

	return coalesce(vCount, 0);
		
END
$$;


ALTER FUNCTION catalogo.pacolor_count(vnombre character varying) OWNER TO radiosan_ustaana;

--
-- Name: pacolor_eliminar(integer, integer, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION pacolor_eliminar(vcolorid integer, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from catalogo.producto where colorid=vcolorid limit 1) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar la color por tener productos registrados.';
	end if;
	if vState then
		delete from catalogo.color where colorid=vcolorid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION catalogo.pacolor_eliminar(vcolorid integer, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: pacolor_leer(integer, integer, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION pacolor_leer(vinicio integer, vfin integer, vnombre character varying) RETURNS SETOF type_color_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp cascade;
	create temporary table tmp(colorid integer not null, count integer not null);
	insert into tmp select p.colorid, count(*) from catalogo.producto p group by 1;
	
	return query 
		select c.colorid, c.nombre, c.abreviatura, coalesce(tmp.count, 0)::integer
		from catalogo.color c left join tmp on c.colorid=tmp.colorid
		where 1=1--c.colorid>0
			and case when trim(vnombre)!='' then upper(buscar(trim(c.nombre))) like '%'|| upper(buscar(trim(vnombre))) ||'%' else true end
		order by (case when c.colorid=0 then 0 else 1 end), c.nombre
		limit case when vinicio=0 and vfin=0 then null else vfin end offset vinicio;
		
	drop table if exists tmp cascade;
END
$$;


ALTER FUNCTION catalogo.pacolor_leer(vinicio integer, vfin integer, vnombre character varying) OWNER TO radiosan_ustaana;

--
-- Name: pagrupo_actualizar(boolean, integer, character varying, character varying, boolean); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION pagrupo_actualizar(innew boolean, ingrupoid integer, innombre character varying, inabreviatura character varying, inestado boolean) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from catalogo.grupo g where trim(upper(buscar(g.nombre)))=trim(upper(buscar(innombre))) and g.grupoid!=ingrupoid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre del grupo ya existe.';
	end if;
	If vState Then
		if inNew then
			insert into catalogo.grupo values(default, trim(innombre), trim(inabreviatura), catalogo.pagrupo_ultimo_orden()+1, inestado);
			vID:=lastval();
		Else
			update catalogo.grupo set nombre=trim(innombre), abreviatura=trim(inabreviatura), estado=inestado where grupoid=ingrupoid;
			vID:=ingrupoid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION catalogo.pagrupo_actualizar(innew boolean, ingrupoid integer, innombre character varying, inabreviatura character varying, inestado boolean) OWNER TO radiosan_ustaana;

--
-- Name: pagrupo_cambiar_estado(integer, integer, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION pagrupo_cambiar_estado(vgrupoid integer, vusuario integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vEstadoOld boolean default false;
BEGIN
	if vState then
		if exists(select * from catalogo.grupo where grupoid=vgrupoid) then
			--RASTRO
			select estado into vEstadoOld from catalogo.grupo where grupoid=vgrupoid;
			insert into rastro.campo values(default, 'catalogo', 'grupo', 'estado', 'B', vgrupoid, 0, 0, vEstadoOld::varchar, (not vEstadoOld)::varchar, current_timestamp, vusuario, vip, 1, 0);
			
			update catalogo.grupo set estado=not estado where grupoid=vgrupoid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION catalogo.pagrupo_cambiar_estado(vgrupoid integer, vusuario integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: pagrupo_cambiar_orden(integer[]); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION pagrupo_cambiar_orden(myarr integer[]) RETURNS void
    LANGUAGE plpgsql
    AS $$
declare myRow record;
BEGIN
	for myRow in select myarr[i] as id, i as orden from generate_series(1, array_upper(myarr, 1)) as i loop
		update catalogo.grupo set orden=myRow.orden where grupoid=myRow.id;
	end loop;
END
$$;


ALTER FUNCTION catalogo.pagrupo_cambiar_orden(myarr integer[]) OWNER TO radiosan_ustaana;

--
-- Name: pagrupo_eliminar(integer, integer, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION pagrupo_eliminar(vgrupoid integer, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare 
	vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from catalogo.producto_grupo where grupoid=vgrupoid limit 1) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar la grupo por tener productos registrados.';
	end if;
	if vState then
		delete from catalogo.grupo where grupoid=vgrupoid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION catalogo.pagrupo_eliminar(vgrupoid integer, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: pagrupo_getrow(integer); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION pagrupo_getrow(vgrupoid integer) RETURNS SETOF type_grupo_getrow
    LANGUAGE plpgsql
    AS $$
declare vCantProductos integer default 0;
BEGIN
	select count(*) into vCantProductos from catalogo.producto_grupo pg where pg.grupoid=vgrupoid;
	return query 
		select g.grupoid, g.nombre, g.abreviatura, g.orden, g.estado, coalesce(vCantProductos, 0)::integer
		from catalogo.grupo g
		where g.grupoid=vgrupoid;
END
$$;


ALTER FUNCTION catalogo.pagrupo_getrow(vgrupoid integer) OWNER TO radiosan_ustaana;

--
-- Name: pagrupo_leer(character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION pagrupo_leer(innombre character varying) RETURNS SETOF type_grupo_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp cascade;
	create temporary table tmp(grupoid integer not null, cantidad integer not null);
	insert into tmp select pg.grupoid, count(*) from catalogo.producto_grupo pg group by 1;
	return query 
		select g.grupoid, g.nombre, g.abreviatura, g.orden, g.estado, coalesce(tmp.cantidad, 0)::integer
		from catalogo.grupo g left join tmp on g.grupoid=tmp.grupoid
		where g.grupoid>0
			and case when trim(innombre)!='' then trim(upper(buscar(g.nombre))) like '%'|| trim(upper(buscar(innombre))) ||'%' else true end
		order by g.orden;
END
$$;


ALTER FUNCTION catalogo.pagrupo_leer(innombre character varying) OWNER TO radiosan_ustaana;

--
-- Name: pagrupo_ultimo_orden(); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION pagrupo_ultimo_orden() RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vOrden integer default 0;
BEGIN
	select max(g.orden) into vOrden from catalogo.grupo g;
	return coalesce(vOrden, 0);
END
$$;


ALTER FUNCTION catalogo.pagrupo_ultimo_orden() OWNER TO radiosan_ustaana;

--
-- Name: palaboratorio_actualizar(boolean, integer, character varying, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION palaboratorio_actualizar(innew boolean, inlaboratorioid integer, innombre character varying, inabreviatura character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from catalogo.laboratorio l where trim(upper(buscar(l.nombre)))=trim(upper(buscar(innombre))) and l.laboratorioid!=inlaboratorioid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre de la laboratorio ya existe.';
	end if;
	If vState Then
		if inNew then
			insert into catalogo.laboratorio values(default, trim(innombre), trim(inabreviatura));
			vID:=lastval();
		Else
			update catalogo.laboratorio set nombre=trim(innombre), abreviatura=trim(inabreviatura) where laboratorioid=inlaboratorioid;
			vID:=inlaboratorioid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION catalogo.palaboratorio_actualizar(innew boolean, inlaboratorioid integer, innombre character varying, inabreviatura character varying) OWNER TO radiosan_ustaana;

--
-- Name: palaboratorio_count(character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION palaboratorio_count(vnombre character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vCount integer default 0;
BEGIN
	select count(*) into vCount
	from catalogo.laboratorio l
	where l.laboratorioid>0
		and case when trim(vnombre)!='' then upper(buscar(trim(l.nombre))) like '%'|| upper(buscar(trim(vnombre))) ||'%' else true end;
		
	return coalesce(vCount, 0);
		
END
$$;


ALTER FUNCTION catalogo.palaboratorio_count(vnombre character varying) OWNER TO radiosan_ustaana;

--
-- Name: palaboratorio_eliminar(integer, integer, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION palaboratorio_eliminar(vlaboratorioid integer, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from catalogo.producto where laboratorioid=vlaboratorioid limit 1) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar la laboratorio por tener productos registrados.';
	end if;
	if vState then
		delete from catalogo.laboratorio where laboratorioid=vlaboratorioid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION catalogo.palaboratorio_eliminar(vlaboratorioid integer, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: palaboratorio_leer(integer, integer, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION palaboratorio_leer(vinicio integer, vfin integer, vnombre character varying) RETURNS SETOF type_laboratorio_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp cascade;
	create temporary table tmp(laboratorioid integer not null, count integer not null);
	insert into tmp select p.laboratorioid, count(*) from catalogo.producto p group by 1;
	
	return query 
		select l.laboratorioid, l.nombre, l.abreviatura, coalesce(tmp.count, 0)::integer
		from catalogo.laboratorio l left join tmp on l.laboratorioid=tmp.laboratorioid
		where l.laboratorioid>0
			and case when trim(vnombre)!='' then upper(buscar(trim(l.nombre))) like '%'|| upper(buscar(trim(vnombre))) ||'%' else true end
		order by l.nombre
		limit case when vinicio=0 and vfin=0 then null else vfin end offset vinicio;
		
	drop table if exists tmp cascade;
END
$$;


ALTER FUNCTION catalogo.palaboratorio_leer(vinicio integer, vfin integer, vnombre character varying) OWNER TO radiosan_ustaana;

--
-- Name: palinea_actualizar(boolean, integer, character varying, character varying, character varying, boolean); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION palinea_actualizar(innew boolean, inlineaid integer, innombre character varying, inabreviatura character varying, incodigo_contable character varying, inestado boolean) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from catalogo.linea c where trim(upper(c.nombre))=trim(upper(innombre)) and c.lineaid!=inlineaid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre de la linea ya existe.';
	end if;
	If vState Then
		if inNew then
			insert into catalogo.linea values(default, trim(innombre), trim(inabreviatura), trim(incodigo_contable), catalogo.palinea_lastorder(), inestado);
			vID:=lastval();
		Else
			update catalogo.linea set nombre=trim(innombre), abreviatura=trim(inabreviatura), codigo_contable=trim(incodigo_contable), estado=inestado where lineaid=inlineaid;
			vID:=inlineaid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION catalogo.palinea_actualizar(innew boolean, inlineaid integer, innombre character varying, inabreviatura character varying, incodigo_contable character varying, inestado boolean) OWNER TO radiosan_ustaana;

--
-- Name: palinea_count(character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION palinea_count(vnombre character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vCount integer default 0;
BEGIN
	select count(*) into vCount
	from catalogo.linea l
	where l.lineaid>0
		and case when trim(vnombre)!='' then upper(buscar(l.nombre)) like '%'|| upper(buscar(vnombre)) ||'%' else true end;

	return coalesce(vCount, 0);
END
$$;


ALTER FUNCTION catalogo.palinea_count(vnombre character varying) OWNER TO radiosan_ustaana;

--
-- Name: palinea_eliminar(integer, integer, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION palinea_eliminar(vlineaid integer, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare 
	vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from catalogo.producto where lineaid=vlineaid limit 1) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar la linea por tener sublineas registradas.';
	end if;
	if vState then
		delete from catalogo.linea where lineaid=vlineaid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION catalogo.palinea_eliminar(vlineaid integer, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: palinea_lastorder(); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION palinea_lastorder() RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vOrden integer default 0;
BEGIN
	select max(l.orden) into vOrden from catalogo.linea l;
	return coalesce(vOrden, 0);
END
$$;


ALTER FUNCTION catalogo.palinea_lastorder() OWNER TO radiosan_ustaana;

--
-- Name: palinea_leer(integer, integer, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION palinea_leer(vinicio integer, vfin integer, vnombre character varying) RETURNS SETOF type_linea_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select l.lineaid, l.nombre, l.abreviatura, l.codigo_contable, l.orden, l.estado
		from catalogo.linea l
		where l.lineaid>0
			and case when trim(vnombre)!='' then upper(buscar(l.nombre)) like '%'|| upper(buscar(vnombre)) ||'%' else true end
		order by l.nombre
		limit case when vinicio=0 and vfin=0 then null else vfin end offset vinicio;
END
$$;


ALTER FUNCTION catalogo.palinea_leer(vinicio integer, vfin integer, vnombre character varying) OWNER TO radiosan_ustaana;

--
-- Name: pamarca_actualizar(boolean, integer, character varying, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION pamarca_actualizar(innew boolean, inmarcaid integer, innombre character varying, inabreviatura character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from catalogo.marca m where trim(upper(buscar(m.nombre)))=trim(upper(buscar(innombre))) and m.marcaid!=inmarcaid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre de la marca ya existe.';
	end if;
	If vState Then
		if inNew then
			insert into catalogo.marca values(default, trim(innombre), trim(inabreviatura));
			vID:=lastval();
		Else
			update catalogo.marca set nombre=trim(innombre), abreviatura=trim(inabreviatura) where marcaid=inmarcaid;
			vID:=inmarcaid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION catalogo.pamarca_actualizar(innew boolean, inmarcaid integer, innombre character varying, inabreviatura character varying) OWNER TO radiosan_ustaana;

--
-- Name: pamarca_count(character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION pamarca_count(vnombre character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vCount integer default 0;
BEGIN
	select count(*) into vCount
	from catalogo.marca m
	where m.marcaid>0
		and case when trim(vnombre)!='' then upper(buscar(m.nombre)) like '%'|| upper(buscar(vnombre)) ||'%' else true end;

	return coalesce(vCount, 0);
END
$$;


ALTER FUNCTION catalogo.pamarca_count(vnombre character varying) OWNER TO radiosan_ustaana;

--
-- Name: pamarca_eliminar(integer, integer, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION pamarca_eliminar(vmarcaid integer, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from catalogo.producto where marcaid=vmarcaid limit 1) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar la marca por tener productos registrados.';
	end if;
	if vState then
		delete from catalogo.marca where marcaid=vmarcaid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION catalogo.pamarca_eliminar(vmarcaid integer, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: pamarca_leer(integer, integer, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION pamarca_leer(vinicio integer, vfin integer, vnombre character varying) RETURNS SETOF type_marca_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp cascade;
	create temporary table tmp(marcaid integer not null, count integer not null);
	insert into tmp select p.marcaid, count(*) from catalogo.producto p group by 1;
	return query 
		select m.marcaid, m.nombre, m.abreviatura, coalesce(tmp.count, 0)::integer
		from catalogo.marca m left join tmp on m.marcaid=tmp.marcaid
		where m.marcaid>0
			and case when trim(vnombre)!='' then upper(buscar(m.nombre)) like '%'|| upper(buscar(vnombre)) ||'%' else true end
		order by m.nombre
		limit case when vinicio=0 and vfin=0 then null else vfin end offset vinicio;
	drop table if exists tmp cascade;
END
$$;


ALTER FUNCTION catalogo.pamarca_leer(vinicio integer, vfin integer, vnombre character varying) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_actualizar(boolean, integer, integer, integer, integer, integer, integer, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, character varying, numeric, numeric, numeric, numeric, numeric, boolean, integer, integer, integer, integer, numeric, numeric, character varying, boolean, boolean, boolean, boolean, boolean, numeric, boolean, numeric, text, integer, integer, text, text, text, numeric, integer[], integer[], integer, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_actualizar(innew boolean, inproductoid integer, inlineaid integer, insubcategoriaid integer, inmarcaid integer, inunidadmedidaid integer, inunidadid integer, innombre character varying, inpresentacion character varying, inabreviatura character varying, insigla character varying, inbackcolor character varying, inforecolor character varying, incodigo_barras character varying, incodigo_interno character varying, incodigo_sunat character varying, inmoneda character varying, inprecio_com numeric, inprecio_va numeric, inprecio_vb numeric, inprecio_vc numeric, inprecio_vd numeric, infraccion boolean, infraccion_cantidad integer, infraccion_productoid integer, instock_min integer, instock_max integer, inpeso numeric, inflete numeric, instand character varying, inservicio boolean, ingrabado boolean, indestinado_compra boolean, indestinado_venta boolean, inisc boolean, inisc_porcentaje numeric, inpercepcion boolean, inpercepcion_porcentaje numeric, inobservacion text, incolorid integer, inlaboratorioid integer, inprincipio_activo text, inindicaciones text, inregistro_sanitario text, inutilidad numeric, myarrgru integer[], myarrtipope integer[], inusuarioid integer, incaja character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vAlmacenId integer default 0; vAlmacenCantidad integer default 0; vIDOther integer default 0; vIdAux integer default 0;
	vPermisoNombre varchar default ''; vPermisoId integer default 0;
	myrow record;
BEGIN
	if innew then
		vPermisoNombre:='producto-add';
	else
		vPermisoNombre:='producto-edit';
	end if;
	if basic.papersona_getusuario(inusuarioid, 'sistema')!=basic.superusuario() then
		if basic.papermisos_proceso_getid(inusuarioid, vPermisoNombre)=0 then
			vPermisoId:=basic.paproceso_getid(vPermisoNombre);
			vState:=false; vID:=0; vError:=1; vDescripcion:=basic.paproceso_getmensaje(vPermisoId);
			if trim(vDescripcion)='' then
				vDescripcion:='No tiene permisos para realizar este proceso';
			end if;
		end if;
	end if;
	if vState then
		if exists(select * from catalogo.producto p where upper(buscar(trim(p.nombre)||trim(p.presentacion)))=upper(buscar(trim(innombre)||trim(inpresentacion))) and p.productoid!=inproductoid) then
			vState:=false; vID:=0; vError:=1; vDescripcion:='Ya existe un producto registrado igual al que acaba de ingresar';
		end if;
	end if;
	If vState Then
		if trim(incodigo_barras)!='' then
			if exists(select * from catalogo.producto p where upper(buscar(trim(p.codigo_barras)))=upper(buscar(trim(incodigo_barras))) and p.productoid!=inproductoid) then
				select productoid into vIdAux from catalogo.producto p where upper(buscar(trim(p.codigo_barras)))=upper(buscar(trim(incodigo_barras))) and p.productoid!=inproductoid;
				vState:=false; vID:=0; vError:=1; vDescripcion:='Ya existe un codigo de barras registrado igual al que acaba de ingresar. Se encuentra en '||catalogo.paproducto_getnombre(vIdAux)||'';
			end if;
		end if;
	end if;
	If vState Then
		if trim(incodigo_interno)!='' then
			if exists(select * from catalogo.producto p where upper(buscar(trim(p.codigo_interno)))=upper(buscar(trim(incodigo_interno))) and p.productoid!=inproductoid) then
				select productoid into vIdAux from catalogo.producto p where upper(buscar(trim(p.codigo_barras)))=upper(buscar(trim(incodigo_barras))) and p.productoid!=inproductoid;
				vState:=false; vID:=0; vError:=1; vDescripcion:='Ya existe un codigo interno registrado igual al que acaba de ingresar. Se encuentra en '||catalogo.paproducto_getnombre(vIdAux)||'';
			end if;
		end if;
	end if;
	If vState Then
		If inNew Then
			insert into catalogo.producto values(default, current_timestamp, inlineaid, insubcategoriaid, inmarcaid, inunidadmedidaid, 
				trim(innombre), trim(inpresentacion), trim(inabreviatura), trim(incodigo_barras), trim(incodigo_interno), trim(inmoneda), 
				inprecio_com, inprecio_va, inprecio_vb, inprecio_vc, inprecio_vd, 
				infraccion, infraccion_cantidad, infraccion_productoid, instock_min, instock_max, inpeso, inflete, trim(instand), 
				inservicio, ingrabado, false, indestinado_compra, indestinado_venta, 
				inisc, inisc_porcentaje, inpercepcion, inpercepcion_porcentaje, trim(inobservacion), true,
				trim(insigla), trim(inbackcolor), trim(inforecolor), 
				incolorid, inlaboratorioid, trim(inprincipio_activo), trim(inindicaciones), trim(inregistro_sanitario),
				inunidadid, trim(incodigo_sunat), inutilidad
				);
			vID:=lastval();
		Else
			--BEGIN RASTRO
			vIDOther:=nextval('rastro.productoedit_productoeditid_seq');
			insert into rastro.productoedit values(vIDOther, inproductoid, inusuarioid, 'E', current_timestamp, incaja, 1);
			execute rastro.paproductoinsert(vIDOther, 'O');
			
			update catalogo.producto set 
				nombre=trim(innombre), presentacion=trim(inpresentacion), codigo_interno=trim(incodigo_interno), abreviatura=trim(inabreviatura), codigo_barras=trim(incodigo_barras), 
				lineaid=inlineaid, subcategoriaid=insubcategoriaid, marcaid=inmarcaid, unidadmedidaid=inunidadmedidaid,
				precio_com=inprecio_com, precio_va=inprecio_va, precio_vc=inprecio_vc, precio_vd=inprecio_vd, precio_vb=inprecio_vb, 
				fraccion=infraccion, fraccion_cantidad=infraccion_cantidad, fraccion_productoid=infraccion_productoid,
				stock_min=instock_min, stock_max=instock_max, peso=inpeso, flete=inflete, stand=trim(instand), 
				servicio=inservicio, grabado=ingrabado, destinado_compra=indestinado_compra, destinado_venta=indestinado_venta, 
				isc=inisc, isc_porcentaje=inisc_porcentaje, percepcion=inpercepcion, percepcion_porcentaje=inpercepcion_porcentaje,
				observacion=trim(inobservacion), sigla=trim(insigla), backcolor=trim(inbackcolor), forecolor=trim(inforecolor),
				colorid=incolorid, laboratorioid=inlaboratorioid, principio_activo=trim(inprincipio_activo), indicaciones=trim(inindicaciones), registro_sanitario=trim(inregistro_sanitario),
				unidadid=inunidadid, codigo_sunat=trim(incodigo_sunat), utilidad=inutilidad
			where productoid=inproductoid;
			vID:=inproductoid;

			select min(almacenid), count(*) into vAlmacenId, vAlmacenCantidad from basic.almacen;
			vAlmacenId:=coalesce(vAlmacenId, 0);
			vAlmacenCantidad:=coalesce(vAlmacenCantidad, 0);
			if vAlmacenCantidad=1 then
				if exists (select * from catalogo.producto_almacen where almacenid=vAlmacenId and productoid=vID) then
					update catalogo.producto_almacen 
						set stock_min=instock_min, stock_max=instock_max, precio_va=inprecio_va, precio_vb=inprecio_vb, precio_vc=inprecio_vc, precio_vd=inprecio_vd
					where productoid=vID and almacenid=vAlmacenId;
				else
					insert into catalogo.producto_almacen  values (vAlmacenId, vID, instock_min, instock_max, inprecio_va, inprecio_vb, inprecio_vc, inprecio_vd);
				end if;
			else
				if exists(select * from basic.almacen alm inner join basic.almacen_config conf on alm.almacenid=conf.almacenid where conf.updateprecio=true) then
					for myrow in select alm.almacenid from basic.almacen alm inner join basic.almacen_config conf on alm.almacenid=conf.almacenid where conf.updateprecio=true loop
						if exists (select * from catalogo.producto_almacen where almacenid=myrow.almacenid and productoid=vID) then
							update catalogo.producto_almacen 
								set stock_min=instock_min, stock_max=instock_max, precio_va=inprecio_va, precio_vb=inprecio_vb, precio_vc=inprecio_vc, precio_vd=inprecio_vd
							where productoid=vID and almacenid=myrow.almacenid;
						else
							insert into catalogo.producto_almacen  values (myrow.almacenid, vID, instock_min, instock_max, inprecio_va, inprecio_vb, inprecio_vc, inprecio_vd);
						end if;
					end loop;
				end if;
			end if;
		end if;
		delete from catalogo.producto_grupo where productoid=vID;
		insert into catalogo.producto_grupo select vID, myarrgru[i] from generate_series(1, array_upper(myarrgru, 1)) as i;

		delete from catalogo.producto_tipooperacion where productoid=vID;
		insert into catalogo.producto_tipooperacion select vID, myarrtipope[i] from generate_series(1, array_upper(myarrtipope, 1)) as i;
		
		If not inNew Then
			--RASTRO DE LOS DATOS NUEVOS
			execute rastro.paproductoinsert(vIDOther, 'N');
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION catalogo.paproducto_actualizar(innew boolean, inproductoid integer, inlineaid integer, insubcategoriaid integer, inmarcaid integer, inunidadmedidaid integer, inunidadid integer, innombre character varying, inpresentacion character varying, inabreviatura character varying, insigla character varying, inbackcolor character varying, inforecolor character varying, incodigo_barras character varying, incodigo_interno character varying, incodigo_sunat character varying, inmoneda character varying, inprecio_com numeric, inprecio_va numeric, inprecio_vb numeric, inprecio_vc numeric, inprecio_vd numeric, infraccion boolean, infraccion_cantidad integer, infraccion_productoid integer, instock_min integer, instock_max integer, inpeso numeric, inflete numeric, instand character varying, inservicio boolean, ingrabado boolean, indestinado_compra boolean, indestinado_venta boolean, inisc boolean, inisc_porcentaje numeric, inpercepcion boolean, inpercepcion_porcentaje numeric, inobservacion text, incolorid integer, inlaboratorioid integer, inprincipio_activo text, inindicaciones text, inregistro_sanitario text, inutilidad numeric, myarrgru integer[], myarrtipope integer[], inusuarioid integer, incaja character varying) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_almacen_consulta_app(integer, integer); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_almacen_consulta_app(vproductoid integer, valmacen_noincluido integer) RETURNS SETOF type_producto_almacen_consulta_app
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query
		select a.almacenid, a.nombre,coalesce(pa.precio_va, 0)::numeric
		from basic.almacen a left join catalogo.producto_almacen pa on a.almacenid=pa.almacenid and vproductoid=pa.productoid
		where pa.precio_va>0
			and case when valmacen_noincluido>0 then a.almacenid!=valmacen_noincluido else true end
		order by a.nombre;
		
END
$$;


ALTER FUNCTION catalogo.paproducto_almacen_consulta_app(vproductoid integer, valmacen_noincluido integer) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_almacen_consulta_stock(integer, integer, integer); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_almacen_consulta_stock(vano integer, vproductoid integer, valmacen_noincluido integer) RETURNS SETOF type_producto_almacen_consulta_stock
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp_stock cascade;
	
	create temporary table tmp_stock(almacenid integer not null, stock integer not null);
	insert into tmp_stock 
		select s.almacenid, sum(s.stock) 
		from inventarios.stock s
		where s.productoid=vproductoid
		group by s.almacenid;
		
	return query
		select a.almacenid, a.nombre, a.zonaid, z.nombre, coalesce(pa.stock_min,0)::integer, coalesce(pa.stock_max,0)::integer, 
			coalesce(pa.precio_va, 0)::numeric, coalesce(pa.precio_vb, 0)::numeric, coalesce(pa.precio_vc, 0)::numeric, coalesce(pa.precio_vd, 0)::numeric, coalesce(s.stock,0)::integer
		from basic.almacen a inner join basic.zona z on a.zonaid=z.zonaid
			left join tmp_stock s on a.almacenid=s.almacenid
			left join catalogo.producto_almacen pa on a.almacenid=pa.almacenid and vproductoid=pa.productoid
		where 1=1
			and case when valmacen_noincluido>0 then a.almacenid!=valmacen_noincluido else true end
		order by z.orden, a.nombre;
		
	drop table if exists tmp_stock cascade;
END
$$;


ALTER FUNCTION catalogo.paproducto_almacen_consulta_stock(vano integer, vproductoid integer, valmacen_noincluido integer) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_almacen_consulta_stock(integer, integer, integer, integer); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_almacen_consulta_stock(vempresaid integer, vano integer, vproductoid integer, valmacen_noincluido integer) RETURNS SETOF type_producto_almacen_consulta_stock
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp_stock cascade;
	
	create temporary table tmp_stock(almacenid integer not null, stock integer not null);
	insert into tmp_stock 
		select s.almacenid, sum(s.stock) 
		from inventarios.stock s
		where s.productoid=vproductoid and s.empresaid=vempresaid
		group by s.almacenid;
		
	return query
		select a.almacenid, a.nombre, a.zonaid, z.nombre, coalesce(pa.stock_min,0)::integer, coalesce(pa.stock_max,0)::integer, 
			coalesce(pa.precio_va, 0)::numeric, coalesce(pa.precio_vb, 0)::numeric, coalesce(pa.precio_vc, 0)::numeric, coalesce(pa.precio_vd, 0)::numeric, coalesce(s.stock,0)::integer
		from basic.almacen a inner join basic.zona z on a.zonaid=z.zonaid
			left join tmp_stock s on a.almacenid=s.almacenid
			left join catalogo.producto_almacen pa on a.almacenid=pa.almacenid and vproductoid=pa.productoid
		where 1=1
			and case when valmacen_noincluido>0 then a.almacenid!=valmacen_noincluido else true end
		order by z.orden, a.nombre;
		
	drop table if exists tmp_stock cascade;
END
$$;


ALTER FUNCTION catalogo.paproducto_almacen_consulta_stock(vempresaid integer, vano integer, vproductoid integer, valmacen_noincluido integer) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_almacen_duplicar(integer, integer, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_almacen_duplicar(vproductoid integer, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	myRow record;
BEGIN
	if exists(select * from catalogo.producto where productoid=vproductoid) then
		select * into myRow from catalogo.producto where productoid=vproductoid;
		delete from catalogo.producto_almacen where productoid=vproductoid;
		insert into catalogo.producto_almacen select alm.almacenid, vproductoid, myRow.stock_min, myRow.stock_max, myRow.precio_va, myRow.precio_vb, myRow.precio_vc, myRow.precio_vd from basic.almacen alm;
	else
		vState:=false; vID:=0; vError:=1; vDescripcion:='El codigo no existe.';
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION catalogo.paproducto_almacen_duplicar(vproductoid integer, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_almacen_getalmacenesbyproducto(integer); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_almacen_getalmacenesbyproducto(vproductoid integer) RETURNS SETOF type_producto_almacen_getalmacenesbyproducto
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp cascade;
	create temporary table tmp(almacenid integer not null);
	insert into tmp select ea.almacenid from basic.empresa_almacen ea where ea.empresaid in (select ec.empresaid from basic.empresa_config ec where ec.grupoid in (select grupoid from catalogo.producto_grupo pg where pg.productoid=vproductoid)) group by 1;

	return query
		select a.almacenid, a.nombre, a.zonaid, z.nombre
		from tmp inner join basic.almacen a on tmp.almacenid=a.almacenid
			inner join basic.zona z on a.zonaid=z.zonaid
		order by z.orden, a.nombre;
		
	drop table if exists tmp cascade;
END
$$;


ALTER FUNCTION catalogo.paproducto_almacen_getalmacenesbyproducto(vproductoid integer) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_almacen_getalmacenesbyproducto_app(integer); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_almacen_getalmacenesbyproducto_app(vproductoid integer) RETURNS SETOF type_producto_almacen_getalmacenesbyproductoapp
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp cascade;
	create temporary table tmp(almacenid integer not null);
	insert into tmp select ea.almacenid from basic.empresa_almacen ea where ea.empresaid in (select ec.empresaid from basic.empresa_config ec where ec.grupoid in (select grupoid from catalogo.producto_grupo pg where pg.productoid=vproductoid)) group by 1;

	return query
		select a.almacenid, a.nombre,pa.precio_va,p.precio_va
		from tmp inner join basic.almacen a on tmp.almacenid=a.almacenid
			inner join basic.zona z on a.zonaid=z.zonaid inner join catalogo.producto_almacen pa on pa.almacenid=a.almacenid inner join catalogo.producto p on p.productoid=pa.productoid
		where pa.productoid=vproductoid	
		order by z.orden, a.nombre;
		
	drop table if exists tmp cascade;
END
$$;


ALTER FUNCTION catalogo.paproducto_almacen_getalmacenesbyproducto_app(vproductoid integer) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_almacen_getrow(integer, integer, integer); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_almacen_getrow(vproductoid integer, valmacenid integer, vano integer) RETURNS SETOF type_producto_almacen_getrow
    LANGUAGE plpgsql
    AS $$
declare vstock numeric default 0; 
BEGIN
	select s.stock into vstock from inventarios.stock s where s.almacenid=valmacenid and s.productoid=vproductoid;
		
	return query
		select pa.productoid, a.almacenid, a.nombre, a.zonaid, z.nombre, pa.stock_min, pa.stock_max, 
			pa.precio_va, pa.precio_vb, pa.precio_vc, pa.precio_vd, 
			coalesce(vstock, 0)::numeric, inventarios.ultimo_precio_venta(vproductoid, valmacenid, '')
		from catalogo.producto_almacen pa inner join basic.almacen a on pa.almacenid=a.almacenid
			inner join basic.zona z on a.zonaid=z.zonaid
		where pa.almacenid=valmacenid and pa.productoid=vproductoid
		order by z.orden, a.nombre;
		
END
$$;


ALTER FUNCTION catalogo.paproducto_almacen_getrow(vproductoid integer, valmacenid integer, vano integer) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_almacen_getrow(integer, integer, integer, integer); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_almacen_getrow(vempresaid integer, vproductoid integer, valmacenid integer, vano integer) RETURNS SETOF type_producto_almacen_getrow
    LANGUAGE plpgsql
    AS $$
declare vstock numeric default 0; 
BEGIN
	select s.stock into vstock from inventarios.stock s where s.almacenid=valmacenid and s.productoid=vproductoid and s.empresaid=vempresaid;
		
	return query
		select pa.productoid, a.almacenid, a.nombre, a.zonaid, z.nombre, pa.stock_min, pa.stock_max, 
			pa.precio_va, pa.precio_vb, pa.precio_vc, pa.precio_vd, 
			coalesce(vstock, 0)::numeric, inventarios.ultimo_precio_venta(vproductoid, valmacenid, '')
		from catalogo.producto_almacen pa inner join basic.almacen a on pa.almacenid=a.almacenid
			inner join basic.zona z on a.zonaid=z.zonaid
		where pa.almacenid=valmacenid and pa.productoid=vproductoid
		order by z.orden, a.nombre;
		
END
$$;


ALTER FUNCTION catalogo.paproducto_almacen_getrow(vempresaid integer, vproductoid integer, valmacenid integer, vano integer) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_almacen_leer(integer, integer, integer, integer); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_almacen_leer(vempresaid integer, vano integer, vproductoid integer, valmacen_noincluido integer) RETURNS SETOF type_producto_almacen_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp_stock cascade;
	create temporary table tmp_stock(almacenid integer not null, stock integer not null);
	insert into tmp_stock 
		select s.almacenid, sum(s.stock) 
		from inventarios.stock s
		where s.productoid=vproductoid and s.empresaid=vempresaid
		group by s.almacenid;
		
	return query
		select a.almacenid, a.nombre, a.zonaid, z.nombre, coalesce(pa.stock_min,0)::integer, coalesce(pa.stock_max,0)::integer, 
			coalesce(pa.precio_va, 0)::numeric, coalesce(pa.precio_vb, 0)::numeric, coalesce(pa.precio_vc, 0)::numeric, coalesce(pa.precio_vd, 0)::numeric, coalesce(s.stock,0)::integer
		from basic.almacen a inner join basic.zona z on a.zonaid=z.zonaid
			left join tmp_stock s on a.almacenid=s.almacenid
			left join catalogo.producto_almacen pa on a.almacenid=pa.almacenid and vproductoid=pa.productoid
		where 1=1
			and case when valmacen_noincluido>0 then a.almacenid!=valmacen_noincluido else true end
		order by z.orden, a.nombre;
		
	drop table if exists tmp_stock cascade;
END
$$;


ALTER FUNCTION catalogo.paproducto_almacen_leer(vempresaid integer, vano integer, vproductoid integer, valmacen_noincluido integer) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_almacen_registrar(integer, character varying[], integer, boolean, integer, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_almacen_registrar(vproductoid integer, myarr character varying[], vcambiarprecioid integer, vcambiarpreciorecordar boolean, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vIndice integer default 0; vFilas integer default 0; valmacenid integer default 0;
	vRastroId integer default 0; vStockMinOld integer default 0; vStockMaxOld integer default 0; vPreVAOld numeric default 0; vPreVBOld numeric default 0; vPreVCOld numeric default 0; vPreVDOld numeric default 0;
	vPermisoNombre varchar default 'catalogo-cambiar-precios'; vPermisoId integer default 0;
begin
	if basic.papermisos_proceso_getid(vusuarioid, vPermisoNombre)=0 then
		vPermisoId:=basic.paproceso_getid(vPermisoNombre);
		vState:=false; vID:=0; vError:=1; vDescripcion:=basic.paproceso_getmensaje(vPermisoId);
		if trim(vDescripcion)='' then
			vDescripcion:='No tiene permisos para realizar este proceso';
		end if;
	end if;
	if vState then
		vFilas=array_upper(myarr,1);
		if (not (myarr[1][1] is null)) then
			vIndice:=0;
			if vFilas>0 then
				for vIndice in 1..vFilas loop
					valmacenid:=myarr[vIndice][1]::integer;
					if valmacenid>0 and vproductoid>0 then
						if not exists(select * from catalogo.producto_almacen where productoid=vproductoid and almacenid=valmacenid) then
							insert into catalogo.producto_almacen values(valmacenid, vproductoid, myarr[vIndice][2]::integer, myarr[vIndice][3]::integer, myarr[vIndice][4]::numeric, myarr[vIndice][5]::numeric, myarr[vIndice][6]::numeric, myarr[vIndice][7]::numeric);
						else
							--PARA EL RASTRO
							select stock_min, stock_max, precio_va, precio_vb, precio_vc, precio_vd into vStockMinOld, vStockMaxOld, vPreVAOld, vPreVBOld, vPreVCOld, vPreVDOld from catalogo.producto_almacen where productoid=vproductoid and almacenid=valmacenid;

							update catalogo.producto_almacen 
								set stock_min=myarr[vIndice][2]::numeric, stock_max=myarr[vIndice][3]::numeric, 
								    precio_va=myarr[vIndice][4]::numeric, precio_vb=myarr[vIndice][5]::numeric, 
								    precio_vc=myarr[vIndice][6]::numeric, precio_vd=myarr[vIndice][7]::numeric
							where almacenid=valmacenid and productoid=vproductoid;

						end if;

						--BEGIN RASTRO
						vRastroId:=nextval('rastro.cambiar_precios_cambiarpreciosid_seq');
						insert into rastro.cambiar_precios values(vRastroId, current_timestamp, vproductoid, valmacenid, 
							coalesce(vStockMinOld, 0), coalesce(vStockMaxOld, 0), coalesce(vPreVAOld, 0), coalesce(vPreVBOld, 0), coalesce(vPreVCOld, 0), coalesce(vPreVDOld, 0), 
							myarr[vIndice][2]::integer, myarr[vIndice][3]::integer, myarr[vIndice][4]::numeric, myarr[vIndice][5]::numeric, myarr[vIndice][6]::numeric, myarr[vIndice][7]::numeric,
							vusuarioid, trim(vip));

						if vcambiarpreciorecordar then
							insert into catalogo.cambiar_precios values(default, current_timestamp, valmacenid, vproductoid, '', 1, vusuarioid, '', 0, '', vcambiarprecioid);
						end if;
						if vcambiarprecioid>0 then
							update catalogo.cambiar_precios set estado=2 where id=vcambiarprecioid;
						end if;

					end if;
				end loop;
			end if;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
end 
$$;


ALTER FUNCTION catalogo.paproducto_almacen_registrar(vproductoid integer, myarr character varying[], vcambiarprecioid integer, vcambiarpreciorecordar boolean, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_cambiar_estado(integer, integer, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_cambiar_estado(vproductoid integer, vusuario integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vEstadoOld boolean default false;
BEGIN
	if vState then
		if exists(select * from catalogo.producto where productoid=vproductoid) then
			--RASTRO
			select estado into vEstadoOld from catalogo.producto where productoid=vproductoid;
			insert into rastro.campo values(default, 'catalogo', 'producto', 'estado', 'B', vproductoid, 0, 0, vEstadoOld::varchar, (not vEstadoOld)::varchar, current_timestamp, vusuario, vip, 1, 0);
			
			update catalogo.producto set estado=not estado where productoid=vproductoid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION catalogo.paproducto_cambiar_estado(vproductoid integer, vusuario integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_cambiar_oferta(integer, integer, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_cambiar_oferta(vproductoid integer, vusuario integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vEstadoOld boolean default false;
BEGIN
	if vState then
		if exists(select * from catalogo.producto where productoid=vproductoid) then
			--RASTRO
			select oferta into vEstadoOld from catalogo.producto where productoid=vproductoid;
			insert into rastro.campo values(default, 'catalogo', 'producto', 'oferta', 'B', vproductoid, 0, 0, vEstadoOld::varchar, (not vEstadoOld)::varchar, current_timestamp, vusuario, vip, 1, 0);
			
			update catalogo.producto set oferta=not oferta where productoid=vproductoid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION catalogo.paproducto_cambiar_oferta(vproductoid integer, vusuario integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_consulta(integer, integer, integer, integer, character varying, integer, integer); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_consulta(vano integer, vempresaid integer, valmacenid integer, vlimite integer, vnombre character varying, vproductoid integer, vtipoventaid integer) RETURNS SETOF type_producto_consulta
    LANGUAGE plpgsql
    AS $$
declare vgrupoid integer default basic.paempresa_almacen_getgrupoid(vempresaid, valmacenid); vnombreaux varchar default '';
BEGIN
	vnombreaux:=replace(vnombre, '+', '%');
	if vgrupoid=0 then
		vgrupoid=basic.paempresa_getgrupoid(vempresaid);
	end if;

	drop table if exists tmp_pro, tmp_stock cascade;
	create temporary table tmp_pro(productoid integer not null);
	create temporary table tmp_stock(productoid integer not null, stock numeric not null);

	insert into tmp_pro select pg.productoid from catalogo.producto_grupo pg where pg.grupoid=vgrupoid;
	insert into tmp_stock 
		select s.productoid, sum(s.stock) 
		from tmp_pro inner join inventarios.stock s on tmp_pro.productoid=s.productoid
		where 1=1
			and case when vempresaid>0 then s.empresaid=vempresaid else true end
			and case when valmacenid>0 then s.almacenid=valmacenid else true end
		group by s.productoid;
		
	return query
		select p.productoid, (p.nombre || case when p.presentacion!='' then (', ' || p.presentacion) else '' end)::varchar,
			coalesce(um.nombre,'')::varchar, coalesce(m.nombre,'')::varchar, coalesce(sub.nombre,'')::varchar, 
			(case when pa.productoid is null then p.precio_va else coalesce(pa.precio_va, 0) end)::numeric, 
			(case when pa.productoid is null then p.precio_vb else coalesce(pa.precio_vb, 0) end)::numeric,
			(case when pa.productoid is null then p.precio_vc else coalesce(pa.precio_vc, 0) end)::numeric,
			(case when pa.productoid is null then p.precio_vd else coalesce(pa.precio_vd, 0) end)::numeric,
			p.precio_com, p.peso, coalesce(s.stock,0)::numeric, 
			coalesce(p.subcategoriaid, 0)::integer, p.codigo_barras, coalesce(pa.stock_min,0)::integer, coalesce(pa.stock_max,0)::integer, 
			p.flete, p.grabado, p.stand, p.observacion, p.oferta, p.servicio
		from tmp_pro inner join catalogo.producto as p on tmp_pro.productoid=p.productoid
			inner join catalogo.subcategoria as sub on p.subcategoriaid=sub.subcategoriaid 
			inner join catalogo.marca m on p.marcaid=m.marcaid
			inner join catalogo.unidadmedida um on p.unidadmedidaid=um.unidadmedidaid
			left join tmp_stock s on p.productoid=s.productoid
			left join catalogo.producto_almacen pa on p.productoid=pa.productoid and valmacenid=pa.almacenid
		where p.estado=true
			and case when trim(vNombreAux)!='' then 
				--case when not isnumeric(trim(vNombreAux)) then
					(
					upper(p.nombre||' '||p.presentacion||' '||m.nombre) like '%' || upper(vnombreaux) || '%' 
					or upper(p.codigo_barras) like '%' || upper(vnombreaux) || '%' 
					or upper(p.codigo_interno) like '%' || upper(vnombreaux) || '%' 
					or trim(cast(p.productoid as varchar)) like '%'|| trim(vnombreaux) ||'%'
					)
					--else p.codigo=vnombre::integer end
				else true end
			and case when vproductoid>0 then p.productoid=vproductoid else true end
		order by 2
		limit case when vlimite>0 then vlimite else null end;
		
	drop table if exists tmp_pro, tmp_stock cascade;
END
$$;


ALTER FUNCTION catalogo.paproducto_consulta(vano integer, vempresaid integer, valmacenid integer, vlimite integer, vnombre character varying, vproductoid integer, vtipoventaid integer) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_consulta(integer, integer, integer, integer, character varying, integer, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_consulta(vano integer, vempresaid integer, valmacenid integer, vlimite integer, vnombre character varying, vproductoid integer, vidbarras character varying) RETURNS SETOF type_producto_consulta_old
    LANGUAGE plpgsql
    AS $$
declare vgrupoid integer default basic.paempresa_getgrupoid(vempresaid); vnombreaux varchar default '';
BEGIN
	vnombreaux:=replace(vnombre, '+', '%');

	drop table if exists tmp_pro, tmp_stock cascade;
	create temporary table tmp_pro(productoid integer not null);
	create temporary table tmp_stock(productoid integer not null, stock numeric not null);

	insert into tmp_pro select pg.productoid from catalogo.producto_grupo pg where pg.grupoid=vgrupoid;
	insert into tmp_stock 
		select s.productoid, sum(s.stock) 
		from tmp_pro inner join inventarios.stock s on tmp_pro.productoid=s.productoid
		where 1=1
			and case when valmacenid>0 then s.almacenid=valmacenid else true end
		group by s.productoid;
		
	return query
		select p.productoid, (p.nombre || case when p.presentacion!='' then (', ' || p.presentacion) else '' end)::varchar,
			coalesce(m.nombre,'')::varchar, coalesce(sub.nombre,'')::varchar, 
			(case when pa.productoid is null then p.precio_va else coalesce(pa.precio_va, 0) end)::numeric, 
			(case when pa.productoid is null then p.precio_vb else coalesce(pa.precio_vb, 0) end)::numeric,
			(case when pa.productoid is null then p.precio_vc else coalesce(pa.precio_vc, 0) end)::numeric,
			(case when pa.productoid is null then p.precio_vd else coalesce(pa.precio_vd, 0) end)::numeric,
			p.precio_com, p.peso, coalesce(s.stock,0)::numeric, 
			coalesce(p.subcategoriaid, 0)::integer, p.codigo_barras, coalesce(pa.stock_min,0)::integer, coalesce(pa.stock_max,0)::integer, 
			p.flete, p.grabado, p.stand, p.observacion, p.oferta
		from tmp_pro inner join catalogo.producto as p on tmp_pro.productoid=p.productoid
			inner join catalogo.subcategoria as sub on p.subcategoriaid=sub.subcategoriaid 
			left join tmp_stock s on p.productoid=s.productoid
			inner join catalogo.marca m on p.marcaid=m.marcaid
			left join catalogo.producto_almacen pa on p.productoid=pa.productoid and valmacenid=pa.almacenid
		where p.estado=true
			and case when trim(vNombreAux)!='' then 
				--case when not isnumeric(trim(vNombreAux)) then
					(
					upper(p.nombre||' '||p.presentacion||' '||m.nombre) like '%' || upper(vnombreaux) || '%' 
					or upper(p.codigo_barras) like '%' || upper(vnombreaux) || '%' 
					or upper(p.codigo_interno) like '%' || upper(vnombreaux) || '%' 
					or trim(cast(p.productoid as varchar)) like '%'|| trim(vnombreaux) ||'%'
					)
					--else p.codigo=vnombre::integer end
				else true end
			and case when vproductoid>0 then p.productoid=vproductoid else true end
			and case when trim(vIDBarras)!='' then upper(p.codigo_barras) like '' || upper(vIDBarras) || '%' else true end
		order by 2
		limit case when vlimite>0 then vlimite else null end;
		
	drop table if exists tmp_pro, tmp_stock cascade;
END
$$;


ALTER FUNCTION catalogo.paproducto_consulta(vano integer, vempresaid integer, valmacenid integer, vlimite integer, vnombre character varying, vproductoid integer, vidbarras character varying) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_consulta_app(integer, character varying, integer); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_consulta_app(vlimite integer, vnombre character varying, vusuarioid integer) RETURNS SETOF type_producto_consulta_app
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp_grupos, tmp_pro cascade;
	create temporary table tmp_grupos(grupoid integer not null);
	create temporary table tmp_pro(productoid integer not null);
	insert into tmp_grupos select basic.paempresa_getgrupoid(empresaid) from basic.papermisos_empresa_leer_empresas(vusuarioid);
	insert into tmp_pro select pg.productoid from catalogo.producto_grupo pg where pg.grupoid in (select grupoid from tmp_grupos) group by 1;
	
	return query
		select p.productoid, (p.nombre || case when p.presentacion!='' then (', ' || p.presentacion) else '' end)::varchar
		from tmp_pro inner join catalogo.producto as p on tmp_pro.productoid=p.productoid
			inner join catalogo.marca m on p.marcaid=m.marcaid
		where p.estado=true
			and case when trim(vNombre)!='' then 
					(
					upper(p.nombre||' '||p.presentacion||' '||m.nombre) like '%' || upper(vNombre) || '%' 
					or upper(p.codigo_barras) like '%' || upper(vnombre) || '%' 
					or trim(cast(p.productoid as varchar)) like '%'|| trim(vnombre) ||'%'
					)
				else true end
			
		order by 2
		limit case when vlimite>0 then vlimite else null end;
		
	drop table if exists tmp_grupos, tmp_pro cascade;
END
$$;


ALTER FUNCTION catalogo.paproducto_consulta_app(vlimite integer, vnombre character varying, vusuarioid integer) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_count(integer, character varying, integer, integer, integer, integer, integer, integer, character varying, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_count(vano integer, vnombre character varying, vproductoid integer, vlineaid integer, vsubcategoriaid integer, vcategoriaid integer, vmarcaid integer, vunidadmedidaid integer, vstock character varying, vestado character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vtexto varchar default ''; vCount integer default 0;
BEGIN
	drop table if exists tmp_stock cascade;
	create temporary table tmp_stock(productoid integer not null, stock numeric not null);
	insert into tmp_stock 
		select s.productoid, sum(s.stock) 
		from inventarios.stock s
		where 1=1
		group by s.productoid;

	vtexto:=replace(trim(vnombre), '+', '%');
	select count(*) into vCount
	from catalogo.producto as p left join catalogo.subcategoria as sub on p.subcategoriaid=sub.subcategoriaid
		left join catalogo.categoria as c on sub.categoriaid=c.categoriaid
		left join catalogo.marca m on p.marcaid=m.marcaid
		left join tmp_stock s on p.productoid=s.productoid
	where 1=1 
		and case when trim(vnombre)!='' then 
			upper(p.nombre||' '||p.presentacion||' '||m.nombre) like '%' || upper(vtexto) || '%' 
			or trim(p.codigo_barras) like '%'||trim(vnombre)||'%'
			else true end
		and case when vproductoid>0 then p.productoid=vproductoid else true end
		and case when vlineaid>0 then p.lineaid=vlineaid else true end
		and case when vsubcategoriaid>0 then sub.subcategoriaid=vsubcategoriaid else true end
		and case when vcategoriaid>0 then c.categoriaid=vcategoriaid else true end
		and case when vmarcaid>0 then p.marcaid=vmarcaid else true end
		and case when vunidadmedidaid>0 then p.unidadmedidaid=vunidadmedidaid else true end
		and case when trim(vstock)='CONSTOCK' then coalesce(s.stock, 0)>0 else true end
		and case when trim(vstock)='SINSTOCK' then coalesce(s.stock, 0)<=0 else true end
		and case when trim(vstock)='STOCKNEGATIVO' then coalesce(s.stock, 0)<0 else true end
		and case when trim(vestado)!='' then p.estado=(trim(vestado)='Y') else true end;

	drop table if exists tmp_stock cascade;

	return coalesce(vCount, 0);
END
$$;


ALTER FUNCTION catalogo.paproducto_count(vano integer, vnombre character varying, vproductoid integer, vlineaid integer, vsubcategoriaid integer, vcategoriaid integer, vmarcaid integer, vunidadmedidaid integer, vstock character varying, vestado character varying) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_eliminar(integer, integer, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_eliminar(vproductoid integer, vusuarioid integer, vcaja character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	vIDOther integer default 0; vPermisoNombre varchar default 'producto-delete'; vPermisoId integer default 0;
BEGIN

	if basic.papersona_getusuario(vusuarioid, 'sistema')!=basic.superusuario() then
		if basic.papermisos_proceso_getid(vusuarioid, vPermisoNombre)=0 then
			vPermisoId:=basic.paproceso_getid(vPermisoNombre);
			vState:=false; vID:=0; vError:=1; vDescripcion:=basic.paproceso_getmensaje(vPermisoId);
			if trim(vDescripcion)='' then
				vDescripcion:='No tiene permisos para realizar este proceso';
			end if;
		end if;
	end if;
	if vState then
		if exists(select * from inventarios.venta_detalle where productoid=vproductoid limit 1) then
			vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar el producto por tener ventas registradas.';
		end if;
	end if;
	if vState then
		if exists(select * from inventarios.ingreso_detalle where productoid=vproductoid limit 1) then
			vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar el producto por tener ingresos registrados.';
		end if;
	end if;
	if vState then
		if exists(select * from inventarios.salida_detalle where productoid=vproductoid limit 1) then
			vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar el producto por tener salidas registradas.';
		end if;
	end if;
	if vState then
		if exists(select * from inventarios.pedido_detalle where productoid=vproductoid limit 1) then
			vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar el producto por tener pedidos registrados.';
		end if;
	end if;
	if vState then
		--INICIO RASTRO DELETE
		vIDOther:=nextval('rastro.productoedit_productoeditid_seq');
		insert into rastro.productoedit values(vIDOther, vproductoid, vusuarioid, 'D', current_timestamp, vcaja, 1);
		execute rastro.paproductoinsert(vIDOther, 'O');
		--FIN RASTRO DELETE

		delete from inventarios.stock_inicial where productoid=vproductoid;
		delete from inventarios.stock where productoid=vproductoid;
		delete from catalogo.producto_almacen where productoid=vproductoid;
		delete from inventarios.proveedores_producto where productoid=vproductoid;
		delete from catalogo.producto_tipoprecio where productoid=vproductoid;
		delete from catalogo.producto_grupo where productoid=vproductoid;
		delete from catalogo.producto_tipooperacion where productoid=vproductoid;
		delete from catalogo.producto where productoid=vproductoid;
	end if;
	
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION catalogo.paproducto_eliminar(vproductoid integer, vusuarioid integer, vcaja character varying) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_enoferta(integer, integer, integer, character varying, integer); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_enoferta(vempresaid integer, valmacenid integer, vano integer, vnombre character varying, vlimite integer) RETURNS SETOF type_producto_enoferta
    LANGUAGE plpgsql
    AS $$
declare vtexto varchar default '';
BEGIN
	vtexto:=replace(vnombre, '+', '%');
	
	drop table if exists tmp_stock cascade;
	create temporary table tmp_stock(productoid integer not null, stock numeric not null);
	insert into tmp_stock 
		select s.productoid, sum(s.stock) 
		from inventarios.stock s
		where 1=1
			and case when vempresaid>0 then s.empresaid=vempresaid else true end
			and case when valmacenid>0 then s.almacenid=valmacenid else true end
		group by s.productoid;
		
	return query
		select p.productoid, (p.nombre || case when p.presentacion!='' then (', ' || p.presentacion) else '' end)::varchar,
			coalesce(um.abreviatura,'')::varchar, coalesce(m.nombre,'')::varchar, coalesce(sub.nombre,'')::varchar, 
			(case when pa.productoid is null then p.precio_va else coalesce(pa.precio_va, 0) end)::numeric, 
			(case when pa.productoid is null then p.precio_vb else coalesce(pa.precio_vb, 0) end)::numeric,
			(case when pa.productoid is null then p.precio_vc else coalesce(pa.precio_vc, 0) end)::numeric,
			(case when pa.productoid is null then p.precio_vd else coalesce(pa.precio_vd, 0) end)::numeric,
			p.precio_com, p.peso, coalesce(s.stock,0)::numeric, 
			coalesce(p.subcategoriaid, 0)::integer, p.codigo_barras, coalesce(pa.stock_min,0)::integer, coalesce(pa.stock_max,0)::integer, 
			p.grabado, p.stand, p.observacion, p.oferta
		from catalogo.producto as p inner join catalogo.subcategoria as sub on p.subcategoriaid=sub.subcategoriaid 
			inner join catalogo.marca m on p.marcaid=m.marcaid
			inner join catalogo.unidadmedida um on p.unidadmedidaid=um.unidadmedidaid
			left join catalogo.producto_almacen pa on p.productoid=pa.productoid and vAlmacenId=pa.almacenid
			left join tmp_stock s on p.productoid=s.productoid
		where p.estado=true and p.oferta=true
			and case when trim(vnombre)!='' then 
				upper(p.nombre||' '||p.presentacion||' '||m.nombre) like '%' || upper(vtexto) || '%' 
				or trim(p.codigo_barras) like '%'||trim(vnombre)||'%'
				else true end
		order by 2 asc
		limit case when vlimite>0 then vlimite else 20 end;
		
	drop table if exists tmp_stock cascade;
END
$$;


ALTER FUNCTION catalogo.paproducto_enoferta(vempresaid integer, valmacenid integer, vano integer, vnombre character varying, vlimite integer) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_getgravado(integer); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_getgravado(vproductoid integer) RETURNS boolean
    LANGUAGE plpgsql
    AS $$
declare vgravado boolean default false;
BEGIN
	if vproductoid>0 then
		select pro.grabado into vgravado from catalogo.producto pro where pro.productoid=vproductoid;
	end if;
	return coalesce(vgravado, false);
END
$$;


ALTER FUNCTION catalogo.paproducto_getgravado(vproductoid integer) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_getidbynombre(character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_getidbynombre(vnombre character varying) RETURNS integer
    LANGUAGE plpgsql
    AS $$
declare vProductoId integer default 0;
BEGIN
	if trim(vnombre)!='' then
		select pro.productoid into vProductoId from catalogo.producto pro where trim(upper(trim(pro.nombre)||trim(case when trim(pro.presentacion)!='' then pro.presentacion else '' end)))=trim(upper(vnombre));
	end if;
	return coalesce(vProductoId, 0)::integer;
END
$$;


ALTER FUNCTION catalogo.paproducto_getidbynombre(vnombre character varying) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_getnombre(integer); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_getnombre(vproductoid integer) RETURNS character varying
    LANGUAGE plpgsql
    AS $$
declare vnombre varchar default '';
BEGIN
	if vproductoid>0 then
		select (pro.nombre||(case when trim(pro.presentacion)!='' then ', '||trim(pro.presentacion) else '' end)) into vnombre from catalogo.producto pro where pro.productoid=vproductoid;
	end if;
	return trim(coalesce(vnombre, '')::varchar);
END
$$;


ALTER FUNCTION catalogo.paproducto_getnombre(vproductoid integer) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_getrow(integer); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_getrow(vproductoid integer) RETURNS SETOF type_producto_getrow
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select p.productoid, to_char(p.registro, 'DD/MM/YYYY HH12:MI AM')::varchar, p.nombre, p.presentacion, p.moneda, p.precio_com, p.precio_va, p.precio_vb, p.precio_vc, p.precio_vd, 
			p.fraccion, p.fraccion_cantidad, p.fraccion_productoid, p.peso, p.stock_min, p.stock_max, p.flete, p.codigo_barras,
			sub.categoriaid, cat.nombre, p.subcategoriaid, sub.nombre, p.marcaid, m.nombre, p.unidadmedidaid, um.nombre, p.unidadid, uni.nombre, p.grabado, p.stand,
			p.observacion, p.oferta, p.estado, 
			p.lineaid, coalesce(l.nombre,'')::varchar, p.abreviatura, p.codigo_interno, p.codigo_sunat, p.servicio, p.destinado_compra, p.destinado_venta, p.isc, p.isc_porcentaje, p.percepcion, p.percepcion_porcentaje,
			p.sigla, p.backcolor, p.forecolor,
			p.colorid, coalesce(col.nombre,'')::varchar, 
			p.laboratorioid, coalesce(lab.nombre,'')::varchar, 
			p.principio_activo, p.indicaciones, p.registro_sanitario, p.utilidad
		from catalogo.producto as p inner join catalogo.subcategoria as sub on p.subcategoriaid=sub.subcategoriaid 
			inner join catalogo.categoria as cat on sub.categoriaid=cat.categoriaid 
			inner join catalogo.marca m on p.marcaid=m.marcaid
			inner join catalogo.unidadmedida um on p.unidadmedidaid=um.unidadmedidaid 
			inner join catalogo.linea l on p.lineaid=l.lineaid
			inner join catalogo.color col on p.colorid=col.colorid
			inner join catalogo.laboratorio lab on p.laboratorioid=lab.laboratorioid
			inner join catalogo.unidad uni on p.unidadid=uni.unidadid 
		where p.productoid=vproductoid;
END
$$;


ALTER FUNCTION catalogo.paproducto_getrow(vproductoid integer) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_grupo_add(integer, integer[], integer, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_grupo_add(vgrupoid integer, myarr integer[], vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	myRow record;
BEGIN
	for myRow in select myarr[i] as id from generate_series(1, array_upper(myarr, 1)) as i loop
		if not exists(select * from catalogo.producto_grupo pg where pg.grupoid=vgrupoid and pg.productoid=myRow.id) then
			insert into catalogo.producto_grupo values(myRow.id, vgrupoid);
		end if;
	end loop;

	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION catalogo.paproducto_grupo_add(vgrupoid integer, myarr integer[], vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_grupo_add_all(integer, integer, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_grupo_add_all(vgrupoid integer, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	myRow record;
BEGIN
	for myRow in select p.productoid from catalogo.producto p order by 1 loop
		if not exists(select * from catalogo.producto_grupo pg where pg.grupoid=vgrupoid and pg.productoid=myRow.productoid) then
			insert into catalogo.producto_grupo values(myRow.productoid, vgrupoid);
		end if;
	end loop;

	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION catalogo.paproducto_grupo_add_all(vgrupoid integer, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_grupo_delete(integer, integer[], integer, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_grupo_delete(vgrupoid integer, myarr integer[], vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	delete from catalogo.producto_grupo where grupoid=vgrupoid and productoid in (select myarr[i] from generate_series(1, array_upper(myarr, 1)) as i);
	
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION catalogo.paproducto_grupo_delete(vgrupoid integer, myarr integer[], vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_grupo_leer(integer, integer, integer, integer, integer, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_grupo_leer(vgrupoid integer, vlineaid integer, vcategoriaid integer, vsubcategoriaid integer, vmarcaid integer, vnombre character varying) RETURNS SETOF type_producto_grupo_leer
    LANGUAGE plpgsql
    AS $$
declare vnombreaux varchar default '';
BEGIN
	vnombreaux:=replace(vnombre, '+', '%');

	drop table if exists tmp, tmp_stock cascade;
	create temporary table tmp(productoid integer not null);
	create temporary table tmp_stock(productoid integer not null, stock numeric not null);
	
	insert into tmp select pg.productoid from catalogo.producto_grupo pg where pg.grupoid=vgrupoid group by 1;
	insert into tmp_stock select s.productoid, sum(s.stock) from inventarios.stock s group by s.productoid;
		
	return query
		select p.productoid, (p.nombre || case when p.presentacion!='' then (', ' || p.presentacion) else '' end)::varchar,
			p.lineaid, l.nombre, p.marcaid, coalesce(m.nombre,'')::varchar, p.subcategoriaid, coalesce(sc.nombre,'')::varchar, 
			p.precio_va, p.precio_vb, p.precio_vc, p.precio_vd,
			p.precio_com, coalesce(s.stock, 0)::numeric, p.codigo_barras
		from tmp inner join catalogo.producto p on tmp.productoid=p.productoid
			inner join catalogo.subcategoria sc on p.subcategoriaid=sc.subcategoriaid 
			inner join catalogo.marca m on p.marcaid=m.marcaid
			inner join catalogo.linea l on p.lineaid=l.lineaid
			left join tmp_stock s on p.productoid=s.productoid
		where 1=1
			and case when vlineaid>0 then p.lineaid=vlineaid else true end
			and case when vcategoriaid>0 then sc.categoriaid=vcategoriaid else true end
			and case when vsubcategoriaid>0 then p.subcategoriaid=vsubcategoriaid else true end
			and case when vmarcaid>0 then p.marcaid=vmarcaid else true end
			and case when trim(vnombreaux)!='' then 
				--case when not isnumeric(trim(vNombreAux)) then
					(
					upper(p.nombre||' '||p.presentacion||' '||m.nombre) like '%' || upper(vnombreaux) || '%' 
					or upper(p.codigo_barras) like '%' || upper(vnombreaux) || '%' 
					or trim(cast(p.productoid as varchar)) like '%'|| trim(vnombreaux) ||'%'
					)
					--else p.codigo=vnombre::integer end
				else true end
		order by 2;
		
	drop table if exists tmp, tmp_stock cascade;
END
$$;


ALTER FUNCTION catalogo.paproducto_grupo_leer(vgrupoid integer, vlineaid integer, vcategoriaid integer, vsubcategoriaid integer, vmarcaid integer, vnombre character varying) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_grupo_leer_grupos(integer); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_grupo_leer_grupos(vproductoid integer) RETURNS SETOF type_producto_grupo_leer_grupos
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query
		select g.grupoid, g.nombre
		from catalogo.producto_grupo pg inner join catalogo.grupo g on pg.grupoid=g.grupoid 
		where pg.productoid=vproductoid;
END
$$;


ALTER FUNCTION catalogo.paproducto_grupo_leer_grupos(vproductoid integer) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_leer(integer, integer, integer, character varying, integer, integer, integer, integer, integer, integer, character varying, character varying, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_leer(vinicio integer, vfin integer, vano integer, vnombre character varying, vproductoid integer, vlineaid integer, vsubcategoriaid integer, vcategoriaid integer, vmarcaid integer, vunidadmedidaid integer, vstock character varying, vestado character varying, vorderby character varying) RETURNS SETOF type_producto_leer
    LANGUAGE plpgsql
    AS $$
declare vtexto varchar default '';
BEGIN
	vtexto:=replace(trim(vnombre), '+', '%');
	drop table if exists tmp_stock;
	create temporary table tmp_stock(productoid integer not null, stock numeric not null);
	insert into tmp_stock 
		select s.productoid, sum(s.stock) 
		from inventarios.stock s
		group by s.productoid;
		
	return query
		select p.productoid, (p.nombre || case when p.presentacion!='' then (', ' || p.presentacion) else '' end)::varchar as producto,coalesce(sub.subcategoriaid,0)::integer,coalesce(sub.nombre,''), coalesce(p.marcaid, 0)::integer, coalesce(m.nombre, '')::varchar, 
			p.precio_com, p.stand, coalesce(s.stock, 0)::numeric, p.precio_va, p.precio_vb, p.precio_vc, p.precio_vd, 
			p.fraccion_cantidad, p.fraccion_productoid, p.peso, p.stock_min, p.stock_max, p.codigo_barras, p.grabado,
			p.observacion, p.oferta, p.estado
		from catalogo.producto as p left join catalogo.subcategoria as sub on p.subcategoriaid=sub.subcategoriaid
			left join catalogo.categoria as c on sub.categoriaid=c.categoriaid
			left join catalogo.marca m on p.marcaid=m.marcaid
			left join tmp_stock s on p.productoid=s.productoid
		where 1=1 
			and case when trim(vnombre)!='' then 
				upper(p.nombre||' '||p.presentacion||' '||m.nombre) like '%' || upper(vtexto) || '%' 
				or trim(p.codigo_barras) like '%'||trim(vnombre)||'%'
				or trim('STAND '||trim(p.stand)) like ''||trim(vnombre)||''
				else true end
			and case when vproductoid>0 then p.productoid=vproductoid else true end
			and case when vlineaid>0 then p.lineaid=vlineaid else true end
			and case when vsubcategoriaid>0 then sub.subcategoriaid=vsubcategoriaid else true end
			and case when vcategoriaid>0 then c.categoriaid=vcategoriaid else true end
			and case when vmarcaid>0 then p.marcaid=vmarcaid else true end
			and case when vunidadmedidaid>0 then p.unidadmedidaid=vunidadmedidaid else true end
			and case when trim(vstock)='CONSTOCK' then coalesce(s.stock, 0)>0 else true end
			and case when trim(vstock)='SINSTOCK' then coalesce(s.stock, 0)<=0 else true end
			and case when trim(vstock)='STOCKNEGATIVO' then coalesce(s.stock, 0)<0 else true end
			and case when trim(vestado)!='' then p.estado=(trim(vestado)='Y') else true end
		order by  
			case when vorderby='productoid' then p.productoid else 0 end desc, 
			case when vorderby='stock' then coalesce(s.stock, 0) else 0 end desc,
			case when vorderby='precio_com' then p.precio_com else 0 end desc,
			case when vorderby='precio_va' then p.precio_va else 0 end desc,
			case when vorderby='precio_vb' then p.precio_vb else 0 end desc,
			2
		limit case when vinicio=0 and vfin=0 then null else vfin end offset vinicio;
		
	drop table if exists tmp_stock cascade;
END
$$;


ALTER FUNCTION catalogo.paproducto_leer(vinicio integer, vfin integer, vano integer, vnombre character varying, vproductoid integer, vlineaid integer, vsubcategoriaid integer, vcategoriaid integer, vmarcaid integer, vunidadmedidaid integer, vstock character varying, vestado character varying, vorderby character varying) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_leer_nongrupo(integer, integer, integer, integer, integer, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_leer_nongrupo(vgrupoid integer, vlineaid integer, vcategoriaid integer, vsubcategoriaid integer, vmarcaid integer, vnombre character varying) RETURNS SETOF type_producto_leer_nongrupo
    LANGUAGE plpgsql
    AS $$
declare vnombreaux varchar default '';
BEGIN
	vnombreaux:=replace(vnombre, '+', '%');

	drop table if exists tmp_stock cascade;
	create temporary table tmp_stock(productoid integer not null, stock numeric not null);
	
	insert into tmp_stock select s.productoid, sum(s.stock) from inventarios.stock s group by s.productoid;
		
	return query
		select p.productoid, (p.nombre || case when p.presentacion!='' then (', ' || p.presentacion) else '' end)::varchar,
			p.lineaid, l.nombre, p.marcaid, coalesce(m.nombre,'')::varchar, p.subcategoriaid, coalesce(sc.nombre,'')::varchar, 
			p.precio_va, p.precio_vb, p.precio_vc, p.precio_vd,
			p.precio_com, coalesce(s.stock, 0)::numeric, p.codigo_barras
		from catalogo.producto p inner join catalogo.subcategoria sc on p.subcategoriaid=sc.subcategoriaid 
			inner join catalogo.marca m on p.marcaid=m.marcaid
			inner join catalogo.linea l on p.lineaid=l.lineaid
			left join tmp_stock s on p.productoid=s.productoid
			left join catalogo.producto_grupo pg on p.productoid=pg.productoid and vgrupoid=pg.grupoid
		where pg.productoid is null 
			and case when vlineaid>0 then p.lineaid=vlineaid else true end
			and case when vcategoriaid>0 then sc.categoriaid=vcategoriaid else true end
			and case when vsubcategoriaid>0 then p.subcategoriaid=vsubcategoriaid else true end
			and case when vmarcaid>0 then p.marcaid=vmarcaid else true end
			and case when trim(vnombreaux)!='' then 
				--case when not isnumeric(trim(vNombreAux)) then
					(
					upper(p.nombre||' '||p.presentacion||' '||m.nombre) like '%' || upper(vnombreaux) || '%' 
					or upper(p.codigo_barras) like '%' || upper(vnombreaux) || '%' 
					or trim(cast(p.productoid as varchar)) like '%'|| trim(vnombreaux) ||'%'
					)
					--else p.codigo=vnombre::integer end
				else true end
		order by 2;
		
	drop table if exists tmp_stock cascade;
END
$$;


ALTER FUNCTION catalogo.paproducto_leer_nongrupo(vgrupoid integer, vlineaid integer, vcategoriaid integer, vsubcategoriaid integer, vmarcaid integer, vnombre character varying) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_reemplazar(integer, integer, integer, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_reemplazar(vproductoid integer, vproductoidreemplazo integer, vusuarioid integer, vcaja character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $_$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
	myRow record; myRecord record; myRowPriKey record; vIDS text default ''; vReplaceId integer default 0;
	vschema varchar default 'catalogo'; vtabla varchar default 'producto'; vcounttbl integer default 0; vcountreg integer default 0; vcountregaux integer default 0;
BEGIN
	if exists(select det.ingresoid from inventarios.ingreso_detalle det where det.productoid in (vproductoid, vproductoidreemplazo) group by 1 having count(case when det.productoid in (vproductoid, vproductoidreemplazo) then 1 else null end)=2 ) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite reemplazar este producto por que tiene identificadores de INGRESOS DE MERCADERIA similares al producto de reemplazo.';
	end if;
	if vstate then
		if exists(select det.salidaid from inventarios.salida_detalle det where det.productoid in (vproductoid, vproductoidreemplazo) group by 1 having count(case when det.productoid in (vproductoid, vproductoidreemplazo) then 1 else null end)=2 ) then
			vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite reemplazar este producto por que tiene identificadores de SALIDAS DE MERCADERIA similares al producto de reemplazo.';
		end if;
	end if;
	if vstate then
		if exists(select det.ventaid from inventarios.venta_detalle det where det.productoid in (vproductoid, vproductoidreemplazo) group by 1 having count(case when det.productoid in (vproductoid, vproductoidreemplazo) then 1 else null end)=2 ) then
			vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite reemplazar este producto por que tiene identificadores de VENTAS similares al producto de reemplazo.';
		end if;
	end if;
	if vstate then
		--BEGIN RASTRO
		insert into rastro.replace values(default, vusuarioid, current_timestamp, vschema, vtabla, vproductoid, vproductoidreemplazo);
		vReplaceId:=lastval();
		--END RASTRO
		
		for myRecord in select * from public.patablas_relacionadas(vschema, vtabla) loop
			if (myRecord.schema||'.'||myRecord.tabla) not in ('catalogo.producto_almacen', 'catalogo.producto_grupo', 'catalogo.producto_tipooperacion', 'catalogo.producto_tipoprecio', 'inventarios.stock') then

				--BEGIN RASTRO DETAILS
				vIDS:='';
				for myRowPriKey in select * from public.getprimarykeyscolumns((myRecord.schema||'.'||myRecord.tabla)::varchar) loop
					vIDS:=vIDS||myRowPriKey.field||',';
				end loop;
				if trim(vIDS)!='' then
					vIDS:=substring(vIDS for char_length(vIDS)-1);

					execute 'insert into rastro.replacedetails select $1, $2, $3, $4, $5, row('||vIDS||')::text from ' || quote_ident(myRecord.schema) || '.' || quote_ident(myRecord.tabla) || ' where ' || quote_ident(myRecord.campo) || '=' || quote_literal(vproductoid) using vReplaceId, myRecord.schema, myRecord.tabla, myRecord.campo, vIDS;
				end if;
				--END RASTRO DETAILS

				--BEGIN PROCESS
				execute 'update ' || quote_ident(myRecord.schema) || '.' || quote_ident(myRecord.tabla) || ' set ' || quote_ident(myRecord.campo) || '=' || quote_literal(vproductoidreemplazo) || ' where ' || quote_ident(myRecord.campo) || '=' || quote_literal(vproductoid);
				--END PROCESS
			end if;
		end loop;
	end if;
	return query select vState, vID, vError, vDescripcion;
END $_$;


ALTER FUNCTION catalogo.paproducto_reemplazar(vproductoid integer, vproductoidreemplazo integer, vusuarioid integer, vcaja character varying) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_tipo_precio_leer(integer); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_tipo_precio_leer(vproductoid integer) RETURNS SETOF type_producto_tipo_precio_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query
		select tp.tipoprecioid, tp.nombre, ptp.precio_min, ptp.precio_max, ptp.cantidad, ptp.descripcion
		from catalogo.producto_tipoprecio ptp inner join catalogo.tipoprecio tp on ptp.tipoprecioid=tp.tipoprecioid
		where ptp.productoid=vproductoid
		order by tp.cantidad, tp.nombre;
END
$$;


ALTER FUNCTION catalogo.paproducto_tipo_precio_leer(vproductoid integer) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_tipooperacion_leer(integer); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_tipooperacion_leer(vproductoid integer) RETURNS SETOF type_producto_tipooperacion_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select tip.tipooperacionid, tip.nombre, tip.abreviatura, tip.codigo_contable, tip.orden
		from catalogo.producto_tipooperacion protip inner join basic.tipooperacion tip on protip.tipooperacionid=tip.tipooperacionid
		where protip.productoid=vproductoid
		order by tip.orden;
END
$$;


ALTER FUNCTION catalogo.paproducto_tipooperacion_leer(vproductoid integer) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_tipoprecio_leer(integer); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_tipoprecio_leer(vproductoid integer) RETURNS SETOF type_producto_tipoprecio_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query
		select tp.tipoprecioid, tp.nombre, ptp.precio_min, ptp.precio_max, ptp.cantidad, ptp.descripcion
		from catalogo.producto_tipoprecio ptp inner join catalogo.tipoprecio tp on ptp.tipoprecioid=tp.tipoprecioid
		where ptp.productoid=vproductoid
		order by tp.cantidad, tp.nombre;
END
$$;


ALTER FUNCTION catalogo.paproducto_tipoprecio_leer(vproductoid integer) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_tipoprecio_registrar(integer, character varying[]); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_tipoprecio_registrar(vproductoid integer, myarr character varying[]) RETURNS void
    LANGUAGE plpgsql
    AS $$
declare vIndice integer default 0; vFilas integer default 0;
	vCodigoTipPre integer default 0; vPrecioMin numeric default 0; vPrecioMax numeric default 0; vCantidad integer default 0; vDescripcion varchar default 0;
begin
	--array_subfilas[tipoprecioid, precio_min, precio_max]]
	delete from catalogo.producto_tipoprecio where productoid=vproductoid;
	vFilas=array_upper(myArr,1);
	if (not (myArr[1][1] is null)) then
		vIndice:=0;
		if vFilas>0 then
			for vIndice in 1..vFilas loop
				vCodigoTipPre:=myArr[vIndice][1]::integer;
				vPrecioMin:=myArr[vIndice][2]::numeric;
				vPrecioMax:=myArr[vIndice][3]::numeric;
				vCantidad:=myArr[vIndice][4]::numeric;
				vDescripcion:=myArr[vIndice][5]::varchar;
				if vCodigoTipPre>0 and (vPrecioMin>0 or vPrecioMax>0 or trim(vDescripcion)!='')  then
					insert into catalogo.producto_tipoprecio values(vproductoid, vCodigoTipPre, vPrecioMin, vPrecioMax, vCantidad, vDescripcion);
				end if;
			end loop;
		end if;
	end if;
end $$;


ALTER FUNCTION catalogo.paproducto_tipoprecio_registrar(vproductoid integer, myarr character varying[]) OWNER TO radiosan_ustaana;

--
-- Name: paproducto_ultimos_codigos(integer, integer, integer, character varying, integer); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproducto_ultimos_codigos(vempresaid integer, valmacenid integer, vano integer, vnombre character varying, vlimite integer) RETURNS SETOF type_producto_ultimos_codigos
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp_stock cascade;
	create temporary table tmp_stock(productoid integer not null, stock numeric not null);
	insert into tmp_stock 
		select s.productoid, sum(s.stock) 
		from inventarios.stock s
		where 1=1
			and case when vempresaid>0 then s.empresaid=vempresaid else true end
			and case when valmacenid>0 then s.almacenid=valmacenid else true end
		group by s.productoid;
		
	return query
		select p.productoid, (p.nombre || case when p.presentacion!='' then (', ' || p.presentacion) else '' end)::varchar,
			coalesce(um.abreviatura,'')::varchar, coalesce(m.nombre,'')::varchar, coalesce(sub.nombre,'')::varchar, 
			(case when pa.productoid is null then p.precio_va else coalesce(pa.precio_va, 0) end)::numeric, 
			(case when pa.productoid is null then p.precio_vb else coalesce(pa.precio_vb, 0) end)::numeric,
			(case when pa.productoid is null then p.precio_vc else coalesce(pa.precio_vc, 0) end)::numeric,
			(case when pa.productoid is null then p.precio_vd else coalesce(pa.precio_vd, 0) end)::numeric,
			p.precio_com, p.peso, coalesce(s.stock,0)::numeric, 
			coalesce(p.subcategoriaid, 0)::integer, p.codigo_barras, coalesce(pa.stock_min,0)::integer, coalesce(pa.stock_max,0)::integer, 
			p.grabado, p.stand, p.observacion, p.oferta
		from catalogo.producto as p inner join catalogo.subcategoria as sub on p.subcategoriaid=sub.subcategoriaid 
			left join tmp_stock s on p.productoid=s.productoid
			inner join catalogo.marca m on p.marcaid=m.marcaid
			inner join catalogo.unidadmedida um on p.unidadmedidaid=um.unidadmedidaid
			left join catalogo.producto_almacen pa on p.productoid=pa.productoid and valmacenid=pa.almacenid
		where p.estado=true
		order by p.productoid desc
		limit case when vlimite>0 then vlimite else 20 end;
	drop table if exists tmp_stock cascade;
END
$$;


ALTER FUNCTION catalogo.paproducto_ultimos_codigos(vempresaid integer, valmacenid integer, vano integer, vnombre character varying, vlimite integer) OWNER TO radiosan_ustaana;

--
-- Name: paproductos_proveedor_consulta(integer, integer, integer, character varying, integer); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paproductos_proveedor_consulta(valmacenid integer, vano integer, vproveedorid integer, vtexto character varying, vlimite integer) RETURNS SETOF type_productos_proveedor_consulta
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp_stock cascade;
	create temporary table tmp_stock(productoid integer not null, stock numeric not null);
	insert into tmp_stock 
		select s.productoid, sum(s.stock) 
		from inventarios.stock s
		where 1=1
			and case when valmacenid>0 then s.almacenid=valmacenid else true end
		group by s.productoid;

	if vproveedorid>0 then
		return query
			select p.productoid, (p.nombre || case when p.presentacion!='' then (',' || p.presentacion) else '' end)::varchar as producto,p.subcategoriaid,sc.nombre,p.precio_com, p.flete,s.stock,p.precio_va,p.precio_vb, stock_min, stock_max 
			from catalogo.producto as p left join catalogo.subcategoria as sc on p.subcategoriaid=sc.subcategoriaid
				left join tmp_stock s on p.productoid=s.productoid
				left join inventarios.proveedores_producto pp on p.productoid=pp.productoid
			where (upper(buscar(p.nombre)) like'%' || upper(buscar(vTexto)) || '%' or upper(buscar(p.presentacion)) like '%' || upper(buscar(vTexto)) || '%' ) 
				and pp.personaid=vproveedorid
			order by 2;
	else
		return query
			select p.productoid, upper(p.nombre || case when p.presentacion!='' then (',' || p.presentacion) else '' end)::varchar as producto, p.subcategoriaid, sc.nombre, p.precio_com, p.flete,
				coalesce(s.stock,0)::numeric, coalesce(pa.precio_va,0)::numeric, coalesce(pa.precio_vb,0)::numeric, coalesce(pa.stock_min,0)::integer, coalesce(pa.stock_max,0)::integer
			from catalogo.producto as p left join catalogo.subcategoria as sc on p.subcategoriaid=sc.subcategoriaid
				left join tmp_stock s on p.productoid=s.productoid
				left join catalogo.producto_almacen pa on p.productoid=pa.productoid and valmacenid=pa.almacenid
			where (upper(buscar(p.nombre)) like'%' || upper(buscar(vTexto)) || '%' or upper(buscar(p.presentacion)) like '%' || upper(buscar(vTexto)) || '%' ) 
			order by 2;
			
	end if;
	drop table if exists tmp_stock cascade;

END
$$;


ALTER FUNCTION catalogo.paproductos_proveedor_consulta(valmacenid integer, vano integer, vproveedorid integer, vtexto character varying, vlimite integer) OWNER TO radiosan_ustaana;

--
-- Name: pareporte_lista_precios(integer, integer, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION pareporte_lista_precios(vano integer, valmacenid integer, vtipo character varying) RETURNS SETOF type_reporte_lista_precios
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp_stock cascade;
	create temporary table tmp_stock(productoid integer not null, stock integer not null);
	insert into tmp_stock 
		select s.productoid, sum(s.stock) 
		from inventarios.stock s
		where 1=1
			and case when valmacenid>0 then s.almacenid=valmacenid else true end
		group by s.productoid;
		
	return query
		select p.productoid, upper(p.nombre || case when p.presentacion!='' then (',' || p.presentacion) else '' end)::varchar, 
			coalesce(stock,0)::numeric, coalesce(p.precio_com,0)::numeric, coalesce(p.precio_va,0)::numeric, coalesce(p.precio_vb,0)::numeric, coalesce(p.precio_vc,0)::numeric, coalesce(p.precio_vd,0)::numeric, m.nombre
			--coalesce(pa.precio_va,0)::numeric, coalesce(pa.precio_vb,0)::numeric, coalesce(pa.precio_vc,0)::numeric, coalesce(pa.precio_vd,0)::numeric
		from catalogo.producto p inner join catalogo.marca m on p.marcaid=m.marcaid
			left join tmp_stock s on p.productoid=s.productoid 
			left join catalogo.producto_almacen pa on p.productoid=pa.productoid and valmacenid=pa.almacenid
		where 1=1
			and case when vtipo='POSITIVOS' then s.stock>0
				 when vtipo='NEGATIVOS' then s.stock<0
				 when vtipo='SINSTOCK' then s.stock<=0
				 when vtipo='STOCKCERO' then s.stock=0
			         else true 
			    end
		order by 2;
		
	drop table if exists tmp_stock cascade;
END
$$;


ALTER FUNCTION catalogo.pareporte_lista_precios(vano integer, valmacenid integer, vtipo character varying) OWNER TO radiosan_ustaana;

--
-- Name: pareporte_precios(integer, integer); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION pareporte_precios(vzonaid integer, valmacenid integer) RETURNS SETOF type_reporte_precios
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp_stock cascade;
	create temporary table tmp_stock(productoid integer not null, almacenid integer not null, stock integer not null);
	insert into tmp_stock 
		select s.productoid, s.almacenid, sum(s.stock) 
		from inventarios.stock s
		group by 1, 2;

	return query
		select pa.productoid, pa.almacenid, coalesce(s.stock, 0)::numeric, pa.stock_min, pa.stock_max, pa.precio_va, pa.precio_vb, pa.precio_vc, pa.precio_vd
		from catalogo.producto_almacen pa inner join basic.almacen alm on pa.almacenid=alm.almacenid
			left join tmp_stock s on pa.productoid=s.productoid and pa.almacenid=s.almacenid
		order by 1, 2;
	drop table if exists tmp_stock cascade;
END
$$;


ALTER FUNCTION catalogo.pareporte_precios(vzonaid integer, valmacenid integer) OWNER TO radiosan_ustaana;

--
-- Name: pareporte_productos(integer, integer, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION pareporte_productos(vzonaid integer, valmacenid integer, vtipo character varying) RETURNS SETOF type_reporte_productos
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp_stock cascade;
	create temporary table tmp_stock(productoid integer not null, stock integer not null);
	insert into tmp_stock 
		select s.productoid, sum(s.stock) 
		from inventarios.stock s inner join basic.almacen alm on s.almacenid=alm.almacenid
		where 1=1
			and case when vzonaid>0 then alm.zonaid=vzonaid else true end
			and case when valmacenid>0 then s.almacenid=valmacenid else true end
		group by s.productoid;
		
	return query
		select p.productoid, upper(p.nombre || case when p.presentacion!='' then (',' || p.presentacion) else '' end)::varchar, 
			coalesce(stock,0)::numeric, coalesce(p.precio_com,0)::numeric, coalesce(p.precio_va,0)::numeric, coalesce(p.precio_vb,0)::numeric, coalesce(p.precio_vc,0)::numeric, coalesce(p.precio_vd,0)::numeric, 
			p.marcaid, m.nombre, sc.categoriaid, cat.nombre, p.subcategoriaid, sc.nombre, p.laboratorioid, coalesce(lab.nombre,'')::varchar
		from catalogo.producto p inner join catalogo.marca m on p.marcaid=m.marcaid
			inner join catalogo.subcategoria sc on p.subcategoriaid=sc.subcategoriaid
			inner join catalogo.categoria cat on sc.categoriaid=cat.categoriaid
			left join catalogo.laboratorio lab on p.laboratorioid=lab.laboratorioid
			left join tmp_stock s on p.productoid=s.productoid 
		where 1=1
			and case when vtipo='POSITIVOS' then s.stock>0
				 when vtipo='NEGATIVOS' then s.stock<0
				 when vtipo='SINSTOCK' then s.stock<=0
				 when vtipo='STOCKCERO' then s.stock=0
			         else true 
			    end
		order by 2;
		
	drop table if exists tmp_stock cascade;
END
$$;


ALTER FUNCTION catalogo.pareporte_productos(vzonaid integer, valmacenid integer, vtipo character varying) OWNER TO radiosan_ustaana;

--
-- Name: pasubcategoria_actualizar(boolean, integer, integer, character varying, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION pasubcategoria_actualizar(innew boolean, insubcategoriaid integer, incategoriaid integer, innombre character varying, inabreviatura character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from catalogo.subcategoria sc where trim(upper(buscar(sc.nombre)))=trim(upper(buscar(innombre))) and sc.subcategoriaid!=insubcategoriaid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre de la subcategoria ya existe.';
	end if;
	If vState Then
		if inNew then
			insert into catalogo.subcategoria values(default, incategoriaid, trim(innombre), trim(inabreviatura));
			vID:=lastval();
		Else
			update catalogo.subcategoria set categoriaid=incategoriaid, nombre=trim(innombre), abreviatura=trim(inabreviatura) where subcategoriaid=insubcategoriaid;
			vID:=insubcategoriaid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION catalogo.pasubcategoria_actualizar(innew boolean, insubcategoriaid integer, incategoriaid integer, innombre character varying, inabreviatura character varying) OWNER TO radiosan_ustaana;

--
-- Name: pasubcategoria_eliminar(integer, integer, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION pasubcategoria_eliminar(vsubcategoriaid integer, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from catalogo.producto where subcategoriaid=vsubcategoriaid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar la subcategoria por tener productos registrados.';
	end if;
	if vState then
		delete from catalogo.subcategoria where subcategoriaid=vsubcategoriaid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION catalogo.pasubcategoria_eliminar(vsubcategoriaid integer, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: pasubcategoria_getrow(integer); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION pasubcategoria_getrow(vsubcategoriaid integer) RETURNS SETOF type_subcategoria_getrow
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select sc.subcategoriaid, sc.categoriaid, c.nombre, sc.nombre, sc.abreviatura
		from catalogo.subcategoria sc inner join catalogo.categoria c on sc.categoriaid=c.categoriaid
		where sc.subcategoriaid=vsubcategoriaid;
END
$$;


ALTER FUNCTION catalogo.pasubcategoria_getrow(vsubcategoriaid integer) OWNER TO radiosan_ustaana;

--
-- Name: pasubcategoria_leer(character varying, integer); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION pasubcategoria_leer(vnombre character varying, vcategoriaid integer) RETURNS SETOF type_subcategoria_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	drop table if exists tmp cascade;
	create temporary table tmp(subcategoriaid integer not null, count integer not null);
	insert into tmp select p.subcategoriaid, count(*) from catalogo.producto p group by 1;
	return query 
		select sc.subcategoriaid, sc.nombre, sc.abreviatura, sc.categoriaid, c.nombre, coalesce(tmp.count, 0)::integer
		from catalogo.subcategoria sc inner join catalogo.categoria c on sc.categoriaid=c.categoriaid
			left join tmp on sc.subcategoriaid=tmp.subcategoriaid
		where sc.subcategoriaid>0
			and case when trim(vnombre)!='' then upper(buscar(sc.nombre)) like '%'|| upper(buscar(vnombre)) ||'%' else true end
			and case when vcategoriaid>0 then sc.categoriaid=vcategoriaid else true end
		order by sc.nombre;
	drop table if exists tmp cascade;
END
$$;


ALTER FUNCTION catalogo.pasubcategoria_leer(vnombre character varying, vcategoriaid integer) OWNER TO radiosan_ustaana;

--
-- Name: patipoprecio_actualizar(boolean, integer, character varying, integer); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION patipoprecio_actualizar(innew boolean, intipoprecioid integer, innombre character varying, incantidad integer) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from catalogo.tipoprecio t where trim(upper(t.nombre))=trim(upper(innombre)) and t.tipoprecioid!=intipoprecioid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre del tipo de precio ya existe.';
	end if;
	If vState Then
		if inNew then
			insert into catalogo.tipoprecio values(default, trim(innombre), incantidad);
			vID:=lastval();
		Else
			update catalogo.tipoprecio set nombre=trim(innombre), cantidad=incantidad where tipoprecioid=intipoprecioid;
			vID:=intipoprecioid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION catalogo.patipoprecio_actualizar(innew boolean, intipoprecioid integer, innombre character varying, incantidad integer) OWNER TO radiosan_ustaana;

--
-- Name: patipoprecio_eliminar(integer, integer, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION patipoprecio_eliminar(vtipoprecioid integer, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare 
	vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from catalogo.producto_tipoprecio where tipoprecioid=vtipoprecioid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar el tipo por tener subcategorias registradas.';
	end if;
	if vState then
		delete from catalogo.tipoprecio where tipoprecioid=vtipoprecioid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION catalogo.patipoprecio_eliminar(vtipoprecioid integer, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: patipoprecio_leer(character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION patipoprecio_leer(innombre character varying) RETURNS SETOF type_tipoprecio_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select t.tipoprecioid, t.nombre, t.cantidad
		from catalogo.tipoprecio t
		where t.tipoprecioid>0
			and case when trim(innombre)!='' then upper(buscar(t.nombre)) like '%'|| upper(buscar(innombre)) ||'%' else true end
		order by t.cantidad asc, t.nombre;
END
$$;


ALTER FUNCTION catalogo.patipoprecio_leer(innombre character varying) OWNER TO radiosan_ustaana;

--
-- Name: paunidad_actualizar(boolean, integer, character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paunidad_actualizar(innew boolean, inunidadid integer, innombre character varying, inabreviatura character varying, incodigo_contable character varying, incodigo_internacional character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from catalogo.unidad um where trim(upper(buscar(um.nombre)))=trim(upper(buscar(innombre))) and um.unidadid!=inunidadid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre de la unidad de medida ya existe.';
	end if;
	If vState Then
		if inNew then
			insert into catalogo.unidad values(default, trim(innombre), trim(inabreviatura), trim(incodigo_contable), trim(incodigo_internacional));
			vID:=lastval();
		Else
			update catalogo.unidad set nombre=trim(innombre), abreviatura=trim(inabreviatura), codigo_contable=trim(incodigo_contable), codigo_internacional=trim(incodigo_internacional) where unidadid=inunidadid;
			vID:=inunidadid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION catalogo.paunidad_actualizar(innew boolean, inunidadid integer, innombre character varying, inabreviatura character varying, incodigo_contable character varying, incodigo_internacional character varying) OWNER TO radiosan_ustaana;

--
-- Name: paunidad_eliminar(integer, integer, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paunidad_eliminar(vunidadid integer, vusuarioid integer, vip character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare 
	vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from catalogo.producto where unidadid=vunidadid limit 1) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El sistema no permite eliminar la unidad de medida por tener presentaciones registradas.';
	end if;
	if vState=true then
		delete from catalogo.unidad where unidadid=vunidadid;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION catalogo.paunidad_eliminar(vunidadid integer, vusuarioid integer, vip character varying) OWNER TO radiosan_ustaana;

--
-- Name: paunidad_leer(character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paunidad_leer(innombre character varying) RETURNS SETOF type_unidad_leer
    LANGUAGE plpgsql
    AS $$
BEGIN
	return query 
		select um.unidadid, um.nombre, um.abreviatura, um.codigo_contable, um.codigo_internacional
		from catalogo.unidad um
		where um.unidadid>0
			and case when trim(innombre)!='' then upper(buscar(um.nombre)) like '%'|| upper(buscar(innombre)) ||'%' else true end
		order by um.nombre;
END
$$;


ALTER FUNCTION catalogo.paunidad_leer(innombre character varying) OWNER TO radiosan_ustaana;

--
-- Name: paunidadmedida_actualizar(boolean, integer, character varying, character varying, character varying, character varying); Type: FUNCTION; Schema: catalogo; Owner: radiosan_ustaana
--

CREATE FUNCTION paunidadmedida_actualizar(innew boolean, inunidadmedidaid integer, innombre character varying, inabreviatura character varying, incodigo_contable character varying, incodigo_internacional character varying) RETURNS SETOF public.typeresult
    LANGUAGE plpgsql
    AS $$
declare vState boolean default true; vID integer default 0; vError integer default 0; vDescripcion varchar default '';
BEGIN
	if exists(select * from catalogo.unidadmedida um where trim(upper(buscar(um.nombre)))=trim(upper(buscar(innombre))) and um.unidadmedidaid!=inunidadmedidaid) then
		vState:=false; vID:=0; vError:=1; vDescripcion:='El nombre de la unidad de medida ya existe.';
	end if;
	If vState Then
		if inNew then
			insert into catalogo.unidadmedida values(default, trim(innombre), trim(inabreviatura), trim(incodigo_contable), trim(incodigo_internacional));
			vID:=lastval();
		Else
			update catalogo.unidadmedida set nombre=trim(innombre), abreviatura=trim(inabreviatura), codigo_contable=trim(incodigo_contable), codigo_internacional=trim(incodigo_internacional) where unidadmedidaid=inunidadmedidaid;
			vID:=inunidadmedidaid;
		end if;
	end if;
	return query select vState, vID, vError, vDescripcion;
END
$$;


ALTER FUNCTION catalogo.paunidadmedida_actualizar(innew boolean, inunidadmedidaid integer, innombre character varying, inabreviatura character varying, incodigo_contable character varying, incodigo_internacional character varying) OWNER TO radiosan_ustaa