call spQuery_Vendedor('', '', '','1', null, null);

DROP PROCEDURE IF EXISTS spQuery_Vendedor;
CREATE PROCEDURE spQuery_Vendedor(
	varCodigo   int,
	varNombre   varchar(80),
	varDirecc   varchar(80),
  varTipo     int,
  varField    varchar(60),
  varOrder    varchar(5)
)
BEGIN
  DECLARE varCadCod, varCadNom, varCadDir, varCadTip TEXT DEFAULT '';
  DECLARE varCadOrd TEXT DEFAULT '';
	if varCodigo <> '' and varCodigo is not null then
    set varCadCod = CONCAT(" and C.id_vendedor = ", varCodigo," ");
  end if;
	if varNombre <> '' and varNombre is not null then
    set varCadNom = CONCAT(" and C.nombre like '%", varNombre,"%' ");
  end if;
  if varDirecc <> '' and varDirecc is not null then
    set varCadDir = CONCAT(" and C.direccion = ", varDirecc," ");
  end if;
  if varTipo <> '' and varTipo is not null then
    set varCadTip = CONCAT(" and C.id_tipo_vendedor = ", varTipo," ");
  end if;
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'M._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'M._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  END IF;
  
  SET @sql = CONCAT("select C.id_vendedor AS CVEN, C.nombre AS VENDEDOR, ",
                    "C.id_tipo_vendedor as CTIP, T.nombre as TIPO, ",
                    "C.DNI, C.DIRECCION, C.SUELDO, C.COMISION, C.TELEFONO, C.CELULAR, C.RPM, C.RPC, C.NEXTEL, ",
                    "CASE WHEN estado='A' then 'ACTIVO' else 'INACTIVO' END AS ESTADO, ",
                    "date_format(C._date_create,'%d/%m/%Y %h:%i:%s %p') AS FECHA_CREADO, ",
                    "date_format(C._date_update,'%d/%m/%Y %h:%i:%s %p') AS FECHA_MODIFI, ",
                    "UPPER(UN.usuario) as USER_CREADO, ",
                    "UPPER(UU.usuario) as USER_MODIFI ",
                    "from _sv_vendedor C ",
                    "inner join _sv_tipo_vendedor T ON C.id_tipo_vendedor = T.id_tipo_vendedor ",
                    "inner join _sys_usuario UN ON C._user_create = UN.id_usuario ",
                    "inner join _sys_usuario UU ON C._user_update = UU.id_usuario ",
                    "where C._estado='A' ",
                    "and C.id_vendedor <> 0 ",
                    varCadCod, varCadNom, varCadDir, varCadTip,
                    varCadOrd);
                      
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;