call spQuery_Tipo_Cliente(NULL,'','FECHA_CREADO',NULL);

DROP PROCEDURE IF EXISTS spQuery_Tipo_Cliente;
CREATE PROCEDURE spQuery_Tipo_Cliente(
  varCodigo int,
	varNombre varchar(60),
  varField  varchar(60),
  varOrder  varchar(5)
  )
BEGIN
  DECLARE varCadCod, varCadNom  text default '';
  DECLARE varCadOrd TEXT DEFAULT '';
  
  if varCodigo is not null or varCodigo <> '' then
    set varCadCod = CONCAT(" and M.id_tipo_cliente = ", varCodigo, " ");
  end if;
  if varNombre is not null or varNombre <> '' then
    set varCadNom = CONCAT(" and M.nombre LIKE '%", varNombre, "%' ");
  end if;
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'M._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'M._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  END IF;
  
	set @sql = CONCAT("select M.id_tipo_cliente AS CMAT, M.nombre AS tipo_cliente, ",
                    "date_format(M._date_create,'%d/%m/%Y %h:%i:%s %p') AS FECHA_CREADO, ",
                    "date_format(M._date_update,'%d/%m/%Y %h:%i:%s %p') AS FECHA_MODIFI, ",
                    "UPPER(UN.usuario) as USER_CREADO, ",
                    "UPPER(UU.usuario) as USER_MODIFI ",
                    "from _sv_tipo_cliente M ",
                    "left join _sys_usuario UN ON M._user_create = UN.id_usuario ",
                    "left join _sys_usuario UU ON M._user_update = UU.id_usuario ",
                    "where M._estado='A' and M.id_tipo_cliente <> 0 ",
	                  varCadCod, varCadNom,
                    varCadOrd);		
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;