call spQuery_Serie_Punto_Venta(NULL,NULL,1,'FECHA_CREADO',NULL);

DROP PROCEDURE IF EXISTS spQuery_Serie_Punto_Venta;
CREATE PROCEDURE spQuery_Serie_Punto_Venta(
  varEmpresa  int,
	varTipoDoc  int,
  varUsuario  int,
  varField    varchar(60),
  varOrder    varchar(5)
  )
BEGIN
  DECLARE varCadEmp, varCadTip  text default '';
  DECLARE varCadOrd TEXT DEFAULT '';
  
  if varEmpresa is not null or varEmpresa <> '' then
    set varCadEmp = CONCAT(" and S.id_empresa = ", varEmpresa, " ");
  end if;
  if varTipoDoc is not null or varTipoDoc <> '' then
    set varCadTip = CONCAT(" and S.id_tipo_doc = ", varTipoDoc, " ");
  end if;
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'S._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'S._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  END IF;
  
	set @sql = CONCAT("select S.id_serie as IDE, S.id_empresa as CEMP, E.nombre as EMPRESA, ",
                    "S.id_punto_venta AS CPDV, P.nombre AS PUNTOVENTA, ",
                    "S.id_tipo_doc AS CTIP, T.nombre AS TIPODOC, ",
                    "S.nro_serie AS SERIE, S.nro_secuencia AS CORRELATIVO, ",
                    "date_format(S._date_create,'%d/%m/%Y %h:%i:%s %p') AS FECHA_CREADO, ",
                    "date_format(S._date_update,'%d/%m/%Y %h:%i:%s %p') AS FECHA_MODIFI, ",
                    "UPPER(UN.usuario) as USER_CREADO, ",
                    "UPPER(UU.usuario) as USER_MODIFI ",
                    "from _sv_serie_punto_venta S ",
                    "inner join _sv_empresa E ON S.id_empresa = E.id_empresa ",
                    "inner join _sv_punto_venta P ON S.id_punto_venta = P.id_punto_venta ",
                    "inner join _sv_tipo_doc_venta T ON S.id_tipo_doc = T.id_tipo_doc ",
                    "left join _sys_usuario UN on S._user_create = UN.id_usuario ",
                    "left join _sys_usuario UU on S._user_update = UU.id_usuario ",
                    "where S._estado = 'A' AND E._estado = 'A' ",
                    "AND P._estado = 'A' AND T._estado = 'A' ",
                    "AND P.id_agencia IN (select id_agencia from _sys_usuario_agencia U where U.id_usuario=", varUsuario, " and U.id_agencia = P.id_agencia) ",
                    varCadEmp, varCadTip,
                    varCadOrd);		
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;


select S.id_serie as IDE, S.id_empresa as CEMP, E.nombre as EMPRESA,
S.id_punto_venta AS CPDV, P.nombre AS PUNTOVENTA,
S.id_tipo_doc AS CTIP, T.nombre AS TIPODOC,
S.nro_serie AS SERIE, S.nro_secuencia AS CORRELATIVO
from _sv_serie_punto_venta S
inner join _sv_empresa E ON S.id_empresa = E.id_empresa
inner join _sv_punto_venta P ON S.id_punto_venta = P.id_punto_venta
inner join _sv_tipo_doc_venta T ON S.id_tipo_doc = T.id_tipo_doc
where S._estado = 'A' AND E._estado = 'A'
AND P._estado = 'A' AND T._estado = 'A'
AND P.id_agencia IN (select id_agencia from _sys_usuario_agencia U where U.id_usuario=1 and U.id_agencia = P.id_agencia)