call spQuery_Report_AnalComp_Proveedor(1, 1, '2011', 'I');

DROP PROCEDURE IF EXISTS spQuery_Report_AnalComp_Proveedor;
CREATE PROCEDURE spQuery_Report_AnalComp_Proveedor(
  varEmpresa  int,
  varVendedor int,
	varAnio     varchar(4),
	varTipo     char(1)
)
BEGIN
  DECLARE varSQLCab, varCadVen  TEXT DEFAULT '';
  
  if varVendedor is not null then
    set varCadVen = CONCAT(" and V.id_trabajador = ", varVendedor, " ");
  end if;
  if varTipo = 'V' then
    set varSQLCab = CONCAT("sum(case when month(V.fecha_emision)=1  then D.subtotal end) as VEN_ENE, ",
                           "sum(case when month(V.fecha_emision)=2  then D.subtotal end) as VEN_FEB, ",
                           "sum(case when month(V.fecha_emision)=3  then D.subtotal end) as VEN_MAR, ",
                           "sum(case when month(V.fecha_emision)=4  then D.subtotal end) as VEN_ABR, ",
                           "sum(case when month(V.fecha_emision)=5  then D.subtotal end) as VEN_MAY, ",
                           "sum(case when month(V.fecha_emision)=6  then D.subtotal end) as VEN_JUN, ",
                           "sum(case when month(V.fecha_emision)=7  then D.subtotal end) as VEN_JUL, ",
                           "sum(case when month(V.fecha_emision)=8  then D.subtotal end) as VEN_AGO, ",
                           "sum(case when month(V.fecha_emision)=9  then D.subtotal end) as VEN_SET, ",
                           "sum(case when month(V.fecha_emision)=10 then D.subtotal end) as VEN_OCT, ",
                           "sum(case when month(V.fecha_emision)=11 then D.subtotal end) as VEN_NOV, ",
                           "sum(case when month(V.fecha_emision)=12 then D.subtotal end) as VEN_DIC  ");
  elseif varTipo = 'I' then
    set varSQLCab = CONCAT("sum(case when month(V.fecha_emision)=1  then D.igv end) as IGV_ENE, ",
                           "sum(case when month(V.fecha_emision)=2  then D.igv end) as IGV_FEB, ",
                           "sum(case when month(V.fecha_emision)=3  then D.igv end) as IGV_MAR, ",
                           "sum(case when month(V.fecha_emision)=4  then D.igv end) as IGV_ABR, ",
                           "sum(case when month(V.fecha_emision)=5  then D.igv end) as IGV_MAY, ",
                           "sum(case when month(V.fecha_emision)=6  then D.igv end) as IGV_JUN, ",
                           "sum(case when month(V.fecha_emision)=7  then D.igv end) as IGV_JUL, ",
                           "sum(case when month(V.fecha_emision)=8  then D.igv end) as IGV_AGO, ",
                           "sum(case when month(V.fecha_emision)=9  then D.igv end) as IGV_SET, ",
                           "sum(case when month(V.fecha_emision)=10 then D.igv end) as IGV_OCT, ",
                           "sum(case when month(V.fecha_emision)=11 then D.igv end) as IGV_NOV, ",
                           "sum(case when month(V.fecha_emision)=12 then D.igv end) as IGV_DIC  ");
  elseif varTipo = 'T' then
    set varSQLCab = CONCAT("sum(case when month(V.fecha_emision)=1  then D.total end) as TOT_ENE, ",
                           "sum(case when month(V.fecha_emision)=2  then D.total end) as TOT_FEB, ",
                           "sum(case when month(V.fecha_emision)=3  then D.total end) as TOT_MAR, ",
                           "sum(case when month(V.fecha_emision)=4  then D.total end) as TOT_ABR, ",
                           "sum(case when month(V.fecha_emision)=5  then D.total end) as TOT_MAY, ",
                           "sum(case when month(V.fecha_emision)=6  then D.total end) as TOT_JUN, ",
                           "sum(case when month(V.fecha_emision)=7  then D.total end) as TOT_JUL, ",
                           "sum(case when month(V.fecha_emision)=8  then D.total end) as TOT_AGO, ",
                           "sum(case when month(V.fecha_emision)=9  then D.total end) as TOT_SET, ",
                           "sum(case when month(V.fecha_emision)=10 then D.total end) as TOT_OCT, ",
                           "sum(case when month(V.fecha_emision)=11 then D.total end) as TOT_NOV, ",
                           "sum(case when month(V.fecha_emision)=12 then D.total end) as TOT_DIC  ");
  end if;
  
  SET @sql = CONCAT("select V.id_empresa as CEMP, E.nombre as EMPRESA, ",
                    "P.id_proveedor as CPRO, L.nombre as PROVEEDOR, ",
                    varSQLCab,
                    "from _sv_venta_detalle D ",
                    "inner join _sv_venta V     ON D.id_venta = V.id_venta ",
                    "inner join _sv_empresa E ON V.id_empresa = E.id_empresa ",
                    "inner join _sv_producto P  ON D.id_producto = P.id_producto ",
                    "inner join _sv_proveedor L ON P.id_proveedor = L.id_proveedor ",
                    "where V._estado = 'A' ",
                    "and V.estado   <> 'AN' ",
                    varCadVen,
                    "and V.id_empresa = ", varEmpresa, " ",
                    "and YEAR(V.fecha_emision) = '", varAnio, "' ",
                    "GROUP BY V.id_empresa, E.nombre, P.id_proveedor, L.nombre"); 
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1; 
END;