call spQuery_Proveedor('', '', '');

DROP PROCEDURE IF EXISTS spQuery_Proveedor;
CREATE PROCEDURE spQuery_Proveedor(
	varCodigo   varchar(10),
	varNombre   varchar(80),
	varDirecc   varchar(80),
  varField    varchar(60),
  varOrder    varchar(5)
)
BEGIN
  DECLARE varCadCod, varCadNom, varCadDir TEXT default '';
  DECLARE varCadOrd TEXT DEFAULT '';
  
  if varCodigo <> '' and varCodigo is not NULL then
    set varCadCod = CONCAT(" and C.id_proveedor = ", varCodigo, " ");
  end if;
  if varNombre <> '' and varNombre is not NULL then
    set varCadNom = CONCAT(" and C.nombre  like  '%", varNombre, "%' ");
  end if;
  if varDirecc <> '' and varDirecc is not NULL then
    set varCadDir = CONCAT(" and C.direccion like '%", varDirecc, "%' ");
  end if;
  
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'M._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'M._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  END IF;
  
  SET @sql = CONCAT("select C.id_proveedor as CPRO, ",
                    "C.id_tipo_proveedor as CTIP, T.nombre as TIPO, ",
                    "C.nombre AS PROVEEDOR, C.RUC, C.DIRECCION, ",
                    "C.CONTACTO, C.TELEFONO, C.CELULAR, C.RPM, C.RPC, C.NEXTEL, C.CORREO,  ",
                    "CASE WHEN estado='A' then 'ACTIVO' else 'INACTIVO' END AS ESTADO, ",
                    "date_format(C._date_create,'%d/%m/%Y %h:%i:%s %p') AS FECHA_CREADO, ",
                    "date_format(C._date_update,'%d/%m/%Y %h:%i:%s %p') AS FECHA_MODIFI, ",
                    "UPPER(UC.usuario) as USER_CREADO, ",
                    "UPPER(UU.usuario) as USER_MODIFI ",
                    "from _sv_proveedor C ",
                    "inner join _sv_tipo_proveedor T on C.id_tipo_proveedor = T.id_tipo_proveedor ",
                    "left join _sys_usuario UC ON C._user_create = UC.id_usuario ",
                    "left join _sys_usuario UU ON C._user_update = UU.id_usuario ",
                    "where C._estado = 'A' ",
                    varCadCod, varCadNom, varCadDir,
                    varCadOrd); 
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1; 
END;