call spQuery_Packing_Documentos_Liquidados(1, '2011-11-01',NULL,NULL);

DROP PROCEDURE IF EXISTS spQuery_Packing_Documentos_Liquidados;
CREATE PROCEDURE spQuery_Packing_Documentos_Liquidados(
  varEmpresa  int,
  varFecha    date,
  varVendedor text,
  varRuta     text
  )
BEGIN
  DECLARE varCadVen, varCadRut TEXT DEFAULT '';
  
	if varVendedor <> '' and varVendedor is not null then
    set varCadVen = CONCAT(" and V.id_trabajador in ", varVendedor," ");
  end if;
  
  if varRuta <> '' and varRuta is not null then
    set varCadRut = CONCAT(" and V.id_ruta in ", varRuta," ");
  end if;
  
  SET @sql = CONCAT("select V.id_trabajador as CVEN, concat(P.apellido_paterno, ' ', P.apellido_materno, ' ', P.nombre) as VENDEDOR, ",
                    "V.id_cliente as CCLI, C.nombre as CLIENTE, C.DIRECCION, ",
                    "V.id_ruta AS CRUT, R.nombre as RUTA, ",
                    "T.abrev as CTIP, concat(V.nro_serie, '-', V.nro_preimpreso) AS NDOC,  ",
                    "LPAD(V.nro_pedido,6,'0') AS PEDIDO, ",
                    "V.id_condicion as CCON, CP.nombre as CONDICION, ",
                    "case when V.id_motivo_rechazo <> 0 then V.id_motivo_rechazo end as CMOT, ", 
                    "case when V.id_motivo_rechazo <> 0 then M.nombre end as MOTIVO, ",
                    "sum(round(D.cantidad_ate*D.precio,2)) as TOTAL_GRAL, ",
                    "sum(case when V.id_condicion = 1 AND V.estado <> 'AN' then D.total end) as CONTADO, ",
                    "sum(case when V.id_condicion = 2 AND V.estado <> 'AN' then D.total end) as CREDITO, ",
                    "sum(case when V.id_condicion = 1 AND V.estado <> 'AN' AND V.id_motivo_rechazo <> 0 ",
                    "         then round(D.cantidad_ate*D.precio,2) - D.total end) as PARCIAL, ",
                    "sum(case when V.id_condicion = 1 AND V.estado =  'AN' then round(D.cantidad_ate*D.precio,2) end) as RECHAZO ",
                    "from _sv_venta_detalle D ",
                    "inner join _sv_venta V     ON D.id_venta = V.id_venta ",
                    "inner join _sv_trabajador P  ON V.id_trabajador = P.id_trabajador ",
                    "inner join _sv_cliente C   ON V.id_cliente = C.id_cliente ",
                    "inner join _sv_ruta R      ON V.id_ruta = R.id_ruta ",
                    "inner join _sv_tipo_condicion CP ON V.id_condicion = CP.id_condicion ",
                    "inner join _sv_tipo_doc_venta T   ON V.id_tipo_doc = T.id_tipo_doc ",
                    "inner join _sv_motivo_rechazo M  ON V.id_motivo_rechazo = M.id_motivo_rechazo ",
                    "where V.fecha_emision = '", varFecha, "' ",
                    "and V._estado = 'A' ",
                    "AND D._estado = 'A' ",
                    "AND V.id_empresa = ", varEmpresa, " ",
                    "and (V.estado <> 'AN' OR V.id_motivo_rechazo <> 0) ",
                    varCadVen, varCadRut,
                    "GROUP BY V.id_trabajador, concat(P.apellido_paterno, ' ', P.apellido_materno, ' ', P.nombre), V.id_cliente, C.nombre, C.DIRECCION, V.id_ruta, R.nombre, ",
                    "V.id_tipo_doc, concat(V.nro_serie, '-', V.nro_preimpreso), LPAD(V.nro_pedido,6,'0'), ",
                    "V.id_condicion, CP.nombre,  ",
                    "case when V.id_motivo_rechazo <> 0 then V.id_motivo_rechazo end,  ",
                    "case when V.id_motivo_rechazo <> 0 then M.nombre end ",
                    "ORDER BY concat(P.apellido_paterno, ' ', P.apellido_materno, ' ', P.nombre), R.nombre, V.id_tipo_doc, concat(V.nro_serie, '-', V.nro_preimpreso);");
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;