CALL spQuery_Movimientos(1, 1,'000112','2012-09-01','2012-09-28');

DROP PROCEDURE IF EXISTS spQuery_Movimientos;
CREATE PROCEDURE spQuery_Movimientos(	
  varEmpresa  int,
  varAlmacen  int,
	varProducto varchar(6),
  varFechaIni date,
  varFechafin date
)
BEGIN
  set varProducto = lpad(varProducto,6,'0');
  SELECT M.IDE, date_format(M.FECHA,'%d/%m/%Y')  AS FMOV, M.CMOV, M.MOVIMIENTO, M.TIPO, M.CPRO, M.PRODUCTO,
  CASE WHEN M.CVEN IS NULL THEN M.CCOM ELSE M.CVEN END AS CREF,
  CASE WHEN M.CVEN IS NULL THEN C.EMISION ELSE V.EMISION END AS FEMI,
  CASE WHEN M.CVEN IS NULL THEN C.CTIP ELSE V.CTIP END AS CTIPD,
  CASE WHEN M.CVEN IS NULL THEN C.TIPO_DOC ELSE V.TIPO_DOC END AS TIPO_DOC,
  CASE WHEN M.CVEN IS NULL THEN C.NDOC ELSE V.NDOC END AS NDOC,
  CASE WHEN M.CVEN IS NULL THEN LPAD(C.CANE,5,'0') ELSE LPAD(V.CANE,5,'0') END AS CANE,
  CASE WHEN M.CVEN IS NULL THEN C.ANEXO ELSE V.ANEXO END AS ANEXO,
  M.INGRESO, M.SALIDA, USUARIO,
  CASE WHEN M.TIPO = 'SAL' THEN V.CPER END AS CPER,
  CASE WHEN M.TIPO = 'SAL' THEN V.PERSONAL END AS PERSONAL
  from
    (
    select distinct M.id_mov_almacen as IDE,
    M.FECHA,
    M.id_movimiento as CMOV, T.descripcion as MOVIMIENTO, T.TIPO,
    M.id_producto as CPRO, P.descripcion as PRODUCTO, 
    CASE WHEN T.tipo='ING' THEN M.CANTIDAD END AS INGRESO,
    CASE WHEN T.tipo='SAL' THEN M.CANTIDAD END AS SALIDA,
    CASE WHEN T.tipo='ING' AND M.id_movimiento = '101' THEN M.id_referencia END AS CCOM,
    CASE WHEN T.tipo='SAL' 
         THEN M.id_referencia 
         ELSE CASE WHEN T.tipo='ING' AND M.id_movimiento = '102' 
                   THEN M.id_referencia 
              END 
    END AS CVEN,
    UPPER(U.usuario) as USUARIO
    from _sv_movimiento_almacen M
    inner join _sys_tipo_movimiento T ON M.id_movimiento = T.id_movimiento
    inner join _sv_producto P ON M.id_producto = P.id_producto
    inner join _sys_usuario U ON M._user_create = U.id_usuario
    where M._estado   = 'A'
    and M.id_empresa  = varEmpresa
    and M.id_almacen  = varAlmacen
    and M.id_producto = varProducto
    and M.fecha >= varFechaIni
    and M.fecha <= varFechaFin
    ) M
  left join
    (
    select distinct V.id_venta as CVEN, date_format(V.fecha_emision,'%d/%m/%Y') AS EMISION,
    V.id_tipo_doc as CTIP, T.nombre AS TIPO_DOC, CONCAT(V.nro_serie,'-',V.nro_preimpreso) as NDOC,
    V.id_cliente CANE, UPPER(C.nombre) as ANEXO,
    V.id_trabajador as CPER, CONCAT(Ve.nombre,' ',Ve.apellido_paterno,' ',Ve.apellido_materno) as PERSONAL
    from _sv_venta_detalle D
    inner join _sv_venta V ON D.id_venta = V.id_venta
    inner join _sv_tipo_doc_venta T ON V.id_tipo_doc = T.id_tipo_doc
    inner join _sv_cliente C ON V.id_cliente = C.id_cliente
    inner join _sv_trabajador Ve ON V.id_trabajador = Ve.id_trabajador
    where V._estado = 'A'
    and V.id_empresa     = varEmpresa
    and D.id_producto    = varProducto
    and V.fecha_emision >= varFechaIni
    and V.fecha_emision <= varFechaFin
    ) V
  ON M.CVEN = V.CVEN
  left join
    (
    select V.id_compra as CCOM, date_format(V.fecha_emision,'%d/%m/%Y') AS EMISION,
    V.id_tipo_doc as CTIP, T.nombre AS TIPO_DOC, V.nro_documento as NDOC,
    V.id_proveedor CANE, UPPER(P.nombre) as ANEXO
    from _sv_compra_detalle D
    inner join _sv_compra V ON D.id_compra = V.id_compra
    inner join _sv_tipo_doc_compra T ON V.id_tipo_doc = T.id_tipo_doc
    inner join _sv_proveedor P ON V.id_proveedor = P.id_proveedor  
    where V._estado = 'A'
    and V.estado <> 'AN'
    and V.id_empresa     = varEmpresa
    and D.id_producto    = varProducto
    and V.fecha_emision >= varFechaIni
    and V.fecha_emision <= varFechaFin
    ) C
  ON M.CCOM = C.CCOM
  order by M.FECHA ASC, M.IDE ASC;
 END;