call spQuery_Matriz_Trabajador(NULL,NULL,NULL,201304,'FECHA_CREADO',NULL);
call spQuery_Matriz_Trabajador(NULL, NULL, NULL, 201304, NULL, NULL);

DROP PROCEDURE IF EXISTS spQuery_Matriz_Trabajador;
CREATE PROCEDURE spQuery_Matriz_Trabajador(
  varCodigo   int,
	varNombre   varchar(80),
  varArea     int,
  varPeriodo  int,
  varField    varchar(60),
  varOrder    varchar(5)
  )
BEGIN
  DECLARE varCadCod, varCadNom, varCadAre, varCadPer  text default '';
  DECLARE varCadOrd TEXT DEFAULT '';
  
  if varCodigo is not null or varCodigo <> '' then
    set varCadCod = CONCAT(" and MT.id_trabajador = ", varCodigo, " ");
  end if;
  if ifnull(varNombre,'') <> '' then
    set varCadNom = CONCAT(" and CONCAT(T.apellido_paterno, ' ', T.apellido_materno, ' ', T.nombre) LIKE '%", varNombre, "%' ");
  end if;
  if varArea is not null or varArea <> '' then
    set varCadAre = CONCAT(" and M.id_area = ", varArea, " ");
  end if;
  if varPeriodo is not null or varPeriodo <> '' then
    set varCadPer = CONCAT(" and MT.id_periodo_pago = ", varPeriodo, " ");
  end if;
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'A._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'A._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  END IF;
  
	set @sql = CONCAT("select MT.id_trabajador as CTRA, "
                    "CONCAT(T.apellido_paterno, ' ', T.apellido_materno, ' ', T.nombre) as TRABAJADOR, "
                    "MT.id_matriz as CMAT, M.nombre as MATRIZ, MT.BASE, "
                    "MT.id_periodo_pago as CPER, P.nombre as PERIODO, "
                    "MT.id_empresa as CEMP, E.nombre as EMPRESA, "
                    "MT.id_agencia as CAGE, A.nombre as AGENCIA, "
                    "M.id_area as CARE, R.nombre as AREA, ",
                    "MT.id_cargo as CCAR, C.nombre as CARGO, ",
                    "date_format(MT._date_create,'%d/%m/%Y %h:%i:%s %p') AS FECHA_CREADO, ",
                    "date_format(MT._date_update,'%d/%m/%Y %h:%i:%s %p') AS FECHA_MODIFI, ",
                    "UPPER(UN.usuario) as USER_CREADO, ",
                    "UPPER(UU.usuario) as USER_MODIFI ",
                    "from _sind_matriz_trabajador MT ",
                    "inner join _sv_trabajador T    ON MT.id_trabajador = T.id_trabajador ",
                    "inner join _sind_matriz M      ON MT.id_matriz = M.id_matriz ",
                    "inner join _srh_area R         ON M.id_area = R.id_area ",
                    "inner join _srh_periodo_pago P ON MT.id_periodo_pago = P.id_periodo_pago ",
                    "left join _sv_empresa E        ON MT.id_empresa = E.id_empresa ",
                    "left join _srh_agencia A       ON MT.id_agencia = A.id_agencia ",
                    "left join _srh_cargo C         ON MT.id_cargo = C.id_cargo ",
                    "left join _sys_usuario UN ON MT._user_create = UN.id_usuario ",
                    "left join _sys_usuario UU ON MT._user_update = UU.id_usuario ",
                    "where MT._estado='A' ",
	                  varCadCod, varCadNom, varCadAre, varCadPer,
                    varCadOrd);	
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;


SELECT distinct MT.id_trabajador, MT.id_matriz, MT.id_periodo_pago, TE.id_empresa, TE.id_agencia, TE.id_cargo, TE.id_estado_trabajador
FROM _sind_matriz_trabajador MT
left join _srh_trabajador_empresa TE on MT.id_trabajador = TE.id_trabajador
where MT.id_periodo_pago = 201304;