call spQuery_Matriz_IP_Estructura_Logro(40767740, 12, 201303);

DROP PROCEDURE IF EXISTS spQuery_Matriz_IP_Estructura_Logro;
CREATE PROCEDURE spQuery_Matriz_IP_Estructura_Logro(
  varTrabajador int,
  varMatriz     int,
  varPeriodo    int
  )
BEGIN
  select M.CIND, M.INDICADOR, M.CONDICION, M.PORCENTAJE, M.MONTO, M.NIVEL, M.ARBOL, M.TIPONODO, M.PADRE,
  L.META, L.VALOR, L.LOGRO
  from
    (
    select MP.id_indicador as CIND, I.nombre AS INDICADOR, 
    case when MP.id_condicion = 0 
        then CAST(CONCAT(C.nombre, ' [', C.simbolo, ']') AS CHAR)
        else CAST(CONCAT('[', C.simbolo, ']', MP.valcond) AS CHAR)
    end as CONDICION, 
    MP.PORCENTAJE, MP.MONTO, MP.NIVEL, MP.ARBOL, MP.TIPONODO, MP.PADRE
    from _sind_matriz_periodo MP
    inner join _sind_indicador I ON MP.id_indicador = I.id_indicador
    inner join _sind_condicion C ON MP.id_condicion = C.id_condicion
    where MP.id_matriz     = varMatriz
    and MP.id_periodo_pago = varPeriodo
    ) M
  left join
    (
    select ML.id_indicador as CIND, ROUND(ML.META,2) AS META, ROUND(ML.VALOR,2) AS VALOR, ROUND(ML.LOGRO,2) AS LOGRO
    from _sind_logro ML
    where ML.id_periodo_pago = varPeriodo
    and ML.id_trabajador     = varTrabajador
    ) L
  ON M.CIND = L.CIND
  ORDER BY M.ARBOL;
END;