call spQuery_Lista_Trabajador('VEN',41768484,NULL,NULL);

DROP PROCEDURE IF EXISTS spQuery_Lista_Trabajador;
CREATE PROCEDURE spQuery_Lista_Trabajador(
  varTipo       char(3),
	varCodigo     int,
  varNombre     varchar(50),
  varDireccion  varchar(50)
)
BEGIN 
  DECLARE varCadCod, varCadNom, varCadDir, varCadTip TEXT default '';
  
  if varCodigo is not null then
    set varCadCod = CONCAT(" and T.id_trabajador = ", varCodigo, " ");
  end if;
  if varNombre is not null and varNombre <> '' then
    set varNombre = CONCAT(" and concat(ifnull(T.apellido_paterno,''), ' ', ifnull(T.apellido_materno,''), ' ', ifnull(T.nombre,'')) LIKE '%", varNombre, "%' ");
  end if;
  if varDireccion is not null and varDireccion <> '' then
    set varCadDir = CONCAT(" and T.direccion LIKE '%", varDireccion, "%' ");
  end if;
  
  if varTipo is not null and varTipo <> '' then
    set varCadTip = CONCAT(" and TL.id_tipo_trabajador = '", varTipo, "' ");
    set @sql = CONCAT("select TL.id_trabajador as CTRA, ",
                      "concat(ifnull(T.apellido_paterno,''), ' ', ifnull(T.apellido_materno,''), ' ', ifnull(T.nombre,'')) as TRABAJADOR, ",
                      "T.DIRECCION, case when T.estado='A' then 'ACTIVO' else 'INACTIVO' end as ESTADO ",
                      "from _sv_trabajador_lista TL ",
                      "inner join _sv_trabajador T ON TL.id_trabajador = T.id_trabajador ",
                      "where T.estado = 'A' and T._estado = 'A' ",
                      varCadCod, varCadNom, varCadDir, varCadTip
                      );
  else
    set @sql = CONCAT("select id_trabajador AS CTRA, ",
                      "concat(ifnull(apellido_paterno,''), ' ', ifnull(apellido_materno,''), ' ', ifnull(nombre,'')) as TRABAJADOR, ",
                      "DIRECCION, case when estado='A' then 'ACTIVO' else 'INACTIVO' end as ESTADO ",
                      "from _sv_trabajador T ",
                      "where _estado = 'A' ",
                      "and estado = 'A' ",
                      varCadCod, varCadNom, varCadDir
                      );
  end if;
  
  
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
 END;