call spQuery_Lista_Producto_Venta(3, 4 , 1, 'P', '020011', NULL);

DROP PROCEDURE IF EXISTS spQuery_Lista_Producto_Venta;
CREATE PROCEDURE spQuery_Lista_Producto_Venta(
  varEmpresa  int,
  varAlmacen  int,
  varLista    int,
  varFlag     char(1),  /*P=PRODUCTO, S=SERVICIO, A=ACTIVO*/
	varCodigo   varchar(6),
  varNombre   varchar(80)
  )
BEGIN
  DECLARE varCadCod, varCadNom TEXT DEFAULT '';
  
	if varCodigo <> '' and varCodigo is not null then
    set varCadCod = CONCAT(" and LP.id_producto = '", lpad(varCodigo,6,'0'),"' ");
  end if;
	if varNombre <> '' and varNombre is not null then
    set varCadNom = CONCAT(" and P.descripcion like '%", varNombre,"%' ");
  end if;

 	SET @sql = CONCAT("select LP.id_producto as CPRO, P.descripcion as PRODUCTO, LP.id_um AS UM, LP.PRECIO, ",
                    "ifnull((select K.cantidad ",
                    "        from _sv_kardex K ",
                    "        where K._estado = 'A' ",
                    "        and K.id_empresa = ", varEmpresa, " ",
                    "        and K.id_almacen = ", varAlmacen, " ",
                    "        and K.id_producto = LP.id_producto),0) AS STOCK ",
                    "from _sv_lista_producto LP ",
                    "inner join _sv_producto P ON LP.id_producto = P.id_producto ",
                    "inner join _sv_tipo T ON P.id_tipo = T.id_tipo ",
                    "where LP._estado = 'A' and P._estado = 'A' ",
                    "and T.flag_proser = '", varFlag, "' ",
                    "and LP.id_empresa = ", varEmpresa, " ",
                    "and LP.id_lista = ", varLista, " ",
                    varCadCod, varCadNom); 
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;

