call spQuery_Lista_CuotaVenta_Vendedor(1, '2013', '01',4);

DROP PROCEDURE IF EXISTS spQuery_Lista_CuotaVenta_Vendedor;
CREATE PROCEDURE spQuery_Lista_CuotaVenta_Vendedor(
  varEmpresa    int,
  varAnio       varchar(4),
  varMes        varchar(2),
  varProveedor  int
  )
BEGIN 
  select LT.id_trabajador, CONCAT(T.apellido_paterno, ' ', T.apellido_materno, ' ', T.nombre) as trabajador
  from _sv_trabajador_lista LT
  inner join _sv_trabajador T ON LT.id_trabajador = T.id_trabajador
  where T._estado='A' and T.estado = 'A' and LT.id_tipo_trabajador = 'VEN'
  and LT.id_trabajador not in (
                          select id_trabajador
                          from _sv_cuota_venta_vendedor
                          where id_anio    = varAnio
                          and id_mes       = varMes
                          and id_empresa   = varEmpresa
                          and id_proveedor = varProveedor
                          )
  order by CONCAT(apellido_paterno, ' ', apellido_materno, ' ', nombre);
END;