CALL spQuery_Estado_Cuenta(6, '2011-02-01', '2011-02-10');

DROP PROCEDURE IF EXISTS spQuery_Estado_Cuenta;
CREATE PROCEDURE spQuery_Estado_Cuenta(varCliente     int,
                                       varFechaIni    date,
                                       varFechaFin    date)
   BEGIN
      DECLARE varSaldoIni, varVenta, varPagos, varVentaIni   double;
      DECLARE varQuery      text;

      select
      sum(monto) INTO varVentaIni
      from _sv_movimiento_cuenta
      Where _estado='A'
      and tipo_mov = 'INI'
      and id_cliente = varCliente
      and fecha < varFechaIni;
      
      select
      sum(D.TOTAL) INTO varVenta
      from _sv_venta_detalle D
      inner join _sv_venta C ON D.id_venta = C.id_venta
      Where C.fecha_emision < varFechaIni
      and C._estado='A'
      and C.id_cliente = varCliente;
      
      select sum(MONTO) INTO varPagos
      from _sv_movimiento_cuenta
      where tipo_mov='PAG'
      and _estado='A'
      and fecha < varFechaIni
      and id_cliente = varCliente;
      
      set varSaldoIni = ifnull(varVenta,0) + ifnull(varVentaIni,0) - ifnull(varPagos,0);

      IF varSaldoIni > 0
      THEN
         SET varQuery =
                CONCAT("SELECT "
                   "date_format(DATE_ADD('",
                   varFechaIni,
                   "', INTERVAL -1 DAY),'%Y-%m-%d') as FECHA, ",
                   "NULL AS TDOC, N