call spQuery_Empresa(NULL,'','','FECHA_CREADO',NULL);

DROP PROCEDURE IF EXISTS spQuery_Empresa;
CREATE PROCEDURE spQuery_Empresa(
  varCodigo int,
	varNombre varchar(80),
  varRuc    varchar(11),
  varField  varchar(60),
  varOrder  varchar(5)
  )
BEGIN
  DECLARE varCadCod, varCadNom, varCadRuc  text default '';
  DECLARE varCadOrd TEXT DEFAULT '';
  
  if varCodigo is not null or varCodigo <> '' then
    set varCadCod = CONCAT(" and E.id_empresa = ", varCodigo, " ");
  end if;
  if ifnull(varNombre,'') <> '' then
    set varCadNom = CONCAT(" and E.nombre LIKE '%", varNombre, "%' ");
  end if;
  if ifnull(varRuc,'') <> '' then
    set varCadRuc = CONCAT(" and E.ruc = '", varRuc, "' ");
  end if;
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'E._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'E._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  END IF;
  
	set @sql = CONCAT("select E.id_empresa AS CEMP, E.nombre AS EMPRESA, E.RUC, E.ABREV, E.DIRECCION, ",
                    "date_format(E._date_create,'%d/%m/%Y %h:%i:%s %p') AS FECHA_CREADO, ",
                    "date_format(E._date_update,'%d/%m/%Y %h:%i:%s %p') AS FECHA_MODIFI, ",
                    "UPPER(UN.usuario) as USER_CREADO, ",
                    "UPPER(UU.usuario) as USER_MODIFI ",
                    "from _sv_empresa E ",
                    "left join _sys_usuario UN ON E._user_create = UN.id_usuario ",
                    "left join _sys_usuario UU ON E._user_update = UU.id_usuario ",
                    "where E._estado='A' and E.id_empresa <> 0 ",
	                  varCadCod, varCadNom, varCadRuc,
                    varCadOrd);		
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;