call spQuery_Efectividad_Reparto('','','','2011-05-25','2011-05-25');

DROP PROCEDURE IF EXISTS spQuery_Efectividad_Reparto;
CREATE PROCEDURE spQuery_Efectividad_Reparto(
  varRuta       int,
	varCanal      int, 
  varVendedor   int,
	varFechaIni   date,
	varFechaFin   date
  )
BEGIN  
  DECLARE varCadFechaIni, varCadFechaFin, varCadRuta, varCadCanal, varCadVendedor varchar(100) DEFAULT '';
  
  IF varRuta <> '' AND varRuta IS NOT NULL THEN
    SET varCadRuta = CONCAT(" and C.id_ruta = ", varRuta, " ");  
  END IF;
  
  IF varCanal <> '' AND varCanal IS NOT NULL THEN
    SET varCadCanal = CONCAT(" and P.id_tipo_vendedor = ", varCanal, " ");  
  END IF;
  
  IF varVendedor <> '' AND varVendedor IS NOT NULL THEN
    SET varCadVendedor = CONCAT(" and V.id_vendedor = ", varVendedor, " ");  
  END IF;
  
  IF varFechaIni <> '' and varFechaIni <> '0000-00-00' and varFechaIni IS NOT NULL THEN
    SET varCadFechaIni = CONCAT(" and V.fecha_emision >= '", varFechaIni, "' ");
  END IF;
  
  IF varFechaFin <> '' and varFechaFin <> '0000-00-00' and varFechaFin IS NOT NULL THEN
    SET varCadFechaFin = CONCAT(" and V.fecha_emision <= '", varFechaFin, "' ");
  END IF;
  
  set @sql = CONCAT("select V.fecha_emision as FEMI, ",
                    "V.nro_pedido as PEDIDO, ",
                    "CONCAT(T.abrev, '-', V.nro_documento) as NDOC, ",
                    "P.id_tipo_vendedor as CCAN, UPPER(TV.nombre) as CANAL, ",
                    "V.id_vendedor as CVEN, UPPER(P.nombre) as VENDEDOR, ",
                    "V.id_cliente as CCLI, UPPER(C.nombre) as CLIENTE, ",
                    "C.id_ruta as CRUT, UPPER(R.nombre) as RUTA, "
                    "CASE WHEN V.estado='AN' and V.id_motivo_rechazo<>0 THEN 'RECHAZADO' ",
                    "     WHEN V.estado<>'AN' and V.id_motivo_rechazo<>0 THEN 'PARCIAL' ",                    
                    "     WHEN V.estado='AN' and V.id_motivo_rechazo=0 THEN 'ANULADO' ",
                    "     ELSE 'COMPLETADO' ",
                    "END AS ESTADO, "
                    "V.total as IMPORTE ",                    
                    "from _sv_venta_detalle D ",
                    "inner join _sv_venta V ON D.id_venta = V.id_venta ",
                    "inner join _sv_forma_pago T ON V.id_tipo_doc = T.id_tipo_doc ",
                    "inner join _sv_vendedor P ON V.id_vendedor = P.id_vendedor ",
                    "inner join _sv_tipo_vendedor TV ON P.id_tipo_vendedor = TV.id_tipo_vendedor "
                    "inner join _sv_cliente C ON V.id_cliente = C.id_cliente ",
                    "inner join _sv_ruta R    ON C.id_ruta = R.id_ruta ",
                    "where V._estado = 'A' ",
                    varCadRuta, varCadCanal, varCadVendedor, varCadFechaIni, varCadFechaFin,
                    "group by V.fecha_emision, ", 
                    "V.nro_pedido, ",
                    "CONCAT(T.abrev, '-', V.nro_documento), ",
                    "V.id_vendedor, P.nombre, ",
                    "P.id_tipo_vendedor, TV.nombre, ",
                    "V.id_cliente, C.nombre, ",
                    "C.id_ruta, R.nombre, ",
                    "CASE WHEN V.estado='AN' and V.id_motivo_rechazo<>0 THEN 'RECHAZADO' ",
                    "     WHEN V.estado<>'AN' and V.id_motivo_rechazo<>0 THEN 'PARCIAL' ",                    
                    "     WHEN V.estado<>'AN' and V.id_motivo_rechazo<>0 THEN 'ANULADO' ",
                    "     ELSE 'COMPLETADO' ",
                    "END, "
                    "V.total");
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;