call spQuery_Cuota_Compra_Proveedor('2013', '12', '2', NULL, 1, NULL, NULL);

DROP PROCEDURE IF EXISTS spQuery_Cuota_Compra_Proveedor;
CREATE PROCEDURE spQuery_Cuota_Compra_Proveedor(
	varAnio       varchar(4),
	varMes        varchar(2),
  varEmpresa    int,
  varProveedor  int,
  varUsuario    int,
  varField      varchar(60),
  varOrder      varchar(5)
)
BEGIN
  DECLARE varCadAni, varCadMes, varCadEmp, varCadPro TEXT DEFAULT '';
  DECLARE varCadOrd TEXT DEFAULT '';
  
	if varAnio <> '' and varAnio is not null then
    set varCadAni = CONCAT(" and C.id_anio = ", varAnio," ");
  end if;
	if varMes <> '' and varMes is not null then
    set varCadMes = CONCAT(" and C.id_mes = ", varMes," ");
  end if;
  if varEmpresa <> '' and varEmpresa is not null then
    set varCadEmp = CONCAT(" and C.id_empresa = ", varEmpresa," ");
  end if;
  if varProveedor <> '' and varProveedor is not null then
    set varCadPro = CONCAT(" and C.id_proveedor = ", varProveedor," ");
  end if;  
  
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'C._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'C._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  END IF;
  
  SET @sql = CONCAT("select ",
                    "C.id_empresa as CEMP, E.nombre as EMPRESA, ",
                    "C.id_proveedor as CPRO, P.nombre as PROVEEDOR, ",
                    "C.id_anio as ANIO, CONCAT(C.id_mes, ' - ', spFuncion_NombreMes(C.id_mes)) as MES, ",
                    "C.MONTO, ",
                    "date_format(C._date_create,'%d/%m/%Y %h:%i:%s %p') AS FECHA_CREADO, ",
                    "date_format(C._date_update,'%d/%m/%Y %h:%i:%s %p') AS FECHA_MODIFI, ",
                    "UPPER(UN.usuario) as USER_CREADO, ",
                    "UPPER(UU.usuario) as USER_MODIFI ",
                    "from _sv_cuota_compra_proveedor C ",
                    "inner join _sv_empresa E   ON C.id_empresa = E.id_empresa ",
                    "inner join _sv_proveedor P ON C.id_proveedor = P.id_proveedor ",
                    "left join _sys_usuario UN  ON C._user_create = UN.id_usuario ",
                    "left join _sys_usuario UU  ON C._user_update = UU.id_usuario ",
                    "where C._estado = 'A' ",
                    "and C.id_empresa in (select distinct id_empresa from _sys_usuario_almacen where id_usuario=",varUsuario ,") ",
                    varCadAni, varCadMes, varCadEmp, varCadPro,
                    varCadOrd);
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;