call spQuery_Cobertura_Zona(NULL, '2011-08-25', '2011-08-25');

DROP PROCEDURE IF EXISTS spQuery_Cobertura_Zona;
CREATE PROCEDURE spQuery_Cobertura_Zona(  
	varCanal      int, 
  varFechaIni   date,
	varFechaFin   date
  )
BEGIN 
  DECLARE varCadFechaIni, varCadFechaFin, varCadCanal varchar(100) DEFAULT '';
  
  IF varCanal <> '' AND varCanal IS NOT NULL THEN
    SET varCadCanal = CONCAT(" and Ve.id_tipo_vendedor = ", varCanal, " ");  
  END IF;
  
  IF varFechaIni <> '' and varFechaIni <> '0000-00-00' and varFechaIni IS NOT NULL THEN
    SET varCadFechaIni = CONCAT(" and V.fecha_emision >= '", varFechaIni, "' ");
  END IF;
  
  IF varFechaFin <> '' and varFechaFin <> '0000-00-00' and varFechaFin IS NOT NULL THEN
    SET varCadFechaFin = CONCAT(" and V.fecha_emision <= '", varFechaFin, "' ");
  END IF;
  
  set @sql = CONCAT("select C.id_ruta as CRUT, R.nombre as RUTA, ",
                    "V.id_vendedor as CVEN, Ve.nombre as VENDEDOR, ",
                    "A.id_proveedor as CPRO, P.nombre as PROVEEDOR, ",
                    "count(distinct V.id_cliente) as COBERTURA, ",
                    "sum(D.total) as IMPORTE ",
                    "from _sv_venta_detalle D ",
                    "inner join _sv_venta V     ON D.id_venta = V.id_venta ",
                    "inner join _sv_producto A  ON D.id_producto = A.id_producto ",
                    "inner join _sv_proveedor P ON A.id_proveedor = P.id_proveedor ",
                    "inner join _sv_vendedor Ve ON V.id_vendedor = Ve.id_vendedor ",
                    "inner join _sv_cliente C   ON V.id_cliente = C.id_cliente ",
                    "inner join _sv_ruta R      ON C.id_ruta = R.id_ruta ",
                    "where V._estado = 'A' ",
                    "and V.estado   <> 'AN' ",
                    varCadCanal, varCadFechaIni, varCadFechaFin,
                    "and D.cantidad       > 0 ",
                    "group by C.id_ruta, R.nombre, ",
                    "V.id_vendedor, Ve.nombre, ",
                    "A.id_proveedor, P.nombre ",                    
                    "order by R.nombre, C.id_ruta, Ve.nombre, P.nombre");
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;