call spQuery_Boleta_Pago_Cabecera(15,1,1,16402025);

DROP PROCEDURE IF EXISTS spQuery_Boleta_Pago_Cabecera;
CREATE PROCEDURE spQuery_Boleta_Pago_Cabecera(
  varPlanilla   int,
	varEmpresa    int,
  varAgencia    int,
  varTrabajador int
  )
BEGIN
  DECLARE varCadEmp, varCadAge, varCadTra TEXT default '';
  IF ifnull(varEmpresa,'')<>'' THEN
    set varCadEmp = CONCAT(" and PP.id_empresa = ", varEmpresa, " ");
  END IF;
  IF ifnull(varAgencia,'')<>'' THEN
    set varCadAge = CONCAT(" and PP.id_agencia = ", varAgencia, " ");
  END IF;
  IF ifnull(varTrabajador,'')<>'' THEN
    set varCadTra = CONCAT(" and PP.id_trabajador = ", varTrabajador, " ");
  END IF;
  
  set @sql = CONCAT("select PP.id_empresa as CEMP, E.nombre as EMPRESA, E.DIRECCION, E.RUC, 'PRIVADO' AS REGEMP, ",
                    "P.id_periodo_pago as CPER, Pe.nombre as PERIODO, ",
                    "PP.id_trabajador as CTRA, CONCAT(T.apellido_paterno, ' ', T.apellido_materno, ' ', T.nombre) as TRABAJADOR, ",
                    "CONCAT(TD.abrev,' ',T.nro_documento) as DOCIDE, ",
                    "PP.id_tipo_trabajador as CTIP, Ti.nombre as TIPO, ",
                    "PP.id_cargo as CCAR, C.nombre as CARGO, ",
                    "PP.id_regimen as CREG, R.nombre as REGIMEN, ",
                    "DATE_FORMAT(PP.fecha_ingreso,'%d/%m/%Y') AS FING, ",
                    "DATE_FORMAT(PP.fecha_salida,'%d/%m/%Y') AS FSAL, ",
                    "PP.nro_cuspp as CUSPP, ",
                    "PP.BASICO, ",
                    "PP.ASIGFAM, ",
                    "PP.COMISION, ",
                    "CASE WHEN IFNULL(PP.conlab_bono,0) + IFNULL(PP.conlab_viatico,0) <> 0  ",
                    "    THEN IFNULL(PP.conlab_bono,0) + IFNULL(PP.conlab_viatico,0) ",
                    "END AS CONLAB, ",
                    "PP.afp_comision + PP.afp_fondo + PP.afp_prima AS AFP, ",
                    "PP.ONP, ",
                    "PP.total_ingresos as INGRESO, ",
                    "PP.total_egresos as EGRESO, ",
                    "PP.total_pagar as TOTAL, ",
                    "PP.dias_trabajados as DIAS, ",
                    "PP.ESSALUD ",
                    "from _srh_planilla_procesada PP ",
                    "inner join _sv_empresa E ON PP.id_empresa = E.id_empresa ",
                    "inner join _srh_planilla P ON PP.id_planilla = P.id_planilla ",
                    "inner join _srh_periodo_pago Pe ON P.id_periodo_pago = Pe.id_periodo_pago ",
                    "inner join _sv_trabajador T ON PP.id_trabajador = T.id_trabajador ",
                    "inner join _srh_tipo_doc_identidad TD ON T.id_tipo_doc_identidad = TD.id_tipo_doc_identidad ",
                    "inner join _srh_tipo_trabajador Ti ON PP.id_tipo_trabajador = Ti.id_tipo_trabajador ",
                    "inner join _srh_cargo C ON PP.id_cargo = C.id_cargo ",
                    "inner join _srh_regimen_pension R ON PP.id_regimen = R.id_regimen ",
                    "where PP.id_planilla = ", varPlanilla, " ",
                    varCadEmp, varCadAge, varCadTra, " ",
                    "ORDER BY E.nombre, CONCAT(T.apellido_paterno, ' ', T.apellido_materno, ' ', T.nombre);");
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;