CALL spQuery_Avance_Ventas_Empresa('2012','08');

DROP PROCEDURE IF EXISTS spQuery_Avance_Ventas_Empresa;
CREATE PROCEDURE spQuery_Avance_Ventas_Empresa(
  varAnio   varchar(4),
  varMes    varchar(2)
  )
BEGIN
  DECLARE varDiaAcum, varDiaUtil, varDiaFalt  double;
  
  SET varDiaAcum = spFuncion_DiasAcumulados(varAnio, varMes);
  SET varDiaUtil = spFuncion_DiasUtiles(varAnio,varMes);
  SET varDiaFalt = varDiaUtil - varDiaAcum;
  
  select A.CEMP, A.EMPRESA, A.VENTA, B.META, ROUND(VENTA/META*100,2) AS PORC_VENTA,
  round(VENTA/varDiaAcum*varDiaUtil,2) as TENDENCIA,                  
  round((VENTA/varDiaAcum*varDiaUtil)/META*100,2) AS PORC_TENDENCIA,
  varDiaAcum AS DIA_ACUM, varDiaUtil AS DIA_UTIL, varDiaFalt AS DIA_FALT
                    
  from
    (
    select E.CEMP, EMPRESA, VENTA
    from
      (
      select id_empresa as CEMP, nombre as EMPRESA
      from _sv_empresa
      where _estado = 'A'
      ) E
    left join
      (
      select id_empresa as CEMP, sum(subtotal) as VENTA
      from _sv_venta
      where _estado = 'A'
      and estado<>'AN'
      and year(fecha_emision)  = varAnio
      and month(fecha_emision) = varMes
      GROUP BY id_empresa
      ) V
    on E.CEMP = V.CEMP
    ) A
  left join
    (
    select M.id_empresa as CEMP, sum(M.monto) as META
    from _sv_metas M
    where M._estado = 'A'
    and M.id_anio = varAnio
    and M.id_mes  = varMes
    group by M.id_empresa
    ) B
  on A.CEMP = B.CEMP;
END;