CALL spQuery_Asignacion_Venta(1);

DROP PROCEDURE IF EXISTS spQuery_Asignacion_Venta;
CREATE PROCEDURE spQuery_Asignacion_Venta(
  varAsignacion int
  )
BEGIN
  select cast(A.id_venta as char) as IDE,
  CAST(CONCAT(T.abrev,'/',V.nro_serie,'-',V.nro_preimpreso) AS CHAR) AS DOCUMENTO,
  SUBSTRING(CAST(CONCAT(lpad(V.id_cliente,5,'0'),' - ', C.nombre) AS CHAR),1,35) AS CLIENTE, 
  SUBSTRING(C.DIRECCION,1,35) AS DIRECCION,
  SUBSTRING(CAST(CONCAT(V.id_ruta, ' - ', R.nombre) AS CHAR),1,35) AS RUTA,
  V.id_trabajador AS VEND,
  V.total,
  1 as DEL
  from _sv_asignacion_venta A
  inner join _sv_venta V    ON A.id_venta = V.id_venta
  inner join _sv_tipo_doc_venta T ON V.id_tipo_doc = T.id_tipo_doc
  inner join _sv_cliente C  ON V.id_cliente = C.id_cliente
  inner join _sv_ruta R     ON V.id_ruta = R.id_ruta
  where A.id_asignacion = varAsignacion
  and A._estado = 'A'
  and V._estado = 'A';
END;