CALL spQuery_Asignacion_Documentos_Detalle_Liquidar(1);

DROP PROCEDURE IF EXISTS spQuery_Asignacion_Documentos_Detalle_Liquidar;
CREATE PROCEDURE spQuery_Asignacion_Documentos_Detalle_Liquidar(
  varAsignacion int
  )
BEGIN
  select V.id_venta as IDE,
  CONCAT(T.abrev,'/',V.nro_documento) AS NDOC,
  V.id_cliente AS CCLI, C.nombre as CLIENTE, SUBSTRING(C.DIRECCION,1,35) AS DIRECCION,
  CONCAT(V.id_ruta,' - ', R.nombre) as RUTA,
  CAST(SUBSTRING(CONCAT(V.id_vendedor,' - ',Ve.nombre),1,35) AS CHAR) as VENDEDOR,
  V.TOTAL,
  V.SALDO
  from _sv_asignacion_venta A
  inner join _sv_venta V on A.id_venta = V.id_venta
  inner join _sv_cliente C ON V.id_cliente = C.id_cliente
  inner join _sv_ruta R ON V.id_ruta = R.id_ruta
  inner join _sv_vendedor Ve ON V.id_vendedor = Ve.id_vendedor
  inner join _sv_tipo_doc_venta T ON V.id_tipo_doc = T.id_tipo_doc
  where V._estado = 'A'
  and V.estado <> 'AN'
  and V.saldo <> 0
  and A.id_asignacion = varAsignacion;
END;