call spQuery_Asignacion_Documentos('2012-03-21',NULL,NULL);

DROP PROCEDURE IF EXISTS spQuery_Asignacion_Documentos;
CREATE PROCEDURE spQuery_Asignacion_Documentos(
  varFecha    date,
  varVendedor text,
  varRuta     text
  )
BEGIN
  DECLARE varCadVen, varCadRut TEXT DEFAULT '';
  
	if varVendedor <> '' and varVendedor is not null then
    set varCadVen = CONCAT(" and V.id_trabajador in ", varVendedor," ");
  end if;
  
  if varRuta <> '' and varRuta is not null then
    set varCadRut = CONCAT(" and V.id_ruta in ", varRuta," ");
  end if;
  
  SET @sql = CONCAT("select V.id_venta as sel, V.id_venta as IDE, ",
                    "CONCAT(T.abrev,'/',V.nro_serie,'-', V.nro_preimpreso) AS NDOC, ",
                    "SUBSTRING(CONCAT(V.id_cliente,' - ',C.nombre),1,35) as CLIENTE, ",
                    "SUBSTRING(C.DIRECCION,1,35) AS DIRECCION, ",                                        
                    "CONCAT(V.id_ruta,' - ', R.nombre) as RUTA, ",
                    "V.id_trabajador as VENDEDOR, ",
                    "SUM(D.total) AS MONTO ",
                    "from _sv_venta_detalle D ",
                    "inner join _sv_venta V     ON D.id_venta = V.id_venta ",                    
                    "inner join _sv_cliente C   ON V.id_cliente = C.id_cliente ",
                    "inner join _sv_ruta R      ON V.id_ruta = R.id_ruta ",
                    "inner join _sv_tipo_doc_venta T   ON V.id_tipo_doc = T.id_tipo_doc ",
                    "where V.fecha_emision = '", varFecha, "' ",
                    "AND V._estado = 'A' ",
                    "AND D._estado = 'A' ",
                    "AND V.estado <> 'AN' ",
                    "AND ifnull(V.id_asignacion,0) = 0 ",
                    varCadVen, varCadRut, " ",
                    "GROUP BY V.id_venta, CONCAT(T.abrev,'/',V.nro_serie,'-', V.nro_preimpreso), ",
                    "CONCAT(V.id_cliente,' - ',C.nombre), C.DIRECCION, ",
                    "V.id_trabajador, CONCAT(V.id_ruta,' - ', R.nombre) ",
                    "ORDER BY V.id_trabajador, V.id_ruta, V.id_tipo_doc, CONCAT(V.nro_serie,'-', V.nro_preimpreso)");
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;