call spQuery_Anio();

DROP PROCEDURE IF EXISTS spQuery_Anio;
CREATE PROCEDURE spQuery_Anio()
begin
	declare varAnioIni 	int;
	declare varAnioFin 	int;
	
  CREATE TEMPORARY TABLE _sv_anio_tmp (id_anio int); 
  
  set varAnioIni = (select min(id_anio) as id_anio
                    from
                      (
                      select ifnull(min(id_anio),year(now())) as id_anio  from _sv_cuota_venta_vendedor
                      union
                      select ifnull(min(id_anio),year(now())) as id_anio from _sv_cuota_venta_familia
                      union
                      select ifnull(min(id_anio),year(now())) as id_anio from _sv_cuota_compra_proveedor
                      union
                      select ifnull(min(id_anio),year(now())) as id_anio from _sv_cuota_compra_familia
                      ) A);
  set varAnioFin = year(now());
  
  WHILE varAnioIni <= varAnioFin DO
	  insert _sv_anio_tmp values (varAnioIni);
    SET varAnioIni = varAnioIni + 1;
  END WHILE;
	select distinct id_anio, id_anio from _sv_anio_tmp order by id_anio desc;
  
  DROP TEMPORARY TABLE IF EXISTS _sv_anio_tmp;
end;