call spQuery_Agencia(NULL,NULL,1,'FECHA_CREADO',NULL);

DROP PROCEDURE IF EXISTS spQuery_Agencia;
CREATE PROCEDURE spQuery_Agencia(
  varCodigo   int,
	varNombre   varchar(80),
  varUsuario  int,
  varField    varchar(60),
  varOrder    varchar(5)
  )
BEGIN
  DECLARE varCadCod, varCadNom  text default '';
  DECLARE varCadOrd TEXT DEFAULT '';
  
  if varCodigo is not null or varCodigo <> '' then
    set varCadCod = CONCAT(" and A.id_agencia = ", varCodigo, " ");
  end if;
  if ifnull(varNombre,'') <> '' then
    set varCadNom = CONCAT(" and A.nombre LIKE '%", varNombre, "%' ");
  end if;
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'A._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'A._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  END IF;
  
	set @sql = CONCAT("select A.id_agencia AS CAGE, A.nombre AS AGENCIA, A.ABREV, ",
                    "A.id_empresa as CEMP, E.nombre as EMPRESA,",
                    "date_format(A._date_create,'%d/%m/%Y %h:%i:%s %p') AS FECHA_CREADO, ",
                    "date_format(A._date_update,'%d/%m/%Y %h:%i:%s %p') AS FECHA_MODIFI, ",
                    "UPPER(UN.usuario) as USER_CREADO, ",
                    "UPPER(UU.usuario) as USER_MODIFI ",
                    "from _srh_agencia A ",
                    "inner join _sv_empresa E ON A.id_empresa = E.id_empresa ",
                    "left join _sys_usuario UN ON A._user_create = UN.id_usuario ",
                    "left join _sys_usuario UU ON A._user_update = UU.id_usuario ",
                    "where A._estado='A' ",
                    "and A.id_agencia in (select id_agencia from _sys_usuario_agencia where id_usuario = ", varUsuario, ")",
	                  varCadCod, varCadNom,
                    varCadOrd);		
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;