call spMante_Venta_Devolver_Parcial(1, 21, '000086','V', 4.00, 12 ,1);

DROP PROCEDURE IF EXISTS spMante_Venta_Devolver_Parcial;
CREATE PROCEDURE spMante_Venta_Devolver_Parcial(  
  varEmpresa  int,
	varVenta    bigint,
  varProducto varchar(6),
  varTipo     char(1),
  varCantidad double,
  varMotRech  int,
  varUsuario  int
  )
BEGIN 
  /*  201 = Salida por Ventas
      208 = Salida por Bonificacion
      102 = Ingreso por Devolucion de Mercaderia
      109 = Ingreso por Devolucion de Bonificacion
  */
  DECLARE varExiste, varAlmacen int;
  DECLARe varMovIni, varMovDev char(3);
  
  if varTipo = 'V' then
    set varMovIni = '201';
    set varMovDev = '102';
  elseif varTipo = 'B' then
    set varMovIni = '208';
    set varMovDev = '109';
  end if;
  
  select distinct id_almacen 
  into varAlmacen
  from _sv_movimiento_almacen 
  where id_empresa  = varEmpresa
  and id_movimiento = varMovIni
  and id_referencia = varVenta
  and id_producto   = varProducto;
  
  -- Movimiento Ingreso por Devolucion de Mercaderia  
  insert into _sv_movimiento_almacen(id_movimiento, id_empresa, id_almacen, id_referencia, id_producto, cantidad, fecha,
                                     _date_create, _date_update, _user_create, _user_update)
  values(varMovDev, varEmpresa, varAlmacen, varVenta, varProducto, varCantidad, NOW(), NOW(), NOW(), varUsuario, varUsuario);
  
  -- Agregamos la Devolucion al Amacen Fisico
  update _sv_kardex 
  SET cantidad = cantidad + varCantidad,
  _date_update = NOW(),
  _user_update = varUsuario
  where id_almacen= varAlmacen 
  and id_empresa  = varEmpresa 
  and id_producto = varProducto;
  
  -- Restamos la Cantidad devuelta del Documento de Venta
  update _sv_venta_detalle
  set cantidad = cantidad - varCantidad,
  _date_update = NOW(),
  _user_update = varUsuario
  where id_venta  = varVenta
  and id_producto = varProducto
  and id_tipo     = varTipo;
  
  -- Actualizamos la Cantidad y el Monto en el Detalle
  update _sv_venta_detalle
  set total     = round(cantidad*precio,2),
      igv       = round(cantidad*precio*0.18,2),
      subtotal  = round(cantidad*precio/1.18,2)
  where id_venta  = varVenta
  and id_producto = varProducto
  and id_tipo     = varTipo;
  
  -- Actualizamos el monto de la Cabecera del Documento
  update _sv_venta
  set total             = (select sum(total) as total       from _sv_venta_detalle where id_venta = varVenta),
      igv               = (select sum(igv)   as igv         from _sv_venta_detalle where id_venta = varVenta),
      subtotal          = (select sum(subtotal) as subtotal from _sv_venta_detalle where id_venta = varVenta),
      id_motivo_rechazo = varMotRech,
      _user_update      = varUsuario,
      _date_update      = NOW()
  where id_venta        = varVenta
  and id_empresa        = varEmpresa;
  
  -- Actualizamos el monto de la venta en el Movimiento de la Cuenta
  update _sv_movimiento_cuenta_cxc 
  set monto         = (select sum(total) as total from _sv_venta_detalle where id_venta = varVenta),
      _user_update  = varUsuario,
      _date_update  = NOW()
  where id_venta  = varVenta 
  and id_empresa  = varEmpresa
  and tipo_mov    = 'VEN';
  
  -- Actualizamos el monto del pago automatico si la venta fue al contado
  update _sv_movimiento_cuenta_cxc 
  set monto         = (select sum(total) as total from _sv_venta_detalle where id_venta = varVenta),
      _user_update  = varUsuario,
      _date_update  = NOW()
  where id_venta  = varVenta 
  and tipo_mov    = 'PAG'
  and monto > (select sum(total) as total from _sv_venta_detalle where id_venta = varVenta)
  and id_pago_cxc is null;
  
  -- Actualizamos el Saldo del Documento
  update _sv_venta 
  set saldo = (select sum(case when tipo_mov='VEN' then monto else monto*-1 end) as SALDO 
              from _sv_movimiento_cuenta_cxc 
              where id_venta = varVenta
              and id_empresa = varEmpresa
              and _estado = 'A')
  where id_venta = varVenta
  and id_empresa = varEmpresa;
  
END;