call spMante_Vendedor('NEW', NULL, 'APOLAYA SEGURA CARLOS', '41417589', '45613213212', 'CONDORCUNCA', 'CHICLAYO', 'TELEF', 'CELULAR', 'RPC', 'RPM', 'NEXTEL', 1);

DROP PROCEDURE IF EXISTS spMante_Vendedor;
CREATE PROCEDURE spMante_Vendedor(
	varOpcion     varchar(10),
	varCodigo     int,
  varTipo       int,
	varNombre     varchar(80),
	varDNI        varchar(8),
	varDirecc     varchar(80),
  varSueldo     double,
  varComision   double,
  varTelef      varchar(15),
  varCelular    varchar(15),
  varRPM        varchar(15),
  varRPC        varchar(15),
  varNextel     varchar(15),
  varEstado     char(1),
	varUsuario    int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default 'OK';
	if varOpcion='NEW' then
    -- Buscamos si el nombre del cliente ya se encuentra registrado
    select count(*) INTO varExiste from _sv_vendedor 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre)) and _estado = 'A';
    
    if varExiste <= 0 then 
      -- Generamos el siguiente correlativo
      SELECT ifnull(max(id_vendedor),0)+1 INTO varCodigo FROM _sv_vendedor;    
      -- Insertamos el Nuevo Vendedor
      INSERT INTO _sv_vendedor (id_vendedor, id_tipo_vendedor, nombre, dni, direccion, sueldo, comision,
              telefono, celular, rpm, rpc, nextel, estado,
              _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, varTipo, UPPER(varNombre), varDNI, UPPER(varDirecc), varSueldo, varComision, 
              varTelef, varCelular, varRPM, varRPC, varNextel, varEstado,
              NOW(),NOW(), varUsuario, varUsuario);
    else
      set varError = CONCAT('EL VENDEDOR ', varNombre, ' YA SE ENCUENTRA REGISTRADO');
    end if;    	
	else
    -- Buscamos si el nombre del Vendedor ya se encuentra registrado
    select count(*) INTO varExiste  from _sv_vendedor
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and _estado = 'A'  and id_vendedor <> varCodigo;
    if varExiste <= 0 then 
      update _sv_vendedor set
      id_tipo_vendedor = varTipo,
      nombre           = UPPER(varNombre),
      dni              = varDNI,		
      direccion        = UPPER(varDirecc),
      sueldo           = varSueldo,
      comision         = varComision,
      telefono         = varTelef,
      celular          = varCelular,
      rpm              = varRPM,
      rpc              = varRPC,
      nextel           = varNextel,
      estado           = varEstado,
      _date_update     = NOW(),
      _user_update     = varUsuario
      where id_vendedor = varCodigo;
    else
      set varError = CONCAT('EL VENDEDOR ', varNombre, ' YA SE ENCUENTRA REGISTRADO');
    end if;		
	end if;
  SELECT varError;
END;