call spMante_TrabajadorRRHH('EDIT', 16425240, 1, '07030', 'QUISPE', 'RIOJA', 'CESAR CRUZ', '01', '16425240', '1965-08-04', '01', '140101', 'M', 1, 
											'01', 'campodonico', '03', 'ORTIZ VELEZ Nº 180 - CAMPODONICO', NULL, NULL, NULL, '325926', NULL, NULL, NULL, NULL, NULL,
											NULL, NULL, 1, 3, 5, 23, '01', NULL, NULL, NULL, NULL, NULL, NULL, 
											NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 1);
                      
DROP PROCEDURE IF EXISTS spMante_TrabajadorRRHH;
CREATE PROCEDURE spMante_TrabajadorRRHH(
	varOpcion     varchar(10),
	varCodigo     int,
  varEstadoTrab int,
  varAlterna    varchar(10),
  varApePat     varchar(50),
  varApeMat     varchar(50),
	varNombre     varchar(50),
  varTipoDocIde varchar(2),
  varNumDocIde  varchar(20),
  varFechaNac   date,
  varPais       varchar(3),
  varUbigeo     varchar(10),
  varSexo       char(1),
  varEstCivil   int,
  varTipoZona   varchar(3),
  varZona       varchar(80),
  varTipoVia    varchar(3),
  varDirecc     varchar(120),
  varGrupSang   varchar(10),
  varFactSang   varchar(10),
  varAlergia    varchar(60),
  varTelef1     varchar(20),
  varTelef2     varchar(20),
  varCelular    varchar(20),
  varRpm        varchar(20),
  varRpc        varchar(20),
  varNextel     varchar(20),
  varBrevete    varchar(20),
  varEmail      varchar(80),
  varTipo       int,
  varArea       int,
  varSubArea    int,
  varCargo      int,
  varNivelEdu   varchar(3),
  varOcupacion  varchar(6),
  varFlagPri    char(1),
  varDepaPri    varchar(2),
  varCodiPri    int,  
  varFlagSec    char(1),
  varDepaSec    varchar(2),
  varCodiSec    int,  
  varFlagTec    char(1),
  varDepaTec    varchar(2),
  varCodiTec    int,  
  varFlagUni    char(1),
  varDepaUni    varchar(2),
  varCodiUni    int,  
  varFlagMae    char(1),
  varDepaMae    varchar(2),
  varCodiMae    int,  
  varFlagDoc    char(1),
  varDepaDoc    varchar(2),
  varCodiDoc    int,  
  varUsuario    int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default '';
	if varOpcion='NEW' then
    -- Buscamos si el nombre del trabajador ya se encuentra registrado
    select count(*) INTO varExiste from _sv_trabajador 
    where UPPER(CONCAT(TRIM(apellido_paterno), TRIM(apellido_materno), TRIM(nombre))) = 
          UPPER(CONCAT(TRIM(varApePat), TRIM(varApeMat), TRIM(varNombre)))
    and _estado = 'A';
    if varExiste > 0 then 
      set varError = CONCAT(varError, '\nEL TRABAJADOR ', upper(varApePat), ' ', upper(varApemat), ', ', upper(varNombre), ' YA SE ENCUENTRA REGISTRADO');
      set varExiste= 0;
    end if;
    
    -- Buscamos si el Tipo de Documento del trabajador ya se encuentra registrado
    select count(*) INTO varExiste from _sv_trabajador 
    where id_tipo_doc_identidad = varTipoDocIde
    and TRIM(nro_documento) = TRIM(varNumDocIde)
    and _estado = 'A';
    if varExiste > 0 then 
      set varError = CONCAT(varError, '\nEL DOCUMENTO ', (select abrev from _srh_tipo_doc_identidad where id_tipo_doc_identidad=varTipoDocIde), ' ', trim(varNumDocIde), ' YA SE ENCUENTRA REGISTRADO');
    end if;
    
    -- Buscamos si el Codigo del trabajador ya se encuentra registrado
    select count(*) INTO varExiste from _sv_trabajador 
    where id_trabajador = varCodigo;
    if varExiste > 0 then 
      set varError = CONCAT(varError, '\nEL CODIGO ',varCodigo, ' YA SE ENCUENTRA REGISTRADO');
    end if;
    
    -- Si no se genero error insertamos el trabajador
    if varError = '' then
      set varError = 'OK';
      -- SELECT ifnull(max(id_trabajador),0)+1 INTO varCodigo FROM _sv_trabajador;    
      
      INSERT INTO _sv_trabajador (id_trabajador, id_estado_trabajador, id_alternativo, apellido_paterno, apellido_materno, nombre,
              id_tipo_doc_identidad, nro_documento, fecha_nacimiento, id_pais, id_ubigeo, sexo, id_estado_civil, 
              id_zona, zona, id_via, direccion, grupo_sanguineo, factor_sanguineo, alergia, telefono1, telefono2, 
              celular, rpm, rpc,  nextel, brevete, email, id_tipo_trabajador, id_area, id_sub_area, id_cargo, 
              id_nivel_educativo, id_ocupacion, 
              flag_primaria,    id_dep_pri, id_primaria, 
              flag_secundaria,  id_dep_sec, id_secundaria, 
              flag_tecnica,     id_dep_tec, id_tecnica, 
              flag_universidad, id_dep_uni, id_universidad, 
              flag_maestria,    id_dep_mae, id_maestria, 
              flag_doctorado,   id_dep_doc, id_doctorado,
              _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, varEstadoTrab, varAlterna, UPPER(varApePat), UPPER(varApeMat), UPPER(varNombre), 
              varTipoDocIde, varNumDocIde, varFechaNac,
              varPais, varUbigeo, varSexo, varEstCivil, varTipoZona, UPPER(varZona), varTipoVia, UPPER(varDirecc), 
              varGrupSang, varFactSang, UPPER(varAlergia), varTelef1, varTelef2, varCelular, varRpm, varRpc, 
              varNextel, varBrevete, varEmail, varTipo, varArea, varSubArea, varCargo, varNivelEdu, varOcupacion, 
              varFlagPri, varDepaPri, varCodiPri, 
              varFlagSec, varDepaSec, varCodiSec, 
              varFlagTec, varDepaTec, varCodiTec, 
              varFlagUni, varDepaUni, varCodiUni, 
              varFlagMae, varDepaMae, varCodiMae, 
              varFlagDoc, varDepaDoc, varCodiDoc,
              NOW(),NOW(), varUsuario, varUsuario);
    end if;
	else
    -- Buscamos si el nombre del trabajador ya se encuentra registrado
    select count(*) INTO varExiste 
    from _sv_trabajador 
    where UPPER(CONCAT(TRIM(apellido_paterno), TRIM(apellido_materno), TRIM(nombre))) = 
          UPPER(CONCAT(TRIM(varApePat), TRIM(varApeMat), TRIM(varNombre)))
    and _estado = 'A' and id_trabajador <> varCodigo;
    if varExiste > 0 then 
      set varError = CONCAT(varError, '\nEL TRABAJADOR ', upper(varApePat), ' ', upper(varApemat), ', ', upper(varNombre), ' YA SE ENCUENTRA REGISTRADO');
      set varExiste= 0;
    end if;
    
    -- Buscamos si el DNI del trabajador ya se encuentra registrado
    select count(*) INTO varExiste 
    from _sv_trabajador 
    where id_tipo_doc_identidad = varTipoDocIde
    and TRIM(nro_documento) = TRIM(varNumDocIde)
    and _estado = 'A' and id_trabajador <> varCodigo;
    if varExiste > 0 then 
      set varError = CONCAT(varError, '\nEL DOCUMENTO ', (select abrev from _srh_tipo_doc_identidad where id_tipo_doc_identidad=varTipoDocIde), ' ', trim(varNumDocIde), ' YA SE ENCUENTRA REGISTRADO');
    end if;
    
    -- Si no se genero error actualizamos el trabajador
    if varError = '' then
      set varError = 'OK';
      -- Buscamos si el nombre del Vendedor ya se encuentra registrado
      update _sv_trabajador 
      set
      id_estado_trabajador  = varEstadoTrab,
      id_alternativo        = varAlterna,
      apellido_paterno      = UPPER(varApePat),   apellido_materno        = UPPER(varApeMat), 
      nombre                = UPPER(varNombre),   id_tipo_doc_identidad   = varTipoDocIde, 
      nro_documento         = varNumDocIde, fecha_nacimiento= varFechaNac,  id_pais         = varPais, 
      id_ubigeo             = varUbigeo,    sexo            = varSexo,      id_estado_civil = varEstCivil, 
      id_zona               = varTipoZona,  zona          = UPPER(varZona), id_via          = varTipoVia, 
      grupo_sanguineo       = varGrupSang,  factor_sanguineo= varFactSang,  direccion       = UPPER(varDirecc),
      telefono1             = varTelef1,    telefono2       = varTelef2,    alergia         = UPPER(varAlergia), 
      celular               = varCelular,   rpm             = varRpm,       rpc             = varRpc,  
      nextel                = varNextel,    brevete         = varBrevete,   email           = varEmail, 
      id_tipo_trabajador    = varTipo,      id_area         = varArea,      id_sub_area     = varSubArea, 
      id_nivel_educativo    = varNivelEdu,  id_cargo        = varCargo,     id_ocupacion    = varOcupacion, 
      flag_primaria         = varFlagPri,   id_dep_pri      = varDepaPri,   id_primaria     = varCodiPri, 
      flag_secundaria       = varFlagSec,   id_dep_sec      = varDepaSec,   id_secundaria   = varCodiSec, 
      flag_tecnica          = varFlagTec,   id_dep_tec      = varDepaTec,   id_tecnica      = varCodiTec, 
      flag_universidad      = varFlagUni,   id_dep_uni      = varDepaUni,   id_universidad  = varCodiUni, 
      flag_maestria         = varFlagMae,   id_dep_mae      = varDepaMae,   id_maestria     = varCodiMae, 
      flag_doctorado        = varFlagDoc,   id_dep_doc      = varDepaDoc,   id_doctorado    = varCodiDoc,
      _date_update          = NOW(),        _user_update    = varUsuario
      where id_trabajador = varCodigo;
    end if;		
	end if;
  SELECT varError, varCodigo;
END;