Call spMante_Sub_Area('NEW', NULL, 'NEGOCIOS SEOR as CAUTIVO S.R.L.', '20124589654', 'LAS AMERICAS 142 - CHICLAYO', 1);

DROP PROCEDURE IF EXISTS spMante_Sub_Area;
CREATE PROCEDURE spMante_Sub_Area(
	varOpcion   varchar(10),
	varCodigo   int,
  varArea     int,
	varNombre   varchar(100),
  varAbrev    varchar(50),
  varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default '';
	
  if varOpcion='NEW' then
    select count(*) INTO varExiste  
    from _srh_sub_area 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))  and _estado = 'A';
    
    if varExiste > 0 then
      set varError = CONCAT('EL SUB AREA <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADA EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      SELECT ifnull(max(id_sub_area),0)+1 INTO varCodigo FROM _srh_sub_area;
      INSERT INTO _srh_sub_area (id_sub_area, id_area, nombre, abrev, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, varArea, UPPER(varNombre), UPPER(varAbrev), NOW(),NOW(), varUsuario, varUsuario);
      set varError = 'OK';
    end if;
	else
    select count(*) INTO varExiste  
    from _srh_sub_area 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre)) and _estado = 'A' 
    and id_sub_area <> varCodigo;
    if varExiste > 0 then
      set varError = CONCAT('EL SUB AREA <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADA EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      update _srh_sub_area set
      nombre       = UPPER(varNombre),
      abrev        = UPPER(varAbrev),
      id_area      = varArea,
      _date_update = NOW(),
      _user_update = varUsuario
      where id_sub_area = varCodigo;
      set varError = 'OK';
    end if;
	end if;
  select varError;
END;