call spMante_Serie_Punto_Venta('NEW', NULL, 1, 1, 1, 1, 0, 1);

DROP PROCEDURE IF EXISTS spMante_Serie_Punto_Venta;
CREATE PROCEDURE spMante_Serie_Punto_Venta(
	varOpcion   varchar(10),
	varCodigo   int,
	varEmpresa  int,
  varPunVenta int,
  varTipoDoc  int,
  varSerie    varchar(3),
  varNumero   varchar(7),
	varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default 'OK';
	if varOpcion='NEW' then
    select count(*) INTO varExiste
    from _sv_serie_punto_venta
    where id_empresa  = varEmpresa
    and id_punto_venta= varPunVenta
    and id_tipo_doc   = varTipoDoc
    and nro_serie     = lpad(varSerie,3, '0')
    and _estado       = 'A';
    
    if varExiste <= 0 then 
      SELECT ifnull(max(id_serie),0)+1 INTO varCodigo FROM _sv_serie_punto_venta;
      INSERT INTO _sv_serie_punto_venta (id_serie, id_empresa, id_punto_venta, id_tipo_doc, nro_serie, nro_secuencia, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, varEmpresa, varPunVenta, varTipoDoc, lpad(varSerie,3, '0'), varNumero, NOW(),NOW(), varUsuario, varUsuario);
    else
      set varError = CONCAT('LA SERIE QUE INTENTA GUARDAR YA SE ENCUENTRA REGISTRADA');
    end if;
	else
    select count(*) INTO varExiste
    from _sv_serie_punto_venta
    where id_empresa  = varEmpresa
    and id_punto_venta= varPunVenta
    and id_tipo_doc   = varTipoDoc
    and nro_serie     = lpad(varSerie,'0',3)
    and _estado       = 'A'
    and id_serie     <> varCodigo;
    if varExiste <= 0 then 
      update _sv_serie_punto_venta 
      set
      nro_secuencia= varNumero,
      _date_update = NOW(),
      _user_update = varUsuario
      where id_serie = varCodigo;
    else
      set varError = CONCAT('LA SERIE QUE INTENTA GUARDAR YA SE ENCUENTRA REGISTRADA');
    end if;
	end if;
  select varError;
END;