call spMante_RegimenPension('EDIT', '02', 'SISTEMA NACIONAL DE PENSIONES - ONP', 'S', 'S', 'S', 1);

DROP PROCEDURE IF EXISTS spMante_RegimenPension;
CREATE PROCEDURE spMante_RegimenPension(
	varOpcion   varchar(10),
	varCodigo   varchar(2),
	varNombre   varchar(100),
  varPrivado  char(1),
  varPublico  char(1),
  varOtros    char(1),
  varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default '';
	
  if varOpcion='NEW' then
    select count(*) INTO varExiste  
    from _srh_regimen_pension 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))  and _estado = 'A';
    
    if varExiste > 0 then
      set varError = CONCAT('EL REGIMEN DE PENSION <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADO EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      -- SELECT ifnull(max(id_regimen),0)+1 INTO varCodigo FROM _srh_regimen_pension;
      INSERT INTO _srh_regimen_pension (id_regimen, nombre, flag_privado, flag_publico, flag_otros, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, UPPER(varNombre), varPrivado, varPublico, varOtros, NOW(),NOW(), varUsuario, varUsuario);
      set varError = 'OK';
    end if;
	else
    select count(*) INTO varExiste  
    from _srh_regimen_pension 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre)) and _estado = 'A' 
    and id_regimen <> varCodigo;
    if varExiste > 0 then
      set varError = CONCAT('EL REGIMEN DE PENSION <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADO EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      update _srh_regimen_pension set
      nombre        = UPPER(varNombre),
      flag_privado  = varPrivado, 
      flag_publico  = varPublico, 
      flag_otros    = varOtros,
      _date_update  = NOW(),
      _user_update  = varUsuario
      where id_regimen = varCodigo;
      set varError = 'OK';
    end if;
	end if;
  select varError;
END;