call spMante_Producto('EDIT', '002529', '00', '0000', '000000', '0', '0', 'MIL', 'CIE', 'CIE', 'TIRAFON HEXAGONAL G-2 5/16 * 1 1/2', 100, 0, 1);

DROP PROCEDURE IF EXISTS spMante_Producto;
CREATE PROCEDURE spMante_Producto(
	varOpcion     varchar(10),
	varCodigo     varchar(6),
  varProvee     int,	
  varTipo       varchar(2),
  varFamilia    varchar(4),
  varSubFamilia varchar(6),
	varMarca      int,
  varMaterial   int,  
  varUMCompra   varchar(10),
  varUMVenta    varchar(10),
  varUMStock    varchar(10),
	varDescrip    varchar(80),
	varStkMin     double,
  varPeso       double,
	varUsuario    int
)
BEGIN
  DECLARE varCodTemp varchar(6);
  
	if varOpcion='NEW' then
		SELECT LPAD(ifnull(max(id_producto),0)+1,6,'0') INTO varCodTemp 
    FROM _sv_producto
    where id_proveedor = varProvee;
    
    if varCodTemp = '000001' then
      set varCodigo = CONCAT(lpad(varProvee,2,'0'),lpad('1',4,'0'));      
    else
      set varCodigo = varCodTemp;
    end if;
    
		INSERT INTO _sv_producto (id_producto, 
                              id_proveedor, 
                              id_tipo, 
                              id_familia, 
                              id_sub_familia, 
                              id_marca, 
                              id_material, 
                              id_um_compra, 
                              id_um_venta, 
                              id_um_stock, 
                              descripcion, 
                              stock_minimo, 
                              peso, 
                              _date_create, _date_update, _user_create, _user_update) 
		VALUES (varCodigo, 
            varProvee,             
            varTipo, 
            varFamilia,
            varSubFamilia,
            varMarca, 
            varMaterial, 
            varUMCompra, 
            varUMVenta, 
            varUMStock, 
            UPPER(varDescrip),
            varStkMin, 
            varPeso, 
            NOW(),NOW(), varUsuario, varUsuario);
	else
		UPDATE _sv_producto 
    SET
		id_familia      = varFamilia,
    id_sub_familia  = varSubFamilia,
		id_tipo         = varTipo,		
    id_marca        = varMarca,
		id_material     = varMaterial,
    /*
    id_um_compra    = varUMCompra, 
    id_um_venta     = varUMVenta, 
    id_um_stock     = varUMStock,
    */
		descripcion     = UPPER(varDescrip),
		stock_minimo    = varStkMin,
    peso            = varPeso,
		_date_update    = NOW(),
		_user_update    = varUsuario
		where id_producto = varCodigo;
	end if;
END;

select * from _sv_almacen
select * from _sv_kardex