call spMante_Planilla_Detalle('NEW', '10', '2', '0102', 2, 3, 150, NULL, 1);

DROP PROCEDURE IF EXISTS spMante_Planilla_Detalle;
CREATE PROCEDURE spMante_Planilla_Detalle(
	varOpcion     varchar(10),
	varPlanilla   int,
  varTrabajador int,
	varConcepto   varchar(5),
  varEmpresa    int,
  varDetalle    int,
  varAgencia    int,
  varMonto      double,
  varObserva    text,
  varUsuario    int
)
BEGIN
  if varOpcion='NEW' then
    SELECT ifnull(max(id_detalle),0) + 1 
    INTO varDetalle
    from _srh_planilla_detalle
    where id_planilla = varPlanilla
    and id_trabajador = varTrabajador
    and id_concepto   = varConcepto
    and id_empresa    = varEmpresa;
    
    INSERT INTO _srh_planilla_detalle (id_planilla, id_trabajador, id_concepto, id_empresa, id_detalle,
                                       id_agencia, monto, observacion, _date_create, _date_update, _user_create, _user_update) 
    VALUES (varPlanilla, varTrabajador, varConcepto, varEmpresa, varDetalle, varAgencia, 
            varMonto, varObserva, NOW(),NOW(), varUsuario, varUsuario);
      
	else
    update _srh_planilla_detalle
    set monto    = varMonto, 
    observacion  = varObserva,
    _date_update = NOW(),
    _user_update = varUsuario
    where id_planilla = varPlanilla
    and id_trabajador = id_trabajador
    and id_concepto   = varConcepto
    and id_empresa    = varEmpresa
    and id_detalle    = varDetalle;
	end if;
END;