DROP PROCEDURE IF EXISTS spMante_PeriodoPago;
CREATE PROCEDURE spMante_PeriodoPago(
	varOpcion   varchar(10),
	varCodigo   int,
	varNombre   varchar(100),
  varTipo     varchar(2),
  varInicio   date,
  varFin      date,
  varDias     int,
  varLabor    int,
  varFeria    int,
  varEstado   char(1),
  varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default '';
	
  if varOpcion='NEW' then
    -- Verificamos si existe el Nombre del Periodo
    select count(*) INTO varExiste  
    from _srh_periodo_pago 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))  and _estado = 'A';
        if varExiste > 0 then
      set varError = CONCAT('EL NOMBRE DE PERIODO DE PAGO <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADO EN EL SISTEMA\n');
    end if;
    
    -- Verificamos si existe el Codigo del Periodo
    select count(*) INTO varExiste  
    from _srh_periodo_pago 
    where id_periodo_pago = varCodigo;
        if varExiste > 0 then
      set varError = CONCAT('EL CODIGO DE PERIODO DE PAGO <<', varCodigo, '>> YA SE ENCUENTRA REGISTRADO EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      INSERT INTO _srh_periodo_pago (id_periodo_pago, id_tipo_periodicidad, nombre, fecha_inicio, fecha_fin, 
                  dias_periodo, dias_laborables, dias_feriados, estado,
                  _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, varTipo, UPPER(varNombre), varInicio, varFin, varDias, varLabor, varFeria, varEstado,
                  NOW(),NOW(), varUsuario, varUsuario);
      set varError = 'OK';
    end if;
	else
    -- Verificamos si existe el Nombre del Periodo
    select count(*) INTO varExiste  
    from _srh_periodo_pago 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre)) and _estado = 'A' 
    and id_periodo_pago <> varCodigo;
    if varExiste > 0 then
      set varError = CONCAT('EL PERIODO DE PAGO  <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADA EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      update _srh_periodo_pago set
      nombre                = UPPER(varNombre),
      id_tipo_periodicidad  = varTipo,
      fecha_inicio          = varInicio,
      fecha_fin             = varFin,
      dias_periodo          = varDias,
      dias_laborables       = varLabor,
      dias_feriados         = varFeria,
      estado                = varEstado,
      _date_update          = NOW(),
      _user_update          = varUsuario
      where id_periodo_pago = varCodigo;
      set varError = 'OK';
    end if;
	end if;
  select varError;
END;