DROP PROCEDURE IF EXISTS spMante_PeriodoAfp;
CREATE PROCEDURE spMante_PeriodoAfp(
	varOpcion   varchar(10),
	varCodigo   int,
	varNombre   varchar(100),
  varAnio     varchar(4),
  varMes      varchar(2),
  varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default '';
	
  if varOpcion='NEW' then
    -- Verificamos si existe el Nombre del Periodo
    select count(*) INTO varExiste  
    from _srh_periodo_afp 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))  and _estado = 'A';
        if varExiste > 0 then
      set varError = CONCAT('EL PERIODO AFP <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADA EN EL SISTEMA\n');
    end if;
    set varExiste = 0;
    -- Verificamos si existe el mes y ao
    select count(*) INTO varExiste  
    from _srh_periodo_afp 
    where _estado = 'A'
    and id_anio   = varAnio
    and id_mes    = varMes;
    
        if varExiste > 0 then
      set varError = CONCAT('EL PERIODO AFP <<',spFuncion_NombreMes(varMes),' ', varAnio, '>> YA SE ENCUENTRA REGISTRADO EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      SELECT ifnull(max(id_periodo_afp),0)+1 INTO varCodigo FROM _srh_periodo_afp;
      INSERT INTO _srh_periodo_afp (id_periodo_afp, nombre, id_anio, id_mes, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, UPPER(varNombre), varAnio, varMes, NOW(),NOW(), varUsuario, varUsuario);
      set varError = 'OK';
    end if;
	else
    -- Verificamos si existe el Nombre del Periodo
    select count(*) INTO varExiste  
    from _srh_periodo_afp 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre)) and _estado = 'A' 
    and id_periodo_afp <> varCodigo;
    if varExiste > 0 then
      set varError = CONCAT('EL PERIODO AFP  <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADA EN EL SISTEMA\n');
    end if;
    set varExiste = 0;
    -- Verificamos si existe el mes y ao
    select count(*) INTO varExiste  
    from _srh_periodo_afp 
    where _estado = 'A'
    and id_anio   = varAnio
    and id_mes    = varMes
    and id_periodo_afp <> varCodigo;
    if varExiste > 0 then
      set varError = CONCAT('EL PERIODO AFP <<',spFuncion_NombreMes(varMes),' ', varAnio, '>> YA SE ENCUENTRA REGISTRADO EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      update _srh_periodo_afp set
      nombre       = UPPER(varNombre),
      id_anio      = varAnio,
      id_mes       = varMes,
      _date_update = NOW(),
      _user_update = varUsuario
      where id_periodo_afp = varCodigo;
      set varError = 'OK';
    end if;
	end if;
  select varError;
END;