CALL spMante_Pago_Modificar(3, 5000, 'Por error en digitacion', 1);

DROP PROCEDURE IF EXISTS spMante_Pago_Modificar;
CREATE PROCEDURE spMante_Pago_Modificar(
	varPago       int,   
  varMonto      double,	
  varObserva    text,
  varUsuario    int
  )
BEGIN  
-- DISTRIBUCIONES MENFAR
  DECLARE varVenta  int;
  DECLARE varMontoAnt, varSaldoAct, varSaldoNew  double;
  
  select id_venta, monto into varVenta, varMontoAnt
  from _sv_pago where id_pago=varPago;  
  
  -- CONSULTAMOS SALDO ACTUAL y NUEVO SALDO DEL DOCUMENTO
  select  saldo into varSaldoAct from _sv_venta where id_venta = varVenta;
  set varSaldoNew = varSaldoAct + varMontoAnt-varMonto;
  
  -- ACTUALIZAMOS EL REGISTRO DE VENTAS
  IF varSaldoNew = 0 THEN  
    update _sv_venta set saldo=varSaldoNew, estado='CA' where id_venta=varVenta;
  ELSE
    update _sv_venta set saldo=varSaldoNew, estado='PP' where id_venta=varVenta;
  END IF;
  
  
  /*ACTUALIZAMOS EL VOUCHER DE PAGO*/
  update _sv_pago 
  set monto = varMonto,
  observacion = concat(observacion,' ',varObserva),
  _update = NOW(),
  _user_update = varUsuario
  where id_pago = varPago
  and _estado = 'A';
  
  /*ACTUALIZAMOS EL MOVIMIENTO DE LA CUENTA*/
  update _sv_movimiento_cuenta
  set monto = varMonto,
  _update = NOW(),
  _user_update = varUsuario
  where tipo_mov='PAG'
  and id_pago = varPago
  and _estado = 'A'; 
END;
