CALL spMante_Pago_CxC(7,  '1', '00001', '2012-08-10', 20, 'CANCELACION MERCADERIA DEFECTUOSA', 1);

DROP PROCEDURE IF EXISTS spMante_Pago_CxC;
CREATE PROCEDURE spMante_Pago_CxC(
	varVenta      int,
  varFormaPago   int,
	varDocumento  varchar(20),
  varFecha      date,
  varMonto      double,	
  varObserva    text,
  varUsuario    int
  )
BEGIN
  DECLARE varNumPago bigint;
  DECLARE varEmp, varCli int;
  DECLARE varSal double default 0;
  DECLARE varError text default 'OK';
  
  select id_empresa, id_cliente, ifnull(saldo,0)
  into varEmp, varCli, varSal
  from _sv_venta
  where id_venta = varVenta;
  
  SELECT if(isnull(MAX(id_pago_cxc)),0,MAX(id_pago_cxc))+1 INTO varNumPago FROM _sv_pago_cxc; 
  
  IF varMonto = varSal THEN
    UPDATE _sv_venta SET estado = 'CA', saldo = saldo - varMonto, _user_update = varUsuario, _date_update=NOW() 
    where id_venta = varVenta;
  ELSEIF varMonto < varSal THEN
    UPDATE _sv_venta SET estado = 'PP', saldo = saldo - varMonto, _user_update = varUsuario, _date_update=NOW() 
    where id_venta = varVenta;
  ELSE
    set varError = "EL MONTO A PAGAR ES MAYOR AL SALDO";
  END IF;
  
  if varError = "OK" then
    /*REGISTRAMOS EL VOUCHER DE PAGO*/
    insert into _sv_pago_cxc(id_pago_cxc, id_empresa, id_cliente, id_venta, id_forma_pago, nro_doc_pago, fecha, monto, observacion, _date_create, _date_update, _user_create, _user_update)
    values(varNumPago, varEmp, varCli, varVenta, varFormaPago, varDocumento, varFecha, varMonto, varObserva, NOW(), NOW(), varUsuario, varUsuario);
    
    /*REGISTRAMOS EL MOVIMIENTO DE LA CUENTA*/
    insert into _sv_movimiento_cuenta_cxc(id_empresa, id_cliente, id_venta, id_pago_cxc, tipo_mov, fecha, monto, _date_create, _date_update, _user_create, _user_update)
    values (varEmp, varCli, varVenta, varNumPago, 'PAG', varFecha, varMonto, NOW(), NOW(), varUsuario, varUsuario);
  end if;
  select varError;
END;