call spMante_Nivel_Educativo('EDIT', '01', 'SIN EDUCACIN FORMAL', 'SIN EDUCACIN FORMAL', 1);

DROP PROCEDURE IF EXISTS spMante_Nivel_Educativo;
CREATE PROCEDURE spMante_Nivel_Educativo(
	varOpcion   varchar(10),
	varCodigo   varchar(3),
	varNombre   varchar(100),
  varAbrev    varchar(100),
  varUsuario  int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default '';
	
  if varOpcion='NEW' then
    select count(*) INTO varExiste  
    from _srh_nivel_educativo 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))  and _estado = 'A';
    
    if varExiste > 0 then
      set varError = CONCAT('EL NIVEL EDUCATIVO <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADO EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      SELECT LPAD(ifnull(max(id_nivel_educativo),0)+1,2,'0') INTO varCodigo FROM _srh_nivel_educativo;
      INSERT INTO _srh_nivel_educativo (id_nivel_educativo, nombre, abrev, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, UPPER(varNombre), UPPER(varAbrev), NOW(),NOW(), varUsuario, varUsuario);
      set varError = 'OK';
    end if;
	else
    select count(*) INTO varExiste  
    from _srh_nivel_educativo 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre)) and _estado = 'A' 
    and id_nivel_educativo <> varCodigo;
    if varExiste > 0 then
      set varError = CONCAT('EL NIVEL EDUCATIVO <<', UPPER(varNombre), '>> YA SE ENCUENTRA REGISTRADO EN EL SISTEMA\n');
    end if;
    
    if varError = '' then 
      update _srh_nivel_educativo set
      nombre       = UPPER(varNombre),
      abrev        = UPPER(varAbrev),
      _date_update = NOW(),
      _user_update = varUsuario
      where id_nivel_educativo = varCodigo;
      set varError = 'OK';
    end if;
	end if;
  select varError;
END;