call spMante_Hospedaje_CheckOut(2, 1, 1, '2012-09-12 19:13:00', 60.00, 60.00, 1);

DROP PROCEDURE IF EXISTS spMante_Hospedaje_CheckOut;
CREATE PROCEDURE spMante_Hospedaje_CheckOut(
	varCodigo     int,
	varCliente    int,
  varFormaPago  int,
  varFecha     datetime,
  varTotal      double,
  varSaldo      double,
  varUsuario    int
)
BEGIN  
  DECLARE varSub, varIgv  double default 0;
  DECLARE varExiste int default 0;
  DECLARE varError  varchar(2) default 'NO';
  
  set varSub = round(varTotal/1.18,2);
  set varIgv = round(varTotal - varSub,2);
  
  select count(*) into varExiste
  from _sh_hospedaje 
  where id_hospedaje=varCodigo and estado='AC'
  group by id_hospedaje, id_reservacion, fecha_ingreso;
  
  
  if varExiste > 0 then
    set varError = 'SI';
    /* Actualizamos estado del hospedaje */
    update _sh_hospedaje H
    set estado    = 'FI',
    id_cliente    = varCliente,
    fecha_salida  = varFecha,
    subtotal      = varSub,
    igv           = varIgv,
    total         = varTotal,
    saldo         = 0,
    _date_update  = NOW(),
    _user_update  = varUsuario
    where id_hospedaje = varCodigo
    and estado = 'AC';
    
    /* Insertamos pago a cuenta del saldo */
    insert into _sh_hospedaje_acuenta(id_hospedaje, id_forma_pago, fecha, monto, _date_create, _date_update, _user_create, _user_update) 
    values(varCodigo, varFormaPago, varFecha, varSaldo, NOW(), NOW(), varUsuario, varUsuario);
  end if;
  
  select varError;
END;