call spMante_Cuota_Venta_Familia('EDIT', '2013', '12',1, 41768484, 2, '01', '0105', '010510', 
				500, 250, 1);

DROP PROCEDURE IF EXISTS spMante_Cuota_Venta_Familia;
CREATE PROCEDURE spMante_Cuota_Venta_Familia(
  varOpcion     varchar(10),
  varAnio       varchar(4),
  varMes        varchar(2),
  varEmpresa    int,
  varVendedor   int,
  varProveedor  int,
  varTipo       varchar(2),
  varFamilia    varchar(4),
  varSubFamilia varchar(6),
  varMonto      double,
  varCantidad   double,
  varUsuario    int
)
BEGIN
  DECLARE varExiste int default 0;
  DECLARE varError  text default 'OK';
  DECLARE varDEmp, varDVen, varDPro, varDMes, varDTip, varDFam, varDSub varchar(80) default '';
  
  select nombre into varDEmp from _sv_empresa where id_empresa = varEmpresa;
  select nombre into varDPro from _sv_proveedor where id_proveedor = varProveedor;
  select CONCAT(apellido_paterno, ' ', apellido_materno, ' ', nombre) into varDVen from _sv_trabajador where id_trabajador = varVendedor;
  select nombre into varDTip from _sv_tipo where id_tipo = varTipo;
  select nombre into varDFam from _sv_familia where id_familia = varFamilia;
  select nombre into varDSub from _sv_sub_familia where id_sub_familia = varSubFamilia;
  select spFuncion_NombreMes(varMes) into varDMes;
  
  if varOpcion='NEW' then
    select count(*) INTO varExiste from _sv_cuota_venta_familia
    where id_anio       = varAnio
    and id_mes          = varMes
    and id_empresa      = varEmpresa
    and id_trabajador   = varVendedor
    and id_proveedor    = varProveedor
    and id_tipo         = varTipo
    and id_familia      = varFamilia
    and id_sub_familia  = varSubFamilia
    and _estado = 'A';
    
    if varExiste <= 0 then 
      INSERT INTO _sv_cuota_venta_familia (id_anio, id_mes, id_empresa, id_trabajador, id_proveedor, id_tipo, id_familia, id_sub_familia, 
                  monto, cantidad, _date_create, _date_update, _user_create, _user_update) 
      values (varAnio, varMes, varEmpresa, varVendedor, varProveedor, varTipo, varFamilia, varSubFamilia, varMonto, varCantidad,
              NOW(),NOW(), varUsuario, varUsuario);
    else
      set varError = CONCAT('LA CUOTA PARA\n',
                            'Anio \t\t: ', varAnio, '\n',
                            'Mes \t\t: ', varMes, ' - ', UPPER(varDMes), '\n',
                            'Empresa \t: ', varEmpresa, ' - ', UPPER(varDEmp), '\n',
                            'Vendedor \t: ', varVendedor, ' - ', UPPER(varDVen), '\n',
                            'Proveedor \t: ', varProveedor, ' - ', UPPER(varDPro), '\n',
                            'Tipo \t\t: ', varTipo, ' - ', UPPER(varDTip), '\n',
                            'Familia \t\t: ', varFamilia, ' - ', UPPER(varDFam), '\n',
                            'Sub Familia \t: ', varSubFamilia, ' - ', UPPER(varDSub), '\n',
                            'YA SE ENCUENTRA REGISTRADA EN EL SISTEMA'
                            );
    end if;
  else
    update _sv_cuota_venta_familia set
    monto     = varMonto,
    cantidad  = varCantidad,
    _date_update = NOW(),
    _user_update = varUsuario
    where id_anio       = varAnio
    and id_mes          = varMes
    and id_empresa      = varEmpresa
    and id_trabajador   = varVendedor
    and id_proveedor    = varProveedor
    and id_tipo         = varTipo
    and id_familia      = varFamilia
    and id_sub_familia  = varSubFamilia;
  end if;
  select varError;
END;
  