call spMante_Cliente('NEW', NULL, 'CLIENTE DE PRUEBA', 'M', 'S', '1982-12-28', '11111111', '22222222222', 'DIRECCION', 'REFERENCIA', 1, 
									 'GEN', NULL, '01', '140101', '123456', '654321', '979026496', '#0063327', '978728055', '329*1554', 10, 'RO_KEN777SC@HOTMAIL.COM', 1);

DROP PROCEDURE IF EXISTS spMante_Cliente;
CREATE PROCEDURE spMante_Cliente(
	varOpcion     varchar(10),
	varCodigo     varchar(15),	
	varNombre     varchar(80),
  varSexo       varchar(1),
  varCivil      varchar(1),
  varFNac       date,
	varDNI        varchar(8),
	varRUC        varchar(11),
	varDirecc     varchar(80),
  varReferencia text,
  varTipo       int,
  varSegmento   int,
  varRuta       varchar(10),
  varModulo     varchar(10),
  varPais       varchar(3),
  varUbigeo     varchar(10),
  varTelef1     varchar(15),
  varTelef2     varchar(15),
  varCelular    varchar(15),
  varRPM        varchar(15),
  varRPC        varchar(15),
  varNextel     varchar(15),
  varSecuencia  int,
  varEmail      varchar(100),
  varEstado     char(1),
	varUsuario    int
)
BEGIN  
  DECLARE varExiste int default 0;
  DECLARE varError  text default 'OK';
	if varOpcion='NEW' then
    -- Buscamos si el nombre del cliente ya se encuentra registrado
    select count(*) INTO varExiste from _sv_cliente 
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre)) and _estado = 'A';
    
    if varExiste <= 0 then 
      -- Generamos Siguiente Correlativo
      SELECT ifnull(max(id_cliente),0)+1 INTO varCodigo FROM _sv_cliente;    
      -- Insertamos Registro
      INSERT INTO _sv_cliente (id_cliente, nombre, sexo, estado_civil, fecha_nacimiento, dni, ruc, direccion, referencia,
              id_tipo_cliente, id_segmento, id_pais, id_ubigeo, id_ruta, id_modulo, telefono1, telefono2, celular, rpm, rpc, 
              nextel, secuencia, email, estado, _date_create, _date_update, _user_create, _user_update) 
      values (varCodigo, UPPER(varNombre), varSexo, varCivil, varFnac, varDNI, varRUC, UPPER(varDirecc), UPPER(varReferencia),
              varTipo, varSegmento, varPais, varUbigeo, varRuta, varModulo, varTelef1, varTelef2, varCelular, varRPM, varRPC, 
              varNextel, varSecuencia, varEmail, varEstado, NOW(),NOW(), varUsuario, varUsuario);
    else
      set varError = CONCAT('EL CLIENTE ', varNombre, ' YA SE ENCUENTRA REGISTRADO');
    end if;
    
	else
    -- Buscamos si el nombre del cliente ya se encuentra registrado
    select count(*) INTO varExiste  from _sv_cliente
    where TRIM(UPPER(nombre)) = TRIM(UPPER(varNombre))
    and _estado = 'A'  and id_cliente <> varCodigo;
    if varExiste <= 0 then 
      update _sv_cliente set		
      nombre          = UPPER(varNombre),
      sexo            = varSexo,
      estado_civil    = varCivil,
      fecha_nacimiento= varFNac,
      dni             = varDNI,		
      ruc             = varRUC,
      direccion       = UPPER(varDirecc),
      referencia      = UPPER(varReferencia),
      id_tipo_cliente = varTipo,
      id_segmento     = varSegmento,
      id_ruta         = varRuta,
      id_modulo       = varModulo,
      id_pais         = varPais,
      id_ubigeo       = varUbigeo,
      telefono1       = varTelef1,
      telefono2       = varTelef2,
      celular         = varCelular,
      rpm             = varRPM,
      rpc             = varRPC,
      nextel          = varNextel,
      secuencia       = varSecuencia,
      email           = varEmail,
      estado          = varEstado,
      _date_update    = NOW(),
      _user_update    = varUsuario
      where id_cliente = varCodigo;
    else
      set varError = CONCAT('EL CLIENTE ', varNombre, ' YA SE ENCUENTRA REGISTRADO');
    end if;		
	end if;
  select varCodigo, varError;
END;