select spFuncion_SueldoUnitario(125,8,13,12);

DROP FUNCTION IF EXISTS spFuncion_SueldoUnitario;
CREATE FUNCTION spFuncion_SueldoUnitario (
	varTrabajador int, 
	varEmpresa    int,
  varAgencia    int,
  varPeriodo    int
	) 
RETURNS double
BEGIN
  declare varSueldo double;
  SELECT ifnull(MONTO,0) - ifnull(DESCUENTO,0) INTO varSueldo
  FROM    
    (
    SELECT PP.id_trabajador AS CTRA,    
    ifnull(PP.bono, 0) + ifnull(PP.reintegro, 0) + 
    ifnull(PP.comisiones,0) +
    ifnull(PP.BASICO,0) + 
    ifnull(PP.asigfamiliar,0) -
    ifnull(ABS(PP.ADELANTO),0) -
    ifnull(ABS(PP.afp),0) -
    ifnull(ABS(PP.dscto_snp),0) -
    ifnull(ABS(PP.renta5ta),0) -
    ifnull(ABS(PP.saludvida),0) as MONTO
    FROM _bp_planilla_procesada PP                  
    WHERE PP.id_periodo = varPeriodo
    AND PP.id_empresa = varEmpresa
    AND PP.id_agencia = varAgencia
    and PP.id_trabajador = varTrabajador
    ) A
  LEFT JOIN
    (
    SELECT PD.id_trabajador AS CTRA, sum(PD.MONTO) as DESCUENTO
    FROM _bp_planilla_detalle PD
    WHERE id_periodo = varPeriodo         
    and PD.id_trabajador = varTrabajador
    AND PD._estado <> 'X'
    group by PD.id_trabajador
    ) B
  ON A.CTRA = B.CTRA;
  return varSueldo;
END;



