call spQuery_Vehiculo('', '', '',null, null);

DROP PROCEDURE IF EXISTS spQuery_Vehiculo;
CREATE PROCEDURE spQuery_Vehiculo(
	varCodigo   varchar(10),
	varNombre   varchar(80),
	varPlaca    varchar(20),
  varField    varchar(60),
  varOrder    varchar(5)
)
BEGIN
  DECLARE varCadCod, varCadNom, varCadPla TEXT DEFAULT '';
  DECLARE varCadOrd TEXT DEFAULT '';
  
	if varCodigo <> '' and varCodigo is not null then
    set varCadCod = CONCAT(" and V.id_vehiculo = ", varCodigo," ");
  end if;
	if varNombre <> '' and varNombre is not null then
    set varCadNom = CONCAT(" and V.descripcion like '%", varNombre,"%' ");
  end if;
  if varPlaca <> '' and varPlaca is not null then
    set varCadPla = CONCAT(" and V.placa LIKE '%", varPlaca,"%' ");
  end if;
  
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'M._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'M._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  END IF;
  SET @sql = CONCAT("select V.id_vehiculo as CVEH, V.descripcion as VEHICULO,  ",
                    "V.id_marca AS CMAR, M.nombre AS MARCA, ",
                    "V.PLACA, ANIO, TARJETA_PROPIEDAD, ",
                    "monto as COSTO, "
                    "PESO_MAX, LARGO, ANCHO, ALTO, ",
                    "CASE WHEN estado='A' then 'ACTIVO' else 'INACTIVO' END AS ESTADO, ",
                    "date_format(V._date_create,'%d/%m/%Y %h:%i:%s %p') AS FECHA_CREADO, ",
                    "date_format(V._date_update,'%d/%m/%Y %h:%i:%s %p') AS FECHA_MODIFI, ",
                    "UPPER(UN.usuario) as USER_CREADO, ",
                    "UPPER(UU.usuario) as USER_MODIFI ",
                    "from _sv_vehiculo V ",
                    "left join _sv_marca_vehiculo M ON V.id_marca = M.id_marca ",
                    "left join _sys_usuario UN ON V._user_create = UN.id_usuario ",
                    "left join _sys_usuario UU ON V._user_update = UU.id_usuario ",
                    "where V._estado = 'A' ",
                    varCadCod, varCadNom, varCadPla,
                    varCadOrd);
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;