call spQuery_Trabajador_Planilla_Detalle('1', '1', '1', NULL, NULL);
call spQuery_Trabajador_Planilla_Detalle(1, NULL, 1, 'TRABAJADOR', NULL);

DROP PROCEDURE IF EXISTS spQuery_Trabajador_Planilla_Detalle;
CREATE PROCEDURE spQuery_Trabajador_Planilla_Detalle(
	varEmpresa  int,
  varAgencia  int,
  varTipoPla  int,
	varField    varchar(60),
  varOrder    varchar(5)
)
BEGIN
  DECLARE varCadOrd TEXT DEFAULT '';
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'M._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'M._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  END IF;
  
  SET @sql = CONCAT("select lpad(cast(TE.id_trabajador as char),8,'0') as SEL, ",
                    "lpad(cast(TE.id_trabajador as char),8,'0') as CTRA,",
                    "CONCAT(T.apellido_paterno, ' ', T.apellido_materno, ' ', T.nombre) as TRABAJADOR, ",
                    "TE.id_empresa as CEMP, E.nombre as EMPRESA, ",
                    "TE.id_agencia as CAGE, AG.nombre as AGENCIA, ",
                    "TE.id_area as CARE, A.nombre as AREA, ",
                    "TE.id_cargo as CCAR, C.nombre as CARGO, ",
                    "TE.remuneracion_mensual as BRUTO ",
                    "from _srh_trabajador_empresa TE ",
                    "inner join _sv_trabajador T ON TE.id_trabajador = T.id_trabajador ",
                    "left join _srh_cargo C    ON TE.id_cargo = C.id_cargo ",
                    "left join _srh_area A     ON TE.id_area = A.id_area ",
                    "inner join _sv_empresa E   ON TE.id_empresa = E.id_empresa ",
                    "inner join _srh_agencia AG ON TE.id_agencia = AG.id_agencia ",
                    "where TE._estado = 'A' ",
                    "and TE.id_estado_trabajador = 1 ",
                    "and TE.id_empresa = ", varEmpresa, " ",
                    "and TE.id_agencia = ", varAgencia, " ",
                    "and TE.id_tipo_planilla = ", varTipoPla , " ",
                    varCadOrd);
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;