call spQuery_Tipo_Descuento(NULL, '',null, null);

DROP PROCEDURE IF EXISTS spQuery_Tipo_Descuento;
CREATE PROCEDURE spQuery_Tipo_Descuento(
	varCodigo   varchar(10),
	varNombre   varchar(80),
  varField    varchar(60),
  varOrder    varchar(5)
)
BEGIN
  DECLARE varCadCod, varCadNom TEXT DEFAULT '';
  DECLARE varCadOrd TEXT DEFAULT '';
  
	if varCodigo <> '' and varCodigo is not null then
    set varCadCod = CONCAT(" and V.id_tipo_descuento = ", varCodigo," ");
  end if;
	if varNombre <> '' and varNombre is not null then
    set varCadNom = CONCAT(" and V.nombre like '%", varNombre,"%' ");
  end if;
  
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'V._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'V._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  END IF;
  SET @sql = CONCAT("select V.id_tipo_descuento as CDES, V.nombre as DESCUENTO, V.ABREV, ",
                    "CASE WHEN V.TIPO='V' THEN 'PARA VENDEDOR' ",
                    "     WHEN V.TIPO='O' THEN 'PARA OFICINA' ",
                    "     WHEN V.TIPO='L' THEN 'PARA LIQUIDADOR' ",
                    "END AS TIPO, ",
                    "CASE WHEN estado='A' then 'ACTIVO' else 'INACTIVO' END AS ESTADO, ",
                    "date_format(V._date_create,'%d/%m/%Y %h:%i:%s %p') AS FECHA_CREADO, ",
                    "date_format(V._date_update,'%d/%m/%Y %h:%i:%s %p') AS FECHA_MODIFI, ",
                    "UPPER(UN.usuario) as USER_CREADO, ",
                    "UPPER(UU.usuario) as USER_MODIFI ",
                    "from _sv_tipo_descuento V ",                    
                    "inner join _sys_usuario UN ON V._user_create = UN.id_usuario ",
                    "inner join _sys_usuario UU ON V._user_update = UU.id_usuario ",
                    "where V._estado = 'A' ",
                    varCadCod, varCadNom,
                    varCadOrd);
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;