call spQuery_Tarifario(1, 1, NULL, NULL);

DROP PROCEDURE IF EXISTS spQuery_Tarifario;
CREATE PROCEDURE spQuery_Tarifario(
  varEmpresa  int,
  varSegmento int,
  varField    varchar(60),
  varOrder    varchar(5)
  )
BEGIN 
  DECLARE varCadSeg TEXT DEFAULT '';
  DECLARE varCadOrd TEXT DEFAULT '';
  
  if varSegmento is not null then
    set varCadSeg = CONCAT(" and T.id_segmento = ", varSegmento, " ");
  end if;
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'M._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'M._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  END IF;
  
  SET @sql = CONCAT("select T.id_empresa as CEMP, E.nombre as EMPRESA, ",
                    "T.id_segmento as CSEG, S.nombre as SEGMENTO, ",
                    "T.id_habitacion as CHAB, H.NUMERO, ",
                    "H.id_tipo_habitacion AS CTIP, TH.nombre as TIPO, ",
                    "T.PRECIO_24, T.PRECIO_12, T.PRECIO_06, T.PRECIO_03, T.PRECIO_02, T.PRECIO_01 ",
                    "from _sh_tarifario T ",
                    "inner join _sv_empresa E ON T.id_empresa = E.id_empresa ",
                    "inner join _sh_segmento S ON T.id_segmento = S.id_segmento ",
                    "inner join _sh_habitacion H ON T.id_habitacion = H.id_habitacion ",
                    "inner join _sh_tipo_habitacion TH ON H.id_tipo_habitacion = TH.id_tipo_habitacion ",
                    "where T._estado = 'A' ",
                    "and T.id_empresa = ", varEmpresa, " ",
                    varCadSeg,
                    varCadOrd);
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;