call spQuery_Sueldo_General(1, '2012','10','2012-10-01','2012-10-31');

DROP PROCEDURE IF EXISTS spQuery_Sueldo_General;
CREATE PROCEDURE spQuery_Sueldo_General(
  varEmpresa    int,
	varAnio       varchar(4),
  varMes        varchar(4),  
  varFechaIni   date,
	varFechaFin   date  
  )
BEGIN
  DECLARE varCodLP int;
  DECLARE varNomLP, varCadLP1, varCadLP2, varCadLP3 text default '';
  
  DECLARE done INT DEFAULT 0;
  DECLARE curLP CURSOR FOR
      SELECT distinct id_lista, nombre
      FROM _sv_lista
      where id_empresa = varEmpresa
      and _estado='A'
      order by id_lista;
  DECLARE CONTINUE HANDLER FOR SQLSTATE '02000' SET done = 1;
  
  OPEN curLP;
      REPEAT
        FETCH curLP INTO  varCodLP, varNomLP;
        IF NOT done THEN  
          set varCadLP1 = CONCAT(varCadLP1, " sum(CASE WHEN C.id_lista = ",varCodLP," THEN D.subtotal END) as ", substring(varNomLP,1,5),", ");
          set varCadLP2 = CONCAT(varCadLP2, "SUM(", substring(varNomLP,1,5),") AS ", substring(varNomLP,1,5),", ");
          set varCadLP3 = CONCAT(varCadLP3, substring(varNomLP,1,5),", ");
        END IF;
      UNTIL done END REPEAT;
    CLOSE curLP;
    
  set @sql = CONCAT("select V.CVEN, V.VENDEDOR, V.BASICO AS BASE, ",
                    varCadLP3,
                    "V.VENTA, V.COMISION, M.CUOTA, ",
                    "ROUND(VENTA/CUOTA*100,2) AS LOGRO, ",
                    "IFNULL(ROUND((ifnull(VENTA,0)/IFNULL(CUOTA,0))*IFNULL(BASICO,0),2),0) as BASICO, ",
                    "ROUND(IFNULL(V.COMISION,0),2) + ifnull(ROUND((ifnull(VENTA,0)/IFNULL(CUOTA,0))*IFNULL(BASICO,0),2),0) AS SUELDO ",
                    "from ",
                    "  ( ",
                    "  select CVEN, VENDEDOR, BASICO, ROUND(SUM(VENTA),2) AS VENTA, ",
                       varCadLP2,
                    "  SUM(VENTA*PESO/100) AS COMISION ",
                    "  from ",
                    "    ( ",
                    "    select V.id_trabajador as CVEN, CONCAT(V.apellido_paterno, ' ', V.apellido_materno, ' ',V.nombre) as VENDEDOR, ",
                    "    A.id_proveedor as CPRO, C.id_lista as CTIP, ",
                    "    V.sueldo_base_mensual as BASICO, ",
                         varCadLP1,    
                    "    sum(D.subtotal) as VENTA ",
                    "    from _sv_venta_detalle D ",
                    "    inner join _sv_venta C    ON D.id_venta    = C.id_venta ",
                    "    inner join _sv_producto A ON D.id_producto = A.id_producto ",      
                    "    inner join _sv_trabajador V ON C.id_trabajador = V.id_trabajador ",
                    "    where C._estado = 'A' ",
                    "    and D._estado = 'A' ",
                    "    and C.estado <> 'AN' ",
                    "    and C.id_empresa = ", varEmpresa," ",
                    "    and C.fecha_emision >= '", varFechaIni, "' ",
                    "    and C.fecha_emision <= '", varFechaFin, "' ",
                    "    GROUP BY V.id_trabajador, CONCAT(V.apellido_paterno, ' ', V.apellido_materno, ' ',V.nombre), A.id_proveedor, C.id_lista, V.sueldo_base_mensual ",
                    "    ) A ",
                    "  left join ",
                    "    ( ",
                    "    select C.id_proveedor as CPRO, C.id_lista as CTIP, ",
                    "    sum(C.peso) as PESO ",
                    "    from _sv_proveedor_comision C ",
                    "    where C._estado   = 'A' ",
                    "    and C.id_anio     = '", varAnio, "' ",
                    "    and C.id_mes      = '", varMes, "' ",  
                    "    and C.id_empresa  = ", varEmpresa," ",
                    "    group by C.id_proveedor, C.id_lista ",
                    "    ) B ",
                    "  on A.CPRO = B.CPRO AND A.CTIP = B.CTIP ",
                    "  GROUP BY CVEN, VENDEDOR, BASICO ",
                    "  ) V ",
                    "left join ",
                    "  ( ",
                    "  select M.id_trabajador as CVEN, sum(M.monto) as CUOTA  ",
                    "  from _sv_cuota_venta_vendedor M ",
                    "  where M.id_anio   = '", varAnio, "' ",
                    "  and M.id_mes      = '", varMes, "' ",
                    "  and M.id_empresa  = ", varEmpresa," ",
                    "  and M._estado     = 'A' ",
                    "  group by M.id_trabajador ",
                    "  ) M ",
                    "ON V.CVEN = M.CVEN;");
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;