call spQuery_StockMinimo();

DROP PROCEDURE IF EXISTS spQuery_StockMinimo;
CREATE PROCEDURE spQuery_StockMinimo()
BEGIN 
  select P.id_producto as CPRO, P.descripcion as PRODUCTO,
  P.id_um_venta as UM_VENTA, P.id_um_stock as UM_STOCK,
  ifnull(P.STOCK_MINIMO,10) as STOCK_MINIMO,
  K.cantidad AS STOCK_REAL
  from _sv_producto P
  left join _sv_kardex K     ON K.id_producto = P.id_producto
  where P._estado = 'A'
  and K.id_almacen = 1
  and K.id_local = 1
  and ifnull(P.STOCK_MINIMO,10) > K.cantidad;
END;