call spQuery_Sistema_Usuario('','','',1,'NOMBRE',NULL);

DROP PROCEDURE IF EXISTS spQuery_Sistema_Usuario;
CREATE PROCEDURE spQuery_Sistema_Usuario(
  varCodigo   int,
	varUsuario  varchar(20),
  varNombre   varchar(80),
  varUser     int,
  varField    varchar(60),
  varOrder    varchar(5)
)
BEGIN
  DECLARE varCadOrd TEXT DEFAULT '';
  DECLARE varCadCod, varCadUse, varCadNom, varCadFlag TEXT default '';
  
  IF varCodigo is not null and varCodigo <> '' THEN
    SET varCadCod = CONCAT(" and U.id_usuario = ", varCodigo, " ");
  END IF;
  IF varUsuario is not null and varUsuario <> '' THEN
    SET varCadUse = CONCAT(" and U.usuario = '", varUsuario, "' ");
  END IF;
  IF varNombre is not null and varNombre <> '' THEN
    SET varCadNom = CONCAT(" and U.nombre LIKE '%", varNombre, "%' ");
  END IF;
  IF varUser <> 1 THEN
    SET varCadFlag = CONCAT(" and U.id_usuario <> 1 ");
  END IF;
  
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'M._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'M._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  END IF;
  
  SET @sql = CONCAT("select U.id_usuario AS CUSU, U.NOMBRE, UPPER(U.usuario) as USUARIO, ",                    
                    "U.id_trabajador as CTRA, CONCAT(V.apellido_paterno, ' ' , V.apellido_materno, ' ', V.nombre) as TRABAJADOR, ",
                    "date_format(U._date_create,'%d/%m/%Y %h:%i:%s %p') AS FECHA_CREADO, ",
                    "date_format(U._date_update,'%d/%m/%Y %h:%i:%s %p') AS FECHA_MODIFI, ",
                    "UPPER(UN.usuario) as USER_CREADO, ",
                    "UPPER(UU.usuario) as USER_MODIFI ",
                    "from _sys_usuario U ",                    
                    "left join _sv_trabajador V ON U.id_trabajador = V.id_trabajador ",
                    "inner join _sys_usuario UN ON U._user_create = UN.id_usuario ",
                    "inner join _sys_usuario UU ON U._user_update = UU.id_usuario ",
                    "where U._estado='A' ",
                    varCadCod, varCadUse, varCadNom, varCadFlag,
                    varCadOrd);
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;                  
end;