call spQuery_Sistema_Roles(3, NULL, '', 2, NULL, NULL)

DROP PROCEDURE IF EXISTS spQuery_Sistema_Roles;
CREATE PROCEDURE spQuery_Sistema_Roles(	
  varSistema  int,
  varCodigo   int,
	varNombre   varchar(80),
  varUsuario  int,
  varField    varchar(60),
  varOrder    varchar(5)
)
BEGIN
  DECLARE varCadCod, varCadNom, varCadUsr  text default '';
  DECLARE varCadOrd TEXT DEFAULT '';
  
  if varCodigo is not null or varCodigo <> '' then
    set varCadCod = CONCAT(" and M.id_rol = ", varCodigo, " ");
  end if;
  if varNombre is not null or varNombre <> '' then
    set varCadNom = CONCAT(" and M.nombre LIKE '%", varNombre, "%' ");
  end if;
  if varUsuario <> 1 then
    set varCadUsr = CONCAT(" and M.id_rol <> 1 ");
  end if;
  
  -- Para Ordenar
  IF varField is not null and varField <> '' THEN
    SET varField = CASE WHEN varField = 'FECHA_CREADO' THEN 'M._date_create'
                        WHEN varField = 'FECHA_MODIFI' THEN 'M._date_update'
                        ELSE varField
                   END;
    SET varCadOrd = CONCAT("ORDER BY ", varField, " ");
    IF varOrder is not null and varOrder <> '' THEN
      SET varCadOrd = CONCAT(varCadOrd, varOrder, " ");      
    END IF;
  END IF;
  
	set @sql = CONCAT("select M.id_sistema as CSIS, M.id_rol AS CROL, M.nombre AS DESCRIPCION, ",
                    "(select count(id_menu) as total from _sys_rol_menu where id_sistema = M.id_sistema and id_rol = M.id_rol) as CANT, ",
                    "date_format(M._date_create,'%d/%m/%Y %h:%i:%s %p') AS FECHA_CREADO, ",
                    "date_format(M._date_update,'%d/%m/%Y %h:%i:%s %p') AS FECHA_MODIFI, ",
                    "UPPER(UN.usuario) as USER_CREADO, ",
                    "UPPER(UU.usuario) as USER_MODIFI ",
                    "from _sys_rol M ",
                    "inner join _sys_usuario UN ON M._user_create = UN.id_usuario ",
                    "inner join _sys_usuario UU ON M._user_update = UU.id_usuario ",
                    "where M._estado='A' and M.id_rol <> 0 ",
                    "and M.id_sistema = ", varSistema, " ",
	                  varCadCod, varCadNom, varCadUsr,
                    varCadOrd);		
  PREPARE s1 FROM @sql;
  EXECUTE s1;
  DEALLOCATE PREPARE s1;
END;